/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.util.UtilKt;
import org.jitsi.videobridge.cc.vp9.PacketInsertionResult;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0003J\u000e\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0000R%\u0010\b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\n\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0011\u0010$\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001c\u00a8\u00060"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "index", "", "<init>", "(Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;J)V", "frames", "Ljava/util/ArrayList;", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "Lkotlin/collections/ArrayList;", "getFrames", "()Ljava/util/ArrayList;", "frame", "sid", "", "setFrameAtSid", "", "firstFrame", "lastFrame", "ssrc", "getSsrc", "()J", "timestamp", "getTimestamp", "temporalLayer", "getTemporalLayer", "()I", "earliestKnownSequenceNumber", "getEarliestKnownSequenceNumber", "latestKnownSequenceNumber", "getLatestKnownSequenceNumber", "pictureId", "getPictureId", "getIndex", "tl0PICIDX", "getTl0PICIDX", "addPacket", "Lorg/jitsi/videobridge/cc/vp9/PacketInsertionResult;", "matchesSSRC", "", "pkt", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "matchesPicture", "validateConsistency", "isImmediatelyAfter", "otherPicture", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVp9Picture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp9Picture.kt\norg/jitsi/videobridge/cc/vp9/Vp9Picture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class Vp9Picture {
    @NotNull
    private final ArrayList<Vp9Frame> frames;

    public Vp9Picture(@NotNull Vp9Packet packet, long index) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.frames = new ArrayList();
        int sid = packet.getEffectiveSpatialLayerIndex();
        this.setFrameAtSid(new Vp9Frame(packet, index), sid);
    }

    @NotNull
    public final ArrayList<Vp9Frame> getFrames() {
        return this.frames;
    }

    @Nullable
    public final Vp9Frame frame(int sid) {
        return (Vp9Frame)CollectionsKt.getOrNull((List)this.frames, (int)sid);
    }

    @Nullable
    public final Vp9Frame frame(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        return this.frame(packet.getEffectiveSpatialLayerIndex());
    }

    private final void setFrameAtSid(Vp9Frame frame, int sid) {
        UtilKt.setAndExtend((List)this.frames, (int)sid, (Object)frame, null);
    }

    private final Vp9Frame firstFrame() {
        Object v0;
        block2: {
            Iterable iterable = this.frames;
            for (Object t : iterable) {
                Vp9Frame f = (Vp9Frame)t;
                boolean bl = false;
                if (!(f != null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Vp9Frame f = v0;
        if (!(f != null)) {
            boolean bl = false;
            String string = "Picture must have at least one frame";
            throw new IllegalStateException(string.toString());
        }
        return f;
    }

    private final Vp9Frame lastFrame() {
        Object v0;
        block2: {
            List list = this.frames;
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                Vp9Frame f = (Vp9Frame)e;
                boolean bl = false;
                if (!(f != null)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        Vp9Frame f = v0;
        if (!(f != null)) {
            boolean bl = false;
            String string = "Picture must have at least one frame";
            throw new IllegalStateException(string.toString());
        }
        return f;
    }

    public final long getSsrc() {
        return this.firstFrame().getSsrc();
    }

    public final long getTimestamp() {
        return this.firstFrame().getTimestamp();
    }

    public final int getTemporalLayer() {
        return this.firstFrame().getTemporalLayer();
    }

    public final int getEarliestKnownSequenceNumber() {
        return this.firstFrame().getEarliestKnownSequenceNumber();
    }

    public final int getLatestKnownSequenceNumber() {
        return this.lastFrame().getLatestKnownSequenceNumber();
    }

    public final int getPictureId() {
        return this.firstFrame().getPictureId();
    }

    public final long getIndex() {
        return this.firstFrame().getIndex();
    }

    public final int getTl0PICIDX() {
        return this.firstFrame().getTl0PICIDX();
    }

    @NotNull
    public final PacketInsertionResult addPacket(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!this.matchesPicture(packet)) {
            boolean $i$a$-require-Vp9Picture$addPacket$22 = false;
            String $i$a$-require-Vp9Picture$addPacket$22 = "Non-matching packet added to picture";
            throw new IllegalArgumentException($i$a$-require-Vp9Picture$addPacket$22.toString());
        }
        int sid = packet.getEffectiveSpatialLayerIndex();
        Vp9Frame f = this.frame(packet);
        if (f != null) {
            f.addPacket(packet);
            return new PacketInsertionResult(f, this, false, false, 8, null);
        }
        Vp9Frame newF = new Vp9Frame(packet, this.getIndex());
        this.setFrameAtSid(newF, sid);
        return new PacketInsertionResult(newF, this, true, false, 8, null);
    }

    private final boolean matchesSSRC(VideoRtpPacket pkt) {
        return this.getSsrc() == pkt.getSsrc();
    }

    public final boolean matchesPicture(@NotNull Vp9Packet pkt) {
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        return this.matchesSSRC((VideoRtpPacket)pkt) && this.getTimestamp() == pkt.getTimestamp();
    }

    public final void validateConsistency(@NotNull Vp9Packet pkt) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        Vp9Frame f = this.frame(pkt);
        if (f != null) {
            f.validateConsistency(pkt);
            return;
        }
        if (this.getTemporalLayer() == pkt.getTemporalLayerIndex() && this.getTl0PICIDX() == pkt.getTL0PICIDX() && this.getPictureId() == pkt.getPictureId()) {
            return;
        }
        StringBuilder $this$validateConsistency_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Vp9Packet $this$validateConsistency_u24lambda_u240_u240 = pkt;
        boolean bl2 = false;
        $this$validateConsistency_u24lambda_u240.append("Packet ssrc " + $this$validateConsistency_u24lambda_u240_u240.getSsrc() + ", seq " + $this$validateConsistency_u24lambda_u240_u240.getSequenceNumber() + ", picture id " + $this$validateConsistency_u24lambda_u240_u240.getPictureId() + ", timestamp " + $this$validateConsistency_u24lambda_u240_u240.getTimestamp() + " ");
        $this$validateConsistency_u24lambda_u240.append("is not consistent with picture " + this.getSsrc() + ", ");
        $this$validateConsistency_u24lambda_u240.append("seq " + this.getEarliestKnownSequenceNumber() + "-" + this.getLatestKnownSequenceNumber() + " ");
        $this$validateConsistency_u24lambda_u240.append("picture id " + this.getPictureId() + ", timestamp " + this.getTimestamp() + ": ");
        boolean complained = false;
        if (this.getTemporalLayer() != pkt.getTemporalLayerIndex()) {
            $this$validateConsistency_u24lambda_u240.append("packet temporal layer " + pkt.getTemporalLayerIndex() + " != frame temporal layer " + this.getTemporalLayer());
            complained = true;
        }
        if (this.getTl0PICIDX() != pkt.getTL0PICIDX()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u240.append("; ");
            }
            $this$validateConsistency_u24lambda_u240.append("packet TL0PICIDX " + pkt.getTL0PICIDX() + " != frame TL0PICIDX " + this.getTl0PICIDX());
            complained = true;
        }
        if (this.getPictureId() != pkt.getPictureId()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u240.append("; ");
            }
            $this$validateConsistency_u24lambda_u240.append("packet PictureID " + pkt.getPictureId() + " != frame PictureID " + this.getPictureId());
        }
        String string = stringBuilder.toString();
        throw new RuntimeException(string);
    }

    public final boolean isImmediatelyAfter(@NotNull Vp9Picture otherPicture) {
        Intrinsics.checkNotNullParameter((Object)otherPicture, (String)"otherPicture");
        return this.getPictureId() == VpxUtils.Companion.applyExtendedPictureIdDelta(otherPicture.getPictureId(), 1);
    }
}

