/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.Jid;

public abstract class AbstractFromToMatchesFilter
implements StanzaFilter {
    private final Jid address;
    private final boolean ignoreResourcepart;

    protected AbstractFromToMatchesFilter(Jid address, boolean ignoreResourcepart) {
        this.address = address != null && ignoreResourcepart ? address.asBareJid() : address;
        this.ignoreResourcepart = ignoreResourcepart;
    }

    @Override
    public final boolean accept(Stanza stanza) {
        Jid stanzaAddress = this.getAddressToCompare(stanza);
        if (stanzaAddress == null) {
            return this.address == null;
        }
        if (this.ignoreResourcepart) {
            stanzaAddress = stanzaAddress.asBareJid();
        }
        return stanzaAddress.equals((CharSequence)this.address);
    }

    protected abstract Jid getAddressToCompare(Stanza var1);

    public final String toString() {
        String matchMode = this.ignoreResourcepart ? "ignoreResourcepart" : "full";
        return this.getClass().getSimpleName() + " (" + matchMode + "): " + this.address;
    }
}

