/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class EntryIterator
implements Iterator<Iso9660FileEntry> {
    private final Iso9660FileSystem fileSystem;
    private final List<Iso9660FileEntry> queue;

    public EntryIterator(Iso9660FileSystem iso9660FileSystem, Iso9660FileEntry iso9660FileEntry) {
        this.fileSystem = iso9660FileSystem;
        this.queue = new LinkedList<Iso9660FileEntry>();
        if (iso9660FileEntry != null) {
            this.queue.add(iso9660FileEntry);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public Iso9660FileEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iso9660FileEntry iso9660FileEntry = this.queue.remove(0);
        if (iso9660FileEntry.isDirectory()) {
            byte[] byArray;
            try {
                byArray = this.fileSystem.getBytes(iso9660FileEntry);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            int n = 0;
            boolean bl = false;
            while (n < byArray.length) {
                if (LittleEndian.getUInt8((byte[])byArray, (int)n) <= 0) {
                    bl = true;
                    n += 2;
                    continue;
                }
                Boolean bl2 = this.fileSystem.suspUsed();
                Iso9660FileEntry iso9660FileEntry2 = new Iso9660FileEntry(this.fileSystem, iso9660FileEntry.getPath(), byArray, n + 1, bl2);
                if (bl && iso9660FileEntry2.getSize() < 0L) {
                    n += 2;
                    continue;
                }
                n += iso9660FileEntry2.getEntryLength();
                if (".".equals(iso9660FileEntry2.getName()) || "..".equals(iso9660FileEntry2.getName()) || "Desktop DB".equalsIgnoreCase(iso9660FileEntry2.getName()) || "Desktop DF".equalsIgnoreCase(iso9660FileEntry2.getName())) continue;
                this.queue.add(iso9660FileEntry2);
            }
        }
        return iso9660FileEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

