/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.anidb.AniDbMetadataParser;
import org.tinymediamanager.scraper.anidb.AniDbMetadataProvider;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.Similarity;

public class AniDbMovieMetadataProvider
extends AniDbMetadataProvider
implements IMovieMetadataProvider {
    public static final String ID = "anidb";
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDbMovieMetadataProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, "movie", "aniDB", "<html><h3>aniDB</h3><br />AniDB stands for Anime DataBase. AniDB is a non-profit anime database that is open freely to the public.</html>", AniDbMovieMetadataProvider.class.getResource("/org/tinymediamanager/scraper/anidb_net.png"), -10);
        info.getConfig().addInteger("numberOfTags", 20);
        info.getConfig().addInteger("minimumTagsWeight", 200);
        info.getConfig().load();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        Class<AniDbMovieMetadataProvider> clazz = AniDbMovieMetadataProvider.class;
        synchronized (AniDbMovieMetadataProvider.class) {
            if (this.showsForLookup.isEmpty()) {
                this.buildTitleHashMap();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String searchString = "";
            if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if (StringUtils.isEmpty((CharSequence)searchString)) {
                return new TreeSet<MediaSearchResult>();
            }
            String finalSearchString = searchString;
            return this.showsForLookup.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(movie -> new MediaSearchResult.Builder(MediaType.MOVIE).providerId(this.providerInfo.getId()).id(String.valueOf(movie.aniDbId)).title(movie.title).score(Similarity.compareStrings(movie.title, finalSearchString)).build()).filter(msr -> msr.getScore() >= 0.75f).collect(Collectors.toCollection(TreeSet::new));
        }
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        Document doc = this.requestAnimeDocument(options);
        if (doc == null || doc.children().isEmpty()) {
            return null;
        }
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        String language = options.getLanguage().getLanguage();
        String id = options.getIdAsString(this.providerInfo.getId());
        md.setId(this.providerInfo.getId(), id);
        AniDbMetadataParser.fillAnimeMetadata(md, language, doc.child(0), this.providerInfo);
        md.addGenre(MediaGenres.ANIME);
        return md;
    }
}

