/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public class MediaScraperComboBox
extends JComboBox<MediaScraper> {
    private Map<URI, ImageIcon> imageCache;
    private int listWidth = 0;

    public MediaScraperComboBox() {
        this.initialize();
    }

    public MediaScraperComboBox(MediaScraper[] scrapers) {
        super(scrapers);
        this.initialize();
    }

    public MediaScraperComboBox(Vector<MediaScraper> scrapers) {
        super(scrapers);
        this.initialize();
    }

    public MediaScraperComboBox(List<MediaScraper> scrapers) {
        super(new Vector<MediaScraper>(scrapers));
        this.initialize();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.imageCache != null) {
            this.imageCache.clear();
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        dim.width = Math.max(dim.width, this.getPreferredPopupSize().width);
        return dim;
    }

    private Dimension getPreferredPopupSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.listWidth > 0) {
            dimension.width = this.listWidth;
        }
        return dimension;
    }

    private void initialize() {
        this.setRenderer(new MediaScraperComboBoxRenderer());
        this.updateUI();
    }

    private ImageIcon getIcon(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URI uri = url.toURI();
            Object logo = this.imageCache.get(uri);
            if (logo == null) {
                if (url.getFile().endsWith("svg")) {
                    TmmSvgIcon svgIcon = new TmmSvgIcon(uri);
                    svgIcon.setPreferredHeight(this.calculatePreferredHeight());
                    logo = svgIcon;
                } else {
                    logo = ImageUtils.createMultiResolutionImage(IconManager.loadImageFromURL(url), this.calculatePreferredHeight());
                }
                this.imageCache.put(uri, (ImageIcon)logo);
            }
            return logo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int calculatePreferredHeight() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return (int)((float)fm.getHeight() * 2.0f);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item instanceof MediaScraper) {
            MediaScraper mediaScraper = (MediaScraper)item;
            if (!mediaScraper.getMediaProvider().isActive()) {
                return;
            }
            super.setSelectedItem(item);
        }
    }

    class MediaScraperComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<MediaScraper> {
        protected final ListCellRenderer defaultRenderer;

        public MediaScraperComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            MediaScraperComboBox.this.imageCache = new HashMap<URI, ImageIcon>();
            JComboBox box = new JComboBox();
            this.defaultRenderer = box.getRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends MediaScraper> list, MediaScraper scraper, int index, boolean isSelected, boolean cellHasFocus) {
            if (index > -1) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                int maxWidth = 0;
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    MediaScraper ms = list.getModel().getElementAt(i);
                    ImageIcon logo = MediaScraperComboBox.this.getIcon(ms.getLogoURL());
                    maxWidth = Math.max(maxWidth, logo == null ? 0 : logo.getIconWidth());
                }
                int currentWidth = 0;
                ImageIcon logo = MediaScraperComboBox.this.getIcon(scraper.getLogoURL());
                if (logo != null) {
                    currentWidth = logo.getIconWidth();
                }
                this.setIcon(logo);
                this.setText(scraper.getMediaProvider().getProviderInfo().getName());
                this.setFont(list.getFont());
                this.setIconTextGap(maxWidth + 4 - currentWidth);
                if (!scraper.isActive()) {
                    this.setFocusable(false);
                    this.setEnabled(false);
                    if (!scraper.isEnabled()) {
                        this.setText("*PRO* " + this.getText());
                    }
                } else {
                    this.setFocusable(true);
                    this.setEnabled(true);
                }
                Dimension preferredSize = this.getPreferredSize();
                if (MediaScraperComboBox.this.listWidth < preferredSize.width) {
                    MediaScraperComboBox.this.listWidth = preferredSize.width;
                }
                return this;
            }
            MediaScraper ms = (MediaScraper)MediaScraperComboBox.this.getSelectedItem();
            if (ms != null) {
                return this.defaultRenderer.getListCellRendererComponent(list, ms.getName(), index, isSelected, cellHasFocus);
            }
            return this.defaultRenderer.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
        }
    }
}

