/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.bus.Event;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;

public class MovieSetSelectionModel
extends AbstractModelObject {
    public static final String SELECTED_MOVIE_SET = "selectedMovieSet";
    private final MovieSet initalMovieSet;
    private MovieSet selectedMovieSet;
    private TmmTreeTable treeTable;

    public MovieSetSelectionModel() {
        this.selectedMovieSet = this.initalMovieSet = new MovieSet("");
        EventBus.registerListener(EventBus.TOPIC_MOVIE_SETS, event -> {
            MovieSet movieSet;
            Object patt1797$temp = event.sender();
            if (patt1797$temp instanceof MovieSet && (movieSet = (MovieSet)patt1797$temp) == this.selectedMovieSet) {
                if (event.eventType().equals(Event.TYPE_REMOVE)) {
                    this.setSelectedMovieSet(this.initalMovieSet);
                } else {
                    this.firePropertyChange(SELECTED_MOVIE_SET, null, movieSet);
                }
            }
        });
    }

    public void setTreeTable(TmmTreeTable treeTable) {
        this.treeTable = treeTable;
    }

    public void setSelectedMovieSet(MovieSet movieSet) {
        MovieSet oldValue = this.selectedMovieSet;
        this.selectedMovieSet = Objects.requireNonNullElse(movieSet, this.initalMovieSet);
        this.firePropertyChange(SELECTED_MOVIE_SET, oldValue, this.selectedMovieSet);
    }

    public MovieSet getSelectedMovieSet() {
        return this.selectedMovieSet;
    }

    public List<MovieSet> getSelectedMovieSets() {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>();
        for (Object obj : this.getSelectedObjects()) {
            if (!(obj instanceof MovieSet)) continue;
            selectedMovieSets.add((MovieSet)obj);
        }
        return selectedMovieSets;
    }

    public List<Movie> getSelectedMovies() {
        return this.getSelectedMovies(false);
    }

    public List<Movie> getSelectedMovies(boolean withLocked) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>();
        for (Object obj : this.getSelectedObjects()) {
            if (!(obj instanceof Movie)) continue;
            Movie movie = (Movie)obj;
            if (withLocked) {
                selectedMovies.add(movie);
                continue;
            }
            if (movie.isLocked()) continue;
            selectedMovies.add(movie);
        }
        return selectedMovies;
    }

    public List<Movie> getSelectedMoviesRecursive() {
        LinkedHashSet<Movie> selectedMovies = new LinkedHashSet<Movie>();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof MovieSet) {
                selectedMovies.addAll(((MovieSet)obj).getMovies());
                continue;
            }
            if (obj instanceof MovieSet.MovieSetMovie || !(obj instanceof Movie)) continue;
            selectedMovies.add((Movie)obj);
        }
        return new ArrayList<Movie>(selectedMovies);
    }

    public List<Object> getSelectedObjects() {
        int[] rows;
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int row : rows = this.treeTable.getSelectedRows()) {
            DefaultMutableTreeNode node = this.treeTable.getTreeNode(row);
            if (node == null) continue;
            Object userObject = node.getUserObject();
            if (userObject instanceof MovieSet) {
                selectedObjects.add(userObject);
                continue;
            }
            if (!(userObject instanceof Movie)) continue;
            selectedObjects.add(userObject);
        }
        return selectedObjects;
    }
}

