/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTextTvShowUIFilter;

public class TvShowStudioFilter
extends AbstractTextTvShowUIFilter {
    @Override
    public String getId() {
        return "tvShowStudio";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            boolean foundShow = false;
            Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(tvShow.getProductionCompany()));
            if (matcher.find()) {
                foundShow = true;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = false;
                matcher = this.filterPattern.matcher(StrgUtils.normalizeString(episode.getProductionCompany()));
                if (matcher.find()) {
                    foundEpisode = true;
                }
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("tvshowextendedsearch.studio"));
    }
}

