/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.mjpeg;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ObjectDescriptorFactory;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.tools.Hex;

public class OneJpegPerIframe
extends AbstractTrack {
    private File[] jpegs;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private long[] sampleDurations;
    private long[] syncSamples;
    private VisualSampleEntry mp4v;

    public OneJpegPerIframe(String name, File[] jpegs, Track alignTo) throws IOException {
        super(name);
        this.jpegs = jpegs;
        if (alignTo.getSyncSamples().length != jpegs.length) {
            throw new RuntimeException("Number of sync samples doesn't match the number of stills (" + alignTo.getSyncSamples().length + " vs. " + jpegs.length + ")");
        }
        BufferedImage a = ImageIO.read(jpegs[0]);
        this.trackMetaData.setWidth(a.getWidth());
        this.trackMetaData.setHeight(a.getHeight());
        this.trackMetaData.setTimescale(alignTo.getTrackMetaData().getTimescale());
        long[] sampleDurationsToiAlignTo = alignTo.getSampleDurations();
        long[] syncSamples = alignTo.getSyncSamples();
        int currentSyncSample = 1;
        long duration = 0L;
        this.sampleDurations = new long[syncSamples.length];
        for (int i = 1; i < sampleDurationsToiAlignTo.length; ++i) {
            if (currentSyncSample < syncSamples.length && (long)i == syncSamples[currentSyncSample]) {
                this.sampleDurations[currentSyncSample - 1] = duration;
                duration = 0L;
                ++currentSyncSample;
            }
            duration += sampleDurationsToiAlignTo[i];
        }
        this.sampleDurations[this.sampleDurations.length - 1] = duration;
        this.mp4v = new VisualSampleEntry("mp4v");
        ESDescriptorBox esds = new ESDescriptorBox();
        esds.setData(ByteBuffer.wrap(Hex.decodeHex((String)"038080801B000100048080800D6C11000000000A1CB4000A1CB4068080800102")));
        esds.setEsDescriptor((ESDescriptor)ObjectDescriptorFactory.createFrom((int)-1, (ByteBuffer)ByteBuffer.wrap(Hex.decodeHex((String)"038080801B000100048080800D6C11000000000A1CB4000A1CB4068080800102"))));
        this.mp4v.addBox((Box)esds);
        this.syncSamples = new long[jpegs.length];
        for (int i = 0; i < this.syncSamples.length; ++i) {
            this.syncSamples[i] = i + 1;
        }
        double earliestTrackPresentationTime = 0.0;
        boolean acceptDwell = true;
        boolean acceptEdit = true;
        for (Edit edit : alignTo.getEdits()) {
            if (edit.getMediaTime() == -1L && !acceptDwell) {
                throw new RuntimeException("Cannot accept edit list for processing (1)");
            }
            if (edit.getMediaTime() >= 0L && !acceptEdit) {
                throw new RuntimeException("Cannot accept edit list for processing (2)");
            }
            if (edit.getMediaTime() == -1L) {
                earliestTrackPresentationTime += edit.getSegmentDuration();
                continue;
            }
            earliestTrackPresentationTime -= (double)edit.getMediaTime() / (double)edit.getTimeScale();
            acceptEdit = false;
            acceptDwell = false;
        }
        if (alignTo.getCompositionTimeEntries() != null && alignTo.getCompositionTimeEntries().size() > 0) {
            long currentTime = 0L;
            int[] ptss = CompositionTimeToSample.blowupCompositionTimes(alignTo.getCompositionTimeEntries());
            for (int j = 0; j < ptss.length && j < 50; ++j) {
                int n = j;
                ptss[n] = (int)((long)ptss[n] + currentTime);
                currentTime += alignTo.getSampleDurations()[j];
            }
            Arrays.sort(ptss);
            earliestTrackPresentationTime += (double)ptss[0] / (double)alignTo.getTrackMetaData().getTimescale();
        }
        if (earliestTrackPresentationTime < 0.0) {
            this.getEdits().add(new Edit((long)(-earliestTrackPresentationTime * (double)this.getTrackMetaData().getTimescale()), this.getTrackMetaData().getTimescale(), 1.0, (double)this.getDuration() / (double)this.getTrackMetaData().getTimescale()));
        } else if (earliestTrackPresentationTime > 0.0) {
            this.getEdits().add(new Edit(-1L, this.getTrackMetaData().getTimescale(), 1.0, earliestTrackPresentationTime));
            this.getEdits().add(new Edit(0L, this.getTrackMetaData().getTimescale(), 1.0, (double)this.getDuration() / (double)this.getTrackMetaData().getTimescale()));
        }
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.mp4v);
    }

    @Override
    public long[] getSampleDurations() {
        return this.sampleDurations;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public long[] getSyncSamples() {
        return this.syncSamples;
    }

    @Override
    public List<Sample> getSamples() {
        return new AbstractList<Sample>(){

            @Override
            public int size() {
                return OneJpegPerIframe.this.jpegs.length;
            }

            @Override
            public Sample get(final int index) {
                return new Sample(){
                    ByteBuffer sample = null;

                    @Override
                    public void writeTo(WritableByteChannel channel) throws IOException {
                        RandomAccessFile raf = new RandomAccessFile(OneJpegPerIframe.this.jpegs[index], "r");
                        raf.getChannel().transferTo(0L, raf.length(), channel);
                        raf.close();
                    }

                    @Override
                    public long getSize() {
                        return OneJpegPerIframe.this.jpegs[index].length();
                    }

                    @Override
                    public ByteBuffer asByteBuffer() {
                        if (this.sample == null) {
                            try {
                                RandomAccessFile raf = new RandomAccessFile(OneJpegPerIframe.this.jpegs[index], "r");
                                this.sample = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return this.sample;
                    }

                    @Override
                    public SampleEntry getSampleEntry() {
                        return OneJpegPerIframe.this.mp4v;
                    }
                };
            }
        };
    }

    @Override
    public void close() throws IOException {
    }
}

