/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.JarDiffCodes;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarDiff
implements JarDiffCodes {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static final byte[] newBytes = new byte[2048];
    private static final byte[] oldBytes = new byte[2048];
    private static boolean _debug;

    public static void createPatch(String oldPath, String newPath, OutputStream os, boolean minimal) throws IOException {
        try (ZipFile2 oldArchive = new ZipFile2(oldPath);
             ZipFile2 newArchive = new ZipFile2(newPath);){
            HashMap<String, String> moved = new HashMap<String, String>();
            HashSet<String> implicit = new HashSet<String>();
            HashSet<String> moveSrc = new HashSet<String>();
            HashSet<String> newEntries = new HashSet<String>();
            for (Iterator newEntry : newArchive) {
                String newname = ((ZipEntry)((Object)newEntry)).getName();
                String oldname = oldArchive.getBestMatch(newArchive, (ZipEntry)((Object)newEntry));
                if (oldname == null) {
                    if (_debug) {
                        System.out.println("NEW: " + newname);
                    }
                    newEntries.add(newname);
                    continue;
                }
                if (oldname.equals(newname) && !moveSrc.contains(oldname)) {
                    if (_debug) {
                        System.out.println(newname + " added to implicit set!");
                    }
                    implicit.add(newname);
                    continue;
                }
                if (!minimal && (implicit.contains(oldname) || moveSrc.contains(oldname))) {
                    if (_debug) {
                        System.out.println("NEW: " + newname);
                    }
                    newEntries.add(newname);
                } else {
                    if (_debug) {
                        System.err.println("moved.put " + newname + " " + oldname);
                    }
                    moved.put(newname, oldname);
                    moveSrc.add(oldname);
                }
                if (!implicit.contains(oldname) || !minimal) continue;
                if (_debug) {
                    System.err.println("implicit.remove " + oldname);
                    System.err.println("moved.put " + oldname + " " + oldname);
                }
                implicit.remove(oldname);
                moved.put(oldname, oldname);
                moveSrc.add(oldname);
            }
            ArrayList<String> deleted = new ArrayList<String>();
            for (ZipEntry oldEntry : oldArchive) {
                String oldName = oldEntry.getName();
                if (implicit.contains(oldName) || moveSrc.contains(oldName) || newEntries.contains(oldName)) continue;
                if (_debug) {
                    System.err.println("deleted.add " + oldName);
                }
                deleted.add(oldName);
            }
            if (_debug) {
                System.out.println("MOVED MAP!!!");
                for (Map.Entry entry : moved.entrySet()) {
                    System.out.println(entry);
                }
                System.out.println("IMOVE MAP!!!");
                for (String newName : implicit) {
                    System.out.println("key is " + newName);
                }
            }
            ZipOutputStream jos = new ZipOutputStream(os);
            JarDiff.createIndex(jos, deleted, moved);
            for (String newName : newEntries) {
                if (_debug) {
                    System.out.println("New File: " + newName);
                }
                JarDiff.writeEntry(jos, newArchive.getEntryByName(newName), newArchive);
            }
            jos.finish();
        }
    }

    private static void createIndex(ZipOutputStream jos, List<String> oldEntries, Map<String, String> movedMap) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write("version 1.0");
        writer.write("\r\n");
        for (String string : oldEntries) {
            writer.write("remove");
            writer.write(" ");
            JarDiff.writeEscapedString(writer, string);
            writer.write("\r\n");
        }
        for (Map.Entry entry : movedMap.entrySet()) {
            String oldName = (String)entry.getValue();
            writer.write("move");
            writer.write(" ");
            JarDiff.writeEscapedString(writer, oldName);
            writer.write(" ");
            JarDiff.writeEscapedString(writer, (String)entry.getKey());
            writer.write("\r\n");
        }
        jos.putNextEntry(new ZipEntry("META-INF/INDEX.JD"));
        byte[] bytes = writer.toString().getBytes(StandardCharsets.UTF_8);
        jos.write(bytes, 0, bytes.length);
    }

    protected static Writer writeEscapedString(Writer writer, String string) throws IOException {
        int index = 0;
        int last = 0;
        char[] chars = null;
        while ((index = string.indexOf(32, index)) != -1) {
            if (last != index) {
                if (chars == null) {
                    chars = string.toCharArray();
                }
                writer.write(chars, last, index - last);
            }
            last = index++;
            writer.write(92);
        }
        if (last != 0 && chars != null) {
            writer.write(chars, last, chars.length - last);
        } else {
            writer.write(string);
        }
        return writer;
    }

    private static void writeEntry(ZipOutputStream jos, ZipEntry entry, ZipFile2 file) throws IOException {
        try (InputStream data = file.getArchive().getInputStream(entry);){
            jos.putNextEntry(entry);
            int size = data.read(newBytes);
            while (size != -1) {
                jos.write(newBytes, 0, size);
                size = data.read(newBytes);
            }
        }
    }

    private static class ZipFile2
    implements Iterable<ZipEntry>,
    Closeable {
        private final ZipFile _archive;
        private List<ZipEntry> _entries;
        private HashMap<String, ZipEntry> _nameToEntryMap;
        private HashMap<Long, LinkedList<ZipEntry>> _crcToEntryMap;

        public ZipFile2(String path) throws IOException {
            this._archive = new ZipFile(new File(path));
            this.index();
        }

        public ZipFile getArchive() {
            return this._archive;
        }

        @Override
        public Iterator<ZipEntry> iterator() {
            return this._entries.iterator();
        }

        public ZipEntry getEntryByName(String name) {
            return this._nameToEntryMap.get(name);
        }

        private static boolean differs(InputStream oldIS, InputStream newIS) throws IOException {
            int newSize = 0;
            int total = 0;
            boolean retVal = false;
            block0: while (newSize != -1) {
                int oldSize;
                newSize = newIS.read(newBytes);
                if (newSize != (oldSize = oldIS.read(oldBytes))) {
                    if (_debug) {
                        System.out.println("\tread sizes differ: " + newSize + " " + oldSize + " total " + total);
                    }
                    retVal = true;
                    break;
                }
                if (newSize <= 0) continue;
                while (--newSize >= 0) {
                    ++total;
                    if (newBytes[newSize] != oldBytes[newSize]) {
                        if (_debug) {
                            System.out.println("\tbytes differ at " + total);
                        }
                        retVal = true;
                        continue block0;
                    }
                    if (retVal) continue block0;
                    newSize = 0;
                }
            }
            return retVal;
        }

        public String getBestMatch(ZipFile2 file, ZipEntry entry) throws IOException {
            if (this.contains(file, entry)) {
                return entry.getName();
            }
            return this.hasSameContent(file, entry);
        }

        public boolean contains(ZipFile2 f, ZipEntry e) throws IOException {
            ZipEntry thisEntry = this.getEntryByName(e.getName());
            if (thisEntry == null) {
                return false;
            }
            if (thisEntry.getCrc() != e.getCrc()) {
                return false;
            }
            try (InputStream oldIS = this.getArchive().getInputStream(thisEntry);){
                boolean bl;
                block14: {
                    InputStream newIS = f.getArchive().getInputStream(e);
                    try {
                        boolean bl2 = bl = !ZipFile2.differs(oldIS, newIS);
                        if (newIS == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (newIS != null) {
                            try {
                                newIS.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    newIS.close();
                }
                return bl;
            }
        }

        public String hasSameContent(ZipFile2 file, ZipEntry entry) throws IOException {
            String thisName = null;
            Long crcL = entry.getCrc();
            if (this._crcToEntryMap.containsKey(crcL)) {
                LinkedList<ZipEntry> ll = this._crcToEntryMap.get(crcL);
                ListIterator<ZipEntry> li = ll.listIterator(0);
                while (li.hasNext()) {
                    ZipEntry thisEntry = li.next();
                    InputStream oldIS = this.getArchive().getInputStream(thisEntry);
                    try (InputStream newIS = file.getArchive().getInputStream(entry);){
                        if (ZipFile2.differs(oldIS, newIS)) continue;
                        String string = thisName = thisEntry.getName();
                        return string;
                    }
                    finally {
                        if (oldIS == null) continue;
                        oldIS.close();
                    }
                }
            }
            return thisName;
        }

        private void index() throws IOException {
            Enumeration<? extends ZipEntry> entries = this._archive.entries();
            this._nameToEntryMap = new HashMap();
            this._crcToEntryMap = new HashMap();
            this._entries = new ArrayList<ZipEntry>();
            if (_debug) {
                System.out.println("indexing: " + this._archive.getName());
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    LinkedList<Object> ll;
                    ZipEntry entry = entries.nextElement();
                    long crc = entry.getCrc();
                    Long crcL = crc;
                    if (_debug) {
                        System.out.println("\t" + entry.getName() + " CRC " + crc);
                    }
                    this._nameToEntryMap.put(entry.getName(), entry);
                    this._entries.add(entry);
                    if (this._crcToEntryMap.containsKey(crcL)) {
                        ll = this._crcToEntryMap.get(crcL);
                        ll.add(entry);
                        this._crcToEntryMap.put(crcL, ll);
                        continue;
                    }
                    ll = new LinkedList<ZipEntry>();
                    ll.add(entry);
                    this._crcToEntryMap.put(crcL, ll);
                }
            }
        }

        @Override
        public void close() throws IOException {
            this._archive.close();
        }
    }
}

