/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficrule;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.trafficrule.TrafficRuleScheduleDto;
import com.ubnt.model.api.trafficrule.TrafficRuleScheduleMode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="TrafficRuleScheduleDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableTrafficRuleScheduleDto
implements TrafficRuleScheduleDto {
    private final TrafficRuleScheduleMode mode;
    private final List<com.ubnt.model.schedule.Object> repeatOnDays;
    private final boolean allDay;
    @Nullable
    private final String timeRangeStart;
    @Nullable
    private final String timeRangeEnd;
    @Nullable
    private final LocalDate date;
    @Nullable
    private final LocalDate dateStart;
    @Nullable
    private final LocalDate dateEnd;

    private ImmutableTrafficRuleScheduleDto(Builder builder) {
        this.mode = builder.mode;
        this.repeatOnDays = ImmutableTrafficRuleScheduleDto.o00000(true, builder.repeatOnDays);
        this.allDay = builder.allDay;
        this.timeRangeStart = builder.timeRangeStart;
        this.timeRangeEnd = builder.timeRangeEnd;
        this.date = builder.date;
        this.dateStart = builder.dateStart;
        this.dateEnd = builder.dateEnd;
    }

    @Override
    @JsonProperty(value="mode")
    @NotNull
    public TrafficRuleScheduleMode mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="repeat_on_days")
    @Schema(description="Repeat on on days. Applicable to: EVERY_WEEK, CUSTOM", example="[\"sun\"]")
    public List<com.ubnt.model.schedule.Object> repeatOnDays() {
        return this.repeatOnDays;
    }

    @Override
    @JsonProperty(value="time_all_day")
    @Schema(description="Rule will be running for all day. Time range start/end are ignored. Applicable to: EVERY_WEEK, CUSTOM")
    public boolean allDay() {
        return this.allDay;
    }

    @Override
    @JsonProperty(value="time_range_start")
    @Schema(description="Start time in 24 hours format. Applicable to: EVERY_DAY, EVERY_WEEK, ONE_TIME_ONLY, CUSTOM", example="11:30")
    public Optional<String> timeRangeStart() {
        return Optional.ofNullable(this.timeRangeStart);
    }

    @Override
    @JsonProperty(value="time_range_end")
    @Schema(description="End time in 24 hours format. It accepts 24:00 as end of the day. Applicable to: EVERY_DAY, EVERY_WEEK, ONE_TIME_ONLY, CUSTOM", example="21:15")
    public Optional<String> timeRangeEnd() {
        return Optional.ofNullable(this.timeRangeEnd);
    }

    @Override
    @JsonProperty(value="date")
    @Schema(description="Start date. Applicable to: ONE_TIME_ONLY", example="2021-07-13")
    public Optional<LocalDate> date() {
        return Optional.ofNullable(this.date);
    }

    @Override
    @JsonProperty(value="date_start")
    @Schema(name="Start date. Applicable to: CUSTOM", example="2021-07-13")
    public Optional<LocalDate> dateStart() {
        return Optional.ofNullable(this.dateStart);
    }

    @Override
    @JsonProperty(value="date_end")
    @Schema(name="End date. Applicable to: CUSTOM", example="2021-08-14")
    public Optional<LocalDate> dateEnd() {
        return Optional.ofNullable(this.dateEnd);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableTrafficRuleScheduleDto && this.\u00d300000(0, (ImmutableTrafficRuleScheduleDto)object);
    }

    private boolean \u00d300000(int n2, ImmutableTrafficRuleScheduleDto immutableTrafficRuleScheduleDto) {
        return Objects.equals((Object)this.mode, (Object)immutableTrafficRuleScheduleDto.mode) && this.repeatOnDays.equals(immutableTrafficRuleScheduleDto.repeatOnDays) && this.allDay == immutableTrafficRuleScheduleDto.allDay && Objects.equals(this.timeRangeStart, immutableTrafficRuleScheduleDto.timeRangeStart) && Objects.equals(this.timeRangeEnd, immutableTrafficRuleScheduleDto.timeRangeEnd) && Objects.equals(this.date, immutableTrafficRuleScheduleDto.date) && Objects.equals(this.dateStart, immutableTrafficRuleScheduleDto.dateStart) && Objects.equals(this.dateEnd, immutableTrafficRuleScheduleDto.dateEnd);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode((Object)this.mode);
        n2 += (n2 << 5) + this.repeatOnDays.hashCode();
        n2 += (n2 << 5) + Boolean.hashCode(this.allDay);
        n2 += (n2 << 5) + Objects.hashCode(this.timeRangeStart);
        n2 += (n2 << 5) + Objects.hashCode(this.timeRangeEnd);
        n2 += (n2 << 5) + Objects.hashCode(this.date);
        n2 += (n2 << 5) + Objects.hashCode(this.dateStart);
        n2 += (n2 << 5) + Objects.hashCode(this.dateEnd);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TrafficRuleScheduleDto{");
        if (this.mode != null) {
            stringBuilder.append("mode=").append((Object)this.mode);
        }
        if (stringBuilder.length() > 23) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("repeatOnDays=").append(this.repeatOnDays);
        stringBuilder.append(", ");
        stringBuilder.append("allDay=").append(this.allDay);
        if (this.timeRangeStart != null) {
            stringBuilder.append(", ");
            stringBuilder.append("timeRangeStart=").append(this.timeRangeStart);
        }
        if (this.timeRangeEnd != null) {
            stringBuilder.append(", ");
            stringBuilder.append("timeRangeEnd=").append(this.timeRangeEnd);
        }
        if (this.date != null) {
            stringBuilder.append(", ");
            stringBuilder.append("date=").append(this.date);
        }
        if (this.dateStart != null) {
            stringBuilder.append(", ");
            stringBuilder.append("dateStart=").append(this.dateStart);
        }
        if (this.dateEnd != null) {
            stringBuilder.append(", ");
            stringBuilder.append("dateEnd=").append(this.dateEnd);
        }
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d200000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> o00000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @Generated(from="TrafficRuleScheduleDto", generator="Immutables")
    public static final class Builder {
        @Nullable
        private TrafficRuleScheduleMode mode;
        private List<com.ubnt.model.schedule.Object> repeatOnDays = new ArrayList<com.ubnt.model.schedule.Object>();
        private boolean allDay;
        @Nullable
        private String timeRangeStart;
        @Nullable
        private String timeRangeEnd;
        @Nullable
        private LocalDate date;
        @Nullable
        private LocalDate dateStart;
        @Nullable
        private LocalDate dateEnd;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TrafficRuleScheduleDto trafficRuleScheduleDto) {
            Optional<LocalDate> optional;
            Optional<LocalDate> optional2;
            Optional<LocalDate> optional3;
            Optional<String> optional4;
            Objects.requireNonNull(trafficRuleScheduleDto, "instance");
            TrafficRuleScheduleMode trafficRuleScheduleMode = trafficRuleScheduleDto.mode();
            if (trafficRuleScheduleMode != null) {
                this.mode(trafficRuleScheduleMode);
            }
            this.addAllRepeatOnDays(trafficRuleScheduleDto.repeatOnDays());
            this.allDay(trafficRuleScheduleDto.allDay());
            Optional<String> optional5 = trafficRuleScheduleDto.timeRangeStart();
            if (optional5.isPresent()) {
                this.timeRangeStart(optional5);
            }
            if ((optional4 = trafficRuleScheduleDto.timeRangeEnd()).isPresent()) {
                this.timeRangeEnd(optional4);
            }
            if ((optional3 = trafficRuleScheduleDto.date()).isPresent()) {
                this.date(optional3);
            }
            if ((optional2 = trafficRuleScheduleDto.dateStart()).isPresent()) {
                this.dateStart(optional2);
            }
            if ((optional = trafficRuleScheduleDto.dateEnd()).isPresent()) {
                this.dateEnd(optional);
            }
            return this;
        }

        @JsonProperty(value="mode")
        @CanIgnoreReturnValue
        public final Builder mode(TrafficRuleScheduleMode trafficRuleScheduleMode) {
            this.mode = trafficRuleScheduleMode;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepeatOnDays(@Nullable com.ubnt.model.schedule.Object object) {
            this.repeatOnDays.add(object);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepeatOnDays(com.ubnt.model.schedule.Object ... objectArray) {
            for (com.ubnt.model.schedule.Object object : objectArray) {
                this.repeatOnDays.add(object);
            }
            return this;
        }

        @JsonProperty(value="repeat_on_days")
        @CanIgnoreReturnValue
        public final Builder repeatOnDays(Iterable<? extends com.ubnt.model.schedule.Object> iterable) {
            this.repeatOnDays.clear();
            return this.addAllRepeatOnDays(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRepeatOnDays(Iterable<? extends com.ubnt.model.schedule.Object> iterable) {
            for (com.ubnt.model.schedule.Object object : iterable) {
                this.repeatOnDays.add(object);
            }
            return this;
        }

        @JsonProperty(value="time_all_day")
        @CanIgnoreReturnValue
        public final Builder allDay(boolean bl) {
            this.allDay = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeRangeStart(@Nullable String string) {
            this.timeRangeStart = string;
            return this;
        }

        @JsonProperty(value="time_range_start")
        @CanIgnoreReturnValue
        public final Builder timeRangeStart(Optional<String> optional) {
            this.timeRangeStart = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeRangeEnd(@Nullable String string) {
            this.timeRangeEnd = string;
            return this;
        }

        @JsonProperty(value="time_range_end")
        @CanIgnoreReturnValue
        public final Builder timeRangeEnd(Optional<String> optional) {
            this.timeRangeEnd = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder date(@Nullable LocalDate localDate) {
            this.date = localDate;
            return this;
        }

        @JsonProperty(value="date")
        @CanIgnoreReturnValue
        public final Builder date(Optional<? extends LocalDate> optional) {
            this.date = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dateStart(@Nullable LocalDate localDate) {
            this.dateStart = localDate;
            return this;
        }

        @JsonProperty(value="date_start")
        @CanIgnoreReturnValue
        public final Builder dateStart(Optional<? extends LocalDate> optional) {
            this.dateStart = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dateEnd(@Nullable LocalDate localDate) {
            this.dateEnd = localDate;
            return this;
        }

        @JsonProperty(value="date_end")
        @CanIgnoreReturnValue
        public final Builder dateEnd(Optional<? extends LocalDate> optional) {
            this.dateEnd = optional.orElse(null);
            return this;
        }

        public ImmutableTrafficRuleScheduleDto build() {
            return new ImmutableTrafficRuleScheduleDto(this);
        }
    }
}

