/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficstats;

import com.ubnt.data.Site;
import com.ubnt.model.api.trafficstats.CountryTrafficStatsDto;
import com.ubnt.model.api.trafficstats.HistoricalDpiQueryParameters;
import com.ubnt.model.api.trafficstats.HistoricalTrafficUsageDto;
import com.ubnt.model.api.trafficstats.TrafficClientStatsDto;
import com.ubnt.model.api.trafficstats.TrafficTotalUsageStatsDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.stat.dpi.OoOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Tag(name="Traffic Overview")
public class TrafficOverviewController {
    private final OoOO o00000;

    public TrafficOverviewController(OoOO ooOO2) {
        this.o00000 = ooOO2;
    }

    @GetMapping(value={"/api/site/{siteName}/traffic"})
    @Operation(summary="Get traffic stats")
    public TrafficTotalUsageStatsDto getSiteTraffic(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return TrafficTotalUsageStatsDto.of(this.o00000.\u00d8\u00d20000(site.getId(), l2, l3, bl, List.of()));
    }

    @GetMapping(value={"/api/site/{siteName}/traffic/{mac}"})
    @Operation(summary="Get traffic stats for a specific client")
    public TrafficClientStatsDto getSiteTrafficByMac(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return TrafficClientStatsDto.of(this.o00000.\u00d8\u00d20000(site.getId(), l2, l3, bl, List.of(string)));
    }

    @GetMapping(value={"/api/site/{siteName}/country-traffic"})
    @Operation(summary="Get site country traffic usage")
    public CountryTrafficStatsDto getSiteCountryTrafficUsage(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3) {
        return this.o00000.\u00f4\u00d40000(site.getId(), l2, l3);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-rate"})
    @Operation(summary="Get historical traffic usage", description="Since 7.1.55")
    public List<HistoricalTrafficUsageDto> getHistoricalSiteTrafficUsage(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return this.o00000.\u00d3\u00d40000(site.getId(), l2, l3, bl, HistoricalDpiQueryParameters.withoutApps());
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/app-traffic-rate"})
    @Operation(summary="Get historical traffic usage", description="Since 7.1.55")
    public List<HistoricalTrafficUsageDto> getHistoricalSiteTrafficUsageByApps(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestBody HistoricalDpiQueryParameters historicalDpiQueryParameters, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return this.o00000.\u00d3\u00d40000(site.getId(), l2, l3, bl, historicalDpiQueryParameters);
    }
}

