/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.Firework;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.MapColor;
import net.minecraft.client.color.item.Potion;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.item.BundleSelectedItemSpecialRenderer;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.Broken;
import net.minecraft.client.renderer.item.properties.conditional.BundleHasSelectedItem;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.conditional.FishingRodCast;
import net.minecraft.client.renderer.item.properties.numeric.CompassAngle;
import net.minecraft.client.renderer.item.properties.numeric.CompassAngleState;
import net.minecraft.client.renderer.item.properties.numeric.CrossbowPull;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.Time;
import net.minecraft.client.renderer.item.properties.numeric.UseCycle;
import net.minecraft.client.renderer.item.properties.numeric.UseDuration;
import net.minecraft.client.renderer.item.properties.select.Charge;
import net.minecraft.client.renderer.item.properties.select.DisplayContext;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.TrimMaterialProperty;
import net.minecraft.client.renderer.special.ShieldSpecialRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.special.TridentSpecialRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemModelGenerators {
    private static final ItemTintSource BLANK_LAYER = ItemModelUtils.constantTint((int)-1);
    public static final ResourceLocation TRIM_PREFIX_HELMET = ItemModelGenerators.prefixForSlotTrim("helmet");
    public static final ResourceLocation TRIM_PREFIX_CHESTPLATE = ItemModelGenerators.prefixForSlotTrim("chestplate");
    public static final ResourceLocation TRIM_PREFIX_LEGGINGS = ItemModelGenerators.prefixForSlotTrim("leggings");
    public static final ResourceLocation TRIM_PREFIX_BOOTS = ItemModelGenerators.prefixForSlotTrim("boots");
    public static final List<TrimMaterialData> TRIM_MATERIAL_MODELS = List.of(new TrimMaterialData(MaterialAssetGroup.QUARTZ, TrimMaterials.QUARTZ), new TrimMaterialData(MaterialAssetGroup.IRON, TrimMaterials.IRON), new TrimMaterialData(MaterialAssetGroup.NETHERITE, TrimMaterials.NETHERITE), new TrimMaterialData(MaterialAssetGroup.REDSTONE, TrimMaterials.REDSTONE), new TrimMaterialData(MaterialAssetGroup.COPPER, TrimMaterials.COPPER), new TrimMaterialData(MaterialAssetGroup.GOLD, TrimMaterials.GOLD), new TrimMaterialData(MaterialAssetGroup.EMERALD, TrimMaterials.EMERALD), new TrimMaterialData(MaterialAssetGroup.DIAMOND, TrimMaterials.DIAMOND), new TrimMaterialData(MaterialAssetGroup.LAPIS, TrimMaterials.LAPIS), new TrimMaterialData(MaterialAssetGroup.AMETHYST, TrimMaterials.AMETHYST), new TrimMaterialData(MaterialAssetGroup.RESIN, TrimMaterials.RESIN));
    protected final ItemModelOutput itemModelOutput;
    protected final BiConsumer<ResourceLocation, ModelInstance> modelOutput;

    public static ResourceLocation prefixForSlotTrim(String p_394902_) {
        return ResourceLocation.withDefaultNamespace("trims/items/" + p_394902_ + "_trim");
    }

    public ItemModelGenerators(ItemModelOutput p_375677_, BiConsumer<ResourceLocation, ModelInstance> p_377569_) {
        this.itemModelOutput = p_375677_;
        this.modelOutput = p_377569_;
    }

    protected void declareCustomModelItem(Item p_376826_) {
        this.itemModelOutput.accept(p_376826_, ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376826_)));
    }

    protected ResourceLocation createFlatItemModel(Item p_378447_, ModelTemplate p_376080_) {
        return p_376080_.create(ModelLocationUtils.getModelLocation((Item)p_378447_), TextureMapping.layer0((Item)p_378447_), this.modelOutput);
    }

    protected void generateFlatItem(Item p_377153_, ModelTemplate p_375452_) {
        this.itemModelOutput.accept(p_377153_, ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_377153_, p_375452_)));
    }

    protected ResourceLocation createFlatItemModel(Item p_376880_, String p_375748_, ModelTemplate p_375473_) {
        return p_375473_.create(ModelLocationUtils.getModelLocation((Item)p_376880_, (String)p_375748_), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)p_376880_, (String)p_375748_)), this.modelOutput);
    }

    protected ResourceLocation createFlatItemModel(Item p_376313_, Item p_376431_, ModelTemplate p_376494_) {
        return p_376494_.create(ModelLocationUtils.getModelLocation((Item)p_376313_), TextureMapping.layer0((Item)p_376431_), this.modelOutput);
    }

    protected void generateFlatItem(Item p_376380_, Item p_377414_, ModelTemplate p_375715_) {
        this.itemModelOutput.accept(p_376380_, ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376380_, p_377414_, p_375715_)));
    }

    protected void generateItemWithTintedOverlay(Item p_377767_, ItemTintSource p_376307_) {
        this.generateItemWithTintedOverlay(p_377767_, "_overlay", p_376307_);
    }

    protected void generateItemWithTintedOverlay(Item p_376479_, String p_377630_, ItemTintSource p_375561_) {
        ResourceLocation resourcelocation = this.generateLayeredItem(p_376479_, TextureMapping.getItemTexture((Item)p_376479_), TextureMapping.getItemTexture((Item)p_376479_, (String)p_377630_));
        this.itemModelOutput.accept(p_376479_, ItemModelUtils.tintedModel((ResourceLocation)resourcelocation, (ItemTintSource[])new ItemTintSource[]{BLANK_LAYER, p_375561_}));
    }

    protected List<RangeSelectItemModel.Entry> createCompassModels(Item p_378493_) {
        ArrayList<RangeSelectItemModel.Entry> list = new ArrayList<RangeSelectItemModel.Entry>();
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378493_, "_16", ModelTemplates.FLAT_ITEM));
        list.add(ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked, (float)0.0f));
        for (int i = 1; i < 32; ++i) {
            int j = Mth.positiveModulo(i - 16, 32);
            ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378493_, String.format(Locale.ROOT, "_%02d", j), ModelTemplates.FLAT_ITEM));
            list.add(ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked1, (float)((float)i - 0.5f)));
        }
        list.add(ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked, (float)31.5f));
        return list;
    }

    protected void generateStandardCompassItem(Item p_377729_) {
        List<RangeSelectItemModel.Entry> list = this.createCompassModels(p_377729_);
        this.itemModelOutput.accept(p_377729_, ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.hasComponent(DataComponents.LODESTONE_TRACKER), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new CompassAngle(true, CompassAngleState.CompassTarget.LODESTONE), (float)32.0f, list), (ItemModel.Unbaked)ItemModelUtils.inOverworld((ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new CompassAngle(true, CompassAngleState.CompassTarget.SPAWN), (float)32.0f, list), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new CompassAngle(true, CompassAngleState.CompassTarget.NONE), (float)32.0f, list))));
    }

    protected void generateRecoveryCompassItem(Item p_375879_) {
        this.itemModelOutput.accept(p_375879_, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new CompassAngle(true, CompassAngleState.CompassTarget.RECOVERY), (float)32.0f, this.createCompassModels(p_375879_)));
    }

    protected void generateClockItem(Item p_376265_) {
        ArrayList<RangeSelectItemModel.Entry> list = new ArrayList<RangeSelectItemModel.Entry>();
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376265_, "_00", ModelTemplates.FLAT_ITEM));
        list.add(ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked, (float)0.0f));
        for (int i = 1; i < 64; ++i) {
            ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376265_, String.format(Locale.ROOT, "_%02d", i), ModelTemplates.FLAT_ITEM));
            list.add(ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked1, (float)((float)i - 0.5f)));
        }
        list.add(ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked, (float)63.5f));
        this.itemModelOutput.accept(p_376265_, ItemModelUtils.inOverworld((ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new Time(true, Time.TimeSource.DAYTIME), (float)64.0f, list), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new Time(true, Time.TimeSource.RANDOM), (float)64.0f, list)));
    }

    protected ResourceLocation generateLayeredItem(Item p_378743_, ResourceLocation p_377953_, ResourceLocation p_378692_) {
        return ModelTemplates.TWO_LAYERED_ITEM.create(p_378743_, TextureMapping.layered((ResourceLocation)p_377953_, (ResourceLocation)p_378692_), this.modelOutput);
    }

    protected ResourceLocation generateLayeredItem(ResourceLocation p_376036_, ResourceLocation p_375418_, ResourceLocation p_375468_) {
        return ModelTemplates.TWO_LAYERED_ITEM.create(p_376036_, TextureMapping.layered((ResourceLocation)p_375418_, (ResourceLocation)p_375468_), this.modelOutput);
    }

    protected void generateLayeredItem(ResourceLocation p_377800_, ResourceLocation p_375633_, ResourceLocation p_378759_, ResourceLocation p_378764_) {
        ModelTemplates.THREE_LAYERED_ITEM.create(p_377800_, TextureMapping.layered((ResourceLocation)p_375633_, (ResourceLocation)p_378759_, (ResourceLocation)p_378764_), this.modelOutput);
    }

    protected void generateTrimmableItem(Item p_376312_, ResourceKey<EquipmentAsset> p_375739_, ResourceLocation p_396254_, boolean p_377962_) {
        ItemModel.Unbaked itemmodel$unbaked1;
        ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Item)p_376312_);
        ResourceLocation resourcelocation1 = TextureMapping.getItemTexture((Item)p_376312_);
        ResourceLocation resourcelocation2 = TextureMapping.getItemTexture((Item)p_376312_, (String)"_overlay");
        ArrayList<SelectItemModel.SwitchCase> list = new ArrayList<SelectItemModel.SwitchCase>(TRIM_MATERIAL_MODELS.size());
        for (TrimMaterialData itemmodelgenerators$trimmaterialdata : TRIM_MATERIAL_MODELS) {
            ItemModel.Unbaked itemmodel$unbaked;
            ResourceLocation resourcelocation3 = resourcelocation.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().base().suffix() + "_trim");
            ResourceLocation resourcelocation4 = p_396254_.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().assetId(p_375739_).suffix());
            if (p_377962_) {
                this.generateLayeredItem(resourcelocation3, resourcelocation1, resourcelocation2, resourcelocation4);
                itemmodel$unbaked = ItemModelUtils.tintedModel((ResourceLocation)resourcelocation3, (ItemTintSource[])new ItemTintSource[]{new Dye(-6265536)});
            } else {
                this.generateLayeredItem(resourcelocation3, resourcelocation1, resourcelocation4);
                itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)resourcelocation3);
            }
            list.add(ItemModelUtils.when(itemmodelgenerators$trimmaterialdata.materialKey, (ItemModel.Unbaked)itemmodel$unbaked));
        }
        if (p_377962_) {
            ModelTemplates.TWO_LAYERED_ITEM.create(resourcelocation, TextureMapping.layered((ResourceLocation)resourcelocation1, (ResourceLocation)resourcelocation2), this.modelOutput);
            itemmodel$unbaked1 = ItemModelUtils.tintedModel((ResourceLocation)resourcelocation, (ItemTintSource[])new ItemTintSource[]{new Dye(-6265536)});
        } else {
            ModelTemplates.FLAT_ITEM.create(resourcelocation, TextureMapping.layer0((ResourceLocation)resourcelocation1), this.modelOutput);
            itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)resourcelocation);
        }
        this.itemModelOutput.accept(p_376312_, ItemModelUtils.select((SelectItemModelProperty)new TrimMaterialProperty(), (ItemModel.Unbaked)itemmodel$unbaked1, list));
    }

    protected void generateBundleModels(Item p_376224_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376224_, ModelTemplates.FLAT_ITEM));
        ResourceLocation resourcelocation = this.generateBundleCoverModel(p_376224_, ModelTemplates.BUNDLE_OPEN_BACK_INVENTORY, "_open_back");
        ResourceLocation resourcelocation1 = this.generateBundleCoverModel(p_376224_, ModelTemplates.BUNDLE_OPEN_FRONT_INVENTORY, "_open_front");
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.composite((ItemModel.Unbaked[])new ItemModel.Unbaked[]{ItemModelUtils.plainModel((ResourceLocation)resourcelocation), new BundleSelectedItemSpecialRenderer.Unbaked(), ItemModelUtils.plainModel((ResourceLocation)resourcelocation1)});
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.conditional((ConditionalItemModelProperty)new BundleHasSelectedItem(), (ItemModel.Unbaked)itemmodel$unbaked1, (ItemModel.Unbaked)itemmodel$unbaked);
        this.itemModelOutput.accept(p_376224_, ItemModelUtils.select((SelectItemModelProperty)new DisplayContext(), (ItemModel.Unbaked)itemmodel$unbaked, (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when((Object)ItemDisplayContext.GUI, (ItemModel.Unbaked)itemmodel$unbaked2)}));
    }

    protected ResourceLocation generateBundleCoverModel(Item p_377759_, ModelTemplate p_377732_, String p_376771_) {
        ResourceLocation resourcelocation = TextureMapping.getItemTexture((Item)p_377759_, (String)p_376771_);
        return p_377732_.create(p_377759_, TextureMapping.layer0((ResourceLocation)resourcelocation), this.modelOutput);
    }

    protected void generateBow(Item p_376089_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376089_));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376089_, "_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376089_, "_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376089_, "_pulling_2", ModelTemplates.BOW));
        this.itemModelOutput.accept(p_376089_, ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)itemmodel$unbaked1, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked2, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked3, (float)0.9f)}), (ItemModel.Unbaked)itemmodel$unbaked));
    }

    protected void generateCrossbow(Item p_378673_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_378673_));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378673_, "_pulling_0", ModelTemplates.CROSSBOW));
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378673_, "_pulling_1", ModelTemplates.CROSSBOW));
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378673_, "_pulling_2", ModelTemplates.CROSSBOW));
        ItemModel.Unbaked itemmodel$unbaked4 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378673_, "_arrow", ModelTemplates.CROSSBOW));
        ItemModel.Unbaked itemmodel$unbaked5 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_378673_, "_firework", ModelTemplates.CROSSBOW));
        this.itemModelOutput.accept(p_378673_, ItemModelUtils.select((SelectItemModelProperty)new Charge(), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new CrossbowPull(), (ItemModel.Unbaked)itemmodel$unbaked1, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked2, (float)0.58f), ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked3, (float)1.0f)}), (ItemModel.Unbaked)itemmodel$unbaked), (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when((Object)CrossbowItem.ChargeType.ARROW, (ItemModel.Unbaked)itemmodel$unbaked4), ItemModelUtils.when((Object)CrossbowItem.ChargeType.ROCKET, (ItemModel.Unbaked)itemmodel$unbaked5)}));
    }

    protected void generateBooleanDispatch(Item p_377310_, ConditionalItemModelProperty p_376519_, ItemModel.Unbaked p_376296_, ItemModel.Unbaked p_378712_) {
        this.itemModelOutput.accept(p_377310_, ItemModelUtils.conditional((ConditionalItemModelProperty)p_376519_, (ItemModel.Unbaked)p_376296_, (ItemModel.Unbaked)p_378712_));
    }

    protected void generateElytra(Item p_376521_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376521_, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376521_, "_broken", ModelTemplates.FLAT_ITEM));
        this.generateBooleanDispatch(p_376521_, (ConditionalItemModelProperty)new Broken(), itemmodel$unbaked1, itemmodel$unbaked);
    }

    protected void generateBrush(Item p_376591_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376591_));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376591_, (String)"_brushing_0"));
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376591_, (String)"_brushing_1"));
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376591_, (String)"_brushing_2"));
        this.itemModelOutput.accept(p_376591_, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseCycle(10.0f), (float)0.1f, (ItemModel.Unbaked)itemmodel$unbaked, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked1, (float)0.25f), ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked2, (float)0.5f), ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked3, (float)0.75f)}));
    }

    protected void generateFishingRod(Item p_377466_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_377466_, ModelTemplates.FLAT_HANDHELD_ROD_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_377466_, "_cast", ModelTemplates.FLAT_HANDHELD_ROD_ITEM));
        this.generateBooleanDispatch(p_377466_, (ConditionalItemModelProperty)new FishingRodCast(), itemmodel$unbaked1, itemmodel$unbaked);
    }

    protected void generateGoatHorn(Item p_378813_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_378813_));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.decorateItemModelLocation((String)"tooting_goat_horn"));
        this.generateBooleanDispatch(p_378813_, ItemModelUtils.isUsingItem(), itemmodel$unbaked1, itemmodel$unbaked);
    }

    protected void generateShield(Item p_378111_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.specialModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_378111_), (SpecialModelRenderer.Unbaked)new ShieldSpecialRenderer.Unbaked());
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.specialModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_378111_, (String)"_blocking"), (SpecialModelRenderer.Unbaked)new ShieldSpecialRenderer.Unbaked());
        this.generateBooleanDispatch(p_378111_, ItemModelUtils.isUsingItem(), itemmodel$unbaked1, itemmodel$unbaked);
    }

    protected static ItemModel.Unbaked createFlatModelDispatch(ItemModel.Unbaked p_377503_, ItemModel.Unbaked p_377244_) {
        return ItemModelUtils.select((SelectItemModelProperty)new DisplayContext(), (ItemModel.Unbaked)p_377244_, (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when(List.of(ItemDisplayContext.GUI, ItemDisplayContext.GROUND, ItemDisplayContext.FIXED), (ItemModel.Unbaked)p_377503_)});
    }

    protected void generateSpyglass(Item p_377890_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_377890_, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_377890_, (String)"_in_hand"));
        this.itemModelOutput.accept(p_377890_, ItemModelGenerators.createFlatModelDispatch(itemmodel$unbaked, itemmodel$unbaked1));
    }

    protected void generateTrident(Item p_376855_) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(p_376855_, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.specialModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376855_, (String)"_in_hand"), (SpecialModelRenderer.Unbaked)new TridentSpecialRenderer.Unbaked());
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.specialModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)p_376855_, (String)"_throwing"), (SpecialModelRenderer.Unbaked)new TridentSpecialRenderer.Unbaked());
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)itemmodel$unbaked2, (ItemModel.Unbaked)itemmodel$unbaked1);
        this.itemModelOutput.accept(p_376855_, ItemModelGenerators.createFlatModelDispatch(itemmodel$unbaked, itemmodel$unbaked3));
    }

    protected void addPotionTint(Item p_376884_, ResourceLocation p_378272_) {
        this.itemModelOutput.accept(p_376884_, ItemModelUtils.tintedModel((ResourceLocation)p_378272_, (ItemTintSource[])new ItemTintSource[]{new Potion()}));
    }

    protected void generatePotion(Item p_375712_) {
        ResourceLocation resourcelocation = this.generateLayeredItem(p_375712_, ModelLocationUtils.decorateItemModelLocation((String)"potion_overlay"), ModelLocationUtils.getModelLocation((Item)p_375712_));
        this.addPotionTint(p_375712_, resourcelocation);
    }

    protected void generateTippedArrow(Item p_377081_) {
        ResourceLocation resourcelocation = this.generateLayeredItem(p_377081_, ModelLocationUtils.getModelLocation((Item)p_377081_, (String)"_head"), ModelLocationUtils.getModelLocation((Item)p_377081_, (String)"_base"));
        this.addPotionTint(p_377081_, resourcelocation);
    }

    protected void generateDyedItem(Item p_377413_, int p_378189_) {
        ResourceLocation resourcelocation = this.createFlatItemModel(p_377413_, ModelTemplates.FLAT_ITEM);
        this.itemModelOutput.accept(p_377413_, ItemModelUtils.tintedModel((ResourceLocation)resourcelocation, (ItemTintSource[])new ItemTintSource[]{new Dye(p_378189_)}));
    }

    protected void generateTwoLayerDyedItem(Item p_376926_) {
        ResourceLocation resourcelocation = TextureMapping.getItemTexture((Item)p_376926_);
        ResourceLocation resourcelocation1 = TextureMapping.getItemTexture((Item)p_376926_, (String)"_overlay");
        ResourceLocation resourcelocation2 = ModelTemplates.FLAT_ITEM.create(p_376926_, TextureMapping.layer0((ResourceLocation)resourcelocation), this.modelOutput);
        ResourceLocation resourcelocation3 = ModelLocationUtils.getModelLocation((Item)p_376926_, (String)"_dyed");
        ModelTemplates.TWO_LAYERED_ITEM.create(resourcelocation3, TextureMapping.layered((ResourceLocation)resourcelocation, (ResourceLocation)resourcelocation1), this.modelOutput);
        this.itemModelOutput.accept(p_376926_, ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.hasComponent(DataComponents.DYED_COLOR), (ItemModel.Unbaked)ItemModelUtils.tintedModel((ResourceLocation)resourcelocation3, (ItemTintSource[])new ItemTintSource[]{BLANK_LAYER, new Dye(0)}), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)resourcelocation2)));
    }

    public void run() {
        this.generateFlatItem(Items.ACACIA_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CHERRY_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ACACIA_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CHERRY_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.AMETHYST_SHARD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.APPLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ARMADILLO_SCUTE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ARMOR_STAND, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ARROW, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BAKED_POTATO, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BAMBOO, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.BEEF, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BEETROOT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BEETROOT_SOUP, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BIRCH_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BIRCH_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLACK_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLAZE_POWDER, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLAZE_ROD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.BLUE_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BONE_MEAL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BORDURE_INDENTED_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BOOK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BOWL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BREAD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BRICK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BREEZE_ROD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.BROWN_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CARROT_ON_A_STICK, ModelTemplates.FLAT_HANDHELD_ROD_ITEM);
        this.generateFlatItem(Items.WARPED_FUNGUS_ON_A_STICK, ModelTemplates.FLAT_HANDHELD_ROD_ITEM);
        this.generateFlatItem(Items.CHARCOAL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CHEST_MINECART, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CHICKEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CHORUS_FRUIT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CLAY_BALL, ModelTemplates.FLAT_ITEM);
        this.generateClockItem(Items.CLOCK);
        this.generateFlatItem(Items.COAL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COD_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COMMAND_BLOCK_MINECART, ModelTemplates.FLAT_ITEM);
        this.generateStandardCompassItem(Items.COMPASS);
        this.generateRecoveryCompassItem(Items.RECOVERY_COMPASS);
        this.generateFlatItem(Items.COOKED_BEEF, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKED_CHICKEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKED_COD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKED_MUTTON, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKED_PORKCHOP, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKED_RABBIT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKED_SALMON, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COOKIE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RAW_COPPER, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COPPER_INGOT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CREEPER_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CYAN_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DARK_OAK_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DARK_OAK_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DIAMOND, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DIAMOND_AXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.DIAMOND_HOE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.DIAMOND_HORSE_ARMOR, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DIAMOND_PICKAXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.DIAMOND_SHOVEL, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.DIAMOND_SWORD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.DRAGON_BREATH, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DRIED_KELP, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLUE_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BROWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.EMERALD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ENCHANTED_BOOK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ENDER_EYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ENDER_PEARL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.END_CRYSTAL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.EXPERIENCE_BOTTLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FERMENTED_SPIDER_EYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FIELD_MASONED_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FIREWORK_ROCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FIRE_CHARGE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FLINT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FLINT_AND_STEEL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FLOW_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FLOWER_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FURNACE_MINECART, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GHAST_TEAR, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLASS_BOTTLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLISTERING_MELON_SLICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLOBE_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLOW_BERRIES, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLOWSTONE_DUST, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLOW_INK_SAC, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLOW_ITEM_FRAME, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RAW_GOLD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GOLDEN_APPLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GOLDEN_AXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.GOLDEN_CARROT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GOLDEN_HOE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.GOLDEN_HORSE_ARMOR, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GOLDEN_PICKAXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.GOLDEN_SHOVEL, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.GOLDEN_SWORD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.GOLD_INGOT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GOLD_NUGGET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GRAY_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GREEN_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GUNPOWDER, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GUSTER_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HEART_OF_THE_SEA, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HONEYCOMB, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HONEY_BOTTLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HOPPER_MINECART, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.INK_SAC, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RAW_IRON, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.IRON_AXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.IRON_HOE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.IRON_HORSE_ARMOR, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.IRON_INGOT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.IRON_NUGGET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.IRON_PICKAXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.IRON_SHOVEL, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.IRON_SWORD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.ITEM_FRAME, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.JUNGLE_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.JUNGLE_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.KNOWLEDGE_BOOK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LAPIS_LAZULI, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LAVA_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LEATHER, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LIGHT_BLUE_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LIGHT_GRAY_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LIME_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MAGENTA_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MAGMA_CREAM, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MANGROVE_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MANGROVE_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BAMBOO_RAFT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BAMBOO_CHEST_RAFT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MAP, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MELON_SLICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MILK_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MINECART, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MOJANG_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MUSHROOM_STEW, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DISC_FRAGMENT_5, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MUSIC_DISC_11, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_13, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_BLOCKS, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_CAT, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_CHIRP, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_CREATOR, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_CREATOR_MUSIC_BOX, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_FAR, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_LAVA_CHICKEN, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_MALL, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_MELLOHI, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_PIGSTEP, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_PRECIPICE, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_STAL, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_STRAD, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_WAIT, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_WARD, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_OTHERSIDE, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_RELIC, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_5, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUSIC_DISC_TEARS, ModelTemplates.MUSIC_DISC);
        this.generateFlatItem(Items.MUTTON, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NAME_TAG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NAUTILUS_SHELL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NETHERITE_AXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.NETHERITE_HOE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.NETHERITE_INGOT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NETHERITE_PICKAXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.NETHERITE_SCRAP, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NETHERITE_SHOVEL, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.NETHERITE_SWORD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.NETHER_BRICK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RESIN_BRICK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NETHER_STAR, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.OAK_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.OAK_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ORANGE_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PAINTING, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PALE_OAK_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PALE_OAK_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PAPER, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PHANTOM_MEMBRANE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PIGLIN_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PINK_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.POISONOUS_POTATO, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.POPPED_CHORUS_FRUIT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PORKCHOP, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.POWDER_SNOW_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PRISMARINE_CRYSTALS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PRISMARINE_SHARD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PUFFERFISH, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PUFFERFISH_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PUMPKIN_PIE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PURPLE_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.QUARTZ, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RABBIT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RABBIT_FOOT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RABBIT_HIDE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RABBIT_STEW, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RED_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ROTTEN_FLESH, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SADDLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SALMON, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SALMON_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TURTLE_SCUTE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHEARS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHULKER_SHELL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SKULL_BANNER_PATTERN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SLIME_BALL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SNOWBALL, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ECHO_SHARD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SPECTRAL_ARROW, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SPIDER_EYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SPRUCE_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SPRUCE_CHEST_BOAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.STICK, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.STONE_AXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.STONE_HOE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.STONE_PICKAXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.STONE_SHOVEL, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.STONE_SWORD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.SUGAR, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SUSPICIOUS_STEW, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TNT_MINECART, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TOTEM_OF_UNDYING, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TROPICAL_FISH, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TROPICAL_FISH_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.AXOLOTL_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TADPOLE_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WATER_BUCKET, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WHEAT, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WHITE_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WIND_CHARGE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MACE, ModelTemplates.FLAT_HANDHELD_MACE_ITEM);
        this.generateFlatItem(Items.WOODEN_AXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.WOODEN_HOE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.WOODEN_PICKAXE, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.WOODEN_SHOVEL, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.WOODEN_SWORD, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.WRITABLE_BOOK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WRITTEN_BOOK, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.YELLOW_DYE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DEBUG_STICK, Items.STICK, ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateFlatItem(Items.ENCHANTED_GOLDEN_APPLE, Items.GOLDEN_APPLE, ModelTemplates.FLAT_ITEM);
        this.generateTrimmableItem(Items.TURTLE_HELMET, EquipmentAssets.TURTLE_SCUTE, TRIM_PREFIX_HELMET, false);
        this.generateTrimmableItem(Items.LEATHER_HELMET, EquipmentAssets.LEATHER, TRIM_PREFIX_HELMET, true);
        this.generateTrimmableItem(Items.LEATHER_CHESTPLATE, EquipmentAssets.LEATHER, TRIM_PREFIX_CHESTPLATE, true);
        this.generateTrimmableItem(Items.LEATHER_LEGGINGS, EquipmentAssets.LEATHER, TRIM_PREFIX_LEGGINGS, true);
        this.generateTrimmableItem(Items.LEATHER_BOOTS, EquipmentAssets.LEATHER, TRIM_PREFIX_BOOTS, true);
        this.generateTrimmableItem(Items.CHAINMAIL_HELMET, EquipmentAssets.CHAINMAIL, TRIM_PREFIX_HELMET, false);
        this.generateTrimmableItem(Items.CHAINMAIL_CHESTPLATE, EquipmentAssets.CHAINMAIL, TRIM_PREFIX_CHESTPLATE, false);
        this.generateTrimmableItem(Items.CHAINMAIL_LEGGINGS, EquipmentAssets.CHAINMAIL, TRIM_PREFIX_LEGGINGS, false);
        this.generateTrimmableItem(Items.CHAINMAIL_BOOTS, EquipmentAssets.CHAINMAIL, TRIM_PREFIX_BOOTS, false);
        this.generateTrimmableItem(Items.IRON_HELMET, EquipmentAssets.IRON, TRIM_PREFIX_HELMET, false);
        this.generateTrimmableItem(Items.IRON_CHESTPLATE, EquipmentAssets.IRON, TRIM_PREFIX_CHESTPLATE, false);
        this.generateTrimmableItem(Items.IRON_LEGGINGS, EquipmentAssets.IRON, TRIM_PREFIX_LEGGINGS, false);
        this.generateTrimmableItem(Items.IRON_BOOTS, EquipmentAssets.IRON, TRIM_PREFIX_BOOTS, false);
        this.generateTrimmableItem(Items.DIAMOND_HELMET, EquipmentAssets.DIAMOND, TRIM_PREFIX_HELMET, false);
        this.generateTrimmableItem(Items.DIAMOND_CHESTPLATE, EquipmentAssets.DIAMOND, TRIM_PREFIX_CHESTPLATE, false);
        this.generateTrimmableItem(Items.DIAMOND_LEGGINGS, EquipmentAssets.DIAMOND, TRIM_PREFIX_LEGGINGS, false);
        this.generateTrimmableItem(Items.DIAMOND_BOOTS, EquipmentAssets.DIAMOND, TRIM_PREFIX_BOOTS, false);
        this.generateTrimmableItem(Items.GOLDEN_HELMET, EquipmentAssets.GOLD, TRIM_PREFIX_HELMET, false);
        this.generateTrimmableItem(Items.GOLDEN_CHESTPLATE, EquipmentAssets.GOLD, TRIM_PREFIX_CHESTPLATE, false);
        this.generateTrimmableItem(Items.GOLDEN_LEGGINGS, EquipmentAssets.GOLD, TRIM_PREFIX_LEGGINGS, false);
        this.generateTrimmableItem(Items.GOLDEN_BOOTS, EquipmentAssets.GOLD, TRIM_PREFIX_BOOTS, false);
        this.generateTrimmableItem(Items.NETHERITE_HELMET, EquipmentAssets.NETHERITE, TRIM_PREFIX_HELMET, false);
        this.generateTrimmableItem(Items.NETHERITE_CHESTPLATE, EquipmentAssets.NETHERITE, TRIM_PREFIX_CHESTPLATE, false);
        this.generateTrimmableItem(Items.NETHERITE_LEGGINGS, EquipmentAssets.NETHERITE, TRIM_PREFIX_LEGGINGS, false);
        this.generateTrimmableItem(Items.NETHERITE_BOOTS, EquipmentAssets.NETHERITE, TRIM_PREFIX_BOOTS, false);
        this.generateDyedItem(Items.LEATHER_HORSE_ARMOR, -6265536);
        this.generateFlatItem(Items.ANGLER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ARCHER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ARMS_UP_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLADE_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BREWER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BURN_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DANGER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.EXPLORER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FLOW_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FRIEND_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GUSTER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HEART_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HEARTBREAK_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HOWL_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MINER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MOURNER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PLENTY_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PRIZE_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SCRAPE_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHEAF_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHELTER_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SKULL_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SNORT_POTTERY_SHERD, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TRIAL_KEY, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.OMINOUS_TRIAL_KEY, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.OMINOUS_BOTTLE, ModelTemplates.FLAT_ITEM);
        this.generateItemWithTintedOverlay(Items.FIREWORK_STAR, (ItemTintSource)new Firework());
        this.generateItemWithTintedOverlay(Items.FILLED_MAP, "_markings", (ItemTintSource)new MapColor());
        this.generateBundleModels(Items.BUNDLE);
        this.generateBundleModels(Items.BLACK_BUNDLE);
        this.generateBundleModels(Items.WHITE_BUNDLE);
        this.generateBundleModels(Items.GRAY_BUNDLE);
        this.generateBundleModels(Items.LIGHT_GRAY_BUNDLE);
        this.generateBundleModels(Items.LIGHT_BLUE_BUNDLE);
        this.generateBundleModels(Items.BLUE_BUNDLE);
        this.generateBundleModels(Items.CYAN_BUNDLE);
        this.generateBundleModels(Items.YELLOW_BUNDLE);
        this.generateBundleModels(Items.RED_BUNDLE);
        this.generateBundleModels(Items.PURPLE_BUNDLE);
        this.generateBundleModels(Items.MAGENTA_BUNDLE);
        this.generateBundleModels(Items.PINK_BUNDLE);
        this.generateBundleModels(Items.GREEN_BUNDLE);
        this.generateBundleModels(Items.LIME_BUNDLE);
        this.generateBundleModels(Items.BROWN_BUNDLE);
        this.generateBundleModels(Items.ORANGE_BUNDLE);
        this.generateSpyglass(Items.SPYGLASS);
        this.generateTrident(Items.TRIDENT);
        this.generateTwoLayerDyedItem(Items.WOLF_ARMOR);
        this.generateFlatItem(Items.WHITE_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ORANGE_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MAGENTA_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LIGHT_BLUE_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.YELLOW_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LIME_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PINK_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GRAY_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LIGHT_GRAY_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CYAN_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PURPLE_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLUE_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BROWN_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GREEN_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RED_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLACK_HARNESS, ModelTemplates.FLAT_ITEM);
        this.generateBow(Items.BOW);
        this.generateCrossbow(Items.CROSSBOW);
        this.generateElytra(Items.ELYTRA);
        this.generateBrush(Items.BRUSH);
        this.generateFishingRod(Items.FISHING_ROD);
        this.generateGoatHorn(Items.GOAT_HORN);
        this.generateShield(Items.SHIELD);
        this.generateTippedArrow(Items.TIPPED_ARROW);
        this.generatePotion(Items.POTION);
        this.generatePotion(Items.SPLASH_POTION);
        this.generatePotion(Items.LINGERING_POTION);
        this.generateFlatItem(Items.ARMADILLO_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ALLAY_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.AXOLOTL_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BAT_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BEE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BLAZE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BOGGED_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.BREEZE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CAT_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CAMEL_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CAVE_SPIDER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CHICKEN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COD_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.COW_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CREEPER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DOLPHIN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DONKEY_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.DROWNED_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ELDER_GUARDIAN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ENDER_DRAGON_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ENDERMAN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ENDERMITE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.EVOKER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FOX_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.FROG_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GHAST_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GLOW_SQUID_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GOAT_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.GUARDIAN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HAPPY_GHAST_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HOGLIN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HORSE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.HUSK_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.IRON_GOLEM_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.LLAMA_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MAGMA_CUBE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MOOSHROOM_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.MULE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.OCELOT_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PANDA_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PARROT_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PHANTOM_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PIG_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PIGLIN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PIGLIN_BRUTE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PILLAGER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.POLAR_BEAR_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.PUFFERFISH_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RABBIT_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.RAVAGER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SALMON_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHEEP_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SHULKER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SILVERFISH_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SKELETON_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SKELETON_HORSE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SLIME_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SNIFFER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SNOW_GOLEM_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SPIDER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.SQUID_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.STRAY_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.STRIDER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TADPOLE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TRADER_LLAMA_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TROPICAL_FISH_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.TURTLE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.VEX_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.VILLAGER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.VINDICATOR_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WANDERING_TRADER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WARDEN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WITCH_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WITHER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WITHER_SKELETON_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.WOLF_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ZOGLIN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.CREAKING_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ZOMBIE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ZOMBIE_HORSE_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ZOMBIE_VILLAGER_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(Items.ZOMBIFIED_PIGLIN_SPAWN_EGG, ModelTemplates.FLAT_ITEM);
        this.declareCustomModelItem(Items.AIR);
        this.declareCustomModelItem(Items.AMETHYST_CLUSTER);
        this.declareCustomModelItem(Items.SMALL_AMETHYST_BUD);
        this.declareCustomModelItem(Items.MEDIUM_AMETHYST_BUD);
        this.declareCustomModelItem(Items.LARGE_AMETHYST_BUD);
        this.declareCustomModelItem(Items.SMALL_DRIPLEAF);
        this.declareCustomModelItem(Items.BIG_DRIPLEAF);
        this.declareCustomModelItem(Items.HANGING_ROOTS);
        this.declareCustomModelItem(Items.POINTED_DRIPSTONE);
        this.declareCustomModelItem(Items.BONE);
        this.declareCustomModelItem(Items.COD);
        this.declareCustomModelItem(Items.FEATHER);
        this.declareCustomModelItem(Items.LEAD);
        ItemModelOutput itemModelOutput = this.itemModelOutput;
        if (itemModelOutput instanceof ModelProvider.ItemInfoCollector) {
            ModelProvider.ItemInfoCollector collector = (ModelProvider.ItemInfoCollector)itemModelOutput;
            collector.generateDefaultBlockModels();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record TrimMaterialData(MaterialAssetGroup assets, ResourceKey<TrimMaterial> materialKey) {
    }
}

