/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.realmsclient.RealmsMainScreen;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.NowPlayingToast;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.Dialogs;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DialogTags;
import net.minecraft.util.CommonLinks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ModListScreen;

@OnlyIn(value=Dist.CLIENT)
public class PauseScreen
extends Screen {
    private static final ResourceLocation DRAFT_REPORT_SPRITE = ResourceLocation.withDefaultNamespace("icon/draft_report");
    private static final int COLUMNS = 2;
    private static final int MENU_PADDING_TOP = 50;
    private static final int BUTTON_PADDING = 4;
    private static final int BUTTON_WIDTH_FULL = 204;
    private static final int BUTTON_WIDTH_HALF = 98;
    private static final Component RETURN_TO_GAME = Component.translatable("menu.returnToGame");
    private static final Component ADVANCEMENTS = Component.translatable("gui.advancements");
    private static final Component STATS = Component.translatable("gui.stats");
    private static final Component SEND_FEEDBACK = Component.translatable("menu.sendFeedback");
    private static final Component REPORT_BUGS = Component.translatable("menu.reportBugs");
    private static final Component FEEDBACK_SUBSCREEN = Component.translatable("menu.feedback");
    private static final Component OPTIONS = Component.translatable("menu.options");
    private static final Component SHARE_TO_LAN = Component.translatable("menu.shareToLan");
    private static final Component PLAYER_REPORTING = Component.translatable("menu.playerReporting");
    private static final Component GAME = Component.translatable("menu.game");
    private static final Component PAUSED = Component.translatable("menu.paused");
    private static final Tooltip CUSTOM_OPTIONS_TOOLTIP = Tooltip.create((Component)Component.translatable("menu.custom_options.tooltip"));
    private final boolean showPauseMenu;
    @Nullable
    private Button disconnectButton;

    public PauseScreen(boolean p_96308_) {
        super(p_96308_ ? GAME : PAUSED);
        this.showPauseMenu = p_96308_;
    }

    public boolean showsPauseMenu() {
        return this.showPauseMenu;
    }

    @Override
    protected void init() {
        if (this.showPauseMenu) {
            this.createPauseMenu();
        }
        this.addRenderableWidget(new StringWidget(0, this.showPauseMenu ? 40 : 10, this.width, 9, this.title, this.font));
    }

    private void createPauseMenu() {
        GridLayout gridlayout = new GridLayout();
        gridlayout.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper gridlayout$rowhelper = gridlayout.createRowHelper(2);
        gridlayout$rowhelper.addChild((LayoutElement)Button.builder(RETURN_TO_GAME, p_280814_ -> {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
        }).width(204).build(), 2, gridlayout.newCellSettings().paddingTop(50));
        gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(ADVANCEMENTS, () -> new AdvancementsScreen(this.minecraft.player.connection.getAdvancements(), this)));
        gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(STATS, () -> new StatsScreen((Screen)this, this.minecraft.player.getStats())));
        Optional<? extends Holder<Dialog>> optional = this.getCustomAdditions();
        if (optional.isEmpty()) {
            PauseScreen.addFeedbackButtons(this, gridlayout$rowhelper);
        } else {
            this.addFeedbackSubscreenAndCustomDialogButtons(this.minecraft, optional.get(), gridlayout$rowhelper);
        }
        gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(OPTIONS, () -> new OptionsScreen((Screen)this, this.minecraft.options)));
        if (this.minecraft.hasSingleplayerServer() && !this.minecraft.getSingleplayerServer().isPublished()) {
            gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(SHARE_TO_LAN, () -> new ShareToLanScreen((Screen)this)));
        } else {
            gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(PLAYER_REPORTING, () -> new SocialInteractionsScreen((Screen)this)));
        }
        gridlayout$rowhelper.addChild((LayoutElement)Button.builder(Component.translatable("fml.menu.mods"), button -> this.minecraft.setScreen((Screen)new ModListScreen((Screen)this))).width(204).build(), 2);
        this.disconnectButton = (Button)gridlayout$rowhelper.addChild((LayoutElement)Button.builder(CommonComponents.disconnectButtonLabel(this.minecraft.isLocalServer()), p_280815_ -> {
            p_280815_.active = false;
            this.minecraft.getReportingContext().draftReportHandled(this.minecraft, (Screen)this, () -> PauseScreen.disconnectFromWorld(this.minecraft, ClientLevel.DEFAULT_QUIT_MESSAGE), true);
        }).width(204).build(), 2);
        gridlayout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridlayout, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.25f);
        gridlayout.visitWidgets(this::addRenderableWidget);
    }

    private Optional<? extends Holder<Dialog>> getCustomAdditions() {
        HolderSet holderset;
        HolderLookup.RegistryLookup registry = this.minecraft.player.connection.registryAccess().lookupOrThrow(Registries.DIALOG);
        Optional optional = registry.get(DialogTags.PAUSE_SCREEN_ADDITIONS);
        if (optional.isPresent() && (holderset = (HolderSet)optional.get()).size() > 0) {
            if (holderset.size() == 1) {
                return Optional.of(holderset.get(0));
            }
            return registry.get(Dialogs.CUSTOM_OPTIONS);
        }
        ServerLinks serverlinks = this.minecraft.player.connection.serverLinks();
        return !serverlinks.isEmpty() ? registry.get(Dialogs.SERVER_LINKS) : Optional.empty();
    }

    static void addFeedbackButtons(Screen p_342955_, GridLayout.RowHelper p_344682_) {
        p_344682_.addChild((LayoutElement)PauseScreen.openLinkButton(p_342955_, SEND_FEEDBACK, SharedConstants.getCurrentVersion().stable() ? CommonLinks.RELEASE_FEEDBACK : CommonLinks.SNAPSHOT_FEEDBACK));
        ((Button)p_344682_.addChild((LayoutElement)PauseScreen.openLinkButton((Screen)p_342955_, (Component)PauseScreen.REPORT_BUGS, (URI)CommonLinks.SNAPSHOT_BUGS_FEEDBACK))).active = !SharedConstants.getCurrentVersion().dataVersion().isSideSeries();
    }

    private void addFeedbackSubscreenAndCustomDialogButtons(Minecraft p_409476_, Holder<Dialog> p_410455_, GridLayout.RowHelper p_409050_) {
        p_409050_.addChild((LayoutElement)this.openScreenButton(FEEDBACK_SUBSCREEN, () -> new FeedbackSubScreen(this)));
        p_409050_.addChild((LayoutElement)Button.builder(p_410455_.value().common().computeExternalTitle(), p_404847_ -> p_409476_.player.connection.showDialog(p_410455_, this)).width(98).tooltip(CUSTOM_OPTIONS_TOOLTIP).build());
    }

    public static void disconnectFromWorld(Minecraft p_407579_, Component p_410652_) {
        boolean flag = p_407579_.isLocalServer();
        ServerData serverdata = p_407579_.getCurrentServer();
        if (p_407579_.level != null) {
            p_407579_.level.disconnect(p_410652_);
        }
        if (flag) {
            p_407579_.disconnectWithSavingScreen();
        } else {
            p_407579_.disconnectWithProgressScreen();
        }
        TitleScreen titlescreen = new TitleScreen();
        if (flag) {
            p_407579_.setScreen(titlescreen);
        } else if (serverdata != null && serverdata.isRealm()) {
            p_407579_.setScreen((Screen)new RealmsMainScreen((Screen)titlescreen));
        } else {
            p_407579_.setScreen((Screen)new JoinMultiplayerScreen((Screen)titlescreen));
        }
    }

    @Override
    public void tick() {
        if (this.rendersNowPlayingToast()) {
            NowPlayingToast.tickMusicNotes();
        }
    }

    @Override
    public void render(GuiGraphics p_281899_, int p_281431_, int p_283183_, float p_281435_) {
        super.render(p_281899_, p_281431_, p_283183_, p_281435_);
        if (this.rendersNowPlayingToast()) {
            NowPlayingToast.renderToast((GuiGraphics)p_281899_, (Font)this.font);
        }
        if (this.showPauseMenu && this.minecraft != null && this.minecraft.getReportingContext().hasDraftReport() && this.disconnectButton != null) {
            p_281899_.blitSprite(RenderPipelines.GUI_TEXTURED, DRAFT_REPORT_SPRITE, this.disconnectButton.getX() + this.disconnectButton.getWidth() - 17, this.disconnectButton.getY() + 3, 15, 15);
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_299656_, int p_297892_, int p_299995_, float p_300532_) {
        if (this.showPauseMenu) {
            super.renderBackground(p_299656_, p_297892_, p_299995_, p_300532_);
        }
    }

    public boolean rendersNowPlayingToast() {
        Options options = this.minecraft.options;
        return (Boolean)options.showNowPlayingToast().get() != false && options.getFinalSoundSourceVolume(SoundSource.MUSIC) > 0.0f && this.showPauseMenu;
    }

    private Button openScreenButton(Component p_262567_, Supplier<Screen> p_262581_) {
        return Button.builder(p_262567_, p_280817_ -> this.minecraft.setScreen((Screen)((Object)((Object)p_262581_.get())))).width(98).build();
    }

    private static Button openLinkButton(Screen p_343161_, Component p_262593_, URI p_343969_) {
        return Button.builder(p_262593_, ConfirmLinkScreen.confirmLink((Screen)p_343161_, (URI)p_343969_)).width(98).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FeedbackSubScreen
    extends Screen {
        private static final Component TITLE = Component.translatable("menu.feedback.title");
        public final Screen parent;
        private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

        protected FeedbackSubScreen(Screen p_343282_) {
            super(TITLE);
            this.parent = p_343282_;
        }

        @Override
        protected void init() {
            this.layout.addTitleHeader(TITLE, this.font);
            GridLayout gridlayout = (GridLayout)this.layout.addToContents((LayoutElement)new GridLayout());
            gridlayout.defaultCellSetting().padding(4, 4, 4, 0);
            GridLayout.RowHelper gridlayout$rowhelper = gridlayout.createRowHelper(2);
            PauseScreen.addFeedbackButtons(this, gridlayout$rowhelper);
            this.layout.addToFooter((LayoutElement)Button.builder(CommonComponents.GUI_BACK, p_342489_ -> this.onClose()).width(200).build());
            this.layout.visitWidgets(this::addRenderableWidget);
            this.repositionElements();
        }

        @Override
        protected void repositionElements() {
            this.layout.arrangeElements();
        }

        @Override
        public void onClose() {
            this.minecraft.setScreen(this.parent);
        }
    }
}

