/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.options.controls;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindsScreen
extends OptionsSubScreen {
    private static final Component TITLE = Component.translatable("controls.keybinds.title");
    @Nullable
    public KeyMapping selectedKey;
    public long lastKeySelection;
    private KeyBindsList keyBindsList;
    private Button resetButton;

    public KeyBindsScreen(Screen p_344695_, Options p_342647_) {
        super(p_344695_, p_342647_, TITLE);
    }

    protected void addContents() {
        this.keyBindsList = (KeyBindsList)this.layout.addToContents((LayoutElement)new KeyBindsList(this, this.minecraft));
    }

    protected void addOptions() {
    }

    protected void addFooter() {
        this.resetButton = Button.builder(Component.translatable("controls.resetAll"), p_343640_ -> {
            for (KeyMapping keymapping : this.options.keyMappings) {
                keymapping.setToDefault();
            }
            this.keyBindsList.resetMappingAndUpdateButtons();
        }).build();
        LinearLayout linearlayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearlayout.addChild((LayoutElement)this.resetButton);
        linearlayout.addChild((LayoutElement)Button.builder(CommonComponents.GUI_DONE, p_404863_ -> this.onClose()).build());
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.keyBindsList.updateSize(this.width, this.layout);
    }

    public boolean mouseClicked(double p_343851_, double p_342346_, int p_344515_) {
        if (this.selectedKey != null) {
            this.selectedKey.setKey(InputConstants.Type.MOUSE.getOrCreate(p_344515_));
            this.selectedKey = null;
            this.keyBindsList.resetMappingAndUpdateButtons();
            return true;
        }
        return super.mouseClicked(p_343851_, p_342346_, p_344515_);
    }

    public boolean keyPressed(int p_342715_, int p_342862_, int p_345515_) {
        if (this.selectedKey != null) {
            if (p_342715_ == 256) {
                this.selectedKey.setKeyModifierAndCode(null, InputConstants.UNKNOWN);
            } else {
                this.selectedKey.setKeyModifierAndCode(null, InputConstants.getKey((int)p_342715_, (int)p_342862_));
            }
            if (p_342715_ == 256 || !KeyModifier.isKeyCodeModifier((InputConstants.Key)this.selectedKey.getKey())) {
                this.selectedKey = null;
            }
            this.lastKeySelection = Util.getMillis();
            this.keyBindsList.resetMappingAndUpdateButtons();
            return true;
        }
        return super.keyPressed(p_342715_, p_342862_, p_345515_);
    }

    public void render(GuiGraphics p_344555_, int p_344302_, int p_344298_, float p_344857_) {
        super.render(p_344555_, p_344302_, p_344298_, p_344857_);
        boolean flag = false;
        for (KeyMapping keymapping : this.options.keyMappings) {
            if (keymapping.isDefault()) continue;
            flag = true;
            break;
        }
        this.resetButton.active = flag;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.selectedKey != null && this.selectedKey.getKey() == key) {
            this.selectedKey = null;
            this.lastKeySelection = Util.getMillis();
            this.keyBindsList.resetMappingAndUpdateButtons();
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

