/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;

public class Tags {
    public static void init() {
        Blocks.init();
        EntityTypes.init();
        Items.init();
        Fluids.init();
        Enchantments.init();
        Biomes.init();
        Structures.init();
    }

    public static class Blocks {
        public static final TagKey<Block> ENDERMAN_PLACE_ON_BLACKLIST = Blocks.forgeTag("enderman_place_on_blacklist");
        public static final TagKey<Block> NEEDS_WOOD_TOOL = Blocks.forgeTag("needs_wood_tool");
        public static final TagKey<Block> NEEDS_GOLD_TOOL = Blocks.forgeTag("needs_gold_tool");
        public static final TagKey<Block> NEEDS_NETHERITE_TOOL = Blocks.forgeTag("needs_netherite_tool");
        public static final TagKey<Block> STORAGE_BLOCKS_AMETHYST = Blocks.forgeTag("storage_blocks/amethyst");
        public static final TagKey<Block> STORAGE_BLOCKS_QUARTZ = Blocks.forgeTag("storage_blocks/quartz");
        public static final TagKey<Block> CHESTS_ENDER = Blocks.forgeTag("chests/ender");
        public static final TagKey<Block> CHESTS_TRAPPED = Blocks.forgeTag("chests/trapped");
        public static final TagKey<Block> CHORUS_ADDITIONALLY_GROWS_ON = Blocks.forgeTag("chorus_additionally_grows_on");
        public static final TagKey<Block> COBBLESTONE_NORMAL = Blocks.forgeTag("cobblestone/normal");
        public static final TagKey<Block> COBBLESTONE_INFESTED = Blocks.forgeTag("cobblestone/infested");
        public static final TagKey<Block> COBBLESTONE_MOSSY = Blocks.forgeTag("cobblestone/mossy");
        public static final TagKey<Block> COBBLESTONE_DEEPSLATE = Blocks.forgeTag("cobblestone/deepslate");
        public static final TagKey<Block> END_STONES = Blocks.forgeTag("end_stones");
        public static final TagKey<Block> FENCE_GATES = Blocks.forgeTag("fence_gates");
        public static final TagKey<Block> FENCE_GATES_WOODEN = Blocks.forgeTag("fence_gates/wooden");
        public static final TagKey<Block> FENCES = Blocks.forgeTag("fences");
        public static final TagKey<Block> FENCES_NETHER_BRICK = Blocks.forgeTag("fences/nether_brick");
        public static final TagKey<Block> FENCES_WOODEN = Blocks.forgeTag("fences/wooden");
        public static final TagKey<Block> GRAVEL = Blocks.forgeTag("gravel");
        public static final TagKey<Block> NETHERRACK = Blocks.forgeTag("netherrack");
        public static final TagKey<Block> ORE_BEARING_GROUND_DEEPSLATE = Blocks.forgeTag("ore_bearing_ground/deepslate");
        public static final TagKey<Block> ORE_BEARING_GROUND_NETHERRACK = Blocks.forgeTag("ore_bearing_ground/netherrack");
        public static final TagKey<Block> ORE_BEARING_GROUND_STONE = Blocks.forgeTag("ore_bearing_ground/stone");
        public static final TagKey<Block> ORE_RATES_DENSE = Blocks.forgeTag("ore_rates/dense");
        public static final TagKey<Block> ORE_RATES_SINGULAR = Blocks.forgeTag("ore_rates/singular");
        public static final TagKey<Block> ORE_RATES_SPARSE = Blocks.forgeTag("ore_rates/sparse");
        public static final TagKey<Block> ORES_COAL = Blocks.forgeTag("ores/coal");
        public static final TagKey<Block> ORES_COPPER = Blocks.forgeTag("ores/copper");
        public static final TagKey<Block> ORES_DIAMOND = Blocks.forgeTag("ores/diamond");
        public static final TagKey<Block> ORES_EMERALD = Blocks.forgeTag("ores/emerald");
        public static final TagKey<Block> ORES_GOLD = Blocks.forgeTag("ores/gold");
        public static final TagKey<Block> ORES_IRON = Blocks.forgeTag("ores/iron");
        public static final TagKey<Block> ORES_LAPIS = Blocks.forgeTag("ores/lapis");
        public static final TagKey<Block> ORES_REDSTONE = Blocks.forgeTag("ores/redstone");
        public static final TagKey<Block> ORES_IN_GROUND_DEEPSLATE = Blocks.forgeTag("ores_in_ground/deepslate");
        public static final TagKey<Block> ORES_IN_GROUND_NETHERRACK = Blocks.forgeTag("ores_in_ground/netherrack");
        public static final TagKey<Block> ORES_IN_GROUND_STONE = Blocks.forgeTag("ores_in_ground/stone");
        public static final TagKey<Block> SAND = Blocks.forgeTag("sand");
        public static final TagKey<Block> SAND_COLORLESS = Blocks.forgeTag("sand/colorless");
        public static final TagKey<Block> SAND_RED = Blocks.forgeTag("sand/red");
        public static final TagKey<Block> BARRELS = Blocks.cTag("barrels");
        public static final TagKey<Block> BARRELS_WOODEN = Blocks.cTag("barrels/wooden");
        public static final TagKey<Block> BOOKSHELVES = Blocks.cTag("bookshelves");
        public static final TagKey<Block> BUDDING_BLOCKS = Blocks.cTag("budding_blocks");
        public static final TagKey<Block> BUDS = Blocks.cTag("buds");
        public static final TagKey<Block> CHAINS = Blocks.cTag("chains");
        public static final TagKey<Block> CHESTS = Blocks.cTag("chests");
        public static final TagKey<Block> CHESTS_WOODEN = Blocks.cTag("chests/wooden");
        public static final TagKey<Block> CLUSTERS = Blocks.cTag("clusters");
        public static final TagKey<Block> COBBLESTONES = Blocks.cTag("cobblestones");
        public static final TagKey<Block> CONCRETES = Blocks.cTag("concretes");
        public static final TagKey<Block> DYED = Blocks.cTag("dyed");
        public static final TagKey<Block> DYED_BLACK = Blocks.cTag("dyed/black");
        public static final TagKey<Block> DYED_BLUE = Blocks.cTag("dyed/blue");
        public static final TagKey<Block> DYED_BROWN = Blocks.cTag("dyed/brown");
        public static final TagKey<Block> DYED_CYAN = Blocks.cTag("dyed/cyan");
        public static final TagKey<Block> DYED_GRAY = Blocks.cTag("dyed/gray");
        public static final TagKey<Block> DYED_GREEN = Blocks.cTag("dyed/green");
        public static final TagKey<Block> DYED_LIGHT_BLUE = Blocks.cTag("dyed/light_blue");
        public static final TagKey<Block> DYED_LIGHT_GRAY = Blocks.cTag("dyed/light_gray");
        public static final TagKey<Block> DYED_LIME = Blocks.cTag("dyed/lime");
        public static final TagKey<Block> DYED_MAGENTA = Blocks.cTag("dyed/magenta");
        public static final TagKey<Block> DYED_ORANGE = Blocks.cTag("dyed/orange");
        public static final TagKey<Block> DYED_PINK = Blocks.cTag("dyed/pink");
        public static final TagKey<Block> DYED_PURPLE = Blocks.cTag("dyed/purple");
        public static final TagKey<Block> DYED_RED = Blocks.cTag("dyed/red");
        public static final TagKey<Block> DYED_WHITE = Blocks.cTag("dyed/white");
        public static final TagKey<Block> DYED_YELLOW = Blocks.cTag("dyed/yellow");
        public static final TagKey<Block> FLOWERS_SMALL = Blocks.cTag("flowers/small");
        public static final TagKey<Block> FLOWERS_TALL = Blocks.cTag("flowers/tall");
        public static final TagKey<Block> FLOWERS = Blocks.cTag("flowers");
        public static final TagKey<Block> GLASS_BLOCKS = Blocks.cTag("glass_blocks");
        public static final TagKey<Block> GLASS_BLOCKS_COLORLESS = Blocks.cTag("glass_blocks/colorless");
        public static final TagKey<Block> GLASS_BLOCKS_CHEAP = Blocks.cTag("glass_blocks/cheap");
        public static final TagKey<Block> GLASS_BLOCKS_TINTED = Blocks.cTag("glass_blocks/tinted");
        public static final TagKey<Block> GLASS_PANES = Blocks.cTag("glass_panes");
        public static final TagKey<Block> GLASS_PANES_COLORLESS = Blocks.cTag("glass_panes/colorless");
        public static final TagKey<Block> GLAZED_TERRACOTTAS = Blocks.cTag("glazed_terracottas");
        public static final TagKey<Block> HIDDEN_FROM_RECIPE_VIEWERS = Blocks.cTag("hidden_from_recipe_viewers");
        public static final TagKey<Block> OBSIDIANS = Blocks.cTag("obsidians");
        public static final TagKey<Block> OBSIDIANS_NORMAL = Blocks.cTag("obsidians/normal");
        public static final TagKey<Block> OBSIDIANS_CRYING = Blocks.cTag("obsidians/crying");
        public static final TagKey<Block> ORES = Blocks.cTag("ores");
        public static final TagKey<Block> ORES_NETHERITE_SCRAP = Blocks.cTag("ores/netherite_scrap");
        public static final TagKey<Block> ORES_QUARTZ = Blocks.cTag("ores/quartz");
        public static final TagKey<Block> PLAYER_WORKSTATIONS_CRAFTING_TABLES = Blocks.cTag("player_workstations/crafting_tables");
        public static final TagKey<Block> PLAYER_WORKSTATIONS_FURNACES = Blocks.cTag("player_workstations/furnaces");
        public static final TagKey<Block> PUMPKINS = Blocks.cTag("pumpkins");
        public static final TagKey<Block> PUMPKINS_NORMAL = Blocks.cTag("pumpkins/normal");
        public static final TagKey<Block> PUMPKINS_CARVED = Blocks.cTag("pumpkins/carved");
        public static final TagKey<Block> PUMPKINS_JACK_O_LANTERNS = Blocks.cTag("pumpkins/jack_o_lanterns");
        public static final TagKey<Block> RELOCATION_NOT_SUPPORTED = Blocks.cTag("relocation_not_supported");
        public static final TagKey<Block> ROPES = Blocks.cTag("ropes");
        public static final TagKey<Block> SANDSTONE_BLOCKS = Blocks.cTag("sandstone/blocks");
        public static final TagKey<Block> SANDSTONE_SLABS = Blocks.cTag("sandstone/slabs");
        public static final TagKey<Block> SANDSTONE_STAIRS = Blocks.cTag("sandstone/stairs");
        public static final TagKey<Block> SANDSTONE_RED_BLOCKS = Blocks.cTag("sandstone/red_blocks");
        public static final TagKey<Block> SANDSTONE_RED_SLABS = Blocks.cTag("sandstone/red_slabs");
        public static final TagKey<Block> SANDSTONE_RED_STAIRS = Blocks.cTag("sandstone/red_stairs");
        public static final TagKey<Block> SANDSTONE_UNCOLORED_BLOCKS = Blocks.cTag("sandstone/uncolored_blocks");
        public static final TagKey<Block> SANDSTONE_UNCOLORED_SLABS = Blocks.cTag("sandstone/uncolored_slabs");
        public static final TagKey<Block> SANDSTONE_UNCOLORED_STAIRS = Blocks.cTag("sandstone/uncolored_stairs");
        public static final TagKey<Block> SKULLS = Blocks.cTag("skulls");
        public static final TagKey<Block> STONES = Blocks.cTag("stones");
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.cTag("storage_blocks");
        public static final TagKey<Block> STORAGE_BLOCKS_BONE_MEAL = Blocks.cTag("storage_blocks/bone_meal");
        public static final TagKey<Block> STORAGE_BLOCKS_COAL = Blocks.cTag("storage_blocks/coal");
        public static final TagKey<Block> STORAGE_BLOCKS_COPPER = Blocks.cTag("storage_blocks/copper");
        public static final TagKey<Block> STORAGE_BLOCKS_DIAMOND = Blocks.cTag("storage_blocks/diamond");
        public static final TagKey<Block> STORAGE_BLOCKS_DRIED_KELP = Blocks.cTag("storage_blocks/dried_kelp");
        public static final TagKey<Block> STORAGE_BLOCKS_EMERALD = Blocks.cTag("storage_blocks/emerald");
        public static final TagKey<Block> STORAGE_BLOCKS_GOLD = Blocks.cTag("storage_blocks/gold");
        public static final TagKey<Block> STORAGE_BLOCKS_IRON = Blocks.cTag("storage_blocks/iron");
        public static final TagKey<Block> STORAGE_BLOCKS_LAPIS = Blocks.cTag("storage_blocks/lapis");
        public static final TagKey<Block> STORAGE_BLOCKS_NETHERITE = Blocks.cTag("storage_blocks/netherite");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_COPPER = Blocks.cTag("storage_blocks/raw_copper");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_GOLD = Blocks.cTag("storage_blocks/raw_gold");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_IRON = Blocks.cTag("storage_blocks/raw_iron");
        public static final TagKey<Block> STORAGE_BLOCKS_REDSTONE = Blocks.cTag("storage_blocks/redstone");
        public static final TagKey<Block> STORAGE_BLOCKS_SLIME = Blocks.cTag("storage_blocks/slime");
        public static final TagKey<Block> STORAGE_BLOCKS_WHEAT = Blocks.cTag("storage_blocks/wheat");
        public static final TagKey<Block> STRIPPED_LOGS = Blocks.cTag("stripped_logs");
        public static final TagKey<Block> STRIPPED_WOODS = Blocks.cTag("stripped_woods");
        public static final TagKey<Block> VILLAGER_JOB_SITES = Blocks.cTag("villager_job_sites");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> COBBLESTONE = COBBLESTONES;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_SILICA = GLASS_BLOCKS_CHEAP;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS = Blocks.forgeTag("glass");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_BLACK = Blocks.forgeTag("glass/black");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_BLUE = Blocks.forgeTag("glass/blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_BROWN = Blocks.forgeTag("glass/brown");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_COLORLESS = Blocks.forgeTag("glass/colorless");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_CYAN = Blocks.forgeTag("glass/cyan");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_GRAY = Blocks.forgeTag("glass/gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_GREEN = Blocks.forgeTag("glass/green");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_LIGHT_BLUE = Blocks.forgeTag("glass/light_blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_LIGHT_GRAY = Blocks.forgeTag("glass/light_gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_LIME = Blocks.forgeTag("glass/lime");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_MAGENTA = Blocks.forgeTag("glass/magenta");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_ORANGE = Blocks.forgeTag("glass/orange");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PINK = Blocks.forgeTag("glass/pink");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PURPLE = Blocks.forgeTag("glass/purple");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_RED = Blocks.forgeTag("glass/red");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_WHITE = Blocks.forgeTag("glass/white");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_YELLOW = Blocks.forgeTag("glass/yellow");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> STAINED_GLASS = Blocks.forgeTag("stained_glass");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_BLACK = Blocks.forgeTag("glass_panes/black");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_BLUE = Blocks.forgeTag("glass_panes/blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_BROWN = Blocks.forgeTag("glass_panes/brown");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_CYAN = Blocks.forgeTag("glass_panes/cyan");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_GRAY = Blocks.forgeTag("glass_panes/gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_GREEN = Blocks.forgeTag("glass_panes/green");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_LIGHT_BLUE = Blocks.forgeTag("glass_panes/light_blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_LIGHT_GRAY = Blocks.forgeTag("glass_panes/light_gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_LIME = Blocks.forgeTag("glass_panes/lime");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_MAGENTA = Blocks.forgeTag("glass_panes/magenta");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_ORANGE = Blocks.forgeTag("glass_panes/orange");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_PINK = Blocks.forgeTag("glass_panes/pink");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_PURPLE = Blocks.forgeTag("glass_panes/purple");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_RED = Blocks.forgeTag("glass_panes/red");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_WHITE = Blocks.forgeTag("glass_panes/white");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> GLASS_PANES_YELLOW = Blocks.forgeTag("glass_panes/yellow");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Block> STAINED_GLASS_PANES = Blocks.forgeTag("stained_glass_panes");

        private static void init() {
        }

        private static TagKey<Block> cTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Block> forgeTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
        }
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> BOSSES = EntityTypes.cTag("bosses");
        public static final TagKey<EntityType<?>> MINECARTS = EntityTypes.cTag("minecarts");
        public static final TagKey<EntityType<?>> BOATS = EntityTypes.cTag("boats");
        public static final TagKey<EntityType<?>> CAPTURING_NOT_SUPPORTED = EntityTypes.cTag("capturing_not_supported");
        public static final TagKey<EntityType<?>> TELEPORTING_NOT_SUPPORTED = EntityTypes.cTag("teleporting_not_supported");

        private static void init() {
        }

        private static TagKey<EntityType<?>> cTag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> BONES = Items.forgeTag("bones");
        public static final TagKey<Item> CHESTS_ENDER = Items.forgeTag("chests/ender");
        public static final TagKey<Item> CHESTS_TRAPPED = Items.forgeTag("chests/trapped");
        public static final TagKey<Item> COBBLESTONE_NORMAL = Items.forgeTag("cobblestone/normal");
        public static final TagKey<Item> COBBLESTONE_INFESTED = Items.forgeTag("cobblestone/infested");
        public static final TagKey<Item> COBBLESTONE_MOSSY = Items.forgeTag("cobblestone/mossy");
        public static final TagKey<Item> COBBLESTONE_DEEPSLATE = Items.forgeTag("cobblestone/deepslate");
        public static final TagKey<Item> EGGS = Items.forgeTag("eggs");
        public static final TagKey<Item> END_STONES = Items.forgeTag("end_stones");
        public static final TagKey<Item> FEATHERS = Items.forgeTag("feathers");
        public static final TagKey<Item> FENCE_GATES = Items.forgeTag("fence_gates");
        public static final TagKey<Item> FENCE_GATES_WOODEN = Items.forgeTag("fence_gates/wooden");
        public static final TagKey<Item> FENCES = Items.forgeTag("fences");
        public static final TagKey<Item> FENCES_NETHER_BRICK = Items.forgeTag("fences/nether_brick");
        public static final TagKey<Item> FENCES_WOODEN = Items.forgeTag("fences/wooden");
        public static final TagKey<Item> GRAVEL = Items.forgeTag("gravel");
        public static final TagKey<Item> GUNPOWDER = Items.forgeTag("gunpowder");
        public static final TagKey<Item> MUSHROOMS = Items.forgeTag("mushrooms");
        public static final TagKey<Item> NETHER_STARS = Items.forgeTag("nether_stars");
        public static final TagKey<Item> NETHERRACK = Items.forgeTag("netherrack");
        public static final TagKey<Item> ORE_BEARING_GROUND_DEEPSLATE = Items.forgeTag("ore_bearing_ground/deepslate");
        public static final TagKey<Item> ORE_BEARING_GROUND_NETHERRACK = Items.forgeTag("ore_bearing_ground/netherrack");
        public static final TagKey<Item> ORE_BEARING_GROUND_STONE = Items.forgeTag("ore_bearing_ground/stone");
        public static final TagKey<Item> ORE_RATES_DENSE = Items.forgeTag("ore_rates/dense");
        public static final TagKey<Item> ORE_RATES_SINGULAR = Items.forgeTag("ore_rates/singular");
        public static final TagKey<Item> ORE_RATES_SPARSE = Items.forgeTag("ore_rates/sparse");
        public static final TagKey<Item> ORES_COAL = Items.forgeTag("ores/coal");
        public static final TagKey<Item> ORES_COPPER = Items.forgeTag("ores/copper");
        public static final TagKey<Item> ORES_DIAMOND = Items.forgeTag("ores/diamond");
        public static final TagKey<Item> ORES_EMERALD = Items.forgeTag("ores/emerald");
        public static final TagKey<Item> ORES_GOLD = Items.forgeTag("ores/gold");
        public static final TagKey<Item> ORES_IRON = Items.forgeTag("ores/iron");
        public static final TagKey<Item> ORES_LAPIS = Items.forgeTag("ores/lapis");
        public static final TagKey<Item> ORES_REDSTONE = Items.forgeTag("ores/redstone");
        public static final TagKey<Item> ORES_IN_GROUND_DEEPSLATE = Items.forgeTag("ores_in_ground/deepslate");
        public static final TagKey<Item> ORES_IN_GROUND_NETHERRACK = Items.forgeTag("ores_in_ground/netherrack");
        public static final TagKey<Item> ORES_IN_GROUND_STONE = Items.forgeTag("ores_in_ground/stone");
        public static final TagKey<Item> SAND = Items.forgeTag("sand");
        public static final TagKey<Item> SAND_COLORLESS = Items.forgeTag("sand/colorless");
        public static final TagKey<Item> SAND_RED = Items.forgeTag("sand/red");
        public static final TagKey<Item> SEEDS = Items.forgeTag("seeds");
        public static final TagKey<Item> SEEDS_BEETROOT = Items.forgeTag("seeds/beetroot");
        public static final TagKey<Item> SEEDS_MELON = Items.forgeTag("seeds/melon");
        public static final TagKey<Item> SEEDS_PUMPKIN = Items.forgeTag("seeds/pumpkin");
        public static final TagKey<Item> SEEDS_WHEAT = Items.forgeTag("seeds/wheat");
        public static final TagKey<Item> ENCHANTING_FUELS = Items.forgeTag("enchanting_fuels");
        public static final TagKey<Item> STORAGE_BLOCKS_AMETHYST = Items.forgeTag("storage_blocks/amethyst");
        public static final TagKey<Item> STORAGE_BLOCKS_QUARTZ = Items.forgeTag("storage_blocks/quartz");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> DUSTS_PRISMARINE = Items.forgeTag("dusts/prismarine");
        public static final TagKey<Item> BARRELS = Items.cTag("barrels");
        public static final TagKey<Item> BARRELS_WOODEN = Items.cTag("barrels/wooden");
        public static final TagKey<Item> BOOKSHELVES = Items.cTag("bookshelves");
        public static final TagKey<Item> BRICKS = Items.cTag("bricks");
        public static final TagKey<Item> BRICKS_NORMAL = Items.cTag("bricks/normal");
        public static final TagKey<Item> BRICKS_NETHER = Items.cTag("bricks/nether");
        public static final TagKey<Item> BUCKETS = Items.cTag("buckets");
        public static final TagKey<Item> BUCKETS_EMPTY = Items.cTag("buckets/empty");
        public static final TagKey<Item> BUCKETS_WATER = Items.cTag("buckets/water");
        public static final TagKey<Item> BUCKETS_LAVA = Items.cTag("buckets/lava");
        public static final TagKey<Item> BUCKETS_MILK = Items.cTag("buckets/milk");
        public static final TagKey<Item> BUCKETS_POWDER_SNOW = Items.cTag("buckets/powder_snow");
        public static final TagKey<Item> BUCKETS_ENTITY_WATER = Items.cTag("buckets/entity_water");
        public static final TagKey<Item> BUDDING_BLOCKS = Items.cTag("budding_blocks");
        public static final TagKey<Item> BUDS = Items.cTag("buds");
        public static final TagKey<Item> CHAINS = Items.cTag("chains");
        public static final TagKey<Item> CHESTS = Items.cTag("chests");
        public static final TagKey<Item> CHESTS_WOODEN = Items.cTag("chests/wooden");
        public static final TagKey<Item> COBBLESTONES = Items.cTag("cobblestones");
        public static final TagKey<Item> CONCRETES = Items.cTag("concretes");
        public static final TagKey<Item> CONCRETE_POWDERS = Items.cTag("concrete_powders");
        public static final TagKey<Item> CLUSTERS = Items.cTag("clusters");
        public static final TagKey<Item> CROPS = Items.cTag("crops");
        public static final TagKey<Item> CROPS_BEETROOT = Items.cTag("crops/beetroot");
        public static final TagKey<Item> CROPS_CACTUS = Items.cTag("crops/cactus");
        public static final TagKey<Item> CROPS_CARROT = Items.cTag("crops/carrot");
        public static final TagKey<Item> CROPS_COCOA_BEAN = Items.cTag("crops/cocoa_bean");
        public static final TagKey<Item> CROPS_MELON = Items.cTag("crops/melon");
        public static final TagKey<Item> CROPS_NETHER_WART = Items.cTag("crops/nether_wart");
        public static final TagKey<Item> CROPS_POTATO = Items.cTag("crops/potato");
        public static final TagKey<Item> CROPS_PUMPKIN = Items.cTag("crops/pumpkin");
        public static final TagKey<Item> CROPS_SUGAR_CANE = Items.cTag("crops/sugar_cane");
        public static final TagKey<Item> CROPS_WHEAT = Items.cTag("crops/wheat");
        public static final TagKey<Item> DUSTS = Items.cTag("dusts");
        public static final TagKey<Item> DUSTS_REDSTONE = Items.cTag("dusts/redstone");
        public static final TagKey<Item> DUSTS_GLOWSTONE = Items.cTag("dusts/glowstone");
        public static final TagKey<Item> DYED = Items.cTag("dyed");
        public static final TagKey<Item> DYED_BLACK = Items.cTag("dyed/black");
        public static final TagKey<Item> DYED_BLUE = Items.cTag("dyed/blue");
        public static final TagKey<Item> DYED_BROWN = Items.cTag("dyed/brown");
        public static final TagKey<Item> DYED_CYAN = Items.cTag("dyed/cyan");
        public static final TagKey<Item> DYED_GRAY = Items.cTag("dyed/gray");
        public static final TagKey<Item> DYED_GREEN = Items.cTag("dyed/green");
        public static final TagKey<Item> DYED_LIGHT_BLUE = Items.cTag("dyed/light_blue");
        public static final TagKey<Item> DYED_LIGHT_GRAY = Items.cTag("dyed/light_gray");
        public static final TagKey<Item> DYED_LIME = Items.cTag("dyed/lime");
        public static final TagKey<Item> DYED_MAGENTA = Items.cTag("dyed/magenta");
        public static final TagKey<Item> DYED_ORANGE = Items.cTag("dyed/orange");
        public static final TagKey<Item> DYED_PINK = Items.cTag("dyed/pink");
        public static final TagKey<Item> DYED_PURPLE = Items.cTag("dyed/purple");
        public static final TagKey<Item> DYED_RED = Items.cTag("dyed/red");
        public static final TagKey<Item> DYED_WHITE = Items.cTag("dyed/white");
        public static final TagKey<Item> DYED_YELLOW = Items.cTag("dyed/yellow");
        public static final TagKey<Item> DYES = Items.cTag("dyes");
        public static final TagKey<Item> DYES_BLACK = DyeColor.BLACK.getTag();
        public static final TagKey<Item> DYES_RED = DyeColor.RED.getTag();
        public static final TagKey<Item> DYES_GREEN = DyeColor.GREEN.getTag();
        public static final TagKey<Item> DYES_BROWN = DyeColor.BROWN.getTag();
        public static final TagKey<Item> DYES_BLUE = DyeColor.BLUE.getTag();
        public static final TagKey<Item> DYES_PURPLE = DyeColor.PURPLE.getTag();
        public static final TagKey<Item> DYES_CYAN = DyeColor.CYAN.getTag();
        public static final TagKey<Item> DYES_LIGHT_GRAY = DyeColor.LIGHT_GRAY.getTag();
        public static final TagKey<Item> DYES_GRAY = DyeColor.GRAY.getTag();
        public static final TagKey<Item> DYES_PINK = DyeColor.PINK.getTag();
        public static final TagKey<Item> DYES_LIME = DyeColor.LIME.getTag();
        public static final TagKey<Item> DYES_YELLOW = DyeColor.YELLOW.getTag();
        public static final TagKey<Item> DYES_LIGHT_BLUE = DyeColor.LIGHT_BLUE.getTag();
        public static final TagKey<Item> DYES_MAGENTA = DyeColor.MAGENTA.getTag();
        public static final TagKey<Item> DYES_ORANGE = DyeColor.ORANGE.getTag();
        public static final TagKey<Item> DYES_WHITE = DyeColor.WHITE.getTag();
        public static final TagKey<Item> ENDER_PEARLS = Items.cTag("ender_pearls");
        public static final TagKey<Item> FERTILIZERS = Items.cTag("fertilizers");
        public static final TagKey<Item> FLOWERS_SMALL = Items.cTag("flowers/small");
        public static final TagKey<Item> FLOWERS_TALL = Items.cTag("flowers/tall");
        public static final TagKey<Item> FLOWERS = Items.cTag("flowers");
        public static final TagKey<Item> FOODS = Items.cTag("foods");
        public static final TagKey<Item> FOODS_FRUIT = Items.cTag("foods/fruit");
        public static final TagKey<Item> FOODS_VEGETABLE = Items.cTag("foods/vegetable");
        public static final TagKey<Item> FOODS_BERRY = Items.cTag("foods/berry");
        public static final TagKey<Item> FOODS_BREAD = Items.cTag("foods/bread");
        public static final TagKey<Item> FOODS_COOKIE = Items.cTag("foods/cookie");
        public static final TagKey<Item> FOODS_RAW_MEAT = Items.cTag("foods/raw_meat");
        public static final TagKey<Item> FOODS_COOKED_MEAT = Items.cTag("foods/cooked_meat");
        public static final TagKey<Item> FOODS_RAW_FISH = Items.cTag("foods/raw_fish");
        public static final TagKey<Item> FOODS_COOKED_FISH = Items.cTag("foods/cooked_fish");
        public static final TagKey<Item> FOODS_SOUP = Items.cTag("foods/soup");
        public static final TagKey<Item> FOODS_CANDY = Items.cTag("foods/candy");
        public static final TagKey<Item> FOODS_PIE = Items.cTag("foods/pie");
        public static final TagKey<Item> FOODS_GOLDEN = Items.cTag("foods/golden");
        public static final TagKey<Item> FOODS_EDIBLE_WHEN_PLACED = Items.cTag("foods/edible_when_placed");
        public static final TagKey<Item> FOODS_FOOD_POISONING = Items.cTag("foods/food_poisoning");
        public static final TagKey<Item> ANIMAL_FOODS = Items.cTag("animal_foods");
        public static final TagKey<Item> GEMS = Items.cTag("gems");
        public static final TagKey<Item> GEMS_DIAMOND = Items.cTag("gems/diamond");
        public static final TagKey<Item> GEMS_EMERALD = Items.cTag("gems/emerald");
        public static final TagKey<Item> GEMS_AMETHYST = Items.cTag("gems/amethyst");
        public static final TagKey<Item> GEMS_LAPIS = Items.cTag("gems/lapis");
        public static final TagKey<Item> GEMS_PRISMARINE = Items.cTag("gems/prismarine");
        public static final TagKey<Item> GEMS_QUARTZ = Items.cTag("gems/quartz");
        public static final TagKey<Item> GLASS_BLOCKS = Items.cTag("glass_blocks");
        public static final TagKey<Item> GLASS_BLOCKS_COLORLESS = Items.cTag("glass_blocks/colorless");
        public static final TagKey<Item> GLASS_BLOCKS_CHEAP = Items.cTag("glass_blocks/cheap");
        public static final TagKey<Item> GLASS_BLOCKS_TINTED = Items.cTag("glass_blocks/tinted");
        public static final TagKey<Item> GLASS_PANES = Items.cTag("glass_panes");
        public static final TagKey<Item> GLASS_PANES_COLORLESS = Items.cTag("glass_panes/colorless");
        public static final TagKey<Item> GLAZED_TERRACOTTAS = Items.cTag("glazed_terracottas");
        public static final TagKey<Item> HIDDEN_FROM_RECIPE_VIEWERS = Items.cTag("hidden_from_recipe_viewers");
        public static final TagKey<Item> OBSIDIANS = Items.cTag("obsidians");
        public static final TagKey<Item> OBSIDIANS_NORMAL = Items.cTag("obsidians/normal");
        public static final TagKey<Item> OBSIDIANS_CRYING = Items.cTag("obsidians/crying");
        public static final TagKey<Item> INGOTS = Items.cTag("ingots");
        public static final TagKey<Item> INGOTS_COPPER = Items.cTag("ingots/copper");
        public static final TagKey<Item> INGOTS_GOLD = Items.cTag("ingots/gold");
        public static final TagKey<Item> INGOTS_IRON = Items.cTag("ingots/iron");
        public static final TagKey<Item> INGOTS_NETHERITE = Items.cTag("ingots/netherite");
        public static final TagKey<Item> LEATHERS = Items.cTag("leathers");
        public static final TagKey<Item> MUSIC_DISCS = Items.cTag("music_discs");
        public static final TagKey<Item> NUGGETS = Items.cTag("nuggets");
        public static final TagKey<Item> NUGGETS_GOLD = Items.cTag("nuggets/gold");
        public static final TagKey<Item> NUGGETS_IRON = Items.cTag("nuggets/iron");
        public static final TagKey<Item> ORES = Items.cTag("ores");
        public static final TagKey<Item> ORES_NETHERITE_SCRAP = Items.cTag("ores/netherite_scrap");
        public static final TagKey<Item> ORES_QUARTZ = Items.cTag("ores/quartz");
        public static final TagKey<Item> PLAYER_WORKSTATIONS_CRAFTING_TABLES = Items.cTag("player_workstations/crafting_tables");
        public static final TagKey<Item> PLAYER_WORKSTATIONS_FURNACES = Items.cTag("player_workstations/furnaces");
        public static final TagKey<Item> PUMPKINS = Items.cTag("pumpkins");
        public static final TagKey<Item> PUMPKINS_NORMAL = Items.cTag("pumpkins/normal");
        public static final TagKey<Item> PUMPKINS_CARVED = Items.cTag("pumpkins/carved");
        public static final TagKey<Item> PUMPKINS_JACK_O_LANTERNS = Items.cTag("pumpkins/jack_o_lanterns");
        public static final TagKey<Item> RAW_MATERIALS = Items.cTag("raw_materials");
        public static final TagKey<Item> RAW_MATERIALS_COPPER = Items.cTag("raw_materials/copper");
        public static final TagKey<Item> RAW_MATERIALS_GOLD = Items.cTag("raw_materials/gold");
        public static final TagKey<Item> RAW_MATERIALS_IRON = Items.cTag("raw_materials/iron");
        public static final TagKey<Item> RODS = Items.cTag("rods");
        public static final TagKey<Item> RODS_BLAZE = Items.cTag("rods/blaze");
        public static final TagKey<Item> RODS_BREEZE = Items.cTag("rods/breeze");
        public static final TagKey<Item> RODS_WOODEN = Items.cTag("rods/wooden");
        public static final TagKey<Item> ROPES = Items.cTag("ropes");
        public static final TagKey<Item> SANDSTONE_BLOCKS = Items.cTag("sandstone/blocks");
        public static final TagKey<Item> SANDSTONE_SLABS = Items.cTag("sandstone/slabs");
        public static final TagKey<Item> SANDSTONE_STAIRS = Items.cTag("sandstone/stairs");
        public static final TagKey<Item> SANDSTONE_RED_BLOCKS = Items.cTag("sandstone/red_blocks");
        public static final TagKey<Item> SANDSTONE_RED_SLABS = Items.cTag("sandstone/red_slabs");
        public static final TagKey<Item> SANDSTONE_RED_STAIRS = Items.cTag("sandstone/red_stairs");
        public static final TagKey<Item> SANDSTONE_UNCOLORED_BLOCKS = Items.cTag("sandstone/uncolored_blocks");
        public static final TagKey<Item> SANDSTONE_UNCOLORED_SLABS = Items.cTag("sandstone/uncolored_slabs");
        public static final TagKey<Item> SANDSTONE_UNCOLORED_STAIRS = Items.cTag("sandstone/uncolored_stairs");
        public static final TagKey<Item> SHULKER_BOXES = Items.cTag("shulker_boxes");
        public static final TagKey<Item> SLIME_BALLS = Items.cTag("slime_balls");
        public static final TagKey<Item> STONES = Items.cTag("stones");
        public static final TagKey<Item> STORAGE_BLOCKS = Items.cTag("storage_blocks");
        public static final TagKey<Item> STORAGE_BLOCKS_BONE_MEAL = Items.cTag("storage_blocks/bone_meal");
        public static final TagKey<Item> STORAGE_BLOCKS_COAL = Items.cTag("storage_blocks/coal");
        public static final TagKey<Item> STORAGE_BLOCKS_COPPER = Items.cTag("storage_blocks/copper");
        public static final TagKey<Item> STORAGE_BLOCKS_DIAMOND = Items.cTag("storage_blocks/diamond");
        public static final TagKey<Item> STORAGE_BLOCKS_DRIED_KELP = Items.cTag("storage_blocks/dried_kelp");
        public static final TagKey<Item> STORAGE_BLOCKS_EMERALD = Items.cTag("storage_blocks/emerald");
        public static final TagKey<Item> STORAGE_BLOCKS_GOLD = Items.cTag("storage_blocks/gold");
        public static final TagKey<Item> STORAGE_BLOCKS_IRON = Items.cTag("storage_blocks/iron");
        public static final TagKey<Item> STORAGE_BLOCKS_LAPIS = Items.cTag("storage_blocks/lapis");
        public static final TagKey<Item> STORAGE_BLOCKS_NETHERITE = Items.cTag("storage_blocks/netherite");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_COPPER = Items.cTag("storage_blocks/raw_copper");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_GOLD = Items.cTag("storage_blocks/raw_gold");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_IRON = Items.cTag("storage_blocks/raw_iron");
        public static final TagKey<Item> STORAGE_BLOCKS_REDSTONE = Items.cTag("storage_blocks/redstone");
        public static final TagKey<Item> STORAGE_BLOCKS_SLIME = Items.cTag("storage_blocks/slime");
        public static final TagKey<Item> STORAGE_BLOCKS_WHEAT = Items.cTag("storage_blocks/wheat");
        public static final TagKey<Item> STRINGS = Items.cTag("strings");
        public static final TagKey<Item> STRIPPED_LOGS = Items.cTag("stripped_logs");
        public static final TagKey<Item> STRIPPED_WOODS = Items.cTag("stripped_woods");
        public static final TagKey<Item> VILLAGER_JOB_SITES = Items.cTag("villager_job_sites");
        public static final TagKey<Item> TOOLS = Items.cTag("tools");
        public static final TagKey<Item> TOOLS_SHIELD = Items.cTag("tools/shield");
        public static final TagKey<Item> TOOLS_BOW = Items.cTag("tools/bow");
        public static final TagKey<Item> TOOLS_CROSSBOW = Items.cTag("tools/crossbow");
        public static final TagKey<Item> TOOLS_FISHING_ROD = Items.cTag("tools/fishing_rod");
        public static final TagKey<Item> TOOLS_SPEAR = Items.cTag("tools/spear");
        public static final TagKey<Item> TOOLS_SHEAR = Items.cTag("tools/shear");
        public static final TagKey<Item> TOOLS_BRUSH = Items.cTag("tools/brush");
        public static final TagKey<Item> TOOLS_IGNITER = Items.cTag("tools/igniter");
        public static final TagKey<Item> TOOLS_MACE = Items.cTag("tools/mace");
        public static final TagKey<Item> MELEE_WEAPON_TOOLS = Items.cTag("tools/melee_weapon");
        public static final TagKey<Item> RANGED_WEAPON_TOOLS = Items.cTag("tools/ranged_weapon");
        public static final TagKey<Item> MINING_TOOL_TOOLS = Items.cTag("tools/mining_tool");
        public static final TagKey<Item> ARMORS = Items.cTag("armors");
        public static final TagKey<Item> ENCHANTABLES = Items.cTag("enchantables");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> COBBLESTONE = COBBLESTONES;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> LEATHER = LEATHERS;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> SANDSTONE = SANDSTONE_BLOCKS;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> STONE = STONES;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> SHEARS = TOOLS_SHEAR;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> TOOLS_TRIDENTS = TOOLS_SPEAR;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> STRING = STRINGS;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS = Items.forgeTag("glass");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_BLACK = Items.forgeTag("glass/black");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_BLUE = Items.forgeTag("glass/blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_BROWN = Items.forgeTag("glass/brown");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_COLORLESS = Items.forgeTag("glass/colorless");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_CYAN = Items.forgeTag("glass/cyan");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_GRAY = Items.forgeTag("glass/gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_GREEN = Items.forgeTag("glass/green");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_LIGHT_BLUE = Items.forgeTag("glass/light_blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_LIGHT_GRAY = Items.forgeTag("glass/light_gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_LIME = Items.forgeTag("glass/lime");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_MAGENTA = Items.forgeTag("glass/magenta");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_ORANGE = Items.forgeTag("glass/orange");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PINK = Items.forgeTag("glass/pink");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PURPLE = Items.forgeTag("glass/purple");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_RED = Items.forgeTag("glass/red");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_WHITE = Items.forgeTag("glass/white");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_YELLOW = Items.forgeTag("glass/yellow");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> STAINED_GLASS = Items.forgeTag("stained_glass");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_BLACK = Items.forgeTag("glass_panes/black");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_BLUE = Items.forgeTag("glass_panes/blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_BROWN = Items.forgeTag("glass_panes/brown");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_CYAN = Items.forgeTag("glass_panes/cyan");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_GRAY = Items.forgeTag("glass_panes/gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_GREEN = Items.forgeTag("glass_panes/green");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_LIGHT_BLUE = Items.forgeTag("glass_panes/light_blue");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_LIGHT_GRAY = Items.forgeTag("glass_panes/light_gray");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_LIME = Items.forgeTag("glass_panes/lime");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_MAGENTA = Items.forgeTag("glass_panes/magenta");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_ORANGE = Items.forgeTag("glass_panes/orange");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_PINK = Items.forgeTag("glass_panes/pink");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_PURPLE = Items.forgeTag("glass_panes/purple");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_RED = Items.forgeTag("glass_panes/red");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_WHITE = Items.forgeTag("glass_panes/white");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> GLASS_PANES_YELLOW = Items.forgeTag("glass_panes/yellow");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> STAINED_GLASS_PANES = Items.forgeTag("stained_glass_panes");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> ARMORS_HELMETS = Items.forgeTag("armors/helmets");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> ARMORS_CHESTPLATES = Items.forgeTag("armors/chestplates");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> ARMORS_LEGGINGS = Items.forgeTag("armors/leggings");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Item> ARMORS_BOOTS = Items.forgeTag("armors/boots");

        private static void init() {
        }

        private static TagKey<Item> cTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Item> forgeTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> GASEOUS = Fluids.forgeTag("gaseous");
        public static final TagKey<Fluid> POTION = Fluids.forgeTag("potion");
        public static final TagKey<Fluid> SUSPICIOUS_STEW = Fluids.forgeTag("suspicious_stew");
        public static final TagKey<Fluid> MUSHROOM_STEW = Fluids.forgeTag("mushroom_stew");
        public static final TagKey<Fluid> RABBIT_STEW = Fluids.forgeTag("rabbit_stew");
        public static final TagKey<Fluid> BEETROOT_SOUP = Fluids.forgeTag("beetroot_soup");
        public static final TagKey<Fluid> WATER = Fluids.cTag("water");
        public static final TagKey<Fluid> LAVA = Fluids.cTag("lava");
        public static final TagKey<Fluid> MILK = Fluids.cTag("milk");
        public static final TagKey<Fluid> HONEY = Fluids.cTag("honey");
        public static final TagKey<Fluid> HIDDEN_FROM_RECIPE_VIEWERS = Fluids.cTag("hidden_from_recipe_viewers");

        private static void init() {
        }

        private static TagKey<Fluid> cTag(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Fluid> forgeTag(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
        }
    }

    public static class Enchantments {
        public static final TagKey<Enchantment> INCREASE_BLOCK_DROPS = Enchantments.cTag("increase_block_drops");
        public static final TagKey<Enchantment> INCREASE_ENTITY_DROPS = Enchantments.cTag("increase_entity_drops");
        public static final TagKey<Enchantment> WEAPON_DAMAGE_ENHANCEMENTS = Enchantments.cTag("weapon_damage_enhancements");
        public static final TagKey<Enchantment> ENTITY_SPEED_ENHANCEMENTS = Enchantments.cTag("entity_speed_enhancements");
        public static final TagKey<Enchantment> ENTITY_AUXILIARY_MOVEMENT_ENHANCEMENTS = Enchantments.cTag("entity_auxiliary_movement_enhancements");
        public static final TagKey<Enchantment> ENTITY_DEFENSE_ENHANCEMENTS = Enchantments.cTag("entity_defense_enhancements");

        private static void init() {
        }

        private static TagKey<Enchantment> cTag(String name) {
            return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> IS_COLD_NETHER = Biomes.forgeTag("is_cold/nether");
        public static final TagKey<Biome> IS_SPARSE_NETHER = Biomes.forgeTag("is_sparse/nether");
        public static final TagKey<Biome> IS_SPARSE_END = Biomes.forgeTag("is_sparse/end");
        public static final TagKey<Biome> IS_DENSE_NETHER = Biomes.forgeTag("is_dense/nether");
        public static final TagKey<Biome> IS_DENSE_END = Biomes.forgeTag("is_dense/end");
        public static final TagKey<Biome> IS_HOT_END = Biomes.forgeTag("is_hot/end");
        public static final TagKey<Biome> IS_LUSH = Biomes.forgeTag("is_lush");
        public static final TagKey<Biome> IS_MAGICAL = Biomes.forgeTag("is_magical");
        public static final TagKey<Biome> IS_MODIFIED = Biomes.forgeTag("is_modified");
        public static final TagKey<Biome> IS_RARE = Biomes.forgeTag("is_rare");
        public static final TagKey<Biome> IS_PLATEAU = Biomes.forgeTag("is_plateau");
        public static final TagKey<Biome> IS_SANDY = Biomes.forgeTag("is_sandy");
        public static final TagKey<Biome> IS_WET_NETHER = Biomes.forgeTag("is_wet/nether");
        public static final TagKey<Biome> IS_WET_END = Biomes.forgeTag("is_wet/end");
        public static final TagKey<Biome> IS_SPOOKY = Biomes.forgeTag("is_spooky");
        public static final TagKey<Biome> NO_DEFAULT_MONSTERS = Biomes.cTag("no_default_monsters");
        public static final TagKey<Biome> HIDDEN_FROM_LOCATOR_SELECTION = Biomes.cTag("hidden_from_locator_selection");
        public static final TagKey<Biome> IS_VOID = Biomes.cTag("is_void");
        public static final TagKey<Biome> IS_HOT = Biomes.cTag("is_hot");
        public static final TagKey<Biome> IS_HOT_OVERWORLD = Biomes.cTag("is_hot/overworld");
        public static final TagKey<Biome> IS_HOT_NETHER = Biomes.cTag("is_hot/nether");
        public static final TagKey<Biome> IS_COLD = Biomes.cTag("is_cold");
        public static final TagKey<Biome> IS_COLD_OVERWORLD = Biomes.cTag("is_cold/overworld");
        public static final TagKey<Biome> IS_COLD_END = Biomes.cTag("is_cold/end");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION = Biomes.cTag("is_sparse_vegetation");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_OVERWORLD = Biomes.cTag("is_sparse_vegetation/overworld");
        public static final TagKey<Biome> IS_DENSE_VEGETATION = Biomes.cTag("is_dense_vegetation");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_OVERWORLD = Biomes.cTag("is_dense_vegetation/overworld");
        public static final TagKey<Biome> IS_WET = Biomes.cTag("is_wet");
        public static final TagKey<Biome> IS_WET_OVERWORLD = Biomes.cTag("is_wet/overworld");
        public static final TagKey<Biome> IS_DRY = Biomes.cTag("is_dry");
        public static final TagKey<Biome> IS_DRY_OVERWORLD = Biomes.cTag("is_dry/overworld");
        public static final TagKey<Biome> IS_DRY_NETHER = Biomes.cTag("is_dry/nether");
        public static final TagKey<Biome> IS_DRY_END = Biomes.cTag("is_dry/end");
        public static final TagKey<Biome> IS_OVERWORLD = Biomes.cTag("is_overworld");
        public static final TagKey<Biome> IS_CONIFEROUS_TREE = Biomes.cTag("is_tree/coniferous");
        public static final TagKey<Biome> IS_SAVANNA_TREE = Biomes.cTag("is_tree/savanna");
        public static final TagKey<Biome> IS_JUNGLE_TREE = Biomes.cTag("is_tree/jungle");
        public static final TagKey<Biome> IS_DECIDUOUS_TREE = Biomes.cTag("is_tree/deciduous");
        public static final TagKey<Biome> IS_MOUNTAIN = Biomes.cTag("is_mountain");
        public static final TagKey<Biome> IS_MOUNTAIN_PEAK = Biomes.cTag("is_mountain/peak");
        public static final TagKey<Biome> IS_MOUNTAIN_SLOPE = Biomes.cTag("is_mountain/slope");
        public static final TagKey<Biome> IS_PLAINS = Biomes.cTag("is_plains");
        public static final TagKey<Biome> IS_SNOWY_PLAINS = Biomes.cTag("is_snowy_plains");
        public static final TagKey<Biome> IS_FOREST = Biomes.cTag("is_forest");
        public static final TagKey<Biome> IS_BIRCH_FOREST = Biomes.cTag("is_birch_forest");
        public static final TagKey<Biome> IS_FLOWER_FOREST = Biomes.cTag("is_flower_forest");
        public static final TagKey<Biome> IS_TAIGA = Biomes.cTag("is_taiga");
        public static final TagKey<Biome> IS_OLD_GROWTH = Biomes.cTag("is_old_growth");
        public static final TagKey<Biome> IS_HILL = Biomes.cTag("is_hill");
        public static final TagKey<Biome> IS_WINDSWEPT = Biomes.cTag("is_windswept");
        public static final TagKey<Biome> IS_JUNGLE = Biomes.cTag("is_jungle");
        public static final TagKey<Biome> IS_SAVANNA = Biomes.cTag("is_savanna");
        public static final TagKey<Biome> IS_SWAMP = Biomes.cTag("is_swamp");
        public static final TagKey<Biome> IS_DESERT = Biomes.cTag("is_desert");
        public static final TagKey<Biome> IS_BADLANDS = Biomes.cTag("is_badlands");
        public static final TagKey<Biome> IS_BEACH = Biomes.cTag("is_beach");
        public static final TagKey<Biome> IS_STONY_SHORES = Biomes.cTag("is_stony_shores");
        public static final TagKey<Biome> IS_MUSHROOM = Biomes.cTag("is_mushroom");
        public static final TagKey<Biome> IS_RIVER = Biomes.cTag("is_river");
        public static final TagKey<Biome> IS_OCEAN = Biomes.cTag("is_ocean");
        public static final TagKey<Biome> IS_DEEP_OCEAN = Biomes.cTag("is_deep_ocean");
        public static final TagKey<Biome> IS_SHALLOW_OCEAN = Biomes.cTag("is_shallow_ocean");
        public static final TagKey<Biome> IS_UNDERGROUND = Biomes.cTag("is_underground");
        public static final TagKey<Biome> IS_CAVE = Biomes.cTag("is_cave");
        public static final TagKey<Biome> IS_WASTELAND = Biomes.cTag("is_wasteland");
        public static final TagKey<Biome> IS_DEAD = Biomes.cTag("is_dead");
        public static final TagKey<Biome> IS_FLORAL = Biomes.cTag("is_floral");
        public static final TagKey<Biome> IS_SNOWY = Biomes.cTag("is_snowy");
        public static final TagKey<Biome> IS_ICY = Biomes.cTag("is_icy");
        public static final TagKey<Biome> IS_AQUATIC = Biomes.cTag("is_aquatic");
        public static final TagKey<Biome> IS_AQUATIC_ICY = Biomes.cTag("is_aquatic_icy");
        public static final TagKey<Biome> IS_NETHER = Biomes.cTag("is_nether");
        public static final TagKey<Biome> IS_NETHER_FOREST = Biomes.cTag("is_nether_forest");
        public static final TagKey<Biome> IS_END = Biomes.cTag("is_end");
        public static final TagKey<Biome> IS_OUTER_END_ISLAND = Biomes.cTag("is_outer_end_island");
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_SPARSE = IS_SPARSE_VEGETATION;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_SPARSE_OVERWORLD = IS_SPARSE_VEGETATION_OVERWORLD;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_DENSE = IS_DENSE_VEGETATION;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_DENSE_OVERWORLD = IS_DENSE_VEGETATION_OVERWORLD;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_WATER = IS_AQUATIC;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_SLOPE = IS_MOUNTAIN_SLOPE;
        @Deprecated(forRemoval=true, since="1.21")
        public static final TagKey<Biome> IS_PEAK = IS_MOUNTAIN_PEAK;

        private static void init() {
        }

        private static TagKey<Biome> cTag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Biome> forgeTag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
        }
    }

    public static class Structures {
        public static final TagKey<Structure> HIDDEN_FROM_DISPLAYERS = Structures.cTag("hidden_from_displayers");
        public static final TagKey<Structure> HIDDEN_FROM_LOCATOR_SELECTION = Structures.cTag("hidden_from_locator_selection");

        private static void init() {
        }

        private static TagKey<Structure> cTag(String name) {
            return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }
}

