/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import java.util.function.Consumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;

public sealed class LivingConversionEvent
extends LivingEvent
implements InheritableEvent {
    public static final EventBus<LivingConversionEvent> BUS = EventBus.create(LivingConversionEvent.class);

    public LivingConversionEvent(LivingEntity entity) {
        super(entity);
    }

    public static final class Post
    extends LivingConversionEvent {
        public static final EventBus<Post> BUS = EventBus.create(Post.class);
        private final LivingEntity outcome;

        public Post(LivingEntity entity, LivingEntity outcome) {
            super(entity);
            this.outcome = outcome;
        }

        public LivingEntity getOutcome() {
            return this.outcome;
        }
    }

    public static final class Pre
    extends LivingConversionEvent
    implements Cancellable {
        public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        private final EntityType<? extends LivingEntity> outcome;
        private final Consumer<Integer> timer;

        public Pre(LivingEntity entity, EntityType<? extends LivingEntity> outcome, Consumer<Integer> timer) {
            super(entity);
            this.outcome = outcome;
            this.timer = timer;
        }

        public EntityType<? extends LivingEntity> getOutcome() {
            return this.outcome;
        }

        public void setConversionTimer(int ticks) {
            this.timer.accept(ticks);
        }
    }
}

