/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.HasResult;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed class MobEffectEvent
extends LivingEvent {
    public static final EventBus<MobEffectEvent> BUS = EventBus.create(MobEffectEvent.class);
    @Nullable
    protected final MobEffectInstance effectInstance;

    public MobEffectEvent(LivingEntity living, MobEffectInstance effectInstance) {
        super(living);
        this.effectInstance = effectInstance;
    }

    @Nullable
    public MobEffectInstance getEffectInstance() {
        return this.effectInstance;
    }

    public static final class Expired
    extends MobEffectEvent {
        public static final EventBus<Expired> BUS = EventBus.create(Expired.class);

        public Expired(LivingEntity living, MobEffectInstance effect) {
            super(living, effect);
        }
    }

    public static final class Added
    extends MobEffectEvent {
        public static final EventBus<Added> BUS = EventBus.create(Added.class);
        private final MobEffectInstance oldEffectInstance;
        private final Entity source;

        public Added(LivingEntity living, MobEffectInstance oldEffectInstance, MobEffectInstance newEffectInstance, Entity source) {
            super(living, newEffectInstance);
            this.oldEffectInstance = oldEffectInstance;
            this.source = source;
        }

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance() {
            return super.getEffectInstance();
        }

        @Nullable
        public MobEffectInstance getOldEffectInstance() {
            return this.oldEffectInstance;
        }

        @Nullable
        public Entity getEffectSource() {
            return this.source;
        }
    }

    public static final class Applicable
    extends MobEffectEvent
    implements HasResult {
        public static final EventBus<Applicable> BUS = EventBus.create(Applicable.class);
        private Result result = Result.DEFAULT;

        public Applicable(LivingEntity living, @NotNull MobEffectInstance effectInstance) {
            super(living, effectInstance);
        }

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance() {
            return super.getEffectInstance();
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        @Override
        public void setResult(Result result) {
            this.result = result;
        }
    }

    public static final class Remove
    extends MobEffectEvent
    implements Cancellable {
        public static final CancellableEventBus<Remove> BUS = CancellableEventBus.create(Remove.class);
        private final MobEffect effect;

        public Remove(LivingEntity living, MobEffect effect) {
            super(living, living.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect)));
            this.effect = effect;
        }

        public Remove(LivingEntity living, MobEffectInstance effectInstance) {
            super(living, effectInstance);
            this.effect = (MobEffect)effectInstance.getEffect().get();
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        @Override
        @Nullable
        public MobEffectInstance getEffectInstance() {
            return super.getEffectInstance();
        }
    }
}

