/*
 * Decompiled with CFR 0.152.
 */
package org.cservenak.streams;

import java.io.IOException;
import java.io.InputStream;
import org.cservenak.streams.Coder;
import org.cservenak.streams.CoderThread;

public class CoderInputStream
extends InputStream {
    private final CoderThread ct;
    private volatile InputStream in;

    protected CoderInputStream(InputStream in, Coder coder) throws IOException {
        this.ct = new CoderThread(coder, in);
        this.in = this.ct.getInputStreamSink();
        this.ct.start();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        try {
            this.ct.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.ct.checkForException();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

