/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.ModStateManager;
import net.minecraftforge.fml.ModWorkManager;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModIdentifier;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.locating.ForgeFeature;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LoadingModList loadingModList;
    private final List<ModLoadingException> loadingExceptions;
    private final Set<IModInfo> erroredModInfos;
    private final List<ModLoadingWarning> loadingWarnings;
    private final ModStateManager stateManager;
    private static boolean loadingStateValid;
    private final Consumer<String> statusConsumer = StartupNotificationManager.modLoaderConsumer().orElse(msg -> {});
    private final Set<IModLoadingState> completedStates = new HashSet<IModLoadingState>();
    private ModList modList;
    private static boolean runningDataGen;

    private ModLoader() {
        this.loadingModList = FMLLoader.getLoadingModList();
        this.loadingExceptions = this.loadingModList.getErrors().stream().flatMap(ModLoadingException::fromEarlyException).collect(Collectors.toList());
        this.loadingWarnings = this.loadingModList.getBrokenFiles().stream().map(file -> new ModLoadingWarning(null, ModLoadingStage.VALIDATE, InvalidModIdentifier.identifyJarProblem((Path)file.getFilePath()).orElse("fml.modloading.brokenfile"), file.getFileName())).collect(Collectors.toList());
        if (this.loadingExceptions.isEmpty()) {
            this.erroredModInfos = Collections.emptySet();
        } else {
            this.erroredModInfos = Collections.newSetFromMap(new IdentityHashMap());
            this.erroredModInfos.addAll(this.loadingExceptions.stream().map(ModLoadingException::getModInfo).toList());
        }
        this.loadingModList.getModFiles().stream().filter(ModFileInfo::missingLicense).filter(modFileInfo -> modFileInfo.getMods().stream().noneMatch(this.erroredModInfos::contains)).map(modFileInfo -> new ModLoadingException(null, ModLoadingStage.VALIDATE, "fml.modloading.missinglicense", null, modFileInfo.getFile())).forEach(this.loadingExceptions::add);
        this.stateManager = new ModStateManager();
        CrashReportCallables.registerCrashCallable("ModLauncher", FMLLoader::getLauncherInfo);
        CrashReportCallables.registerCrashCallable("ModLauncher launch target", FMLLoader::launcherHandlerName);
        CrashReportCallables.registerCrashCallable("ModLauncher naming", FMLLoader::getNaming);
        CrashReportCallables.registerCrashCallable("ModLauncher services", ModLoader::computeModLauncherServiceList);
        CrashReportCallables.registerCrashCallable("FML Language Providers", ModLoader::computeLanguageList);
    }

    private static String computeLanguageList() {
        return "\n" + FMLLoader.getLanguageLoadingProvider().applyForEach(lp -> lp.name() + "@" + lp.getClass().getPackage().getImplementationVersion()).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    private static String computeModLauncherServiceList() {
        List mods = FMLLoader.modLauncherModList();
        return "\n" + mods.stream().map(mod -> mod.getOrDefault("file", "nofile") + " " + mod.getOrDefault("name", "missing") + " " + mod.getOrDefault("type", "NOTYPE") + " " + mod.getOrDefault("description", "")).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    public static ModLoader get() {
        return LazyInit.INSTANCE;
    }

    public void gatherAndInitializeMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        ForgeFeature.registerFeature((String)"javaVersion", (ForgeFeature.IFeatureTest)ForgeFeature.VersionFeatureTest.forVersionString((IModInfo.DependencySide)IModInfo.DependencySide.BOTH, (String)System.getProperty("java.version")));
        ForgeFeature.registerFeature((String)"openGLVersion", (ForgeFeature.IFeatureTest)ForgeFeature.VersionFeatureTest.forVersionString((IModInfo.DependencySide)IModInfo.DependencySide.CLIENT, (String)ImmediateWindowHandler.getGLVersion()));
        loadingStateValid = true;
        FMLLoader.backgroundScanHandler.waitForScanToComplete(periodicTask);
        ModList modList = ModList.of(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).toList(), this.loadingModList.getMods());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Error during pre-loading phase", (Throwable)this.loadingExceptions.getFirst());
            this.statusConsumer.accept("ERROR DURING MOD LOADING");
            modList.setLoadedMods(Collections.emptyList());
            loadingStateValid = false;
            throw new LoadingFailedException(this.loadingExceptions);
        }
        ArrayList<ForgeFeature.Bound> failedBounds = new ArrayList<ForgeFeature.Bound>();
        for (Object mod : this.loadingModList.getMods()) {
            for (ForgeFeature.Bound feature : mod.getForgeFeatures()) {
                if (ForgeFeature.testFeature((Dist)FMLEnvironment.dist, (ForgeFeature.Bound)feature)) continue;
                failedBounds.add(feature);
            }
        }
        if (!failedBounds.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to validate feature bounds for mods: {}", failedBounds);
            this.statusConsumer.accept("ERROR DURING MOD LOADING");
            modList.setLoadedMods(Collections.emptyList());
            loadingStateValid = false;
            throw new LoadingFailedException(failedBounds.stream().map(fb -> new ModLoadingException(fb.modInfo(), ModLoadingStage.CONSTRUCT, "fml.modloading.feature.missing", null, fb, ForgeFeature.featureValue((ForgeFeature.Bound)fb))).toList());
        }
        HashMap<String, ModContainer> modContainers = new HashMap<String, ModContainer>();
        for (ModFileInfo file : this.loadingModList.getModFiles()) {
            List<ModContainer> containers = this.buildMods((IModFile)file.getFile());
            for (ModContainer container : containers) {
                modContainers.put(container.getModId(), container);
            }
        }
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to initialize mod containers", (Throwable)this.loadingExceptions.getFirst());
            this.statusConsumer.accept("ERROR DURING MOD LOADING");
            modList.setLoadedMods(Collections.emptyList());
            loadingStateValid = false;
            throw new LoadingFailedException(this.loadingExceptions);
        }
        for (ModContainer mod : modContainers.values()) {
            for (IModInfo.ModVersion dep : mod.getModInfo().getDependencies()) {
                ModContainer target = (ModContainer)modContainers.get(dep.getModId());
                if (target == null) continue;
                switch (dep.getOrdering()) {
                    case AFTER: {
                        mod.dependencies.add(target);
                        break;
                    }
                    case BEFORE: {
                        target.dependencies.add(mod);
                        break;
                    }
                }
            }
        }
        modList.setLoadedMods(modContainers.values().stream().toList());
        this.modList = modList;
        List<IModLoadingState> stateList = this.stateManager.getStates(ModLoadingPhase.GATHER);
        ProgressMeter progress = StartupMessageManager.addProgressBar("Mod Gather", stateList.stream().mapToInt(mls -> mls.size().applyAsInt(this.modList)).sum());
        for (IModLoadingState mls2 : stateList) {
            this.dispatchAndHandleError(mls2, syncExecutor, parallelExecutor, periodicTask, progress);
        }
        progress.complete();
    }

    public void loadMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        List<IModLoadingState> stateList = this.stateManager.getStates(ModLoadingPhase.LOAD);
        ProgressMeter progress = StartupMessageManager.addProgressBar("Mod Loading", stateList.stream().mapToInt(mls -> mls.size().applyAsInt(this.modList)).sum());
        for (IModLoadingState mls2 : stateList) {
            this.dispatchAndHandleError(mls2, syncExecutor, parallelExecutor, periodicTask, progress);
        }
        progress.complete();
    }

    public void finishMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        List<IModLoadingState> stateList = this.stateManager.getStates(ModLoadingPhase.COMPLETE);
        ProgressMeter progress = StartupMessageManager.addProgressBar("Mod Complete", stateList.stream().mapToInt(mls -> mls.size().applyAsInt(this.modList)).sum());
        for (IModLoadingState mls2 : stateList) {
            this.dispatchAndHandleError(mls2, syncExecutor, parallelExecutor, periodicTask, progress);
        }
        this.statusConsumer.accept(String.format("Mod loading complete - %d mods loaded", this.modList.size()));
        progress.complete();
    }

    private void dispatchAndHandleError(IModLoadingState state, ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable ticker, ProgressMeter progressBar) {
        CompletableFuture transition;
        if (!ModLoader.isLoadingStateValid()) {
            LOGGER.error("Cowardly refusing to process mod state change request from {}", (Object)state);
            return;
        }
        progressBar.label(progressBar.name() + " working");
        syncExecutor.drive(ticker);
        Consumer inlineRunnable = state.inlineRunnable().orElse(null);
        if (inlineRunnable != null) {
            this.handleInlineTransition(inlineRunnable, state, syncExecutor, ticker);
        }
        if ((transition = (CompletableFuture)state.buildTransition(syncExecutor, parallelExecutor, progressBar).orElse(null)) != null) {
            this.waitForTransition(state, syncExecutor, ticker, transition);
        }
        this.completedStates.add(state);
    }

    private void handleInlineTransition(Consumer<ModList> transition, IModLoadingState state, ModWorkManager.DrivenExecutor syncExecutor, Runnable ticker) {
        ProgressMeter pb = StartupMessageManager.addProgressBar("State transition " + state.name() + " running", 0);
        syncExecutor.drive(ticker);
        transition.accept(this.modList);
        syncExecutor.drive(ticker);
        pb.complete();
        syncExecutor.drive(ticker);
    }

    private void waitForTransition(IModLoadingState state, ModWorkManager.DrivenExecutor syncExecutor, Runnable ticker, CompletableFuture<Void> transition) {
        while (!transition.isDone()) {
            syncExecutor.drive(ticker);
        }
        try {
            transition.join();
        }
        catch (CompletionException e) {
            loadingStateValid = false;
            Throwable t = e.getCause();
            boolean hasNotModLoadingEx = Arrays.stream(t.getSuppressed()).anyMatch(obj -> !(obj instanceof ModLoadingException));
            if (hasNotModLoadingEx) {
                LOGGER.fatal("Encountered non-modloading exceptions!", (Throwable)e);
                this.statusConsumer.accept("ERROR DURING MOD LOADING");
                throw e;
            }
            List<ModLoadingException> modLoadingExceptions = Arrays.stream(t.getSuppressed()).filter(ModLoadingException.class::isInstance).map(ModLoadingException.class::cast).toList();
            LOGGER.fatal(Logging.LOADING, "Failed to complete lifecycle event {}, {} errors found", (Object)state.name(), (Object)modLoadingExceptions.size());
            this.statusConsumer.accept("ERROR DURING MOD LOADING");
            throw new LoadingFailedException(modLoadingExceptions);
        }
    }

    private List<ModContainer> buildMods(IModFile modFile) {
        HashMap<String, IModInfo> modInfoMap = new HashMap<String, IModInfo>();
        for (Object mod : modFile.getModFileInfo().getMods()) {
            modInfoMap.put(mod.getModId(), (IModInfo)mod);
        }
        LOGGER.trace(Logging.LOADING, "ModContainer is {}", (Object)ModContainer.class.getClassLoader());
        ArrayList<ModContainer> containers = new ArrayList<ModContainer>();
        for (Map.Entry entry : modFile.getScanResult().getTargets().entrySet()) {
            ModContainer container = this.buildModContainerFromTOML(modFile, modInfoMap, (String)entry.getKey(), (IModLanguageProvider.IModLanguageLoader)entry.getValue());
            if (container == null) continue;
            containers.add(container);
        }
        if (containers.size() != modInfoMap.size()) {
            List<String> modIds = modInfoMap.values().stream().map(IModInfo::getModId).sorted().toList();
            List<String> list = containers.stream().map(c -> c != null ? c.getModId() : "(null)").sorted().toList();
            LOGGER.fatal(Logging.LOADING, "File {} constructed {} mods: {}, but had {} mods specified: {}", (Object)modFile.getFilePath(), (Object)containers.size(), list, (Object)modInfoMap.size(), modIds);
            ArrayList<String> missingClasses = new ArrayList<String>(modIds);
            missingClasses.removeAll(list);
            LOGGER.fatal(Logging.LOADING, "The following classes are missing, but are reported in the mods.toml: {}", missingClasses);
            ArrayList<String> missingMods = new ArrayList<String>(list);
            missingMods.removeAll(modIds);
            LOGGER.fatal(Logging.LOADING, "The following mods are missing, but have classes in the jar: {}", missingMods);
            this.loadingExceptions.add(new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingclasses", null, modFile.getFilePath()));
        }
        return containers.stream().filter(mc -> mc.modLoadingStage != ModLoadingStage.ERROR).toList();
    }

    private ModContainer buildModContainerFromTOML(IModFile modFile, Map<String, IModInfo> modInfoMap, String modId, IModLanguageProvider.IModLanguageLoader languageLoader) {
        try {
            IModInfo info = modInfoMap.get(modId);
            if (info == null) {
                throw new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingmetadata", null, modId);
            }
            return (ModContainer)languageLoader.loadMod(info, modFile.getScanResult(), FMLLoader.getGameLayer());
        }
        catch (ModLoadingException mle) {
            this.loadingExceptions.add(mle);
            return new ErroredModContainer();
        }
    }

    public static boolean isLoadingStateValid() {
        return loadingStateValid;
    }

    public boolean hasCompletedState(String stateName) {
        IModLoadingState state = this.stateManager.findState(stateName);
        return this.completedStates.contains(state);
    }

    public <T extends IModBusEvent> void runEventGenerator(Function<ModContainer, T> generator) {
        if (!loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event generator to a broken mod state");
            return;
        }
        for (ModContainer mod : ModList.get().getLoadedMods()) {
            mod.acceptEvent((IModBusEvent)generator.apply(mod));
        }
    }

    public <T extends IModBusEvent> void postEvent(T e) {
        Class<?> cls = e.getClass();
        if (!loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        for (ModContainer mod : ModList.get().getLoadedMods()) {
            mod.acceptEvent(e);
        }
    }

    public <T extends IModBusEvent> T postEventWithReturn(T e) {
        if (!loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return e;
        }
        for (ModContainer mod : ModList.get().getLoadedMods()) {
            mod.acceptEvent(e);
        }
        return e;
    }

    public <T extends IModBusEvent> void postEventWrapContainerInModOrder(T event) {
        this.postEventWithWrapInModOrder(event, (mc, e) -> ModLoadingContext.get().setActiveContainer((ModContainer)mc), (mc, e) -> ModLoadingContext.get().setActiveContainer(null));
    }

    public <T extends IModBusEvent> void postEventWithWrapInModOrder(T e, BiConsumer<ModContainer, T> pre, BiConsumer<ModContainer, T> post) {
        if (!loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        for (ModContainer mod : ModList.get().getLoadedMods()) {
            pre.accept(mod, (ModContainer)((Object)e));
            mod.acceptEvent(e);
            post.accept(mod, (ModContainer)((Object)e));
        }
    }

    public List<ModLoadingWarning> getWarnings() {
        return ImmutableList.copyOf(this.loadingWarnings);
    }

    public void addWarning(ModLoadingWarning warning) {
        this.loadingWarnings.add(warning);
    }

    public static boolean isDataGenRunning() {
        return runningDataGen;
    }

    static {
        runningDataGen = false;
    }

    private static final class LazyInit {
        private static final ModLoader INSTANCE = new ModLoader();

        private LazyInit() {
        }
    }

    private static final class ErroredModContainer
    extends ModContainer {
        @Override
        public boolean matches(Object mod) {
            return false;
        }

        @Override
        public Object getMod() {
            return null;
        }
    }
}

