// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// CIAppCIErrorDomain Error category used to differentiate between issues related to the developer or provider environments.
type CIAppCIErrorDomain string

// List of CIAppCIErrorDomain.
const (
	CIAPPCIERRORDOMAIN_PROVIDER CIAppCIErrorDomain = "provider"
	CIAPPCIERRORDOMAIN_USER     CIAppCIErrorDomain = "user"
	CIAPPCIERRORDOMAIN_UNKNOWN  CIAppCIErrorDomain = "unknown"
)

var allowedCIAppCIErrorDomainEnumValues = []CIAppCIErrorDomain{
	CIAPPCIERRORDOMAIN_PROVIDER,
	CIAPPCIERRORDOMAIN_USER,
	CIAPPCIERRORDOMAIN_UNKNOWN,
}

// GetAllowedValues reeturns the list of possible values.
func (v *CIAppCIErrorDomain) GetAllowedValues() []CIAppCIErrorDomain {
	return allowedCIAppCIErrorDomainEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *CIAppCIErrorDomain) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = CIAppCIErrorDomain(value)
	return nil
}

// NewCIAppCIErrorDomainFromValue returns a pointer to a valid CIAppCIErrorDomain
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewCIAppCIErrorDomainFromValue(v string) (*CIAppCIErrorDomain, error) {
	ev := CIAppCIErrorDomain(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for CIAppCIErrorDomain: valid values are %v", v, allowedCIAppCIErrorDomainEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v CIAppCIErrorDomain) IsValid() bool {
	for _, existing := range allowedCIAppCIErrorDomainEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to CIAppCIErrorDomain value.
func (v CIAppCIErrorDomain) Ptr() *CIAppCIErrorDomain {
	return &v
}
