/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.MediaSources;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpReceiver;
import org.jitsi.nlj.RtpReceiverImpl;
import org.jitsi.nlj.RtpSender;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.Stoppable;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketIOActivity;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.nlj.util.StreamInformationStoreImpl;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u008c\u00012\u00020\u0001:\u0002\u008c\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u00102\u001a\u00020-J\u0006\u00103\u001a\u00020-J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020=J\u001c\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010E\u001a\u00020AJ\u000e\u0010F\u001a\u00020;2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020;2\u0006\u0010J\u001a\u00020HJ\u0016\u0010K\u001a\u00020;2\u0006\u0010L\u001a\u00020D2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020;2\u0006\u0010L\u001a\u00020DJ\u0016\u0010P\u001a\u00020;2\u0006\u0010M\u001a\u00020N2\u0006\u0010L\u001a\u00020DJ\u000e\u0010Q\u001a\u00020;2\u0006\u0010R\u001a\u00020SJ\u000e\u0010T\u001a\u00020-2\u0006\u0010L\u001a\u00020DJ\u0019\u0010Y\u001a\u00020-2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020[0Z\u00a2\u0006\u0002\u0010\\J\u0011\u0010]\u001a\b\u0012\u0004\u0012\u00020[0Z\u00a2\u0006\u0002\u0010^J\u0019\u0010_\u001a\u00020;2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010DH\u0007\u00a2\u0006\u0002\u0010aJ\u000e\u0010b\u001a\u00020;2\u0006\u0010c\u001a\u00020dJ\u0006\u0010e\u001a\u00020;J\u000e\u0010f\u001a\u00020;2\u0006\u0010g\u001a\u00020hJ\u0006\u0010i\u001a\u00020;J\u000e\u0010j\u001a\u00020;2\u0006\u0010k\u001a\u00020-J\u000e\u0010l\u001a\u00020;2\u0006\u0010m\u001a\u00020nJ&\u0010o\u001a\u00020;2\u0006\u0010p\u001a\u00020A2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020-J\u0018\u0010v\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u0010w\u001a\u00020-H\u0002J\u000e\u0010o\u001a\u00020;2\u0006\u0010&\u001a\u00020'J\u000e\u0010x\u001a\u00020;2\u0006\u0010y\u001a\u00020-J\u000e\u0010z\u001a\u00020;2\u0006\u0010y\u001a\u00020-J\u000e\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020~J\u0007\u0010\u007f\u001a\u00030\u0080\u0001J\u0011\u0010\u0081\u0001\u001a\u00020;2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u0011\u0010\u0084\u0001\u001a\u00020;2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\t\u0010\u0085\u0001\u001a\u00020;H\u0016J\u0007\u0010\u0086\u0001\u001a\u00020;J\u001a\u0010\u0087\u0001\u001a\u00020;2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020-J\u0011\u0010\u008b\u0001\u001a\u00020-2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020D0V8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\u00a8\u0006\u008d\u0001"}, d2={"Lorg/jitsi/nlj/Transceiver;", "Lorg/jitsi/nlj/Stoppable;", "id", "", "receiverExecutor", "Ljava/util/concurrent/ExecutorService;", "senderExecutor", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "eventHandler", "Lorg/jitsi/nlj/TransceiverEventHandler;", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/nlj/TransceiverEventHandler;Ljava/time/Clock;)V", "logger", "packetIOActivity", "Lorg/jitsi/nlj/stats/PacketIOActivity;", "getPacketIOActivity", "()Lorg/jitsi/nlj/stats/PacketIOActivity;", "endpointConnectionStats", "Lorg/jitsi/nlj/stats/EndpointConnectionStats;", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStoreImpl;", "readOnlyStreamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "getReadOnlyStreamInformationStore", "()Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "getRtcpEventNotifier", "()Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "mediaSources", "Lorg/jitsi/nlj/MediaSources;", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "getSrtpTransformers", "()Lorg/jitsi/nlj/srtp/SrtpTransformers;", "setSrtpTransformers", "(Lorg/jitsi/nlj/srtp/SrtpTransformers;)V", "internalTransformers", "", "getInternalTransformers", "()Z", "setInternalTransformers", "(Z)V", "isReceivingAudio", "isReceivingVideo", "rtpSender", "Lorg/jitsi/nlj/RtpSender;", "getRtpSender", "()Lorg/jitsi/nlj/RtpSender;", "rtpReceiver", "Lorg/jitsi/nlj/RtpReceiver;", "handleIncomingPacket", "", "p", "Lorg/jitsi/nlj/PacketInfo;", "sendPacket", "packetInfo", "sendProbing", "", "mediaSsrcs", "", "", "numBytes", "setIncomingPacketHandler", "rtpHandler", "Lorg/jitsi/nlj/PacketHandler;", "setOutgoingPacketHandler", "outgoingPacketHandler", "addReceiveSsrc", "ssrc", "mediaType", "Lorg/jitsi/utils/MediaType;", "removeReceiveSsrc", "setLocalSsrc", "addRtpExtensionToRetain", "extensionType", "Lorg/jitsi/nlj/rtp/RtpExtensionType;", "receivesSsrc", "receiveSsrcs", "", "getReceiveSsrcs", "()Ljava/util/Set;", "setMediaSources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "([Lorg/jitsi/nlj/MediaSourceDesc;)Z", "getMediaSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "requestKeyFrame", "mediaSsrc", "(Ljava/lang/Long;)V", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "clearPayloadTypes", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "clearRtpExtensions", "setExtmapAllowMixed", "allow", "addSsrcAssociation", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "setSrtpInformation", "chosenSrtpProtectionProfile", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "cryptex", "setSrtpInformationInternal", "internal", "forceMuteAudio", "shouldMute", "forceMuteVideo", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "getTransceiverStats", "Lorg/jitsi/nlj/stats/TransceiverStats;", "addEndpointConnectionStatsListener", "listener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "removeEndpointConnectionStatsListener", "stop", "teardown", "setFeature", "feature", "Lorg/jitsi/nlj/Features;", "enabled", "isFeatureEnabled", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nTransceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transceiver.kt\norg/jitsi/nlj/Transceiver\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,393:1\n63#2,4:394\n57#2,4:398\n63#2,4:402\n63#2,4:406\n57#2,4:410\n63#2,4:414\n57#2,4:418\n63#2,4:422\n63#2,4:426\n1#3:430\n*S KotlinDebug\n*F\n+ 1 Transceiver.kt\norg/jitsi/nlj/Transceiver\n*L\n196#1:394,4\n201#1:398,4\n224#1:402,4\n240#1:406,4\n245#1:410,4\n250#1:414,4\n255#1:418,4\n270#1:422,4\n285#1:426,4\n*E\n"})
public final class Transceiver
implements Stoppable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final TransceiverEventHandler eventHandler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PacketIOActivity packetIOActivity;
    @NotNull
    private final EndpointConnectionStats endpointConnectionStats;
    @NotNull
    private final StreamInformationStoreImpl streamInformationStore;
    @NotNull
    private final ReadOnlyStreamInformationStore readOnlyStreamInformationStore;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private MediaSources mediaSources;
    @Nullable
    private SrtpTransformers srtpTransformers;
    private boolean internalTransformers;
    @NotNull
    private final RtpSender rtpSender;
    @NotNull
    private final RtpReceiver rtpReceiver;

    public Transceiver(@NotNull String id, @NotNull ExecutorService receiverExecutor, @NotNull ExecutorService senderExecutor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, @NotNull TransceiverEventHandler eventHandler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)receiverExecutor, (String)"receiverExecutor");
        Intrinsics.checkNotNullParameter((Object)senderExecutor, (String)"senderExecutor");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.id = id;
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.packetIOActivity = new PacketIOActivity();
        this.endpointConnectionStats = new EndpointConnectionStats(this.logger, null, 2, null);
        this.streamInformationStore = new StreamInformationStoreImpl();
        this.readOnlyStreamInformationStore = this.streamInformationStore;
        this.rtcpEventNotifier = new RtcpEventNotifier();
        this.mediaSources = new MediaSources();
        this.rtpSender = new RtpSenderImpl(this.id, this.rtcpEventNotifier, senderExecutor, backgroundExecutor, this.streamInformationStore, this.logger, diagnosticContext);
        this.rtpReceiver = new RtpReceiverImpl(this.id, (Function1<? super RtcpPacket, Unit>)((Function1)arg_0 -> Transceiver.rtpReceiver$lambda$0(this, arg_0)), this.rtcpEventNotifier, receiverExecutor, backgroundExecutor, this.streamInformationStore, this.eventHandler, this.logger, diagnosticContext);
        this.rtpSender.addBandwidthListener(new TransportCcEngine.BandwidthListener(){

            @Override
            public void bandwidthEstimationChanged-_2icLw0(long l) {
                eventHandler.bandwidthEstimationChanged-_2icLw0(l);
            }
        });
        this.rtpReceiver.addLossListener(this.endpointConnectionStats.getIncomingLossTracker());
        this.rtpSender.addLossListener(this.endpointConnectionStats.getOutgoingLossTracker());
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.endpointConnectionStats, false, 2, null);
        this.endpointConnectionStats.addListener(this.rtpSender);
        this.endpointConnectionStats.addListener(this.rtpReceiver);
    }

    public /* synthetic */ Transceiver(String string, ExecutorService executorService, ExecutorService executorService2, ScheduledExecutorService scheduledExecutorService, DiagnosticContext diagnosticContext, Logger logger, TransceiverEventHandler transceiverEventHandler, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(string, executorService, executorService2, scheduledExecutorService, diagnosticContext, logger, transceiverEventHandler, clock);
    }

    @NotNull
    public final PacketIOActivity getPacketIOActivity() {
        return this.packetIOActivity;
    }

    @NotNull
    public final ReadOnlyStreamInformationStore getReadOnlyStreamInformationStore() {
        return this.readOnlyStreamInformationStore;
    }

    @NotNull
    public final RtcpEventNotifier getRtcpEventNotifier() {
        return this.rtcpEventNotifier;
    }

    @Nullable
    public final SrtpTransformers getSrtpTransformers() {
        return this.srtpTransformers;
    }

    public final void setSrtpTransformers(@Nullable SrtpTransformers srtpTransformers) {
        this.srtpTransformers = srtpTransformers;
    }

    public final boolean getInternalTransformers() {
        return this.internalTransformers;
    }

    public final void setInternalTransformers(boolean bl) {
        this.internalTransformers = bl;
    }

    public final boolean isReceivingAudio() {
        return this.rtpReceiver.isReceivingAudio();
    }

    public final boolean isReceivingVideo() {
        return this.rtpReceiver.isReceivingVideo();
    }

    @NotNull
    public final RtpSender getRtpSender() {
        return this.rtpSender;
    }

    public final void handleIncomingPacket(@NotNull PacketInfo p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        this.packetIOActivity.setLastRtpPacketReceivedInstant(instant);
        this.rtpReceiver.enqueuePacket(p);
    }

    public final void sendPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        this.packetIOActivity.setLastRtpPacketSentInstant(instant);
        this.rtpSender.processPacket(packetInfo);
    }

    public final int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
        Intrinsics.checkNotNullParameter(mediaSsrcs, (String)"mediaSsrcs");
        return this.rtpSender.sendProbing(mediaSsrcs, numBytes);
    }

    public final void setIncomingPacketHandler(@NotNull PacketHandler rtpHandler) {
        Intrinsics.checkNotNullParameter((Object)rtpHandler, (String)"rtpHandler");
        this.rtpReceiver.setPacketHandler(rtpHandler);
    }

    public final void setOutgoingPacketHandler(@NotNull PacketHandler outgoingPacketHandler) {
        Intrinsics.checkNotNullParameter((Object)outgoingPacketHandler, (String)"outgoingPacketHandler");
        this.rtpSender.onOutgoingPacket(outgoingPacketHandler);
    }

    public final void addReceiveSsrc(long ssrc, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)(this.hashCode() + " adding receive ssrc " + ssrc + " of type " + mediaType));
        }
        this.streamInformationStore.addReceiveSsrc(ssrc, mediaType);
    }

    public final void removeReceiveSsrc(long ssrc) {
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info((Object)("Transceiver " + this.hashCode() + " removing receive ssrc " + ssrc));
        }
        this.streamInformationStore.removeReceiveSsrc(ssrc);
    }

    public final void setLocalSsrc(@NotNull MediaType mediaType, long ssrc) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        SetLocalSsrcEvent localSsrcSetEvent = new SetLocalSsrcEvent(mediaType, ssrc);
        this.rtpSender.handleEvent(localSsrcSetEvent);
        this.rtpReceiver.handleEvent(localSsrcSetEvent);
    }

    public final void addRtpExtensionToRetain(@NotNull RtpExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionType), (String)"extensionType");
        this.rtpSender.addRtpExtensionToRetain(extensionType);
    }

    public final boolean receivesSsrc(long ssrc) {
        return this.streamInformationStore.getReceiveSsrcs().contains(ssrc);
    }

    @NotNull
    public final Set<Long> getReceiveSsrcs() {
        return this.streamInformationStore.getReceiveSsrcs();
    }

    public final boolean setMediaSources(@NotNull MediaSourceDesc[] mediaSources) {
        Intrinsics.checkNotNullParameter((Object)mediaSources, (String)"mediaSources");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)(this.id + " setting media sources: " + ArraysKt.joinToString$default((Object[])mediaSources, null, null, null, (int)0, null, null, (int)63, null)));
        }
        boolean ret = this.mediaSources.setMediaSources(mediaSources);
        MediaSourceDesc[] mergedMediaSources = this.mediaSources.getMediaSources();
        MediaSourceDesc[] signaledMediaSources = MediaSourceDescKt.copy(mediaSources);
        this.rtpReceiver.handleEvent(new SetMediaSourcesEvent(mergedMediaSources, signaledMediaSources));
        return ret;
    }

    @NotNull
    public final MediaSourceDesc[] getMediaSources() {
        return this.mediaSources.getMediaSources();
    }

    @JvmOverloads
    public final void requestKeyFrame(@Nullable Long mediaSsrc) {
        this.rtpSender.requestKeyframe(mediaSsrc);
    }

    public static /* synthetic */ void requestKeyFrame$default(Transceiver transceiver, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        transceiver.requestKeyFrame(l);
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter((Object)payloadType, (String)"payloadType");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Payload type added: " + payloadType));
        }
        this.streamInformationStore.addRtpPayloadType(payloadType);
    }

    public final void clearPayloadTypes() {
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info((Object)"All payload types being cleared");
        }
        this.streamInformationStore.clearRtpPayloadTypes();
    }

    public final void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter((Object)rtpExtension, (String)"rtpExtension");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Adding RTP extension: " + rtpExtension));
        }
        this.streamInformationStore.addRtpExtensionMapping(rtpExtension);
    }

    public final void clearRtpExtensions() {
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info((Object)"Clearing all RTP extensions");
        }
    }

    public final void setExtmapAllowMixed(boolean allow) {
        this.streamInformationStore.setExtmapAllowMixed(allow);
    }

    public final void addSsrcAssociation(@NotNull SsrcAssociation ssrcAssociation) {
        Intrinsics.checkNotNullParameter((Object)ssrcAssociation, (String)"ssrcAssociation");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            String location = ssrcAssociation instanceof LocalSsrcAssociation ? "local" : "remote";
            logger.debug((Object)("Adding " + location + " SSRC association: " + ssrcAssociation));
        }
        this.streamInformationStore.addSsrcAssociation(ssrcAssociation);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSrtpInformation(int chosenSrtpProtectionProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial, boolean cryptex) {
        void it;
        SrtpTransformers srtpTransformers;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), (String)"tlsRole");
        Intrinsics.checkNotNullParameter((Object)keyingMaterial, (String)"keyingMaterial");
        SrtpProfileInformation srtpProfileInfo = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(chosenSrtpProtectionProfile);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug22 = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            object = $this$cdebug$iv;
            boolean bl = false;
            object.debug((Object)("Transceiver " + this.id + " creating transformers with:\nprofile info:\n" + srtpProfileInfo + "\ntls role: " + tlsRole + "\ncryptex: " + cryptex));
        }
        SrtpTransformers $i$f$cdebug22 = srtpTransformers = SrtpUtil.Companion.initializeTransformer(srtpProfileInfo, keyingMaterial, tlsRole, cryptex, this.logger);
        object = this;
        boolean bl = false;
        this.setSrtpInformationInternal((SrtpTransformers)it, true);
        object.srtpTransformers = srtpTransformers;
    }

    private final void setSrtpInformationInternal(SrtpTransformers srtpTransformers, boolean internal) {
        this.rtpReceiver.setSrtpTransformers(srtpTransformers);
        this.rtpSender.setSrtpTransformers(srtpTransformers);
        this.internalTransformers = internal;
    }

    public final void setSrtpInformation(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter((Object)srtpTransformers, (String)"srtpTransformers");
        this.setSrtpInformationInternal(srtpTransformers, false);
    }

    public final void forceMuteAudio(boolean shouldMute) {
        boolean bl = shouldMute;
        if (bl) {
            this.logger.info((Object)"Muting incoming audio");
        } else if (!bl) {
            this.logger.info((Object)"Unmuting incoming audio");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.rtpReceiver.forceMuteAudio(shouldMute);
    }

    public final void forceMuteVideo(boolean shouldMute) {
        boolean bl = shouldMute;
        if (bl) {
            this.logger.info((Object)"Muting incoming video");
        } else if (!bl) {
            this.logger.info((Object)"Unmuting incoming video");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.rtpReceiver.forceMuteVideo(shouldMute);
    }

    @NotNull
    public final OrderedJsonObject debugState(@NotNull DebugStateMode mode) {
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        OrderedJsonObject $this$debugState_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$debugState_u24lambda_u240.put((Object)"stream_information_store", (Object)this.streamInformationStore.debugState(mode));
        $this$debugState_u24lambda_u240.put((Object)"media_sources", (Object)this.mediaSources.debugState());
        $this$debugState_u24lambda_u240.put((Object)"endpoint_connection_stats", (Object)this.endpointConnectionStats.getSnapshot().toJson());
        $this$debugState_u24lambda_u240.put((Object)"receiver", (Object)this.rtpReceiver.debugState(mode));
        $this$debugState_u24lambda_u240.put((Object)"sender", (Object)this.rtpSender.debugState(mode));
        return orderedJsonObject;
    }

    @NotNull
    public final TransceiverStats getTransceiverStats() {
        return new TransceiverStats(this.endpointConnectionStats.getSnapshot(), this.rtpReceiver.getStats(), this.rtpSender.getStreamStats(), this.rtpSender.getPacketStreamStats(), this.rtpSender.getTransportCcEngineStats());
    }

    public final void addEndpointConnectionStatsListener(@NotNull EndpointConnectionStats.EndpointConnectionStatsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.endpointConnectionStats.addListener(listener);
    }

    public final void removeEndpointConnectionStatsListener(@NotNull EndpointConnectionStats.EndpointConnectionStatsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.endpointConnectionStats.removeListener(listener);
    }

    @Override
    public void stop() {
        block1: {
            this.rtpReceiver.stop();
            this.rtpSender.stop();
            if (!this.internalTransformers) break block1;
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                srtpTransformers.close();
            }
        }
    }

    public final void teardown() {
        this.logger.debug((Object)"Tearing down");
        this.rtpReceiver.tearDown();
        this.rtpSender.tearDown();
    }

    public final void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        this.rtpReceiver.setFeature(feature, enabled2);
        this.rtpSender.setFeature(feature, enabled2);
    }

    public final boolean isFeatureEnabled(@NotNull Features feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return this.rtpReceiver.isFeatureEnabled(feature);
    }

    @JvmOverloads
    public final void requestKeyFrame() {
        Transceiver.requestKeyFrame$default(this, null, 1, null);
    }

    private static final Unit rtpReceiver$lambda$0(Transceiver this$0, RtcpPacket rtcpPacket) {
        Intrinsics.checkNotNullParameter((Object)rtcpPacket, (String)"rtcpPacket");
        if (rtcpPacket.length >= 1500) {
            this$0.logger.warn((Object)("Sending large locally-generated RTCP packet of size " + rtcpPacket.length + ", first packet of type " + rtcpPacket.getPacketType() + " rc " + rtcpPacket.getReportCount() + "."));
        }
        this$0.rtpSender.processPacket(new PacketInfo((Packet)rtcpPacket, 0, null, 6, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/nlj/Transceiver$Companion;", "", "<init>", "()V", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

