/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.srtp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpTransformer;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpCryptoContext;
import org.jitsi.srtp.SrtpErrorStatus;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/srtp/SrtpDecryptTransformer;", "Lorg/jitsi/nlj/srtp/SrtpTransformer;", "contextFactory", "Lorg/jitsi/srtp/SrtpContextFactory;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/srtp/SrtpContextFactory;Lorg/jitsi/utils/logging2/Logger;)V", "earlyDiscardedPacketsSinceLastSuccess", "", "getEarlyDiscardedPacketsSinceLastSuccess", "()I", "setEarlyDiscardedPacketsSinceLastSuccess", "(I)V", "alwaysProcess", "", "transform", "Lorg/jitsi/srtp/SrtpErrorStatus;", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "context", "Lorg/jitsi/srtp/SrtpCryptoContext;", "doTransform", "jitsi-media-transform"})
public final class SrtpDecryptTransformer
extends SrtpTransformer {
    private int earlyDiscardedPacketsSinceLastSuccess;
    private final boolean alwaysProcess;

    public SrtpDecryptTransformer(@NotNull SrtpContextFactory contextFactory, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super(contextFactory, parentLogger);
        this.alwaysProcess = SrtpConfig.Companion.getMaxConsecutivePacketsDiscardedEarly() <= 0;
    }

    public final int getEarlyDiscardedPacketsSinceLastSuccess() {
        return this.earlyDiscardedPacketsSinceLastSuccess;
    }

    public final void setEarlyDiscardedPacketsSinceLastSuccess(int n) {
        this.earlyDiscardedPacketsSinceLastSuccess = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected SrtpErrorStatus transform(@NotNull PacketInfo packetInfo, @NotNull SrtpCryptoContext context) {
        SrtpErrorStatus srtpErrorStatus;
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!packetInfo.getShouldDiscard()) return this.doTransform(packetInfo, context);
        if (!this.alwaysProcess) {
            int n = this.earlyDiscardedPacketsSinceLastSuccess;
            this.earlyDiscardedPacketsSinceLastSuccess = n + 1;
            if (n <= SrtpConfig.Companion.getMaxConsecutivePacketsDiscardedEarly()) {
                srtpErrorStatus = SrtpErrorStatus.OK;
                return srtpErrorStatus;
            }
        }
        srtpErrorStatus = this.doTransform(packetInfo, context);
        return srtpErrorStatus;
    }

    private final SrtpErrorStatus doTransform(PacketInfo packetInfo, SrtpCryptoContext context) {
        SrtpErrorStatus srtpErrorStatus;
        SrtpErrorStatus it = srtpErrorStatus = context.reverseTransformPacket((ByteArrayBuffer)packetInfo.packetAs(), packetInfo.getShouldDiscard());
        boolean bl = false;
        packetInfo.resetPayloadVerification();
        if (it == SrtpErrorStatus.OK) {
            this.earlyDiscardedPacketsSinceLastSuccess = 0;
        }
        SrtpErrorStatus srtpErrorStatus2 = srtpErrorStatus;
        Intrinsics.checkNotNullExpressionValue((Object)srtpErrorStatus2, (String)"also(...)");
        return srtpErrorStatus2;
    }
}

