/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;

public class AccessibleClassLoader extends ClassLoader {

    public AccessibleClassLoader() {
        super();
    }

    public AccessibleClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class superFindLoadedClass(String name) {
        return super.findLoadedClass(name);
    }

    public Class superDefineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        Class r = super.defineClass(name, b, off, len, protectionDomain);
        Log.log(2,Log.LOG_CLASSLOAD, "ClientClassLoader.defineClass(",name,")=",r==null?"<null>":r.toString());
        return r;
    }

    public void superResolveClass(Class c) {
        super.resolveClass(c);
    }

    public Class superFindSystemClass(String name) throws ClassNotFoundException {
        return super.findSystemClass(name);
    }

    public void superSetSigners(Class c, Object[] signers) {
        super.setSigners(c, signers);
    }

    public static URL superGetSystemResource(String name) {
        return getSystemResource(name);
    }

    public static Enumeration<URL> superGetSystemResources(String name) throws IOException {
        return getSystemResources(name);
    }

    public java.lang.Package superDefinePackage(String name, String specTitle, String specVersion, String specVendor,
            String implTitle, String implVersion, String implVendor, URL sealBase) {
        return definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public java.lang.Package superGetPackage(String name) {
        return getPackage(name);
    }

    public java.lang.Package[] superGetPackages() {
        return getPackages();
    }

    public Class superFindClass(String name) throws ClassNotFoundException {
        return findClass(name);
    }

    private static Manager manager = createManager();

    public static class Manager extends java.lang.SecurityManager {
        public Class[] getCallerClasses() {
            return getClassContext();
        }
    }

    private static Manager createManager() {
        Manager m;
        m = (Manager)AccessController.doPrivileged(new PrivilegedAction(){
            @Override
            public Object run() {
                return new Manager();
            }
        });
        return m;
    }

    public static final int STACK_OFFSET = 2;
    public static Class[] getStack() {
        return manager.getCallerClasses();
    }

}
