/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.tinymediamanager.core.AbstractModelObject;

public class MediaStreamInfo
extends AbstractModelObject {
    @JsonProperty
    protected String codec = "";
    @JsonProperty
    protected String language = "";
    @JsonProperty
    protected String title = "";
    @JsonProperty
    protected Set<Flags> streamFlags = EnumSet.noneOf(Flags.class);
    public String id = "";

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean has(Flags flag) {
        return this.streamFlags.contains((Object)flag);
    }

    public void set(Flags ... flags) {
        this.streamFlags.addAll(Arrays.asList(flags));
    }

    public Set<Flags> getFlags() {
        return this.streamFlags;
    }

    public void set(Collection<Flags> flags) {
        this.streamFlags.addAll(flags);
    }

    public void remove(Flags ... flags) {
        for (Flags f : flags) {
            this.streamFlags.remove((Object)f);
        }
    }

    public boolean isDefaultStream() {
        return this.streamFlags.contains((Object)Flags.FLAG_DEFAULT);
    }

    public void setDefaultStream(boolean defaultStream) {
        if (defaultStream) {
            this.streamFlags.add(Flags.FLAG_DEFAULT);
        } else {
            this.streamFlags.remove((Object)Flags.FLAG_DEFAULT);
        }
    }

    public boolean isForced() {
        return this.streamFlags.contains((Object)Flags.FLAG_FORCED);
    }

    public void setForced(boolean forced) {
        if (forced) {
            this.streamFlags.add(Flags.FLAG_FORCED);
        } else {
            this.streamFlags.remove((Object)Flags.FLAG_FORCED);
        }
    }

    public boolean isSdh() {
        return this.streamFlags.contains((Object)Flags.FLAG_HEARING_IMPAIRED);
    }

    public void setSdh(boolean sdh) {
        if (sdh) {
            this.streamFlags.add(Flags.FLAG_HEARING_IMPAIRED);
        } else {
            this.streamFlags.remove((Object)Flags.FLAG_HEARING_IMPAIRED);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.streamFlags == null ? 0 : this.streamFlags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaStreamInfo other = (MediaStreamInfo)obj;
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.streamFlags == null ? other.streamFlags != null : !this.streamFlags.equals(other.streamFlags));
    }

    public static enum Flags {
        FLAG_DEFAULT,
        FLAG_DUB,
        FLAG_ORIGINAL,
        FLAG_COMMENT,
        FLAG_LYRICS,
        FLAG_KARAOKE,
        FLAG_FORCED,
        FLAG_HEARING_IMPAIRED,
        FLAG_VISUAL_IMPAIRED;

    }
}

