/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.StreamAttr;

@XmlType(propOrder={"start", "map", "number", "reserved", "streamAttr"})
public class ProgramSequence {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgramSequence.class);
    private int start;
    private short map;
    private byte number;
    private byte reserved;
    private StreamAttr[] streamAttr;

    public int size() {
        return 8 + (this.number > 0 ? this.streamAttr[0].size() * this.number : 0);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public short getMap() {
        return this.map;
    }

    public void setMap(short s) {
        this.map = s;
    }

    public byte getNumber() {
        return this.number;
    }

    public void setNumber(byte by) {
        this.number = by;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void setReserved(byte by) {
        this.reserved = by;
    }

    public StreamAttr[] getStreamAttr() {
        return this.streamAttr;
    }

    public void setStreamAttr(StreamAttr[] streamAttrArray) {
        this.streamAttr = streamAttrArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.start = dataInputStream.readInt();
        LOGGER.trace("ProgramSequence start=" + this.start);
        this.map = dataInputStream.readShort();
        LOGGER.trace("ProgramSequence map=" + this.map);
        this.number = dataInputStream.readByte();
        LOGGER.trace("ProgramSequence number=" + this.number);
        this.reserved = dataInputStream.readByte();
        LOGGER.trace("ProgramSequence reserved=" + this.reserved);
        this.streamAttr = new StreamAttr[this.number];
        for (int i = 0; i < this.number; ++i) {
            this.streamAttr[i] = new StreamAttr();
            this.streamAttr[i].readObject(dataInputStream);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getStart());
        dataOutputStream.writeShort(this.getMap());
        dataOutputStream.writeByte(this.getNumber());
        dataOutputStream.writeByte(this.getReserved());
        for (int i = 0; i < this.number; ++i) {
            this.streamAttr[i].writeObject(dataOutputStream);
        }
    }
}

