/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.dvd;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.tinymediamanager.library.dvd.DvdAudio;
import org.tinymediamanager.library.dvd.DvdSubtitle;
import org.tinymediamanager.library.dvd.DvdTitleSet;

public class DvdTitle {
    private final int[] colors = new int[16];
    private final List<Long> chapterTimeMs = new ArrayList<Long>();
    private final List<DvdAudio> audios = new ArrayList<DvdAudio>();
    private final List<DvdSubtitle> subs = new ArrayList<DvdSubtitle>();
    private int title;
    private int chapters;
    private int angles;
    private long totalTimeMs;
    private DvdTitleSet titleSet;
    private int vtsn;
    private int vts;

    public int[] getColors() {
        return this.colors;
    }

    public List<Long> getChapterTimeMs() {
        return this.chapterTimeMs;
    }

    public List<DvdAudio> getAudios() {
        return this.audios;
    }

    public List<DvdSubtitle> getSubs() {
        return this.subs;
    }

    public int getTitle() {
        return this.title;
    }

    public void setTitle(int n) {
        this.title = n;
    }

    public long getTotalTimeMs() {
        return this.totalTimeMs;
    }

    public void setTotalTimeMs(long l) {
        this.totalTimeMs = l;
    }

    public int getChapters() {
        return this.chapters;
    }

    public void setChapters(int n) {
        this.chapters = n;
    }

    public int getAngles() {
        return this.angles;
    }

    public void setAngles(int n) {
        this.angles = n;
    }

    public int getVtsn() {
        return this.vtsn;
    }

    public void setVtsn(int n) {
        this.vtsn = n;
    }

    public int getVts() {
        return this.vts;
    }

    public void setVts(int n) {
        this.vts = n;
    }

    public DvdTitleSet getTitleSet() {
        return this.titleSet;
    }

    public void setTitleSet(DvdTitleSet dvdTitleSet) {
        this.titleSet = dvdTitleSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[title ").append(this.title);
        stringBuilder.append(", chapters=").append(this.chapters);
        stringBuilder.append(", audios=");
        stringBuilder.append(this.audios.stream().map(DvdAudio::toString).collect(Collectors.joining(" ", "[", "]")));
        stringBuilder.append(", subs=");
        stringBuilder.append(this.subs.stream().map(DvdSubtitle::toString).collect(Collectors.joining(" ", "[", "]")));
        stringBuilder.append(", angles=").append(this.angles);
        stringBuilder.append(", vtsn=").append(this.vtsn);
        stringBuilder.append(", vts=").append(this.vts);
        stringBuilder.append(", total=").append(this.totalTimeMs).append(" ms");
        stringBuilder.append(", chapter=");
        stringBuilder.append(this.chapterTimeMs.stream().map(String::valueOf).map(string -> string + " ms").collect(Collectors.joining(",")));
        stringBuilder.append(", colors=");
        StringJoiner stringJoiner = new StringJoiner(",");
        for (int n : this.colors) {
            stringJoiner.add(String.format("%06X", n));
        }
        stringBuilder.append(stringJoiner);
        stringBuilder.append(", titleSet=").append(this.titleSet);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

