/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.images;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.Icon;

public class LogoCircle
implements Icon {
    private static final int DEFAULT_WIDTH = 50;
    private static final int DEFAULT_HEIGHT = 50;
    private final int width;
    private final int height;
    private BufferedImage image;

    public LogoCircle() {
        this.width = 50;
        this.height = 50;
    }

    public LogoCircle(int size) {
        this.width = size;
        this.height = size;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            double coef = Math.min((double)this.width / 50.0, (double)this.height / 50.0);
            Graphics2D g2d = this.image.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale(coef, coef);
            LogoCircle.paint(g2d);
            g2d.dispose();
        }
        return this.image;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.getImage(), x, y, null);
    }

    private static void paint(Graphics2D g) {
        Shape shape = null;
        float origAlpha = 1.0f;
        LinkedList<AffineTransform> transformations = new LinkedList<AffineTransform>();
        shape = new RoundRectangle2D.Double(0.0, 0.0, 50.0, 50.0, 7.8125, 7.8125);
        g.setPaint(new RadialGradientPaint(new Point2D.Double(0.5, 0.45517972111701965), 0.6055503f, new Point2D.Double(0.5, 0.45517972111701965), new float[]{0.0f, 1.0f}, new Color[]{new Color(0x494949), new Color(0x303030)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(50.0f, 0.0f, 0.0f, 50.0f, 0.0f, 0.0f)));
        g.fill(shape);
        transformations.offer(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 7.0f, 7.0f));
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(17.999876, 36.0);
        ((GeneralPath)shape).curveTo(8.074509, 36.0, 0.0, 27.925491, 0.0, 17.999876);
        ((GeneralPath)shape).curveTo(0.0, 8.074261, 8.074509, -3.5527137E-15, 17.999876, -3.5527137E-15);
        ((GeneralPath)shape).curveTo(27.925491, -3.5527137E-15, 36.0, 8.074261, 36.0, 17.999876);
        ((GeneralPath)shape).curveTo(36.0, 27.925491, 27.925491, 36.0, 17.999876, 36.0);
        ((GeneralPath)shape).lineTo(17.999876, 36.0);
        ((GeneralPath)shape).closePath();
        ((GeneralPath)shape).moveTo(21.754723, 4.454225);
        ((GeneralPath)shape).lineTo(19.095743, 16.930326);
        ((GeneralPath)shape).curveTo(18.938835, 17.596188, 18.88819, 18.116066, 18.88819, 18.58356);
        ((GeneralPath)shape).curveTo(18.88819, 20.027006, 19.559513, 20.490776, 21.002958, 20.490776);
        ((GeneralPath)shape).curveTo(23.016932, 20.490776, 24.873997, 18.527203, 25.649841, 15.946925);
        ((GeneralPath)shape).lineTo(27.816998, 15.946925);
        ((GeneralPath)shape).curveTo(24.873997, 24.361565, 19.76533, 25.498396, 16.978739, 25.498396);
        ((GeneralPath)shape).curveTo(13.878582, 25.498396, 11.455212, 23.63587, 11.455212, 19.30156);
        ((GeneralPath)shape).curveTo(11.455212, 18.321634, 11.608395, 17.184555, 11.866596, 15.946925);
        ((GeneralPath)shape).lineTo(14.323731, 4.431881);
        ((GeneralPath)shape).curveTo(8.343635, 6.0550747, 3.9266498, 11.515293, 3.9266498, 17.999876);
        ((GeneralPath)shape).curveTo(3.9266498, 25.75635, 10.239677, 32.06913, 17.999876, 32.06913);
        ((GeneralPath)shape).curveTo(25.760075, 32.06913, 32.07335, 25.75635, 32.07335, 17.999876);
        ((GeneralPath)shape).curveTo(32.07335, 11.541361, 27.695593, 6.1034875, 21.754723, 4.454225);
        ((GeneralPath)shape).lineTo(21.754723, 4.454225);
        ((GeneralPath)shape).closePath();
        g.setPaint(new Color(16743680));
        g.fill(shape);
        g.setTransform((AffineTransform)transformations.poll());
    }
}

