/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieDatasourceFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private MovieSettings movieSettings = MovieModuleManager.getInstance().getSettings();

    public MovieDatasourceFilter() {
        this.buildAndInstallDatasourceArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallDatasourceArray();
        this.movieSettings.addPropertyChangeListener("dataSource", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieDatasource";
    }

    @Override
    public boolean accept(Movie movie) {
        List datasources = this.checkComboBox.getSelectedItems();
        return datasources.contains(movie.getDataSource());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
    }

    private void buildAndInstallDatasourceArray() {
        this.setValues(new ArrayList<String>(this.movieSettings.getMovieDataSource()));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

