/*
 * Decompiled with CFR 0.152.
 */
package io.github.jacksonbrienen.jwfd;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public final class FileExtension
extends FileFilter {
    public static final FileExtension ALL = new FileExtension();
    private final String[] extensions;
    private final String windowsFilter;
    private final String description;

    private FileExtension() {
        this.extensions = new String[]{""};
        this.windowsFilter = "All\u0000*.*";
        this.description = "All (*.*)";
    }

    public FileExtension(String description, String ... extensions) throws IllegalArgumentException {
        if (description == null) {
            throw new IllegalArgumentException("The description cannot be null");
        }
        if (extensions == null) {
            throw new IllegalArgumentException("The extensions array cannot be null");
        }
        if (extensions.length == 0) {
            throw new IllegalArgumentException("The extensions array must have a minimum length of 1");
        }
        this.extensions = FileExtension.addExtensionIdentifier(extensions);
        String winExtensions = FileExtension.arrayToWindowsFilter(extensions);
        this.windowsFilter = description + "\u0000" + winExtensions;
        this.description = description + " (" + winExtensions + ")";
    }

    String getWindowsFilter() {
        return this.windowsFilter;
    }

    String[] getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        for (String extension : this.extensions) {
            if (!f.getName().toLowerCase().endsWith(extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    private static String[] addExtensionIdentifier(String[] extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = "." + extensions[i];
        }
        return extensions;
    }

    private static String arrayToWindowsFilter(String[] extensions) {
        StringBuilder builder = new StringBuilder();
        builder.append("*").append(extensions[0]);
        for (int i = 1; i < extensions.length; ++i) {
            builder.append(";*").append(extensions[i]);
        }
        return builder.toString();
    }
}

