/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;

public class MovieMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieMissingArtworkDownloadTask.class);
    private final List<Movie> moviesToScrape;
    private final MovieSearchAndScrapeOptions scrapeOptions;
    private final List<MovieScraperMetadataConfig> metadataConfig;

    public MovieMissingArtworkDownloadTask(List<Movie> moviesToScrape, MovieSearchAndScrapeOptions scrapeOptions, List<MovieScraperMetadataConfig> metadataConfig) {
        super(TmmResourceBundle.getString("task.missingartwork"));
        this.moviesToScrape = moviesToScrape;
        this.scrapeOptions = scrapeOptions;
        this.metadataConfig = metadataConfig;
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing artwork for '{}' movies", (Object)this.moviesToScrape.size());
        this.initThreadPool(3, "scrapeMissingMovieArtwork");
        for (Movie movie : this.moviesToScrape) {
            this.submitTask(new Worker(movie, this.scrapeOptions, this.metadataConfig));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Finished getting missing artwork - took {} ms", (Object)this.getRuntime());
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private static class Worker
    implements Runnable {
        private final Movie movie;
        private final MediaSearchAndScrapeOptions scrapeOptions;
        private final List<MovieScraperMetadataConfig> metadataConfig;

        private Worker(Movie movie, MediaSearchAndScrapeOptions scrapeOptions, List<MovieScraperMetadataConfig> metadataConfig) {
            this.movie = movie;
            this.scrapeOptions = scrapeOptions;
            this.metadataConfig = metadataConfig;
        }

        @Override
        public void run() {
            if (MovieArtworkHelper.hasMissingArtwork(this.movie, this.metadataConfig)) {
                try {
                    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
                    ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                    ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE);
                    options.setDataFromOtherOptions(this.scrapeOptions);
                    options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                    options.setIds(this.movie.getIds());
                    if (this.movie.isStacked()) {
                        options.setId("mediaFile", new ArrayList<MediaFile>(this.movie.getMediaFiles(MediaFileType.VIDEO)));
                    } else {
                        options.setId("mediaFile", this.movie.getMainFile());
                    }
                    options.setLanguage(MovieModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
                    options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
                    options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
                    options.getArtworkScrapers().parallelStream().forEach(scraper -> {
                        if ("ffmpeg".equals(scraper.getId())) {
                            return;
                        }
                        IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                        try {
                            lock.writeLock().lock();
                            artwork.addAll(artworkProvider.getArtwork(options));
                        }
                        catch (MissingIdException e) {
                            LOGGER.info("Missing IDs for scraping '{}' with '{}'", (Object)this.movie.getTitle(), (Object)scraper.getId());
                        }
                        catch (ScrapeException e) {
                            LOGGER.error("Could not scrape movie artwork for '{}' with '{}' - '{}'", new Object[]{this.movie.getTitle(), scraper.getId(), e.getMessage()});
                            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.moviesetartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                        }
                        catch (Exception e) {
                            LOGGER.error("Unforeseen error in movie artwork scrape for '{}'", (Object)this.movie.getTitle(), (Object)e);
                        }
                        finally {
                            lock.writeLock().unlock();
                        }
                    });
                    if (!artwork.isEmpty()) {
                        LOGGER.info("Download missing artwork for movie '{}'", (Object)this.movie.getTitle());
                        MovieArtworkHelper.downloadMissingArtwork(this.movie, artwork, this.metadataConfig);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not get missing artwork for movie '{}' - '{}'", (Object)this.movie.getTitle(), (Object)e.getMessage());
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            MovieArtworkHelper.cleanupArtwork(this.movie, this.metadataConfig);
        }
    }
}

