/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class ClientEncryptionSettings {
    private final MongoClientSettings keyVaultMongoClientSettings;
    private final String keyVaultNamespace;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final Map<String, SSLContext> kmsProviderSslContextMap;

    public static Builder builder() {
        return new Builder();
    }

    public MongoClientSettings getKeyVaultMongoClientSettings() {
        return this.keyVaultMongoClientSettings;
    }

    public String getKeyVaultNamespace() {
        return this.keyVaultNamespace;
    }

    public Map<String, Map<String, Object>> getKmsProviders() {
        return Collections.unmodifiableMap(this.kmsProviders);
    }

    public Map<String, Supplier<Map<String, Object>>> getKmsProviderPropertySuppliers() {
        return Collections.unmodifiableMap(this.kmsProviderPropertySuppliers);
    }

    public Map<String, SSLContext> getKmsProviderSslContextMap() {
        return Collections.unmodifiableMap(this.kmsProviderSslContextMap);
    }

    private ClientEncryptionSettings(Builder builder) {
        this.keyVaultMongoClientSettings = Assertions.notNull("keyVaultMongoClientSettings", builder.keyVaultMongoClientSettings);
        this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", builder.keyVaultNamespace);
        this.kmsProviders = Assertions.notNull("kmsProviders", builder.kmsProviders);
        this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", builder.kmsProviderPropertySuppliers);
        this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", builder.kmsProviderSslContextMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private MongoClientSettings keyVaultMongoClientSettings;
        private String keyVaultNamespace;
        private Map<String, Map<String, Object>> kmsProviders;
        private Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers = new HashMap<String, Supplier<Map<String, Object>>>();
        private Map<String, SSLContext> kmsProviderSslContextMap = new HashMap<String, SSLContext>();

        public Builder keyVaultMongoClientSettings(MongoClientSettings keyVaultMongoClientSettings) {
            this.keyVaultMongoClientSettings = Assertions.notNull("keyVaultMongoClientSettings", keyVaultMongoClientSettings);
            return this;
        }

        public Builder keyVaultNamespace(String keyVaultNamespace) {
            this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", keyVaultNamespace);
            return this;
        }

        public Builder kmsProviders(Map<String, Map<String, Object>> kmsProviders) {
            this.kmsProviders = Assertions.notNull("kmsProviders", kmsProviders);
            return this;
        }

        public Builder kmsProviderPropertySuppliers(Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
            this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", kmsProviderPropertySuppliers);
            return this;
        }

        public Builder kmsProviderSslContextMap(Map<String, SSLContext> kmsProviderSslContextMap) {
            this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", kmsProviderSslContextMap);
            return this;
        }

        public ClientEncryptionSettings build() {
            return new ClientEncryptionSettings(this);
        }

        private Builder() {
        }
    }
}

