/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractNumericGene;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.random;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import io.jenetics.util.Mean;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.util.Random;

public final class IntegerGene
extends AbstractNumericGene<Integer, IntegerGene>
implements NumericGene<Integer, IntegerGene>,
Mean<IntegerGene>,
Comparable<IntegerGene>,
Serializable {
    private static final long serialVersionUID = 1L;

    IntegerGene(Integer value, Integer min, Integer max) {
        super(value, min, max);
    }

    @Override
    public int compareTo(IntegerGene other) {
        return ((Integer)this._value).compareTo((Integer)other._value);
    }

    public static IntegerGene of(int value, int min, int max) {
        return new IntegerGene(value, min, max);
    }

    public static IntegerGene of(int value, IntRange range) {
        return new IntegerGene(value, range.getMin(), range.getMax());
    }

    public static IntegerGene of(int min, int max) {
        return IntegerGene.of(IntegerGene.nextInt(RandomRegistry.getRandom(), min, max), min, max);
    }

    public static IntegerGene of(IntRange range) {
        return IntegerGene.of(IntegerGene.nextInt(RandomRegistry.getRandom(), range.getMin(), range.getMax()), range);
    }

    static ISeq<IntegerGene> seq(Integer minimum, Integer maximum, IntRange lengthRange) {
        int min = minimum;
        int max = maximum;
        Random r = RandomRegistry.getRandom();
        return MSeq.ofLength(random.nextInt(lengthRange, r)).fill(() -> new IntegerGene(IntegerGene.nextInt(r, min, max), minimum, maximum)).toISeq();
    }

    @Override
    public IntegerGene newInstance(Number number) {
        return new IntegerGene(number.intValue(), (Integer)this._min, (Integer)this._max);
    }

    @Override
    public IntegerGene newInstance() {
        return new IntegerGene(IntegerGene.nextInt(RandomRegistry.getRandom(), (Integer)this._min, (Integer)this._max), (Integer)this._min, (Integer)this._max);
    }

    @Override
    public IntegerGene mean(IntegerGene that) {
        return new IntegerGene((Integer)this._value + ((Integer)that._value - (Integer)this._value) / 2, (Integer)this._min, (Integer)this._max);
    }

    static int nextInt(Random random2, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("Min >= max: %d >= %d", min, max));
        }
        int diff = max - min + 1;
        int result = 0;
        if (diff <= 0) {
            while ((result = random2.nextInt()) < min || result > max) {
            }
        } else {
            result = random2.nextInt(diff) + min;
        }
        return result;
    }
}

