/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.gf.model.impl.pd.GFPDMetadata;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.pdlayer.PDMetadata;

public class GFCosDict
extends GFCosObject
implements CosDict {
    public static final String COS_DICT_TYPE = "CosDict";
    public static final String KEYS = "keys";
    public static final String VALUES = "values";
    public static final String METADATA = "metadata";
    private final int size;

    public GFCosDict(COSDictionary dictionary) {
        this(dictionary, COS_DICT_TYPE);
    }

    protected GFCosDict(COSDictionary dictionary, String type) {
        super(dictionary, type);
        this.size = dictionary.size();
    }

    @Override
    public Long getsize() {
        return this.size;
    }

    @Override
    public String getkeysString() {
        return this.baseObject.getKeySet().stream().map(ASAtom::getValue).collect(Collectors.joining("&"));
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "keys": {
                return this.getKeys();
            }
            case "values": {
                return this.getValues();
            }
            case "metadata": {
                return this.getMetadata();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosName> getKeys() {
        ArrayList<CosName> list = new ArrayList<CosName>(this.baseObject.size());
        for (ASAtom key : this.baseObject.getKeySet()) {
            if (key == null) continue;
            COSBase name = COSName.fromValue(key);
            list.add((CosName)GFCosDict.getFromValue(name));
        }
        return Collections.unmodifiableList(list);
    }

    private List<CosObject> getValues() {
        ArrayList<CosObject> list = new ArrayList<CosObject>(this.baseObject.size());
        for (COSObject value : this.baseObject.getValues()) {
            if (value == null) continue;
            list.add(GFCosDict.getFromValue(value.get()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<PDMetadata> getMetadata() {
        COSDictionary dictionary = (COSDictionary)this.baseObject;
        COSObject meta = dictionary.getKey(ASAtom.METADATA);
        ASAtom type = dictionary.getNameKey(ASAtom.TYPE);
        if (org.verapdf.pd.PDMetadata.isMetadataObject(meta) && type != ASAtom.CATALOG) {
            ArrayList<GFPDMetadata> pdMetadatas = new ArrayList<GFPDMetadata>(1);
            org.verapdf.pd.PDMetadata md = new org.verapdf.pd.PDMetadata(meta);
            pdMetadatas.add(new GFPDMetadata(md, Boolean.FALSE));
            return Collections.unmodifiableList(pdMetadatas);
        }
        return Collections.emptyList();
    }
}

