/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableListBase;

public abstract class ReadOnlyUnbackedObservableList<E>
extends ObservableListBase<E> {
    public void callObservers(ListChangeListener.Change<E> c) {
        this.fireChange(c);
    }

    @Override
    public abstract E get(int var1);

    @Override
    public abstract int size();

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            E obj = this.get(i);
            if (!o.equals(obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            E obj = this.get(i);
            if (!o.equals(obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SelectionListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new SelectionListIterator(this, index);
    }

    @Override
    public Iterator<E> iterator() {
        return new SelectionListIterator(this);
    }

    @Override
    public List<E> subList(final int fromIndex2, final int toIndex) {
        if (fromIndex2 < 0 || toIndex > this.size() || fromIndex2 > toIndex) {
            throw new IndexOutOfBoundsException("[ fromIndex: " + fromIndex2 + ", toIndex: " + toIndex + ", size: " + this.size() + " ]");
        }
        final ReadOnlyUnbackedObservableList outer = this;
        return new ReadOnlyUnbackedObservableList<E>(){

            @Override
            public E get(int i) {
                return outer.get(i + fromIndex2);
            }

            @Override
            public int size() {
                return toIndex - fromIndex2;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            arr[i] = this.get(i);
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] elementData = this.toArray();
        int size = elementData.length;
        if (a.length < size) {
            return Arrays.copyOf(elementData, size, a.getClass());
        }
        System.arraycopy(elementData, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public String toString() {
        Iterator<E> i = this.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = i.next()) == this ? "(this Collection)" : e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(E ... elements) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setAll(Collection<? extends E> col) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setAll(E ... elements) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void remove(int from, int to) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(E ... elements) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(E ... elements) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private static class SelectionListIterator<E>
    implements ListIterator<E> {
        private int index;
        private final ReadOnlyUnbackedObservableList<E> list;

        public SelectionListIterator(ReadOnlyUnbackedObservableList<E> list) {
            this(list, 0);
        }

        public SelectionListIterator(ReadOnlyUnbackedObservableList<E> list, int index) {
            this.list = list;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public E next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return this.list.get(this.index--);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

