/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.ad.model.ADTask;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.DeleteConfigRequest;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class BaseDeleteConfigTransportAction<TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, ConfigType extends Config>
extends HandledTransportAction<DeleteConfigRequest, DeleteResponse> {
    private static final Logger LOG = LogManager.getLogger(BaseDeleteConfigTransportAction.class);
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private NamedXContentRegistry xContentRegistry;
    private final TaskManagerType taskManager;
    private volatile Boolean filterByEnabled;
    private final NodeStateManager nodeStateManager;
    private final AnalysisType analysisType;
    private final String stateIndex;
    private final Class<ConfigType> configTypeClass;
    private final List<TaskTypeEnum> batchTaskTypes;
    protected final String configIndexName;

    public BaseDeleteConfigTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry, NodeStateManager nodeStateManager, TaskManagerType taskManager, String deleteConfigAction, Setting<Boolean> filterByBackendRoleSetting, AnalysisType analysisType, String stateIndex, Class<ConfigType> configTypeClass, List<TaskTypeEnum> historicalTaskTypes, String configIndexName) {
        super(deleteConfigAction, transportService, actionFilters, DeleteConfigRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.taskManager = taskManager;
        this.nodeStateManager = nodeStateManager;
        this.filterByEnabled = (Boolean)filterByBackendRoleSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleSetting, it -> {
            this.filterByEnabled = it;
        });
        this.analysisType = analysisType;
        this.stateIndex = stateIndex;
        this.configTypeClass = configTypeClass;
        this.batchTaskTypes = historicalTaskTypes;
        this.configIndexName = configIndexName;
    }

    protected void doExecute(Task task, DeleteConfigRequest request, ActionListener<DeleteResponse> actionListener) {
        String configId = request.getConfigID();
        LOG.info("Delete job {}", (Object)configId);
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonMessages.FAIL_TO_DELETE_CONFIG);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.verifyResourceAccessAndProcessRequest(this.settings, args -> this.deleteConfigIfNotRunning(configId, (ActionListener<DeleteResponse>)listener), new Object[0], fallbackArgs -> ParseUtils.resolveUserAndExecute(user, configId, this.filterByEnabled, listener, input -> this.deleteConfigIfNotRunning(configId, (ActionListener<DeleteResponse>)listener), this.client, this.clusterService, this.xContentRegistry, this.configTypeClass), new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void deleteConfigIfNotRunning(String configId, ActionListener<DeleteResponse> listener) {
        this.nodeStateManager.getConfig(configId, this.analysisType, config -> {
            if (config.isEmpty()) {
                LOG.info("Can't find config {}", (Object)configId);
                ((TaskManager)this.taskManager).deleteTasks(configId, () -> this.deleteJobDoc(configId, listener), listener);
                return;
            }
            this.getJob(configId, listener, () -> ((TaskManager)this.taskManager).getAndExecuteOnLatestConfigLevelTask(configId, this.batchTaskTypes, configTask -> {
                if (configTask.isPresent() && !((TimeSeriesTask)configTask.get()).isDone()) {
                    String batchTaskName = configTask.get() instanceof ADTask ? "Historical" : "Run once";
                    listener.onFailure((Exception)new OpenSearchStatusException(batchTaskName + " is running", RestStatus.BAD_REQUEST, new Object[0]));
                } else {
                    ((TaskManager)this.taskManager).deleteTasks(configId, () -> this.deleteJobDoc(configId, listener), listener);
                }
            }, this.transportService, false, listener));
        }, listener);
    }

    private void deleteJobDoc(String configId, ActionListener<DeleteResponse> listener) {
        LOG.info("Delete job {}", (Object)configId);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-anomaly-detector-jobs", configId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, ActionListener.wrap(response -> {
            if (response.getResult() == DocWriteResponse.Result.DELETED || response.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                this.deleteStateDoc(configId, listener);
            } else {
                String message = "Fail to delete job " + configId;
                LOG.error(message);
                listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, exception -> {
            LOG.error("Failed to delete job for " + configId, (Throwable)exception);
            if (exception instanceof IndexNotFoundException) {
                this.deleteStateDoc(configId, listener);
            } else {
                LOG.error("Failed to delete job", (Throwable)exception);
                listener.onFailure(exception);
            }
        }));
    }

    private void deleteStateDoc(String configId, ActionListener<DeleteResponse> listener) {
        LOG.info("Delete config state {}", (Object)configId);
        DeleteRequest deleteRequest = new DeleteRequest(this.stateIndex, configId);
        this.client.delete(deleteRequest, ActionListener.wrap(response -> this.deleteConfigDoc(configId, listener), exception -> {
            if (exception instanceof IndexNotFoundException) {
                this.deleteConfigDoc(configId, listener);
            } else {
                LOG.error("Failed to delete state", (Throwable)exception);
                listener.onFailure(exception);
            }
        }));
    }

    private void deleteConfigDoc(String configId, final ActionListener<DeleteResponse> listener) {
        LOG.info("Delete config {}", (Object)configId);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(this.configIndexName, configId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                listener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void getJob(String configId, ActionListener<DeleteResponse> listener, ExecutorFunction function) {
        if (this.clusterService.state().metadata().indices().containsKey(".opendistro-anomaly-detector-jobs")) {
            GetRequest request = new GetRequest(".opendistro-anomaly-detector-jobs").id(configId);
            this.client.get(request, ActionListener.wrap(response -> this.onGetJobResponseForWrite((GetResponse)response, listener, function), exception -> {
                LOG.error("Fail to get job: " + configId, (Throwable)exception);
                listener.onFailure(exception);
            }));
        } else {
            function.execute();
        }
    }

    private void onGetJobResponseForWrite(GetResponse response, ActionListener<DeleteResponse> listener, ExecutorFunction function) throws IOException {
        if (response.isExists()) {
            String jobId = response.getId();
            if (jobId != null) {
                try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Job adJob = Job.parse(parser);
                    if (adJob.isEnabled()) {
                        listener.onFailure((Exception)new OpenSearchStatusException("Job is running: " + jobId, RestStatus.BAD_REQUEST, new Object[0]));
                    } else {
                        function.execute();
                    }
                }
                catch (IOException e) {
                    String message = "Failed to parse job " + jobId;
                    LOG.error(message, (Throwable)e);
                    function.execute();
                }
            }
        } else {
            function.execute();
        }
    }
}

