/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;

public class MemoryStorageConfig
implements ToXContentObject,
Writeable {
    private String memoryIndexName;
    private boolean semanticStorageEnabled;
    private FunctionName embeddingModelType;
    private String embeddingModelId;
    private String llmModelId;
    private Integer dimension;
    private Integer maxInferSize;

    public MemoryStorageConfig(String memoryIndexName, boolean semanticStorageEnabled, FunctionName embeddingModelType, String embeddingModelId, String llmModelId, Integer dimension, Integer maxInferSize) {
        MemoryStorageConfig.validateInputs(embeddingModelType, embeddingModelId, dimension, maxInferSize);
        boolean determinedSemanticStorage = embeddingModelId != null && embeddingModelType != null;
        this.memoryIndexName = memoryIndexName;
        this.semanticStorageEnabled = determinedSemanticStorage;
        this.embeddingModelType = embeddingModelType;
        this.embeddingModelId = embeddingModelId;
        this.llmModelId = llmModelId;
        this.dimension = dimension;
        this.maxInferSize = llmModelId != null ? Integer.valueOf(maxInferSize != null ? maxInferSize : 5) : null;
    }

    public MemoryStorageConfig(StreamInput input) throws IOException {
        this.memoryIndexName = input.readOptionalString();
        this.semanticStorageEnabled = input.readBoolean();
        String embeddingModelTypeStr = input.readOptionalString();
        this.embeddingModelType = embeddingModelTypeStr != null ? FunctionName.from(embeddingModelTypeStr) : null;
        this.embeddingModelId = input.readOptionalString();
        this.llmModelId = input.readOptionalString();
        this.dimension = input.readOptionalInt();
        this.maxInferSize = input.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.memoryIndexName);
        out.writeBoolean(this.semanticStorageEnabled);
        out.writeOptionalString(this.embeddingModelType != null ? this.embeddingModelType.name() : null);
        out.writeOptionalString(this.embeddingModelId);
        out.writeOptionalString(this.llmModelId);
        out.writeOptionalInt(this.dimension);
        out.writeOptionalInt(this.maxInferSize);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.memoryIndexName != null) {
            builder.field("memory_index_name", this.memoryIndexName);
        }
        builder.field("semantic_storage_enabled", this.semanticStorageEnabled);
        if (this.llmModelId != null) {
            builder.field("llm_model_id", this.llmModelId);
        }
        if (this.semanticStorageEnabled) {
            if (this.embeddingModelType != null) {
                builder.field("embedding_model_type", this.embeddingModelType.name());
            }
            if (this.embeddingModelId != null) {
                builder.field("embedding_model_id", this.embeddingModelId);
            }
            if (this.dimension != null) {
                builder.field("dimension", this.dimension);
            }
        }
        if (this.llmModelId != null && this.maxInferSize != null) {
            builder.field("max_infer_size", this.maxInferSize);
        }
        builder.endObject();
        return builder;
    }

    public static MemoryStorageConfig parse(XContentParser parser) throws IOException {
        String memoryIndexName = null;
        FunctionName embeddingModelType = null;
        String embeddingModelId = null;
        String llmModelId = null;
        Integer dimension = null;
        Integer maxInferSize = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory_index_name": {
                    memoryIndexName = parser.text();
                    continue block18;
                }
                case "semantic_storage_enabled": {
                    parser.skipChildren();
                    continue block18;
                }
                case "embedding_model_type": {
                    embeddingModelType = FunctionName.from(parser.text());
                    continue block18;
                }
                case "embedding_model_id": {
                    embeddingModelId = parser.text();
                    continue block18;
                }
                case "llm_model_id": {
                    llmModelId = parser.text();
                    continue block18;
                }
                case "dimension": {
                    dimension = parser.intValue();
                    continue block18;
                }
                case "max_infer_size": {
                    maxInferSize = parser.intValue();
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return MemoryStorageConfig.builder().memoryIndexName(memoryIndexName).embeddingModelType(embeddingModelType).embeddingModelId(embeddingModelId).llmModelId(llmModelId).dimension(dimension).maxInferSize(maxInferSize).build();
    }

    private static void validateInputs(FunctionName embeddingModelType, String embeddingModelId, Integer dimension, Integer maxInferSize) {
        MemoryStorageConfig.validateEmbeddingConfiguration(embeddingModelType, embeddingModelId, dimension);
        MemoryStorageConfig.validateMaxInferSize(maxInferSize);
    }

    private static void validateEmbeddingConfiguration(FunctionName embeddingModelType, String embeddingModelId, Integer dimension) {
        if (embeddingModelId != null && embeddingModelType == null) {
            throw new IllegalArgumentException("Embedding model type is required when embedding model ID is provided");
        }
        if (embeddingModelType != null && embeddingModelId == null) {
            throw new IllegalArgumentException("Embedding model ID is required when embedding model type is provided");
        }
        if (embeddingModelType != null) {
            MemoryStorageConfig.validateEmbeddingModelType(embeddingModelType);
            MemoryStorageConfig.validateDimensionRequirements(embeddingModelType, dimension);
        }
    }

    private static void validateMaxInferSize(Integer maxInferSize) {
        if (maxInferSize != null && maxInferSize > 10) {
            throw new IllegalArgumentException("Maximum infer size cannot exceed 10");
        }
    }

    private static void validateEmbeddingModelType(FunctionName embeddingModelType) {
        if (embeddingModelType != FunctionName.TEXT_EMBEDDING && embeddingModelType != FunctionName.SPARSE_ENCODING) {
            throw new IllegalArgumentException("Embedding model type must be either TEXT_EMBEDDING or SPARSE_ENCODING");
        }
    }

    private static void validateDimensionRequirements(FunctionName embeddingModelType, Integer dimension) {
        if (embeddingModelType == FunctionName.TEXT_EMBEDDING && dimension == null) {
            throw new IllegalArgumentException("Dimension is required for TEXT_EMBEDDING");
        }
        if (embeddingModelType == FunctionName.SPARSE_ENCODING && dimension != null) {
            throw new IllegalArgumentException("Dimension is not allowed for SPARSE_ENCODING");
        }
    }

    @Generated
    private static Integer $default$maxInferSize() {
        return 5;
    }

    @Generated
    public static MemoryStorageConfigBuilder builder() {
        return new MemoryStorageConfigBuilder();
    }

    @Generated
    public String getMemoryIndexName() {
        return this.memoryIndexName;
    }

    @Generated
    public boolean isSemanticStorageEnabled() {
        return this.semanticStorageEnabled;
    }

    @Generated
    public FunctionName getEmbeddingModelType() {
        return this.embeddingModelType;
    }

    @Generated
    public String getEmbeddingModelId() {
        return this.embeddingModelId;
    }

    @Generated
    public String getLlmModelId() {
        return this.llmModelId;
    }

    @Generated
    public Integer getDimension() {
        return this.dimension;
    }

    @Generated
    public Integer getMaxInferSize() {
        return this.maxInferSize;
    }

    @Generated
    public void setMemoryIndexName(String memoryIndexName) {
        this.memoryIndexName = memoryIndexName;
    }

    @Generated
    public void setSemanticStorageEnabled(boolean semanticStorageEnabled) {
        this.semanticStorageEnabled = semanticStorageEnabled;
    }

    @Generated
    public void setEmbeddingModelType(FunctionName embeddingModelType) {
        this.embeddingModelType = embeddingModelType;
    }

    @Generated
    public void setEmbeddingModelId(String embeddingModelId) {
        this.embeddingModelId = embeddingModelId;
    }

    @Generated
    public void setLlmModelId(String llmModelId) {
        this.llmModelId = llmModelId;
    }

    @Generated
    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setMaxInferSize(Integer maxInferSize) {
        this.maxInferSize = maxInferSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryStorageConfig)) {
            return false;
        }
        MemoryStorageConfig other = (MemoryStorageConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSemanticStorageEnabled() != other.isSemanticStorageEnabled()) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$maxInferSize = this.getMaxInferSize();
        Integer other$maxInferSize = other.getMaxInferSize();
        if (this$maxInferSize == null ? other$maxInferSize != null : !((Object)this$maxInferSize).equals(other$maxInferSize)) {
            return false;
        }
        String this$memoryIndexName = this.getMemoryIndexName();
        String other$memoryIndexName = other.getMemoryIndexName();
        if (this$memoryIndexName == null ? other$memoryIndexName != null : !this$memoryIndexName.equals(other$memoryIndexName)) {
            return false;
        }
        FunctionName this$embeddingModelType = this.getEmbeddingModelType();
        FunctionName other$embeddingModelType = other.getEmbeddingModelType();
        if (this$embeddingModelType == null ? other$embeddingModelType != null : !((Object)((Object)this$embeddingModelType)).equals((Object)other$embeddingModelType)) {
            return false;
        }
        String this$embeddingModelId = this.getEmbeddingModelId();
        String other$embeddingModelId = other.getEmbeddingModelId();
        if (this$embeddingModelId == null ? other$embeddingModelId != null : !this$embeddingModelId.equals(other$embeddingModelId)) {
            return false;
        }
        String this$llmModelId = this.getLlmModelId();
        String other$llmModelId = other.getLlmModelId();
        return !(this$llmModelId == null ? other$llmModelId != null : !this$llmModelId.equals(other$llmModelId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoryStorageConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSemanticStorageEnabled() ? 79 : 97);
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $maxInferSize = this.getMaxInferSize();
        result = result * 59 + ($maxInferSize == null ? 43 : ((Object)$maxInferSize).hashCode());
        String $memoryIndexName = this.getMemoryIndexName();
        result = result * 59 + ($memoryIndexName == null ? 43 : $memoryIndexName.hashCode());
        FunctionName $embeddingModelType = this.getEmbeddingModelType();
        result = result * 59 + ($embeddingModelType == null ? 43 : ((Object)((Object)$embeddingModelType)).hashCode());
        String $embeddingModelId = this.getEmbeddingModelId();
        result = result * 59 + ($embeddingModelId == null ? 43 : $embeddingModelId.hashCode());
        String $llmModelId = this.getLlmModelId();
        result = result * 59 + ($llmModelId == null ? 43 : $llmModelId.hashCode());
        return result;
    }

    @Generated
    public static class MemoryStorageConfigBuilder {
        @Generated
        private String memoryIndexName;
        @Generated
        private boolean semanticStorageEnabled;
        @Generated
        private FunctionName embeddingModelType;
        @Generated
        private String embeddingModelId;
        @Generated
        private String llmModelId;
        @Generated
        private Integer dimension;
        @Generated
        private boolean maxInferSize$set;
        @Generated
        private Integer maxInferSize$value;

        @Generated
        MemoryStorageConfigBuilder() {
        }

        @Generated
        public MemoryStorageConfigBuilder memoryIndexName(String memoryIndexName) {
            this.memoryIndexName = memoryIndexName;
            return this;
        }

        @Generated
        public MemoryStorageConfigBuilder semanticStorageEnabled(boolean semanticStorageEnabled) {
            this.semanticStorageEnabled = semanticStorageEnabled;
            return this;
        }

        @Generated
        public MemoryStorageConfigBuilder embeddingModelType(FunctionName embeddingModelType) {
            this.embeddingModelType = embeddingModelType;
            return this;
        }

        @Generated
        public MemoryStorageConfigBuilder embeddingModelId(String embeddingModelId) {
            this.embeddingModelId = embeddingModelId;
            return this;
        }

        @Generated
        public MemoryStorageConfigBuilder llmModelId(String llmModelId) {
            this.llmModelId = llmModelId;
            return this;
        }

        @Generated
        public MemoryStorageConfigBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        @Generated
        public MemoryStorageConfigBuilder maxInferSize(Integer maxInferSize) {
            this.maxInferSize$value = maxInferSize;
            this.maxInferSize$set = true;
            return this;
        }

        @Generated
        public MemoryStorageConfig build() {
            Integer maxInferSize$value = this.maxInferSize$value;
            if (!this.maxInferSize$set) {
                maxInferSize$value = MemoryStorageConfig.$default$maxInferSize();
            }
            return new MemoryStorageConfig(this.memoryIndexName, this.semanticStorageEnabled, this.embeddingModelType, this.embeddingModelId, this.llmModelId, this.dimension, maxInferSize$value);
        }

        @Generated
        public String toString() {
            return "MemoryStorageConfig.MemoryStorageConfigBuilder(memoryIndexName=" + this.memoryIndexName + ", semanticStorageEnabled=" + this.semanticStorageEnabled + ", embeddingModelType=" + String.valueOf((Object)this.embeddingModelType) + ", embeddingModelId=" + this.embeddingModelId + ", llmModelId=" + this.llmModelId + ", dimension=" + this.dimension + ", maxInferSize$value=" + this.maxInferSize$value + ")";
        }
    }
}

