# SPDX-FileCopyrightText: Copyright (c) 2021-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: LicenseRef-NVIDIA-SOFTWARE-LICENSE

# This code was automatically generated with version 13.0.0. Do not modify it directly.
from typing import Any, Optional
from enum import IntEnum
import cython
import ctypes
from libc.stdlib cimport calloc, malloc, free
from libc cimport string
from libc.stdint cimport int32_t, uint32_t, int64_t, uint64_t, uintptr_t
from libc.stddef cimport wchar_t
from libc.limits cimport CHAR_MIN
from libcpp.vector cimport vector
from cpython.buffer cimport PyObject_CheckBuffer, PyObject_GetBuffer, PyBuffer_Release, PyBUF_SIMPLE, PyBUF_ANY_CONTIGUOUS
from cpython.bytes cimport PyBytes_FromStringAndSize
import cuda.bindings.driver
from libcpp.map cimport map

_driver = globals()
include "_lib/utils.pxi"

ctypedef unsigned long long signed_char_ptr
ctypedef unsigned long long unsigned_char_ptr
ctypedef unsigned long long char_ptr
ctypedef unsigned long long short_ptr
ctypedef unsigned long long unsigned_short_ptr
ctypedef unsigned long long int_ptr
ctypedef unsigned long long long_int_ptr
ctypedef unsigned long long long_long_int_ptr
ctypedef unsigned long long unsigned_int_ptr
ctypedef unsigned long long unsigned_long_int_ptr
ctypedef unsigned long long unsigned_long_long_int_ptr
ctypedef unsigned long long uint32_t_ptr
ctypedef unsigned long long uint64_t_ptr
ctypedef unsigned long long int32_t_ptr
ctypedef unsigned long long int64_t_ptr
ctypedef unsigned long long unsigned_ptr
ctypedef unsigned long long unsigned_long_long_ptr
ctypedef unsigned long long long_long_ptr
ctypedef unsigned long long size_t_ptr
ctypedef unsigned long long long_ptr
ctypedef unsigned long long float_ptr
ctypedef unsigned long long double_ptr
ctypedef unsigned long long void_ptr

#: CUDA API version number
CUDA_VERSION = cydriver.CUDA_VERSION

#: CUDA IPC handle size
CU_IPC_HANDLE_SIZE = cydriver.CU_IPC_HANDLE_SIZE

#: Legacy stream handle
#:
#: Stream handle that can be passed as a CUstream to use an implicit stream
#: with legacy synchronization behavior.
#:
#: See details of the \link_sync_behavior
CU_STREAM_LEGACY = cydriver.CU_STREAM_LEGACY

#: Per-thread stream handle
#:
#: Stream handle that can be passed as a CUstream to use an implicit stream
#: with per-thread synchronization behavior.
#:
#: See details of the \link_sync_behavior
CU_STREAM_PER_THREAD = cydriver.CU_STREAM_PER_THREAD

CU_COMPUTE_ACCELERATED_TARGET_BASE = cydriver.CU_COMPUTE_ACCELERATED_TARGET_BASE

CU_COMPUTE_FAMILY_TARGET_BASE = cydriver.CU_COMPUTE_FAMILY_TARGET_BASE

#: Conditional node handle flags Default value is applied when graph is
#: launched.
CU_GRAPH_COND_ASSIGN_DEFAULT = cydriver.CU_GRAPH_COND_ASSIGN_DEFAULT

#: This port activates when the kernel has finished executing.
CU_GRAPH_KERNEL_NODE_PORT_DEFAULT = cydriver.CU_GRAPH_KERNEL_NODE_PORT_DEFAULT

#: This port activates when all blocks of the kernel have performed
#: cudaTriggerProgrammaticLaunchCompletion() or have terminated. It must be
#: used with edge type :py:obj:`~.CU_GRAPH_DEPENDENCY_TYPE_PROGRAMMATIC`.
#: See also :py:obj:`~.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT`.
CU_GRAPH_KERNEL_NODE_PORT_PROGRAMMATIC = cydriver.CU_GRAPH_KERNEL_NODE_PORT_PROGRAMMATIC

#: This port activates when all blocks of the kernel have begun execution.
#: See also :py:obj:`~.CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT`.
CU_GRAPH_KERNEL_NODE_PORT_LAUNCH_ORDER = cydriver.CU_GRAPH_KERNEL_NODE_PORT_LAUNCH_ORDER

CU_KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW = cydriver.CU_KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW

CU_KERNEL_NODE_ATTRIBUTE_COOPERATIVE = cydriver.CU_KERNEL_NODE_ATTRIBUTE_COOPERATIVE

CU_KERNEL_NODE_ATTRIBUTE_CLUSTER_DIMENSION = cydriver.CU_KERNEL_NODE_ATTRIBUTE_CLUSTER_DIMENSION

CU_KERNEL_NODE_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE = cydriver.CU_KERNEL_NODE_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE

CU_KERNEL_NODE_ATTRIBUTE_PRIORITY = cydriver.CU_KERNEL_NODE_ATTRIBUTE_PRIORITY

CU_KERNEL_NODE_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP = cydriver.CU_KERNEL_NODE_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP

CU_KERNEL_NODE_ATTRIBUTE_MEM_SYNC_DOMAIN = cydriver.CU_KERNEL_NODE_ATTRIBUTE_MEM_SYNC_DOMAIN

CU_KERNEL_NODE_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION = cydriver.CU_KERNEL_NODE_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION

CU_KERNEL_NODE_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE = cydriver.CU_KERNEL_NODE_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE

CU_KERNEL_NODE_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = cydriver.CU_KERNEL_NODE_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT

CU_STREAM_ATTRIBUTE_ACCESS_POLICY_WINDOW = cydriver.CU_STREAM_ATTRIBUTE_ACCESS_POLICY_WINDOW

CU_STREAM_ATTRIBUTE_SYNCHRONIZATION_POLICY = cydriver.CU_STREAM_ATTRIBUTE_SYNCHRONIZATION_POLICY

CU_STREAM_ATTRIBUTE_PRIORITY = cydriver.CU_STREAM_ATTRIBUTE_PRIORITY

CU_STREAM_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP = cydriver.CU_STREAM_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP

CU_STREAM_ATTRIBUTE_MEM_SYNC_DOMAIN = cydriver.CU_STREAM_ATTRIBUTE_MEM_SYNC_DOMAIN

#: If set, host memory is portable between CUDA contexts. Flag for
#: :py:obj:`~.cuMemHostAlloc()`
CU_MEMHOSTALLOC_PORTABLE = cydriver.CU_MEMHOSTALLOC_PORTABLE

#: If set, host memory is mapped into CUDA address space and
#: :py:obj:`~.cuMemHostGetDevicePointer()` may be called on the host
#: pointer. Flag for :py:obj:`~.cuMemHostAlloc()`
CU_MEMHOSTALLOC_DEVICEMAP = cydriver.CU_MEMHOSTALLOC_DEVICEMAP

#: If set, host memory is allocated as write-combined - fast to write,
#: faster to DMA, slow to read except via SSE4 streaming load instruction
#: (MOVNTDQA). Flag for :py:obj:`~.cuMemHostAlloc()`
CU_MEMHOSTALLOC_WRITECOMBINED = cydriver.CU_MEMHOSTALLOC_WRITECOMBINED

#: If set, host memory is portable between CUDA contexts. Flag for
#: :py:obj:`~.cuMemHostRegister()`
CU_MEMHOSTREGISTER_PORTABLE = cydriver.CU_MEMHOSTREGISTER_PORTABLE

#: If set, host memory is mapped into CUDA address space and
#: :py:obj:`~.cuMemHostGetDevicePointer()` may be called on the host
#: pointer. Flag for :py:obj:`~.cuMemHostRegister()`
CU_MEMHOSTREGISTER_DEVICEMAP = cydriver.CU_MEMHOSTREGISTER_DEVICEMAP

#: If set, the passed memory pointer is treated as pointing to some memory-
#: mapped I/O space, e.g. belonging to a third-party PCIe device. On
#: Windows the flag is a no-op. On Linux that memory is marked as non
#: cache-coherent for the GPU and is expected to be physically contiguous.
#: It may return :py:obj:`~.CUDA_ERROR_NOT_PERMITTED` if run as an
#: unprivileged user, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED` on older Linux
#: kernel versions. On all other platforms, it is not supported and
#: :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED` is returned. Flag for
#: :py:obj:`~.cuMemHostRegister()`
CU_MEMHOSTREGISTER_IOMEMORY = cydriver.CU_MEMHOSTREGISTER_IOMEMORY

#: If set, the passed memory pointer is treated as pointing to memory that
#: is considered read-only by the device. On platforms without
#: :py:obj:`~.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES`,
#: this flag is required in order to register memory mapped to the CPU as
#: read-only. Support for the use of this flag can be queried from the
#: device attribute
#: :py:obj:`~.CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED`. Using
#: this flag with a current context associated with a device that does not
#: have this attribute set will cause :py:obj:`~.cuMemHostRegister` to
#: error with :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`.
CU_MEMHOSTREGISTER_READ_ONLY = cydriver.CU_MEMHOSTREGISTER_READ_ONLY

#: Indicates that the layered sparse CUDA array or CUDA mipmapped array has
#: a single mip tail region for all layers
CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL = cydriver.CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL

#: Size of tensor map descriptor
CU_TENSOR_MAP_NUM_QWORDS = cydriver.CU_TENSOR_MAP_NUM_QWORDS

#: Indicates that the external memory object is a dedicated resource
CUDA_EXTERNAL_MEMORY_DEDICATED = cydriver.CUDA_EXTERNAL_MEMORY_DEDICATED

#: When the `flags` parameter of
#: :py:obj:`~.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS` contains this flag, it
#: indicates that signaling an external semaphore object should skip
#: performing appropriate memory synchronization operations over all the
#: external memory objects that are imported as
#: :py:obj:`~.CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF`, which otherwise are
#: performed by default to ensure data coherency with other importers of
#: the same NvSciBuf memory objects.
CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC = cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC

#: When the `flags` parameter of
#: :py:obj:`~.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS` contains this flag, it
#: indicates that waiting on an external semaphore object should skip
#: performing appropriate memory synchronization operations over all the
#: external memory objects that are imported as
#: :py:obj:`~.CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF`, which otherwise are
#: performed by default to ensure data coherency with other importers of
#: the same NvSciBuf memory objects.
CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC = cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC

#: When `flags` of :py:obj:`~.cuDeviceGetNvSciSyncAttributes` is set to
#: this, it indicates that application needs signaler specific
#: NvSciSyncAttr to be filled by
#: :py:obj:`~.cuDeviceGetNvSciSyncAttributes`.
CUDA_NVSCISYNC_ATTR_SIGNAL = cydriver.CUDA_NVSCISYNC_ATTR_SIGNAL

#: When `flags` of :py:obj:`~.cuDeviceGetNvSciSyncAttributes` is set to
#: this, it indicates that application needs waiter specific NvSciSyncAttr
#: to be filled by :py:obj:`~.cuDeviceGetNvSciSyncAttributes`.
CUDA_NVSCISYNC_ATTR_WAIT = cydriver.CUDA_NVSCISYNC_ATTR_WAIT

#: This flag if set indicates that the memory will be used as a tile pool.
CU_MEM_CREATE_USAGE_TILE_POOL = cydriver.CU_MEM_CREATE_USAGE_TILE_POOL

#: This flag, if set, indicates that the memory will be used as a buffer
#: for hardware accelerated decompression.
CU_MEM_CREATE_USAGE_HW_DECOMPRESS = cydriver.CU_MEM_CREATE_USAGE_HW_DECOMPRESS

#: This flag, if set, indicates that the memory will be used as a buffer
#: for hardware accelerated decompression.
CU_MEM_POOL_CREATE_USAGE_HW_DECOMPRESS = cydriver.CU_MEM_POOL_CREATE_USAGE_HW_DECOMPRESS

#: If set, each kernel launched as part of
#: :py:obj:`~.cuLaunchCooperativeKernelMultiDevice` only waits for prior
#: work in the stream corresponding to that GPU to complete before the
#: kernel begins execution.
CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC = cydriver.CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC

#: If set, any subsequent work pushed in a stream that participated in a
#: call to :py:obj:`~.cuLaunchCooperativeKernelMultiDevice` will only wait
#: for the kernel launched on the GPU corresponding to that stream to
#: complete before it begins execution.
CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC = cydriver.CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC

#: If set, the CUDA array is a collection of layers, where each layer is
#: either a 1D or a 2D array and the Depth member of
#: CUDA_ARRAY3D_DESCRIPTOR specifies the number of layers, not the depth of
#: a 3D array.
CUDA_ARRAY3D_LAYERED = cydriver.CUDA_ARRAY3D_LAYERED

#: Deprecated, use CUDA_ARRAY3D_LAYERED
CUDA_ARRAY3D_2DARRAY = cydriver.CUDA_ARRAY3D_2DARRAY

#: This flag must be set in order to bind a surface reference to the CUDA
#: array
CUDA_ARRAY3D_SURFACE_LDST = cydriver.CUDA_ARRAY3D_SURFACE_LDST

#: If set, the CUDA array is a collection of six 2D arrays, representing
#: faces of a cube. The width of such a CUDA array must be equal to its
#: height, and Depth must be six. If :py:obj:`~.CUDA_ARRAY3D_LAYERED` flag
#: is also set, then the CUDA array is a collection of cubemaps and Depth
#: must be a multiple of six.
CUDA_ARRAY3D_CUBEMAP = cydriver.CUDA_ARRAY3D_CUBEMAP

#: This flag must be set in order to perform texture gather operations on a
#: CUDA array.
CUDA_ARRAY3D_TEXTURE_GATHER = cydriver.CUDA_ARRAY3D_TEXTURE_GATHER

#: This flag if set indicates that the CUDA array is a DEPTH_TEXTURE.
CUDA_ARRAY3D_DEPTH_TEXTURE = cydriver.CUDA_ARRAY3D_DEPTH_TEXTURE

#: This flag indicates that the CUDA array may be bound as a color target
#: in an external graphics API
CUDA_ARRAY3D_COLOR_ATTACHMENT = cydriver.CUDA_ARRAY3D_COLOR_ATTACHMENT

#: This flag if set indicates that the CUDA array or CUDA mipmapped array
#: is a sparse CUDA array or CUDA mipmapped array respectively
CUDA_ARRAY3D_SPARSE = cydriver.CUDA_ARRAY3D_SPARSE

#: This flag if set indicates that the CUDA array or CUDA mipmapped array
#: will allow deferred memory mapping
CUDA_ARRAY3D_DEFERRED_MAPPING = cydriver.CUDA_ARRAY3D_DEFERRED_MAPPING

#: This flag indicates that the CUDA array will be used for hardware
#: accelerated video encode/decode operations.
CUDA_ARRAY3D_VIDEO_ENCODE_DECODE = cydriver.CUDA_ARRAY3D_VIDEO_ENCODE_DECODE

#: Override the texref format with a format inferred from the array. Flag
#: for :py:obj:`~.cuTexRefSetArray()`
CU_TRSA_OVERRIDE_FORMAT = cydriver.CU_TRSA_OVERRIDE_FORMAT

#: Read the texture as integers rather than promoting the values to floats
#: in the range [0,1]. Flag for :py:obj:`~.cuTexRefSetFlags()` and
#: :py:obj:`~.cuTexObjectCreate()`
CU_TRSF_READ_AS_INTEGER = cydriver.CU_TRSF_READ_AS_INTEGER

#: Use normalized texture coordinates in the range [0,1) instead of
#: [0,dim). Flag for :py:obj:`~.cuTexRefSetFlags()` and
#: :py:obj:`~.cuTexObjectCreate()`
CU_TRSF_NORMALIZED_COORDINATES = cydriver.CU_TRSF_NORMALIZED_COORDINATES

#: Perform sRGB->linear conversion during texture read. Flag for
#: :py:obj:`~.cuTexRefSetFlags()` and :py:obj:`~.cuTexObjectCreate()`
CU_TRSF_SRGB = cydriver.CU_TRSF_SRGB

#: Disable any trilinear filtering optimizations. Flag for
#: :py:obj:`~.cuTexRefSetFlags()` and :py:obj:`~.cuTexObjectCreate()`
CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION = cydriver.CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION

#: Enable seamless cube map filtering. Flag for
#: :py:obj:`~.cuTexObjectCreate()`
CU_TRSF_SEAMLESS_CUBEMAP = cydriver.CU_TRSF_SEAMLESS_CUBEMAP

#: Launch with the required block dimension.
CU_LAUNCH_KERNEL_REQUIRED_BLOCK_DIM = cydriver.CU_LAUNCH_KERNEL_REQUIRED_BLOCK_DIM

#: C++ compile time constant for CU_LAUNCH_PARAM_END
CU_LAUNCH_PARAM_END_AS_INT = cydriver.CU_LAUNCH_PARAM_END_AS_INT

#: End of array terminator for the `extra` parameter to
#: :py:obj:`~.cuLaunchKernel`
CU_LAUNCH_PARAM_END = cydriver.CU_LAUNCH_PARAM_END

#: C++ compile time constant for CU_LAUNCH_PARAM_BUFFER_POINTER
CU_LAUNCH_PARAM_BUFFER_POINTER_AS_INT = cydriver.CU_LAUNCH_PARAM_BUFFER_POINTER_AS_INT

#: Indicator that the next value in the `extra` parameter to
#: :py:obj:`~.cuLaunchKernel` will be a pointer to a buffer containing all
#: kernel parameters used for launching kernel `f`. This buffer needs to
#: honor all alignment/padding requirements of the individual parameters.
#: If :py:obj:`~.CU_LAUNCH_PARAM_BUFFER_SIZE` is not also specified in the
#: `extra` array, then :py:obj:`~.CU_LAUNCH_PARAM_BUFFER_POINTER` will have
#: no effect.
CU_LAUNCH_PARAM_BUFFER_POINTER = cydriver.CU_LAUNCH_PARAM_BUFFER_POINTER

#: C++ compile time constant for CU_LAUNCH_PARAM_BUFFER_SIZE
CU_LAUNCH_PARAM_BUFFER_SIZE_AS_INT = cydriver.CU_LAUNCH_PARAM_BUFFER_SIZE_AS_INT

#: Indicator that the next value in the `extra` parameter to
#: :py:obj:`~.cuLaunchKernel` will be a pointer to a size_t which contains
#: the size of the buffer specified with
#: :py:obj:`~.CU_LAUNCH_PARAM_BUFFER_POINTER`. It is required that
#: :py:obj:`~.CU_LAUNCH_PARAM_BUFFER_POINTER` also be specified in the
#: `extra` array if the value associated with
#: :py:obj:`~.CU_LAUNCH_PARAM_BUFFER_SIZE` is not zero.
CU_LAUNCH_PARAM_BUFFER_SIZE = cydriver.CU_LAUNCH_PARAM_BUFFER_SIZE

#: For texture references loaded into the module, use default texunit from
#: texture reference.
CU_PARAM_TR_DEFAULT = cydriver.CU_PARAM_TR_DEFAULT

#: Device that represents the CPU
CU_DEVICE_CPU = cydriver.CU_DEVICE_CPU

#: Device that represents an invalid device
CU_DEVICE_INVALID = cydriver.CU_DEVICE_INVALID

RESOURCE_ABI_VERSION = cydriver.RESOURCE_ABI_VERSION

RESOURCE_ABI_EXTERNAL_BYTES = cydriver.RESOURCE_ABI_EXTERNAL_BYTES

#: Maximum number of planes per frame
MAX_PLANES = cydriver.MAX_PLANES

#: Indicates that timeout for :py:obj:`~.cuEGLStreamConsumerAcquireFrame`
#: is infinite.
CUDA_EGL_INFINITE_TIMEOUT = cydriver.CUDA_EGL_INFINITE_TIMEOUT

class CUipcMem_flags(IntEnum):
    """
    CUDA Ipc Mem Flags
    """

    #: Automatically enable peer access between remote devices as needed
    CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS = cydriver.CUipcMem_flags_enum.CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS

_dict_CUipcMem_flags = dict(((int(v), v) for k, v in CUipcMem_flags.__members__.items()))

class CUmemAttach_flags(IntEnum):
    """
    CUDA Mem Attach Flags
    """

    #: Memory can be accessed by any stream on any device
    CU_MEM_ATTACH_GLOBAL = cydriver.CUmemAttach_flags_enum.CU_MEM_ATTACH_GLOBAL

    #: Memory cannot be accessed by any stream on any device
    CU_MEM_ATTACH_HOST = cydriver.CUmemAttach_flags_enum.CU_MEM_ATTACH_HOST

    #: Memory can only be accessed by a single stream on the associated
    #: device
    CU_MEM_ATTACH_SINGLE = cydriver.CUmemAttach_flags_enum.CU_MEM_ATTACH_SINGLE

_dict_CUmemAttach_flags = dict(((int(v), v) for k, v in CUmemAttach_flags.__members__.items()))

class CUctx_flags(IntEnum):
    """
    Context creation flags
    """

    #: Automatic scheduling
    CU_CTX_SCHED_AUTO = cydriver.CUctx_flags_enum.CU_CTX_SCHED_AUTO

    #: Set spin as default scheduling
    CU_CTX_SCHED_SPIN = cydriver.CUctx_flags_enum.CU_CTX_SCHED_SPIN

    #: Set yield as default scheduling
    CU_CTX_SCHED_YIELD = cydriver.CUctx_flags_enum.CU_CTX_SCHED_YIELD

    #: Set blocking synchronization as default scheduling
    CU_CTX_SCHED_BLOCKING_SYNC = cydriver.CUctx_flags_enum.CU_CTX_SCHED_BLOCKING_SYNC

    #: Set blocking synchronization as default scheduling [Deprecated]
    CU_CTX_BLOCKING_SYNC = cydriver.CUctx_flags_enum.CU_CTX_BLOCKING_SYNC
    CU_CTX_SCHED_MASK = cydriver.CUctx_flags_enum.CU_CTX_SCHED_MASK

    #: [Deprecated]
    CU_CTX_MAP_HOST = cydriver.CUctx_flags_enum.CU_CTX_MAP_HOST

    #: Keep local memory allocation after launch
    CU_CTX_LMEM_RESIZE_TO_MAX = cydriver.CUctx_flags_enum.CU_CTX_LMEM_RESIZE_TO_MAX

    #: Trigger coredumps from exceptions in this context
    CU_CTX_COREDUMP_ENABLE = cydriver.CUctx_flags_enum.CU_CTX_COREDUMP_ENABLE

    #: Enable user pipe to trigger coredumps in this context
    CU_CTX_USER_COREDUMP_ENABLE = cydriver.CUctx_flags_enum.CU_CTX_USER_COREDUMP_ENABLE

    #: Ensure synchronous memory operations on this context will
    #: synchronize
    CU_CTX_SYNC_MEMOPS = cydriver.CUctx_flags_enum.CU_CTX_SYNC_MEMOPS
    CU_CTX_FLAGS_MASK = cydriver.CUctx_flags_enum.CU_CTX_FLAGS_MASK

_dict_CUctx_flags = dict(((int(v), v) for k, v in CUctx_flags.__members__.items()))

class CUevent_sched_flags(IntEnum):
    """
    Event sched flags
    """

    #: Automatic scheduling
    CU_EVENT_SCHED_AUTO = cydriver.CUevent_sched_flags_enum.CU_EVENT_SCHED_AUTO

    #: Set spin as default scheduling
    CU_EVENT_SCHED_SPIN = cydriver.CUevent_sched_flags_enum.CU_EVENT_SCHED_SPIN

    #: Set yield as default scheduling
    CU_EVENT_SCHED_YIELD = cydriver.CUevent_sched_flags_enum.CU_EVENT_SCHED_YIELD

    #: Set blocking synchronization as default scheduling
    CU_EVENT_SCHED_BLOCKING_SYNC = cydriver.CUevent_sched_flags_enum.CU_EVENT_SCHED_BLOCKING_SYNC

_dict_CUevent_sched_flags = dict(((int(v), v) for k, v in CUevent_sched_flags.__members__.items()))

class cl_event_flags(IntEnum):
    """
    NVCL event scheduling flags
    """

    #: Automatic scheduling
    NVCL_EVENT_SCHED_AUTO = cydriver.cl_event_flags_enum.NVCL_EVENT_SCHED_AUTO

    #: Set spin as default scheduling
    NVCL_EVENT_SCHED_SPIN = cydriver.cl_event_flags_enum.NVCL_EVENT_SCHED_SPIN

    #: Set yield as default scheduling
    NVCL_EVENT_SCHED_YIELD = cydriver.cl_event_flags_enum.NVCL_EVENT_SCHED_YIELD

    #: Set blocking synchronization as default scheduling
    NVCL_EVENT_SCHED_BLOCKING_SYNC = cydriver.cl_event_flags_enum.NVCL_EVENT_SCHED_BLOCKING_SYNC

_dict_cl_event_flags = dict(((int(v), v) for k, v in cl_event_flags.__members__.items()))

class cl_context_flags(IntEnum):
    """
    NVCL context scheduling flags
    """

    #: Automatic scheduling
    NVCL_CTX_SCHED_AUTO = cydriver.cl_context_flags_enum.NVCL_CTX_SCHED_AUTO

    #: Set spin as default scheduling
    NVCL_CTX_SCHED_SPIN = cydriver.cl_context_flags_enum.NVCL_CTX_SCHED_SPIN

    #: Set yield as default scheduling
    NVCL_CTX_SCHED_YIELD = cydriver.cl_context_flags_enum.NVCL_CTX_SCHED_YIELD

    #: Set blocking synchronization as default scheduling
    NVCL_CTX_SCHED_BLOCKING_SYNC = cydriver.cl_context_flags_enum.NVCL_CTX_SCHED_BLOCKING_SYNC

_dict_cl_context_flags = dict(((int(v), v) for k, v in cl_context_flags.__members__.items()))

class CUstream_flags(IntEnum):
    """
    Stream creation flags
    """

    #: Default stream flag
    CU_STREAM_DEFAULT = cydriver.CUstream_flags_enum.CU_STREAM_DEFAULT

    #: Stream does not synchronize with stream 0 (the NULL stream)
    CU_STREAM_NON_BLOCKING = cydriver.CUstream_flags_enum.CU_STREAM_NON_BLOCKING

_dict_CUstream_flags = dict(((int(v), v) for k, v in CUstream_flags.__members__.items()))

class CUevent_flags(IntEnum):
    """
    Event creation flags
    """

    #: Default event flag
    CU_EVENT_DEFAULT = cydriver.CUevent_flags_enum.CU_EVENT_DEFAULT

    #: Event uses blocking synchronization
    CU_EVENT_BLOCKING_SYNC = cydriver.CUevent_flags_enum.CU_EVENT_BLOCKING_SYNC

    #: Event will not record timing data
    CU_EVENT_DISABLE_TIMING = cydriver.CUevent_flags_enum.CU_EVENT_DISABLE_TIMING

    #: Event is suitable for interprocess use. CU_EVENT_DISABLE_TIMING must
    #: be set
    CU_EVENT_INTERPROCESS = cydriver.CUevent_flags_enum.CU_EVENT_INTERPROCESS

_dict_CUevent_flags = dict(((int(v), v) for k, v in CUevent_flags.__members__.items()))

class CUevent_record_flags(IntEnum):
    """
    Event record flags
    """

    #: Default event record flag
    CU_EVENT_RECORD_DEFAULT = cydriver.CUevent_record_flags_enum.CU_EVENT_RECORD_DEFAULT

    #: When using stream capture, create an event record node instead of
    #: the default behavior. This flag is invalid when used outside of
    #: capture.
    CU_EVENT_RECORD_EXTERNAL = cydriver.CUevent_record_flags_enum.CU_EVENT_RECORD_EXTERNAL

_dict_CUevent_record_flags = dict(((int(v), v) for k, v in CUevent_record_flags.__members__.items()))

class CUevent_wait_flags(IntEnum):
    """
    Event wait flags
    """

    #: Default event wait flag
    CU_EVENT_WAIT_DEFAULT = cydriver.CUevent_wait_flags_enum.CU_EVENT_WAIT_DEFAULT

    #: When using stream capture, create an event wait node instead of the
    #: default behavior. This flag is invalid when used outside of capture.
    CU_EVENT_WAIT_EXTERNAL = cydriver.CUevent_wait_flags_enum.CU_EVENT_WAIT_EXTERNAL

_dict_CUevent_wait_flags = dict(((int(v), v) for k, v in CUevent_wait_flags.__members__.items()))

class CUstreamWaitValue_flags(IntEnum):
    """
    Flags for :py:obj:`~.cuStreamWaitValue32` and
    :py:obj:`~.cuStreamWaitValue64`
    """

    #: Wait until (int32_t)(*addr - value) >= 0 (or int64_t for 64 bit
    #: values). Note this is a cyclic comparison which ignores wraparound.
    #: (Default behavior.)
    CU_STREAM_WAIT_VALUE_GEQ = cydriver.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_GEQ

    #: Wait until *addr == value.
    CU_STREAM_WAIT_VALUE_EQ = cydriver.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_EQ

    #: Wait until (*addr & value) != 0.
    CU_STREAM_WAIT_VALUE_AND = cydriver.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_AND

    #: Wait until ~(*addr | value) != 0. Support for this operation can be
    #: queried with :py:obj:`~.cuDeviceGetAttribute()` and
    #: :py:obj:`~.CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR`.
    CU_STREAM_WAIT_VALUE_NOR = cydriver.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_NOR

    #: Follow the wait operation with a flush of outstanding remote writes.
    #: This means that, if a remote write operation is guaranteed to have
    #: reached the device before the wait can be satisfied, that write is
    #: guaranteed to be visible to downstream device work. The device is
    #: permitted to reorder remote writes internally. For example, this
    #: flag would be required if two remote writes arrive in a defined
    #: order, the wait is satisfied by the second write, and downstream
    #: work needs to observe the first write. Support for this operation is
    #: restricted to selected platforms and can be queried with
    #: :py:obj:`~.CU_DEVICE_ATTRIBUTE_CAN_FLUSH_REMOTE_WRITES`.
    CU_STREAM_WAIT_VALUE_FLUSH = cydriver.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_FLUSH

_dict_CUstreamWaitValue_flags = dict(((int(v), v) for k, v in CUstreamWaitValue_flags.__members__.items()))

class CUstreamWriteValue_flags(IntEnum):
    """
    Flags for :py:obj:`~.cuStreamWriteValue32`
    """

    #: Default behavior
    CU_STREAM_WRITE_VALUE_DEFAULT = cydriver.CUstreamWriteValue_flags_enum.CU_STREAM_WRITE_VALUE_DEFAULT

    #: Permits the write to be reordered with writes which were issued
    #: before it, as a performance optimization. Normally,
    #: :py:obj:`~.cuStreamWriteValue32` will provide a memory fence before
    #: the write, which has similar semantics to __threadfence_system() but
    #: is scoped to the stream rather than a CUDA thread. This flag is not
    #: supported in the v2 API.
    CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER = cydriver.CUstreamWriteValue_flags_enum.CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER

_dict_CUstreamWriteValue_flags = dict(((int(v), v) for k, v in CUstreamWriteValue_flags.__members__.items()))

class CUstreamBatchMemOpType(IntEnum):
    """
    Operations for :py:obj:`~.cuStreamBatchMemOp`
    """

    #: Represents a :py:obj:`~.cuStreamWaitValue32` operation
    CU_STREAM_MEM_OP_WAIT_VALUE_32 = cydriver.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WAIT_VALUE_32

    #: Represents a :py:obj:`~.cuStreamWriteValue32` operation
    CU_STREAM_MEM_OP_WRITE_VALUE_32 = cydriver.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WRITE_VALUE_32

    #: This has the same effect as :py:obj:`~.CU_STREAM_WAIT_VALUE_FLUSH`,
    #: but as a standalone operation.
    CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES = cydriver.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES

    #: Represents a :py:obj:`~.cuStreamWaitValue64` operation
    CU_STREAM_MEM_OP_WAIT_VALUE_64 = cydriver.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WAIT_VALUE_64

    #: Represents a :py:obj:`~.cuStreamWriteValue64` operation
    CU_STREAM_MEM_OP_WRITE_VALUE_64 = cydriver.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WRITE_VALUE_64

    #: Insert a memory barrier of the specified type
    CU_STREAM_MEM_OP_BARRIER = cydriver.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_BARRIER

_dict_CUstreamBatchMemOpType = dict(((int(v), v) for k, v in CUstreamBatchMemOpType.__members__.items()))

class CUstreamMemoryBarrier_flags(IntEnum):
    """
    Flags for :py:obj:`~.CUstreamBatchMemOpParams.memoryBarrier`
    """

    #: System-wide memory barrier.
    CU_STREAM_MEMORY_BARRIER_TYPE_SYS = cydriver.CUstreamMemoryBarrier_flags_enum.CU_STREAM_MEMORY_BARRIER_TYPE_SYS

    #: Limit memory barrier scope to the GPU.
    CU_STREAM_MEMORY_BARRIER_TYPE_GPU = cydriver.CUstreamMemoryBarrier_flags_enum.CU_STREAM_MEMORY_BARRIER_TYPE_GPU

_dict_CUstreamMemoryBarrier_flags = dict(((int(v), v) for k, v in CUstreamMemoryBarrier_flags.__members__.items()))

class CUoccupancy_flags(IntEnum):
    """
    Occupancy calculator flag
    """

    #: Default behavior
    CU_OCCUPANCY_DEFAULT = cydriver.CUoccupancy_flags_enum.CU_OCCUPANCY_DEFAULT

    #: Assume global caching is enabled and cannot be automatically turned
    #: off
    CU_OCCUPANCY_DISABLE_CACHING_OVERRIDE = cydriver.CUoccupancy_flags_enum.CU_OCCUPANCY_DISABLE_CACHING_OVERRIDE

_dict_CUoccupancy_flags = dict(((int(v), v) for k, v in CUoccupancy_flags.__members__.items()))

class CUstreamUpdateCaptureDependencies_flags(IntEnum):
    """
    Flags for :py:obj:`~.cuStreamUpdateCaptureDependencies`
    """

    #: Add new nodes to the dependency set
    CU_STREAM_ADD_CAPTURE_DEPENDENCIES = cydriver.CUstreamUpdateCaptureDependencies_flags_enum.CU_STREAM_ADD_CAPTURE_DEPENDENCIES

    #: Replace the dependency set with the new nodes
    CU_STREAM_SET_CAPTURE_DEPENDENCIES = cydriver.CUstreamUpdateCaptureDependencies_flags_enum.CU_STREAM_SET_CAPTURE_DEPENDENCIES

_dict_CUstreamUpdateCaptureDependencies_flags = dict(((int(v), v) for k, v in CUstreamUpdateCaptureDependencies_flags.__members__.items()))

class CUasyncNotificationType(IntEnum):
    """
    Types of async notification that can be sent
    """

    #: Sent when the process has exceeded its device memory budget
    CU_ASYNC_NOTIFICATION_TYPE_OVER_BUDGET = cydriver.CUasyncNotificationType_enum.CU_ASYNC_NOTIFICATION_TYPE_OVER_BUDGET

_dict_CUasyncNotificationType = dict(((int(v), v) for k, v in CUasyncNotificationType.__members__.items()))

class CUarray_format(IntEnum):
    """
    Array formats
    """

    #: Unsigned 8-bit integers
    CU_AD_FORMAT_UNSIGNED_INT8 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNSIGNED_INT8

    #: Unsigned 16-bit integers
    CU_AD_FORMAT_UNSIGNED_INT16 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNSIGNED_INT16

    #: Unsigned 32-bit integers
    CU_AD_FORMAT_UNSIGNED_INT32 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNSIGNED_INT32

    #: Signed 8-bit integers
    CU_AD_FORMAT_SIGNED_INT8 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SIGNED_INT8

    #: Signed 16-bit integers
    CU_AD_FORMAT_SIGNED_INT16 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SIGNED_INT16

    #: Signed 32-bit integers
    CU_AD_FORMAT_SIGNED_INT32 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SIGNED_INT32

    #: 16-bit floating point
    CU_AD_FORMAT_HALF = cydriver.CUarray_format_enum.CU_AD_FORMAT_HALF

    #: 32-bit floating point
    CU_AD_FORMAT_FLOAT = cydriver.CUarray_format_enum.CU_AD_FORMAT_FLOAT

    #: 4 channel unorm R10G10B10A2 RGB format
    CU_AD_FORMAT_UNORM_INT_101010_2 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT_101010_2

    #: 4 channel unsigned normalized block-compressed (BC1 compression)
    #: format
    CU_AD_FORMAT_BC1_UNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC1_UNORM

    #: 4 channel unsigned normalized block-compressed (BC1 compression)
    #: format with sRGB encoding
    CU_AD_FORMAT_BC1_UNORM_SRGB = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC1_UNORM_SRGB

    #: 4 channel unsigned normalized block-compressed (BC2 compression)
    #: format
    CU_AD_FORMAT_BC2_UNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC2_UNORM

    #: 4 channel unsigned normalized block-compressed (BC2 compression)
    #: format with sRGB encoding
    CU_AD_FORMAT_BC2_UNORM_SRGB = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC2_UNORM_SRGB

    #: 4 channel unsigned normalized block-compressed (BC3 compression)
    #: format
    CU_AD_FORMAT_BC3_UNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC3_UNORM

    #: 4 channel unsigned normalized block-compressed (BC3 compression)
    #: format with sRGB encoding
    CU_AD_FORMAT_BC3_UNORM_SRGB = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC3_UNORM_SRGB

    #: 1 channel unsigned normalized block-compressed (BC4 compression)
    #: format
    CU_AD_FORMAT_BC4_UNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC4_UNORM

    #: 1 channel signed normalized block-compressed (BC4 compression)
    #: format
    CU_AD_FORMAT_BC4_SNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC4_SNORM

    #: 2 channel unsigned normalized block-compressed (BC5 compression)
    #: format
    CU_AD_FORMAT_BC5_UNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC5_UNORM

    #: 2 channel signed normalized block-compressed (BC5 compression)
    #: format
    CU_AD_FORMAT_BC5_SNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC5_SNORM

    #: 3 channel unsigned half-float block-compressed (BC6H compression)
    #: format
    CU_AD_FORMAT_BC6H_UF16 = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC6H_UF16

    #: 3 channel signed half-float block-compressed (BC6H compression)
    #: format
    CU_AD_FORMAT_BC6H_SF16 = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC6H_SF16

    #: 4 channel unsigned normalized block-compressed (BC7 compression)
    #: format
    CU_AD_FORMAT_BC7_UNORM = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC7_UNORM

    #: 4 channel unsigned normalized block-compressed (BC7 compression)
    #: format with sRGB encoding
    CU_AD_FORMAT_BC7_UNORM_SRGB = cydriver.CUarray_format_enum.CU_AD_FORMAT_BC7_UNORM_SRGB

    #: 10-bit YUV planar format, with 4:2:0 sampling
    CU_AD_FORMAT_P010 = cydriver.CUarray_format_enum.CU_AD_FORMAT_P010

    #: 16-bit YUV planar format, with 4:2:0 sampling
    CU_AD_FORMAT_P016 = cydriver.CUarray_format_enum.CU_AD_FORMAT_P016

    #: 8-bit YUV planar format, with 4:2:2 sampling
    CU_AD_FORMAT_NV16 = cydriver.CUarray_format_enum.CU_AD_FORMAT_NV16

    #: 10-bit YUV planar format, with 4:2:2 sampling
    CU_AD_FORMAT_P210 = cydriver.CUarray_format_enum.CU_AD_FORMAT_P210

    #: 16-bit YUV planar format, with 4:2:2 sampling
    CU_AD_FORMAT_P216 = cydriver.CUarray_format_enum.CU_AD_FORMAT_P216

    #: 2 channel, 8-bit YUV packed planar format, with 4:2:2 sampling
    CU_AD_FORMAT_YUY2 = cydriver.CUarray_format_enum.CU_AD_FORMAT_YUY2

    #: 2 channel, 10-bit YUV packed planar format, with 4:2:2 sampling
    CU_AD_FORMAT_Y210 = cydriver.CUarray_format_enum.CU_AD_FORMAT_Y210

    #: 2 channel, 16-bit YUV packed planar format, with 4:2:2 sampling
    CU_AD_FORMAT_Y216 = cydriver.CUarray_format_enum.CU_AD_FORMAT_Y216

    #: 4 channel, 8-bit YUV packed planar format, with 4:4:4 sampling
    CU_AD_FORMAT_AYUV = cydriver.CUarray_format_enum.CU_AD_FORMAT_AYUV

    #: 10-bit YUV packed planar format, with 4:4:4 sampling
    CU_AD_FORMAT_Y410 = cydriver.CUarray_format_enum.CU_AD_FORMAT_Y410

    #: 8-bit YUV planar format, with 4:2:0 sampling
    CU_AD_FORMAT_NV12 = cydriver.CUarray_format_enum.CU_AD_FORMAT_NV12

    #: 4 channel, 12-bit YUV packed planar format, with 4:4:4 sampling
    CU_AD_FORMAT_Y416 = cydriver.CUarray_format_enum.CU_AD_FORMAT_Y416

    #: 3 channel 8-bit YUV planar format, with 4:4:4 sampling
    CU_AD_FORMAT_Y444_PLANAR8 = cydriver.CUarray_format_enum.CU_AD_FORMAT_Y444_PLANAR8

    #: 3 channel 10-bit YUV planar format, with 4:4:4 sampling
    CU_AD_FORMAT_Y444_PLANAR10 = cydriver.CUarray_format_enum.CU_AD_FORMAT_Y444_PLANAR10

    #: 3 channel 8-bit YUV semi-planar format, with 4:4:4 sampling
    CU_AD_FORMAT_YUV444_8bit_SemiPlanar = cydriver.CUarray_format_enum.CU_AD_FORMAT_YUV444_8bit_SemiPlanar

    #: 3 channel 16-bit YUV semi-planar format, with 4:4:4 sampling
    CU_AD_FORMAT_YUV444_16bit_SemiPlanar = cydriver.CUarray_format_enum.CU_AD_FORMAT_YUV444_16bit_SemiPlanar

    #: 1 channel unsigned 8-bit normalized integer
    CU_AD_FORMAT_UNORM_INT8X1 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT8X1

    #: 2 channel unsigned 8-bit normalized integer
    CU_AD_FORMAT_UNORM_INT8X2 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT8X2

    #: 4 channel unsigned 8-bit normalized integer
    CU_AD_FORMAT_UNORM_INT8X4 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT8X4

    #: 1 channel unsigned 16-bit normalized integer
    CU_AD_FORMAT_UNORM_INT16X1 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT16X1

    #: 2 channel unsigned 16-bit normalized integer
    CU_AD_FORMAT_UNORM_INT16X2 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT16X2

    #: 4 channel unsigned 16-bit normalized integer
    CU_AD_FORMAT_UNORM_INT16X4 = cydriver.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT16X4

    #: 1 channel signed 8-bit normalized integer
    CU_AD_FORMAT_SNORM_INT8X1 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT8X1

    #: 2 channel signed 8-bit normalized integer
    CU_AD_FORMAT_SNORM_INT8X2 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT8X2

    #: 4 channel signed 8-bit normalized integer
    CU_AD_FORMAT_SNORM_INT8X4 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT8X4

    #: 1 channel signed 16-bit normalized integer
    CU_AD_FORMAT_SNORM_INT16X1 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT16X1

    #: 2 channel signed 16-bit normalized integer
    CU_AD_FORMAT_SNORM_INT16X2 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT16X2

    #: 4 channel signed 16-bit normalized integer
    CU_AD_FORMAT_SNORM_INT16X4 = cydriver.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT16X4
    CU_AD_FORMAT_MAX = cydriver.CUarray_format_enum.CU_AD_FORMAT_MAX

_dict_CUarray_format = dict(((int(v), v) for k, v in CUarray_format.__members__.items()))

class CUaddress_mode(IntEnum):
    """
    Texture reference addressing modes
    """

    #: Wrapping address mode
    CU_TR_ADDRESS_MODE_WRAP = cydriver.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_WRAP

    #: Clamp to edge address mode
    CU_TR_ADDRESS_MODE_CLAMP = cydriver.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_CLAMP

    #: Mirror address mode
    CU_TR_ADDRESS_MODE_MIRROR = cydriver.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_MIRROR

    #: Border address mode
    CU_TR_ADDRESS_MODE_BORDER = cydriver.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_BORDER

_dict_CUaddress_mode = dict(((int(v), v) for k, v in CUaddress_mode.__members__.items()))

class CUfilter_mode(IntEnum):
    """
    Texture reference filtering modes
    """

    #: Point filter mode
    CU_TR_FILTER_MODE_POINT = cydriver.CUfilter_mode_enum.CU_TR_FILTER_MODE_POINT

    #: Linear filter mode
    CU_TR_FILTER_MODE_LINEAR = cydriver.CUfilter_mode_enum.CU_TR_FILTER_MODE_LINEAR

_dict_CUfilter_mode = dict(((int(v), v) for k, v in CUfilter_mode.__members__.items()))

class CUdevice_attribute(IntEnum):
    """
    Device properties
    """

    #: Maximum number of threads per block
    CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK

    #: Maximum block dimension X
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X

    #: Maximum block dimension Y
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y

    #: Maximum block dimension Z
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z

    #: Maximum grid dimension X
    CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X

    #: Maximum grid dimension Y
    CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y

    #: Maximum grid dimension Z
    CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z

    #: Maximum shared memory available per block in bytes
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK

    #: Deprecated, use CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK

    #: Memory available on device for constant variables in a CUDA C kernel
    #: in bytes
    CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY

    #: Warp size in threads
    CU_DEVICE_ATTRIBUTE_WARP_SIZE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_WARP_SIZE

    #: Maximum pitch in bytes allowed by memory copies
    CU_DEVICE_ATTRIBUTE_MAX_PITCH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_PITCH

    #: Maximum number of 32-bit registers available per block
    CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK

    #: Deprecated, use CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK

    #: Typical clock frequency in kilohertz
    CU_DEVICE_ATTRIBUTE_CLOCK_RATE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CLOCK_RATE

    #: Alignment requirement for textures
    CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT

    #: Device can possibly copy memory and execute a kernel concurrently.
    #: Deprecated. Use instead CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT.
    CU_DEVICE_ATTRIBUTE_GPU_OVERLAP = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_OVERLAP

    #: Number of multiprocessors on device
    CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT

    #: Specifies whether there is a run time limit on kernels
    CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT

    #: Device is integrated with host memory
    CU_DEVICE_ATTRIBUTE_INTEGRATED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_INTEGRATED

    #: Device can map host memory into CUDA address space
    CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY

    #: Compute mode (See :py:obj:`~.CUcomputemode` for details)
    CU_DEVICE_ATTRIBUTE_COMPUTE_MODE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_MODE

    #: Maximum 1D texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH

    #: Maximum 2D texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH

    #: Maximum 2D texture height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT

    #: Maximum 3D texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH

    #: Maximum 3D texture height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT

    #: Maximum 3D texture depth
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH

    #: Maximum 2D layered texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH

    #: Deprecated, use CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_WIDTH

    #: Maximum 2D layered texture height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT

    #: Deprecated, use CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_HEIGHT

    #: Maximum layers in a 2D layered texture
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS

    #: Deprecated, use CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_NUMSLICES = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_NUMSLICES

    #: Alignment requirement for surfaces
    CU_DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT

    #: Device can possibly execute multiple kernels concurrently
    CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS

    #: Device has ECC support enabled
    CU_DEVICE_ATTRIBUTE_ECC_ENABLED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_ECC_ENABLED

    #: PCI bus ID of the device
    CU_DEVICE_ATTRIBUTE_PCI_BUS_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PCI_BUS_ID

    #: PCI device ID of the device
    CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID

    #: Device is using TCC driver model
    CU_DEVICE_ATTRIBUTE_TCC_DRIVER = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TCC_DRIVER

    #: Peak memory clock frequency in kilohertz
    CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE

    #: Global memory bus width in bits
    CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH

    #: Size of L2 cache in bytes
    CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE

    #: Maximum resident threads per multiprocessor
    CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR

    #: Number of asynchronous engines
    CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT

    #: Device shares a unified address space with the host
    CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING

    #: Maximum 1D layered texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH

    #: Maximum layers in a 1D layered texture
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS

    #: Deprecated, do not use.
    CU_DEVICE_ATTRIBUTE_CAN_TEX2D_GATHER = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_TEX2D_GATHER

    #: Maximum 2D texture width if CUDA_ARRAY3D_TEXTURE_GATHER is set
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH

    #: Maximum 2D texture height if CUDA_ARRAY3D_TEXTURE_GATHER is set
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT

    #: Alternate maximum 3D texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE

    #: Alternate maximum 3D texture height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE

    #: Alternate maximum 3D texture depth
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE

    #: PCI domain ID of the device
    CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID

    #: Pitch alignment requirement for textures
    CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT

    #: Maximum cubemap texture width/height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH

    #: Maximum cubemap layered texture width/height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH

    #: Maximum layers in a cubemap layered texture
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS

    #: Maximum 1D surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH

    #: Maximum 2D surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH

    #: Maximum 2D surface height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT

    #: Maximum 3D surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH

    #: Maximum 3D surface height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT

    #: Maximum 3D surface depth
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH

    #: Maximum 1D layered surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH

    #: Maximum layers in a 1D layered surface
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS

    #: Maximum 2D layered surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH

    #: Maximum 2D layered surface height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT

    #: Maximum layers in a 2D layered surface
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS

    #: Maximum cubemap surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH

    #: Maximum cubemap layered surface width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH

    #: Maximum layers in a cubemap layered surface
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS

    #: Deprecated, do not use. Use cudaDeviceGetTexture1DLinearMaxWidth()
    #: or :py:obj:`~.cuDeviceGetTexture1DLinearMaxWidth()` instead.
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH

    #: Maximum 2D linear texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH

    #: Maximum 2D linear texture height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT

    #: Maximum 2D linear texture pitch in bytes
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH

    #: Maximum mipmapped 2D texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH

    #: Maximum mipmapped 2D texture height
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT

    #: Major compute capability version number
    CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR

    #: Minor compute capability version number
    CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR

    #: Maximum mipmapped 1D texture width
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH

    #: Device supports stream priorities
    CU_DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED

    #: Device supports caching globals in L1
    CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED

    #: Device supports caching locals in L1
    CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED

    #: Maximum shared memory available per multiprocessor in bytes
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR

    #: Maximum number of 32-bit registers available per multiprocessor
    CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR

    #: Device can allocate managed memory on this system
    CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY

    #: Device is on a multi-GPU board
    CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD

    #: Unique id for a group of devices on the same multi-GPU board
    CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID

    #: Link between the device and the host supports all native atomic
    #: operations
    CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED

    #: Ratio of single precision performance (in floating-point operations
    #: per second) to double precision performance
    CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO

    #: Device supports coherently accessing pageable memory without calling
    #: cudaHostRegister on it
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS

    #: Device can coherently access managed memory concurrently with the
    #: CPU
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS

    #: Device supports compute preemption.
    CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED

    #: Device can access host registered memory at the same virtual address
    #: as the CPU
    CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM

    #: Deprecated, along with v1 MemOps API, :py:obj:`~.cuStreamBatchMemOp`
    #: and related APIs are supported.
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS_V1 = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS_V1

    #: Deprecated, along with v1 MemOps API, 64-bit operations are
    #: supported in :py:obj:`~.cuStreamBatchMemOp` and related APIs.
    CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS_V1 = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS_V1

    #: Deprecated, along with v1 MemOps API,
    #: :py:obj:`~.CU_STREAM_WAIT_VALUE_NOR` is supported.
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR_V1 = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR_V1

    #: Device supports launching cooperative kernels via
    #: :py:obj:`~.cuLaunchCooperativeKernel`
    CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH

    #: Deprecated, :py:obj:`~.cuLaunchCooperativeKernelMultiDevice` is
    #: deprecated.
    CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH

    #: Maximum optin shared memory per block
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN

    #: The :py:obj:`~.CU_STREAM_WAIT_VALUE_FLUSH` flag and the
    #: :py:obj:`~.CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES` MemOp are supported
    #: on the device. See :py:obj:`~.Stream Memory Operations` for
    #: additional details.
    CU_DEVICE_ATTRIBUTE_CAN_FLUSH_REMOTE_WRITES = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_FLUSH_REMOTE_WRITES

    #: Device supports host memory registration via
    #: :py:obj:`~.cudaHostRegister`.
    CU_DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED

    #: Device accesses pageable memory via the host's page tables.
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES

    #: The host can directly access managed memory on the device without
    #: migration.
    CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST

    #: Deprecated, Use
    #: CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED
    CU_DEVICE_ATTRIBUTE_VIRTUAL_ADDRESS_MANAGEMENT_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_VIRTUAL_ADDRESS_MANAGEMENT_SUPPORTED

    #: Device supports virtual memory management APIs like
    #: :py:obj:`~.cuMemAddressReserve`, :py:obj:`~.cuMemCreate`,
    #: :py:obj:`~.cuMemMap` and related APIs
    CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED

    #: Device supports exporting memory to a posix file descriptor with
    #: :py:obj:`~.cuMemExportToShareableHandle`, if requested via
    #: :py:obj:`~.cuMemCreate`
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR_SUPPORTED

    #: Device supports exporting memory to a Win32 NT handle with
    #: :py:obj:`~.cuMemExportToShareableHandle`, if requested via
    #: :py:obj:`~.cuMemCreate`
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_HANDLE_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_HANDLE_SUPPORTED

    #: Device supports exporting memory to a Win32 KMT handle with
    #: :py:obj:`~.cuMemExportToShareableHandle`, if requested via
    #: :py:obj:`~.cuMemCreate`
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_KMT_HANDLE_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_KMT_HANDLE_SUPPORTED

    #: Maximum number of blocks per multiprocessor
    CU_DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR

    #: Device supports compression of memory
    CU_DEVICE_ATTRIBUTE_GENERIC_COMPRESSION_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GENERIC_COMPRESSION_SUPPORTED

    #: Maximum L2 persisting lines capacity setting in bytes.
    CU_DEVICE_ATTRIBUTE_MAX_PERSISTING_L2_CACHE_SIZE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_PERSISTING_L2_CACHE_SIZE

    #: Maximum value of :py:obj:`~.CUaccessPolicyWindow.num_bytes`.
    CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE

    #: Device supports specifying the GPUDirect RDMA flag with
    #: :py:obj:`~.cuMemCreate`
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WITH_CUDA_VMM_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WITH_CUDA_VMM_SUPPORTED

    #: Shared memory reserved by CUDA driver per block in bytes
    CU_DEVICE_ATTRIBUTE_RESERVED_SHARED_MEMORY_PER_BLOCK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_RESERVED_SHARED_MEMORY_PER_BLOCK

    #: Device supports sparse CUDA arrays and sparse CUDA mipmapped arrays
    CU_DEVICE_ATTRIBUTE_SPARSE_CUDA_ARRAY_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SPARSE_CUDA_ARRAY_SUPPORTED

    #: Device supports using the :py:obj:`~.cuMemHostRegister` flag
    #: :py:obj:`~.CU_MEMHOSTERGISTER_READ_ONLY` to register memory that
    #: must be mapped as read-only to the GPU
    CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED

    #: External timeline semaphore interop is supported on the device
    CU_DEVICE_ATTRIBUTE_TIMELINE_SEMAPHORE_INTEROP_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TIMELINE_SEMAPHORE_INTEROP_SUPPORTED

    #: Device supports using the :py:obj:`~.cuMemAllocAsync` and
    #: :py:obj:`~.cuMemPool` family of APIs
    CU_DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED

    #: Device supports GPUDirect RDMA APIs, like nvidia_p2p_get_pages (see
    #: https://docs.nvidia.com/cuda/gpudirect-rdma for more information)
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_SUPPORTED

    #: The returned attribute shall be interpreted as a bitmask, where the
    #: individual bits are described by the
    #: :py:obj:`~.CUflushGPUDirectRDMAWritesOptions` enum
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS

    #: GPUDirect RDMA writes to the device do not need to be flushed for
    #: consumers within the scope indicated by the returned attribute. See
    #: :py:obj:`~.CUGPUDirectRDMAWritesOrdering` for the numerical values
    #: returned here.
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING

    #: Handle types supported with mempool based IPC
    CU_DEVICE_ATTRIBUTE_MEMPOOL_SUPPORTED_HANDLE_TYPES = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEMPOOL_SUPPORTED_HANDLE_TYPES

    #: Indicates device supports cluster launch
    CU_DEVICE_ATTRIBUTE_CLUSTER_LAUNCH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CLUSTER_LAUNCH

    #: Device supports deferred mapping CUDA arrays and CUDA mipmapped
    #: arrays
    CU_DEVICE_ATTRIBUTE_DEFERRED_MAPPING_CUDA_ARRAY_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_DEFERRED_MAPPING_CUDA_ARRAY_SUPPORTED

    #: 64-bit operations are supported in :py:obj:`~.cuStreamBatchMemOp`
    #: and related MemOp APIs.
    CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS

    #: :py:obj:`~.CU_STREAM_WAIT_VALUE_NOR` is supported by MemOp APIs.
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR

    #: Device supports buffer sharing with dma_buf mechanism.
    CU_DEVICE_ATTRIBUTE_DMA_BUF_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_DMA_BUF_SUPPORTED

    #: Device supports IPC Events.
    CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED

    #: Number of memory domains the device supports.
    CU_DEVICE_ATTRIBUTE_MEM_SYNC_DOMAIN_COUNT = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEM_SYNC_DOMAIN_COUNT

    #: Device supports accessing memory using Tensor Map.
    CU_DEVICE_ATTRIBUTE_TENSOR_MAP_ACCESS_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TENSOR_MAP_ACCESS_SUPPORTED

    #: Device supports exporting memory to a fabric handle with
    #: :py:obj:`~.cuMemExportToShareableHandle()` or requested with
    #: :py:obj:`~.cuMemCreate()`
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_FABRIC_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_FABRIC_SUPPORTED

    #: Device supports unified function pointers.
    CU_DEVICE_ATTRIBUTE_UNIFIED_FUNCTION_POINTERS = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_UNIFIED_FUNCTION_POINTERS

    #: NUMA configuration of a device: value is of type
    #: :py:obj:`~.CUdeviceNumaConfig` enum
    CU_DEVICE_ATTRIBUTE_NUMA_CONFIG = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_NUMA_CONFIG

    #: NUMA node ID of the GPU memory
    CU_DEVICE_ATTRIBUTE_NUMA_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_NUMA_ID

    #: Device supports switch multicast and reduction operations.
    CU_DEVICE_ATTRIBUTE_MULTICAST_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTICAST_SUPPORTED

    #: Indicates if contexts created on this device will be shared via MPS
    CU_DEVICE_ATTRIBUTE_MPS_ENABLED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MPS_ENABLED

    #: NUMA ID of the host node closest to the device. Returns -1 when
    #: system does not support NUMA.
    CU_DEVICE_ATTRIBUTE_HOST_NUMA_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_NUMA_ID

    #: Device supports CIG with D3D12.
    CU_DEVICE_ATTRIBUTE_D3D12_CIG_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_D3D12_CIG_SUPPORTED

    #: The returned valued shall be interpreted as a bitmask, where the
    #: individual bits are described by the
    #: :py:obj:`~.CUmemDecompressAlgorithm` enum.
    CU_DEVICE_ATTRIBUTE_MEM_DECOMPRESS_ALGORITHM_MASK = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEM_DECOMPRESS_ALGORITHM_MASK

    #: The returned valued is the maximum length in bytes of a single
    #: decompress operation that is allowed.
    CU_DEVICE_ATTRIBUTE_MEM_DECOMPRESS_MAXIMUM_LENGTH = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEM_DECOMPRESS_MAXIMUM_LENGTH

    #: Device supports CIG with Vulkan.
    CU_DEVICE_ATTRIBUTE_VULKAN_CIG_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_VULKAN_CIG_SUPPORTED

    #: The combined 16-bit PCI device ID and 16-bit PCI vendor ID.
    CU_DEVICE_ATTRIBUTE_GPU_PCI_DEVICE_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_PCI_DEVICE_ID

    #: The combined 16-bit PCI subsystem ID and 16-bit PCI subsystem vendor
    #: ID.
    CU_DEVICE_ATTRIBUTE_GPU_PCI_SUBSYSTEM_ID = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_PCI_SUBSYSTEM_ID

    #: Device supports HOST_NUMA location with the virtual memory
    #: management APIs like :py:obj:`~.cuMemCreate`, :py:obj:`~.cuMemMap`
    #: and related APIs
    CU_DEVICE_ATTRIBUTE_HOST_NUMA_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_NUMA_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED

    #: Device supports HOST_NUMA location with the
    #: :py:obj:`~.cuMemAllocAsync` and :py:obj:`~.cuMemPool` family of APIs
    CU_DEVICE_ATTRIBUTE_HOST_NUMA_MEMORY_POOLS_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_NUMA_MEMORY_POOLS_SUPPORTED

    #: Device supports HOST_NUMA location IPC between nodes in a multi-node
    #: system.
    CU_DEVICE_ATTRIBUTE_HOST_NUMA_MULTINODE_IPC_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_NUMA_MULTINODE_IPC_SUPPORTED

    #: Device suports HOST location with the :py:obj:`~.cuMemAllocAsync`
    #: and :py:obj:`~.cuMemPool` family of APIs
    CU_DEVICE_ATTRIBUTE_HOST_MEMORY_POOLS_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_MEMORY_POOLS_SUPPORTED

    #: Device supports HOST location with the virtual memory management
    #: APIs like :py:obj:`~.cuMemCreate`, :py:obj:`~.cuMemMap` and related
    #: APIs
    CU_DEVICE_ATTRIBUTE_HOST_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED

    #: Device supports page-locked host memory buffer sharing with dma_buf
    #: mechanism.
    CU_DEVICE_ATTRIBUTE_HOST_ALLOC_DMA_BUF_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_ALLOC_DMA_BUF_SUPPORTED

    #: Link between the device and the host supports only some native
    #: atomic operations
    CU_DEVICE_ATTRIBUTE_ONLY_PARTIAL_HOST_NATIVE_ATOMIC_SUPPORTED = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_ONLY_PARTIAL_HOST_NATIVE_ATOMIC_SUPPORTED
    CU_DEVICE_ATTRIBUTE_MAX = cydriver.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX

_dict_CUdevice_attribute = dict(((int(v), v) for k, v in CUdevice_attribute.__members__.items()))

class CUpointer_attribute(IntEnum):
    """
    Pointer information
    """

    #: The :py:obj:`~.CUcontext` on which a pointer was allocated or
    #: registered
    CU_POINTER_ATTRIBUTE_CONTEXT = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_CONTEXT

    #: The :py:obj:`~.CUmemorytype` describing the physical location of a
    #: pointer
    CU_POINTER_ATTRIBUTE_MEMORY_TYPE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MEMORY_TYPE

    #: The address at which a pointer's memory may be accessed on the
    #: device
    CU_POINTER_ATTRIBUTE_DEVICE_POINTER = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_DEVICE_POINTER

    #: The address at which a pointer's memory may be accessed on the host
    CU_POINTER_ATTRIBUTE_HOST_POINTER = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_HOST_POINTER

    #: A pair of tokens for use with the nv-p2p.h Linux kernel interface
    CU_POINTER_ATTRIBUTE_P2P_TOKENS = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_P2P_TOKENS

    #: Synchronize every synchronous memory operation initiated on this
    #: region
    CU_POINTER_ATTRIBUTE_SYNC_MEMOPS = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_SYNC_MEMOPS

    #: A process-wide unique ID for an allocated memory region
    CU_POINTER_ATTRIBUTE_BUFFER_ID = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_BUFFER_ID

    #: Indicates if the pointer points to managed memory
    CU_POINTER_ATTRIBUTE_IS_MANAGED = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_MANAGED

    #: A device ordinal of a device on which a pointer was allocated or
    #: registered
    CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL

    #: 1 if this pointer maps to an allocation that is suitable for
    #: :py:obj:`~.cudaIpcGetMemHandle`, 0 otherwise
    CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE

    #: Starting address for this requested pointer
    CU_POINTER_ATTRIBUTE_RANGE_START_ADDR = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_RANGE_START_ADDR

    #: Size of the address range for this requested pointer
    CU_POINTER_ATTRIBUTE_RANGE_SIZE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_RANGE_SIZE

    #: 1 if this pointer is in a valid address range that is mapped to a
    #: backing allocation, 0 otherwise
    CU_POINTER_ATTRIBUTE_MAPPED = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MAPPED

    #: Bitmask of allowed :py:obj:`~.CUmemAllocationHandleType` for this
    #: allocation
    CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES

    #: 1 if the memory this pointer is referencing can be used with the
    #: GPUDirect RDMA API
    CU_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE

    #: Returns the access flags the device associated with the current
    #: context has on the corresponding memory referenced by the pointer
    #: given
    CU_POINTER_ATTRIBUTE_ACCESS_FLAGS = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAGS

    #: Returns the mempool handle for the allocation if it was allocated
    #: from a mempool. Otherwise returns NULL.
    CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE

    #: Size of the actual underlying mapping that the pointer belongs to
    CU_POINTER_ATTRIBUTE_MAPPING_SIZE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MAPPING_SIZE

    #: The start address of the mapping that the pointer belongs to
    CU_POINTER_ATTRIBUTE_MAPPING_BASE_ADDR = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MAPPING_BASE_ADDR

    #: A process-wide unique id corresponding to the physical allocation
    #: the pointer belongs to
    CU_POINTER_ATTRIBUTE_MEMORY_BLOCK_ID = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MEMORY_BLOCK_ID

    #: Returns in `*data` a boolean that indicates whether the pointer
    #: points to memory that is capable to be used for hardware accelerated
    #: decompression.
    CU_POINTER_ATTRIBUTE_IS_HW_DECOMPRESS_CAPABLE = cydriver.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_HW_DECOMPRESS_CAPABLE

_dict_CUpointer_attribute = dict(((int(v), v) for k, v in CUpointer_attribute.__members__.items()))

class CUfunction_attribute(IntEnum):
    """
    Function properties
    """

    #: The maximum number of threads per block, beyond which a launch of
    #: the function would fail. This number depends on both the function
    #: and the device on which the function is currently loaded.
    CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK

    #: The size in bytes of statically-allocated shared memory required by
    #: this function. This does not include dynamically-allocated shared
    #: memory requested by the user at runtime.
    CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES

    #: The size in bytes of user-allocated constant memory required by this
    #: function.
    CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES

    #: The size in bytes of local memory used by each thread of this
    #: function.
    CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES

    #: The number of registers used by each thread of this function.
    CU_FUNC_ATTRIBUTE_NUM_REGS = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_NUM_REGS

    #: The PTX virtual architecture version for which the function was
    #: compiled. This value is the major PTX version * 10 + the minor PTX
    #: version, so a PTX version 1.3 function would return the value 13.
    #: Note that this may return the undefined value of 0 for cubins
    #: compiled prior to CUDA 3.0.
    CU_FUNC_ATTRIBUTE_PTX_VERSION = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_PTX_VERSION

    #: The binary architecture version for which the function was compiled.
    #: This value is the major binary version * 10 + the minor binary
    #: version, so a binary version 1.3 function would return the value 13.
    #: Note that this will return a value of 10 for legacy cubins that do
    #: not have a properly-encoded binary architecture version.
    CU_FUNC_ATTRIBUTE_BINARY_VERSION = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_BINARY_VERSION

    #: The attribute to indicate whether the function has been compiled
    #: with user specified option "-Xptxas --dlcm=ca" set .
    CU_FUNC_ATTRIBUTE_CACHE_MODE_CA = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_CACHE_MODE_CA

    #: The maximum size in bytes of dynamically-allocated shared memory
    #: that can be used by this function. If the user-specified dynamic
    #: shared memory size is larger than this value, the launch will fail.
    #: The default value of this attribute is
    #: :py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK` -
    #: :py:obj:`~.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES`, except when
    #: :py:obj:`~.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES` is greater than
    #: :py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK`, then
    #: the default value of this attribute is 0. The value can be increased
    #: to :py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN`
    #: - :py:obj:`~.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES`. See
    #: :py:obj:`~.cuFuncSetAttribute`, :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES

    #: On devices where the L1 cache and shared memory use the same
    #: hardware resources, this sets the shared memory carveout preference,
    #: in percent of the total shared memory. Refer to
    #: :py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR`.
    #: This is only a hint, and the driver can choose a different ratio if
    #: required to execute the function. See
    #: :py:obj:`~.cuFuncSetAttribute`, :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT

    #: If this attribute is set, the kernel must launch with a valid
    #: cluster size specified. See :py:obj:`~.cuFuncSetAttribute`,
    #: :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_CLUSTER_SIZE_MUST_BE_SET = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_CLUSTER_SIZE_MUST_BE_SET

    #: The required cluster width in blocks. The values must either all be
    #: 0 or all be positive. The validity of the cluster dimensions is
    #: otherwise checked at launch time.
    #:
    #: If the value is set during compile time, it cannot be set at
    #: runtime. Setting it at runtime will return CUDA_ERROR_NOT_PERMITTED.
    #: See :py:obj:`~.cuFuncSetAttribute`, :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_WIDTH = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_WIDTH

    #: The required cluster height in blocks. The values must either all be
    #: 0 or all be positive. The validity of the cluster dimensions is
    #: otherwise checked at launch time.
    #:
    #: If the value is set during compile time, it cannot be set at
    #: runtime. Setting it at runtime should return
    #: CUDA_ERROR_NOT_PERMITTED. See :py:obj:`~.cuFuncSetAttribute`,
    #: :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_HEIGHT = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_HEIGHT

    #: The required cluster depth in blocks. The values must either all be
    #: 0 or all be positive. The validity of the cluster dimensions is
    #: otherwise checked at launch time.
    #:
    #: If the value is set during compile time, it cannot be set at
    #: runtime. Setting it at runtime should return
    #: CUDA_ERROR_NOT_PERMITTED. See :py:obj:`~.cuFuncSetAttribute`,
    #: :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_DEPTH = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_DEPTH

    #: Whether the function can be launched with non-portable cluster size.
    #: 1 is allowed, 0 is disallowed. A non-portable cluster size may only
    #: function on the specific SKUs the program is tested on. The launch
    #: might fail if the program is run on a different hardware platform.
    #:
    #: CUDA API provides cudaOccupancyMaxActiveClusters to assist with
    #: checking whether the desired size can be launched on the current
    #: device.
    #:
    #: Portable Cluster Size
    #:
    #: A portable cluster size is guaranteed to be functional on all
    #: compute capabilities higher than the target compute capability. The
    #: portable cluster size for sm_90 is 8 blocks per cluster. This value
    #: may increase for future compute capabilities.
    #:
    #: The specific hardware unit may support higher cluster sizes that’s
    #: not guaranteed to be portable. See :py:obj:`~.cuFuncSetAttribute`,
    #: :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_NON_PORTABLE_CLUSTER_SIZE_ALLOWED = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_NON_PORTABLE_CLUSTER_SIZE_ALLOWED

    #: The block scheduling policy of a function. The value type is
    #: CUclusterSchedulingPolicy / cudaClusterSchedulingPolicy. See
    #: :py:obj:`~.cuFuncSetAttribute`, :py:obj:`~.cuKernelSetAttribute`
    CU_FUNC_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE
    CU_FUNC_ATTRIBUTE_MAX = cydriver.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_MAX

_dict_CUfunction_attribute = dict(((int(v), v) for k, v in CUfunction_attribute.__members__.items()))

class CUfunc_cache(IntEnum):
    """
    Function cache configurations
    """

    #: no preference for shared memory or L1 (default)
    CU_FUNC_CACHE_PREFER_NONE = cydriver.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_NONE

    #: prefer larger shared memory and smaller L1 cache
    CU_FUNC_CACHE_PREFER_SHARED = cydriver.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_SHARED

    #: prefer larger L1 cache and smaller shared memory
    CU_FUNC_CACHE_PREFER_L1 = cydriver.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_L1

    #: prefer equal sized L1 cache and shared memory
    CU_FUNC_CACHE_PREFER_EQUAL = cydriver.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_EQUAL

_dict_CUfunc_cache = dict(((int(v), v) for k, v in CUfunc_cache.__members__.items()))

class CUsharedconfig(IntEnum):
    """
    [Deprecated]  Shared memory configurations
    """

    #: set default shared memory bank size
    CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE = cydriver.CUsharedconfig_enum.CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE

    #: set shared memory bank width to four bytes
    CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE = cydriver.CUsharedconfig_enum.CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE

    #: set shared memory bank width to eight bytes
    CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE = cydriver.CUsharedconfig_enum.CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE

_dict_CUsharedconfig = dict(((int(v), v) for k, v in CUsharedconfig.__members__.items()))

class CUshared_carveout(IntEnum):
    """
    Shared memory carveout configurations. These may be passed to
    :py:obj:`~.cuFuncSetAttribute` or :py:obj:`~.cuKernelSetAttribute`
    """

    #: No preference for shared memory or L1 (default)
    CU_SHAREDMEM_CARVEOUT_DEFAULT = cydriver.CUshared_carveout_enum.CU_SHAREDMEM_CARVEOUT_DEFAULT

    #: Prefer maximum available L1 cache, minimum shared memory
    CU_SHAREDMEM_CARVEOUT_MAX_L1 = cydriver.CUshared_carveout_enum.CU_SHAREDMEM_CARVEOUT_MAX_L1

    #: Prefer maximum available shared memory, minimum L1 cache
    CU_SHAREDMEM_CARVEOUT_MAX_SHARED = cydriver.CUshared_carveout_enum.CU_SHAREDMEM_CARVEOUT_MAX_SHARED

_dict_CUshared_carveout = dict(((int(v), v) for k, v in CUshared_carveout.__members__.items()))

class CUmemorytype(IntEnum):
    """
    Memory types
    """

    #: Host memory
    CU_MEMORYTYPE_HOST = cydriver.CUmemorytype_enum.CU_MEMORYTYPE_HOST

    #: Device memory
    CU_MEMORYTYPE_DEVICE = cydriver.CUmemorytype_enum.CU_MEMORYTYPE_DEVICE

    #: Array memory
    CU_MEMORYTYPE_ARRAY = cydriver.CUmemorytype_enum.CU_MEMORYTYPE_ARRAY

    #: Unified device or host memory
    CU_MEMORYTYPE_UNIFIED = cydriver.CUmemorytype_enum.CU_MEMORYTYPE_UNIFIED

_dict_CUmemorytype = dict(((int(v), v) for k, v in CUmemorytype.__members__.items()))

class CUcomputemode(IntEnum):
    """
    Compute Modes
    """

    #: Default compute mode (Multiple contexts allowed per device)
    CU_COMPUTEMODE_DEFAULT = cydriver.CUcomputemode_enum.CU_COMPUTEMODE_DEFAULT

    #: Compute-prohibited mode (No contexts can be created on this device
    #: at this time)
    CU_COMPUTEMODE_PROHIBITED = cydriver.CUcomputemode_enum.CU_COMPUTEMODE_PROHIBITED

    #: Compute-exclusive-process mode (Only one context used by a single
    #: process can be present on this device at a time)
    CU_COMPUTEMODE_EXCLUSIVE_PROCESS = cydriver.CUcomputemode_enum.CU_COMPUTEMODE_EXCLUSIVE_PROCESS

_dict_CUcomputemode = dict(((int(v), v) for k, v in CUcomputemode.__members__.items()))

class CUmem_advise(IntEnum):
    """
    Memory advise values
    """

    #: Data will mostly be read and only occasionally be written to
    CU_MEM_ADVISE_SET_READ_MOSTLY = cydriver.CUmem_advise_enum.CU_MEM_ADVISE_SET_READ_MOSTLY

    #: Undo the effect of :py:obj:`~.CU_MEM_ADVISE_SET_READ_MOSTLY`
    CU_MEM_ADVISE_UNSET_READ_MOSTLY = cydriver.CUmem_advise_enum.CU_MEM_ADVISE_UNSET_READ_MOSTLY

    #: Set the preferred location for the data as the specified device
    CU_MEM_ADVISE_SET_PREFERRED_LOCATION = cydriver.CUmem_advise_enum.CU_MEM_ADVISE_SET_PREFERRED_LOCATION

    #: Clear the preferred location for the data
    CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION = cydriver.CUmem_advise_enum.CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION

    #: Data will be accessed by the specified device, so prevent page
    #: faults as much as possible
    CU_MEM_ADVISE_SET_ACCESSED_BY = cydriver.CUmem_advise_enum.CU_MEM_ADVISE_SET_ACCESSED_BY

    #: Let the Unified Memory subsystem decide on the page faulting policy
    #: for the specified device
    CU_MEM_ADVISE_UNSET_ACCESSED_BY = cydriver.CUmem_advise_enum.CU_MEM_ADVISE_UNSET_ACCESSED_BY

_dict_CUmem_advise = dict(((int(v), v) for k, v in CUmem_advise.__members__.items()))

class CUmem_range_attribute(IntEnum):
    """

    """

    #: Whether the range will mostly be read and only occasionally be
    #: written to
    CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY

    #: The preferred location of the range
    CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION

    #: Memory range has :py:obj:`~.CU_MEM_ADVISE_SET_ACCESSED_BY` set for
    #: specified device
    CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY

    #: The last location to which the range was prefetched
    CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION

    #: The preferred location type of the range
    CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION_TYPE = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION_TYPE

    #: The preferred location id of the range
    CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION_ID = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION_ID

    #: The last location type to which the range was prefetched
    CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION_TYPE = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION_TYPE

    #: The last location id to which the range was prefetched
    CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION_ID = cydriver.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION_ID

_dict_CUmem_range_attribute = dict(((int(v), v) for k, v in CUmem_range_attribute.__members__.items()))

class CUjit_option(IntEnum):
    """
    Online compiler and linker options
    """

    #: Max number of registers that a thread may use.
    #: Option type: unsigned int
    #: Applies to: compiler only
    CU_JIT_MAX_REGISTERS = cydriver.CUjit_option_enum.CU_JIT_MAX_REGISTERS

    #: IN: Specifies minimum number of threads per block to target
    #: compilation for
    #: OUT: Returns the number of threads the compiler actually targeted.
    #: This restricts the resource utilization of the compiler (e.g. max
    #: registers) such that a block with the given number of threads should
    #: be able to launch based on register limitations. Note, this option
    #: does not currently take into account any other resource limitations,
    #: such as shared memory utilization.
    #: Cannot be combined with :py:obj:`~.CU_JIT_TARGET`.
    #: Option type: unsigned int
    #: Applies to: compiler only
    CU_JIT_THREADS_PER_BLOCK = cydriver.CUjit_option_enum.CU_JIT_THREADS_PER_BLOCK

    #: Overwrites the option value with the total wall clock time, in
    #: milliseconds, spent in the compiler and linker
    #: Option type: float
    #: Applies to: compiler and linker
    CU_JIT_WALL_TIME = cydriver.CUjit_option_enum.CU_JIT_WALL_TIME

    #: Pointer to a buffer in which to print any log messages that are
    #: informational in nature (the buffer size is specified via option
    #: :py:obj:`~.CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES`)
    #: Option type: char *
    #: Applies to: compiler and linker
    CU_JIT_INFO_LOG_BUFFER = cydriver.CUjit_option_enum.CU_JIT_INFO_LOG_BUFFER

    #: IN: Log buffer size in bytes. Log messages will be capped at this
    #: size (including null terminator)
    #: OUT: Amount of log buffer filled with messages
    #: Option type: unsigned int
    #: Applies to: compiler and linker
    CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES = cydriver.CUjit_option_enum.CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES

    #: Pointer to a buffer in which to print any log messages that reflect
    #: errors (the buffer size is specified via option
    #: :py:obj:`~.CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES`)
    #: Option type: char *
    #: Applies to: compiler and linker
    CU_JIT_ERROR_LOG_BUFFER = cydriver.CUjit_option_enum.CU_JIT_ERROR_LOG_BUFFER

    #: IN: Log buffer size in bytes. Log messages will be capped at this
    #: size (including null terminator)
    #: OUT: Amount of log buffer filled with messages
    #: Option type: unsigned int
    #: Applies to: compiler and linker
    CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES = cydriver.CUjit_option_enum.CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES

    #: Level of optimizations to apply to generated code (0 - 4), with 4
    #: being the default and highest level of optimizations.
    #: Option type: unsigned int
    #: Applies to: compiler only
    CU_JIT_OPTIMIZATION_LEVEL = cydriver.CUjit_option_enum.CU_JIT_OPTIMIZATION_LEVEL

    #: No option value required. Determines the target based on the current
    #: attached context (default)
    #: Option type: No option value needed
    #: Applies to: compiler and linker
    CU_JIT_TARGET_FROM_CUCONTEXT = cydriver.CUjit_option_enum.CU_JIT_TARGET_FROM_CUCONTEXT

    #: Target is chosen based on supplied :py:obj:`~.CUjit_target`. Cannot
    #: be combined with :py:obj:`~.CU_JIT_THREADS_PER_BLOCK`.
    #: Option type: unsigned int for enumerated type
    #: :py:obj:`~.CUjit_target`
    #: Applies to: compiler and linker
    CU_JIT_TARGET = cydriver.CUjit_option_enum.CU_JIT_TARGET

    #: Specifies choice of fallback strategy if matching cubin is not
    #: found. Choice is based on supplied :py:obj:`~.CUjit_fallback`. This
    #: option cannot be used with cuLink* APIs as the linker requires exact
    #: matches.
    #: Option type: unsigned int for enumerated type
    #: :py:obj:`~.CUjit_fallback`
    #: Applies to: compiler only
    CU_JIT_FALLBACK_STRATEGY = cydriver.CUjit_option_enum.CU_JIT_FALLBACK_STRATEGY

    #: Specifies whether to create debug information in output (-g) (0:
    #: false, default)
    #: Option type: int
    #: Applies to: compiler and linker
    CU_JIT_GENERATE_DEBUG_INFO = cydriver.CUjit_option_enum.CU_JIT_GENERATE_DEBUG_INFO

    #: Generate verbose log messages (0: false, default)
    #: Option type: int
    #: Applies to: compiler and linker
    CU_JIT_LOG_VERBOSE = cydriver.CUjit_option_enum.CU_JIT_LOG_VERBOSE

    #: Generate line number information (-lineinfo) (0: false, default)
    #: Option type: int
    #: Applies to: compiler only
    CU_JIT_GENERATE_LINE_INFO = cydriver.CUjit_option_enum.CU_JIT_GENERATE_LINE_INFO

    #: Specifies whether to enable caching explicitly (-dlcm)
    #: Choice is based on supplied :py:obj:`~.CUjit_cacheMode_enum`.
    #: Option type: unsigned int for enumerated type
    #: :py:obj:`~.CUjit_cacheMode_enum`
    #: Applies to: compiler only
    CU_JIT_CACHE_MODE = cydriver.CUjit_option_enum.CU_JIT_CACHE_MODE

    #: [Deprecated]
    CU_JIT_NEW_SM3X_OPT = cydriver.CUjit_option_enum.CU_JIT_NEW_SM3X_OPT

    #: This jit option is used for internal purpose only.
    CU_JIT_FAST_COMPILE = cydriver.CUjit_option_enum.CU_JIT_FAST_COMPILE

    #: Array of device symbol names that will be relocated to the
    #: corresponding host addresses stored in
    #: :py:obj:`~.CU_JIT_GLOBAL_SYMBOL_ADDRESSES`.
    #: Must contain :py:obj:`~.CU_JIT_GLOBAL_SYMBOL_COUNT` entries.
    #: When loading a device module, driver will relocate all encountered
    #: unresolved symbols to the host addresses.
    #: It is only allowed to register symbols that correspond to unresolved
    #: global variables.
    #: It is illegal to register the same device symbol at multiple
    #: addresses.
    #: Option type: const char **
    #: Applies to: dynamic linker only
    CU_JIT_GLOBAL_SYMBOL_NAMES = cydriver.CUjit_option_enum.CU_JIT_GLOBAL_SYMBOL_NAMES

    #: Array of host addresses that will be used to relocate corresponding
    #: device symbols stored in :py:obj:`~.CU_JIT_GLOBAL_SYMBOL_NAMES`.
    #: Must contain :py:obj:`~.CU_JIT_GLOBAL_SYMBOL_COUNT` entries.
    #: Option type: void **
    #: Applies to: dynamic linker only
    CU_JIT_GLOBAL_SYMBOL_ADDRESSES = cydriver.CUjit_option_enum.CU_JIT_GLOBAL_SYMBOL_ADDRESSES

    #: Number of entries in :py:obj:`~.CU_JIT_GLOBAL_SYMBOL_NAMES` and
    #: :py:obj:`~.CU_JIT_GLOBAL_SYMBOL_ADDRESSES` arrays.
    #: Option type: unsigned int
    #: Applies to: dynamic linker only
    CU_JIT_GLOBAL_SYMBOL_COUNT = cydriver.CUjit_option_enum.CU_JIT_GLOBAL_SYMBOL_COUNT

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_LTO = cydriver.CUjit_option_enum.CU_JIT_LTO

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_FTZ = cydriver.CUjit_option_enum.CU_JIT_FTZ

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_PREC_DIV = cydriver.CUjit_option_enum.CU_JIT_PREC_DIV

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_PREC_SQRT = cydriver.CUjit_option_enum.CU_JIT_PREC_SQRT

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_FMA = cydriver.CUjit_option_enum.CU_JIT_FMA

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_REFERENCED_KERNEL_NAMES = cydriver.CUjit_option_enum.CU_JIT_REFERENCED_KERNEL_NAMES

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_REFERENCED_KERNEL_COUNT = cydriver.CUjit_option_enum.CU_JIT_REFERENCED_KERNEL_COUNT

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_REFERENCED_VARIABLE_NAMES = cydriver.CUjit_option_enum.CU_JIT_REFERENCED_VARIABLE_NAMES

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_REFERENCED_VARIABLE_COUNT = cydriver.CUjit_option_enum.CU_JIT_REFERENCED_VARIABLE_COUNT

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_OPTIMIZE_UNUSED_DEVICE_VARIABLES = cydriver.CUjit_option_enum.CU_JIT_OPTIMIZE_UNUSED_DEVICE_VARIABLES

    #: Generate position independent code (0: false)
    #: Option type: int
    #: Applies to: compiler only
    CU_JIT_POSITION_INDEPENDENT_CODE = cydriver.CUjit_option_enum.CU_JIT_POSITION_INDEPENDENT_CODE

    #: This option hints to the JIT compiler the minimum number of CTAs
    #: from the kernel’s grid to be mapped to a SM. This option is ignored
    #: when used together with :py:obj:`~.CU_JIT_MAX_REGISTERS` or
    #: :py:obj:`~.CU_JIT_THREADS_PER_BLOCK`. Optimizations based on this
    #: option need :py:obj:`~.CU_JIT_MAX_THREADS_PER_BLOCK` to be specified
    #: as well. For kernels already using PTX directive .minnctapersm, this
    #: option will be ignored by default. Use
    #: :py:obj:`~.CU_JIT_OVERRIDE_DIRECTIVE_VALUES` to let this option take
    #: precedence over the PTX directive. Option type: unsigned int
    #: Applies to: compiler only
    CU_JIT_MIN_CTA_PER_SM = cydriver.CUjit_option_enum.CU_JIT_MIN_CTA_PER_SM

    #: Maximum number threads in a thread block, computed as the product of
    #: the maximum extent specifed for each dimension of the block. This
    #: limit is guaranteed not to be exeeded in any invocation of the
    #: kernel. Exceeding the the maximum number of threads results in
    #: runtime error or kernel launch failure. For kernels already using
    #: PTX directive .maxntid, this option will be ignored by default. Use
    #: :py:obj:`~.CU_JIT_OVERRIDE_DIRECTIVE_VALUES` to let this option take
    #: precedence over the PTX directive. Option type: int
    #: Applies to: compiler only
    CU_JIT_MAX_THREADS_PER_BLOCK = cydriver.CUjit_option_enum.CU_JIT_MAX_THREADS_PER_BLOCK

    #: This option lets the values specified using
    #: :py:obj:`~.CU_JIT_MAX_REGISTERS`,
    #: :py:obj:`~.CU_JIT_THREADS_PER_BLOCK`,
    #: :py:obj:`~.CU_JIT_MAX_THREADS_PER_BLOCK` and
    #: :py:obj:`~.CU_JIT_MIN_CTA_PER_SM` take precedence over any PTX
    #: directives. (0: Disable, default; 1: Enable) Option type: int
    #: Applies to: compiler only
    CU_JIT_OVERRIDE_DIRECTIVE_VALUES = cydriver.CUjit_option_enum.CU_JIT_OVERRIDE_DIRECTIVE_VALUES

    #: This option specifies the maximum number of concurrent threads to
    #: use when running compiler optimizations. If the specified value is
    #: 1, the option will be ignored. If the specified value is 0, the
    #: number of threads will match the number of CPUs on the underlying
    #: machine. Otherwise, if the option is N, then up to N threads will be
    #: used. Option type: unsigned int
    #: Applies to: compiler only
    CU_JIT_SPLIT_COMPILE = cydriver.CUjit_option_enum.CU_JIT_SPLIT_COMPILE
    CU_JIT_NUM_OPTIONS = cydriver.CUjit_option_enum.CU_JIT_NUM_OPTIONS

_dict_CUjit_option = dict(((int(v), v) for k, v in CUjit_option.__members__.items()))

class CUjit_target(IntEnum):
    """
    Online compilation targets
    """

    #: Compute device class 3.0
    CU_TARGET_COMPUTE_30 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_30

    #: Compute device class 3.2
    CU_TARGET_COMPUTE_32 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_32

    #: Compute device class 3.5
    CU_TARGET_COMPUTE_35 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_35

    #: Compute device class 3.7
    CU_TARGET_COMPUTE_37 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_37

    #: Compute device class 5.0
    CU_TARGET_COMPUTE_50 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_50

    #: Compute device class 5.2
    CU_TARGET_COMPUTE_52 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_52

    #: Compute device class 5.3
    CU_TARGET_COMPUTE_53 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_53

    #: Compute device class 6.0.
    CU_TARGET_COMPUTE_60 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_60

    #: Compute device class 6.1.
    CU_TARGET_COMPUTE_61 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_61

    #: Compute device class 6.2.
    CU_TARGET_COMPUTE_62 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_62

    #: Compute device class 7.0.
    CU_TARGET_COMPUTE_70 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_70

    #: Compute device class 7.2.
    CU_TARGET_COMPUTE_72 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_72

    #: Compute device class 7.5.
    CU_TARGET_COMPUTE_75 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_75

    #: Compute device class 8.0.
    CU_TARGET_COMPUTE_80 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_80

    #: Compute device class 8.6.
    CU_TARGET_COMPUTE_86 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_86

    #: Compute device class 8.7.
    CU_TARGET_COMPUTE_87 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_87

    #: Compute device class 8.9.
    CU_TARGET_COMPUTE_89 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_89

    #: Compute device class 9.0.
    CU_TARGET_COMPUTE_90 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_90

    #: Compute device class 10.0.
    CU_TARGET_COMPUTE_100 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_100

    #: Compute device class 10.3.
    CU_TARGET_COMPUTE_103 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_103

    #: Compute device class 11.0.
    CU_TARGET_COMPUTE_110 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_110

    #: Compute device class 12.0.
    CU_TARGET_COMPUTE_120 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_120

    #: Compute device class 12.1. Compute device class 9.0. with
    #: accelerated features.
    CU_TARGET_COMPUTE_121 = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_121

    #: Compute device class 10.0. with accelerated features.
    CU_TARGET_COMPUTE_90A = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_90A

    #: Compute device class 11.0 with accelerated features.
    CU_TARGET_COMPUTE_100A = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_100A

    #: Compute device class 12.0. with accelerated features.
    CU_TARGET_COMPUTE_103A = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_103A

    #: Compute device class 10.3. with accelerated features.
    CU_TARGET_COMPUTE_110A = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_110A

    #: Compute device class 12.1. with accelerated features.
    CU_TARGET_COMPUTE_120A = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_120A

    #: Compute device class 10.x with family features.
    CU_TARGET_COMPUTE_121A = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_121A

    #: Compute device class 11.0 with family features.
    CU_TARGET_COMPUTE_100F = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_100F

    #: Compute device class 12.0. with family features.
    CU_TARGET_COMPUTE_103F = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_103F

    #: Compute device class 10.3. with family features.
    CU_TARGET_COMPUTE_110F = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_110F

    #: Compute device class 12.1. with family features.
    CU_TARGET_COMPUTE_120F = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_120F
    CU_TARGET_COMPUTE_121F = cydriver.CUjit_target_enum.CU_TARGET_COMPUTE_121F

_dict_CUjit_target = dict(((int(v), v) for k, v in CUjit_target.__members__.items()))

class CUjit_fallback(IntEnum):
    """
    Cubin matching fallback strategies
    """

    #: Prefer to compile ptx if exact binary match not found
    CU_PREFER_PTX = cydriver.CUjit_fallback_enum.CU_PREFER_PTX

    #: Prefer to fall back to compatible binary code if exact match not
    #: found
    CU_PREFER_BINARY = cydriver.CUjit_fallback_enum.CU_PREFER_BINARY

_dict_CUjit_fallback = dict(((int(v), v) for k, v in CUjit_fallback.__members__.items()))

class CUjit_cacheMode(IntEnum):
    """
    Caching modes for dlcm
    """

    #: Compile with no -dlcm flag specified
    CU_JIT_CACHE_OPTION_NONE = cydriver.CUjit_cacheMode_enum.CU_JIT_CACHE_OPTION_NONE

    #: Compile with L1 cache disabled
    CU_JIT_CACHE_OPTION_CG = cydriver.CUjit_cacheMode_enum.CU_JIT_CACHE_OPTION_CG

    #: Compile with L1 cache enabled
    CU_JIT_CACHE_OPTION_CA = cydriver.CUjit_cacheMode_enum.CU_JIT_CACHE_OPTION_CA

_dict_CUjit_cacheMode = dict(((int(v), v) for k, v in CUjit_cacheMode.__members__.items()))

class CUjitInputType(IntEnum):
    """
    Device code formats
    """

    #: Compiled device-class-specific device code
    #: Applicable options: none
    CU_JIT_INPUT_CUBIN = cydriver.CUjitInputType_enum.CU_JIT_INPUT_CUBIN

    #: PTX source code
    #: Applicable options: PTX compiler options
    CU_JIT_INPUT_PTX = cydriver.CUjitInputType_enum.CU_JIT_INPUT_PTX

    #: Bundle of multiple cubins and/or PTX of some device code
    #: Applicable options: PTX compiler options,
    #: :py:obj:`~.CU_JIT_FALLBACK_STRATEGY`
    CU_JIT_INPUT_FATBINARY = cydriver.CUjitInputType_enum.CU_JIT_INPUT_FATBINARY

    #: Host object with embedded device code
    #: Applicable options: PTX compiler options,
    #: :py:obj:`~.CU_JIT_FALLBACK_STRATEGY`
    CU_JIT_INPUT_OBJECT = cydriver.CUjitInputType_enum.CU_JIT_INPUT_OBJECT

    #: Archive of host objects with embedded device code
    #: Applicable options: PTX compiler options,
    #: :py:obj:`~.CU_JIT_FALLBACK_STRATEGY`
    CU_JIT_INPUT_LIBRARY = cydriver.CUjitInputType_enum.CU_JIT_INPUT_LIBRARY

    #: [Deprecated]
    #:
    #: Only valid with LTO-IR compiled with toolkits prior to CUDA 12.0
    CU_JIT_INPUT_NVVM = cydriver.CUjitInputType_enum.CU_JIT_INPUT_NVVM
    CU_JIT_NUM_INPUT_TYPES = cydriver.CUjitInputType_enum.CU_JIT_NUM_INPUT_TYPES

_dict_CUjitInputType = dict(((int(v), v) for k, v in CUjitInputType.__members__.items()))

class CUgraphicsRegisterFlags(IntEnum):
    """
    Flags to register a graphics resource
    """
    CU_GRAPHICS_REGISTER_FLAGS_NONE = cydriver.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_NONE
    CU_GRAPHICS_REGISTER_FLAGS_READ_ONLY = cydriver.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_READ_ONLY
    CU_GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD = cydriver.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD
    CU_GRAPHICS_REGISTER_FLAGS_SURFACE_LDST = cydriver.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_SURFACE_LDST
    CU_GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER = cydriver.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER

_dict_CUgraphicsRegisterFlags = dict(((int(v), v) for k, v in CUgraphicsRegisterFlags.__members__.items()))

class CUgraphicsMapResourceFlags(IntEnum):
    """
    Flags for mapping and unmapping interop resources
    """
    CU_GRAPHICS_MAP_RESOURCE_FLAGS_NONE = cydriver.CUgraphicsMapResourceFlags_enum.CU_GRAPHICS_MAP_RESOURCE_FLAGS_NONE
    CU_GRAPHICS_MAP_RESOURCE_FLAGS_READ_ONLY = cydriver.CUgraphicsMapResourceFlags_enum.CU_GRAPHICS_MAP_RESOURCE_FLAGS_READ_ONLY
    CU_GRAPHICS_MAP_RESOURCE_FLAGS_WRITE_DISCARD = cydriver.CUgraphicsMapResourceFlags_enum.CU_GRAPHICS_MAP_RESOURCE_FLAGS_WRITE_DISCARD

_dict_CUgraphicsMapResourceFlags = dict(((int(v), v) for k, v in CUgraphicsMapResourceFlags.__members__.items()))

class CUarray_cubemap_face(IntEnum):
    """
    Array indices for cube faces
    """

    #: Positive X face of cubemap
    CU_CUBEMAP_FACE_POSITIVE_X = cydriver.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_POSITIVE_X

    #: Negative X face of cubemap
    CU_CUBEMAP_FACE_NEGATIVE_X = cydriver.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_NEGATIVE_X

    #: Positive Y face of cubemap
    CU_CUBEMAP_FACE_POSITIVE_Y = cydriver.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_POSITIVE_Y

    #: Negative Y face of cubemap
    CU_CUBEMAP_FACE_NEGATIVE_Y = cydriver.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_NEGATIVE_Y

    #: Positive Z face of cubemap
    CU_CUBEMAP_FACE_POSITIVE_Z = cydriver.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_POSITIVE_Z

    #: Negative Z face of cubemap
    CU_CUBEMAP_FACE_NEGATIVE_Z = cydriver.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_NEGATIVE_Z

_dict_CUarray_cubemap_face = dict(((int(v), v) for k, v in CUarray_cubemap_face.__members__.items()))

class CUlimit(IntEnum):
    """
    Limits
    """

    #: GPU thread stack size
    CU_LIMIT_STACK_SIZE = cydriver.CUlimit_enum.CU_LIMIT_STACK_SIZE

    #: GPU printf FIFO size
    CU_LIMIT_PRINTF_FIFO_SIZE = cydriver.CUlimit_enum.CU_LIMIT_PRINTF_FIFO_SIZE

    #: GPU malloc heap size
    CU_LIMIT_MALLOC_HEAP_SIZE = cydriver.CUlimit_enum.CU_LIMIT_MALLOC_HEAP_SIZE

    #: GPU device runtime launch synchronize depth
    CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH = cydriver.CUlimit_enum.CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH

    #: GPU device runtime pending launch count
    CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT = cydriver.CUlimit_enum.CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT

    #: A value between 0 and 128 that indicates the maximum fetch
    #: granularity of L2 (in Bytes). This is a hint
    CU_LIMIT_MAX_L2_FETCH_GRANULARITY = cydriver.CUlimit_enum.CU_LIMIT_MAX_L2_FETCH_GRANULARITY

    #: A size in bytes for L2 persisting lines cache size
    CU_LIMIT_PERSISTING_L2_CACHE_SIZE = cydriver.CUlimit_enum.CU_LIMIT_PERSISTING_L2_CACHE_SIZE

    #: A maximum size in bytes of shared memory available to CUDA kernels
    #: on a CIG context. Can only be queried, cannot be set
    CU_LIMIT_SHMEM_SIZE = cydriver.CUlimit_enum.CU_LIMIT_SHMEM_SIZE

    #: A non-zero value indicates this CUDA context is a CIG-enabled
    #: context. Can only be queried, cannot be set
    CU_LIMIT_CIG_ENABLED = cydriver.CUlimit_enum.CU_LIMIT_CIG_ENABLED

    #: When set to zero, CUDA will fail to launch a kernel on a CIG
    #: context, instead of using the fallback path, if the kernel uses more
    #: shared memory than available
    CU_LIMIT_CIG_SHMEM_FALLBACK_ENABLED = cydriver.CUlimit_enum.CU_LIMIT_CIG_SHMEM_FALLBACK_ENABLED
    CU_LIMIT_MAX = cydriver.CUlimit_enum.CU_LIMIT_MAX

_dict_CUlimit = dict(((int(v), v) for k, v in CUlimit.__members__.items()))

class CUresourcetype(IntEnum):
    """
    Resource types
    """

    #: Array resource
    CU_RESOURCE_TYPE_ARRAY = cydriver.CUresourcetype_enum.CU_RESOURCE_TYPE_ARRAY

    #: Mipmapped array resource
    CU_RESOURCE_TYPE_MIPMAPPED_ARRAY = cydriver.CUresourcetype_enum.CU_RESOURCE_TYPE_MIPMAPPED_ARRAY

    #: Linear resource
    CU_RESOURCE_TYPE_LINEAR = cydriver.CUresourcetype_enum.CU_RESOURCE_TYPE_LINEAR

    #: Pitch 2D resource
    CU_RESOURCE_TYPE_PITCH2D = cydriver.CUresourcetype_enum.CU_RESOURCE_TYPE_PITCH2D

_dict_CUresourcetype = dict(((int(v), v) for k, v in CUresourcetype.__members__.items()))

class CUaccessProperty(IntEnum):
    """
    Specifies performance hint with :py:obj:`~.CUaccessPolicyWindow`
    for hitProp and missProp members.
    """

    #: Normal cache persistence.
    CU_ACCESS_PROPERTY_NORMAL = cydriver.CUaccessProperty_enum.CU_ACCESS_PROPERTY_NORMAL

    #: Streaming access is less likely to persit from cache.
    CU_ACCESS_PROPERTY_STREAMING = cydriver.CUaccessProperty_enum.CU_ACCESS_PROPERTY_STREAMING

    #: Persisting access is more likely to persist in cache.
    CU_ACCESS_PROPERTY_PERSISTING = cydriver.CUaccessProperty_enum.CU_ACCESS_PROPERTY_PERSISTING

_dict_CUaccessProperty = dict(((int(v), v) for k, v in CUaccessProperty.__members__.items()))

class CUgraphConditionalNodeType(IntEnum):
    """
    Conditional node types
    """

    #: Conditional 'if/else' Node. Body[0] executed if condition is non-
    #: zero. If `size` == 2, an optional ELSE graph is created and this is
    #: executed if the condition is zero.
    CU_GRAPH_COND_TYPE_IF = cydriver.CUgraphConditionalNodeType_enum.CU_GRAPH_COND_TYPE_IF

    #: Conditional 'while' Node. Body executed repeatedly while condition
    #: value is non-zero.
    CU_GRAPH_COND_TYPE_WHILE = cydriver.CUgraphConditionalNodeType_enum.CU_GRAPH_COND_TYPE_WHILE

    #: Conditional 'switch' Node. Body[n] is executed once, where 'n' is
    #: the value of the condition. If the condition does not match a body
    #: index, no body is launched.
    CU_GRAPH_COND_TYPE_SWITCH = cydriver.CUgraphConditionalNodeType_enum.CU_GRAPH_COND_TYPE_SWITCH

_dict_CUgraphConditionalNodeType = dict(((int(v), v) for k, v in CUgraphConditionalNodeType.__members__.items()))

class CUgraphNodeType(IntEnum):
    """
    Graph node types
    """

    #: GPU kernel node
    CU_GRAPH_NODE_TYPE_KERNEL = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_KERNEL

    #: Memcpy node
    CU_GRAPH_NODE_TYPE_MEMCPY = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEMCPY

    #: Memset node
    CU_GRAPH_NODE_TYPE_MEMSET = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEMSET

    #: Host (executable) node
    CU_GRAPH_NODE_TYPE_HOST = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_HOST

    #: Node which executes an embedded graph
    CU_GRAPH_NODE_TYPE_GRAPH = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_GRAPH

    #: Empty (no-op) node
    CU_GRAPH_NODE_TYPE_EMPTY = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EMPTY

    #: External event wait node
    CU_GRAPH_NODE_TYPE_WAIT_EVENT = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_WAIT_EVENT

    #: External event record node
    CU_GRAPH_NODE_TYPE_EVENT_RECORD = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EVENT_RECORD

    #: External semaphore signal node
    CU_GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL

    #: External semaphore wait node
    CU_GRAPH_NODE_TYPE_EXT_SEMAS_WAIT = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EXT_SEMAS_WAIT

    #: Memory Allocation Node
    CU_GRAPH_NODE_TYPE_MEM_ALLOC = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEM_ALLOC

    #: Memory Free Node
    CU_GRAPH_NODE_TYPE_MEM_FREE = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEM_FREE

    #: Batch MemOp Node See :py:obj:`~.cuStreamBatchMemOp` and
    #: :py:obj:`~.CUstreamBatchMemOpType` for what these nodes can do.
    CU_GRAPH_NODE_TYPE_BATCH_MEM_OP = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_BATCH_MEM_OP

    #: Conditional Node                                         May be used
    #: to implement a conditional execution path or loop
    #:                                         inside of a graph. The
    #: graph(s) contained within the body of the conditional node
    #:                                         can be selectively executed
    #: or iterated upon based on the value of a conditional
    #:                                         variable.
    #:
    #:                                         Handles must be created in
    #: advance of creating the node
    #:                                         using
    #: :py:obj:`~.cuGraphConditionalHandleCreate`.
    #:
    #:                                         The following restrictions
    #: apply to graphs which contain conditional nodes:
    #:                                          The graph cannot be used in
    #: a child node.
    #:                                          Only one instantiation of
    #: the graph may exist at any point in time.
    #:                                          The graph cannot be cloned.
    #:
    #:                                         To set the control value,
    #: supply a default value when creating the handle and/or
    #:                                         call
    #: :py:obj:`~.cudaGraphSetConditional` from device code.
    CU_GRAPH_NODE_TYPE_CONDITIONAL = cydriver.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_CONDITIONAL

_dict_CUgraphNodeType = dict(((int(v), v) for k, v in CUgraphNodeType.__members__.items()))

class CUgraphDependencyType(IntEnum):
    """
    Type annotations that can be applied to graph edges as part of
    :py:obj:`~.CUgraphEdgeData`.
    """

    #: This is an ordinary dependency.
    CU_GRAPH_DEPENDENCY_TYPE_DEFAULT = cydriver.CUgraphDependencyType_enum.CU_GRAPH_DEPENDENCY_TYPE_DEFAULT

    #: This dependency type allows the downstream node to use
    #: `cudaGridDependencySynchronize()`. It may only be used between
    #: kernel nodes, and must be used with either the
    #: :py:obj:`~.CU_GRAPH_KERNEL_NODE_PORT_PROGRAMMATIC` or
    #: :py:obj:`~.CU_GRAPH_KERNEL_NODE_PORT_LAUNCH_ORDER` outgoing port.
    CU_GRAPH_DEPENDENCY_TYPE_PROGRAMMATIC = cydriver.CUgraphDependencyType_enum.CU_GRAPH_DEPENDENCY_TYPE_PROGRAMMATIC

_dict_CUgraphDependencyType = dict(((int(v), v) for k, v in CUgraphDependencyType.__members__.items()))

class CUgraphInstantiateResult(IntEnum):
    """
    Graph instantiation results
    """

    #: Instantiation succeeded
    CUDA_GRAPH_INSTANTIATE_SUCCESS = cydriver.CUgraphInstantiateResult_enum.CUDA_GRAPH_INSTANTIATE_SUCCESS

    #: Instantiation failed for an unexpected reason which is described in
    #: the return value of the function
    CUDA_GRAPH_INSTANTIATE_ERROR = cydriver.CUgraphInstantiateResult_enum.CUDA_GRAPH_INSTANTIATE_ERROR

    #: Instantiation failed due to invalid structure, such as cycles
    CUDA_GRAPH_INSTANTIATE_INVALID_STRUCTURE = cydriver.CUgraphInstantiateResult_enum.CUDA_GRAPH_INSTANTIATE_INVALID_STRUCTURE

    #: Instantiation for device launch failed because the graph contained
    #: an unsupported operation
    CUDA_GRAPH_INSTANTIATE_NODE_OPERATION_NOT_SUPPORTED = cydriver.CUgraphInstantiateResult_enum.CUDA_GRAPH_INSTANTIATE_NODE_OPERATION_NOT_SUPPORTED

    #: Instantiation for device launch failed due to the nodes belonging to
    #: different contexts
    CUDA_GRAPH_INSTANTIATE_MULTIPLE_CTXS_NOT_SUPPORTED = cydriver.CUgraphInstantiateResult_enum.CUDA_GRAPH_INSTANTIATE_MULTIPLE_CTXS_NOT_SUPPORTED

    #: One or more conditional handles are not associated with conditional
    #: nodes
    CUDA_GRAPH_INSTANTIATE_CONDITIONAL_HANDLE_UNUSED = cydriver.CUgraphInstantiateResult_enum.CUDA_GRAPH_INSTANTIATE_CONDITIONAL_HANDLE_UNUSED

_dict_CUgraphInstantiateResult = dict(((int(v), v) for k, v in CUgraphInstantiateResult.__members__.items()))

class CUsynchronizationPolicy(IntEnum):
    """

    """
    CU_SYNC_POLICY_AUTO = cydriver.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_AUTO
    CU_SYNC_POLICY_SPIN = cydriver.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_SPIN
    CU_SYNC_POLICY_YIELD = cydriver.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_YIELD
    CU_SYNC_POLICY_BLOCKING_SYNC = cydriver.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_BLOCKING_SYNC

_dict_CUsynchronizationPolicy = dict(((int(v), v) for k, v in CUsynchronizationPolicy.__members__.items()))

class CUclusterSchedulingPolicy(IntEnum):
    """
    Cluster scheduling policies. These may be passed to
    :py:obj:`~.cuFuncSetAttribute` or :py:obj:`~.cuKernelSetAttribute`
    """

    #: the default policy
    CU_CLUSTER_SCHEDULING_POLICY_DEFAULT = cydriver.CUclusterSchedulingPolicy_enum.CU_CLUSTER_SCHEDULING_POLICY_DEFAULT

    #: spread the blocks within a cluster to the SMs
    CU_CLUSTER_SCHEDULING_POLICY_SPREAD = cydriver.CUclusterSchedulingPolicy_enum.CU_CLUSTER_SCHEDULING_POLICY_SPREAD

    #: allow the hardware to load-balance the blocks in a cluster to the
    #: SMs
    CU_CLUSTER_SCHEDULING_POLICY_LOAD_BALANCING = cydriver.CUclusterSchedulingPolicy_enum.CU_CLUSTER_SCHEDULING_POLICY_LOAD_BALANCING

_dict_CUclusterSchedulingPolicy = dict(((int(v), v) for k, v in CUclusterSchedulingPolicy.__members__.items()))

class CUlaunchMemSyncDomain(IntEnum):
    """
    Memory Synchronization Domain  A kernel can be launched in a
    specified memory synchronization domain that affects all memory
    operations issued by that kernel. A memory barrier issued in one
    domain will only order memory operations in that domain, thus
    eliminating latency increase from memory barriers ordering
    unrelated traffic.  By default, kernels are launched in domain 0.
    Kernel launched with :py:obj:`~.CU_LAUNCH_MEM_SYNC_DOMAIN_REMOTE`
    will have a different domain ID. User may also alter the domain ID
    with :py:obj:`~.CUlaunchMemSyncDomainMap` for a specific stream /
    graph node / kernel launch. See
    :py:obj:`~.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN`,
    :py:obj:`~.cuStreamSetAttribute`, :py:obj:`~.cuLaunchKernelEx`,
    :py:obj:`~.cuGraphKernelNodeSetAttribute`.  Memory operations done
    in kernels launched in different domains are considered system-
    scope distanced. In other words, a GPU scoped memory
    synchronization is not sufficient for memory order to be observed
    by kernels in another memory synchronization domain even if they
    are on the same GPU.
    """

    #: Launch kernels in the default domain
    CU_LAUNCH_MEM_SYNC_DOMAIN_DEFAULT = cydriver.CUlaunchMemSyncDomain_enum.CU_LAUNCH_MEM_SYNC_DOMAIN_DEFAULT

    #: Launch kernels in the remote domain
    CU_LAUNCH_MEM_SYNC_DOMAIN_REMOTE = cydriver.CUlaunchMemSyncDomain_enum.CU_LAUNCH_MEM_SYNC_DOMAIN_REMOTE

_dict_CUlaunchMemSyncDomain = dict(((int(v), v) for k, v in CUlaunchMemSyncDomain.__members__.items()))

class CUlaunchAttributeID(IntEnum):
    """
    Launch attributes enum; used as id field of
    :py:obj:`~.CUlaunchAttribute`
    """

    #: Ignored entry, for convenient composition
    CU_LAUNCH_ATTRIBUTE_IGNORE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_IGNORE

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.accessPolicyWindow`.
    CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.cooperative`.
    CU_LAUNCH_ATTRIBUTE_COOPERATIVE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_COOPERATIVE

    #: Valid for streams. See
    #: :py:obj:`~.CUlaunchAttributeValue.syncPolicy`.
    CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.clusterDim`.
    CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.clusterSchedulingPolicyPreference`.
    CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE

    #: Valid for launches. Setting
    #: :py:obj:`~.CUlaunchAttributeValue.programmaticStreamSerializationAllowed`
    #: to non-0 signals that the kernel will use programmatic means to
    #: resolve its stream dependency, so that the CUDA runtime should
    #: opportunistically allow the grid's execution to overlap with the
    #: previous kernel in the stream, if that kernel requests the overlap.
    #: The dependent launches can choose to wait on the dependency using
    #: the programmatic sync (cudaGridDependencySynchronize() or equivalent
    #: PTX instructions).
    CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION

    #: Valid for launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.programmaticEvent` to record the
    #: event. Event recorded through this launch attribute is guaranteed to
    #: only trigger after all block in the associated kernel trigger the
    #: event. A block can trigger the event through PTX launchdep.release
    #: or CUDA builtin function cudaTriggerProgrammaticLaunchCompletion().
    #: A trigger can also be inserted at the beginning of each block's
    #: execution if triggerAtBlockStart is set to non-0. The dependent
    #: launches can choose to wait on the dependency using the programmatic
    #: sync (cudaGridDependencySynchronize() or equivalent PTX
    #: instructions). Note that dependents (including the CPU thread
    #: calling :py:obj:`~.cuEventSynchronize()`) are not guaranteed to
    #: observe the release precisely when it is released. For example,
    #: :py:obj:`~.cuEventSynchronize()` may only observe the event trigger
    #: long after the associated kernel has completed. This recording type
    #: is primarily meant for establishing programmatic dependency between
    #: device tasks. Note also this type of dependency allows, but does not
    #: guarantee, concurrent execution of tasks.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag set).
    CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.priority`.
    CU_LAUNCH_ATTRIBUTE_PRIORITY = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PRIORITY

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.memSyncDomainMap`.
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.memSyncDomain`.
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN

    #: Valid for graph nodes, launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.preferredClusterDim` to allow the
    #: kernel launch to specify a preferred substitute cluster dimension.
    #: Blocks may be grouped according to either the dimensions specified
    #: with this attribute (grouped into a "preferred substitute cluster"),
    #: or the one specified with
    #: :py:obj:`~.CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION` attribute (grouped
    #: into a "regular cluster"). The cluster dimensions of a "preferred
    #: substitute cluster" shall be an integer multiple greater than zero
    #: of the regular cluster dimensions. The device will attempt - on a
    #: best-effort basis - to group thread blocks into preferred clusters
    #: over grouping them into regular clusters. When it deems necessary
    #: (primarily when the device temporarily runs out of physical
    #: resources to launch the larger preferred clusters), the device may
    #: switch to launch the regular clusters instead to attempt to utilize
    #: as much of the physical device resources as possible.
    #:  Each type of cluster will have its enumeration / coordinate setup
    #: as if the grid consists solely of its type of cluster. For example,
    #: if the preferred substitute cluster dimensions double the regular
    #: cluster dimensions, there might be simultaneously a regular cluster
    #: indexed at (1,0,0), and a preferred cluster indexed at (1,0,0). In
    #: this example, the preferred substitute cluster (1,0,0) replaces
    #: regular clusters (2,0,0) and (3,0,0) and groups their blocks.
    #:  This attribute will only take effect when a regular cluster
    #: dimension has been specified. The preferred substitute cluster
    #: dimension must be an integer multiple greater than zero of the
    #: regular cluster dimension and must divide the grid. It must also be
    #: no more than `maxBlocksPerCluster`, if it is set in the kernel's
    #: `__launch_bounds__`. Otherwise it must be less than the maximum
    #: value the driver can support. Otherwise, setting this attribute to a
    #: value physically unable to fit on any particular device is
    #: permitted.
    CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION

    #: Valid for launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.launchCompletionEvent` to record
    #: the event.
    #:  Nominally, the event is triggered once all blocks of the kernel
    #: have begun execution. Currently this is a best effort. If a kernel B
    #: has a launch completion dependency on a kernel A, B may wait until A
    #: is complete. Alternatively, blocks of B may begin before all blocks
    #: of A have begun, for example if B can claim execution resources
    #: unavailable to A (e.g. they run on different GPUs) or if B is a
    #: higher priority than A. Exercise caution if such an ordering
    #: inversion could lead to deadlock.
    #:  A launch completion event is nominally similar to a programmatic
    #: event with `triggerAtBlockStart` set except that it is not visible
    #: to `cudaGridDependencySynchronize()` and can be used with compute
    #: capability less than 9.0.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag set).
    CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT

    #: Valid for graph nodes, launches. This attribute is graphs-only, and
    #: passing it to a launch in a non-capturing stream will result in an
    #: error.
    #: :py:obj:`~.CUlaunchAttributeValue`::deviceUpdatableKernelNode::deviceUpdatable
    #: can only be set to 0 or 1. Setting the field to 1 indicates that the
    #: corresponding kernel node should be device-updatable. On success, a
    #: handle will be returned via
    #: :py:obj:`~.CUlaunchAttributeValue`::deviceUpdatableKernelNode::devNode
    #: which can be passed to the various device-side update functions to
    #: update the node's kernel parameters from within another kernel. For
    #: more information on the types of device updates that can be made, as
    #: well as the relevant limitations thereof, see
    #: :py:obj:`~.cudaGraphKernelNodeUpdatesApply`.
    #:  Nodes which are device-updatable have additional restrictions
    #: compared to regular kernel nodes. Firstly, device-updatable nodes
    #: cannot be removed from their graph via
    #: :py:obj:`~.cuGraphDestroyNode`. Additionally, once opted-in to this
    #: functionality, a node cannot opt out, and any attempt to set the
    #: deviceUpdatable attribute to 0 will result in an error. Device-
    #: updatable kernel nodes also cannot have their attributes copied
    #: to/from another kernel node via
    #: :py:obj:`~.cuGraphKernelNodeCopyAttributes`. Graphs containing one
    #: or more device-updatable nodes also do not allow multiple
    #: instantiation, and neither the graph nor its instantiated version
    #: can be passed to :py:obj:`~.cuGraphExecUpdate`.
    #:  If a graph contains device-updatable nodes and updates those nodes
    #: from the device from within the graph, the graph must be uploaded
    #: with :py:obj:`~.cuGraphUpload` before it is launched. For such a
    #: graph, if host-side executable graph updates are made to the device-
    #: updatable nodes, the graph must be uploaded before it is launched
    #: again.
    CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE

    #: Valid for launches. On devices where the L1 cache and shared memory
    #: use the same hardware resources, setting
    #: :py:obj:`~.CUlaunchAttributeValue.sharedMemCarveout` to a percentage
    #: between 0-100 signals the CUDA driver to set the shared memory
    #: carveout preference, in percent of the total shared memory for that
    #: kernel launch. This attribute takes precedence over
    #: :py:obj:`~.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT`. This
    #: is only a hint, and the CUDA driver can choose a different
    #: configuration if required for the launch.
    CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT

    #: Valid for streams, graph nodes, launches. This attribute is a hint
    #: to the CUDA runtime that the launch should attempt to make the
    #: kernel maximize its NVLINK utilization.
    #:
    #:  When possible to honor this hint, CUDA will assume each block in
    #: the grid launch will carry out an even amount of NVLINK traffic, and
    #: make a best-effort attempt to adjust the kernel launch based on that
    #: assumption.
    #:  This attribute is a hint only. CUDA makes no functional or
    #: performance guarantee. Its applicability can be affected by many
    #: different factors, including driver version (i.e. CUDA doesn't
    #: guarantee the performance characteristics will be maintained between
    #: driver versions or a driver update could alter or regress previously
    #: observed perf characteristics.) It also doesn't guarantee a
    #: successful result, i.e. applying the attribute may not improve the
    #: performance of either the targeted kernel or the encapsulating
    #: application.
    #:  Valid values for
    #: :py:obj:`~.CUlaunchAttributeValue`::nvlinkUtilCentricScheduling are
    #: 0 (disabled) and 1 (enabled).
    CU_LAUNCH_ATTRIBUTE_NVLINK_UTIL_CENTRIC_SCHEDULING = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_NVLINK_UTIL_CENTRIC_SCHEDULING

_dict_CUlaunchAttributeID = dict(((int(v), v) for k, v in CUlaunchAttributeID.__members__.items()))

class CUstreamCaptureStatus(IntEnum):
    """
    Possible stream capture statuses returned by
    :py:obj:`~.cuStreamIsCapturing`
    """

    #: Stream is not capturing
    CU_STREAM_CAPTURE_STATUS_NONE = cydriver.CUstreamCaptureStatus_enum.CU_STREAM_CAPTURE_STATUS_NONE

    #: Stream is actively capturing
    CU_STREAM_CAPTURE_STATUS_ACTIVE = cydriver.CUstreamCaptureStatus_enum.CU_STREAM_CAPTURE_STATUS_ACTIVE

    #: Stream is part of a capture sequence that has been invalidated, but
    #: not terminated
    CU_STREAM_CAPTURE_STATUS_INVALIDATED = cydriver.CUstreamCaptureStatus_enum.CU_STREAM_CAPTURE_STATUS_INVALIDATED

_dict_CUstreamCaptureStatus = dict(((int(v), v) for k, v in CUstreamCaptureStatus.__members__.items()))

class CUstreamCaptureMode(IntEnum):
    """
    Possible modes for stream capture thread interactions. For more
    details see :py:obj:`~.cuStreamBeginCapture` and
    :py:obj:`~.cuThreadExchangeStreamCaptureMode`
    """
    CU_STREAM_CAPTURE_MODE_GLOBAL = cydriver.CUstreamCaptureMode_enum.CU_STREAM_CAPTURE_MODE_GLOBAL
    CU_STREAM_CAPTURE_MODE_THREAD_LOCAL = cydriver.CUstreamCaptureMode_enum.CU_STREAM_CAPTURE_MODE_THREAD_LOCAL
    CU_STREAM_CAPTURE_MODE_RELAXED = cydriver.CUstreamCaptureMode_enum.CU_STREAM_CAPTURE_MODE_RELAXED

_dict_CUstreamCaptureMode = dict(((int(v), v) for k, v in CUstreamCaptureMode.__members__.items()))

class CUdriverProcAddress_flags(IntEnum):
    """
    Flags to specify search options. For more details see
    :py:obj:`~.cuGetProcAddress`
    """

    #: Default search mode for driver symbols.
    CU_GET_PROC_ADDRESS_DEFAULT = cydriver.CUdriverProcAddress_flags_enum.CU_GET_PROC_ADDRESS_DEFAULT

    #: Search for legacy versions of driver symbols.
    CU_GET_PROC_ADDRESS_LEGACY_STREAM = cydriver.CUdriverProcAddress_flags_enum.CU_GET_PROC_ADDRESS_LEGACY_STREAM

    #: Search for per-thread versions of driver symbols.
    CU_GET_PROC_ADDRESS_PER_THREAD_DEFAULT_STREAM = cydriver.CUdriverProcAddress_flags_enum.CU_GET_PROC_ADDRESS_PER_THREAD_DEFAULT_STREAM

_dict_CUdriverProcAddress_flags = dict(((int(v), v) for k, v in CUdriverProcAddress_flags.__members__.items()))

class CUdriverProcAddressQueryResult(IntEnum):
    """
    Flags to indicate search status. For more details see
    :py:obj:`~.cuGetProcAddress`
    """

    #: Symbol was succesfully found
    CU_GET_PROC_ADDRESS_SUCCESS = cydriver.CUdriverProcAddressQueryResult_enum.CU_GET_PROC_ADDRESS_SUCCESS

    #: Symbol was not found in search
    CU_GET_PROC_ADDRESS_SYMBOL_NOT_FOUND = cydriver.CUdriverProcAddressQueryResult_enum.CU_GET_PROC_ADDRESS_SYMBOL_NOT_FOUND

    #: Symbol was found but version supplied was not sufficient
    CU_GET_PROC_ADDRESS_VERSION_NOT_SUFFICIENT = cydriver.CUdriverProcAddressQueryResult_enum.CU_GET_PROC_ADDRESS_VERSION_NOT_SUFFICIENT

_dict_CUdriverProcAddressQueryResult = dict(((int(v), v) for k, v in CUdriverProcAddressQueryResult.__members__.items()))

class CUexecAffinityType(IntEnum):
    """
    Execution Affinity Types
    """

    #: Create a context with limited SMs.
    CU_EXEC_AFFINITY_TYPE_SM_COUNT = cydriver.CUexecAffinityType_enum.CU_EXEC_AFFINITY_TYPE_SM_COUNT
    CU_EXEC_AFFINITY_TYPE_MAX = cydriver.CUexecAffinityType_enum.CU_EXEC_AFFINITY_TYPE_MAX

_dict_CUexecAffinityType = dict(((int(v), v) for k, v in CUexecAffinityType.__members__.items()))

class CUcigDataType(IntEnum):
    """

    """
    CIG_DATA_TYPE_D3D12_COMMAND_QUEUE = cydriver.CUcigDataType_enum.CIG_DATA_TYPE_D3D12_COMMAND_QUEUE

    #: D3D12 Command Queue Handle
    CIG_DATA_TYPE_NV_BLOB = cydriver.CUcigDataType_enum.CIG_DATA_TYPE_NV_BLOB

_dict_CUcigDataType = dict(((int(v), v) for k, v in CUcigDataType.__members__.items()))

class CUlibraryOption(IntEnum):
    """
    Library options to be specified with
    :py:obj:`~.cuLibraryLoadData()` or
    :py:obj:`~.cuLibraryLoadFromFile()`
    """
    CU_LIBRARY_HOST_UNIVERSAL_FUNCTION_AND_DATA_TABLE = cydriver.CUlibraryOption_enum.CU_LIBRARY_HOST_UNIVERSAL_FUNCTION_AND_DATA_TABLE

    #: Specifes that the argument `code` passed to
    #: :py:obj:`~.cuLibraryLoadData()` will be preserved. Specifying this
    #: option will let the driver know that `code` can be accessed at any
    #: point until :py:obj:`~.cuLibraryUnload()`. The default behavior is
    #: for the driver to allocate and maintain its own copy of `code`. Note
    #: that this is only a memory usage optimization hint and the driver
    #: can choose to ignore it if required. Specifying this option with
    #: :py:obj:`~.cuLibraryLoadFromFile()` is invalid and will return
    #: :py:obj:`~.CUDA_ERROR_INVALID_VALUE`.
    CU_LIBRARY_BINARY_IS_PRESERVED = cydriver.CUlibraryOption_enum.CU_LIBRARY_BINARY_IS_PRESERVED
    CU_LIBRARY_NUM_OPTIONS = cydriver.CUlibraryOption_enum.CU_LIBRARY_NUM_OPTIONS

_dict_CUlibraryOption = dict(((int(v), v) for k, v in CUlibraryOption.__members__.items()))

class CUresult(IntEnum):
    """
    Error codes
    """

    #: The API call returned with no errors. In the case of query calls,
    #: this also means that the operation being queried is complete (see
    #: :py:obj:`~.cuEventQuery()` and :py:obj:`~.cuStreamQuery()`).
    CUDA_SUCCESS = cydriver.cudaError_enum.CUDA_SUCCESS

    #: This indicates that one or more of the parameters passed to the API
    #: call is not within an acceptable range of values.
    CUDA_ERROR_INVALID_VALUE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_VALUE

    #: The API call failed because it was unable to allocate enough memory
    #: or other resources to perform the requested operation.
    CUDA_ERROR_OUT_OF_MEMORY = cydriver.cudaError_enum.CUDA_ERROR_OUT_OF_MEMORY

    #: This indicates that the CUDA driver has not been initialized with
    #: :py:obj:`~.cuInit()` or that initialization has failed.
    CUDA_ERROR_NOT_INITIALIZED = cydriver.cudaError_enum.CUDA_ERROR_NOT_INITIALIZED

    #: This indicates that the CUDA driver is in the process of shutting
    #: down.
    CUDA_ERROR_DEINITIALIZED = cydriver.cudaError_enum.CUDA_ERROR_DEINITIALIZED

    #: This indicates profiler is not initialized for this run. This can
    #: happen when the application is running with external profiling tools
    #: like visual profiler.
    CUDA_ERROR_PROFILER_DISABLED = cydriver.cudaError_enum.CUDA_ERROR_PROFILER_DISABLED

    #: [Deprecated]
    CUDA_ERROR_PROFILER_NOT_INITIALIZED = cydriver.cudaError_enum.CUDA_ERROR_PROFILER_NOT_INITIALIZED

    #: [Deprecated]
    CUDA_ERROR_PROFILER_ALREADY_STARTED = cydriver.cudaError_enum.CUDA_ERROR_PROFILER_ALREADY_STARTED

    #: [Deprecated]
    CUDA_ERROR_PROFILER_ALREADY_STOPPED = cydriver.cudaError_enum.CUDA_ERROR_PROFILER_ALREADY_STOPPED

    #: This indicates that the CUDA driver that the application has loaded
    #: is a stub library. Applications that run with the stub rather than a
    #: real driver loaded will result in CUDA API returning this error.
    CUDA_ERROR_STUB_LIBRARY = cydriver.cudaError_enum.CUDA_ERROR_STUB_LIBRARY

    #: This indicates that the API call requires a newer CUDA driver than
    #: the one currently installed. Users should install an updated NVIDIA
    #: CUDA driver to allow the API call to succeed.
    CUDA_ERROR_CALL_REQUIRES_NEWER_DRIVER = cydriver.cudaError_enum.CUDA_ERROR_CALL_REQUIRES_NEWER_DRIVER

    #: This indicates that requested CUDA device is unavailable at the
    #: current time. Devices are often unavailable due to use of
    #: :py:obj:`~.CU_COMPUTEMODE_EXCLUSIVE_PROCESS` or
    #: :py:obj:`~.CU_COMPUTEMODE_PROHIBITED`.
    CUDA_ERROR_DEVICE_UNAVAILABLE = cydriver.cudaError_enum.CUDA_ERROR_DEVICE_UNAVAILABLE

    #: This indicates that no CUDA-capable devices were detected by the
    #: installed CUDA driver.
    CUDA_ERROR_NO_DEVICE = cydriver.cudaError_enum.CUDA_ERROR_NO_DEVICE

    #: This indicates that the device ordinal supplied by the user does not
    #: correspond to a valid CUDA device or that the action requested is
    #: invalid for the specified device.
    CUDA_ERROR_INVALID_DEVICE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_DEVICE

    #: This error indicates that the Grid license is not applied.
    CUDA_ERROR_DEVICE_NOT_LICENSED = cydriver.cudaError_enum.CUDA_ERROR_DEVICE_NOT_LICENSED

    #: This indicates that the device kernel image is invalid. This can
    #: also indicate an invalid CUDA module.
    CUDA_ERROR_INVALID_IMAGE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_IMAGE

    #: This most frequently indicates that there is no context bound to the
    #: current thread. This can also be returned if the context passed to
    #: an API call is not a valid handle (such as a context that has had
    #: :py:obj:`~.cuCtxDestroy()` invoked on it). This can also be returned
    #: if a user mixes different API versions (i.e. 3010 context with 3020
    #: API calls). See :py:obj:`~.cuCtxGetApiVersion()` for more details.
    #: This can also be returned if the green context passed to an API call
    #: was not converted to a :py:obj:`~.CUcontext` using
    #: :py:obj:`~.cuCtxFromGreenCtx` API.
    CUDA_ERROR_INVALID_CONTEXT = cydriver.cudaError_enum.CUDA_ERROR_INVALID_CONTEXT

    #: This indicated that the context being supplied as a parameter to the
    #: API call was already the active context. [Deprecated]
    CUDA_ERROR_CONTEXT_ALREADY_CURRENT = cydriver.cudaError_enum.CUDA_ERROR_CONTEXT_ALREADY_CURRENT

    #: This indicates that a map or register operation has failed.
    CUDA_ERROR_MAP_FAILED = cydriver.cudaError_enum.CUDA_ERROR_MAP_FAILED

    #: This indicates that an unmap or unregister operation has failed.
    CUDA_ERROR_UNMAP_FAILED = cydriver.cudaError_enum.CUDA_ERROR_UNMAP_FAILED

    #: This indicates that the specified array is currently mapped and thus
    #: cannot be destroyed.
    CUDA_ERROR_ARRAY_IS_MAPPED = cydriver.cudaError_enum.CUDA_ERROR_ARRAY_IS_MAPPED

    #: This indicates that the resource is already mapped.
    CUDA_ERROR_ALREADY_MAPPED = cydriver.cudaError_enum.CUDA_ERROR_ALREADY_MAPPED

    #: This indicates that there is no kernel image available that is
    #: suitable for the device. This can occur when a user specifies code
    #: generation options for a particular CUDA source file that do not
    #: include the corresponding device configuration.
    CUDA_ERROR_NO_BINARY_FOR_GPU = cydriver.cudaError_enum.CUDA_ERROR_NO_BINARY_FOR_GPU

    #: This indicates that a resource has already been acquired.
    CUDA_ERROR_ALREADY_ACQUIRED = cydriver.cudaError_enum.CUDA_ERROR_ALREADY_ACQUIRED

    #: This indicates that a resource is not mapped.
    CUDA_ERROR_NOT_MAPPED = cydriver.cudaError_enum.CUDA_ERROR_NOT_MAPPED

    #: This indicates that a mapped resource is not available for access as
    #: an array.
    CUDA_ERROR_NOT_MAPPED_AS_ARRAY = cydriver.cudaError_enum.CUDA_ERROR_NOT_MAPPED_AS_ARRAY

    #: This indicates that a mapped resource is not available for access as
    #: a pointer.
    CUDA_ERROR_NOT_MAPPED_AS_POINTER = cydriver.cudaError_enum.CUDA_ERROR_NOT_MAPPED_AS_POINTER

    #: This indicates that an uncorrectable ECC error was detected during
    #: execution.
    CUDA_ERROR_ECC_UNCORRECTABLE = cydriver.cudaError_enum.CUDA_ERROR_ECC_UNCORRECTABLE

    #: This indicates that the :py:obj:`~.CUlimit` passed to the API call
    #: is not supported by the active device.
    CUDA_ERROR_UNSUPPORTED_LIMIT = cydriver.cudaError_enum.CUDA_ERROR_UNSUPPORTED_LIMIT

    #: This indicates that the :py:obj:`~.CUcontext` passed to the API call
    #: can only be bound to a single CPU thread at a time but is already
    #: bound to a CPU thread.
    CUDA_ERROR_CONTEXT_ALREADY_IN_USE = cydriver.cudaError_enum.CUDA_ERROR_CONTEXT_ALREADY_IN_USE

    #: This indicates that peer access is not supported across the given
    #: devices.
    CUDA_ERROR_PEER_ACCESS_UNSUPPORTED = cydriver.cudaError_enum.CUDA_ERROR_PEER_ACCESS_UNSUPPORTED

    #: This indicates that a PTX JIT compilation failed.
    CUDA_ERROR_INVALID_PTX = cydriver.cudaError_enum.CUDA_ERROR_INVALID_PTX

    #: This indicates an error with OpenGL or DirectX context.
    CUDA_ERROR_INVALID_GRAPHICS_CONTEXT = cydriver.cudaError_enum.CUDA_ERROR_INVALID_GRAPHICS_CONTEXT

    #: This indicates that an uncorrectable NVLink error was detected
    #: during the execution.
    CUDA_ERROR_NVLINK_UNCORRECTABLE = cydriver.cudaError_enum.CUDA_ERROR_NVLINK_UNCORRECTABLE

    #: This indicates that the PTX JIT compiler library was not found.
    CUDA_ERROR_JIT_COMPILER_NOT_FOUND = cydriver.cudaError_enum.CUDA_ERROR_JIT_COMPILER_NOT_FOUND

    #: This indicates that the provided PTX was compiled with an
    #: unsupported toolchain.
    CUDA_ERROR_UNSUPPORTED_PTX_VERSION = cydriver.cudaError_enum.CUDA_ERROR_UNSUPPORTED_PTX_VERSION

    #: This indicates that the PTX JIT compilation was disabled.
    CUDA_ERROR_JIT_COMPILATION_DISABLED = cydriver.cudaError_enum.CUDA_ERROR_JIT_COMPILATION_DISABLED

    #: This indicates that the :py:obj:`~.CUexecAffinityType` passed to the
    #: API call is not supported by the active device.
    CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY = cydriver.cudaError_enum.CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY

    #: This indicates that the code to be compiled by the PTX JIT contains
    #: unsupported call to cudaDeviceSynchronize.
    CUDA_ERROR_UNSUPPORTED_DEVSIDE_SYNC = cydriver.cudaError_enum.CUDA_ERROR_UNSUPPORTED_DEVSIDE_SYNC

    #: This indicates that an exception occurred on the device that is now
    #: contained by the GPU's error containment capability. Common causes
    #: are - a. Certain types of invalid accesses of peer GPU memory over
    #: nvlink b. Certain classes of hardware errors This leaves the process
    #: in an inconsistent state and any further CUDA work will return the
    #: same error. To continue using CUDA, the process must be terminated
    #: and relaunched.
    CUDA_ERROR_CONTAINED = cydriver.cudaError_enum.CUDA_ERROR_CONTAINED

    #: This indicates that the device kernel source is invalid. This
    #: includes compilation/linker errors encountered in device code or
    #: user error.
    CUDA_ERROR_INVALID_SOURCE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_SOURCE

    #: This indicates that the file specified was not found.
    CUDA_ERROR_FILE_NOT_FOUND = cydriver.cudaError_enum.CUDA_ERROR_FILE_NOT_FOUND

    #: This indicates that a link to a shared object failed to resolve.
    CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND = cydriver.cudaError_enum.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND

    #: This indicates that initialization of a shared object failed.
    CUDA_ERROR_SHARED_OBJECT_INIT_FAILED = cydriver.cudaError_enum.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED

    #: This indicates that an OS call failed.
    CUDA_ERROR_OPERATING_SYSTEM = cydriver.cudaError_enum.CUDA_ERROR_OPERATING_SYSTEM

    #: This indicates that a resource handle passed to the API call was not
    #: valid. Resource handles are opaque types like :py:obj:`~.CUstream`
    #: and :py:obj:`~.CUevent`.
    CUDA_ERROR_INVALID_HANDLE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_HANDLE

    #: This indicates that a resource required by the API call is not in a
    #: valid state to perform the requested operation.
    CUDA_ERROR_ILLEGAL_STATE = cydriver.cudaError_enum.CUDA_ERROR_ILLEGAL_STATE

    #: This indicates an attempt was made to introspect an object in a way
    #: that would discard semantically important information. This is
    #: either due to the object using funtionality newer than the API
    #: version used to introspect it or omission of optional return
    #: arguments.
    CUDA_ERROR_LOSSY_QUERY = cydriver.cudaError_enum.CUDA_ERROR_LOSSY_QUERY

    #: This indicates that a named symbol was not found. Examples of
    #: symbols are global/constant variable names, driver function names,
    #: texture names, and surface names.
    CUDA_ERROR_NOT_FOUND = cydriver.cudaError_enum.CUDA_ERROR_NOT_FOUND

    #: This indicates that asynchronous operations issued previously have
    #: not completed yet. This result is not actually an error, but must be
    #: indicated differently than :py:obj:`~.CUDA_SUCCESS` (which indicates
    #: completion). Calls that may return this value include
    #: :py:obj:`~.cuEventQuery()` and :py:obj:`~.cuStreamQuery()`.
    CUDA_ERROR_NOT_READY = cydriver.cudaError_enum.CUDA_ERROR_NOT_READY

    #: While executing a kernel, the device encountered a load or store
    #: instruction on an invalid memory address. This leaves the process in
    #: an inconsistent state and any further CUDA work will return the same
    #: error. To continue using CUDA, the process must be terminated and
    #: relaunched.
    CUDA_ERROR_ILLEGAL_ADDRESS = cydriver.cudaError_enum.CUDA_ERROR_ILLEGAL_ADDRESS

    #: This indicates that a launch did not occur because it did not have
    #: appropriate resources. This error usually indicates that the user
    #: has attempted to pass too many arguments to the device kernel, or
    #: the kernel launch specifies too many threads for the kernel's
    #: register count. Passing arguments of the wrong size (i.e. a 64-bit
    #: pointer when a 32-bit int is expected) is equivalent to passing too
    #: many arguments and can also result in this error.
    CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES = cydriver.cudaError_enum.CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES

    #: This indicates that the device kernel took too long to execute. This
    #: can only occur if timeouts are enabled - see the device attribute
    #: :py:obj:`~.CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT` for more
    #: information. This leaves the process in an inconsistent state and
    #: any further CUDA work will return the same error. To continue using
    #: CUDA, the process must be terminated and relaunched.
    CUDA_ERROR_LAUNCH_TIMEOUT = cydriver.cudaError_enum.CUDA_ERROR_LAUNCH_TIMEOUT

    #: This error indicates a kernel launch that uses an incompatible
    #: texturing mode.
    CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING = cydriver.cudaError_enum.CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING

    #: This error indicates that a call to
    #: :py:obj:`~.cuCtxEnablePeerAccess()` is trying to re-enable peer
    #: access to a context which has already had peer access to it enabled.
    CUDA_ERROR_PEER_ACCESS_ALREADY_ENABLED = cydriver.cudaError_enum.CUDA_ERROR_PEER_ACCESS_ALREADY_ENABLED

    #: This error indicates that :py:obj:`~.cuCtxDisablePeerAccess()` is
    #: trying to disable peer access which has not been enabled yet via
    #: :py:obj:`~.cuCtxEnablePeerAccess()`.
    CUDA_ERROR_PEER_ACCESS_NOT_ENABLED = cydriver.cudaError_enum.CUDA_ERROR_PEER_ACCESS_NOT_ENABLED

    #: This error indicates that the primary context for the specified
    #: device has already been initialized.
    CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE = cydriver.cudaError_enum.CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE

    #: This error indicates that the context current to the calling thread
    #: has been destroyed using :py:obj:`~.cuCtxDestroy`, or is a primary
    #: context which has not yet been initialized.
    CUDA_ERROR_CONTEXT_IS_DESTROYED = cydriver.cudaError_enum.CUDA_ERROR_CONTEXT_IS_DESTROYED

    #: A device-side assert triggered during kernel execution. The context
    #: cannot be used anymore, and must be destroyed. All existing device
    #: memory allocations from this context are invalid and must be
    #: reconstructed if the program is to continue using CUDA.
    CUDA_ERROR_ASSERT = cydriver.cudaError_enum.CUDA_ERROR_ASSERT

    #: This error indicates that the hardware resources required to enable
    #: peer access have been exhausted for one or more of the devices
    #: passed to :py:obj:`~.cuCtxEnablePeerAccess()`.
    CUDA_ERROR_TOO_MANY_PEERS = cydriver.cudaError_enum.CUDA_ERROR_TOO_MANY_PEERS

    #: This error indicates that the memory range passed to
    #: :py:obj:`~.cuMemHostRegister()` has already been registered.
    CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED = cydriver.cudaError_enum.CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED

    #: This error indicates that the pointer passed to
    #: :py:obj:`~.cuMemHostUnregister()` does not correspond to any
    #: currently registered memory region.
    CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED = cydriver.cudaError_enum.CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED

    #: While executing a kernel, the device encountered a stack error. This
    #: can be due to stack corruption or exceeding the stack size limit.
    #: This leaves the process in an inconsistent state and any further
    #: CUDA work will return the same error. To continue using CUDA, the
    #: process must be terminated and relaunched.
    CUDA_ERROR_HARDWARE_STACK_ERROR = cydriver.cudaError_enum.CUDA_ERROR_HARDWARE_STACK_ERROR

    #: While executing a kernel, the device encountered an illegal
    #: instruction. This leaves the process in an inconsistent state and
    #: any further CUDA work will return the same error. To continue using
    #: CUDA, the process must be terminated and relaunched.
    CUDA_ERROR_ILLEGAL_INSTRUCTION = cydriver.cudaError_enum.CUDA_ERROR_ILLEGAL_INSTRUCTION

    #: While executing a kernel, the device encountered a load or store
    #: instruction on a memory address which is not aligned. This leaves
    #: the process in an inconsistent state and any further CUDA work will
    #: return the same error. To continue using CUDA, the process must be
    #: terminated and relaunched.
    CUDA_ERROR_MISALIGNED_ADDRESS = cydriver.cudaError_enum.CUDA_ERROR_MISALIGNED_ADDRESS

    #: While executing a kernel, the device encountered an instruction
    #: which can only operate on memory locations in certain address spaces
    #: (global, shared, or local), but was supplied a memory address not
    #: belonging to an allowed address space. This leaves the process in an
    #: inconsistent state and any further CUDA work will return the same
    #: error. To continue using CUDA, the process must be terminated and
    #: relaunched.
    CUDA_ERROR_INVALID_ADDRESS_SPACE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_ADDRESS_SPACE

    #: While executing a kernel, the device program counter wrapped its
    #: address space. This leaves the process in an inconsistent state and
    #: any further CUDA work will return the same error. To continue using
    #: CUDA, the process must be terminated and relaunched.
    CUDA_ERROR_INVALID_PC = cydriver.cudaError_enum.CUDA_ERROR_INVALID_PC

    #: An exception occurred on the device while executing a kernel. Common
    #: causes include dereferencing an invalid device pointer and accessing
    #: out of bounds shared memory. Less common cases can be system
    #: specific - more information about these cases can be found in the
    #: system specific user guide. This leaves the process in an
    #: inconsistent state and any further CUDA work will return the same
    #: error. To continue using CUDA, the process must be terminated and
    #: relaunched.
    CUDA_ERROR_LAUNCH_FAILED = cydriver.cudaError_enum.CUDA_ERROR_LAUNCH_FAILED

    #: This error indicates that the number of blocks launched per grid for
    #: a kernel that was launched via either
    #: :py:obj:`~.cuLaunchCooperativeKernel` or
    #: :py:obj:`~.cuLaunchCooperativeKernelMultiDevice` exceeds the maximum
    #: number of blocks as allowed by
    #: :py:obj:`~.cuOccupancyMaxActiveBlocksPerMultiprocessor` or
    #: :py:obj:`~.cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags`
    #: times the number of multiprocessors as specified by the device
    #: attribute :py:obj:`~.CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT`.
    CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE = cydriver.cudaError_enum.CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE

    #: An exception occurred on the device while exiting a kernel using
    #: tensor memory: the tensor memory was not completely deallocated.
    #: This leaves the process in an inconsistent state and any further
    #: CUDA work will return the same error. To continue using CUDA, the
    #: process must be terminated and relaunched.
    CUDA_ERROR_TENSOR_MEMORY_LEAK = cydriver.cudaError_enum.CUDA_ERROR_TENSOR_MEMORY_LEAK

    #: This error indicates that the attempted operation is not permitted.
    CUDA_ERROR_NOT_PERMITTED = cydriver.cudaError_enum.CUDA_ERROR_NOT_PERMITTED

    #: This error indicates that the attempted operation is not supported
    #: on the current system or device.
    CUDA_ERROR_NOT_SUPPORTED = cydriver.cudaError_enum.CUDA_ERROR_NOT_SUPPORTED

    #: This error indicates that the system is not yet ready to start any
    #: CUDA work. To continue using CUDA, verify the system configuration
    #: is in a valid state and all required driver daemons are actively
    #: running. More information about this error can be found in the
    #: system specific user guide.
    CUDA_ERROR_SYSTEM_NOT_READY = cydriver.cudaError_enum.CUDA_ERROR_SYSTEM_NOT_READY

    #: This error indicates that there is a mismatch between the versions
    #: of the display driver and the CUDA driver. Refer to the
    #: compatibility documentation for supported versions.
    CUDA_ERROR_SYSTEM_DRIVER_MISMATCH = cydriver.cudaError_enum.CUDA_ERROR_SYSTEM_DRIVER_MISMATCH

    #: This error indicates that the system was upgraded to run with
    #: forward compatibility but the visible hardware detected by CUDA does
    #: not support this configuration. Refer to the compatibility
    #: documentation for the supported hardware matrix or ensure that only
    #: supported hardware is visible during initialization via the
    #: CUDA_VISIBLE_DEVICES environment variable.
    CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE = cydriver.cudaError_enum.CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE

    #: This error indicates that the MPS client failed to connect to the
    #: MPS control daemon or the MPS server.
    CUDA_ERROR_MPS_CONNECTION_FAILED = cydriver.cudaError_enum.CUDA_ERROR_MPS_CONNECTION_FAILED

    #: This error indicates that the remote procedural call between the MPS
    #: server and the MPS client failed.
    CUDA_ERROR_MPS_RPC_FAILURE = cydriver.cudaError_enum.CUDA_ERROR_MPS_RPC_FAILURE

    #: This error indicates that the MPS server is not ready to accept new
    #: MPS client requests. This error can be returned when the MPS server
    #: is in the process of recovering from a fatal failure.
    CUDA_ERROR_MPS_SERVER_NOT_READY = cydriver.cudaError_enum.CUDA_ERROR_MPS_SERVER_NOT_READY

    #: This error indicates that the hardware resources required to create
    #: MPS client have been exhausted.
    CUDA_ERROR_MPS_MAX_CLIENTS_REACHED = cydriver.cudaError_enum.CUDA_ERROR_MPS_MAX_CLIENTS_REACHED

    #: This error indicates the the hardware resources required to support
    #: device connections have been exhausted.
    CUDA_ERROR_MPS_MAX_CONNECTIONS_REACHED = cydriver.cudaError_enum.CUDA_ERROR_MPS_MAX_CONNECTIONS_REACHED

    #: This error indicates that the MPS client has been terminated by the
    #: server. To continue using CUDA, the process must be terminated and
    #: relaunched.
    CUDA_ERROR_MPS_CLIENT_TERMINATED = cydriver.cudaError_enum.CUDA_ERROR_MPS_CLIENT_TERMINATED

    #: This error indicates that the module is using CUDA Dynamic
    #: Parallelism, but the current configuration, like MPS, does not
    #: support it.
    CUDA_ERROR_CDP_NOT_SUPPORTED = cydriver.cudaError_enum.CUDA_ERROR_CDP_NOT_SUPPORTED

    #: This error indicates that a module contains an unsupported
    #: interaction between different versions of CUDA Dynamic Parallelism.
    CUDA_ERROR_CDP_VERSION_MISMATCH = cydriver.cudaError_enum.CUDA_ERROR_CDP_VERSION_MISMATCH

    #: This error indicates that the operation is not permitted when the
    #: stream is capturing.
    CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED

    #: This error indicates that the current capture sequence on the stream
    #: has been invalidated due to a previous error.
    CUDA_ERROR_STREAM_CAPTURE_INVALIDATED = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_INVALIDATED

    #: This error indicates that the operation would have resulted in a
    #: merge of two independent capture sequences.
    CUDA_ERROR_STREAM_CAPTURE_MERGE = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_MERGE

    #: This error indicates that the capture was not initiated in this
    #: stream.
    CUDA_ERROR_STREAM_CAPTURE_UNMATCHED = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_UNMATCHED

    #: This error indicates that the capture sequence contains a fork that
    #: was not joined to the primary stream.
    CUDA_ERROR_STREAM_CAPTURE_UNJOINED = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_UNJOINED

    #: This error indicates that a dependency would have been created which
    #: crosses the capture sequence boundary. Only implicit in-stream
    #: ordering dependencies are allowed to cross the boundary.
    CUDA_ERROR_STREAM_CAPTURE_ISOLATION = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_ISOLATION

    #: This error indicates a disallowed implicit dependency on a current
    #: capture sequence from cudaStreamLegacy.
    CUDA_ERROR_STREAM_CAPTURE_IMPLICIT = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_IMPLICIT

    #: This error indicates that the operation is not permitted on an event
    #: which was last recorded in a capturing stream.
    CUDA_ERROR_CAPTURED_EVENT = cydriver.cudaError_enum.CUDA_ERROR_CAPTURED_EVENT

    #: A stream capture sequence not initiated with the
    #: :py:obj:`~.CU_STREAM_CAPTURE_MODE_RELAXED` argument to
    #: :py:obj:`~.cuStreamBeginCapture` was passed to
    #: :py:obj:`~.cuStreamEndCapture` in a different thread.
    CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD = cydriver.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD

    #: This error indicates that the timeout specified for the wait
    #: operation has lapsed.
    CUDA_ERROR_TIMEOUT = cydriver.cudaError_enum.CUDA_ERROR_TIMEOUT

    #: This error indicates that the graph update was not performed because
    #: it included changes which violated constraints specific to
    #: instantiated graph update.
    CUDA_ERROR_GRAPH_EXEC_UPDATE_FAILURE = cydriver.cudaError_enum.CUDA_ERROR_GRAPH_EXEC_UPDATE_FAILURE

    #: This indicates that an async error has occurred in a device outside
    #: of CUDA. If CUDA was waiting for an external device's signal before
    #: consuming shared data, the external device signaled an error
    #: indicating that the data is not valid for consumption. This leaves
    #: the process in an inconsistent state and any further CUDA work will
    #: return the same error. To continue using CUDA, the process must be
    #: terminated and relaunched.
    CUDA_ERROR_EXTERNAL_DEVICE = cydriver.cudaError_enum.CUDA_ERROR_EXTERNAL_DEVICE

    #: Indicates a kernel launch error due to cluster misconfiguration.
    CUDA_ERROR_INVALID_CLUSTER_SIZE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_CLUSTER_SIZE

    #: Indiciates a function handle is not loaded when calling an API that
    #: requires a loaded function.
    CUDA_ERROR_FUNCTION_NOT_LOADED = cydriver.cudaError_enum.CUDA_ERROR_FUNCTION_NOT_LOADED

    #: This error indicates one or more resources passed in are not valid
    #: resource types for the operation.
    CUDA_ERROR_INVALID_RESOURCE_TYPE = cydriver.cudaError_enum.CUDA_ERROR_INVALID_RESOURCE_TYPE

    #: This error indicates one or more resources are insufficient or non-
    #: applicable for the operation.
    CUDA_ERROR_INVALID_RESOURCE_CONFIGURATION = cydriver.cudaError_enum.CUDA_ERROR_INVALID_RESOURCE_CONFIGURATION

    #: This error indicates that an error happened during the key rotation
    #: sequence.
    CUDA_ERROR_KEY_ROTATION = cydriver.cudaError_enum.CUDA_ERROR_KEY_ROTATION

    #: This indicates that an unknown internal error has occurred.
    CUDA_ERROR_UNKNOWN = cydriver.cudaError_enum.CUDA_ERROR_UNKNOWN

_dict_CUresult = dict(((int(v), v) for k, v in CUresult.__members__.items()))

class CUdevice_P2PAttribute(IntEnum):
    """
    P2P Attributes
    """

    #: A relative value indicating the performance of the link between two
    #: devices
    CU_DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK = cydriver.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK

    #: P2P Access is enable
    CU_DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED = cydriver.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED

    #: All CUDA-valid atomic operation over the link are supported
    CU_DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED = cydriver.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED

    #: [Deprecated]
    CU_DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED = cydriver.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED

    #: Accessing CUDA arrays over the link supported
    CU_DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED = cydriver.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED

    #: Only some CUDA-valid atomic operations over the link are supported.
    CU_DEVICE_P2P_ATTRIBUTE_ONLY_PARTIAL_NATIVE_ATOMIC_SUPPORTED = cydriver.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_ONLY_PARTIAL_NATIVE_ATOMIC_SUPPORTED

_dict_CUdevice_P2PAttribute = dict(((int(v), v) for k, v in CUdevice_P2PAttribute.__members__.items()))

class CUatomicOperation(IntEnum):
    """
    CUDA-valid Atomic Operations
    """
    CU_ATOMIC_OPERATION_INTEGER_ADD = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_INTEGER_ADD
    CU_ATOMIC_OPERATION_INTEGER_MIN = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_INTEGER_MIN
    CU_ATOMIC_OPERATION_INTEGER_MAX = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_INTEGER_MAX
    CU_ATOMIC_OPERATION_INTEGER_INCREMENT = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_INTEGER_INCREMENT
    CU_ATOMIC_OPERATION_INTEGER_DECREMENT = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_INTEGER_DECREMENT
    CU_ATOMIC_OPERATION_AND = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_AND
    CU_ATOMIC_OPERATION_OR = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_OR
    CU_ATOMIC_OPERATION_XOR = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_XOR
    CU_ATOMIC_OPERATION_EXCHANGE = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_EXCHANGE
    CU_ATOMIC_OPERATION_CAS = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_CAS
    CU_ATOMIC_OPERATION_FLOAT_ADD = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_FLOAT_ADD
    CU_ATOMIC_OPERATION_FLOAT_MIN = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_FLOAT_MIN
    CU_ATOMIC_OPERATION_FLOAT_MAX = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_FLOAT_MAX
    CU_ATOMIC_OPERATION_MAX = cydriver.CUatomicOperation_enum.CU_ATOMIC_OPERATION_MAX

_dict_CUatomicOperation = dict(((int(v), v) for k, v in CUatomicOperation.__members__.items()))

class CUatomicOperationCapability(IntEnum):
    """
    CUDA-valid Atomic Operation capabilities
    """








_dict_CUatomicOperationCapability = dict(((int(v), v) for k, v in CUatomicOperationCapability.__members__.items()))

class CUresourceViewFormat(IntEnum):
    """
    Resource view format
    """

    #: No resource view format (use underlying resource format)
    CU_RES_VIEW_FORMAT_NONE = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_NONE

    #: 1 channel unsigned 8-bit integers
    CU_RES_VIEW_FORMAT_UINT_1X8 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_1X8

    #: 2 channel unsigned 8-bit integers
    CU_RES_VIEW_FORMAT_UINT_2X8 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_2X8

    #: 4 channel unsigned 8-bit integers
    CU_RES_VIEW_FORMAT_UINT_4X8 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_4X8

    #: 1 channel signed 8-bit integers
    CU_RES_VIEW_FORMAT_SINT_1X8 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_1X8

    #: 2 channel signed 8-bit integers
    CU_RES_VIEW_FORMAT_SINT_2X8 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_2X8

    #: 4 channel signed 8-bit integers
    CU_RES_VIEW_FORMAT_SINT_4X8 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_4X8

    #: 1 channel unsigned 16-bit integers
    CU_RES_VIEW_FORMAT_UINT_1X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_1X16

    #: 2 channel unsigned 16-bit integers
    CU_RES_VIEW_FORMAT_UINT_2X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_2X16

    #: 4 channel unsigned 16-bit integers
    CU_RES_VIEW_FORMAT_UINT_4X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_4X16

    #: 1 channel signed 16-bit integers
    CU_RES_VIEW_FORMAT_SINT_1X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_1X16

    #: 2 channel signed 16-bit integers
    CU_RES_VIEW_FORMAT_SINT_2X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_2X16

    #: 4 channel signed 16-bit integers
    CU_RES_VIEW_FORMAT_SINT_4X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_4X16

    #: 1 channel unsigned 32-bit integers
    CU_RES_VIEW_FORMAT_UINT_1X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_1X32

    #: 2 channel unsigned 32-bit integers
    CU_RES_VIEW_FORMAT_UINT_2X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_2X32

    #: 4 channel unsigned 32-bit integers
    CU_RES_VIEW_FORMAT_UINT_4X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_4X32

    #: 1 channel signed 32-bit integers
    CU_RES_VIEW_FORMAT_SINT_1X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_1X32

    #: 2 channel signed 32-bit integers
    CU_RES_VIEW_FORMAT_SINT_2X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_2X32

    #: 4 channel signed 32-bit integers
    CU_RES_VIEW_FORMAT_SINT_4X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_4X32

    #: 1 channel 16-bit floating point
    CU_RES_VIEW_FORMAT_FLOAT_1X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_1X16

    #: 2 channel 16-bit floating point
    CU_RES_VIEW_FORMAT_FLOAT_2X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_2X16

    #: 4 channel 16-bit floating point
    CU_RES_VIEW_FORMAT_FLOAT_4X16 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_4X16

    #: 1 channel 32-bit floating point
    CU_RES_VIEW_FORMAT_FLOAT_1X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_1X32

    #: 2 channel 32-bit floating point
    CU_RES_VIEW_FORMAT_FLOAT_2X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_2X32

    #: 4 channel 32-bit floating point
    CU_RES_VIEW_FORMAT_FLOAT_4X32 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_4X32

    #: Block compressed 1
    CU_RES_VIEW_FORMAT_UNSIGNED_BC1 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC1

    #: Block compressed 2
    CU_RES_VIEW_FORMAT_UNSIGNED_BC2 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC2

    #: Block compressed 3
    CU_RES_VIEW_FORMAT_UNSIGNED_BC3 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC3

    #: Block compressed 4 unsigned
    CU_RES_VIEW_FORMAT_UNSIGNED_BC4 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC4

    #: Block compressed 4 signed
    CU_RES_VIEW_FORMAT_SIGNED_BC4 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SIGNED_BC4

    #: Block compressed 5 unsigned
    CU_RES_VIEW_FORMAT_UNSIGNED_BC5 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC5

    #: Block compressed 5 signed
    CU_RES_VIEW_FORMAT_SIGNED_BC5 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SIGNED_BC5

    #: Block compressed 6 unsigned half-float
    CU_RES_VIEW_FORMAT_UNSIGNED_BC6H = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC6H

    #: Block compressed 6 signed half-float
    CU_RES_VIEW_FORMAT_SIGNED_BC6H = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SIGNED_BC6H

    #: Block compressed 7
    CU_RES_VIEW_FORMAT_UNSIGNED_BC7 = cydriver.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC7

_dict_CUresourceViewFormat = dict(((int(v), v) for k, v in CUresourceViewFormat.__members__.items()))

class CUtensorMapDataType(IntEnum):
    """
    Tensor map data type
    """
    CU_TENSOR_MAP_DATA_TYPE_UINT8 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_UINT8
    CU_TENSOR_MAP_DATA_TYPE_UINT16 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_UINT16
    CU_TENSOR_MAP_DATA_TYPE_UINT32 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_UINT32
    CU_TENSOR_MAP_DATA_TYPE_INT32 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_INT32
    CU_TENSOR_MAP_DATA_TYPE_UINT64 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_UINT64
    CU_TENSOR_MAP_DATA_TYPE_INT64 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_INT64
    CU_TENSOR_MAP_DATA_TYPE_FLOAT16 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_FLOAT16
    CU_TENSOR_MAP_DATA_TYPE_FLOAT32 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_FLOAT32
    CU_TENSOR_MAP_DATA_TYPE_FLOAT64 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_FLOAT64
    CU_TENSOR_MAP_DATA_TYPE_BFLOAT16 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_BFLOAT16
    CU_TENSOR_MAP_DATA_TYPE_FLOAT32_FTZ = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_FLOAT32_FTZ
    CU_TENSOR_MAP_DATA_TYPE_TFLOAT32 = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_TFLOAT32
    CU_TENSOR_MAP_DATA_TYPE_TFLOAT32_FTZ = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_TFLOAT32_FTZ
    CU_TENSOR_MAP_DATA_TYPE_16U4_ALIGN8B = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_16U4_ALIGN8B
    CU_TENSOR_MAP_DATA_TYPE_16U4_ALIGN16B = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_16U4_ALIGN16B
    CU_TENSOR_MAP_DATA_TYPE_16U6_ALIGN16B = cydriver.CUtensorMapDataType_enum.CU_TENSOR_MAP_DATA_TYPE_16U6_ALIGN16B

_dict_CUtensorMapDataType = dict(((int(v), v) for k, v in CUtensorMapDataType.__members__.items()))

class CUtensorMapInterleave(IntEnum):
    """
    Tensor map interleave layout type
    """
    CU_TENSOR_MAP_INTERLEAVE_NONE = cydriver.CUtensorMapInterleave_enum.CU_TENSOR_MAP_INTERLEAVE_NONE
    CU_TENSOR_MAP_INTERLEAVE_16B = cydriver.CUtensorMapInterleave_enum.CU_TENSOR_MAP_INTERLEAVE_16B
    CU_TENSOR_MAP_INTERLEAVE_32B = cydriver.CUtensorMapInterleave_enum.CU_TENSOR_MAP_INTERLEAVE_32B

_dict_CUtensorMapInterleave = dict(((int(v), v) for k, v in CUtensorMapInterleave.__members__.items()))

class CUtensorMapSwizzle(IntEnum):
    """
    Tensor map swizzling mode of shared memory banks
    """
    CU_TENSOR_MAP_SWIZZLE_NONE = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_NONE
    CU_TENSOR_MAP_SWIZZLE_32B = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_32B
    CU_TENSOR_MAP_SWIZZLE_64B = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_64B
    CU_TENSOR_MAP_SWIZZLE_128B = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_128B
    CU_TENSOR_MAP_SWIZZLE_128B_ATOM_32B = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_128B_ATOM_32B
    CU_TENSOR_MAP_SWIZZLE_128B_ATOM_32B_FLIP_8B = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_128B_ATOM_32B_FLIP_8B
    CU_TENSOR_MAP_SWIZZLE_128B_ATOM_64B = cydriver.CUtensorMapSwizzle_enum.CU_TENSOR_MAP_SWIZZLE_128B_ATOM_64B

_dict_CUtensorMapSwizzle = dict(((int(v), v) for k, v in CUtensorMapSwizzle.__members__.items()))

class CUtensorMapL2promotion(IntEnum):
    """
    Tensor map L2 promotion type
    """
    CU_TENSOR_MAP_L2_PROMOTION_NONE = cydriver.CUtensorMapL2promotion_enum.CU_TENSOR_MAP_L2_PROMOTION_NONE
    CU_TENSOR_MAP_L2_PROMOTION_L2_64B = cydriver.CUtensorMapL2promotion_enum.CU_TENSOR_MAP_L2_PROMOTION_L2_64B
    CU_TENSOR_MAP_L2_PROMOTION_L2_128B = cydriver.CUtensorMapL2promotion_enum.CU_TENSOR_MAP_L2_PROMOTION_L2_128B
    CU_TENSOR_MAP_L2_PROMOTION_L2_256B = cydriver.CUtensorMapL2promotion_enum.CU_TENSOR_MAP_L2_PROMOTION_L2_256B

_dict_CUtensorMapL2promotion = dict(((int(v), v) for k, v in CUtensorMapL2promotion.__members__.items()))

class CUtensorMapFloatOOBfill(IntEnum):
    """
    Tensor map out-of-bounds fill type
    """
    CU_TENSOR_MAP_FLOAT_OOB_FILL_NONE = cydriver.CUtensorMapFloatOOBfill_enum.CU_TENSOR_MAP_FLOAT_OOB_FILL_NONE
    CU_TENSOR_MAP_FLOAT_OOB_FILL_NAN_REQUEST_ZERO_FMA = cydriver.CUtensorMapFloatOOBfill_enum.CU_TENSOR_MAP_FLOAT_OOB_FILL_NAN_REQUEST_ZERO_FMA

_dict_CUtensorMapFloatOOBfill = dict(((int(v), v) for k, v in CUtensorMapFloatOOBfill.__members__.items()))

class CUtensorMapIm2ColWideMode(IntEnum):
    """
    Tensor map Im2Col wide mode
    """
    CU_TENSOR_MAP_IM2COL_WIDE_MODE_W = cydriver.CUtensorMapIm2ColWideMode_enum.CU_TENSOR_MAP_IM2COL_WIDE_MODE_W
    CU_TENSOR_MAP_IM2COL_WIDE_MODE_W128 = cydriver.CUtensorMapIm2ColWideMode_enum.CU_TENSOR_MAP_IM2COL_WIDE_MODE_W128

_dict_CUtensorMapIm2ColWideMode = dict(((int(v), v) for k, v in CUtensorMapIm2ColWideMode.__members__.items()))

class CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS(IntEnum):
    """
    Access flags that specify the level of access the current context's
    device has on the memory referenced.
    """

    #: No access, meaning the device cannot access this memory at all, thus
    #: must be staged through accessible memory in order to complete
    #: certain operations
    CU_POINTER_ATTRIBUTE_ACCESS_FLAG_NONE = cydriver.CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAG_NONE

    #: Read-only access, meaning writes to this memory are considered
    #: invalid accesses and thus return error in that case.
    CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READ = cydriver.CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READ

    #: Read-write access, the device has full read-write access to the
    #: memory
    CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READWRITE = cydriver.CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READWRITE

_dict_CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS = dict(((int(v), v) for k, v in CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS.__members__.items()))

class CUexternalMemoryHandleType(IntEnum):
    """
    External memory handle types
    """

    #: Handle is an opaque file descriptor
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD

    #: Handle is an opaque shared NT handle
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32 = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32

    #: Handle is an opaque, globally shared handle
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT

    #: Handle is a D3D12 heap object
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP

    #: Handle is a D3D12 committed resource
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE

    #: Handle is a shared NT handle to a D3D11 resource
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE

    #: Handle is a globally shared handle to a D3D11 resource
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT

    #: Handle is an NvSciBuf object
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF

    #: Handle is a dma_buf file descriptor
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_DMABUF_FD = cydriver.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_DMABUF_FD

_dict_CUexternalMemoryHandleType = dict(((int(v), v) for k, v in CUexternalMemoryHandleType.__members__.items()))

class CUexternalSemaphoreHandleType(IntEnum):
    """
    External semaphore handle types
    """

    #: Handle is an opaque file descriptor
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD

    #: Handle is an opaque shared NT handle
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32 = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32

    #: Handle is an opaque, globally shared handle
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT

    #: Handle is a shared NT handle referencing a D3D12 fence object
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE

    #: Handle is a shared NT handle referencing a D3D11 fence object
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE

    #: Opaque handle to NvSciSync Object
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC

    #: Handle is a shared NT handle referencing a D3D11 keyed mutex object
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX

    #: Handle is a globally shared handle referencing a D3D11 keyed mutex
    #: object
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT

    #: Handle is an opaque file descriptor referencing a timeline semaphore
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD

    #: Handle is an opaque shared NT handle referencing a timeline
    #: semaphore
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32 = cydriver.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32

_dict_CUexternalSemaphoreHandleType = dict(((int(v), v) for k, v in CUexternalSemaphoreHandleType.__members__.items()))

class CUmemAllocationHandleType(IntEnum):
    """
    Flags for specifying particular handle types
    """

    #: Does not allow any export mechanism. >
    CU_MEM_HANDLE_TYPE_NONE = cydriver.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_NONE

    #: Allows a file descriptor to be used for exporting. Permitted only on
    #: POSIX systems. (int)
    CU_MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR = cydriver.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR

    #: Allows a Win32 NT handle to be used for exporting. (HANDLE)
    CU_MEM_HANDLE_TYPE_WIN32 = cydriver.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_WIN32

    #: Allows a Win32 KMT handle to be used for exporting. (D3DKMT_HANDLE)
    CU_MEM_HANDLE_TYPE_WIN32_KMT = cydriver.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_WIN32_KMT

    #: Allows a fabric handle to be used for exporting. (CUmemFabricHandle)
    CU_MEM_HANDLE_TYPE_FABRIC = cydriver.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_FABRIC
    CU_MEM_HANDLE_TYPE_MAX = cydriver.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_MAX

_dict_CUmemAllocationHandleType = dict(((int(v), v) for k, v in CUmemAllocationHandleType.__members__.items()))

class CUmemAccess_flags(IntEnum):
    """
    Specifies the memory protection flags for mapping.
    """

    #: Default, make the address range not accessible
    CU_MEM_ACCESS_FLAGS_PROT_NONE = cydriver.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_NONE

    #: Make the address range read accessible
    CU_MEM_ACCESS_FLAGS_PROT_READ = cydriver.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_READ

    #: Make the address range read-write accessible
    CU_MEM_ACCESS_FLAGS_PROT_READWRITE = cydriver.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_READWRITE
    CU_MEM_ACCESS_FLAGS_PROT_MAX = cydriver.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_MAX

_dict_CUmemAccess_flags = dict(((int(v), v) for k, v in CUmemAccess_flags.__members__.items()))

class CUmemLocationType(IntEnum):
    """
    Specifies the type of location
    """
    CU_MEM_LOCATION_TYPE_INVALID = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_INVALID

    #: Location is unspecified. This is used when creating a managed memory
    #: pool to indicate no preferred location for the pool
    CU_MEM_LOCATION_TYPE_NONE = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_NONE

    #: Location is a device location, thus id is a device ordinal
    CU_MEM_LOCATION_TYPE_DEVICE = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_DEVICE

    #: Location is host, id is ignored
    CU_MEM_LOCATION_TYPE_HOST = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_HOST

    #: Location is a host NUMA node, thus id is a host NUMA node id
    CU_MEM_LOCATION_TYPE_HOST_NUMA = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_HOST_NUMA

    #: Location is a host NUMA node of the current thread, id is ignored
    CU_MEM_LOCATION_TYPE_HOST_NUMA_CURRENT = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_HOST_NUMA_CURRENT
    CU_MEM_LOCATION_TYPE_MAX = cydriver.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_MAX

_dict_CUmemLocationType = dict(((int(v), v) for k, v in CUmemLocationType.__members__.items()))

class CUmemAllocationType(IntEnum):
    """
    Defines the allocation types available
    """
    CU_MEM_ALLOCATION_TYPE_INVALID = cydriver.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_INVALID

    #: This allocation type is 'pinned', i.e. cannot migrate from its
    #: current location while the application is actively using it
    CU_MEM_ALLOCATION_TYPE_PINNED = cydriver.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_PINNED

    #: This allocation type is managed memory
    CU_MEM_ALLOCATION_TYPE_MANAGED = cydriver.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_MANAGED
    CU_MEM_ALLOCATION_TYPE_MAX = cydriver.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_MAX

_dict_CUmemAllocationType = dict(((int(v), v) for k, v in CUmemAllocationType.__members__.items()))

class CUmemAllocationGranularity_flags(IntEnum):
    """
    Flag for requesting different optimal and required granularities
    for an allocation.
    """

    #: Minimum required granularity for allocation
    CU_MEM_ALLOC_GRANULARITY_MINIMUM = cydriver.CUmemAllocationGranularity_flags_enum.CU_MEM_ALLOC_GRANULARITY_MINIMUM

    #: Recommended granularity for allocation for best performance
    CU_MEM_ALLOC_GRANULARITY_RECOMMENDED = cydriver.CUmemAllocationGranularity_flags_enum.CU_MEM_ALLOC_GRANULARITY_RECOMMENDED

_dict_CUmemAllocationGranularity_flags = dict(((int(v), v) for k, v in CUmemAllocationGranularity_flags.__members__.items()))

class CUmemRangeHandleType(IntEnum):
    """
    Specifies the handle type for address range
    """
    CU_MEM_RANGE_HANDLE_TYPE_DMA_BUF_FD = cydriver.CUmemRangeHandleType_enum.CU_MEM_RANGE_HANDLE_TYPE_DMA_BUF_FD
    CU_MEM_RANGE_HANDLE_TYPE_MAX = cydriver.CUmemRangeHandleType_enum.CU_MEM_RANGE_HANDLE_TYPE_MAX

_dict_CUmemRangeHandleType = dict(((int(v), v) for k, v in CUmemRangeHandleType.__members__.items()))

class CUmemRangeFlags(IntEnum):
    """
    Flag for requesting handle type for address range.
    """

    #: Indicates that DMA_BUF handle should be mapped via PCIe BAR1
    CU_MEM_RANGE_FLAG_DMA_BUF_MAPPING_TYPE_PCIE = cydriver.CUmemRangeFlags_enum.CU_MEM_RANGE_FLAG_DMA_BUF_MAPPING_TYPE_PCIE

_dict_CUmemRangeFlags = dict(((int(v), v) for k, v in CUmemRangeFlags.__members__.items()))

class CUarraySparseSubresourceType(IntEnum):
    """
    Sparse subresource types
    """
    CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL = cydriver.CUarraySparseSubresourceType_enum.CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL
    CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL = cydriver.CUarraySparseSubresourceType_enum.CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL

_dict_CUarraySparseSubresourceType = dict(((int(v), v) for k, v in CUarraySparseSubresourceType.__members__.items()))

class CUmemOperationType(IntEnum):
    """
    Memory operation types
    """
    CU_MEM_OPERATION_TYPE_MAP = cydriver.CUmemOperationType_enum.CU_MEM_OPERATION_TYPE_MAP
    CU_MEM_OPERATION_TYPE_UNMAP = cydriver.CUmemOperationType_enum.CU_MEM_OPERATION_TYPE_UNMAP

_dict_CUmemOperationType = dict(((int(v), v) for k, v in CUmemOperationType.__members__.items()))

class CUmemHandleType(IntEnum):
    """
    Memory handle types
    """
    CU_MEM_HANDLE_TYPE_GENERIC = cydriver.CUmemHandleType_enum.CU_MEM_HANDLE_TYPE_GENERIC

_dict_CUmemHandleType = dict(((int(v), v) for k, v in CUmemHandleType.__members__.items()))

class CUmemAllocationCompType(IntEnum):
    """
    Specifies compression attribute for an allocation.
    """

    #: Allocating non-compressible memory
    CU_MEM_ALLOCATION_COMP_NONE = cydriver.CUmemAllocationCompType_enum.CU_MEM_ALLOCATION_COMP_NONE

    #: Allocating compressible memory
    CU_MEM_ALLOCATION_COMP_GENERIC = cydriver.CUmemAllocationCompType_enum.CU_MEM_ALLOCATION_COMP_GENERIC

_dict_CUmemAllocationCompType = dict(((int(v), v) for k, v in CUmemAllocationCompType.__members__.items()))

class CUmulticastGranularity_flags(IntEnum):
    """
    Flags for querying different granularities for a multicast object
    """

    #: Minimum required granularity
    CU_MULTICAST_GRANULARITY_MINIMUM = cydriver.CUmulticastGranularity_flags_enum.CU_MULTICAST_GRANULARITY_MINIMUM

    #: Recommended granularity for best performance
    CU_MULTICAST_GRANULARITY_RECOMMENDED = cydriver.CUmulticastGranularity_flags_enum.CU_MULTICAST_GRANULARITY_RECOMMENDED

_dict_CUmulticastGranularity_flags = dict(((int(v), v) for k, v in CUmulticastGranularity_flags.__members__.items()))

class CUgraphExecUpdateResult(IntEnum):
    """
    CUDA Graph Update error types
    """

    #: The update succeeded
    CU_GRAPH_EXEC_UPDATE_SUCCESS = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_SUCCESS

    #: The update failed for an unexpected reason which is described in the
    #: return value of the function
    CU_GRAPH_EXEC_UPDATE_ERROR = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR

    #: The update failed because the topology changed
    CU_GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED

    #: The update failed because a node type changed
    CU_GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED

    #: The update failed because the function of a kernel node changed
    #: (CUDA driver < 11.2)
    CU_GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED

    #: The update failed because the parameters changed in a way that is
    #: not supported
    CU_GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED

    #: The update failed because something about the node is not supported
    CU_GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED

    #: The update failed because the function of a kernel node changed in
    #: an unsupported way
    CU_GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE

    #: The update failed because the node attributes changed in a way that
    #: is not supported
    CU_GRAPH_EXEC_UPDATE_ERROR_ATTRIBUTES_CHANGED = cydriver.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_ATTRIBUTES_CHANGED

_dict_CUgraphExecUpdateResult = dict(((int(v), v) for k, v in CUgraphExecUpdateResult.__members__.items()))

class CUmemPool_attribute(IntEnum):
    """
    CUDA memory pool attributes
    """

    #: (value type = int) Allow cuMemAllocAsync to use memory
    #: asynchronously freed in another streams as long as a stream ordering
    #: dependency of the allocating stream on the free action exists. Cuda
    #: events and null stream interactions can create the required stream
    #: ordered dependencies. (default enabled)
    CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES

    #: (value type = int) Allow reuse of already completed frees when there
    #: is no dependency between the free and allocation. (default enabled)
    CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC

    #: (value type = int) Allow cuMemAllocAsync to insert new stream
    #: dependencies in order to establish the stream ordering required to
    #: reuse a piece of memory released by cuFreeAsync (default enabled).
    CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES

    #: (value type = cuuint64_t) Amount of reserved memory in bytes to hold
    #: onto before trying to release memory back to the OS. When more than
    #: the release threshold bytes of memory are held by the memory pool,
    #: the allocator will try to release memory back to the OS on the next
    #: call to stream, event or context synchronize. (default 0)
    CU_MEMPOOL_ATTR_RELEASE_THRESHOLD = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_RELEASE_THRESHOLD

    #: (value type = cuuint64_t) Amount of backing memory currently
    #: allocated for the mempool.
    CU_MEMPOOL_ATTR_RESERVED_MEM_CURRENT = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_RESERVED_MEM_CURRENT

    #: (value type = cuuint64_t) High watermark of backing memory allocated
    #: for the mempool since the last time it was reset. High watermark can
    #: only be reset to zero.
    CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH

    #: (value type = cuuint64_t) Amount of memory from the pool that is
    #: currently in use by the application.
    CU_MEMPOOL_ATTR_USED_MEM_CURRENT = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_USED_MEM_CURRENT

    #: (value type = cuuint64_t) High watermark of the amount of memory
    #: from the pool that was in use by the application since the last time
    #: it was reset. High watermark can only be reset to zero.
    CU_MEMPOOL_ATTR_USED_MEM_HIGH = cydriver.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_USED_MEM_HIGH

_dict_CUmemPool_attribute = dict(((int(v), v) for k, v in CUmemPool_attribute.__members__.items()))

class CUmemcpyFlags(IntEnum):
    """
    Flags to specify for copies within a batch. For more details see
    :py:obj:`~.cuMemcpyBatchAsync`.
    """
    CU_MEMCPY_FLAG_DEFAULT = cydriver.CUmemcpyFlags_enum.CU_MEMCPY_FLAG_DEFAULT

    #: Hint to the driver to try and overlap the copy with compute work on
    #: the SMs.
    CU_MEMCPY_FLAG_PREFER_OVERLAP_WITH_COMPUTE = cydriver.CUmemcpyFlags_enum.CU_MEMCPY_FLAG_PREFER_OVERLAP_WITH_COMPUTE

_dict_CUmemcpyFlags = dict(((int(v), v) for k, v in CUmemcpyFlags.__members__.items()))

class CUmemcpySrcAccessOrder(IntEnum):
    """
    These flags allow applications to convey the source access ordering
    CUDA must maintain. The destination will always be accessed in
    stream order.
    """

    #: Default invalid.
    CU_MEMCPY_SRC_ACCESS_ORDER_INVALID = cydriver.CUmemcpySrcAccessOrder_enum.CU_MEMCPY_SRC_ACCESS_ORDER_INVALID

    #: Indicates that access to the source pointer must be in stream order.
    CU_MEMCPY_SRC_ACCESS_ORDER_STREAM = cydriver.CUmemcpySrcAccessOrder_enum.CU_MEMCPY_SRC_ACCESS_ORDER_STREAM

    #: Indicates that access to the source pointer can be out of stream
    #: order and all accesses must be complete before the API call returns.
    #: This flag is suited for ephemeral sources (ex., stack variables)
    #: when it's known that no prior operations in the stream can be
    #: accessing the memory and also that the lifetime of the memory is
    #: limited to the scope that the source variable was declared in.
    #: Specifying this flag allows the driver to optimize the copy and
    #: removes the need for the user to synchronize the stream after the
    #: API call.
    CU_MEMCPY_SRC_ACCESS_ORDER_DURING_API_CALL = cydriver.CUmemcpySrcAccessOrder_enum.CU_MEMCPY_SRC_ACCESS_ORDER_DURING_API_CALL

    #: Indicates that access to the source pointer can be out of stream
    #: order and the accesses can happen even after the API call returns.
    #: This flag is suited for host pointers allocated outside CUDA (ex.,
    #: via malloc) when it's known that no prior operations in the stream
    #: can be accessing the memory. Specifying this flag allows the driver
    #: to optimize the copy on certain platforms.
    CU_MEMCPY_SRC_ACCESS_ORDER_ANY = cydriver.CUmemcpySrcAccessOrder_enum.CU_MEMCPY_SRC_ACCESS_ORDER_ANY
    CU_MEMCPY_SRC_ACCESS_ORDER_MAX = cydriver.CUmemcpySrcAccessOrder_enum.CU_MEMCPY_SRC_ACCESS_ORDER_MAX

_dict_CUmemcpySrcAccessOrder = dict(((int(v), v) for k, v in CUmemcpySrcAccessOrder.__members__.items()))

class CUmemcpy3DOperandType(IntEnum):
    """
    These flags allow applications to convey the operand type for
    individual copies specified in :py:obj:`~.cuMemcpy3DBatchAsync`.
    """

    #: Memcpy operand is a valid pointer.
    CU_MEMCPY_OPERAND_TYPE_POINTER = cydriver.CUmemcpy3DOperandType_enum.CU_MEMCPY_OPERAND_TYPE_POINTER

    #: Memcpy operand is a CUarray.
    CU_MEMCPY_OPERAND_TYPE_ARRAY = cydriver.CUmemcpy3DOperandType_enum.CU_MEMCPY_OPERAND_TYPE_ARRAY
    CU_MEMCPY_OPERAND_TYPE_MAX = cydriver.CUmemcpy3DOperandType_enum.CU_MEMCPY_OPERAND_TYPE_MAX

_dict_CUmemcpy3DOperandType = dict(((int(v), v) for k, v in CUmemcpy3DOperandType.__members__.items()))

class CUgraphMem_attribute(IntEnum):
    """

    """

    #: (value type = cuuint64_t) Amount of memory, in bytes, currently
    #: associated with graphs
    CU_GRAPH_MEM_ATTR_USED_MEM_CURRENT = cydriver.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_USED_MEM_CURRENT

    #: (value type = cuuint64_t) High watermark of memory, in bytes,
    #: associated with graphs since the last time it was reset. High
    #: watermark can only be reset to zero.
    CU_GRAPH_MEM_ATTR_USED_MEM_HIGH = cydriver.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_USED_MEM_HIGH

    #: (value type = cuuint64_t) Amount of memory, in bytes, currently
    #: allocated for use by the CUDA graphs asynchronous allocator.
    CU_GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT = cydriver.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT

    #: (value type = cuuint64_t) High watermark of memory, in bytes,
    #: currently allocated for use by the CUDA graphs asynchronous
    #: allocator.
    CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH = cydriver.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH

_dict_CUgraphMem_attribute = dict(((int(v), v) for k, v in CUgraphMem_attribute.__members__.items()))

class CUgraphChildGraphNodeOwnership(IntEnum):
    """
    Child graph node ownership
    """

    #: Default behavior for a child graph node. Child graph is cloned into
    #: the parent and memory allocation/free nodes can't be present in the
    #: child graph.
    CU_GRAPH_CHILD_GRAPH_OWNERSHIP_CLONE = cydriver.CUgraphChildGraphNodeOwnership_enum.CU_GRAPH_CHILD_GRAPH_OWNERSHIP_CLONE

    #: The child graph is moved to the parent. The handle to the child
    #: graph is owned by the parent and will be destroyed when the parent
    #: is destroyed.
    #:
    #: The following restrictions apply to child graphs after they have
    #: been moved: Cannot be independently instantiated or destroyed;
    #: Cannot be added as a child graph of a separate parent graph; Cannot
    #: be used as an argument to cuGraphExecUpdate; Cannot have additional
    #: memory allocation or free nodes added.
    CU_GRAPH_CHILD_GRAPH_OWNERSHIP_MOVE = cydriver.CUgraphChildGraphNodeOwnership_enum.CU_GRAPH_CHILD_GRAPH_OWNERSHIP_MOVE

_dict_CUgraphChildGraphNodeOwnership = dict(((int(v), v) for k, v in CUgraphChildGraphNodeOwnership.__members__.items()))

class CUflushGPUDirectRDMAWritesOptions(IntEnum):
    """
    Bitmasks for
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS`
    """

    #: :py:obj:`~.cuFlushGPUDirectRDMAWrites()` and its CUDA Runtime API
    #: counterpart are supported on the device.
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_HOST = cydriver.CUflushGPUDirectRDMAWritesOptions_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_HOST

    #: The :py:obj:`~.CU_STREAM_WAIT_VALUE_FLUSH` flag and the
    #: :py:obj:`~.CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES` MemOp are supported
    #: on the device.
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_MEMOPS = cydriver.CUflushGPUDirectRDMAWritesOptions_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_MEMOPS

_dict_CUflushGPUDirectRDMAWritesOptions = dict(((int(v), v) for k, v in CUflushGPUDirectRDMAWritesOptions.__members__.items()))

class CUGPUDirectRDMAWritesOrdering(IntEnum):
    """
    Platform native ordering for GPUDirect RDMA writes
    """

    #: The device does not natively support ordering of remote writes.
    #: :py:obj:`~.cuFlushGPUDirectRDMAWrites()` can be leveraged if
    #: supported.
    CU_GPU_DIRECT_RDMA_WRITES_ORDERING_NONE = cydriver.CUGPUDirectRDMAWritesOrdering_enum.CU_GPU_DIRECT_RDMA_WRITES_ORDERING_NONE

    #: Natively, the device can consistently consume remote writes,
    #: although other CUDA devices may not.
    CU_GPU_DIRECT_RDMA_WRITES_ORDERING_OWNER = cydriver.CUGPUDirectRDMAWritesOrdering_enum.CU_GPU_DIRECT_RDMA_WRITES_ORDERING_OWNER

    #: Any CUDA device in the system can consistently consume remote writes
    #: to this device.
    CU_GPU_DIRECT_RDMA_WRITES_ORDERING_ALL_DEVICES = cydriver.CUGPUDirectRDMAWritesOrdering_enum.CU_GPU_DIRECT_RDMA_WRITES_ORDERING_ALL_DEVICES

_dict_CUGPUDirectRDMAWritesOrdering = dict(((int(v), v) for k, v in CUGPUDirectRDMAWritesOrdering.__members__.items()))

class CUflushGPUDirectRDMAWritesScope(IntEnum):
    """
    The scopes for :py:obj:`~.cuFlushGPUDirectRDMAWrites`
    """

    #: Blocks until remote writes are visible to the CUDA device context
    #: owning the data.
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_OWNER = cydriver.CUflushGPUDirectRDMAWritesScope_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_OWNER

    #: Blocks until remote writes are visible to all CUDA device contexts.
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_ALL_DEVICES = cydriver.CUflushGPUDirectRDMAWritesScope_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_ALL_DEVICES

_dict_CUflushGPUDirectRDMAWritesScope = dict(((int(v), v) for k, v in CUflushGPUDirectRDMAWritesScope.__members__.items()))

class CUflushGPUDirectRDMAWritesTarget(IntEnum):
    """
    The targets for :py:obj:`~.cuFlushGPUDirectRDMAWrites`
    """

    #: Sets the target for :py:obj:`~.cuFlushGPUDirectRDMAWrites()` to the
    #: currently active CUDA device context.
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TARGET_CURRENT_CTX = cydriver.CUflushGPUDirectRDMAWritesTarget_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TARGET_CURRENT_CTX

_dict_CUflushGPUDirectRDMAWritesTarget = dict(((int(v), v) for k, v in CUflushGPUDirectRDMAWritesTarget.__members__.items()))

class CUgraphDebugDot_flags(IntEnum):
    """
    The additional write options for :py:obj:`~.cuGraphDebugDotPrint`
    """

    #: Output all debug data as if every debug flag is enabled
    CU_GRAPH_DEBUG_DOT_FLAGS_VERBOSE = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_VERBOSE

    #: Use CUDA Runtime structures for output
    CU_GRAPH_DEBUG_DOT_FLAGS_RUNTIME_TYPES = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_RUNTIME_TYPES

    #: Adds CUDA_KERNEL_NODE_PARAMS values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_PARAMS

    #: Adds CUDA_MEMCPY3D values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_MEMCPY_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEMCPY_NODE_PARAMS

    #: Adds CUDA_MEMSET_NODE_PARAMS values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_MEMSET_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEMSET_NODE_PARAMS

    #: Adds CUDA_HOST_NODE_PARAMS values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_HOST_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_HOST_NODE_PARAMS

    #: Adds CUevent handle from record and wait nodes to output
    CU_GRAPH_DEBUG_DOT_FLAGS_EVENT_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EVENT_NODE_PARAMS

    #: Adds CUDA_EXT_SEM_SIGNAL_NODE_PARAMS values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_SIGNAL_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_SIGNAL_NODE_PARAMS

    #: Adds CUDA_EXT_SEM_WAIT_NODE_PARAMS values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_WAIT_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_WAIT_NODE_PARAMS

    #: Adds CUkernelNodeAttrValue values to output
    CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_ATTRIBUTES = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_ATTRIBUTES

    #: Adds node handles and every kernel function handle to output
    CU_GRAPH_DEBUG_DOT_FLAGS_HANDLES = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_HANDLES

    #: Adds memory alloc node parameters to output
    CU_GRAPH_DEBUG_DOT_FLAGS_MEM_ALLOC_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEM_ALLOC_NODE_PARAMS

    #: Adds memory free node parameters to output
    CU_GRAPH_DEBUG_DOT_FLAGS_MEM_FREE_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEM_FREE_NODE_PARAMS

    #: Adds batch mem op node parameters to output
    CU_GRAPH_DEBUG_DOT_FLAGS_BATCH_MEM_OP_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_BATCH_MEM_OP_NODE_PARAMS

    #: Adds edge numbering information
    CU_GRAPH_DEBUG_DOT_FLAGS_EXTRA_TOPO_INFO = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EXTRA_TOPO_INFO

    #: Adds conditional node parameters to output
    CU_GRAPH_DEBUG_DOT_FLAGS_CONDITIONAL_NODE_PARAMS = cydriver.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_CONDITIONAL_NODE_PARAMS

_dict_CUgraphDebugDot_flags = dict(((int(v), v) for k, v in CUgraphDebugDot_flags.__members__.items()))

class CUuserObject_flags(IntEnum):
    """
    Flags for user objects for graphs
    """

    #: Indicates the destructor execution is not synchronized by any CUDA
    #: handle.
    CU_USER_OBJECT_NO_DESTRUCTOR_SYNC = cydriver.CUuserObject_flags_enum.CU_USER_OBJECT_NO_DESTRUCTOR_SYNC

_dict_CUuserObject_flags = dict(((int(v), v) for k, v in CUuserObject_flags.__members__.items()))

class CUuserObjectRetain_flags(IntEnum):
    """
    Flags for retaining user object references for graphs
    """

    #: Transfer references from the caller rather than creating new
    #: references.
    CU_GRAPH_USER_OBJECT_MOVE = cydriver.CUuserObjectRetain_flags_enum.CU_GRAPH_USER_OBJECT_MOVE

_dict_CUuserObjectRetain_flags = dict(((int(v), v) for k, v in CUuserObjectRetain_flags.__members__.items()))

class CUgraphInstantiate_flags(IntEnum):
    """
    Flags for instantiating a graph
    """

    #: Automatically free memory allocated in a graph before relaunching.
    CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH = cydriver.CUgraphInstantiate_flags_enum.CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH

    #: Automatically upload the graph after instantiation. Only supported
    #: by :py:obj:`~.cuGraphInstantiateWithParams`. The upload will be
    #: performed using the stream provided in `instantiateParams`.
    CUDA_GRAPH_INSTANTIATE_FLAG_UPLOAD = cydriver.CUgraphInstantiate_flags_enum.CUDA_GRAPH_INSTANTIATE_FLAG_UPLOAD

    #: Instantiate the graph to be launchable from the device. This flag
    #: can only be used on platforms which support unified addressing. This
    #: flag cannot be used in conjunction with
    #: CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH.
    CUDA_GRAPH_INSTANTIATE_FLAG_DEVICE_LAUNCH = cydriver.CUgraphInstantiate_flags_enum.CUDA_GRAPH_INSTANTIATE_FLAG_DEVICE_LAUNCH

    #: Run the graph using the per-node priority attributes rather than the
    #: priority of the stream it is launched into.
    CUDA_GRAPH_INSTANTIATE_FLAG_USE_NODE_PRIORITY = cydriver.CUgraphInstantiate_flags_enum.CUDA_GRAPH_INSTANTIATE_FLAG_USE_NODE_PRIORITY

_dict_CUgraphInstantiate_flags = dict(((int(v), v) for k, v in CUgraphInstantiate_flags.__members__.items()))

class CUdeviceNumaConfig(IntEnum):
    """
    CUDA device NUMA configuration
    """

    #: The GPU is not a NUMA node
    CU_DEVICE_NUMA_CONFIG_NONE = cydriver.CUdeviceNumaConfig_enum.CU_DEVICE_NUMA_CONFIG_NONE

    #: The GPU is a NUMA node, CU_DEVICE_ATTRIBUTE_NUMA_ID contains its
    #: NUMA ID
    CU_DEVICE_NUMA_CONFIG_NUMA_NODE = cydriver.CUdeviceNumaConfig_enum.CU_DEVICE_NUMA_CONFIG_NUMA_NODE

_dict_CUdeviceNumaConfig = dict(((int(v), v) for k, v in CUdeviceNumaConfig.__members__.items()))

class CUprocessState(IntEnum):
    """
    CUDA Process States
    """

    #: Default process state
    CU_PROCESS_STATE_RUNNING = cydriver.CUprocessState_enum.CU_PROCESS_STATE_RUNNING

    #: CUDA API locks are taken so further CUDA API calls will block
    CU_PROCESS_STATE_LOCKED = cydriver.CUprocessState_enum.CU_PROCESS_STATE_LOCKED

    #: Application memory contents have been checkpointed and underlying
    #: allocations and device handles have been released
    CU_PROCESS_STATE_CHECKPOINTED = cydriver.CUprocessState_enum.CU_PROCESS_STATE_CHECKPOINTED

    #: Application entered an uncorrectable error during the
    #: checkpoint/restore process
    CU_PROCESS_STATE_FAILED = cydriver.CUprocessState_enum.CU_PROCESS_STATE_FAILED

_dict_CUprocessState = dict(((int(v), v) for k, v in CUprocessState.__members__.items()))

class CUmoduleLoadingMode(IntEnum):
    """
    CUDA Lazy Loading status
    """

    #: Lazy Kernel Loading is not enabled
    CU_MODULE_EAGER_LOADING = cydriver.CUmoduleLoadingMode_enum.CU_MODULE_EAGER_LOADING

    #: Lazy Kernel Loading is enabled
    CU_MODULE_LAZY_LOADING = cydriver.CUmoduleLoadingMode_enum.CU_MODULE_LAZY_LOADING

_dict_CUmoduleLoadingMode = dict(((int(v), v) for k, v in CUmoduleLoadingMode.__members__.items()))

class CUmemDecompressAlgorithm(IntEnum):
    """
    Bitmasks for CU_DEVICE_ATTRIBUTE_MEM_DECOMPRESS_ALGORITHM_MASK.
    """

    #: Decompression is unsupported.
    CU_MEM_DECOMPRESS_UNSUPPORTED = cydriver.CUmemDecompressAlgorithm_enum.CU_MEM_DECOMPRESS_UNSUPPORTED

    #: Deflate is supported.
    CU_MEM_DECOMPRESS_ALGORITHM_DEFLATE = cydriver.CUmemDecompressAlgorithm_enum.CU_MEM_DECOMPRESS_ALGORITHM_DEFLATE

    #: Snappy is supported.
    CU_MEM_DECOMPRESS_ALGORITHM_SNAPPY = cydriver.CUmemDecompressAlgorithm_enum.CU_MEM_DECOMPRESS_ALGORITHM_SNAPPY

    #: LZ4 is supported.
    CU_MEM_DECOMPRESS_ALGORITHM_LZ4 = cydriver.CUmemDecompressAlgorithm_enum.CU_MEM_DECOMPRESS_ALGORITHM_LZ4

_dict_CUmemDecompressAlgorithm = dict(((int(v), v) for k, v in CUmemDecompressAlgorithm.__members__.items()))

class CUfunctionLoadingState(IntEnum):
    """

    """
    CU_FUNCTION_LOADING_STATE_UNLOADED = cydriver.CUfunctionLoadingState_enum.CU_FUNCTION_LOADING_STATE_UNLOADED
    CU_FUNCTION_LOADING_STATE_LOADED = cydriver.CUfunctionLoadingState_enum.CU_FUNCTION_LOADING_STATE_LOADED
    CU_FUNCTION_LOADING_STATE_MAX = cydriver.CUfunctionLoadingState_enum.CU_FUNCTION_LOADING_STATE_MAX

_dict_CUfunctionLoadingState = dict(((int(v), v) for k, v in CUfunctionLoadingState.__members__.items()))

class CUcoredumpSettings(IntEnum):
    """
    Flags for choosing a coredump attribute to get/set
    """
    CU_COREDUMP_ENABLE_ON_EXCEPTION = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_ENABLE_ON_EXCEPTION
    CU_COREDUMP_TRIGGER_HOST = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_TRIGGER_HOST
    CU_COREDUMP_LIGHTWEIGHT = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_LIGHTWEIGHT
    CU_COREDUMP_ENABLE_USER_TRIGGER = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_ENABLE_USER_TRIGGER
    CU_COREDUMP_FILE = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_FILE
    CU_COREDUMP_PIPE = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_PIPE
    CU_COREDUMP_GENERATION_FLAGS = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_GENERATION_FLAGS
    CU_COREDUMP_MAX = cydriver.CUcoredumpSettings_enum.CU_COREDUMP_MAX

_dict_CUcoredumpSettings = dict(((int(v), v) for k, v in CUcoredumpSettings.__members__.items()))

class CUCoredumpGenerationFlags(IntEnum):
    """
    Flags for controlling coredump contents
    """
    CU_COREDUMP_DEFAULT_FLAGS = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_DEFAULT_FLAGS
    CU_COREDUMP_SKIP_NONRELOCATED_ELF_IMAGES = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_SKIP_NONRELOCATED_ELF_IMAGES
    CU_COREDUMP_SKIP_GLOBAL_MEMORY = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_SKIP_GLOBAL_MEMORY
    CU_COREDUMP_SKIP_SHARED_MEMORY = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_SKIP_SHARED_MEMORY
    CU_COREDUMP_SKIP_LOCAL_MEMORY = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_SKIP_LOCAL_MEMORY
    CU_COREDUMP_SKIP_ABORT = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_SKIP_ABORT
    CU_COREDUMP_SKIP_CONSTBANK_MEMORY = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_SKIP_CONSTBANK_MEMORY
    CU_COREDUMP_LIGHTWEIGHT_FLAGS = cydriver.CUCoredumpGenerationFlags.CU_COREDUMP_LIGHTWEIGHT_FLAGS

_dict_CUCoredumpGenerationFlags = dict(((int(v), v) for k, v in CUCoredumpGenerationFlags.__members__.items()))

class CUgreenCtxCreate_flags(IntEnum):
    """

    """

    #: Required. Creates a default stream to use inside the green context
    CU_GREEN_CTX_DEFAULT_STREAM = cydriver.CUgreenCtxCreate_flags.CU_GREEN_CTX_DEFAULT_STREAM

_dict_CUgreenCtxCreate_flags = dict(((int(v), v) for k, v in CUgreenCtxCreate_flags.__members__.items()))

class CUdevSmResourceSplit_flags(IntEnum):
    """

    """
    CU_DEV_SM_RESOURCE_SPLIT_IGNORE_SM_COSCHEDULING = cydriver.CUdevSmResourceSplit_flags.CU_DEV_SM_RESOURCE_SPLIT_IGNORE_SM_COSCHEDULING
    CU_DEV_SM_RESOURCE_SPLIT_MAX_POTENTIAL_CLUSTER_SIZE = cydriver.CUdevSmResourceSplit_flags.CU_DEV_SM_RESOURCE_SPLIT_MAX_POTENTIAL_CLUSTER_SIZE

_dict_CUdevSmResourceSplit_flags = dict(((int(v), v) for k, v in CUdevSmResourceSplit_flags.__members__.items()))

class CUdevResourceType(IntEnum):
    """
    Type of resource
    """
    CU_DEV_RESOURCE_TYPE_INVALID = cydriver.CUdevResourceType.CU_DEV_RESOURCE_TYPE_INVALID

    #: Streaming multiprocessors related information
    CU_DEV_RESOURCE_TYPE_SM = cydriver.CUdevResourceType.CU_DEV_RESOURCE_TYPE_SM

_dict_CUdevResourceType = dict(((int(v), v) for k, v in CUdevResourceType.__members__.items()))

class CUlogLevel(IntEnum):
    """

    """
    CU_LOG_LEVEL_ERROR = cydriver.CUlogLevel_enum.CU_LOG_LEVEL_ERROR
    CU_LOG_LEVEL_WARNING = cydriver.CUlogLevel_enum.CU_LOG_LEVEL_WARNING

_dict_CUlogLevel = dict(((int(v), v) for k, v in CUlogLevel.__members__.items()))

class CUoutput_mode(IntEnum):
    """
    Profiler Output Modes
    """

    #: Output mode Key-Value pair format.
    CU_OUT_KEY_VALUE_PAIR = cydriver.CUoutput_mode_enum.CU_OUT_KEY_VALUE_PAIR

    #: Output mode Comma separated values format.
    CU_OUT_CSV = cydriver.CUoutput_mode_enum.CU_OUT_CSV

_dict_CUoutput_mode = dict(((int(v), v) for k, v in CUoutput_mode.__members__.items()))

class CUeglFrameType(IntEnum):
    """
    CUDA EglFrame type - array or pointer
    """

    #: Frame type CUDA array
    CU_EGL_FRAME_TYPE_ARRAY = cydriver.CUeglFrameType_enum.CU_EGL_FRAME_TYPE_ARRAY

    #: Frame type pointer
    CU_EGL_FRAME_TYPE_PITCH = cydriver.CUeglFrameType_enum.CU_EGL_FRAME_TYPE_PITCH

_dict_CUeglFrameType = dict(((int(v), v) for k, v in CUeglFrameType.__members__.items()))

class CUeglResourceLocationFlags(IntEnum):
    """
    Resource location flags- sysmem or vidmem  For CUDA context on
    iGPU, since video and system memory are equivalent - these flags
    will not have an effect on the execution.  For CUDA context on
    dGPU, applications can use the flag
    :py:obj:`~.CUeglResourceLocationFlags` to give a hint about the
    desired location.  :py:obj:`~.CU_EGL_RESOURCE_LOCATION_SYSMEM` -
    the frame data is made resident on the system memory to be accessed
    by CUDA.  :py:obj:`~.CU_EGL_RESOURCE_LOCATION_VIDMEM` - the frame
    data is made resident on the dedicated video memory to be accessed
    by CUDA.  There may be an additional latency due to new allocation
    and data migration, if the frame is produced on a different memory.
    """

    #: Resource location sysmem
    CU_EGL_RESOURCE_LOCATION_SYSMEM = cydriver.CUeglResourceLocationFlags_enum.CU_EGL_RESOURCE_LOCATION_SYSMEM

    #: Resource location vidmem
    CU_EGL_RESOURCE_LOCATION_VIDMEM = cydriver.CUeglResourceLocationFlags_enum.CU_EGL_RESOURCE_LOCATION_VIDMEM

_dict_CUeglResourceLocationFlags = dict(((int(v), v) for k, v in CUeglResourceLocationFlags.__members__.items()))

class CUeglColorFormat(IntEnum):
    """
    CUDA EGL Color Format - The different planar and multiplanar
    formats currently supported for CUDA_EGL interops. Three channel
    formats are currently not supported for
    :py:obj:`~.CU_EGL_FRAME_TYPE_ARRAY`
    """

    #: Y, U, V in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR

    #: Y, UV in two surfaces (UV as one surface) with VU byte ordering,
    #: width, height ratio same as YUV420Planar.
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR

    #: Y, U, V each in a separate surface, U/V width = 1/2 Y width, U/V
    #: height = Y height.
    CU_EGL_COLOR_FORMAT_YUV422_PLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_PLANAR

    #: Y, UV in two surfaces with VU byte ordering, width, height ratio
    #: same as YUV422Planar.
    CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR

    #: R/G/B three channels in one surface with BGR byte ordering. Only
    #: pitch linear format supported.
    CU_EGL_COLOR_FORMAT_RGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_RGB

    #: R/G/B three channels in one surface with RGB byte ordering. Only
    #: pitch linear format supported.
    CU_EGL_COLOR_FORMAT_BGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BGR

    #: R/G/B/A four channels in one surface with BGRA byte ordering.
    CU_EGL_COLOR_FORMAT_ARGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_ARGB

    #: R/G/B/A four channels in one surface with ABGR byte ordering.
    CU_EGL_COLOR_FORMAT_RGBA = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_RGBA

    #: single luminance channel in one surface.
    CU_EGL_COLOR_FORMAT_L = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_L

    #: single color channel in one surface.
    CU_EGL_COLOR_FORMAT_R = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_R

    #: Y, U, V in three surfaces, each in a separate surface, U/V width = Y
    #: width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YUV444_PLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_PLANAR

    #: Y, UV in two surfaces (UV as one surface) with VU byte ordering,
    #: width, height ratio same as YUV444Planar.
    CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR

    #: Y, U, V in one surface, interleaved as UYVY in one channel.
    CU_EGL_COLOR_FORMAT_YUYV_422 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUYV_422

    #: Y, U, V in one surface, interleaved as YUYV in one channel.
    CU_EGL_COLOR_FORMAT_UYVY_422 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_422

    #: R/G/B/A four channels in one surface with RGBA byte ordering.
    CU_EGL_COLOR_FORMAT_ABGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_ABGR

    #: R/G/B/A four channels in one surface with ARGB byte ordering.
    CU_EGL_COLOR_FORMAT_BGRA = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BGRA

    #: Alpha color format - one channel in one surface.
    CU_EGL_COLOR_FORMAT_A = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_A

    #: R/G color format - two channels in one surface with GR byte ordering
    CU_EGL_COLOR_FORMAT_RG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_RG

    #: Y, U, V, A four channels in one surface, interleaved as VUYA.
    CU_EGL_COLOR_FORMAT_AYUV = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_AYUV

    #: Y, VU in two surfaces (VU as one surface) with UV byte ordering, U/V
    #: width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR

    #: Y, VU in two surfaces (VU as one surface) with UV byte ordering, U/V
    #: width = 1/2 Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR

    #: Y, VU in two surfaces (VU as one surface) with UV byte ordering, U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR

    #: Y10, V10U10 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR

    #: Y10, V10U10 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR

    #: Y12, V12U12 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR

    #: Y12, V12U12 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR

    #: Extended Range Y, U, V in one surface, interleaved as YVYU in one
    #: channel.
    CU_EGL_COLOR_FORMAT_VYUY_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_VYUY_ER

    #: Extended Range Y, U, V in one surface, interleaved as YUYV in one
    #: channel.
    CU_EGL_COLOR_FORMAT_UYVY_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_ER

    #: Extended Range Y, U, V in one surface, interleaved as UYVY in one
    #: channel.
    CU_EGL_COLOR_FORMAT_YUYV_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUYV_ER

    #: Extended Range Y, U, V in one surface, interleaved as VYUY in one
    #: channel.
    CU_EGL_COLOR_FORMAT_YVYU_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVYU_ER

    #: Extended Range Y, U, V three channels in one surface, interleaved as
    #: VUY. Only pitch linear format supported.
    CU_EGL_COLOR_FORMAT_YUV_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV_ER

    #: Extended Range Y, U, V, A four channels in one surface, interleaved
    #: as AVUY.
    CU_EGL_COLOR_FORMAT_YUVA_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUVA_ER

    #: Extended Range Y, U, V, A four channels in one surface, interleaved
    #: as VUYA.
    CU_EGL_COLOR_FORMAT_AYUV_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_AYUV_ER

    #: Extended Range Y, U, V in three surfaces, U/V width = Y width, U/V
    #: height = Y height.
    CU_EGL_COLOR_FORMAT_YUV444_PLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_PLANAR_ER

    #: Extended Range Y, U, V in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YUV422_PLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_PLANAR_ER

    #: Extended Range Y, U, V in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR_ER

    #: Extended Range Y, UV in two surfaces (UV as one surface) with VU
    #: byte ordering, U/V width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR_ER

    #: Extended Range Y, UV in two surfaces (UV as one surface) with VU
    #: byte ordering, U/V width = 1/2 Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR_ER

    #: Extended Range Y, UV in two surfaces (UV as one surface) with VU
    #: byte ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_ER

    #: Extended Range Y, V, U in three surfaces, U/V width = Y width, U/V
    #: height = Y height.
    CU_EGL_COLOR_FORMAT_YVU444_PLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_PLANAR_ER

    #: Extended Range Y, V, U in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU422_PLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_PLANAR_ER

    #: Extended Range Y, V, U in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR_ER

    #: Extended Range Y, VU in two surfaces (VU as one surface) with UV
    #: byte ordering, U/V width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR_ER

    #: Extended Range Y, VU in two surfaces (VU as one surface) with UV
    #: byte ordering, U/V width = 1/2 Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR_ER

    #: Extended Range Y, VU in two surfaces (VU as one surface) with UV
    #: byte ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_ER

    #: Bayer format - one channel in one surface with interleaved RGGB
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_RGGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_RGGB

    #: Bayer format - one channel in one surface with interleaved BGGR
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_BGGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_BGGR

    #: Bayer format - one channel in one surface with interleaved GRBG
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_GRBG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_GRBG

    #: Bayer format - one channel in one surface with interleaved GBRG
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_GBRG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_GBRG

    #: Bayer10 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER10_RGGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_RGGB

    #: Bayer10 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER10_BGGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_BGGR

    #: Bayer10 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER10_GRBG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_GRBG

    #: Bayer10 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER10_GBRG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_GBRG

    #: Bayer12 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_RGGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_RGGB

    #: Bayer12 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_BGGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_BGGR

    #: Bayer12 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_GRBG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_GRBG

    #: Bayer12 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_GBRG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_GBRG

    #: Bayer14 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER14_RGGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_RGGB

    #: Bayer14 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER14_BGGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_BGGR

    #: Bayer14 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER14_GRBG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_GRBG

    #: Bayer14 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER14_GBRG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_GBRG

    #: Bayer20 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER20_RGGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_RGGB

    #: Bayer20 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER20_BGGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_BGGR

    #: Bayer20 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER20_GRBG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_GRBG

    #: Bayer20 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER20_GBRG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_GBRG

    #: Y, V, U in three surfaces, each in a separate surface, U/V width = Y
    #: width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU444_PLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_PLANAR

    #: Y, V, U in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_YVU422_PLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_PLANAR

    #: Y, V, U in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved RGGB ordering and mapped to opaque integer
    #: datatype.
    CU_EGL_COLOR_FORMAT_BAYER_ISP_RGGB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_RGGB

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved BGGR ordering and mapped to opaque integer
    #: datatype.
    CU_EGL_COLOR_FORMAT_BAYER_ISP_BGGR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_BGGR

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved GRBG ordering and mapped to opaque integer
    #: datatype.
    CU_EGL_COLOR_FORMAT_BAYER_ISP_GRBG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_GRBG

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved GBRG ordering and mapped to opaque integer
    #: datatype.
    CU_EGL_COLOR_FORMAT_BAYER_ISP_GBRG = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_GBRG

    #: Bayer format - one channel in one surface with interleaved BCCR
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_BCCR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_BCCR

    #: Bayer format - one channel in one surface with interleaved RCCB
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_RCCB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_RCCB

    #: Bayer format - one channel in one surface with interleaved CRBC
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_CRBC = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_CRBC

    #: Bayer format - one channel in one surface with interleaved CBRC
    #: ordering.
    CU_EGL_COLOR_FORMAT_BAYER_CBRC = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_CBRC

    #: Bayer10 format - one channel in one surface with interleaved CCCC
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER10_CCCC = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_CCCC

    #: Bayer12 format - one channel in one surface with interleaved BCCR
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_BCCR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_BCCR

    #: Bayer12 format - one channel in one surface with interleaved RCCB
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_RCCB = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_RCCB

    #: Bayer12 format - one channel in one surface with interleaved CRBC
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_CRBC = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_CRBC

    #: Bayer12 format - one channel in one surface with interleaved CBRC
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_CBRC = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_CBRC

    #: Bayer12 format - one channel in one surface with interleaved CCCC
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    CU_EGL_COLOR_FORMAT_BAYER12_CCCC = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_CCCC

    #: Color format for single Y plane.
    CU_EGL_COLOR_FORMAT_Y = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y

    #: Y, UV in two surfaces (UV as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_2020

    #: Y, VU in two surfaces (VU as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_2020

    #: Y, U, V each in a separate surface, U/V width = 1/2 Y width, U/V
    #: height= 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR_2020

    #: Y, V, U each in a separate surface, U/V width = 1/2 Y width, U/V
    #: height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR_2020

    #: Y, UV in two surfaces (UV as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_709

    #: Y, VU in two surfaces (VU as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_709

    #: Y, U, V each in a separate surface, U/V width = 1/2 Y width, U/V
    #: height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR_709

    #: Y, V, U each in a separate surface, U/V width = 1/2 Y width, U/V
    #: height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR_709

    #: Y10, V10U10 in two surfaces (VU as one surface), U/V width = 1/2 Y
    #: width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709

    #: Y10, V10U10 in two surfaces (VU as one surface), U/V width = 1/2 Y
    #: width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_2020

    #: Y10, V10U10 in two surfaces(VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_2020

    #: Y10, V10U10 in two surfaces(VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR

    #: Y10, V10U10 in two surfaces(VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_709

    #: Extended Range Color format for single Y plane.
    CU_EGL_COLOR_FORMAT_Y_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y_ER

    #: Extended Range Color format for single Y plane.
    CU_EGL_COLOR_FORMAT_Y_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y_709_ER

    #: Extended Range Color format for single Y10 plane.
    CU_EGL_COLOR_FORMAT_Y10_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10_ER

    #: Extended Range Color format for single Y10 plane.
    CU_EGL_COLOR_FORMAT_Y10_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10_709_ER

    #: Extended Range Color format for single Y12 plane.
    CU_EGL_COLOR_FORMAT_Y12_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12_ER

    #: Extended Range Color format for single Y12 plane.
    CU_EGL_COLOR_FORMAT_Y12_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12_709_ER

    #: Y, U, V, A four channels in one surface, interleaved as AVUY.
    CU_EGL_COLOR_FORMAT_YUVA = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUVA

    #: Y, U, V three channels in one surface, interleaved as VUY. Only
    #: pitch linear format supported.
    CU_EGL_COLOR_FORMAT_YUV = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV

    #: Y, U, V in one surface, interleaved as YVYU in one channel.
    CU_EGL_COLOR_FORMAT_YVYU = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVYU

    #: Y, U, V in one surface, interleaved as VYUY in one channel.
    CU_EGL_COLOR_FORMAT_VYUY = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_VYUY

    #: Extended Range Y10, V10U10 in two surfaces(VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_ER

    #: Extended Range Y10, V10U10 in two surfaces(VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709_ER

    #: Extended Range Y10, V10U10 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_ER

    #: Extended Range Y10, V10U10 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_709_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_709_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_709_ER

    #: Y, U, V in one surface, interleaved as UYVY in one channel.
    CU_EGL_COLOR_FORMAT_UYVY_709 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_709

    #: Extended Range Y, U, V in one surface, interleaved as UYVY in one
    #: channel.
    CU_EGL_COLOR_FORMAT_UYVY_709_ER = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_709_ER

    #: Y, U, V in one surface, interleaved as UYVY in one channel.
    CU_EGL_COLOR_FORMAT_UYVY_2020 = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_2020
    CU_EGL_COLOR_FORMAT_MAX = cydriver.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_MAX

_dict_CUeglColorFormat = dict(((int(v), v) for k, v in CUeglColorFormat.__members__.items()))

class CUGLDeviceList(IntEnum):
    """
    CUDA devices corresponding to an OpenGL device
    """

    #: The CUDA devices for all GPUs used by the current OpenGL context
    CU_GL_DEVICE_LIST_ALL = cydriver.CUGLDeviceList_enum.CU_GL_DEVICE_LIST_ALL

    #: The CUDA devices for the GPUs used by the current OpenGL context in
    #: its currently rendering frame
    CU_GL_DEVICE_LIST_CURRENT_FRAME = cydriver.CUGLDeviceList_enum.CU_GL_DEVICE_LIST_CURRENT_FRAME

    #: The CUDA devices for the GPUs to be used by the current OpenGL
    #: context in the next frame
    CU_GL_DEVICE_LIST_NEXT_FRAME = cydriver.CUGLDeviceList_enum.CU_GL_DEVICE_LIST_NEXT_FRAME

_dict_CUGLDeviceList = dict(((int(v), v) for k, v in CUGLDeviceList.__members__.items()))

class CUGLmap_flags(IntEnum):
    """
    Flags to map or unmap a resource
    """
    CU_GL_MAP_RESOURCE_FLAGS_NONE = cydriver.CUGLmap_flags_enum.CU_GL_MAP_RESOURCE_FLAGS_NONE
    CU_GL_MAP_RESOURCE_FLAGS_READ_ONLY = cydriver.CUGLmap_flags_enum.CU_GL_MAP_RESOURCE_FLAGS_READ_ONLY
    CU_GL_MAP_RESOURCE_FLAGS_WRITE_DISCARD = cydriver.CUGLmap_flags_enum.CU_GL_MAP_RESOURCE_FLAGS_WRITE_DISCARD

_dict_CUGLmap_flags = dict(((int(v), v) for k, v in CUGLmap_flags.__members__.items()))

cdef class CUdeviceptr:
    """

    CUDA device pointer CUdeviceptr is defined as an unsigned integer type whose size matches the size of a pointer on the target platform.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUdeviceptr *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUdeviceptr ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUdevice:
    """

    CUDA device

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUdevice *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUdevice ' + str(self.__int__()) + '>'
    def __int__(self):
        return <int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUtexObject:
    """

    An opaque value that represents a CUDA texture object

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUtexObject *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUtexObject ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUsurfObject:
    """

    An opaque value that represents a CUDA surface object

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUsurfObject *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUsurfObject ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgraphConditionalHandle:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint64_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUgraphConditionalHandle *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUgraphConditionalHandle ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint64_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

class CUkernelNodeAttrID(IntEnum):
    """
    Launch attributes enum; used as id field of
    :py:obj:`~.CUlaunchAttribute`
    """

    #: Ignored entry, for convenient composition
    CU_LAUNCH_ATTRIBUTE_IGNORE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_IGNORE

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.accessPolicyWindow`.
    CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.cooperative`.
    CU_LAUNCH_ATTRIBUTE_COOPERATIVE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_COOPERATIVE

    #: Valid for streams. See
    #: :py:obj:`~.CUlaunchAttributeValue.syncPolicy`.
    CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.clusterDim`.
    CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.clusterSchedulingPolicyPreference`.
    CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE

    #: Valid for launches. Setting
    #: :py:obj:`~.CUlaunchAttributeValue.programmaticStreamSerializationAllowed`
    #: to non-0 signals that the kernel will use programmatic means to
    #: resolve its stream dependency, so that the CUDA runtime should
    #: opportunistically allow the grid's execution to overlap with the
    #: previous kernel in the stream, if that kernel requests the overlap.
    #: The dependent launches can choose to wait on the dependency using
    #: the programmatic sync (cudaGridDependencySynchronize() or equivalent
    #: PTX instructions).
    CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION

    #: Valid for launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.programmaticEvent` to record the
    #: event. Event recorded through this launch attribute is guaranteed to
    #: only trigger after all block in the associated kernel trigger the
    #: event. A block can trigger the event through PTX launchdep.release
    #: or CUDA builtin function cudaTriggerProgrammaticLaunchCompletion().
    #: A trigger can also be inserted at the beginning of each block's
    #: execution if triggerAtBlockStart is set to non-0. The dependent
    #: launches can choose to wait on the dependency using the programmatic
    #: sync (cudaGridDependencySynchronize() or equivalent PTX
    #: instructions). Note that dependents (including the CPU thread
    #: calling :py:obj:`~.cuEventSynchronize()`) are not guaranteed to
    #: observe the release precisely when it is released. For example,
    #: :py:obj:`~.cuEventSynchronize()` may only observe the event trigger
    #: long after the associated kernel has completed. This recording type
    #: is primarily meant for establishing programmatic dependency between
    #: device tasks. Note also this type of dependency allows, but does not
    #: guarantee, concurrent execution of tasks.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag set).
    CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.priority`.
    CU_LAUNCH_ATTRIBUTE_PRIORITY = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PRIORITY

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.memSyncDomainMap`.
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.memSyncDomain`.
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN

    #: Valid for graph nodes, launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.preferredClusterDim` to allow the
    #: kernel launch to specify a preferred substitute cluster dimension.
    #: Blocks may be grouped according to either the dimensions specified
    #: with this attribute (grouped into a "preferred substitute cluster"),
    #: or the one specified with
    #: :py:obj:`~.CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION` attribute (grouped
    #: into a "regular cluster"). The cluster dimensions of a "preferred
    #: substitute cluster" shall be an integer multiple greater than zero
    #: of the regular cluster dimensions. The device will attempt - on a
    #: best-effort basis - to group thread blocks into preferred clusters
    #: over grouping them into regular clusters. When it deems necessary
    #: (primarily when the device temporarily runs out of physical
    #: resources to launch the larger preferred clusters), the device may
    #: switch to launch the regular clusters instead to attempt to utilize
    #: as much of the physical device resources as possible.
    #:  Each type of cluster will have its enumeration / coordinate setup
    #: as if the grid consists solely of its type of cluster. For example,
    #: if the preferred substitute cluster dimensions double the regular
    #: cluster dimensions, there might be simultaneously a regular cluster
    #: indexed at (1,0,0), and a preferred cluster indexed at (1,0,0). In
    #: this example, the preferred substitute cluster (1,0,0) replaces
    #: regular clusters (2,0,0) and (3,0,0) and groups their blocks.
    #:  This attribute will only take effect when a regular cluster
    #: dimension has been specified. The preferred substitute cluster
    #: dimension must be an integer multiple greater than zero of the
    #: regular cluster dimension and must divide the grid. It must also be
    #: no more than `maxBlocksPerCluster`, if it is set in the kernel's
    #: `__launch_bounds__`. Otherwise it must be less than the maximum
    #: value the driver can support. Otherwise, setting this attribute to a
    #: value physically unable to fit on any particular device is
    #: permitted.
    CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION

    #: Valid for launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.launchCompletionEvent` to record
    #: the event.
    #:  Nominally, the event is triggered once all blocks of the kernel
    #: have begun execution. Currently this is a best effort. If a kernel B
    #: has a launch completion dependency on a kernel A, B may wait until A
    #: is complete. Alternatively, blocks of B may begin before all blocks
    #: of A have begun, for example if B can claim execution resources
    #: unavailable to A (e.g. they run on different GPUs) or if B is a
    #: higher priority than A. Exercise caution if such an ordering
    #: inversion could lead to deadlock.
    #:  A launch completion event is nominally similar to a programmatic
    #: event with `triggerAtBlockStart` set except that it is not visible
    #: to `cudaGridDependencySynchronize()` and can be used with compute
    #: capability less than 9.0.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag set).
    CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT

    #: Valid for graph nodes, launches. This attribute is graphs-only, and
    #: passing it to a launch in a non-capturing stream will result in an
    #: error.
    #: :py:obj:`~.CUlaunchAttributeValue`::deviceUpdatableKernelNode::deviceUpdatable
    #: can only be set to 0 or 1. Setting the field to 1 indicates that the
    #: corresponding kernel node should be device-updatable. On success, a
    #: handle will be returned via
    #: :py:obj:`~.CUlaunchAttributeValue`::deviceUpdatableKernelNode::devNode
    #: which can be passed to the various device-side update functions to
    #: update the node's kernel parameters from within another kernel. For
    #: more information on the types of device updates that can be made, as
    #: well as the relevant limitations thereof, see
    #: :py:obj:`~.cudaGraphKernelNodeUpdatesApply`.
    #:  Nodes which are device-updatable have additional restrictions
    #: compared to regular kernel nodes. Firstly, device-updatable nodes
    #: cannot be removed from their graph via
    #: :py:obj:`~.cuGraphDestroyNode`. Additionally, once opted-in to this
    #: functionality, a node cannot opt out, and any attempt to set the
    #: deviceUpdatable attribute to 0 will result in an error. Device-
    #: updatable kernel nodes also cannot have their attributes copied
    #: to/from another kernel node via
    #: :py:obj:`~.cuGraphKernelNodeCopyAttributes`. Graphs containing one
    #: or more device-updatable nodes also do not allow multiple
    #: instantiation, and neither the graph nor its instantiated version
    #: can be passed to :py:obj:`~.cuGraphExecUpdate`.
    #:  If a graph contains device-updatable nodes and updates those nodes
    #: from the device from within the graph, the graph must be uploaded
    #: with :py:obj:`~.cuGraphUpload` before it is launched. For such a
    #: graph, if host-side executable graph updates are made to the device-
    #: updatable nodes, the graph must be uploaded before it is launched
    #: again.
    CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE

    #: Valid for launches. On devices where the L1 cache and shared memory
    #: use the same hardware resources, setting
    #: :py:obj:`~.CUlaunchAttributeValue.sharedMemCarveout` to a percentage
    #: between 0-100 signals the CUDA driver to set the shared memory
    #: carveout preference, in percent of the total shared memory for that
    #: kernel launch. This attribute takes precedence over
    #: :py:obj:`~.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT`. This
    #: is only a hint, and the CUDA driver can choose a different
    #: configuration if required for the launch.
    CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT

    #: Valid for streams, graph nodes, launches. This attribute is a hint
    #: to the CUDA runtime that the launch should attempt to make the
    #: kernel maximize its NVLINK utilization.
    #:
    #:  When possible to honor this hint, CUDA will assume each block in
    #: the grid launch will carry out an even amount of NVLINK traffic, and
    #: make a best-effort attempt to adjust the kernel launch based on that
    #: assumption.
    #:  This attribute is a hint only. CUDA makes no functional or
    #: performance guarantee. Its applicability can be affected by many
    #: different factors, including driver version (i.e. CUDA doesn't
    #: guarantee the performance characteristics will be maintained between
    #: driver versions or a driver update could alter or regress previously
    #: observed perf characteristics.) It also doesn't guarantee a
    #: successful result, i.e. applying the attribute may not improve the
    #: performance of either the targeted kernel or the encapsulating
    #: application.
    #:  Valid values for
    #: :py:obj:`~.CUlaunchAttributeValue`::nvlinkUtilCentricScheduling are
    #: 0 (disabled) and 1 (enabled).
    CU_LAUNCH_ATTRIBUTE_NVLINK_UTIL_CENTRIC_SCHEDULING = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_NVLINK_UTIL_CENTRIC_SCHEDULING

_dict_CUlaunchAttributeID = dict(((int(v), v) for k, v in CUlaunchAttributeID.__members__.items()))

class CUstreamAttrID(IntEnum):
    """
    Launch attributes enum; used as id field of
    :py:obj:`~.CUlaunchAttribute`
    """

    #: Ignored entry, for convenient composition
    CU_LAUNCH_ATTRIBUTE_IGNORE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_IGNORE

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.accessPolicyWindow`.
    CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.cooperative`.
    CU_LAUNCH_ATTRIBUTE_COOPERATIVE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_COOPERATIVE

    #: Valid for streams. See
    #: :py:obj:`~.CUlaunchAttributeValue.syncPolicy`.
    CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.clusterDim`.
    CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.clusterSchedulingPolicyPreference`.
    CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE

    #: Valid for launches. Setting
    #: :py:obj:`~.CUlaunchAttributeValue.programmaticStreamSerializationAllowed`
    #: to non-0 signals that the kernel will use programmatic means to
    #: resolve its stream dependency, so that the CUDA runtime should
    #: opportunistically allow the grid's execution to overlap with the
    #: previous kernel in the stream, if that kernel requests the overlap.
    #: The dependent launches can choose to wait on the dependency using
    #: the programmatic sync (cudaGridDependencySynchronize() or equivalent
    #: PTX instructions).
    CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION

    #: Valid for launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.programmaticEvent` to record the
    #: event. Event recorded through this launch attribute is guaranteed to
    #: only trigger after all block in the associated kernel trigger the
    #: event. A block can trigger the event through PTX launchdep.release
    #: or CUDA builtin function cudaTriggerProgrammaticLaunchCompletion().
    #: A trigger can also be inserted at the beginning of each block's
    #: execution if triggerAtBlockStart is set to non-0. The dependent
    #: launches can choose to wait on the dependency using the programmatic
    #: sync (cudaGridDependencySynchronize() or equivalent PTX
    #: instructions). Note that dependents (including the CPU thread
    #: calling :py:obj:`~.cuEventSynchronize()`) are not guaranteed to
    #: observe the release precisely when it is released. For example,
    #: :py:obj:`~.cuEventSynchronize()` may only observe the event trigger
    #: long after the associated kernel has completed. This recording type
    #: is primarily meant for establishing programmatic dependency between
    #: device tasks. Note also this type of dependency allows, but does not
    #: guarantee, concurrent execution of tasks.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag set).
    CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.priority`.
    CU_LAUNCH_ATTRIBUTE_PRIORITY = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PRIORITY

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.memSyncDomainMap`.
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.CUlaunchAttributeValue.memSyncDomain`.
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN

    #: Valid for graph nodes, launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.preferredClusterDim` to allow the
    #: kernel launch to specify a preferred substitute cluster dimension.
    #: Blocks may be grouped according to either the dimensions specified
    #: with this attribute (grouped into a "preferred substitute cluster"),
    #: or the one specified with
    #: :py:obj:`~.CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION` attribute (grouped
    #: into a "regular cluster"). The cluster dimensions of a "preferred
    #: substitute cluster" shall be an integer multiple greater than zero
    #: of the regular cluster dimensions. The device will attempt - on a
    #: best-effort basis - to group thread blocks into preferred clusters
    #: over grouping them into regular clusters. When it deems necessary
    #: (primarily when the device temporarily runs out of physical
    #: resources to launch the larger preferred clusters), the device may
    #: switch to launch the regular clusters instead to attempt to utilize
    #: as much of the physical device resources as possible.
    #:  Each type of cluster will have its enumeration / coordinate setup
    #: as if the grid consists solely of its type of cluster. For example,
    #: if the preferred substitute cluster dimensions double the regular
    #: cluster dimensions, there might be simultaneously a regular cluster
    #: indexed at (1,0,0), and a preferred cluster indexed at (1,0,0). In
    #: this example, the preferred substitute cluster (1,0,0) replaces
    #: regular clusters (2,0,0) and (3,0,0) and groups their blocks.
    #:  This attribute will only take effect when a regular cluster
    #: dimension has been specified. The preferred substitute cluster
    #: dimension must be an integer multiple greater than zero of the
    #: regular cluster dimension and must divide the grid. It must also be
    #: no more than `maxBlocksPerCluster`, if it is set in the kernel's
    #: `__launch_bounds__`. Otherwise it must be less than the maximum
    #: value the driver can support. Otherwise, setting this attribute to a
    #: value physically unable to fit on any particular device is
    #: permitted.
    CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION

    #: Valid for launches. Set
    #: :py:obj:`~.CUlaunchAttributeValue.launchCompletionEvent` to record
    #: the event.
    #:  Nominally, the event is triggered once all blocks of the kernel
    #: have begun execution. Currently this is a best effort. If a kernel B
    #: has a launch completion dependency on a kernel A, B may wait until A
    #: is complete. Alternatively, blocks of B may begin before all blocks
    #: of A have begun, for example if B can claim execution resources
    #: unavailable to A (e.g. they run on different GPUs) or if B is a
    #: higher priority than A. Exercise caution if such an ordering
    #: inversion could lead to deadlock.
    #:  A launch completion event is nominally similar to a programmatic
    #: event with `triggerAtBlockStart` set except that it is not visible
    #: to `cudaGridDependencySynchronize()` and can be used with compute
    #: capability less than 9.0.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag set).
    CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT

    #: Valid for graph nodes, launches. This attribute is graphs-only, and
    #: passing it to a launch in a non-capturing stream will result in an
    #: error.
    #: :py:obj:`~.CUlaunchAttributeValue`::deviceUpdatableKernelNode::deviceUpdatable
    #: can only be set to 0 or 1. Setting the field to 1 indicates that the
    #: corresponding kernel node should be device-updatable. On success, a
    #: handle will be returned via
    #: :py:obj:`~.CUlaunchAttributeValue`::deviceUpdatableKernelNode::devNode
    #: which can be passed to the various device-side update functions to
    #: update the node's kernel parameters from within another kernel. For
    #: more information on the types of device updates that can be made, as
    #: well as the relevant limitations thereof, see
    #: :py:obj:`~.cudaGraphKernelNodeUpdatesApply`.
    #:  Nodes which are device-updatable have additional restrictions
    #: compared to regular kernel nodes. Firstly, device-updatable nodes
    #: cannot be removed from their graph via
    #: :py:obj:`~.cuGraphDestroyNode`. Additionally, once opted-in to this
    #: functionality, a node cannot opt out, and any attempt to set the
    #: deviceUpdatable attribute to 0 will result in an error. Device-
    #: updatable kernel nodes also cannot have their attributes copied
    #: to/from another kernel node via
    #: :py:obj:`~.cuGraphKernelNodeCopyAttributes`. Graphs containing one
    #: or more device-updatable nodes also do not allow multiple
    #: instantiation, and neither the graph nor its instantiated version
    #: can be passed to :py:obj:`~.cuGraphExecUpdate`.
    #:  If a graph contains device-updatable nodes and updates those nodes
    #: from the device from within the graph, the graph must be uploaded
    #: with :py:obj:`~.cuGraphUpload` before it is launched. For such a
    #: graph, if host-side executable graph updates are made to the device-
    #: updatable nodes, the graph must be uploaded before it is launched
    #: again.
    CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE

    #: Valid for launches. On devices where the L1 cache and shared memory
    #: use the same hardware resources, setting
    #: :py:obj:`~.CUlaunchAttributeValue.sharedMemCarveout` to a percentage
    #: between 0-100 signals the CUDA driver to set the shared memory
    #: carveout preference, in percent of the total shared memory for that
    #: kernel launch. This attribute takes precedence over
    #: :py:obj:`~.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT`. This
    #: is only a hint, and the CUDA driver can choose a different
    #: configuration if required for the launch.
    CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT

    #: Valid for streams, graph nodes, launches. This attribute is a hint
    #: to the CUDA runtime that the launch should attempt to make the
    #: kernel maximize its NVLINK utilization.
    #:
    #:  When possible to honor this hint, CUDA will assume each block in
    #: the grid launch will carry out an even amount of NVLINK traffic, and
    #: make a best-effort attempt to adjust the kernel launch based on that
    #: assumption.
    #:  This attribute is a hint only. CUDA makes no functional or
    #: performance guarantee. Its applicability can be affected by many
    #: different factors, including driver version (i.e. CUDA doesn't
    #: guarantee the performance characteristics will be maintained between
    #: driver versions or a driver update could alter or regress previously
    #: observed perf characteristics.) It also doesn't guarantee a
    #: successful result, i.e. applying the attribute may not improve the
    #: performance of either the targeted kernel or the encapsulating
    #: application.
    #:  Valid values for
    #: :py:obj:`~.CUlaunchAttributeValue`::nvlinkUtilCentricScheduling are
    #: 0 (disabled) and 1 (enabled).
    CU_LAUNCH_ATTRIBUTE_NVLINK_UTIL_CENTRIC_SCHEDULING = cydriver.CUlaunchAttributeID_enum.CU_LAUNCH_ATTRIBUTE_NVLINK_UTIL_CENTRIC_SCHEDULING

_dict_CUlaunchAttributeID = dict(((int(v), v) for k, v in CUlaunchAttributeID.__members__.items()))

cdef class CUmemGenericAllocationHandle:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemGenericAllocationHandle *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUmemGenericAllocationHandle ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUcontext:
    """

    A regular context handle

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUcontext>init_value
        else:
            self._pvt_ptr = <cydriver.CUcontext *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUcontext ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUcontext):
            return False
        return self._pvt_ptr[0] == (<CUcontext>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUmodule:
    """

    CUDA module

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUmodule>init_value
        else:
            self._pvt_ptr = <cydriver.CUmodule *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUmodule ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUmodule):
            return False
        return self._pvt_ptr[0] == (<CUmodule>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUfunction:
    """

    CUDA function

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUfunction>init_value
        else:
            self._pvt_ptr = <cydriver.CUfunction *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUfunction ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUfunction):
            return False
        return self._pvt_ptr[0] == (<CUfunction>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUlibrary:
    """

    CUDA library

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUlibrary>init_value
        else:
            self._pvt_ptr = <cydriver.CUlibrary *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUlibrary ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUlibrary):
            return False
        return self._pvt_ptr[0] == (<CUlibrary>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUkernel:
    """

    CUDA kernel

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUkernel>init_value
        else:
            self._pvt_ptr = <cydriver.CUkernel *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUkernel ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUkernel):
            return False
        return self._pvt_ptr[0] == (<CUkernel>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUarray:
    """

    CUDA array

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUarray>init_value
        else:
            self._pvt_ptr = <cydriver.CUarray *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUarray ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUarray):
            return False
        return self._pvt_ptr[0] == (<CUarray>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUmipmappedArray:
    """

    CUDA mipmapped array

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUmipmappedArray>init_value
        else:
            self._pvt_ptr = <cydriver.CUmipmappedArray *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUmipmappedArray ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUmipmappedArray):
            return False
        return self._pvt_ptr[0] == (<CUmipmappedArray>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUtexref:
    """

    CUDA texture reference

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUtexref>init_value
        else:
            self._pvt_ptr = <cydriver.CUtexref *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUtexref ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUtexref):
            return False
        return self._pvt_ptr[0] == (<CUtexref>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUsurfref:
    """

    CUDA surface reference

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUsurfref>init_value
        else:
            self._pvt_ptr = <cydriver.CUsurfref *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUsurfref ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUsurfref):
            return False
        return self._pvt_ptr[0] == (<CUsurfref>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUevent:
    """

    CUDA event

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUevent>init_value
        else:
            self._pvt_ptr = <cydriver.CUevent *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUevent ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUevent):
            return False
        return self._pvt_ptr[0] == (<CUevent>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUstream:
    """

    CUDA stream

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUstream>init_value
        else:
            self._pvt_ptr = <cydriver.CUstream *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUstream ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUstream):
            return False
        return self._pvt_ptr[0] == (<CUstream>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgraphicsResource:
    """

    CUDA graphics interop resource

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUgraphicsResource>init_value
        else:
            self._pvt_ptr = <cydriver.CUgraphicsResource *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUgraphicsResource ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUgraphicsResource):
            return False
        return self._pvt_ptr[0] == (<CUgraphicsResource>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUexternalMemory:
    """

    CUDA external memory

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUexternalMemory>init_value
        else:
            self._pvt_ptr = <cydriver.CUexternalMemory *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUexternalMemory ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUexternalMemory):
            return False
        return self._pvt_ptr[0] == (<CUexternalMemory>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUexternalSemaphore:
    """

    CUDA external semaphore

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUexternalSemaphore>init_value
        else:
            self._pvt_ptr = <cydriver.CUexternalSemaphore *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUexternalSemaphore ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUexternalSemaphore):
            return False
        return self._pvt_ptr[0] == (<CUexternalSemaphore>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgraph:
    """

    CUDA graph

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUgraph>init_value
        else:
            self._pvt_ptr = <cydriver.CUgraph *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUgraph ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUgraph):
            return False
        return self._pvt_ptr[0] == (<CUgraph>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgraphNode:
    """

    CUDA graph node

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUgraphNode>init_value
        else:
            self._pvt_ptr = <cydriver.CUgraphNode *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUgraphNode ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUgraphNode):
            return False
        return self._pvt_ptr[0] == (<CUgraphNode>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgraphExec:
    """

    CUDA executable graph

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUgraphExec>init_value
        else:
            self._pvt_ptr = <cydriver.CUgraphExec *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUgraphExec ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUgraphExec):
            return False
        return self._pvt_ptr[0] == (<CUgraphExec>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUmemoryPool:
    """

    CUDA memory pool

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUmemoryPool>init_value
        else:
            self._pvt_ptr = <cydriver.CUmemoryPool *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUmemoryPool ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUmemoryPool):
            return False
        return self._pvt_ptr[0] == (<CUmemoryPool>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUuserObject:
    """

    CUDA user object for graphs

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUuserObject>init_value
        else:
            self._pvt_ptr = <cydriver.CUuserObject *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUuserObject ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUuserObject):
            return False
        return self._pvt_ptr[0] == (<CUuserObject>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgraphDeviceNode:
    """

    CUDA graph device node handle

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUgraphDeviceNode>init_value
        else:
            self._pvt_ptr = <cydriver.CUgraphDeviceNode *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUgraphDeviceNode ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUgraphDeviceNode):
            return False
        return self._pvt_ptr[0] == (<CUgraphDeviceNode>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUasyncCallbackHandle:
    """

    CUDA async notification callback handle

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUasyncCallbackHandle>init_value
        else:
            self._pvt_ptr = <cydriver.CUasyncCallbackHandle *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUasyncCallbackHandle ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUasyncCallbackHandle):
            return False
        return self._pvt_ptr[0] == (<CUasyncCallbackHandle>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUgreenCtx:
    """

    A green context handle. This handle can be used safely from only one CPU thread at a time. Created via cuGreenCtxCreate

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUgreenCtx>init_value
        else:
            self._pvt_ptr = <cydriver.CUgreenCtx *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUgreenCtx ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUgreenCtx):
            return False
        return self._pvt_ptr[0] == (<CUgreenCtx>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUlinkState:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUlinkState>init_value
        else:
            self._pvt_ptr = <cydriver.CUlinkState *>_ptr
    def __init__(self, *args, **kwargs):
        self._keepalive = []
    def __repr__(self):
        return '<CUlinkState ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUlinkState):
            return False
        return self._pvt_ptr[0] == (<CUlinkState>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUdevResourceDesc:
    """

    An opaque descriptor handle. The descriptor encapsulates multiple created and configured resources. Created via cuDevResourceGenerateDesc

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUdevResourceDesc>init_value
        else:
            self._pvt_ptr = <cydriver.CUdevResourceDesc *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUdevResourceDesc ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUdevResourceDesc):
            return False
        return self._pvt_ptr[0] == (<CUdevResourceDesc>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUlogsCallbackHandle:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUlogsCallbackHandle>init_value
        else:
            self._pvt_ptr = <cydriver.CUlogsCallbackHandle *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUlogsCallbackHandle ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUlogsCallbackHandle):
            return False
        return self._pvt_ptr[0] == (<CUlogsCallbackHandle>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUeglStreamConnection:
    """

    CUDA EGLSream Connection

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUeglStreamConnection>init_value
        else:
            self._pvt_ptr = <cydriver.CUeglStreamConnection *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUeglStreamConnection ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, CUeglStreamConnection):
            return False
        return self._pvt_ptr[0] == (<CUeglStreamConnection>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLImageKHR:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.EGLImageKHR>init_value
        else:
            self._pvt_ptr = <cydriver.EGLImageKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<EGLImageKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, EGLImageKHR):
            return False
        return self._pvt_ptr[0] == (<EGLImageKHR>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLStreamKHR:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.EGLStreamKHR>init_value
        else:
            self._pvt_ptr = <cydriver.EGLStreamKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<EGLStreamKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, EGLStreamKHR):
            return False
        return self._pvt_ptr[0] == (<EGLStreamKHR>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLSyncKHR:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.EGLSyncKHR>init_value
        else:
            self._pvt_ptr = <cydriver.EGLSyncKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<EGLSyncKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, EGLSyncKHR):
            return False
        return self._pvt_ptr[0] == (<EGLSyncKHR>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUasyncCallback:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUasyncCallback>init_value
        else:
            self._pvt_ptr = <cydriver.CUasyncCallback *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUasyncCallback ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUhostFn:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUhostFn>init_value
        else:
            self._pvt_ptr = <cydriver.CUhostFn *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUhostFn ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUstreamCallback:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUstreamCallback>init_value
        else:
            self._pvt_ptr = <cydriver.CUstreamCallback *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUstreamCallback ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUoccupancyB2DSize:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUoccupancyB2DSize>init_value
        else:
            self._pvt_ptr = <cydriver.CUoccupancyB2DSize *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUoccupancyB2DSize ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUlogsCallback:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cydriver.CUlogsCallback>init_value
        else:
            self._pvt_ptr = <cydriver.CUlogsCallback *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<CUlogsCallback ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUuuid_st:
    """
    Attributes
    ----------
    bytes : bytes
        < CUDA definition of UUID

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUuuid_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['bytes : ' + str(self.bytes.hex())]
            except ValueError:
                str_list += ['bytes : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def bytes(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].bytes, 16)

cdef class CUmemFabricHandle_st:
    """
    Fabric handle - An opaque handle representing a memory allocation
    that can be exported to processes in same or different nodes. For
    IPC between processes on different nodes they must be connected via
    the NVSwitch fabric.

    Attributes
    ----------
    data : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemFabricHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['data : ' + str(self.data)]
            except ValueError:
                str_list += ['data : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def data(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].data, 64)
    @data.setter
    def data(self, data):
        if len(data) != 64:
            raise ValueError("data length must be 64, is " + str(len(data)))
        for i, b in enumerate(data):
            self._pvt_ptr[0].data[i] = b

cdef class CUipcEventHandle_st:
    """
    CUDA IPC event handle

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUipcEventHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        if CHAR_MIN == 0:
            for i, b in enumerate(reserved):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].reserved[i] = b
        else:
            for i, b in enumerate(reserved):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].reserved[i] = b

cdef class CUipcMemHandle_st:
    """
    CUDA IPC mem handle

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUipcMemHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        if CHAR_MIN == 0:
            for i, b in enumerate(reserved):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].reserved[i] = b
        else:
            for i, b in enumerate(reserved):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].reserved[i] = b

cdef class CUstreamMemOpWaitValueParams_st:
    """
    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    address : CUdeviceptr

    value : cuuint32_t

    value64 : cuuint64_t

    flags : unsigned int
        See CUstreamWaitValue_flags.
    alias : CUdeviceptr
        For driver internal use. Initial value is unimportant.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUstreamBatchMemOpParams_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._address = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].waitValue.address)
        self._value = cuuint32_t(_ptr=<void_ptr>&self._pvt_ptr[0].waitValue.value)
        self._value64 = cuuint64_t(_ptr=<void_ptr>&self._pvt_ptr[0].waitValue.value64)
        self._alias = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].waitValue.alias)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].waitValue
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['operation : ' + str(self.operation)]
            except ValueError:
                str_list += ['operation : <ValueError>']
            try:
                str_list += ['address : ' + str(self.address)]
            except ValueError:
                str_list += ['address : <ValueError>']
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            try:
                str_list += ['value64 : ' + str(self.value64)]
            except ValueError:
                str_list += ['value64 : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['alias : ' + str(self.alias)]
            except ValueError:
                str_list += ['alias : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def operation(self):
        if self._pvt_ptr[0].waitValue.operation not in _dict_CUstreamBatchMemOpType:
            return None
        return _dict_CUstreamBatchMemOpType[self._pvt_ptr[0].waitValue.operation]
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        self._pvt_ptr[0].waitValue.operation = operation.value
    @property
    def address(self):
        return self._address
    @address.setter
    def address(self, address):
        cdef cydriver.CUdeviceptr cyaddress
        if address is None:
            cyaddress = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(address, (CUdeviceptr)):
            paddress = int(address)
            cyaddress = <cydriver.CUdeviceptr><void_ptr>paddress
        else:
            paddress = int(CUdeviceptr(address))
            cyaddress = <cydriver.CUdeviceptr><void_ptr>paddress
        self._address._pvt_ptr[0] = cyaddress

    @property
    def value(self):
        return self._value
    @value.setter
    def value(self, value):
        cdef cydriver.cuuint32_t cyvalue
        if value is None:
            cyvalue = <cydriver.cuuint32_t><void_ptr>0
        elif isinstance(value, (cuuint32_t)):
            pvalue = int(value)
            cyvalue = <cydriver.cuuint32_t><void_ptr>pvalue
        else:
            pvalue = int(cuuint32_t(value))
            cyvalue = <cydriver.cuuint32_t><void_ptr>pvalue
        self._value._pvt_ptr[0] = cyvalue

    @property
    def value64(self):
        return self._value64
    @value64.setter
    def value64(self, value64):
        cdef cydriver.cuuint64_t cyvalue64
        if value64 is None:
            cyvalue64 = <cydriver.cuuint64_t><void_ptr>0
        elif isinstance(value64, (cuuint64_t)):
            pvalue64 = int(value64)
            cyvalue64 = <cydriver.cuuint64_t><void_ptr>pvalue64
        else:
            pvalue64 = int(cuuint64_t(value64))
            cyvalue64 = <cydriver.cuuint64_t><void_ptr>pvalue64
        self._value64._pvt_ptr[0] = cyvalue64

    @property
    def flags(self):
        return self._pvt_ptr[0].waitValue.flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].waitValue.flags = flags
    @property
    def alias(self):
        return self._alias
    @alias.setter
    def alias(self, alias):
        cdef cydriver.CUdeviceptr cyalias
        if alias is None:
            cyalias = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(alias, (CUdeviceptr)):
            palias = int(alias)
            cyalias = <cydriver.CUdeviceptr><void_ptr>palias
        else:
            palias = int(CUdeviceptr(alias))
            cyalias = <cydriver.CUdeviceptr><void_ptr>palias
        self._alias._pvt_ptr[0] = cyalias


cdef class CUstreamMemOpWriteValueParams_st:
    """
    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    address : CUdeviceptr

    value : cuuint32_t

    value64 : cuuint64_t

    flags : unsigned int
        See CUstreamWriteValue_flags.
    alias : CUdeviceptr
        For driver internal use. Initial value is unimportant.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUstreamBatchMemOpParams_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._address = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].writeValue.address)
        self._value = cuuint32_t(_ptr=<void_ptr>&self._pvt_ptr[0].writeValue.value)
        self._value64 = cuuint64_t(_ptr=<void_ptr>&self._pvt_ptr[0].writeValue.value64)
        self._alias = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].writeValue.alias)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].writeValue
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['operation : ' + str(self.operation)]
            except ValueError:
                str_list += ['operation : <ValueError>']
            try:
                str_list += ['address : ' + str(self.address)]
            except ValueError:
                str_list += ['address : <ValueError>']
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            try:
                str_list += ['value64 : ' + str(self.value64)]
            except ValueError:
                str_list += ['value64 : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['alias : ' + str(self.alias)]
            except ValueError:
                str_list += ['alias : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def operation(self):
        if self._pvt_ptr[0].writeValue.operation not in _dict_CUstreamBatchMemOpType:
            return None
        return _dict_CUstreamBatchMemOpType[self._pvt_ptr[0].writeValue.operation]
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        self._pvt_ptr[0].writeValue.operation = operation.value
    @property
    def address(self):
        return self._address
    @address.setter
    def address(self, address):
        cdef cydriver.CUdeviceptr cyaddress
        if address is None:
            cyaddress = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(address, (CUdeviceptr)):
            paddress = int(address)
            cyaddress = <cydriver.CUdeviceptr><void_ptr>paddress
        else:
            paddress = int(CUdeviceptr(address))
            cyaddress = <cydriver.CUdeviceptr><void_ptr>paddress
        self._address._pvt_ptr[0] = cyaddress

    @property
    def value(self):
        return self._value
    @value.setter
    def value(self, value):
        cdef cydriver.cuuint32_t cyvalue
        if value is None:
            cyvalue = <cydriver.cuuint32_t><void_ptr>0
        elif isinstance(value, (cuuint32_t)):
            pvalue = int(value)
            cyvalue = <cydriver.cuuint32_t><void_ptr>pvalue
        else:
            pvalue = int(cuuint32_t(value))
            cyvalue = <cydriver.cuuint32_t><void_ptr>pvalue
        self._value._pvt_ptr[0] = cyvalue

    @property
    def value64(self):
        return self._value64
    @value64.setter
    def value64(self, value64):
        cdef cydriver.cuuint64_t cyvalue64
        if value64 is None:
            cyvalue64 = <cydriver.cuuint64_t><void_ptr>0
        elif isinstance(value64, (cuuint64_t)):
            pvalue64 = int(value64)
            cyvalue64 = <cydriver.cuuint64_t><void_ptr>pvalue64
        else:
            pvalue64 = int(cuuint64_t(value64))
            cyvalue64 = <cydriver.cuuint64_t><void_ptr>pvalue64
        self._value64._pvt_ptr[0] = cyvalue64

    @property
    def flags(self):
        return self._pvt_ptr[0].writeValue.flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].writeValue.flags = flags
    @property
    def alias(self):
        return self._alias
    @alias.setter
    def alias(self, alias):
        cdef cydriver.CUdeviceptr cyalias
        if alias is None:
            cyalias = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(alias, (CUdeviceptr)):
            palias = int(alias)
            cyalias = <cydriver.CUdeviceptr><void_ptr>palias
        else:
            palias = int(CUdeviceptr(alias))
            cyalias = <cydriver.CUdeviceptr><void_ptr>palias
        self._alias._pvt_ptr[0] = cyalias


cdef class CUstreamMemOpFlushRemoteWritesParams_st:
    """
    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    flags : unsigned int
        Must be 0.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUstreamBatchMemOpParams_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].flushRemoteWrites
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['operation : ' + str(self.operation)]
            except ValueError:
                str_list += ['operation : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def operation(self):
        if self._pvt_ptr[0].flushRemoteWrites.operation not in _dict_CUstreamBatchMemOpType:
            return None
        return _dict_CUstreamBatchMemOpType[self._pvt_ptr[0].flushRemoteWrites.operation]
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        self._pvt_ptr[0].flushRemoteWrites.operation = operation.value
    @property
    def flags(self):
        return self._pvt_ptr[0].flushRemoteWrites.flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flushRemoteWrites.flags = flags

cdef class CUstreamMemOpMemoryBarrierParams_st:
    """
    Attributes
    ----------
    operation : CUstreamBatchMemOpType
        < Only supported in the _v2 API
    flags : unsigned int
        See CUstreamMemoryBarrier_flags

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUstreamBatchMemOpParams_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].memoryBarrier
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['operation : ' + str(self.operation)]
            except ValueError:
                str_list += ['operation : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def operation(self):
        if self._pvt_ptr[0].memoryBarrier.operation not in _dict_CUstreamBatchMemOpType:
            return None
        return _dict_CUstreamBatchMemOpType[self._pvt_ptr[0].memoryBarrier.operation]
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        self._pvt_ptr[0].memoryBarrier.operation = operation.value
    @property
    def flags(self):
        return self._pvt_ptr[0].memoryBarrier.flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].memoryBarrier.flags = flags

cdef class CUstreamBatchMemOpParams_union:
    """
    Per-operation parameters for cuStreamBatchMemOp

    Attributes
    ----------
    operation : CUstreamBatchMemOpType
        Operation. This is the first field of all the union elemets and
        acts as a TAG to determine which union member is valid.
    waitValue : CUstreamMemOpWaitValueParams_st
        Params for CU_STREAM_MEM_OP_WAIT_VALUE_32 and
        CU_STREAM_MEM_OP_WAIT_VALUE_64 operations.
    writeValue : CUstreamMemOpWriteValueParams_st
        Params for CU_STREAM_MEM_OP_WRITE_VALUE_32 and
        CU_STREAM_MEM_OP_WRITE_VALUE_64 operations.
    flushRemoteWrites : CUstreamMemOpFlushRemoteWritesParams_st
        Params for CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES operations.
    memoryBarrier : CUstreamMemOpMemoryBarrierParams_st
        Params for CU_STREAM_MEM_OP_BARRIER operations.
    pad : list[cuuint64_t]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUstreamBatchMemOpParams_union *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._waitValue = CUstreamMemOpWaitValueParams_st(_ptr=<void_ptr>self._pvt_ptr)
        self._writeValue = CUstreamMemOpWriteValueParams_st(_ptr=<void_ptr>self._pvt_ptr)
        self._flushRemoteWrites = CUstreamMemOpFlushRemoteWritesParams_st(_ptr=<void_ptr>self._pvt_ptr)
        self._memoryBarrier = CUstreamMemOpMemoryBarrierParams_st(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['operation : ' + str(self.operation)]
            except ValueError:
                str_list += ['operation : <ValueError>']
            try:
                str_list += ['waitValue :\n' + '\n'.join(['    ' + line for line in str(self.waitValue).splitlines()])]
            except ValueError:
                str_list += ['waitValue : <ValueError>']
            try:
                str_list += ['writeValue :\n' + '\n'.join(['    ' + line for line in str(self.writeValue).splitlines()])]
            except ValueError:
                str_list += ['writeValue : <ValueError>']
            try:
                str_list += ['flushRemoteWrites :\n' + '\n'.join(['    ' + line for line in str(self.flushRemoteWrites).splitlines()])]
            except ValueError:
                str_list += ['flushRemoteWrites : <ValueError>']
            try:
                str_list += ['memoryBarrier :\n' + '\n'.join(['    ' + line for line in str(self.memoryBarrier).splitlines()])]
            except ValueError:
                str_list += ['memoryBarrier : <ValueError>']
            try:
                str_list += ['pad : ' + str(self.pad)]
            except ValueError:
                str_list += ['pad : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def operation(self):
        if self._pvt_ptr[0].operation not in _dict_CUstreamBatchMemOpType:
            return None
        return _dict_CUstreamBatchMemOpType[self._pvt_ptr[0].operation]
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        self._pvt_ptr[0].operation = operation.value
    @property
    def waitValue(self):
        return self._waitValue
    @waitValue.setter
    def waitValue(self, waitValue not None : CUstreamMemOpWaitValueParams_st):
        string.memcpy(&self._pvt_ptr[0].waitValue, <cydriver.CUstreamMemOpWaitValueParams_st*><void_ptr>waitValue.getPtr(), sizeof(self._pvt_ptr[0].waitValue))
    @property
    def writeValue(self):
        return self._writeValue
    @writeValue.setter
    def writeValue(self, writeValue not None : CUstreamMemOpWriteValueParams_st):
        string.memcpy(&self._pvt_ptr[0].writeValue, <cydriver.CUstreamMemOpWriteValueParams_st*><void_ptr>writeValue.getPtr(), sizeof(self._pvt_ptr[0].writeValue))
    @property
    def flushRemoteWrites(self):
        return self._flushRemoteWrites
    @flushRemoteWrites.setter
    def flushRemoteWrites(self, flushRemoteWrites not None : CUstreamMemOpFlushRemoteWritesParams_st):
        string.memcpy(&self._pvt_ptr[0].flushRemoteWrites, <cydriver.CUstreamMemOpFlushRemoteWritesParams_st*><void_ptr>flushRemoteWrites.getPtr(), sizeof(self._pvt_ptr[0].flushRemoteWrites))
    @property
    def memoryBarrier(self):
        return self._memoryBarrier
    @memoryBarrier.setter
    def memoryBarrier(self, memoryBarrier not None : CUstreamMemOpMemoryBarrierParams_st):
        string.memcpy(&self._pvt_ptr[0].memoryBarrier, <cydriver.CUstreamMemOpMemoryBarrierParams_st*><void_ptr>memoryBarrier.getPtr(), sizeof(self._pvt_ptr[0].memoryBarrier))
    @property
    def pad(self):
        return [cuuint64_t(init_value=_pad) for _pad in self._pvt_ptr[0].pad]
    @pad.setter
    def pad(self, pad):
        self._pvt_ptr[0].pad = pad


cdef class CUDA_BATCH_MEM_OP_NODE_PARAMS_v1_st:
    """
    Batch memory operation node parameters  Used in the legacy
    cuGraphAddBatchMemOpNode api. New code should use cuGraphAddNode()

    Attributes
    ----------
    ctx : CUcontext

    count : unsigned int

    paramArray : CUstreamBatchMemOpParams

    flags : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_BATCH_MEM_OP_NODE_PARAMS_v1_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._ctx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
        if self._paramArray is not NULL:
            free(self._paramArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            try:
                str_list += ['count : ' + str(self.count)]
            except ValueError:
                str_list += ['count : <ValueError>']
            try:
                str_list += ['paramArray : ' + str(self.paramArray)]
            except ValueError:
                str_list += ['paramArray : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cydriver.CUcontext cyctx
        if ctx is None:
            cyctx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(ctx, (CUcontext,)):
            pctx = int(ctx)
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        else:
            pctx = int(CUcontext(ctx))
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx
    @property
    def count(self):
        return self._pvt_ptr[0].count
    @count.setter
    def count(self, unsigned int count):
        self._pvt_ptr[0].count = count
    @property
    def paramArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramArray + x*sizeof(cydriver.CUstreamBatchMemOpParams) for x in range(self._paramArray_length)]
        return [CUstreamBatchMemOpParams(_ptr=arr) for arr in arrs]
    @paramArray.setter
    def paramArray(self, val):
        if len(val) == 0:
            free(self._paramArray)
            self._paramArray_length = 0
            self._pvt_ptr[0].paramArray = NULL
        else:
            if self._paramArray_length != <size_t>len(val):
                free(self._paramArray)
                self._paramArray = <cydriver.CUstreamBatchMemOpParams*> calloc(len(val), sizeof(cydriver.CUstreamBatchMemOpParams))
                if self._paramArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUstreamBatchMemOpParams)))
                self._paramArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramArray = self._paramArray
            for idx in range(len(val)):
                string.memcpy(&self._paramArray[idx], (<CUstreamBatchMemOpParams>val[idx])._pvt_ptr, sizeof(cydriver.CUstreamBatchMemOpParams))

    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class CUDA_BATCH_MEM_OP_NODE_PARAMS_v2_st:
    """
    Batch memory operation node parameters

    Attributes
    ----------
    ctx : CUcontext
        Context to use for the operations.
    count : unsigned int
        Number of operations in paramArray.
    paramArray : CUstreamBatchMemOpParams
        Array of batch memory operations.
    flags : unsigned int
        Flags to control the node.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_BATCH_MEM_OP_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._ctx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
        if self._paramArray is not NULL:
            free(self._paramArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            try:
                str_list += ['count : ' + str(self.count)]
            except ValueError:
                str_list += ['count : <ValueError>']
            try:
                str_list += ['paramArray : ' + str(self.paramArray)]
            except ValueError:
                str_list += ['paramArray : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cydriver.CUcontext cyctx
        if ctx is None:
            cyctx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(ctx, (CUcontext,)):
            pctx = int(ctx)
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        else:
            pctx = int(CUcontext(ctx))
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx
    @property
    def count(self):
        return self._pvt_ptr[0].count
    @count.setter
    def count(self, unsigned int count):
        self._pvt_ptr[0].count = count
    @property
    def paramArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramArray + x*sizeof(cydriver.CUstreamBatchMemOpParams) for x in range(self._paramArray_length)]
        return [CUstreamBatchMemOpParams(_ptr=arr) for arr in arrs]
    @paramArray.setter
    def paramArray(self, val):
        if len(val) == 0:
            free(self._paramArray)
            self._paramArray_length = 0
            self._pvt_ptr[0].paramArray = NULL
        else:
            if self._paramArray_length != <size_t>len(val):
                free(self._paramArray)
                self._paramArray = <cydriver.CUstreamBatchMemOpParams*> calloc(len(val), sizeof(cydriver.CUstreamBatchMemOpParams))
                if self._paramArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUstreamBatchMemOpParams)))
                self._paramArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramArray = self._paramArray
            for idx in range(len(val)):
                string.memcpy(&self._paramArray[idx], (<CUstreamBatchMemOpParams>val[idx])._pvt_ptr, sizeof(cydriver.CUstreamBatchMemOpParams))

    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class anon_struct0:
    """
    Attributes
    ----------
    bytesOverBudget : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUasyncNotificationInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].info.overBudget
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['bytesOverBudget : ' + str(self.bytesOverBudget)]
            except ValueError:
                str_list += ['bytesOverBudget : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def bytesOverBudget(self):
        return self._pvt_ptr[0].info.overBudget.bytesOverBudget
    @bytesOverBudget.setter
    def bytesOverBudget(self, unsigned long long bytesOverBudget):
        self._pvt_ptr[0].info.overBudget.bytesOverBudget = bytesOverBudget

cdef class anon_union2:
    """
    Attributes
    ----------
    overBudget : anon_struct0


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUasyncNotificationInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._overBudget = anon_struct0(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].info
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['overBudget :\n' + '\n'.join(['    ' + line for line in str(self.overBudget).splitlines()])]
            except ValueError:
                str_list += ['overBudget : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def overBudget(self):
        return self._overBudget
    @overBudget.setter
    def overBudget(self, overBudget not None : anon_struct0):
        string.memcpy(&self._pvt_ptr[0].info.overBudget, <cydriver.anon_struct0*><void_ptr>overBudget.getPtr(), sizeof(self._pvt_ptr[0].info.overBudget))

cdef class CUasyncNotificationInfo_st:
    """
    Information passed to the user via the async notification callback

    Attributes
    ----------
    type : CUasyncNotificationType
        The type of notification being sent
    info : anon_union2
        Information about the notification. `typename` must be checked in
        order to interpret this field.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUasyncNotificationInfo_st *>calloc(1, sizeof(cydriver.CUasyncNotificationInfo_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUasyncNotificationInfo_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._info = anon_union2(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['info :\n' + '\n'.join(['    ' + line for line in str(self.info).splitlines()])]
            except ValueError:
                str_list += ['info : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUasyncNotificationType:
            return None
        return _dict_CUasyncNotificationType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUasyncNotificationType):
        self._pvt_ptr[0].type = type.value
    @property
    def info(self):
        return self._info
    @info.setter
    def info(self, info not None : anon_union2):
        string.memcpy(&self._pvt_ptr[0].info, <cydriver.anon_union2*><void_ptr>info.getPtr(), sizeof(self._pvt_ptr[0].info))

cdef class CUdevprop_st:
    """
    Legacy device properties

    Attributes
    ----------
    maxThreadsPerBlock : int
        Maximum number of threads per block
    maxThreadsDim : list[int]
        Maximum size of each dimension of a block
    maxGridSize : list[int]
        Maximum size of each dimension of a grid
    sharedMemPerBlock : int
        Shared memory available per block in bytes
    totalConstantMemory : int
        Constant memory available on device in bytes
    SIMDWidth : int
        Warp size in threads
    memPitch : int
        Maximum pitch in bytes allowed by memory copies
    regsPerBlock : int
        32-bit registers available per block
    clockRate : int
        Clock frequency in kilohertz
    textureAlign : int
        Alignment requirement for textures

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUdevprop_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['maxThreadsPerBlock : ' + str(self.maxThreadsPerBlock)]
            except ValueError:
                str_list += ['maxThreadsPerBlock : <ValueError>']
            try:
                str_list += ['maxThreadsDim : ' + str(self.maxThreadsDim)]
            except ValueError:
                str_list += ['maxThreadsDim : <ValueError>']
            try:
                str_list += ['maxGridSize : ' + str(self.maxGridSize)]
            except ValueError:
                str_list += ['maxGridSize : <ValueError>']
            try:
                str_list += ['sharedMemPerBlock : ' + str(self.sharedMemPerBlock)]
            except ValueError:
                str_list += ['sharedMemPerBlock : <ValueError>']
            try:
                str_list += ['totalConstantMemory : ' + str(self.totalConstantMemory)]
            except ValueError:
                str_list += ['totalConstantMemory : <ValueError>']
            try:
                str_list += ['SIMDWidth : ' + str(self.SIMDWidth)]
            except ValueError:
                str_list += ['SIMDWidth : <ValueError>']
            try:
                str_list += ['memPitch : ' + str(self.memPitch)]
            except ValueError:
                str_list += ['memPitch : <ValueError>']
            try:
                str_list += ['regsPerBlock : ' + str(self.regsPerBlock)]
            except ValueError:
                str_list += ['regsPerBlock : <ValueError>']
            try:
                str_list += ['clockRate : ' + str(self.clockRate)]
            except ValueError:
                str_list += ['clockRate : <ValueError>']
            try:
                str_list += ['textureAlign : ' + str(self.textureAlign)]
            except ValueError:
                str_list += ['textureAlign : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def maxThreadsPerBlock(self):
        return self._pvt_ptr[0].maxThreadsPerBlock
    @maxThreadsPerBlock.setter
    def maxThreadsPerBlock(self, int maxThreadsPerBlock):
        self._pvt_ptr[0].maxThreadsPerBlock = maxThreadsPerBlock
    @property
    def maxThreadsDim(self):
        return self._pvt_ptr[0].maxThreadsDim
    @maxThreadsDim.setter
    def maxThreadsDim(self, maxThreadsDim):
        self._pvt_ptr[0].maxThreadsDim = maxThreadsDim
    @property
    def maxGridSize(self):
        return self._pvt_ptr[0].maxGridSize
    @maxGridSize.setter
    def maxGridSize(self, maxGridSize):
        self._pvt_ptr[0].maxGridSize = maxGridSize
    @property
    def sharedMemPerBlock(self):
        return self._pvt_ptr[0].sharedMemPerBlock
    @sharedMemPerBlock.setter
    def sharedMemPerBlock(self, int sharedMemPerBlock):
        self._pvt_ptr[0].sharedMemPerBlock = sharedMemPerBlock
    @property
    def totalConstantMemory(self):
        return self._pvt_ptr[0].totalConstantMemory
    @totalConstantMemory.setter
    def totalConstantMemory(self, int totalConstantMemory):
        self._pvt_ptr[0].totalConstantMemory = totalConstantMemory
    @property
    def SIMDWidth(self):
        return self._pvt_ptr[0].SIMDWidth
    @SIMDWidth.setter
    def SIMDWidth(self, int SIMDWidth):
        self._pvt_ptr[0].SIMDWidth = SIMDWidth
    @property
    def memPitch(self):
        return self._pvt_ptr[0].memPitch
    @memPitch.setter
    def memPitch(self, int memPitch):
        self._pvt_ptr[0].memPitch = memPitch
    @property
    def regsPerBlock(self):
        return self._pvt_ptr[0].regsPerBlock
    @regsPerBlock.setter
    def regsPerBlock(self, int regsPerBlock):
        self._pvt_ptr[0].regsPerBlock = regsPerBlock
    @property
    def clockRate(self):
        return self._pvt_ptr[0].clockRate
    @clockRate.setter
    def clockRate(self, int clockRate):
        self._pvt_ptr[0].clockRate = clockRate
    @property
    def textureAlign(self):
        return self._pvt_ptr[0].textureAlign
    @textureAlign.setter
    def textureAlign(self, int textureAlign):
        self._pvt_ptr[0].textureAlign = textureAlign

cdef class CUaccessPolicyWindow_st:
    """
    Specifies an access policy for a window, a contiguous extent of
    memory beginning at base_ptr and ending at base_ptr + num_bytes.
    num_bytes is limited by
    CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE. Partition into
    many segments and assign segments such that: sum of "hit segments"
    / window == approx. ratio. sum of "miss segments" / window ==
    approx 1-ratio. Segments and ratio specifications are fitted to the
    capabilities of the architecture. Accesses in a hit segment apply
    the hitProp access policy. Accesses in a miss segment apply the
    missProp access policy.

    Attributes
    ----------
    base_ptr : Any
        Starting address of the access policy window. CUDA driver may align
        it.
    num_bytes : size_t
        Size in bytes of the window policy. CUDA driver may restrict the
        maximum size and alignment.
    hitRatio : float
        hitRatio specifies percentage of lines assigned hitProp, rest are
        assigned missProp.
    hitProp : CUaccessProperty
        CUaccessProperty set for hit.
    missProp : CUaccessProperty
        CUaccessProperty set for miss. Must be either NORMAL or STREAMING

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUaccessPolicyWindow_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['base_ptr : ' + hex(self.base_ptr)]
            except ValueError:
                str_list += ['base_ptr : <ValueError>']
            try:
                str_list += ['num_bytes : ' + str(self.num_bytes)]
            except ValueError:
                str_list += ['num_bytes : <ValueError>']
            try:
                str_list += ['hitRatio : ' + str(self.hitRatio)]
            except ValueError:
                str_list += ['hitRatio : <ValueError>']
            try:
                str_list += ['hitProp : ' + str(self.hitProp)]
            except ValueError:
                str_list += ['hitProp : <ValueError>']
            try:
                str_list += ['missProp : ' + str(self.missProp)]
            except ValueError:
                str_list += ['missProp : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def base_ptr(self):
        return <void_ptr>self._pvt_ptr[0].base_ptr
    @base_ptr.setter
    def base_ptr(self, base_ptr):
        _cbase_ptr = _HelperInputVoidPtr(base_ptr)
        self._pvt_ptr[0].base_ptr = <void*><void_ptr>_cbase_ptr.cptr
    @property
    def num_bytes(self):
        return self._pvt_ptr[0].num_bytes
    @num_bytes.setter
    def num_bytes(self, size_t num_bytes):
        self._pvt_ptr[0].num_bytes = num_bytes
    @property
    def hitRatio(self):
        return self._pvt_ptr[0].hitRatio
    @hitRatio.setter
    def hitRatio(self, float hitRatio):
        self._pvt_ptr[0].hitRatio = hitRatio
    @property
    def hitProp(self):
        if self._pvt_ptr[0].hitProp not in _dict_CUaccessProperty:
            return None
        return _dict_CUaccessProperty[self._pvt_ptr[0].hitProp]
    @hitProp.setter
    def hitProp(self, hitProp not None : CUaccessProperty):
        self._pvt_ptr[0].hitProp = hitProp.value
    @property
    def missProp(self):
        if self._pvt_ptr[0].missProp not in _dict_CUaccessProperty:
            return None
        return _dict_CUaccessProperty[self._pvt_ptr[0].missProp]
    @missProp.setter
    def missProp(self, missProp not None : CUaccessProperty):
        self._pvt_ptr[0].missProp = missProp.value

cdef class CUDA_KERNEL_NODE_PARAMS_st:
    """
    GPU kernel node parameters

    Attributes
    ----------
    func : CUfunction
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    kernelParams : Any
        Array of pointers to kernel parameters
    extra : Any
        Extra options

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_KERNEL_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._func = CUfunction(_ptr=<void_ptr>&self._pvt_ptr[0].func)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['func : ' + str(self.func)]
            except ValueError:
                str_list += ['func : <ValueError>']
            try:
                str_list += ['gridDimX : ' + str(self.gridDimX)]
            except ValueError:
                str_list += ['gridDimX : <ValueError>']
            try:
                str_list += ['gridDimY : ' + str(self.gridDimY)]
            except ValueError:
                str_list += ['gridDimY : <ValueError>']
            try:
                str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            except ValueError:
                str_list += ['gridDimZ : <ValueError>']
            try:
                str_list += ['blockDimX : ' + str(self.blockDimX)]
            except ValueError:
                str_list += ['blockDimX : <ValueError>']
            try:
                str_list += ['blockDimY : ' + str(self.blockDimY)]
            except ValueError:
                str_list += ['blockDimY : <ValueError>']
            try:
                str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            except ValueError:
                str_list += ['blockDimZ : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['kernelParams : ' + str(self.kernelParams)]
            except ValueError:
                str_list += ['kernelParams : <ValueError>']
            try:
                str_list += ['extra : ' + str(self.extra)]
            except ValueError:
                str_list += ['extra : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def func(self):
        return self._func
    @func.setter
    def func(self, func):
        cdef cydriver.CUfunction cyfunc
        if func is None:
            cyfunc = <cydriver.CUfunction><void_ptr>0
        elif isinstance(func, (CUfunction,)):
            pfunc = int(func)
            cyfunc = <cydriver.CUfunction><void_ptr>pfunc
        else:
            pfunc = int(CUfunction(func))
            cyfunc = <cydriver.CUfunction><void_ptr>pfunc
        self._func._pvt_ptr[0] = cyfunc
    @property
    def gridDimX(self):
        return self._pvt_ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        self._pvt_ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._pvt_ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        self._pvt_ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._pvt_ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        self._pvt_ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._pvt_ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        self._pvt_ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._pvt_ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        self._pvt_ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._pvt_ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        self._pvt_ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def kernelParams(self):
        return <void_ptr>self._pvt_ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._cykernelParams = _HelperKernelParams(kernelParams)
        self._pvt_ptr[0].kernelParams = <void**><void_ptr>self._cykernelParams.ckernelParams
    @property
    def extra(self):
        return <void_ptr>self._pvt_ptr[0].extra
    @extra.setter
    def extra(self, void_ptr extra):
        self._pvt_ptr[0].extra = <void**>extra

cdef class CUDA_KERNEL_NODE_PARAMS_v2_st:
    """
    GPU kernel node parameters

    Attributes
    ----------
    func : CUfunction
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    kernelParams : Any
        Array of pointers to kernel parameters
    extra : Any
        Extra options
    kern : CUkernel
        Kernel to launch, will only be referenced if func is NULL
    ctx : CUcontext
        Context for the kernel task to run in. The value NULL will indicate
        the current context should be used by the api. This field is
        ignored if func is set.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_KERNEL_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._func = CUfunction(_ptr=<void_ptr>&self._pvt_ptr[0].func)
        self._kern = CUkernel(_ptr=<void_ptr>&self._pvt_ptr[0].kern)
        self._ctx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['func : ' + str(self.func)]
            except ValueError:
                str_list += ['func : <ValueError>']
            try:
                str_list += ['gridDimX : ' + str(self.gridDimX)]
            except ValueError:
                str_list += ['gridDimX : <ValueError>']
            try:
                str_list += ['gridDimY : ' + str(self.gridDimY)]
            except ValueError:
                str_list += ['gridDimY : <ValueError>']
            try:
                str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            except ValueError:
                str_list += ['gridDimZ : <ValueError>']
            try:
                str_list += ['blockDimX : ' + str(self.blockDimX)]
            except ValueError:
                str_list += ['blockDimX : <ValueError>']
            try:
                str_list += ['blockDimY : ' + str(self.blockDimY)]
            except ValueError:
                str_list += ['blockDimY : <ValueError>']
            try:
                str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            except ValueError:
                str_list += ['blockDimZ : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['kernelParams : ' + str(self.kernelParams)]
            except ValueError:
                str_list += ['kernelParams : <ValueError>']
            try:
                str_list += ['extra : ' + str(self.extra)]
            except ValueError:
                str_list += ['extra : <ValueError>']
            try:
                str_list += ['kern : ' + str(self.kern)]
            except ValueError:
                str_list += ['kern : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def func(self):
        return self._func
    @func.setter
    def func(self, func):
        cdef cydriver.CUfunction cyfunc
        if func is None:
            cyfunc = <cydriver.CUfunction><void_ptr>0
        elif isinstance(func, (CUfunction,)):
            pfunc = int(func)
            cyfunc = <cydriver.CUfunction><void_ptr>pfunc
        else:
            pfunc = int(CUfunction(func))
            cyfunc = <cydriver.CUfunction><void_ptr>pfunc
        self._func._pvt_ptr[0] = cyfunc
    @property
    def gridDimX(self):
        return self._pvt_ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        self._pvt_ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._pvt_ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        self._pvt_ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._pvt_ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        self._pvt_ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._pvt_ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        self._pvt_ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._pvt_ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        self._pvt_ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._pvt_ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        self._pvt_ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def kernelParams(self):
        return <void_ptr>self._pvt_ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._cykernelParams = _HelperKernelParams(kernelParams)
        self._pvt_ptr[0].kernelParams = <void**><void_ptr>self._cykernelParams.ckernelParams
    @property
    def extra(self):
        return <void_ptr>self._pvt_ptr[0].extra
    @extra.setter
    def extra(self, void_ptr extra):
        self._pvt_ptr[0].extra = <void**>extra
    @property
    def kern(self):
        return self._kern
    @kern.setter
    def kern(self, kern):
        cdef cydriver.CUkernel cykern
        if kern is None:
            cykern = <cydriver.CUkernel><void_ptr>0
        elif isinstance(kern, (CUkernel,)):
            pkern = int(kern)
            cykern = <cydriver.CUkernel><void_ptr>pkern
        else:
            pkern = int(CUkernel(kern))
            cykern = <cydriver.CUkernel><void_ptr>pkern
        self._kern._pvt_ptr[0] = cykern
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cydriver.CUcontext cyctx
        if ctx is None:
            cyctx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(ctx, (CUcontext,)):
            pctx = int(ctx)
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        else:
            pctx = int(CUcontext(ctx))
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class CUDA_KERNEL_NODE_PARAMS_v3_st:
    """
    GPU kernel node parameters

    Attributes
    ----------
    func : CUfunction
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    kernelParams : Any
        Array of pointers to kernel parameters
    extra : Any
        Extra options
    kern : CUkernel
        Kernel to launch, will only be referenced if func is NULL
    ctx : CUcontext
        Context for the kernel task to run in. The value NULL will indicate
        the current context should be used by the api. This field is
        ignored if func is set.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_KERNEL_NODE_PARAMS_v3_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._func = CUfunction(_ptr=<void_ptr>&self._pvt_ptr[0].func)
        self._kern = CUkernel(_ptr=<void_ptr>&self._pvt_ptr[0].kern)
        self._ctx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['func : ' + str(self.func)]
            except ValueError:
                str_list += ['func : <ValueError>']
            try:
                str_list += ['gridDimX : ' + str(self.gridDimX)]
            except ValueError:
                str_list += ['gridDimX : <ValueError>']
            try:
                str_list += ['gridDimY : ' + str(self.gridDimY)]
            except ValueError:
                str_list += ['gridDimY : <ValueError>']
            try:
                str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            except ValueError:
                str_list += ['gridDimZ : <ValueError>']
            try:
                str_list += ['blockDimX : ' + str(self.blockDimX)]
            except ValueError:
                str_list += ['blockDimX : <ValueError>']
            try:
                str_list += ['blockDimY : ' + str(self.blockDimY)]
            except ValueError:
                str_list += ['blockDimY : <ValueError>']
            try:
                str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            except ValueError:
                str_list += ['blockDimZ : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['kernelParams : ' + str(self.kernelParams)]
            except ValueError:
                str_list += ['kernelParams : <ValueError>']
            try:
                str_list += ['extra : ' + str(self.extra)]
            except ValueError:
                str_list += ['extra : <ValueError>']
            try:
                str_list += ['kern : ' + str(self.kern)]
            except ValueError:
                str_list += ['kern : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def func(self):
        return self._func
    @func.setter
    def func(self, func):
        cdef cydriver.CUfunction cyfunc
        if func is None:
            cyfunc = <cydriver.CUfunction><void_ptr>0
        elif isinstance(func, (CUfunction,)):
            pfunc = int(func)
            cyfunc = <cydriver.CUfunction><void_ptr>pfunc
        else:
            pfunc = int(CUfunction(func))
            cyfunc = <cydriver.CUfunction><void_ptr>pfunc
        self._func._pvt_ptr[0] = cyfunc
    @property
    def gridDimX(self):
        return self._pvt_ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        self._pvt_ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._pvt_ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        self._pvt_ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._pvt_ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        self._pvt_ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._pvt_ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        self._pvt_ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._pvt_ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        self._pvt_ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._pvt_ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        self._pvt_ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def kernelParams(self):
        return <void_ptr>self._pvt_ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._cykernelParams = _HelperKernelParams(kernelParams)
        self._pvt_ptr[0].kernelParams = <void**><void_ptr>self._cykernelParams.ckernelParams
    @property
    def extra(self):
        return <void_ptr>self._pvt_ptr[0].extra
    @extra.setter
    def extra(self, void_ptr extra):
        self._pvt_ptr[0].extra = <void**>extra
    @property
    def kern(self):
        return self._kern
    @kern.setter
    def kern(self, kern):
        cdef cydriver.CUkernel cykern
        if kern is None:
            cykern = <cydriver.CUkernel><void_ptr>0
        elif isinstance(kern, (CUkernel,)):
            pkern = int(kern)
            cykern = <cydriver.CUkernel><void_ptr>pkern
        else:
            pkern = int(CUkernel(kern))
            cykern = <cydriver.CUkernel><void_ptr>pkern
        self._kern._pvt_ptr[0] = cykern
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cydriver.CUcontext cyctx
        if ctx is None:
            cyctx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(ctx, (CUcontext,)):
            pctx = int(ctx)
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        else:
            pctx = int(CUcontext(ctx))
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class CUDA_MEMSET_NODE_PARAMS_st:
    """
    Memset node parameters

    Attributes
    ----------
    dst : CUdeviceptr
        Destination device pointer
    pitch : size_t
        Pitch of destination device pointer. Unused if height is 1
    value : unsigned int
        Value to be set
    elementSize : unsigned int
        Size of each element in bytes. Must be 1, 2, or 4.
    width : size_t
        Width of the row in elements
    height : size_t
        Number of rows

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMSET_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._dst = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dst)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['dst : ' + str(self.dst)]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            try:
                str_list += ['elementSize : ' + str(self.elementSize)]
            except ValueError:
                str_list += ['elementSize : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def dst(self):
        return self._dst
    @dst.setter
    def dst(self, dst):
        cdef cydriver.CUdeviceptr cydst
        if dst is None:
            cydst = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dst, (CUdeviceptr)):
            pdst = int(dst)
            cydst = <cydriver.CUdeviceptr><void_ptr>pdst
        else:
            pdst = int(CUdeviceptr(dst))
            cydst = <cydriver.CUdeviceptr><void_ptr>pdst
        self._dst._pvt_ptr[0] = cydst

    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, size_t pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def value(self):
        return self._pvt_ptr[0].value
    @value.setter
    def value(self, unsigned int value):
        self._pvt_ptr[0].value = value
    @property
    def elementSize(self):
        return self._pvt_ptr[0].elementSize
    @elementSize.setter
    def elementSize(self, unsigned int elementSize):
        self._pvt_ptr[0].elementSize = elementSize
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height

cdef class CUDA_MEMSET_NODE_PARAMS_v2_st:
    """
    Memset node parameters

    Attributes
    ----------
    dst : CUdeviceptr
        Destination device pointer
    pitch : size_t
        Pitch of destination device pointer. Unused if height is 1
    value : unsigned int
        Value to be set
    elementSize : unsigned int
        Size of each element in bytes. Must be 1, 2, or 4.
    width : size_t
        Width of the row in elements
    height : size_t
        Number of rows
    ctx : CUcontext
        Context on which to run the node

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMSET_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._dst = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dst)
        self._ctx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['dst : ' + str(self.dst)]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            try:
                str_list += ['elementSize : ' + str(self.elementSize)]
            except ValueError:
                str_list += ['elementSize : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def dst(self):
        return self._dst
    @dst.setter
    def dst(self, dst):
        cdef cydriver.CUdeviceptr cydst
        if dst is None:
            cydst = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dst, (CUdeviceptr)):
            pdst = int(dst)
            cydst = <cydriver.CUdeviceptr><void_ptr>pdst
        else:
            pdst = int(CUdeviceptr(dst))
            cydst = <cydriver.CUdeviceptr><void_ptr>pdst
        self._dst._pvt_ptr[0] = cydst

    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, size_t pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def value(self):
        return self._pvt_ptr[0].value
    @value.setter
    def value(self, unsigned int value):
        self._pvt_ptr[0].value = value
    @property
    def elementSize(self):
        return self._pvt_ptr[0].elementSize
    @elementSize.setter
    def elementSize(self, unsigned int elementSize):
        self._pvt_ptr[0].elementSize = elementSize
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cydriver.CUcontext cyctx
        if ctx is None:
            cyctx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(ctx, (CUcontext,)):
            pctx = int(ctx)
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        else:
            pctx = int(CUcontext(ctx))
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class CUDA_HOST_NODE_PARAMS_st:
    """
    Host node parameters

    Attributes
    ----------
    fn : CUhostFn
        The function to call when the node executes
    userData : Any
        Argument to pass to the function

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_HOST_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._fn = CUhostFn(_ptr=<void_ptr>&self._pvt_ptr[0].fn)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fn : ' + str(self.fn)]
            except ValueError:
                str_list += ['fn : <ValueError>']
            try:
                str_list += ['userData : ' + hex(self.userData)]
            except ValueError:
                str_list += ['userData : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fn(self):
        return self._fn
    @fn.setter
    def fn(self, fn):
        cdef cydriver.CUhostFn cyfn
        if fn is None:
            cyfn = <cydriver.CUhostFn><void_ptr>0
        elif isinstance(fn, (CUhostFn)):
            pfn = int(fn)
            cyfn = <cydriver.CUhostFn><void_ptr>pfn
        else:
            pfn = int(CUhostFn(fn))
            cyfn = <cydriver.CUhostFn><void_ptr>pfn
        self._fn._pvt_ptr[0] = cyfn
    @property
    def userData(self):
        return <void_ptr>self._pvt_ptr[0].userData
    @userData.setter
    def userData(self, userData):
        _cuserData = _HelperInputVoidPtr(userData)
        self._pvt_ptr[0].userData = <void*><void_ptr>_cuserData.cptr

cdef class CUDA_HOST_NODE_PARAMS_v2_st:
    """
    Host node parameters

    Attributes
    ----------
    fn : CUhostFn
        The function to call when the node executes
    userData : Any
        Argument to pass to the function

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_HOST_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._fn = CUhostFn(_ptr=<void_ptr>&self._pvt_ptr[0].fn)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fn : ' + str(self.fn)]
            except ValueError:
                str_list += ['fn : <ValueError>']
            try:
                str_list += ['userData : ' + hex(self.userData)]
            except ValueError:
                str_list += ['userData : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fn(self):
        return self._fn
    @fn.setter
    def fn(self, fn):
        cdef cydriver.CUhostFn cyfn
        if fn is None:
            cyfn = <cydriver.CUhostFn><void_ptr>0
        elif isinstance(fn, (CUhostFn)):
            pfn = int(fn)
            cyfn = <cydriver.CUhostFn><void_ptr>pfn
        else:
            pfn = int(CUhostFn(fn))
            cyfn = <cydriver.CUhostFn><void_ptr>pfn
        self._fn._pvt_ptr[0] = cyfn
    @property
    def userData(self):
        return <void_ptr>self._pvt_ptr[0].userData
    @userData.setter
    def userData(self, userData):
        _cuserData = _HelperInputVoidPtr(userData)
        self._pvt_ptr[0].userData = <void*><void_ptr>_cuserData.cptr

cdef class CUDA_CONDITIONAL_NODE_PARAMS:
    """
    Conditional node parameters

    Attributes
    ----------
    handle : CUgraphConditionalHandle
        Conditional node handle. Handles must be created in advance of
        creating the node using cuGraphConditionalHandleCreate.
    type : CUgraphConditionalNodeType
        Type of conditional node.
    size : unsigned int
        Size of graph output array. Allowed values are 1 for
        CU_GRAPH_COND_TYPE_WHILE, 1 or 2 for CU_GRAPH_COND_TYPE_IF, or any
        value greater than zero for CU_GRAPH_COND_TYPE_SWITCH.
    phGraph_out : CUgraph
        CUDA-owned array populated with conditional node child graphs
        during creation of the node. Valid for the lifetime of the
        conditional node. The contents of the graph(s) are subject to the
        following constraints:   - Allowed node types are kernel nodes,
        empty nodes, child graphs, memsets, memcopies, and conditionals.
        This applies recursively to child graphs and conditional bodies.
        - All kernels, including kernels in nested conditionals or child
        graphs at any level, must belong to the same CUDA context.
        These graphs may be populated using graph node creation APIs or
        cuStreamBeginCaptureToGraph.  CU_GRAPH_COND_TYPE_IF: phGraph_out[0]
        is executed when the condition is non-zero. If `size` == 2,
        phGraph_out[1] will be executed when the condition is zero.
        CU_GRAPH_COND_TYPE_WHILE: phGraph_out[0] is executed as long as the
        condition is non-zero. CU_GRAPH_COND_TYPE_SWITCH: phGraph_out[n] is
        executed when the condition is equal to n. If the condition >=
        `size`, no body graph is executed.
    ctx : CUcontext
        Context on which to run the node. Must match context used to create
        the handle and all body nodes.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_CONDITIONAL_NODE_PARAMS *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._handle = CUgraphConditionalHandle(_ptr=<void_ptr>&self._pvt_ptr[0].handle)
        self._ctx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['handle : ' + str(self.handle)]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['phGraph_out : ' + str(self.phGraph_out)]
            except ValueError:
                str_list += ['phGraph_out : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle):
        cdef cydriver.CUgraphConditionalHandle cyhandle
        if handle is None:
            cyhandle = <cydriver.CUgraphConditionalHandle><void_ptr>0
        elif isinstance(handle, (CUgraphConditionalHandle)):
            phandle = int(handle)
            cyhandle = <cydriver.CUgraphConditionalHandle><void_ptr>phandle
        else:
            phandle = int(CUgraphConditionalHandle(handle))
            cyhandle = <cydriver.CUgraphConditionalHandle><void_ptr>phandle
        self._handle._pvt_ptr[0] = cyhandle

    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUgraphConditionalNodeType:
            return None
        return _dict_CUgraphConditionalNodeType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUgraphConditionalNodeType):
        self._pvt_ptr[0].type = type.value
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, unsigned int size):
        self._pvt_ptr[0].size = size
    @property
    def phGraph_out(self):
        arrs = [<void_ptr>self._pvt_ptr[0].phGraph_out + x*sizeof(cydriver.CUgraph) for x in range(self.size)]
        return [CUgraph(_ptr=arr) for arr in arrs]
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cydriver.CUcontext cyctx
        if ctx is None:
            cyctx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(ctx, (CUcontext,)):
            pctx = int(ctx)
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        else:
            pctx = int(CUcontext(ctx))
            cyctx = <cydriver.CUcontext><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class CUgraphEdgeData_st:
    """
    Optional annotation for edges in a CUDA graph. Note, all edges
    implicitly have annotations and default to a zero-initialized value
    if not specified. A zero-initialized struct indicates a standard
    full serialization of two nodes with memory visibility.

    Attributes
    ----------
    from_port : bytes
        This indicates when the dependency is triggered from the upstream
        node on the edge. The meaning is specfic to the node type. A value
        of 0 in all cases means full completion of the upstream node, with
        memory visibility to the downstream node or portion thereof
        (indicated by `to_port`).   Only kernel nodes define non-zero
        ports. A kernel node can use the following output port types:
        CU_GRAPH_KERNEL_NODE_PORT_DEFAULT,
        CU_GRAPH_KERNEL_NODE_PORT_PROGRAMMATIC, or
        CU_GRAPH_KERNEL_NODE_PORT_LAUNCH_ORDER.
    to_port : bytes
        This indicates what portion of the downstream node is dependent on
        the upstream node or portion thereof (indicated by `from_port`).
        The meaning is specific to the node type. A value of 0 in all cases
        means the entirety of the downstream node is dependent on the
        upstream work.   Currently no node types define non-zero ports.
        Accordingly, this field must be set to zero.
    type : bytes
        This should be populated with a value from CUgraphDependencyType.
        (It is typed as char due to compiler-specific layout of bitfields.)
        See CUgraphDependencyType.
    reserved : bytes
        These bytes are unused and must be zeroed. This ensures
        compatibility if additional fields are added in the future.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUgraphEdgeData_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['from_port : ' + str(self.from_port)]
            except ValueError:
                str_list += ['from_port : <ValueError>']
            try:
                str_list += ['to_port : ' + str(self.to_port)]
            except ValueError:
                str_list += ['to_port : <ValueError>']
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def from_port(self):
        return self._pvt_ptr[0].from_port
    @from_port.setter
    def from_port(self, unsigned char from_port):
        self._pvt_ptr[0].from_port = from_port
    @property
    def to_port(self):
        return self._pvt_ptr[0].to_port
    @to_port.setter
    def to_port(self, unsigned char to_port):
        self._pvt_ptr[0].to_port = to_port
    @property
    def type(self):
        return self._pvt_ptr[0].type
    @type.setter
    def type(self, unsigned char type):
        self._pvt_ptr[0].type = type
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 5)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 5:
            raise ValueError("reserved length must be 5, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class CUDA_GRAPH_INSTANTIATE_PARAMS_st:
    """
    Graph instantiation parameters

    Attributes
    ----------
    flags : cuuint64_t
        Instantiation flags
    hUploadStream : CUstream
        Upload stream
    hErrNode_out : CUgraphNode
        The node which caused instantiation to fail, if any
    result_out : CUgraphInstantiateResult
        Whether instantiation was successful. If it failed, the reason why

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_GRAPH_INSTANTIATE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._flags = cuuint64_t(_ptr=<void_ptr>&self._pvt_ptr[0].flags)
        self._hUploadStream = CUstream(_ptr=<void_ptr>&self._pvt_ptr[0].hUploadStream)
        self._hErrNode_out = CUgraphNode(_ptr=<void_ptr>&self._pvt_ptr[0].hErrNode_out)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['hUploadStream : ' + str(self.hUploadStream)]
            except ValueError:
                str_list += ['hUploadStream : <ValueError>']
            try:
                str_list += ['hErrNode_out : ' + str(self.hErrNode_out)]
            except ValueError:
                str_list += ['hErrNode_out : <ValueError>']
            try:
                str_list += ['result_out : ' + str(self.result_out)]
            except ValueError:
                str_list += ['result_out : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def flags(self):
        return self._flags
    @flags.setter
    def flags(self, flags):
        cdef cydriver.cuuint64_t cyflags
        if flags is None:
            cyflags = <cydriver.cuuint64_t><void_ptr>0
        elif isinstance(flags, (cuuint64_t)):
            pflags = int(flags)
            cyflags = <cydriver.cuuint64_t><void_ptr>pflags
        else:
            pflags = int(cuuint64_t(flags))
            cyflags = <cydriver.cuuint64_t><void_ptr>pflags
        self._flags._pvt_ptr[0] = cyflags

    @property
    def hUploadStream(self):
        return self._hUploadStream
    @hUploadStream.setter
    def hUploadStream(self, hUploadStream):
        cdef cydriver.CUstream cyhUploadStream
        if hUploadStream is None:
            cyhUploadStream = <cydriver.CUstream><void_ptr>0
        elif isinstance(hUploadStream, (CUstream,)):
            phUploadStream = int(hUploadStream)
            cyhUploadStream = <cydriver.CUstream><void_ptr>phUploadStream
        else:
            phUploadStream = int(CUstream(hUploadStream))
            cyhUploadStream = <cydriver.CUstream><void_ptr>phUploadStream
        self._hUploadStream._pvt_ptr[0] = cyhUploadStream
    @property
    def hErrNode_out(self):
        return self._hErrNode_out
    @hErrNode_out.setter
    def hErrNode_out(self, hErrNode_out):
        cdef cydriver.CUgraphNode cyhErrNode_out
        if hErrNode_out is None:
            cyhErrNode_out = <cydriver.CUgraphNode><void_ptr>0
        elif isinstance(hErrNode_out, (CUgraphNode,)):
            phErrNode_out = int(hErrNode_out)
            cyhErrNode_out = <cydriver.CUgraphNode><void_ptr>phErrNode_out
        else:
            phErrNode_out = int(CUgraphNode(hErrNode_out))
            cyhErrNode_out = <cydriver.CUgraphNode><void_ptr>phErrNode_out
        self._hErrNode_out._pvt_ptr[0] = cyhErrNode_out
    @property
    def result_out(self):
        if self._pvt_ptr[0].result_out not in _dict_CUgraphInstantiateResult:
            return None
        return _dict_CUgraphInstantiateResult[self._pvt_ptr[0].result_out]
    @result_out.setter
    def result_out(self, result_out not None : CUgraphInstantiateResult):
        self._pvt_ptr[0].result_out = result_out.value

cdef class CUlaunchMemSyncDomainMap_st:
    """
    Memory Synchronization Domain map  See ::cudaLaunchMemSyncDomain.
    By default, kernels are launched in domain 0. Kernel launched with
    CU_LAUNCH_MEM_SYNC_DOMAIN_REMOTE will have a different domain ID.
    User may also alter the domain ID with CUlaunchMemSyncDomainMap for
    a specific stream / graph node / kernel launch. See
    CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP.  Domain ID range is
    available through CU_DEVICE_ATTRIBUTE_MEM_SYNC_DOMAIN_COUNT.

    Attributes
    ----------
    default_ : bytes
        The default domain ID to use for designated kernels
    remote : bytes
        The remote domain ID to use for designated kernels

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUlaunchMemSyncDomainMap_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['default_ : ' + str(self.default_)]
            except ValueError:
                str_list += ['default_ : <ValueError>']
            try:
                str_list += ['remote : ' + str(self.remote)]
            except ValueError:
                str_list += ['remote : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def default_(self):
        return self._pvt_ptr[0].default_
    @default_.setter
    def default_(self, unsigned char default_):
        self._pvt_ptr[0].default_ = default_
    @property
    def remote(self):
        return self._pvt_ptr[0].remote
    @remote.setter
    def remote(self, unsigned char remote):
        self._pvt_ptr[0].remote = remote

cdef class anon_struct1:
    """
    Attributes
    ----------
    x : unsigned int

    y : unsigned int

    z : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUlaunchAttributeValue_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].clusterDim
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].clusterDim.x
    @x.setter
    def x(self, unsigned int x):
        self._pvt_ptr[0].clusterDim.x = x
    @property
    def y(self):
        return self._pvt_ptr[0].clusterDim.y
    @y.setter
    def y(self, unsigned int y):
        self._pvt_ptr[0].clusterDim.y = y
    @property
    def z(self):
        return self._pvt_ptr[0].clusterDim.z
    @z.setter
    def z(self, unsigned int z):
        self._pvt_ptr[0].clusterDim.z = z

cdef class anon_struct2:
    """
    Attributes
    ----------
    event : CUevent

    flags : int

    triggerAtBlockStart : int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUlaunchAttributeValue_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._event = CUevent(_ptr=<void_ptr>&self._pvt_ptr[0].programmaticEvent.event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].programmaticEvent
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['triggerAtBlockStart : ' + str(self.triggerAtBlockStart)]
            except ValueError:
                str_list += ['triggerAtBlockStart : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cydriver.CUevent cyevent
        if event is None:
            cyevent = <cydriver.CUevent><void_ptr>0
        elif isinstance(event, (CUevent,)):
            pevent = int(event)
            cyevent = <cydriver.CUevent><void_ptr>pevent
        else:
            pevent = int(CUevent(event))
            cyevent = <cydriver.CUevent><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent
    @property
    def flags(self):
        return self._pvt_ptr[0].programmaticEvent.flags
    @flags.setter
    def flags(self, int flags):
        self._pvt_ptr[0].programmaticEvent.flags = flags
    @property
    def triggerAtBlockStart(self):
        return self._pvt_ptr[0].programmaticEvent.triggerAtBlockStart
    @triggerAtBlockStart.setter
    def triggerAtBlockStart(self, int triggerAtBlockStart):
        self._pvt_ptr[0].programmaticEvent.triggerAtBlockStart = triggerAtBlockStart

cdef class anon_struct3:
    """
    Attributes
    ----------
    event : CUevent

    flags : int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUlaunchAttributeValue_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._event = CUevent(_ptr=<void_ptr>&self._pvt_ptr[0].launchCompletionEvent.event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].launchCompletionEvent
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cydriver.CUevent cyevent
        if event is None:
            cyevent = <cydriver.CUevent><void_ptr>0
        elif isinstance(event, (CUevent,)):
            pevent = int(event)
            cyevent = <cydriver.CUevent><void_ptr>pevent
        else:
            pevent = int(CUevent(event))
            cyevent = <cydriver.CUevent><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent
    @property
    def flags(self):
        return self._pvt_ptr[0].launchCompletionEvent.flags
    @flags.setter
    def flags(self, int flags):
        self._pvt_ptr[0].launchCompletionEvent.flags = flags

cdef class anon_struct4:
    """
    Attributes
    ----------
    x : unsigned int

    y : unsigned int

    z : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUlaunchAttributeValue_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].preferredClusterDim
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].preferredClusterDim.x
    @x.setter
    def x(self, unsigned int x):
        self._pvt_ptr[0].preferredClusterDim.x = x
    @property
    def y(self):
        return self._pvt_ptr[0].preferredClusterDim.y
    @y.setter
    def y(self, unsigned int y):
        self._pvt_ptr[0].preferredClusterDim.y = y
    @property
    def z(self):
        return self._pvt_ptr[0].preferredClusterDim.z
    @z.setter
    def z(self, unsigned int z):
        self._pvt_ptr[0].preferredClusterDim.z = z

cdef class anon_struct5:
    """
    Attributes
    ----------
    deviceUpdatable : int

    devNode : CUgraphDeviceNode


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUlaunchAttributeValue_union *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._devNode = CUgraphDeviceNode(_ptr=<void_ptr>&self._pvt_ptr[0].deviceUpdatableKernelNode.devNode)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].deviceUpdatableKernelNode
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['deviceUpdatable : ' + str(self.deviceUpdatable)]
            except ValueError:
                str_list += ['deviceUpdatable : <ValueError>']
            try:
                str_list += ['devNode : ' + str(self.devNode)]
            except ValueError:
                str_list += ['devNode : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def deviceUpdatable(self):
        return self._pvt_ptr[0].deviceUpdatableKernelNode.deviceUpdatable
    @deviceUpdatable.setter
    def deviceUpdatable(self, int deviceUpdatable):
        self._pvt_ptr[0].deviceUpdatableKernelNode.deviceUpdatable = deviceUpdatable
    @property
    def devNode(self):
        return self._devNode
    @devNode.setter
    def devNode(self, devNode):
        cdef cydriver.CUgraphDeviceNode cydevNode
        if devNode is None:
            cydevNode = <cydriver.CUgraphDeviceNode><void_ptr>0
        elif isinstance(devNode, (CUgraphDeviceNode,)):
            pdevNode = int(devNode)
            cydevNode = <cydriver.CUgraphDeviceNode><void_ptr>pdevNode
        else:
            pdevNode = int(CUgraphDeviceNode(devNode))
            cydevNode = <cydriver.CUgraphDeviceNode><void_ptr>pdevNode
        self._devNode._pvt_ptr[0] = cydevNode

cdef class CUlaunchAttributeValue_union:
    """
    Launch attributes union; used as value field of CUlaunchAttribute

    Attributes
    ----------
    pad : bytes

    accessPolicyWindow : CUaccessPolicyWindow
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_ACCESS_POLICY_WINDOW.
    cooperative : int
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_COOPERATIVE. Nonzero
        indicates a cooperative kernel (see cuLaunchCooperativeKernel).
    syncPolicy : CUsynchronizationPolicy
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_SYNCHRONIZATION_POLICY.
        ::CUsynchronizationPolicy for work queued up in this stream
    clusterDim : anon_struct1
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_CLUSTER_DIMENSION
        that represents the desired cluster dimensions for the kernel.
        Opaque type with the following fields: - `x` - The X dimension of
        the cluster, in blocks. Must be a divisor of the grid X dimension.
        - `y` - The Y dimension of the cluster, in blocks. Must be a
        divisor of the grid Y dimension.    - `z` - The Z dimension of the
        cluster, in blocks. Must be a divisor of the grid Z dimension.
    clusterSchedulingPolicyPreference : CUclusterSchedulingPolicy
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE. Cluster
        scheduling policy preference for the kernel.
    programmaticStreamSerializationAllowed : int
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_STREAM_SERIALIZATION.
    programmaticEvent : anon_struct2
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_PROGRAMMATIC_EVENT
        with the following fields: - `CUevent` event - Event to fire when
        all blocks trigger it.    - `Event` record flags, see
        cuEventRecordWithFlags. Does not accept :CU_EVENT_RECORD_EXTERNAL.
        - `triggerAtBlockStart` - If this is set to non-0, each block
        launch will automatically trigger the event.
    launchCompletionEvent : anon_struct3
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_LAUNCH_COMPLETION_EVENT with the following
        fields: - `CUevent` event - Event to fire when the last block
        launches    - `int` flags; - Event record flags, see
        cuEventRecordWithFlags. Does not accept CU_EVENT_RECORD_EXTERNAL.
    priority : int
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_PRIORITY. Execution
        priority of the kernel.
    memSyncDomainMap : CUlaunchMemSyncDomainMap
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP.
        See CUlaunchMemSyncDomainMap.
    memSyncDomain : CUlaunchMemSyncDomain
        Value of launch attribute CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN.
        See::CUlaunchMemSyncDomain
    preferredClusterDim : anon_struct4
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_PREFERRED_CLUSTER_DIMENSION that represents the
        desired preferred cluster dimensions for the kernel. Opaque type
        with the following fields: - `x` - The X dimension of the preferred
        cluster, in blocks. Must be a divisor of the grid X dimension, and
        must be a multiple of the `x` field of
        CUlaunchAttributeValue::clusterDim.    - `y` - The Y dimension of
        the preferred cluster, in blocks. Must be a divisor of the grid Y
        dimension, and must be a multiple of the `y` field of
        CUlaunchAttributeValue::clusterDim.    - `z` - The Z dimension of
        the preferred cluster, in blocks. Must be equal to the `z` field of
        CUlaunchAttributeValue::clusterDim.
    deviceUpdatableKernelNode : anon_struct5
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_DEVICE_UPDATABLE_KERNEL_NODE. with the
        following fields: - `int` deviceUpdatable - Whether or not the
        resulting kernel node should be device-updatable.    -
        `CUgraphDeviceNode` devNode - Returns a handle to pass to the
        various device-side update functions.
    sharedMemCarveout : unsigned int
        Value of launch attribute
        CU_LAUNCH_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT.
    nvlinkUtilCentricScheduling : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUlaunchAttributeValue_union *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._accessPolicyWindow = CUaccessPolicyWindow(_ptr=<void_ptr>&self._pvt_ptr[0].accessPolicyWindow)
        self._clusterDim = anon_struct1(_ptr=<void_ptr>self._pvt_ptr)
        self._programmaticEvent = anon_struct2(_ptr=<void_ptr>self._pvt_ptr)
        self._launchCompletionEvent = anon_struct3(_ptr=<void_ptr>self._pvt_ptr)
        self._memSyncDomainMap = CUlaunchMemSyncDomainMap(_ptr=<void_ptr>&self._pvt_ptr[0].memSyncDomainMap)
        self._preferredClusterDim = anon_struct4(_ptr=<void_ptr>self._pvt_ptr)
        self._deviceUpdatableKernelNode = anon_struct5(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['pad : ' + str(self.pad)]
            except ValueError:
                str_list += ['pad : <ValueError>']
            try:
                str_list += ['accessPolicyWindow :\n' + '\n'.join(['    ' + line for line in str(self.accessPolicyWindow).splitlines()])]
            except ValueError:
                str_list += ['accessPolicyWindow : <ValueError>']
            try:
                str_list += ['cooperative : ' + str(self.cooperative)]
            except ValueError:
                str_list += ['cooperative : <ValueError>']
            try:
                str_list += ['syncPolicy : ' + str(self.syncPolicy)]
            except ValueError:
                str_list += ['syncPolicy : <ValueError>']
            try:
                str_list += ['clusterDim :\n' + '\n'.join(['    ' + line for line in str(self.clusterDim).splitlines()])]
            except ValueError:
                str_list += ['clusterDim : <ValueError>']
            try:
                str_list += ['clusterSchedulingPolicyPreference : ' + str(self.clusterSchedulingPolicyPreference)]
            except ValueError:
                str_list += ['clusterSchedulingPolicyPreference : <ValueError>']
            try:
                str_list += ['programmaticStreamSerializationAllowed : ' + str(self.programmaticStreamSerializationAllowed)]
            except ValueError:
                str_list += ['programmaticStreamSerializationAllowed : <ValueError>']
            try:
                str_list += ['programmaticEvent :\n' + '\n'.join(['    ' + line for line in str(self.programmaticEvent).splitlines()])]
            except ValueError:
                str_list += ['programmaticEvent : <ValueError>']
            try:
                str_list += ['launchCompletionEvent :\n' + '\n'.join(['    ' + line for line in str(self.launchCompletionEvent).splitlines()])]
            except ValueError:
                str_list += ['launchCompletionEvent : <ValueError>']
            try:
                str_list += ['priority : ' + str(self.priority)]
            except ValueError:
                str_list += ['priority : <ValueError>']
            try:
                str_list += ['memSyncDomainMap :\n' + '\n'.join(['    ' + line for line in str(self.memSyncDomainMap).splitlines()])]
            except ValueError:
                str_list += ['memSyncDomainMap : <ValueError>']
            try:
                str_list += ['memSyncDomain : ' + str(self.memSyncDomain)]
            except ValueError:
                str_list += ['memSyncDomain : <ValueError>']
            try:
                str_list += ['preferredClusterDim :\n' + '\n'.join(['    ' + line for line in str(self.preferredClusterDim).splitlines()])]
            except ValueError:
                str_list += ['preferredClusterDim : <ValueError>']
            try:
                str_list += ['deviceUpdatableKernelNode :\n' + '\n'.join(['    ' + line for line in str(self.deviceUpdatableKernelNode).splitlines()])]
            except ValueError:
                str_list += ['deviceUpdatableKernelNode : <ValueError>']
            try:
                str_list += ['sharedMemCarveout : ' + str(self.sharedMemCarveout)]
            except ValueError:
                str_list += ['sharedMemCarveout : <ValueError>']
            try:
                str_list += ['nvlinkUtilCentricScheduling : ' + str(self.nvlinkUtilCentricScheduling)]
            except ValueError:
                str_list += ['nvlinkUtilCentricScheduling : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def pad(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].pad, 64)
    @pad.setter
    def pad(self, pad):
        if len(pad) != 64:
            raise ValueError("pad length must be 64, is " + str(len(pad)))
        if CHAR_MIN == 0:
            for i, b in enumerate(pad):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].pad[i] = b
        else:
            for i, b in enumerate(pad):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].pad[i] = b
    @property
    def accessPolicyWindow(self):
        return self._accessPolicyWindow
    @accessPolicyWindow.setter
    def accessPolicyWindow(self, accessPolicyWindow not None : CUaccessPolicyWindow):
        string.memcpy(&self._pvt_ptr[0].accessPolicyWindow, <cydriver.CUaccessPolicyWindow*><void_ptr>accessPolicyWindow.getPtr(), sizeof(self._pvt_ptr[0].accessPolicyWindow))
    @property
    def cooperative(self):
        return self._pvt_ptr[0].cooperative
    @cooperative.setter
    def cooperative(self, int cooperative):
        self._pvt_ptr[0].cooperative = cooperative
    @property
    def syncPolicy(self):
        if self._pvt_ptr[0].syncPolicy not in _dict_CUsynchronizationPolicy:
            return None
        return _dict_CUsynchronizationPolicy[self._pvt_ptr[0].syncPolicy]
    @syncPolicy.setter
    def syncPolicy(self, syncPolicy not None : CUsynchronizationPolicy):
        self._pvt_ptr[0].syncPolicy = syncPolicy.value
    @property
    def clusterDim(self):
        return self._clusterDim
    @clusterDim.setter
    def clusterDim(self, clusterDim not None : anon_struct1):
        string.memcpy(&self._pvt_ptr[0].clusterDim, <cydriver.anon_struct1*><void_ptr>clusterDim.getPtr(), sizeof(self._pvt_ptr[0].clusterDim))
    @property
    def clusterSchedulingPolicyPreference(self):
        if self._pvt_ptr[0].clusterSchedulingPolicyPreference not in _dict_CUclusterSchedulingPolicy:
            return None
        return _dict_CUclusterSchedulingPolicy[self._pvt_ptr[0].clusterSchedulingPolicyPreference]
    @clusterSchedulingPolicyPreference.setter
    def clusterSchedulingPolicyPreference(self, clusterSchedulingPolicyPreference not None : CUclusterSchedulingPolicy):
        self._pvt_ptr[0].clusterSchedulingPolicyPreference = clusterSchedulingPolicyPreference.value
    @property
    def programmaticStreamSerializationAllowed(self):
        return self._pvt_ptr[0].programmaticStreamSerializationAllowed
    @programmaticStreamSerializationAllowed.setter
    def programmaticStreamSerializationAllowed(self, int programmaticStreamSerializationAllowed):
        self._pvt_ptr[0].programmaticStreamSerializationAllowed = programmaticStreamSerializationAllowed
    @property
    def programmaticEvent(self):
        return self._programmaticEvent
    @programmaticEvent.setter
    def programmaticEvent(self, programmaticEvent not None : anon_struct2):
        string.memcpy(&self._pvt_ptr[0].programmaticEvent, <cydriver.anon_struct2*><void_ptr>programmaticEvent.getPtr(), sizeof(self._pvt_ptr[0].programmaticEvent))
    @property
    def launchCompletionEvent(self):
        return self._launchCompletionEvent
    @launchCompletionEvent.setter
    def launchCompletionEvent(self, launchCompletionEvent not None : anon_struct3):
        string.memcpy(&self._pvt_ptr[0].launchCompletionEvent, <cydriver.anon_struct3*><void_ptr>launchCompletionEvent.getPtr(), sizeof(self._pvt_ptr[0].launchCompletionEvent))
    @property
    def priority(self):
        return self._pvt_ptr[0].priority
    @priority.setter
    def priority(self, int priority):
        self._pvt_ptr[0].priority = priority
    @property
    def memSyncDomainMap(self):
        return self._memSyncDomainMap
    @memSyncDomainMap.setter
    def memSyncDomainMap(self, memSyncDomainMap not None : CUlaunchMemSyncDomainMap):
        string.memcpy(&self._pvt_ptr[0].memSyncDomainMap, <cydriver.CUlaunchMemSyncDomainMap*><void_ptr>memSyncDomainMap.getPtr(), sizeof(self._pvt_ptr[0].memSyncDomainMap))
    @property
    def memSyncDomain(self):
        if self._pvt_ptr[0].memSyncDomain not in _dict_CUlaunchMemSyncDomain:
            return None
        return _dict_CUlaunchMemSyncDomain[self._pvt_ptr[0].memSyncDomain]
    @memSyncDomain.setter
    def memSyncDomain(self, memSyncDomain not None : CUlaunchMemSyncDomain):
        self._pvt_ptr[0].memSyncDomain = memSyncDomain.value
    @property
    def preferredClusterDim(self):
        return self._preferredClusterDim
    @preferredClusterDim.setter
    def preferredClusterDim(self, preferredClusterDim not None : anon_struct4):
        string.memcpy(&self._pvt_ptr[0].preferredClusterDim, <cydriver.anon_struct4*><void_ptr>preferredClusterDim.getPtr(), sizeof(self._pvt_ptr[0].preferredClusterDim))
    @property
    def deviceUpdatableKernelNode(self):
        return self._deviceUpdatableKernelNode
    @deviceUpdatableKernelNode.setter
    def deviceUpdatableKernelNode(self, deviceUpdatableKernelNode not None : anon_struct5):
        string.memcpy(&self._pvt_ptr[0].deviceUpdatableKernelNode, <cydriver.anon_struct5*><void_ptr>deviceUpdatableKernelNode.getPtr(), sizeof(self._pvt_ptr[0].deviceUpdatableKernelNode))
    @property
    def sharedMemCarveout(self):
        return self._pvt_ptr[0].sharedMemCarveout
    @sharedMemCarveout.setter
    def sharedMemCarveout(self, unsigned int sharedMemCarveout):
        self._pvt_ptr[0].sharedMemCarveout = sharedMemCarveout
    @property
    def nvlinkUtilCentricScheduling(self):
        return self._pvt_ptr[0].nvlinkUtilCentricScheduling
    @nvlinkUtilCentricScheduling.setter
    def nvlinkUtilCentricScheduling(self, unsigned int nvlinkUtilCentricScheduling):
        self._pvt_ptr[0].nvlinkUtilCentricScheduling = nvlinkUtilCentricScheduling

cdef class CUlaunchAttribute_st:
    """
    Launch attribute

    Attributes
    ----------
    id : CUlaunchAttributeID
        Attribute to set
    value : CUlaunchAttributeValue
        Value of the attribute

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUlaunchAttribute_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._value = CUlaunchAttributeValue(_ptr=<void_ptr>&self._pvt_ptr[0].value)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['id : ' + str(self.id)]
            except ValueError:
                str_list += ['id : <ValueError>']
            try:
                str_list += ['value :\n' + '\n'.join(['    ' + line for line in str(self.value).splitlines()])]
            except ValueError:
                str_list += ['value : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def id(self):
        if self._pvt_ptr[0].id not in _dict_CUlaunchAttributeID:
            return None
        return _dict_CUlaunchAttributeID[self._pvt_ptr[0].id]
    @id.setter
    def id(self, id not None : CUlaunchAttributeID):
        self._pvt_ptr[0].id = id.value
    @property
    def value(self):
        return self._value
    @value.setter
    def value(self, value not None : CUlaunchAttributeValue):
        string.memcpy(&self._pvt_ptr[0].value, <cydriver.CUlaunchAttributeValue*><void_ptr>value.getPtr(), sizeof(self._pvt_ptr[0].value))

cdef class CUlaunchConfig_st:
    """
    CUDA extensible launch configuration

    Attributes
    ----------
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    hStream : CUstream
        Stream identifier
    attrs : CUlaunchAttribute
        List of attributes; nullable if CUlaunchConfig::numAttrs == 0
    numAttrs : unsigned int
        Number of attributes populated in CUlaunchConfig::attrs

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUlaunchConfig_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._hStream = CUstream(_ptr=<void_ptr>&self._pvt_ptr[0].hStream)
    def __dealloc__(self):
        pass
        if self._attrs is not NULL:
            free(self._attrs)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['gridDimX : ' + str(self.gridDimX)]
            except ValueError:
                str_list += ['gridDimX : <ValueError>']
            try:
                str_list += ['gridDimY : ' + str(self.gridDimY)]
            except ValueError:
                str_list += ['gridDimY : <ValueError>']
            try:
                str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            except ValueError:
                str_list += ['gridDimZ : <ValueError>']
            try:
                str_list += ['blockDimX : ' + str(self.blockDimX)]
            except ValueError:
                str_list += ['blockDimX : <ValueError>']
            try:
                str_list += ['blockDimY : ' + str(self.blockDimY)]
            except ValueError:
                str_list += ['blockDimY : <ValueError>']
            try:
                str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            except ValueError:
                str_list += ['blockDimZ : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['hStream : ' + str(self.hStream)]
            except ValueError:
                str_list += ['hStream : <ValueError>']
            try:
                str_list += ['attrs : ' + str(self.attrs)]
            except ValueError:
                str_list += ['attrs : <ValueError>']
            try:
                str_list += ['numAttrs : ' + str(self.numAttrs)]
            except ValueError:
                str_list += ['numAttrs : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def gridDimX(self):
        return self._pvt_ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        self._pvt_ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._pvt_ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        self._pvt_ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._pvt_ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        self._pvt_ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._pvt_ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        self._pvt_ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._pvt_ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        self._pvt_ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._pvt_ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        self._pvt_ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def hStream(self):
        return self._hStream
    @hStream.setter
    def hStream(self, hStream):
        cdef cydriver.CUstream cyhStream
        if hStream is None:
            cyhStream = <cydriver.CUstream><void_ptr>0
        elif isinstance(hStream, (CUstream,)):
            phStream = int(hStream)
            cyhStream = <cydriver.CUstream><void_ptr>phStream
        else:
            phStream = int(CUstream(hStream))
            cyhStream = <cydriver.CUstream><void_ptr>phStream
        self._hStream._pvt_ptr[0] = cyhStream
    @property
    def attrs(self):
        arrs = [<void_ptr>self._pvt_ptr[0].attrs + x*sizeof(cydriver.CUlaunchAttribute) for x in range(self._attrs_length)]
        return [CUlaunchAttribute(_ptr=arr) for arr in arrs]
    @attrs.setter
    def attrs(self, val):
        if len(val) == 0:
            free(self._attrs)
            self._attrs_length = 0
            self._pvt_ptr[0].attrs = NULL
        else:
            if self._attrs_length != <size_t>len(val):
                free(self._attrs)
                self._attrs = <cydriver.CUlaunchAttribute*> calloc(len(val), sizeof(cydriver.CUlaunchAttribute))
                if self._attrs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUlaunchAttribute)))
                self._attrs_length = <size_t>len(val)
                self._pvt_ptr[0].attrs = self._attrs
            for idx in range(len(val)):
                string.memcpy(&self._attrs[idx], (<CUlaunchAttribute>val[idx])._pvt_ptr, sizeof(cydriver.CUlaunchAttribute))

    @property
    def numAttrs(self):
        return self._pvt_ptr[0].numAttrs
    @numAttrs.setter
    def numAttrs(self, unsigned int numAttrs):
        self._pvt_ptr[0].numAttrs = numAttrs

cdef class CUexecAffinitySmCount_st:
    """
    Value for CU_EXEC_AFFINITY_TYPE_SM_COUNT

    Attributes
    ----------
    val : unsigned int
        The number of SMs the context is limited to use.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUexecAffinitySmCount_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['val : ' + str(self.val)]
            except ValueError:
                str_list += ['val : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def val(self):
        return self._pvt_ptr[0].val
    @val.setter
    def val(self, unsigned int val):
        self._pvt_ptr[0].val = val

cdef class anon_union3:
    """
    Attributes
    ----------
    smCount : CUexecAffinitySmCount


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUexecAffinityParam_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._smCount = CUexecAffinitySmCount(_ptr=<void_ptr>&self._pvt_ptr[0].param.smCount)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].param
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['smCount :\n' + '\n'.join(['    ' + line for line in str(self.smCount).splitlines()])]
            except ValueError:
                str_list += ['smCount : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def smCount(self):
        return self._smCount
    @smCount.setter
    def smCount(self, smCount not None : CUexecAffinitySmCount):
        string.memcpy(&self._pvt_ptr[0].param.smCount, <cydriver.CUexecAffinitySmCount*><void_ptr>smCount.getPtr(), sizeof(self._pvt_ptr[0].param.smCount))

cdef class CUexecAffinityParam_st:
    """
    Execution Affinity Parameters

    Attributes
    ----------
    type : CUexecAffinityType

    param : anon_union3


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUexecAffinityParam_st *>calloc(1, sizeof(cydriver.CUexecAffinityParam_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUexecAffinityParam_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._param = anon_union3(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['param :\n' + '\n'.join(['    ' + line for line in str(self.param).splitlines()])]
            except ValueError:
                str_list += ['param : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUexecAffinityType:
            return None
        return _dict_CUexecAffinityType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUexecAffinityType):
        self._pvt_ptr[0].type = type.value
    @property
    def param(self):
        return self._param
    @param.setter
    def param(self, param not None : anon_union3):
        string.memcpy(&self._pvt_ptr[0].param, <cydriver.anon_union3*><void_ptr>param.getPtr(), sizeof(self._pvt_ptr[0].param))

cdef class CUctxCigParam_st:
    """
    CIG Context Create Params

    Attributes
    ----------
    sharedDataType : CUcigDataType

    sharedData : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUctxCigParam_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['sharedDataType : ' + str(self.sharedDataType)]
            except ValueError:
                str_list += ['sharedDataType : <ValueError>']
            try:
                str_list += ['sharedData : ' + hex(self.sharedData)]
            except ValueError:
                str_list += ['sharedData : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def sharedDataType(self):
        if self._pvt_ptr[0].sharedDataType not in _dict_CUcigDataType:
            return None
        return _dict_CUcigDataType[self._pvt_ptr[0].sharedDataType]
    @sharedDataType.setter
    def sharedDataType(self, sharedDataType not None : CUcigDataType):
        self._pvt_ptr[0].sharedDataType = sharedDataType.value
    @property
    def sharedData(self):
        return <void_ptr>self._pvt_ptr[0].sharedData
    @sharedData.setter
    def sharedData(self, sharedData):
        _csharedData = _HelperInputVoidPtr(sharedData)
        self._pvt_ptr[0].sharedData = <void*><void_ptr>_csharedData.cptr

cdef class CUctxCreateParams_st:
    """
    Params for creating CUDA context Exactly one of execAffinityParams
    and cigParams must be non-NULL.

    Attributes
    ----------
    execAffinityParams : CUexecAffinityParam

    numExecAffinityParams : int

    cigParams : CUctxCigParam


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUctxCreateParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._execAffinityParams is not NULL:
            free(self._execAffinityParams)
        if self._cigParams is not NULL:
            free(self._cigParams)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['execAffinityParams : ' + str(self.execAffinityParams)]
            except ValueError:
                str_list += ['execAffinityParams : <ValueError>']
            try:
                str_list += ['numExecAffinityParams : ' + str(self.numExecAffinityParams)]
            except ValueError:
                str_list += ['numExecAffinityParams : <ValueError>']
            try:
                str_list += ['cigParams : ' + str(self.cigParams)]
            except ValueError:
                str_list += ['cigParams : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def execAffinityParams(self):
        arrs = [<void_ptr>self._pvt_ptr[0].execAffinityParams + x*sizeof(cydriver.CUexecAffinityParam) for x in range(self._execAffinityParams_length)]
        return [CUexecAffinityParam(_ptr=arr) for arr in arrs]
    @execAffinityParams.setter
    def execAffinityParams(self, val):
        if len(val) == 0:
            free(self._execAffinityParams)
            self._execAffinityParams_length = 0
            self._pvt_ptr[0].execAffinityParams = NULL
        else:
            if self._execAffinityParams_length != <size_t>len(val):
                free(self._execAffinityParams)
                self._execAffinityParams = <cydriver.CUexecAffinityParam*> calloc(len(val), sizeof(cydriver.CUexecAffinityParam))
                if self._execAffinityParams is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUexecAffinityParam)))
                self._execAffinityParams_length = <size_t>len(val)
                self._pvt_ptr[0].execAffinityParams = self._execAffinityParams
            for idx in range(len(val)):
                string.memcpy(&self._execAffinityParams[idx], (<CUexecAffinityParam>val[idx])._pvt_ptr, sizeof(cydriver.CUexecAffinityParam))

    @property
    def numExecAffinityParams(self):
        return self._pvt_ptr[0].numExecAffinityParams
    @numExecAffinityParams.setter
    def numExecAffinityParams(self, int numExecAffinityParams):
        self._pvt_ptr[0].numExecAffinityParams = numExecAffinityParams
    @property
    def cigParams(self):
        arrs = [<void_ptr>self._pvt_ptr[0].cigParams + x*sizeof(cydriver.CUctxCigParam) for x in range(self._cigParams_length)]
        return [CUctxCigParam(_ptr=arr) for arr in arrs]
    @cigParams.setter
    def cigParams(self, val):
        if len(val) == 0:
            free(self._cigParams)
            self._cigParams_length = 0
            self._pvt_ptr[0].cigParams = NULL
        else:
            if self._cigParams_length != <size_t>len(val):
                free(self._cigParams)
                self._cigParams = <cydriver.CUctxCigParam*> calloc(len(val), sizeof(cydriver.CUctxCigParam))
                if self._cigParams is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUctxCigParam)))
                self._cigParams_length = <size_t>len(val)
                self._pvt_ptr[0].cigParams = self._cigParams
            for idx in range(len(val)):
                string.memcpy(&self._cigParams[idx], (<CUctxCigParam>val[idx])._pvt_ptr, sizeof(cydriver.CUctxCigParam))


cdef class CUlibraryHostUniversalFunctionAndDataTable_st:
    """
    Attributes
    ----------
    functionTable : Any

    functionWindowSize : size_t

    dataTable : Any

    dataWindowSize : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUlibraryHostUniversalFunctionAndDataTable_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['functionTable : ' + hex(self.functionTable)]
            except ValueError:
                str_list += ['functionTable : <ValueError>']
            try:
                str_list += ['functionWindowSize : ' + str(self.functionWindowSize)]
            except ValueError:
                str_list += ['functionWindowSize : <ValueError>']
            try:
                str_list += ['dataTable : ' + hex(self.dataTable)]
            except ValueError:
                str_list += ['dataTable : <ValueError>']
            try:
                str_list += ['dataWindowSize : ' + str(self.dataWindowSize)]
            except ValueError:
                str_list += ['dataWindowSize : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def functionTable(self):
        return <void_ptr>self._pvt_ptr[0].functionTable
    @functionTable.setter
    def functionTable(self, functionTable):
        _cfunctionTable = _HelperInputVoidPtr(functionTable)
        self._pvt_ptr[0].functionTable = <void*><void_ptr>_cfunctionTable.cptr
    @property
    def functionWindowSize(self):
        return self._pvt_ptr[0].functionWindowSize
    @functionWindowSize.setter
    def functionWindowSize(self, size_t functionWindowSize):
        self._pvt_ptr[0].functionWindowSize = functionWindowSize
    @property
    def dataTable(self):
        return <void_ptr>self._pvt_ptr[0].dataTable
    @dataTable.setter
    def dataTable(self, dataTable):
        _cdataTable = _HelperInputVoidPtr(dataTable)
        self._pvt_ptr[0].dataTable = <void*><void_ptr>_cdataTable.cptr
    @property
    def dataWindowSize(self):
        return self._pvt_ptr[0].dataWindowSize
    @dataWindowSize.setter
    def dataWindowSize(self, size_t dataWindowSize):
        self._pvt_ptr[0].dataWindowSize = dataWindowSize

cdef class CUDA_MEMCPY2D_st:
    """
    2D memory copy parameters

    Attributes
    ----------
    srcXInBytes : size_t
        Source X in bytes
    srcY : size_t
        Source Y
    srcMemoryType : CUmemorytype
        Source memory type (host, device, array)
    srcHost : Any
        Source host pointer
    srcDevice : CUdeviceptr
        Source device pointer
    srcArray : CUarray
        Source array reference
    srcPitch : size_t
        Source pitch (ignored when src is array)
    dstXInBytes : size_t
        Destination X in bytes
    dstY : size_t
        Destination Y
    dstMemoryType : CUmemorytype
        Destination memory type (host, device, array)
    dstHost : Any
        Destination host pointer
    dstDevice : CUdeviceptr
        Destination device pointer
    dstArray : CUarray
        Destination array reference
    dstPitch : size_t
        Destination pitch (ignored when dst is array)
    WidthInBytes : size_t
        Width of 2D memory copy in bytes
    Height : size_t
        Height of 2D memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMCPY2D_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcDevice = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].srcDevice)
        self._srcArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].srcArray)
        self._dstDevice = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dstDevice)
        self._dstArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].dstArray)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcXInBytes : ' + str(self.srcXInBytes)]
            except ValueError:
                str_list += ['srcXInBytes : <ValueError>']
            try:
                str_list += ['srcY : ' + str(self.srcY)]
            except ValueError:
                str_list += ['srcY : <ValueError>']
            try:
                str_list += ['srcMemoryType : ' + str(self.srcMemoryType)]
            except ValueError:
                str_list += ['srcMemoryType : <ValueError>']
            try:
                str_list += ['srcHost : ' + hex(self.srcHost)]
            except ValueError:
                str_list += ['srcHost : <ValueError>']
            try:
                str_list += ['srcDevice : ' + str(self.srcDevice)]
            except ValueError:
                str_list += ['srcDevice : <ValueError>']
            try:
                str_list += ['srcArray : ' + str(self.srcArray)]
            except ValueError:
                str_list += ['srcArray : <ValueError>']
            try:
                str_list += ['srcPitch : ' + str(self.srcPitch)]
            except ValueError:
                str_list += ['srcPitch : <ValueError>']
            try:
                str_list += ['dstXInBytes : ' + str(self.dstXInBytes)]
            except ValueError:
                str_list += ['dstXInBytes : <ValueError>']
            try:
                str_list += ['dstY : ' + str(self.dstY)]
            except ValueError:
                str_list += ['dstY : <ValueError>']
            try:
                str_list += ['dstMemoryType : ' + str(self.dstMemoryType)]
            except ValueError:
                str_list += ['dstMemoryType : <ValueError>']
            try:
                str_list += ['dstHost : ' + hex(self.dstHost)]
            except ValueError:
                str_list += ['dstHost : <ValueError>']
            try:
                str_list += ['dstDevice : ' + str(self.dstDevice)]
            except ValueError:
                str_list += ['dstDevice : <ValueError>']
            try:
                str_list += ['dstArray : ' + str(self.dstArray)]
            except ValueError:
                str_list += ['dstArray : <ValueError>']
            try:
                str_list += ['dstPitch : ' + str(self.dstPitch)]
            except ValueError:
                str_list += ['dstPitch : <ValueError>']
            try:
                str_list += ['WidthInBytes : ' + str(self.WidthInBytes)]
            except ValueError:
                str_list += ['WidthInBytes : <ValueError>']
            try:
                str_list += ['Height : ' + str(self.Height)]
            except ValueError:
                str_list += ['Height : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcXInBytes(self):
        return self._pvt_ptr[0].srcXInBytes
    @srcXInBytes.setter
    def srcXInBytes(self, size_t srcXInBytes):
        self._pvt_ptr[0].srcXInBytes = srcXInBytes
    @property
    def srcY(self):
        return self._pvt_ptr[0].srcY
    @srcY.setter
    def srcY(self, size_t srcY):
        self._pvt_ptr[0].srcY = srcY
    @property
    def srcMemoryType(self):
        if self._pvt_ptr[0].srcMemoryType not in _dict_CUmemorytype:
            return None
        return _dict_CUmemorytype[self._pvt_ptr[0].srcMemoryType]
    @srcMemoryType.setter
    def srcMemoryType(self, srcMemoryType not None : CUmemorytype):
        self._pvt_ptr[0].srcMemoryType = srcMemoryType.value
    @property
    def srcHost(self):
        return <void_ptr>self._pvt_ptr[0].srcHost
    @srcHost.setter
    def srcHost(self, srcHost):
        _csrcHost = _HelperInputVoidPtr(srcHost)
        self._pvt_ptr[0].srcHost = <void*><void_ptr>_csrcHost.cptr
    @property
    def srcDevice(self):
        return self._srcDevice
    @srcDevice.setter
    def srcDevice(self, srcDevice):
        cdef cydriver.CUdeviceptr cysrcDevice
        if srcDevice is None:
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(srcDevice, (CUdeviceptr)):
            psrcDevice = int(srcDevice)
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
        else:
            psrcDevice = int(CUdeviceptr(srcDevice))
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
        self._srcDevice._pvt_ptr[0] = cysrcDevice

    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef cydriver.CUarray cysrcArray
        if srcArray is None:
            cysrcArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(srcArray, (CUarray,)):
            psrcArray = int(srcArray)
            cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
        else:
            psrcArray = int(CUarray(srcArray))
            cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
        self._srcArray._pvt_ptr[0] = cysrcArray
    @property
    def srcPitch(self):
        return self._pvt_ptr[0].srcPitch
    @srcPitch.setter
    def srcPitch(self, size_t srcPitch):
        self._pvt_ptr[0].srcPitch = srcPitch
    @property
    def dstXInBytes(self):
        return self._pvt_ptr[0].dstXInBytes
    @dstXInBytes.setter
    def dstXInBytes(self, size_t dstXInBytes):
        self._pvt_ptr[0].dstXInBytes = dstXInBytes
    @property
    def dstY(self):
        return self._pvt_ptr[0].dstY
    @dstY.setter
    def dstY(self, size_t dstY):
        self._pvt_ptr[0].dstY = dstY
    @property
    def dstMemoryType(self):
        if self._pvt_ptr[0].dstMemoryType not in _dict_CUmemorytype:
            return None
        return _dict_CUmemorytype[self._pvt_ptr[0].dstMemoryType]
    @dstMemoryType.setter
    def dstMemoryType(self, dstMemoryType not None : CUmemorytype):
        self._pvt_ptr[0].dstMemoryType = dstMemoryType.value
    @property
    def dstHost(self):
        return <void_ptr>self._pvt_ptr[0].dstHost
    @dstHost.setter
    def dstHost(self, dstHost):
        _cdstHost = _HelperInputVoidPtr(dstHost)
        self._pvt_ptr[0].dstHost = <void*><void_ptr>_cdstHost.cptr
    @property
    def dstDevice(self):
        return self._dstDevice
    @dstDevice.setter
    def dstDevice(self, dstDevice):
        cdef cydriver.CUdeviceptr cydstDevice
        if dstDevice is None:
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dstDevice, (CUdeviceptr)):
            pdstDevice = int(dstDevice)
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
        else:
            pdstDevice = int(CUdeviceptr(dstDevice))
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
        self._dstDevice._pvt_ptr[0] = cydstDevice

    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef cydriver.CUarray cydstArray
        if dstArray is None:
            cydstArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(dstArray, (CUarray,)):
            pdstArray = int(dstArray)
            cydstArray = <cydriver.CUarray><void_ptr>pdstArray
        else:
            pdstArray = int(CUarray(dstArray))
            cydstArray = <cydriver.CUarray><void_ptr>pdstArray
        self._dstArray._pvt_ptr[0] = cydstArray
    @property
    def dstPitch(self):
        return self._pvt_ptr[0].dstPitch
    @dstPitch.setter
    def dstPitch(self, size_t dstPitch):
        self._pvt_ptr[0].dstPitch = dstPitch
    @property
    def WidthInBytes(self):
        return self._pvt_ptr[0].WidthInBytes
    @WidthInBytes.setter
    def WidthInBytes(self, size_t WidthInBytes):
        self._pvt_ptr[0].WidthInBytes = WidthInBytes
    @property
    def Height(self):
        return self._pvt_ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        self._pvt_ptr[0].Height = Height

cdef class CUDA_MEMCPY3D_st:
    """
    3D memory copy parameters

    Attributes
    ----------
    srcXInBytes : size_t
        Source X in bytes
    srcY : size_t
        Source Y
    srcZ : size_t
        Source Z
    srcLOD : size_t
        Source LOD
    srcMemoryType : CUmemorytype
        Source memory type (host, device, array)
    srcHost : Any
        Source host pointer
    srcDevice : CUdeviceptr
        Source device pointer
    srcArray : CUarray
        Source array reference
    reserved0 : Any
        Must be NULL
    srcPitch : size_t
        Source pitch (ignored when src is array)
    srcHeight : size_t
        Source height (ignored when src is array; may be 0 if Depth==1)
    dstXInBytes : size_t
        Destination X in bytes
    dstY : size_t
        Destination Y
    dstZ : size_t
        Destination Z
    dstLOD : size_t
        Destination LOD
    dstMemoryType : CUmemorytype
        Destination memory type (host, device, array)
    dstHost : Any
        Destination host pointer
    dstDevice : CUdeviceptr
        Destination device pointer
    dstArray : CUarray
        Destination array reference
    reserved1 : Any
        Must be NULL
    dstPitch : size_t
        Destination pitch (ignored when dst is array)
    dstHeight : size_t
        Destination height (ignored when dst is array; may be 0 if
        Depth==1)
    WidthInBytes : size_t
        Width of 3D memory copy in bytes
    Height : size_t
        Height of 3D memory copy
    Depth : size_t
        Depth of 3D memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMCPY3D_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcDevice = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].srcDevice)
        self._srcArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].srcArray)
        self._dstDevice = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dstDevice)
        self._dstArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].dstArray)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcXInBytes : ' + str(self.srcXInBytes)]
            except ValueError:
                str_list += ['srcXInBytes : <ValueError>']
            try:
                str_list += ['srcY : ' + str(self.srcY)]
            except ValueError:
                str_list += ['srcY : <ValueError>']
            try:
                str_list += ['srcZ : ' + str(self.srcZ)]
            except ValueError:
                str_list += ['srcZ : <ValueError>']
            try:
                str_list += ['srcLOD : ' + str(self.srcLOD)]
            except ValueError:
                str_list += ['srcLOD : <ValueError>']
            try:
                str_list += ['srcMemoryType : ' + str(self.srcMemoryType)]
            except ValueError:
                str_list += ['srcMemoryType : <ValueError>']
            try:
                str_list += ['srcHost : ' + hex(self.srcHost)]
            except ValueError:
                str_list += ['srcHost : <ValueError>']
            try:
                str_list += ['srcDevice : ' + str(self.srcDevice)]
            except ValueError:
                str_list += ['srcDevice : <ValueError>']
            try:
                str_list += ['srcArray : ' + str(self.srcArray)]
            except ValueError:
                str_list += ['srcArray : <ValueError>']
            try:
                str_list += ['reserved0 : ' + hex(self.reserved0)]
            except ValueError:
                str_list += ['reserved0 : <ValueError>']
            try:
                str_list += ['srcPitch : ' + str(self.srcPitch)]
            except ValueError:
                str_list += ['srcPitch : <ValueError>']
            try:
                str_list += ['srcHeight : ' + str(self.srcHeight)]
            except ValueError:
                str_list += ['srcHeight : <ValueError>']
            try:
                str_list += ['dstXInBytes : ' + str(self.dstXInBytes)]
            except ValueError:
                str_list += ['dstXInBytes : <ValueError>']
            try:
                str_list += ['dstY : ' + str(self.dstY)]
            except ValueError:
                str_list += ['dstY : <ValueError>']
            try:
                str_list += ['dstZ : ' + str(self.dstZ)]
            except ValueError:
                str_list += ['dstZ : <ValueError>']
            try:
                str_list += ['dstLOD : ' + str(self.dstLOD)]
            except ValueError:
                str_list += ['dstLOD : <ValueError>']
            try:
                str_list += ['dstMemoryType : ' + str(self.dstMemoryType)]
            except ValueError:
                str_list += ['dstMemoryType : <ValueError>']
            try:
                str_list += ['dstHost : ' + hex(self.dstHost)]
            except ValueError:
                str_list += ['dstHost : <ValueError>']
            try:
                str_list += ['dstDevice : ' + str(self.dstDevice)]
            except ValueError:
                str_list += ['dstDevice : <ValueError>']
            try:
                str_list += ['dstArray : ' + str(self.dstArray)]
            except ValueError:
                str_list += ['dstArray : <ValueError>']
            try:
                str_list += ['reserved1 : ' + hex(self.reserved1)]
            except ValueError:
                str_list += ['reserved1 : <ValueError>']
            try:
                str_list += ['dstPitch : ' + str(self.dstPitch)]
            except ValueError:
                str_list += ['dstPitch : <ValueError>']
            try:
                str_list += ['dstHeight : ' + str(self.dstHeight)]
            except ValueError:
                str_list += ['dstHeight : <ValueError>']
            try:
                str_list += ['WidthInBytes : ' + str(self.WidthInBytes)]
            except ValueError:
                str_list += ['WidthInBytes : <ValueError>']
            try:
                str_list += ['Height : ' + str(self.Height)]
            except ValueError:
                str_list += ['Height : <ValueError>']
            try:
                str_list += ['Depth : ' + str(self.Depth)]
            except ValueError:
                str_list += ['Depth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcXInBytes(self):
        return self._pvt_ptr[0].srcXInBytes
    @srcXInBytes.setter
    def srcXInBytes(self, size_t srcXInBytes):
        self._pvt_ptr[0].srcXInBytes = srcXInBytes
    @property
    def srcY(self):
        return self._pvt_ptr[0].srcY
    @srcY.setter
    def srcY(self, size_t srcY):
        self._pvt_ptr[0].srcY = srcY
    @property
    def srcZ(self):
        return self._pvt_ptr[0].srcZ
    @srcZ.setter
    def srcZ(self, size_t srcZ):
        self._pvt_ptr[0].srcZ = srcZ
    @property
    def srcLOD(self):
        return self._pvt_ptr[0].srcLOD
    @srcLOD.setter
    def srcLOD(self, size_t srcLOD):
        self._pvt_ptr[0].srcLOD = srcLOD
    @property
    def srcMemoryType(self):
        if self._pvt_ptr[0].srcMemoryType not in _dict_CUmemorytype:
            return None
        return _dict_CUmemorytype[self._pvt_ptr[0].srcMemoryType]
    @srcMemoryType.setter
    def srcMemoryType(self, srcMemoryType not None : CUmemorytype):
        self._pvt_ptr[0].srcMemoryType = srcMemoryType.value
    @property
    def srcHost(self):
        return <void_ptr>self._pvt_ptr[0].srcHost
    @srcHost.setter
    def srcHost(self, srcHost):
        _csrcHost = _HelperInputVoidPtr(srcHost)
        self._pvt_ptr[0].srcHost = <void*><void_ptr>_csrcHost.cptr
    @property
    def srcDevice(self):
        return self._srcDevice
    @srcDevice.setter
    def srcDevice(self, srcDevice):
        cdef cydriver.CUdeviceptr cysrcDevice
        if srcDevice is None:
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(srcDevice, (CUdeviceptr)):
            psrcDevice = int(srcDevice)
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
        else:
            psrcDevice = int(CUdeviceptr(srcDevice))
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
        self._srcDevice._pvt_ptr[0] = cysrcDevice

    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef cydriver.CUarray cysrcArray
        if srcArray is None:
            cysrcArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(srcArray, (CUarray,)):
            psrcArray = int(srcArray)
            cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
        else:
            psrcArray = int(CUarray(srcArray))
            cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
        self._srcArray._pvt_ptr[0] = cysrcArray
    @property
    def reserved0(self):
        return <void_ptr>self._pvt_ptr[0].reserved0
    @reserved0.setter
    def reserved0(self, reserved0):
        _creserved0 = _HelperInputVoidPtr(reserved0)
        self._pvt_ptr[0].reserved0 = <void*><void_ptr>_creserved0.cptr
    @property
    def srcPitch(self):
        return self._pvt_ptr[0].srcPitch
    @srcPitch.setter
    def srcPitch(self, size_t srcPitch):
        self._pvt_ptr[0].srcPitch = srcPitch
    @property
    def srcHeight(self):
        return self._pvt_ptr[0].srcHeight
    @srcHeight.setter
    def srcHeight(self, size_t srcHeight):
        self._pvt_ptr[0].srcHeight = srcHeight
    @property
    def dstXInBytes(self):
        return self._pvt_ptr[0].dstXInBytes
    @dstXInBytes.setter
    def dstXInBytes(self, size_t dstXInBytes):
        self._pvt_ptr[0].dstXInBytes = dstXInBytes
    @property
    def dstY(self):
        return self._pvt_ptr[0].dstY
    @dstY.setter
    def dstY(self, size_t dstY):
        self._pvt_ptr[0].dstY = dstY
    @property
    def dstZ(self):
        return self._pvt_ptr[0].dstZ
    @dstZ.setter
    def dstZ(self, size_t dstZ):
        self._pvt_ptr[0].dstZ = dstZ
    @property
    def dstLOD(self):
        return self._pvt_ptr[0].dstLOD
    @dstLOD.setter
    def dstLOD(self, size_t dstLOD):
        self._pvt_ptr[0].dstLOD = dstLOD
    @property
    def dstMemoryType(self):
        if self._pvt_ptr[0].dstMemoryType not in _dict_CUmemorytype:
            return None
        return _dict_CUmemorytype[self._pvt_ptr[0].dstMemoryType]
    @dstMemoryType.setter
    def dstMemoryType(self, dstMemoryType not None : CUmemorytype):
        self._pvt_ptr[0].dstMemoryType = dstMemoryType.value
    @property
    def dstHost(self):
        return <void_ptr>self._pvt_ptr[0].dstHost
    @dstHost.setter
    def dstHost(self, dstHost):
        _cdstHost = _HelperInputVoidPtr(dstHost)
        self._pvt_ptr[0].dstHost = <void*><void_ptr>_cdstHost.cptr
    @property
    def dstDevice(self):
        return self._dstDevice
    @dstDevice.setter
    def dstDevice(self, dstDevice):
        cdef cydriver.CUdeviceptr cydstDevice
        if dstDevice is None:
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dstDevice, (CUdeviceptr)):
            pdstDevice = int(dstDevice)
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
        else:
            pdstDevice = int(CUdeviceptr(dstDevice))
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
        self._dstDevice._pvt_ptr[0] = cydstDevice

    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef cydriver.CUarray cydstArray
        if dstArray is None:
            cydstArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(dstArray, (CUarray,)):
            pdstArray = int(dstArray)
            cydstArray = <cydriver.CUarray><void_ptr>pdstArray
        else:
            pdstArray = int(CUarray(dstArray))
            cydstArray = <cydriver.CUarray><void_ptr>pdstArray
        self._dstArray._pvt_ptr[0] = cydstArray
    @property
    def reserved1(self):
        return <void_ptr>self._pvt_ptr[0].reserved1
    @reserved1.setter
    def reserved1(self, reserved1):
        _creserved1 = _HelperInputVoidPtr(reserved1)
        self._pvt_ptr[0].reserved1 = <void*><void_ptr>_creserved1.cptr
    @property
    def dstPitch(self):
        return self._pvt_ptr[0].dstPitch
    @dstPitch.setter
    def dstPitch(self, size_t dstPitch):
        self._pvt_ptr[0].dstPitch = dstPitch
    @property
    def dstHeight(self):
        return self._pvt_ptr[0].dstHeight
    @dstHeight.setter
    def dstHeight(self, size_t dstHeight):
        self._pvt_ptr[0].dstHeight = dstHeight
    @property
    def WidthInBytes(self):
        return self._pvt_ptr[0].WidthInBytes
    @WidthInBytes.setter
    def WidthInBytes(self, size_t WidthInBytes):
        self._pvt_ptr[0].WidthInBytes = WidthInBytes
    @property
    def Height(self):
        return self._pvt_ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        self._pvt_ptr[0].Height = Height
    @property
    def Depth(self):
        return self._pvt_ptr[0].Depth
    @Depth.setter
    def Depth(self, size_t Depth):
        self._pvt_ptr[0].Depth = Depth

cdef class CUDA_MEMCPY3D_PEER_st:
    """
    3D memory cross-context copy parameters

    Attributes
    ----------
    srcXInBytes : size_t
        Source X in bytes
    srcY : size_t
        Source Y
    srcZ : size_t
        Source Z
    srcLOD : size_t
        Source LOD
    srcMemoryType : CUmemorytype
        Source memory type (host, device, array)
    srcHost : Any
        Source host pointer
    srcDevice : CUdeviceptr
        Source device pointer
    srcArray : CUarray
        Source array reference
    srcContext : CUcontext
        Source context (ignored with srcMemoryType is CU_MEMORYTYPE_ARRAY)
    srcPitch : size_t
        Source pitch (ignored when src is array)
    srcHeight : size_t
        Source height (ignored when src is array; may be 0 if Depth==1)
    dstXInBytes : size_t
        Destination X in bytes
    dstY : size_t
        Destination Y
    dstZ : size_t
        Destination Z
    dstLOD : size_t
        Destination LOD
    dstMemoryType : CUmemorytype
        Destination memory type (host, device, array)
    dstHost : Any
        Destination host pointer
    dstDevice : CUdeviceptr
        Destination device pointer
    dstArray : CUarray
        Destination array reference
    dstContext : CUcontext
        Destination context (ignored with dstMemoryType is
        CU_MEMORYTYPE_ARRAY)
    dstPitch : size_t
        Destination pitch (ignored when dst is array)
    dstHeight : size_t
        Destination height (ignored when dst is array; may be 0 if
        Depth==1)
    WidthInBytes : size_t
        Width of 3D memory copy in bytes
    Height : size_t
        Height of 3D memory copy
    Depth : size_t
        Depth of 3D memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMCPY3D_PEER_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcDevice = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].srcDevice)
        self._srcArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].srcArray)
        self._srcContext = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].srcContext)
        self._dstDevice = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dstDevice)
        self._dstArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].dstArray)
        self._dstContext = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].dstContext)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcXInBytes : ' + str(self.srcXInBytes)]
            except ValueError:
                str_list += ['srcXInBytes : <ValueError>']
            try:
                str_list += ['srcY : ' + str(self.srcY)]
            except ValueError:
                str_list += ['srcY : <ValueError>']
            try:
                str_list += ['srcZ : ' + str(self.srcZ)]
            except ValueError:
                str_list += ['srcZ : <ValueError>']
            try:
                str_list += ['srcLOD : ' + str(self.srcLOD)]
            except ValueError:
                str_list += ['srcLOD : <ValueError>']
            try:
                str_list += ['srcMemoryType : ' + str(self.srcMemoryType)]
            except ValueError:
                str_list += ['srcMemoryType : <ValueError>']
            try:
                str_list += ['srcHost : ' + hex(self.srcHost)]
            except ValueError:
                str_list += ['srcHost : <ValueError>']
            try:
                str_list += ['srcDevice : ' + str(self.srcDevice)]
            except ValueError:
                str_list += ['srcDevice : <ValueError>']
            try:
                str_list += ['srcArray : ' + str(self.srcArray)]
            except ValueError:
                str_list += ['srcArray : <ValueError>']
            try:
                str_list += ['srcContext : ' + str(self.srcContext)]
            except ValueError:
                str_list += ['srcContext : <ValueError>']
            try:
                str_list += ['srcPitch : ' + str(self.srcPitch)]
            except ValueError:
                str_list += ['srcPitch : <ValueError>']
            try:
                str_list += ['srcHeight : ' + str(self.srcHeight)]
            except ValueError:
                str_list += ['srcHeight : <ValueError>']
            try:
                str_list += ['dstXInBytes : ' + str(self.dstXInBytes)]
            except ValueError:
                str_list += ['dstXInBytes : <ValueError>']
            try:
                str_list += ['dstY : ' + str(self.dstY)]
            except ValueError:
                str_list += ['dstY : <ValueError>']
            try:
                str_list += ['dstZ : ' + str(self.dstZ)]
            except ValueError:
                str_list += ['dstZ : <ValueError>']
            try:
                str_list += ['dstLOD : ' + str(self.dstLOD)]
            except ValueError:
                str_list += ['dstLOD : <ValueError>']
            try:
                str_list += ['dstMemoryType : ' + str(self.dstMemoryType)]
            except ValueError:
                str_list += ['dstMemoryType : <ValueError>']
            try:
                str_list += ['dstHost : ' + hex(self.dstHost)]
            except ValueError:
                str_list += ['dstHost : <ValueError>']
            try:
                str_list += ['dstDevice : ' + str(self.dstDevice)]
            except ValueError:
                str_list += ['dstDevice : <ValueError>']
            try:
                str_list += ['dstArray : ' + str(self.dstArray)]
            except ValueError:
                str_list += ['dstArray : <ValueError>']
            try:
                str_list += ['dstContext : ' + str(self.dstContext)]
            except ValueError:
                str_list += ['dstContext : <ValueError>']
            try:
                str_list += ['dstPitch : ' + str(self.dstPitch)]
            except ValueError:
                str_list += ['dstPitch : <ValueError>']
            try:
                str_list += ['dstHeight : ' + str(self.dstHeight)]
            except ValueError:
                str_list += ['dstHeight : <ValueError>']
            try:
                str_list += ['WidthInBytes : ' + str(self.WidthInBytes)]
            except ValueError:
                str_list += ['WidthInBytes : <ValueError>']
            try:
                str_list += ['Height : ' + str(self.Height)]
            except ValueError:
                str_list += ['Height : <ValueError>']
            try:
                str_list += ['Depth : ' + str(self.Depth)]
            except ValueError:
                str_list += ['Depth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcXInBytes(self):
        return self._pvt_ptr[0].srcXInBytes
    @srcXInBytes.setter
    def srcXInBytes(self, size_t srcXInBytes):
        self._pvt_ptr[0].srcXInBytes = srcXInBytes
    @property
    def srcY(self):
        return self._pvt_ptr[0].srcY
    @srcY.setter
    def srcY(self, size_t srcY):
        self._pvt_ptr[0].srcY = srcY
    @property
    def srcZ(self):
        return self._pvt_ptr[0].srcZ
    @srcZ.setter
    def srcZ(self, size_t srcZ):
        self._pvt_ptr[0].srcZ = srcZ
    @property
    def srcLOD(self):
        return self._pvt_ptr[0].srcLOD
    @srcLOD.setter
    def srcLOD(self, size_t srcLOD):
        self._pvt_ptr[0].srcLOD = srcLOD
    @property
    def srcMemoryType(self):
        if self._pvt_ptr[0].srcMemoryType not in _dict_CUmemorytype:
            return None
        return _dict_CUmemorytype[self._pvt_ptr[0].srcMemoryType]
    @srcMemoryType.setter
    def srcMemoryType(self, srcMemoryType not None : CUmemorytype):
        self._pvt_ptr[0].srcMemoryType = srcMemoryType.value
    @property
    def srcHost(self):
        return <void_ptr>self._pvt_ptr[0].srcHost
    @srcHost.setter
    def srcHost(self, srcHost):
        _csrcHost = _HelperInputVoidPtr(srcHost)
        self._pvt_ptr[0].srcHost = <void*><void_ptr>_csrcHost.cptr
    @property
    def srcDevice(self):
        return self._srcDevice
    @srcDevice.setter
    def srcDevice(self, srcDevice):
        cdef cydriver.CUdeviceptr cysrcDevice
        if srcDevice is None:
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(srcDevice, (CUdeviceptr)):
            psrcDevice = int(srcDevice)
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
        else:
            psrcDevice = int(CUdeviceptr(srcDevice))
            cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
        self._srcDevice._pvt_ptr[0] = cysrcDevice

    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef cydriver.CUarray cysrcArray
        if srcArray is None:
            cysrcArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(srcArray, (CUarray,)):
            psrcArray = int(srcArray)
            cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
        else:
            psrcArray = int(CUarray(srcArray))
            cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
        self._srcArray._pvt_ptr[0] = cysrcArray
    @property
    def srcContext(self):
        return self._srcContext
    @srcContext.setter
    def srcContext(self, srcContext):
        cdef cydriver.CUcontext cysrcContext
        if srcContext is None:
            cysrcContext = <cydriver.CUcontext><void_ptr>0
        elif isinstance(srcContext, (CUcontext,)):
            psrcContext = int(srcContext)
            cysrcContext = <cydriver.CUcontext><void_ptr>psrcContext
        else:
            psrcContext = int(CUcontext(srcContext))
            cysrcContext = <cydriver.CUcontext><void_ptr>psrcContext
        self._srcContext._pvt_ptr[0] = cysrcContext
    @property
    def srcPitch(self):
        return self._pvt_ptr[0].srcPitch
    @srcPitch.setter
    def srcPitch(self, size_t srcPitch):
        self._pvt_ptr[0].srcPitch = srcPitch
    @property
    def srcHeight(self):
        return self._pvt_ptr[0].srcHeight
    @srcHeight.setter
    def srcHeight(self, size_t srcHeight):
        self._pvt_ptr[0].srcHeight = srcHeight
    @property
    def dstXInBytes(self):
        return self._pvt_ptr[0].dstXInBytes
    @dstXInBytes.setter
    def dstXInBytes(self, size_t dstXInBytes):
        self._pvt_ptr[0].dstXInBytes = dstXInBytes
    @property
    def dstY(self):
        return self._pvt_ptr[0].dstY
    @dstY.setter
    def dstY(self, size_t dstY):
        self._pvt_ptr[0].dstY = dstY
    @property
    def dstZ(self):
        return self._pvt_ptr[0].dstZ
    @dstZ.setter
    def dstZ(self, size_t dstZ):
        self._pvt_ptr[0].dstZ = dstZ
    @property
    def dstLOD(self):
        return self._pvt_ptr[0].dstLOD
    @dstLOD.setter
    def dstLOD(self, size_t dstLOD):
        self._pvt_ptr[0].dstLOD = dstLOD
    @property
    def dstMemoryType(self):
        if self._pvt_ptr[0].dstMemoryType not in _dict_CUmemorytype:
            return None
        return _dict_CUmemorytype[self._pvt_ptr[0].dstMemoryType]
    @dstMemoryType.setter
    def dstMemoryType(self, dstMemoryType not None : CUmemorytype):
        self._pvt_ptr[0].dstMemoryType = dstMemoryType.value
    @property
    def dstHost(self):
        return <void_ptr>self._pvt_ptr[0].dstHost
    @dstHost.setter
    def dstHost(self, dstHost):
        _cdstHost = _HelperInputVoidPtr(dstHost)
        self._pvt_ptr[0].dstHost = <void*><void_ptr>_cdstHost.cptr
    @property
    def dstDevice(self):
        return self._dstDevice
    @dstDevice.setter
    def dstDevice(self, dstDevice):
        cdef cydriver.CUdeviceptr cydstDevice
        if dstDevice is None:
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dstDevice, (CUdeviceptr)):
            pdstDevice = int(dstDevice)
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
        else:
            pdstDevice = int(CUdeviceptr(dstDevice))
            cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
        self._dstDevice._pvt_ptr[0] = cydstDevice

    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef cydriver.CUarray cydstArray
        if dstArray is None:
            cydstArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(dstArray, (CUarray,)):
            pdstArray = int(dstArray)
            cydstArray = <cydriver.CUarray><void_ptr>pdstArray
        else:
            pdstArray = int(CUarray(dstArray))
            cydstArray = <cydriver.CUarray><void_ptr>pdstArray
        self._dstArray._pvt_ptr[0] = cydstArray
    @property
    def dstContext(self):
        return self._dstContext
    @dstContext.setter
    def dstContext(self, dstContext):
        cdef cydriver.CUcontext cydstContext
        if dstContext is None:
            cydstContext = <cydriver.CUcontext><void_ptr>0
        elif isinstance(dstContext, (CUcontext,)):
            pdstContext = int(dstContext)
            cydstContext = <cydriver.CUcontext><void_ptr>pdstContext
        else:
            pdstContext = int(CUcontext(dstContext))
            cydstContext = <cydriver.CUcontext><void_ptr>pdstContext
        self._dstContext._pvt_ptr[0] = cydstContext
    @property
    def dstPitch(self):
        return self._pvt_ptr[0].dstPitch
    @dstPitch.setter
    def dstPitch(self, size_t dstPitch):
        self._pvt_ptr[0].dstPitch = dstPitch
    @property
    def dstHeight(self):
        return self._pvt_ptr[0].dstHeight
    @dstHeight.setter
    def dstHeight(self, size_t dstHeight):
        self._pvt_ptr[0].dstHeight = dstHeight
    @property
    def WidthInBytes(self):
        return self._pvt_ptr[0].WidthInBytes
    @WidthInBytes.setter
    def WidthInBytes(self, size_t WidthInBytes):
        self._pvt_ptr[0].WidthInBytes = WidthInBytes
    @property
    def Height(self):
        return self._pvt_ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        self._pvt_ptr[0].Height = Height
    @property
    def Depth(self):
        return self._pvt_ptr[0].Depth
    @Depth.setter
    def Depth(self, size_t Depth):
        self._pvt_ptr[0].Depth = Depth

cdef class CUDA_MEMCPY_NODE_PARAMS_st:
    """
    Memcpy node parameters

    Attributes
    ----------
    flags : int
        Must be zero
    reserved : int
        Must be zero
    copyCtx : CUcontext
        Context on which to run the node
    copyParams : CUDA_MEMCPY3D
        Parameters for the memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMCPY_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._copyCtx = CUcontext(_ptr=<void_ptr>&self._pvt_ptr[0].copyCtx)
        self._copyParams = CUDA_MEMCPY3D(_ptr=<void_ptr>&self._pvt_ptr[0].copyParams)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            try:
                str_list += ['copyCtx : ' + str(self.copyCtx)]
            except ValueError:
                str_list += ['copyCtx : <ValueError>']
            try:
                str_list += ['copyParams :\n' + '\n'.join(['    ' + line for line in str(self.copyParams).splitlines()])]
            except ValueError:
                str_list += ['copyParams : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, int reserved):
        self._pvt_ptr[0].reserved = reserved
    @property
    def copyCtx(self):
        return self._copyCtx
    @copyCtx.setter
    def copyCtx(self, copyCtx):
        cdef cydriver.CUcontext cycopyCtx
        if copyCtx is None:
            cycopyCtx = <cydriver.CUcontext><void_ptr>0
        elif isinstance(copyCtx, (CUcontext,)):
            pcopyCtx = int(copyCtx)
            cycopyCtx = <cydriver.CUcontext><void_ptr>pcopyCtx
        else:
            pcopyCtx = int(CUcontext(copyCtx))
            cycopyCtx = <cydriver.CUcontext><void_ptr>pcopyCtx
        self._copyCtx._pvt_ptr[0] = cycopyCtx
    @property
    def copyParams(self):
        return self._copyParams
    @copyParams.setter
    def copyParams(self, copyParams not None : CUDA_MEMCPY3D):
        string.memcpy(&self._pvt_ptr[0].copyParams, <cydriver.CUDA_MEMCPY3D*><void_ptr>copyParams.getPtr(), sizeof(self._pvt_ptr[0].copyParams))

cdef class CUDA_ARRAY_DESCRIPTOR_st:
    """
    Array descriptor

    Attributes
    ----------
    Width : size_t
        Width of array
    Height : size_t
        Height of array
    Format : CUarray_format
        Array format
    NumChannels : unsigned int
        Channels per array element

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_ARRAY_DESCRIPTOR_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['Width : ' + str(self.Width)]
            except ValueError:
                str_list += ['Width : <ValueError>']
            try:
                str_list += ['Height : ' + str(self.Height)]
            except ValueError:
                str_list += ['Height : <ValueError>']
            try:
                str_list += ['Format : ' + str(self.Format)]
            except ValueError:
                str_list += ['Format : <ValueError>']
            try:
                str_list += ['NumChannels : ' + str(self.NumChannels)]
            except ValueError:
                str_list += ['NumChannels : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def Width(self):
        return self._pvt_ptr[0].Width
    @Width.setter
    def Width(self, size_t Width):
        self._pvt_ptr[0].Width = Width
    @property
    def Height(self):
        return self._pvt_ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        self._pvt_ptr[0].Height = Height
    @property
    def Format(self):
        if self._pvt_ptr[0].Format not in _dict_CUarray_format:
            return None
        return _dict_CUarray_format[self._pvt_ptr[0].Format]
    @Format.setter
    def Format(self, Format not None : CUarray_format):
        self._pvt_ptr[0].Format = Format.value
    @property
    def NumChannels(self):
        return self._pvt_ptr[0].NumChannels
    @NumChannels.setter
    def NumChannels(self, unsigned int NumChannels):
        self._pvt_ptr[0].NumChannels = NumChannels

cdef class CUDA_ARRAY3D_DESCRIPTOR_st:
    """
    3D array descriptor

    Attributes
    ----------
    Width : size_t
        Width of 3D array
    Height : size_t
        Height of 3D array
    Depth : size_t
        Depth of 3D array
    Format : CUarray_format
        Array format
    NumChannels : unsigned int
        Channels per array element
    Flags : unsigned int
        Flags

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_ARRAY3D_DESCRIPTOR_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['Width : ' + str(self.Width)]
            except ValueError:
                str_list += ['Width : <ValueError>']
            try:
                str_list += ['Height : ' + str(self.Height)]
            except ValueError:
                str_list += ['Height : <ValueError>']
            try:
                str_list += ['Depth : ' + str(self.Depth)]
            except ValueError:
                str_list += ['Depth : <ValueError>']
            try:
                str_list += ['Format : ' + str(self.Format)]
            except ValueError:
                str_list += ['Format : <ValueError>']
            try:
                str_list += ['NumChannels : ' + str(self.NumChannels)]
            except ValueError:
                str_list += ['NumChannels : <ValueError>']
            try:
                str_list += ['Flags : ' + str(self.Flags)]
            except ValueError:
                str_list += ['Flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def Width(self):
        return self._pvt_ptr[0].Width
    @Width.setter
    def Width(self, size_t Width):
        self._pvt_ptr[0].Width = Width
    @property
    def Height(self):
        return self._pvt_ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        self._pvt_ptr[0].Height = Height
    @property
    def Depth(self):
        return self._pvt_ptr[0].Depth
    @Depth.setter
    def Depth(self, size_t Depth):
        self._pvt_ptr[0].Depth = Depth
    @property
    def Format(self):
        if self._pvt_ptr[0].Format not in _dict_CUarray_format:
            return None
        return _dict_CUarray_format[self._pvt_ptr[0].Format]
    @Format.setter
    def Format(self, Format not None : CUarray_format):
        self._pvt_ptr[0].Format = Format.value
    @property
    def NumChannels(self):
        return self._pvt_ptr[0].NumChannels
    @NumChannels.setter
    def NumChannels(self, unsigned int NumChannels):
        self._pvt_ptr[0].NumChannels = NumChannels
    @property
    def Flags(self):
        return self._pvt_ptr[0].Flags
    @Flags.setter
    def Flags(self, unsigned int Flags):
        self._pvt_ptr[0].Flags = Flags

cdef class anon_struct6:
    """
    Attributes
    ----------
    width : unsigned int

    height : unsigned int

    depth : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_ARRAY_SPARSE_PROPERTIES_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].tileExtent
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def width(self):
        return self._pvt_ptr[0].tileExtent.width
    @width.setter
    def width(self, unsigned int width):
        self._pvt_ptr[0].tileExtent.width = width
    @property
    def height(self):
        return self._pvt_ptr[0].tileExtent.height
    @height.setter
    def height(self, unsigned int height):
        self._pvt_ptr[0].tileExtent.height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].tileExtent.depth
    @depth.setter
    def depth(self, unsigned int depth):
        self._pvt_ptr[0].tileExtent.depth = depth

cdef class CUDA_ARRAY_SPARSE_PROPERTIES_st:
    """
    CUDA array sparse properties

    Attributes
    ----------
    tileExtent : anon_struct6

    miptailFirstLevel : unsigned int
        First mip level at which the mip tail begins.
    miptailSize : unsigned long long
        Total size of the mip tail.
    flags : unsigned int
        Flags will either be zero or
        CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_ARRAY_SPARSE_PROPERTIES_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._tileExtent = anon_struct6(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['tileExtent :\n' + '\n'.join(['    ' + line for line in str(self.tileExtent).splitlines()])]
            except ValueError:
                str_list += ['tileExtent : <ValueError>']
            try:
                str_list += ['miptailFirstLevel : ' + str(self.miptailFirstLevel)]
            except ValueError:
                str_list += ['miptailFirstLevel : <ValueError>']
            try:
                str_list += ['miptailSize : ' + str(self.miptailSize)]
            except ValueError:
                str_list += ['miptailSize : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def tileExtent(self):
        return self._tileExtent
    @tileExtent.setter
    def tileExtent(self, tileExtent not None : anon_struct6):
        string.memcpy(&self._pvt_ptr[0].tileExtent, <cydriver.anon_struct6*><void_ptr>tileExtent.getPtr(), sizeof(self._pvt_ptr[0].tileExtent))
    @property
    def miptailFirstLevel(self):
        return self._pvt_ptr[0].miptailFirstLevel
    @miptailFirstLevel.setter
    def miptailFirstLevel(self, unsigned int miptailFirstLevel):
        self._pvt_ptr[0].miptailFirstLevel = miptailFirstLevel
    @property
    def miptailSize(self):
        return self._pvt_ptr[0].miptailSize
    @miptailSize.setter
    def miptailSize(self, unsigned long long miptailSize):
        self._pvt_ptr[0].miptailSize = miptailSize
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUDA_ARRAY_MEMORY_REQUIREMENTS_st:
    """
    CUDA array memory requirements

    Attributes
    ----------
    size : size_t
        Total required memory size
    alignment : size_t
        alignment requirement
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_ARRAY_MEMORY_REQUIREMENTS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['alignment : ' + str(self.alignment)]
            except ValueError:
                str_list += ['alignment : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, size_t size):
        self._pvt_ptr[0].size = size
    @property
    def alignment(self):
        return self._pvt_ptr[0].alignment
    @alignment.setter
    def alignment(self, size_t alignment):
        self._pvt_ptr[0].alignment = alignment
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct7:
    """
    Attributes
    ----------
    hArray : CUarray


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._hArray = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].res.array.hArray)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.array
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['hArray : ' + str(self.hArray)]
            except ValueError:
                str_list += ['hArray : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def hArray(self):
        return self._hArray
    @hArray.setter
    def hArray(self, hArray):
        cdef cydriver.CUarray cyhArray
        if hArray is None:
            cyhArray = <cydriver.CUarray><void_ptr>0
        elif isinstance(hArray, (CUarray,)):
            phArray = int(hArray)
            cyhArray = <cydriver.CUarray><void_ptr>phArray
        else:
            phArray = int(CUarray(hArray))
            cyhArray = <cydriver.CUarray><void_ptr>phArray
        self._hArray._pvt_ptr[0] = cyhArray

cdef class anon_struct8:
    """
    Attributes
    ----------
    hMipmappedArray : CUmipmappedArray


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._hMipmappedArray = CUmipmappedArray(_ptr=<void_ptr>&self._pvt_ptr[0].res.mipmap.hMipmappedArray)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.mipmap
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['hMipmappedArray : ' + str(self.hMipmappedArray)]
            except ValueError:
                str_list += ['hMipmappedArray : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def hMipmappedArray(self):
        return self._hMipmappedArray
    @hMipmappedArray.setter
    def hMipmappedArray(self, hMipmappedArray):
        cdef cydriver.CUmipmappedArray cyhMipmappedArray
        if hMipmappedArray is None:
            cyhMipmappedArray = <cydriver.CUmipmappedArray><void_ptr>0
        elif isinstance(hMipmappedArray, (CUmipmappedArray,)):
            phMipmappedArray = int(hMipmappedArray)
            cyhMipmappedArray = <cydriver.CUmipmappedArray><void_ptr>phMipmappedArray
        else:
            phMipmappedArray = int(CUmipmappedArray(hMipmappedArray))
            cyhMipmappedArray = <cydriver.CUmipmappedArray><void_ptr>phMipmappedArray
        self._hMipmappedArray._pvt_ptr[0] = cyhMipmappedArray

cdef class anon_struct9:
    """
    Attributes
    ----------
    devPtr : CUdeviceptr

    format : CUarray_format

    numChannels : unsigned int

    sizeInBytes : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._devPtr = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].res.linear.devPtr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.linear
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['devPtr : ' + str(self.devPtr)]
            except ValueError:
                str_list += ['devPtr : <ValueError>']
            try:
                str_list += ['format : ' + str(self.format)]
            except ValueError:
                str_list += ['format : <ValueError>']
            try:
                str_list += ['numChannels : ' + str(self.numChannels)]
            except ValueError:
                str_list += ['numChannels : <ValueError>']
            try:
                str_list += ['sizeInBytes : ' + str(self.sizeInBytes)]
            except ValueError:
                str_list += ['sizeInBytes : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def devPtr(self):
        return self._devPtr
    @devPtr.setter
    def devPtr(self, devPtr):
        cdef cydriver.CUdeviceptr cydevPtr
        if devPtr is None:
            cydevPtr = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(devPtr, (CUdeviceptr)):
            pdevPtr = int(devPtr)
            cydevPtr = <cydriver.CUdeviceptr><void_ptr>pdevPtr
        else:
            pdevPtr = int(CUdeviceptr(devPtr))
            cydevPtr = <cydriver.CUdeviceptr><void_ptr>pdevPtr
        self._devPtr._pvt_ptr[0] = cydevPtr

    @property
    def format(self):
        if self._pvt_ptr[0].res.linear.format not in _dict_CUarray_format:
            return None
        return _dict_CUarray_format[self._pvt_ptr[0].res.linear.format]
    @format.setter
    def format(self, format not None : CUarray_format):
        self._pvt_ptr[0].res.linear.format = format.value
    @property
    def numChannels(self):
        return self._pvt_ptr[0].res.linear.numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        self._pvt_ptr[0].res.linear.numChannels = numChannels
    @property
    def sizeInBytes(self):
        return self._pvt_ptr[0].res.linear.sizeInBytes
    @sizeInBytes.setter
    def sizeInBytes(self, size_t sizeInBytes):
        self._pvt_ptr[0].res.linear.sizeInBytes = sizeInBytes

cdef class anon_struct10:
    """
    Attributes
    ----------
    devPtr : CUdeviceptr

    format : CUarray_format

    numChannels : unsigned int

    width : size_t

    height : size_t

    pitchInBytes : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._devPtr = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].res.pitch2D.devPtr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.pitch2D
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['devPtr : ' + str(self.devPtr)]
            except ValueError:
                str_list += ['devPtr : <ValueError>']
            try:
                str_list += ['format : ' + str(self.format)]
            except ValueError:
                str_list += ['format : <ValueError>']
            try:
                str_list += ['numChannels : ' + str(self.numChannels)]
            except ValueError:
                str_list += ['numChannels : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['pitchInBytes : ' + str(self.pitchInBytes)]
            except ValueError:
                str_list += ['pitchInBytes : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def devPtr(self):
        return self._devPtr
    @devPtr.setter
    def devPtr(self, devPtr):
        cdef cydriver.CUdeviceptr cydevPtr
        if devPtr is None:
            cydevPtr = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(devPtr, (CUdeviceptr)):
            pdevPtr = int(devPtr)
            cydevPtr = <cydriver.CUdeviceptr><void_ptr>pdevPtr
        else:
            pdevPtr = int(CUdeviceptr(devPtr))
            cydevPtr = <cydriver.CUdeviceptr><void_ptr>pdevPtr
        self._devPtr._pvt_ptr[0] = cydevPtr

    @property
    def format(self):
        if self._pvt_ptr[0].res.pitch2D.format not in _dict_CUarray_format:
            return None
        return _dict_CUarray_format[self._pvt_ptr[0].res.pitch2D.format]
    @format.setter
    def format(self, format not None : CUarray_format):
        self._pvt_ptr[0].res.pitch2D.format = format.value
    @property
    def numChannels(self):
        return self._pvt_ptr[0].res.pitch2D.numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        self._pvt_ptr[0].res.pitch2D.numChannels = numChannels
    @property
    def width(self):
        return self._pvt_ptr[0].res.pitch2D.width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].res.pitch2D.width = width
    @property
    def height(self):
        return self._pvt_ptr[0].res.pitch2D.height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].res.pitch2D.height = height
    @property
    def pitchInBytes(self):
        return self._pvt_ptr[0].res.pitch2D.pitchInBytes
    @pitchInBytes.setter
    def pitchInBytes(self, size_t pitchInBytes):
        self._pvt_ptr[0].res.pitch2D.pitchInBytes = pitchInBytes

cdef class anon_struct11:
    """
    Attributes
    ----------
    reserved : list[int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.reserved
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return self._pvt_ptr[0].res.reserved.reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].res.reserved.reserved = reserved

cdef class anon_union4:
    """
    Attributes
    ----------
    array : anon_struct7

    mipmap : anon_struct8

    linear : anon_struct9

    pitch2D : anon_struct10

    reserved : anon_struct11


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._array = anon_struct7(_ptr=<void_ptr>self._pvt_ptr)
        self._mipmap = anon_struct8(_ptr=<void_ptr>self._pvt_ptr)
        self._linear = anon_struct9(_ptr=<void_ptr>self._pvt_ptr)
        self._pitch2D = anon_struct10(_ptr=<void_ptr>self._pvt_ptr)
        self._reserved = anon_struct11(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['array :\n' + '\n'.join(['    ' + line for line in str(self.array).splitlines()])]
            except ValueError:
                str_list += ['array : <ValueError>']
            try:
                str_list += ['mipmap :\n' + '\n'.join(['    ' + line for line in str(self.mipmap).splitlines()])]
            except ValueError:
                str_list += ['mipmap : <ValueError>']
            try:
                str_list += ['linear :\n' + '\n'.join(['    ' + line for line in str(self.linear).splitlines()])]
            except ValueError:
                str_list += ['linear : <ValueError>']
            try:
                str_list += ['pitch2D :\n' + '\n'.join(['    ' + line for line in str(self.pitch2D).splitlines()])]
            except ValueError:
                str_list += ['pitch2D : <ValueError>']
            try:
                str_list += ['reserved :\n' + '\n'.join(['    ' + line for line in str(self.reserved).splitlines()])]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array not None : anon_struct7):
        string.memcpy(&self._pvt_ptr[0].res.array, <cydriver.anon_struct7*><void_ptr>array.getPtr(), sizeof(self._pvt_ptr[0].res.array))
    @property
    def mipmap(self):
        return self._mipmap
    @mipmap.setter
    def mipmap(self, mipmap not None : anon_struct8):
        string.memcpy(&self._pvt_ptr[0].res.mipmap, <cydriver.anon_struct8*><void_ptr>mipmap.getPtr(), sizeof(self._pvt_ptr[0].res.mipmap))
    @property
    def linear(self):
        return self._linear
    @linear.setter
    def linear(self, linear not None : anon_struct9):
        string.memcpy(&self._pvt_ptr[0].res.linear, <cydriver.anon_struct9*><void_ptr>linear.getPtr(), sizeof(self._pvt_ptr[0].res.linear))
    @property
    def pitch2D(self):
        return self._pitch2D
    @pitch2D.setter
    def pitch2D(self, pitch2D not None : anon_struct10):
        string.memcpy(&self._pvt_ptr[0].res.pitch2D, <cydriver.anon_struct10*><void_ptr>pitch2D.getPtr(), sizeof(self._pvt_ptr[0].res.pitch2D))
    @property
    def reserved(self):
        return self._reserved
    @reserved.setter
    def reserved(self, reserved not None : anon_struct11):
        string.memcpy(&self._pvt_ptr[0].res.reserved, <cydriver.anon_struct11*><void_ptr>reserved.getPtr(), sizeof(self._pvt_ptr[0].res.reserved))

cdef class CUDA_RESOURCE_DESC_st:
    """
    CUDA Resource descriptor

    Attributes
    ----------
    resType : CUresourcetype
        Resource type
    res : anon_union4

    flags : unsigned int
        Flags (must be zero)

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>calloc(1, sizeof(cydriver.CUDA_RESOURCE_DESC_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._res = anon_union4(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['resType : ' + str(self.resType)]
            except ValueError:
                str_list += ['resType : <ValueError>']
            try:
                str_list += ['res :\n' + '\n'.join(['    ' + line for line in str(self.res).splitlines()])]
            except ValueError:
                str_list += ['res : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def resType(self):
        if self._pvt_ptr[0].resType not in _dict_CUresourcetype:
            return None
        return _dict_CUresourcetype[self._pvt_ptr[0].resType]
    @resType.setter
    def resType(self, resType not None : CUresourcetype):
        self._pvt_ptr[0].resType = resType.value
    @property
    def res(self):
        return self._res
    @res.setter
    def res(self, res not None : anon_union4):
        string.memcpy(&self._pvt_ptr[0].res, <cydriver.anon_union4*><void_ptr>res.getPtr(), sizeof(self._pvt_ptr[0].res))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class CUDA_TEXTURE_DESC_st:
    """
    Texture descriptor

    Attributes
    ----------
    addressMode : list[CUaddress_mode]
        Address modes
    filterMode : CUfilter_mode
        Filter mode
    flags : unsigned int
        Flags
    maxAnisotropy : unsigned int
        Maximum anisotropy ratio
    mipmapFilterMode : CUfilter_mode
        Mipmap filter mode
    mipmapLevelBias : float
        Mipmap level bias
    minMipmapLevelClamp : float
        Mipmap minimum level clamp
    maxMipmapLevelClamp : float
        Mipmap maximum level clamp
    borderColor : list[float]
        Border Color
    reserved : list[int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_TEXTURE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['addressMode : ' + str(self.addressMode)]
            except ValueError:
                str_list += ['addressMode : <ValueError>']
            try:
                str_list += ['filterMode : ' + str(self.filterMode)]
            except ValueError:
                str_list += ['filterMode : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['maxAnisotropy : ' + str(self.maxAnisotropy)]
            except ValueError:
                str_list += ['maxAnisotropy : <ValueError>']
            try:
                str_list += ['mipmapFilterMode : ' + str(self.mipmapFilterMode)]
            except ValueError:
                str_list += ['mipmapFilterMode : <ValueError>']
            try:
                str_list += ['mipmapLevelBias : ' + str(self.mipmapLevelBias)]
            except ValueError:
                str_list += ['mipmapLevelBias : <ValueError>']
            try:
                str_list += ['minMipmapLevelClamp : ' + str(self.minMipmapLevelClamp)]
            except ValueError:
                str_list += ['minMipmapLevelClamp : <ValueError>']
            try:
                str_list += ['maxMipmapLevelClamp : ' + str(self.maxMipmapLevelClamp)]
            except ValueError:
                str_list += ['maxMipmapLevelClamp : <ValueError>']
            try:
                str_list += ['borderColor : ' + str(self.borderColor)]
            except ValueError:
                str_list += ['borderColor : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def addressMode(self):
        return [_dict_CUaddress_mode[_x] if _x in _dict_CUaddress_mode else None for _x in list(self._pvt_ptr[0].addressMode)]
    @addressMode.setter
    def addressMode(self, addressMode):
        self._pvt_ptr[0].addressMode = [_x.value for _x in addressMode]
    @property
    def filterMode(self):
        if self._pvt_ptr[0].filterMode not in _dict_CUfilter_mode:
            return None
        return _dict_CUfilter_mode[self._pvt_ptr[0].filterMode]
    @filterMode.setter
    def filterMode(self, filterMode not None : CUfilter_mode):
        self._pvt_ptr[0].filterMode = filterMode.value
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def maxAnisotropy(self):
        return self._pvt_ptr[0].maxAnisotropy
    @maxAnisotropy.setter
    def maxAnisotropy(self, unsigned int maxAnisotropy):
        self._pvt_ptr[0].maxAnisotropy = maxAnisotropy
    @property
    def mipmapFilterMode(self):
        if self._pvt_ptr[0].mipmapFilterMode not in _dict_CUfilter_mode:
            return None
        return _dict_CUfilter_mode[self._pvt_ptr[0].mipmapFilterMode]
    @mipmapFilterMode.setter
    def mipmapFilterMode(self, mipmapFilterMode not None : CUfilter_mode):
        self._pvt_ptr[0].mipmapFilterMode = mipmapFilterMode.value
    @property
    def mipmapLevelBias(self):
        return self._pvt_ptr[0].mipmapLevelBias
    @mipmapLevelBias.setter
    def mipmapLevelBias(self, float mipmapLevelBias):
        self._pvt_ptr[0].mipmapLevelBias = mipmapLevelBias
    @property
    def minMipmapLevelClamp(self):
        return self._pvt_ptr[0].minMipmapLevelClamp
    @minMipmapLevelClamp.setter
    def minMipmapLevelClamp(self, float minMipmapLevelClamp):
        self._pvt_ptr[0].minMipmapLevelClamp = minMipmapLevelClamp
    @property
    def maxMipmapLevelClamp(self):
        return self._pvt_ptr[0].maxMipmapLevelClamp
    @maxMipmapLevelClamp.setter
    def maxMipmapLevelClamp(self, float maxMipmapLevelClamp):
        self._pvt_ptr[0].maxMipmapLevelClamp = maxMipmapLevelClamp
    @property
    def borderColor(self):
        return self._pvt_ptr[0].borderColor
    @borderColor.setter
    def borderColor(self, borderColor):
        self._pvt_ptr[0].borderColor = borderColor
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUDA_RESOURCE_VIEW_DESC_st:
    """
    Resource view descriptor

    Attributes
    ----------
    format : CUresourceViewFormat
        Resource view format
    width : size_t
        Width of the resource view
    height : size_t
        Height of the resource view
    depth : size_t
        Depth of the resource view
    firstMipmapLevel : unsigned int
        First defined mipmap level
    lastMipmapLevel : unsigned int
        Last defined mipmap level
    firstLayer : unsigned int
        First layer index
    lastLayer : unsigned int
        Last layer index
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_RESOURCE_VIEW_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['format : ' + str(self.format)]
            except ValueError:
                str_list += ['format : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            try:
                str_list += ['firstMipmapLevel : ' + str(self.firstMipmapLevel)]
            except ValueError:
                str_list += ['firstMipmapLevel : <ValueError>']
            try:
                str_list += ['lastMipmapLevel : ' + str(self.lastMipmapLevel)]
            except ValueError:
                str_list += ['lastMipmapLevel : <ValueError>']
            try:
                str_list += ['firstLayer : ' + str(self.firstLayer)]
            except ValueError:
                str_list += ['firstLayer : <ValueError>']
            try:
                str_list += ['lastLayer : ' + str(self.lastLayer)]
            except ValueError:
                str_list += ['lastLayer : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def format(self):
        if self._pvt_ptr[0].format not in _dict_CUresourceViewFormat:
            return None
        return _dict_CUresourceViewFormat[self._pvt_ptr[0].format]
    @format.setter
    def format(self, format not None : CUresourceViewFormat):
        self._pvt_ptr[0].format = format.value
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].depth
    @depth.setter
    def depth(self, size_t depth):
        self._pvt_ptr[0].depth = depth
    @property
    def firstMipmapLevel(self):
        return self._pvt_ptr[0].firstMipmapLevel
    @firstMipmapLevel.setter
    def firstMipmapLevel(self, unsigned int firstMipmapLevel):
        self._pvt_ptr[0].firstMipmapLevel = firstMipmapLevel
    @property
    def lastMipmapLevel(self):
        return self._pvt_ptr[0].lastMipmapLevel
    @lastMipmapLevel.setter
    def lastMipmapLevel(self, unsigned int lastMipmapLevel):
        self._pvt_ptr[0].lastMipmapLevel = lastMipmapLevel
    @property
    def firstLayer(self):
        return self._pvt_ptr[0].firstLayer
    @firstLayer.setter
    def firstLayer(self, unsigned int firstLayer):
        self._pvt_ptr[0].firstLayer = firstLayer
    @property
    def lastLayer(self):
        return self._pvt_ptr[0].lastLayer
    @lastLayer.setter
    def lastLayer(self, unsigned int lastLayer):
        self._pvt_ptr[0].lastLayer = lastLayer
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUtensorMap_st:
    """
    Tensor map descriptor. Requires compiler support for aligning to
    128 bytes.

    Attributes
    ----------
    opaque : list[cuuint64_t]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUtensorMap_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['opaque : ' + str(self.opaque)]
            except ValueError:
                str_list += ['opaque : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def opaque(self):
        return [cuuint64_t(init_value=_opaque) for _opaque in self._pvt_ptr[0].opaque]
    @opaque.setter
    def opaque(self, opaque):
        self._pvt_ptr[0].opaque = opaque


cdef class CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st:
    """
    GPU Direct v3 tokens

    Attributes
    ----------
    p2pToken : unsigned long long

    vaSpaceToken : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['p2pToken : ' + str(self.p2pToken)]
            except ValueError:
                str_list += ['p2pToken : <ValueError>']
            try:
                str_list += ['vaSpaceToken : ' + str(self.vaSpaceToken)]
            except ValueError:
                str_list += ['vaSpaceToken : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def p2pToken(self):
        return self._pvt_ptr[0].p2pToken
    @p2pToken.setter
    def p2pToken(self, unsigned long long p2pToken):
        self._pvt_ptr[0].p2pToken = p2pToken
    @property
    def vaSpaceToken(self):
        return self._pvt_ptr[0].vaSpaceToken
    @vaSpaceToken.setter
    def vaSpaceToken(self, unsigned int vaSpaceToken):
        self._pvt_ptr[0].vaSpaceToken = vaSpaceToken

cdef class CUDA_LAUNCH_PARAMS_st:
    """
    Kernel launch parameters

    Attributes
    ----------
    function : CUfunction
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    hStream : CUstream
        Stream identifier
    kernelParams : Any
        Array of pointers to kernel parameters

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_LAUNCH_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._function = CUfunction(_ptr=<void_ptr>&self._pvt_ptr[0].function)
        self._hStream = CUstream(_ptr=<void_ptr>&self._pvt_ptr[0].hStream)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['function : ' + str(self.function)]
            except ValueError:
                str_list += ['function : <ValueError>']
            try:
                str_list += ['gridDimX : ' + str(self.gridDimX)]
            except ValueError:
                str_list += ['gridDimX : <ValueError>']
            try:
                str_list += ['gridDimY : ' + str(self.gridDimY)]
            except ValueError:
                str_list += ['gridDimY : <ValueError>']
            try:
                str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            except ValueError:
                str_list += ['gridDimZ : <ValueError>']
            try:
                str_list += ['blockDimX : ' + str(self.blockDimX)]
            except ValueError:
                str_list += ['blockDimX : <ValueError>']
            try:
                str_list += ['blockDimY : ' + str(self.blockDimY)]
            except ValueError:
                str_list += ['blockDimY : <ValueError>']
            try:
                str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            except ValueError:
                str_list += ['blockDimZ : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['hStream : ' + str(self.hStream)]
            except ValueError:
                str_list += ['hStream : <ValueError>']
            try:
                str_list += ['kernelParams : ' + str(self.kernelParams)]
            except ValueError:
                str_list += ['kernelParams : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def function(self):
        return self._function
    @function.setter
    def function(self, function):
        cdef cydriver.CUfunction cyfunction
        if function is None:
            cyfunction = <cydriver.CUfunction><void_ptr>0
        elif isinstance(function, (CUfunction,)):
            pfunction = int(function)
            cyfunction = <cydriver.CUfunction><void_ptr>pfunction
        else:
            pfunction = int(CUfunction(function))
            cyfunction = <cydriver.CUfunction><void_ptr>pfunction
        self._function._pvt_ptr[0] = cyfunction
    @property
    def gridDimX(self):
        return self._pvt_ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        self._pvt_ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._pvt_ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        self._pvt_ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._pvt_ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        self._pvt_ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._pvt_ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        self._pvt_ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._pvt_ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        self._pvt_ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._pvt_ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        self._pvt_ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def hStream(self):
        return self._hStream
    @hStream.setter
    def hStream(self, hStream):
        cdef cydriver.CUstream cyhStream
        if hStream is None:
            cyhStream = <cydriver.CUstream><void_ptr>0
        elif isinstance(hStream, (CUstream,)):
            phStream = int(hStream)
            cyhStream = <cydriver.CUstream><void_ptr>phStream
        else:
            phStream = int(CUstream(hStream))
            cyhStream = <cydriver.CUstream><void_ptr>phStream
        self._hStream._pvt_ptr[0] = cyhStream
    @property
    def kernelParams(self):
        return <void_ptr>self._pvt_ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._cykernelParams = _HelperKernelParams(kernelParams)
        self._pvt_ptr[0].kernelParams = <void**><void_ptr>self._cykernelParams.ckernelParams

cdef class anon_struct12:
    """
    Attributes
    ----------
    handle : Any

    name : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle.win32
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['handle : ' + hex(self.handle)]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['name : ' + hex(self.name)]
            except ValueError:
                str_list += ['name : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def handle(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.handle
    @handle.setter
    def handle(self, handle):
        _chandle = _HelperInputVoidPtr(handle)
        self._pvt_ptr[0].handle.win32.handle = <void*><void_ptr>_chandle.cptr
    @property
    def name(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.name
    @name.setter
    def name(self, name):
        _cname = _HelperInputVoidPtr(name)
        self._pvt_ptr[0].handle.win32.name = <void*><void_ptr>_cname.cptr

cdef class anon_union5:
    """
    Attributes
    ----------
    fd : int

    win32 : anon_struct12

    nvSciBufObject : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._win32 = anon_struct12(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fd : ' + str(self.fd)]
            except ValueError:
                str_list += ['fd : <ValueError>']
            try:
                str_list += ['win32 :\n' + '\n'.join(['    ' + line for line in str(self.win32).splitlines()])]
            except ValueError:
                str_list += ['win32 : <ValueError>']
            try:
                str_list += ['nvSciBufObject : ' + hex(self.nvSciBufObject)]
            except ValueError:
                str_list += ['nvSciBufObject : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fd(self):
        return self._pvt_ptr[0].handle.fd
    @fd.setter
    def fd(self, int fd):
        self._pvt_ptr[0].handle.fd = fd
    @property
    def win32(self):
        return self._win32
    @win32.setter
    def win32(self, win32 not None : anon_struct12):
        string.memcpy(&self._pvt_ptr[0].handle.win32, <cydriver.anon_struct12*><void_ptr>win32.getPtr(), sizeof(self._pvt_ptr[0].handle.win32))
    @property
    def nvSciBufObject(self):
        return <void_ptr>self._pvt_ptr[0].handle.nvSciBufObject
    @nvSciBufObject.setter
    def nvSciBufObject(self, nvSciBufObject):
        _cnvSciBufObject = _HelperInputVoidPtr(nvSciBufObject)
        self._pvt_ptr[0].handle.nvSciBufObject = <void*><void_ptr>_cnvSciBufObject.cptr

cdef class CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st:
    """
    External memory handle descriptor

    Attributes
    ----------
    type : CUexternalMemoryHandleType
        Type of the handle
    handle : anon_union5

    size : unsigned long long
        Size of the memory allocation
    flags : unsigned int
        Flags must either be zero or CUDA_EXTERNAL_MEMORY_DEDICATED
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>calloc(1, sizeof(cydriver.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._handle = anon_union5(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['handle :\n' + '\n'.join(['    ' + line for line in str(self.handle).splitlines()])]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUexternalMemoryHandleType:
            return None
        return _dict_CUexternalMemoryHandleType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUexternalMemoryHandleType):
        self._pvt_ptr[0].type = type.value
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle not None : anon_union5):
        string.memcpy(&self._pvt_ptr[0].handle, <cydriver.anon_union5*><void_ptr>handle.getPtr(), sizeof(self._pvt_ptr[0].handle))
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, unsigned long long size):
        self._pvt_ptr[0].size = size
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st:
    """
    External memory buffer descriptor

    Attributes
    ----------
    offset : unsigned long long
        Offset into the memory object where the buffer's base is
    size : unsigned long long
        Size of the buffer
    flags : unsigned int
        Flags reserved for future use. Must be zero.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def offset(self):
        return self._pvt_ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        self._pvt_ptr[0].offset = offset
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, unsigned long long size):
        self._pvt_ptr[0].size = size
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st:
    """
    External memory mipmap descriptor

    Attributes
    ----------
    offset : unsigned long long
        Offset into the memory object where the base level of the mipmap
        chain is.
    arrayDesc : CUDA_ARRAY3D_DESCRIPTOR
        Format, dimension and type of base level of the mipmap chain
    numLevels : unsigned int
        Total number of levels in the mipmap chain
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._arrayDesc = CUDA_ARRAY3D_DESCRIPTOR(_ptr=<void_ptr>&self._pvt_ptr[0].arrayDesc)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['arrayDesc :\n' + '\n'.join(['    ' + line for line in str(self.arrayDesc).splitlines()])]
            except ValueError:
                str_list += ['arrayDesc : <ValueError>']
            try:
                str_list += ['numLevels : ' + str(self.numLevels)]
            except ValueError:
                str_list += ['numLevels : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def offset(self):
        return self._pvt_ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        self._pvt_ptr[0].offset = offset
    @property
    def arrayDesc(self):
        return self._arrayDesc
    @arrayDesc.setter
    def arrayDesc(self, arrayDesc not None : CUDA_ARRAY3D_DESCRIPTOR):
        string.memcpy(&self._pvt_ptr[0].arrayDesc, <cydriver.CUDA_ARRAY3D_DESCRIPTOR*><void_ptr>arrayDesc.getPtr(), sizeof(self._pvt_ptr[0].arrayDesc))
    @property
    def numLevels(self):
        return self._pvt_ptr[0].numLevels
    @numLevels.setter
    def numLevels(self, unsigned int numLevels):
        self._pvt_ptr[0].numLevels = numLevels
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct13:
    """
    Attributes
    ----------
    handle : Any

    name : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle.win32
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['handle : ' + hex(self.handle)]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['name : ' + hex(self.name)]
            except ValueError:
                str_list += ['name : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def handle(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.handle
    @handle.setter
    def handle(self, handle):
        _chandle = _HelperInputVoidPtr(handle)
        self._pvt_ptr[0].handle.win32.handle = <void*><void_ptr>_chandle.cptr
    @property
    def name(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.name
    @name.setter
    def name(self, name):
        _cname = _HelperInputVoidPtr(name)
        self._pvt_ptr[0].handle.win32.name = <void*><void_ptr>_cname.cptr

cdef class anon_union6:
    """
    Attributes
    ----------
    fd : int

    win32 : anon_struct13

    nvSciSyncObj : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._win32 = anon_struct13(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fd : ' + str(self.fd)]
            except ValueError:
                str_list += ['fd : <ValueError>']
            try:
                str_list += ['win32 :\n' + '\n'.join(['    ' + line for line in str(self.win32).splitlines()])]
            except ValueError:
                str_list += ['win32 : <ValueError>']
            try:
                str_list += ['nvSciSyncObj : ' + hex(self.nvSciSyncObj)]
            except ValueError:
                str_list += ['nvSciSyncObj : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fd(self):
        return self._pvt_ptr[0].handle.fd
    @fd.setter
    def fd(self, int fd):
        self._pvt_ptr[0].handle.fd = fd
    @property
    def win32(self):
        return self._win32
    @win32.setter
    def win32(self, win32 not None : anon_struct13):
        string.memcpy(&self._pvt_ptr[0].handle.win32, <cydriver.anon_struct13*><void_ptr>win32.getPtr(), sizeof(self._pvt_ptr[0].handle.win32))
    @property
    def nvSciSyncObj(self):
        return <void_ptr>self._pvt_ptr[0].handle.nvSciSyncObj
    @nvSciSyncObj.setter
    def nvSciSyncObj(self, nvSciSyncObj):
        _cnvSciSyncObj = _HelperInputVoidPtr(nvSciSyncObj)
        self._pvt_ptr[0].handle.nvSciSyncObj = <void*><void_ptr>_cnvSciSyncObj.cptr

cdef class CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st:
    """
    External semaphore handle descriptor

    Attributes
    ----------
    type : CUexternalSemaphoreHandleType
        Type of the handle
    handle : anon_union6

    flags : unsigned int
        Flags reserved for the future. Must be zero.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>calloc(1, sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._handle = anon_union6(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['handle :\n' + '\n'.join(['    ' + line for line in str(self.handle).splitlines()])]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUexternalSemaphoreHandleType:
            return None
        return _dict_CUexternalSemaphoreHandleType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUexternalSemaphoreHandleType):
        self._pvt_ptr[0].type = type.value
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle not None : anon_union6):
        string.memcpy(&self._pvt_ptr[0].handle, <cydriver.anon_union6*><void_ptr>handle.getPtr(), sizeof(self._pvt_ptr[0].handle))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct14:
    """
    Attributes
    ----------
    value : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.fence
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def value(self):
        return self._pvt_ptr[0].params.fence.value
    @value.setter
    def value(self, unsigned long long value):
        self._pvt_ptr[0].params.fence.value = value

cdef class anon_union7:
    """
    Attributes
    ----------
    fence : Any

    reserved : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.nvSciSync
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence : ' + hex(self.fence)]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return <void_ptr>self._pvt_ptr[0].params.nvSciSync.fence
    @fence.setter
    def fence(self, fence):
        _cfence = _HelperInputVoidPtr(fence)
        self._pvt_ptr[0].params.nvSciSync.fence = <void*><void_ptr>_cfence.cptr
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.nvSciSync.reserved
    @reserved.setter
    def reserved(self, unsigned long long reserved):
        self._pvt_ptr[0].params.nvSciSync.reserved = reserved

cdef class anon_struct15:
    """
    Attributes
    ----------
    key : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.keyedMutex
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['key : ' + str(self.key)]
            except ValueError:
                str_list += ['key : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def key(self):
        return self._pvt_ptr[0].params.keyedMutex.key
    @key.setter
    def key(self, unsigned long long key):
        self._pvt_ptr[0].params.keyedMutex.key = key

cdef class anon_struct16:
    """
    Attributes
    ----------
    fence : anon_struct14

    nvSciSync : anon_union7

    keyedMutex : anon_struct15

    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._fence = anon_struct14(_ptr=<void_ptr>self._pvt_ptr)
        self._nvSciSync = anon_union7(_ptr=<void_ptr>self._pvt_ptr)
        self._keyedMutex = anon_struct15(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence :\n' + '\n'.join(['    ' + line for line in str(self.fence).splitlines()])]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['nvSciSync :\n' + '\n'.join(['    ' + line for line in str(self.nvSciSync).splitlines()])]
            except ValueError:
                str_list += ['nvSciSync : <ValueError>']
            try:
                str_list += ['keyedMutex :\n' + '\n'.join(['    ' + line for line in str(self.keyedMutex).splitlines()])]
            except ValueError:
                str_list += ['keyedMutex : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return self._fence
    @fence.setter
    def fence(self, fence not None : anon_struct14):
        string.memcpy(&self._pvt_ptr[0].params.fence, <cydriver.anon_struct14*><void_ptr>fence.getPtr(), sizeof(self._pvt_ptr[0].params.fence))
    @property
    def nvSciSync(self):
        return self._nvSciSync
    @nvSciSync.setter
    def nvSciSync(self, nvSciSync not None : anon_union7):
        string.memcpy(&self._pvt_ptr[0].params.nvSciSync, <cydriver.anon_union7*><void_ptr>nvSciSync.getPtr(), sizeof(self._pvt_ptr[0].params.nvSciSync))
    @property
    def keyedMutex(self):
        return self._keyedMutex
    @keyedMutex.setter
    def keyedMutex(self, keyedMutex not None : anon_struct15):
        string.memcpy(&self._pvt_ptr[0].params.keyedMutex, <cydriver.anon_struct15*><void_ptr>keyedMutex.getPtr(), sizeof(self._pvt_ptr[0].params.keyedMutex))
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].params.reserved = reserved

cdef class CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st:
    """
    External semaphore signal parameters

    Attributes
    ----------
    params : anon_struct16

    flags : unsigned int
        Only when ::CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS is used to signal
        a CUexternalSemaphore of type
        CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, the valid flag is
        CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC which
        indicates that while signaling the CUexternalSemaphore, no memory
        synchronization operations should be performed for any external
        memory object imported as CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF.
        For all other types of CUexternalSemaphore, flags must be zero.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._params = anon_struct16(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['params :\n' + '\n'.join(['    ' + line for line in str(self.params).splitlines()])]
            except ValueError:
                str_list += ['params : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def params(self):
        return self._params
    @params.setter
    def params(self, params not None : anon_struct16):
        string.memcpy(&self._pvt_ptr[0].params, <cydriver.anon_struct16*><void_ptr>params.getPtr(), sizeof(self._pvt_ptr[0].params))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct17:
    """
    Attributes
    ----------
    value : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.fence
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def value(self):
        return self._pvt_ptr[0].params.fence.value
    @value.setter
    def value(self, unsigned long long value):
        self._pvt_ptr[0].params.fence.value = value

cdef class anon_union8:
    """
    Attributes
    ----------
    fence : Any

    reserved : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.nvSciSync
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence : ' + hex(self.fence)]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return <void_ptr>self._pvt_ptr[0].params.nvSciSync.fence
    @fence.setter
    def fence(self, fence):
        _cfence = _HelperInputVoidPtr(fence)
        self._pvt_ptr[0].params.nvSciSync.fence = <void*><void_ptr>_cfence.cptr
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.nvSciSync.reserved
    @reserved.setter
    def reserved(self, unsigned long long reserved):
        self._pvt_ptr[0].params.nvSciSync.reserved = reserved

cdef class anon_struct18:
    """
    Attributes
    ----------
    key : unsigned long long

    timeoutMs : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.keyedMutex
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['key : ' + str(self.key)]
            except ValueError:
                str_list += ['key : <ValueError>']
            try:
                str_list += ['timeoutMs : ' + str(self.timeoutMs)]
            except ValueError:
                str_list += ['timeoutMs : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def key(self):
        return self._pvt_ptr[0].params.keyedMutex.key
    @key.setter
    def key(self, unsigned long long key):
        self._pvt_ptr[0].params.keyedMutex.key = key
    @property
    def timeoutMs(self):
        return self._pvt_ptr[0].params.keyedMutex.timeoutMs
    @timeoutMs.setter
    def timeoutMs(self, unsigned int timeoutMs):
        self._pvt_ptr[0].params.keyedMutex.timeoutMs = timeoutMs

cdef class anon_struct19:
    """
    Attributes
    ----------
    fence : anon_struct17

    nvSciSync : anon_union8

    keyedMutex : anon_struct18

    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._fence = anon_struct17(_ptr=<void_ptr>self._pvt_ptr)
        self._nvSciSync = anon_union8(_ptr=<void_ptr>self._pvt_ptr)
        self._keyedMutex = anon_struct18(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence :\n' + '\n'.join(['    ' + line for line in str(self.fence).splitlines()])]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['nvSciSync :\n' + '\n'.join(['    ' + line for line in str(self.nvSciSync).splitlines()])]
            except ValueError:
                str_list += ['nvSciSync : <ValueError>']
            try:
                str_list += ['keyedMutex :\n' + '\n'.join(['    ' + line for line in str(self.keyedMutex).splitlines()])]
            except ValueError:
                str_list += ['keyedMutex : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return self._fence
    @fence.setter
    def fence(self, fence not None : anon_struct17):
        string.memcpy(&self._pvt_ptr[0].params.fence, <cydriver.anon_struct17*><void_ptr>fence.getPtr(), sizeof(self._pvt_ptr[0].params.fence))
    @property
    def nvSciSync(self):
        return self._nvSciSync
    @nvSciSync.setter
    def nvSciSync(self, nvSciSync not None : anon_union8):
        string.memcpy(&self._pvt_ptr[0].params.nvSciSync, <cydriver.anon_union8*><void_ptr>nvSciSync.getPtr(), sizeof(self._pvt_ptr[0].params.nvSciSync))
    @property
    def keyedMutex(self):
        return self._keyedMutex
    @keyedMutex.setter
    def keyedMutex(self, keyedMutex not None : anon_struct18):
        string.memcpy(&self._pvt_ptr[0].params.keyedMutex, <cydriver.anon_struct18*><void_ptr>keyedMutex.getPtr(), sizeof(self._pvt_ptr[0].params.keyedMutex))
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].params.reserved = reserved

cdef class CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st:
    """
    External semaphore wait parameters

    Attributes
    ----------
    params : anon_struct19

    flags : unsigned int
        Only when ::CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS is used to wait on
        a CUexternalSemaphore of type
        CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, the valid flag is
        CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC which indicates
        that while waiting for the CUexternalSemaphore, no memory
        synchronization operations should be performed for any external
        memory object imported as CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF.
        For all other types of CUexternalSemaphore, flags must be zero.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._params = anon_struct19(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['params :\n' + '\n'.join(['    ' + line for line in str(self.params).splitlines()])]
            except ValueError:
                str_list += ['params : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def params(self):
        return self._params
    @params.setter
    def params(self, params not None : anon_struct19):
        string.memcpy(&self._pvt_ptr[0].params, <cydriver.anon_struct19*><void_ptr>params.getPtr(), sizeof(self._pvt_ptr[0].params))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st:
    """
    Semaphore signal node parameters

    Attributes
    ----------
    extSemArray : CUexternalSemaphore
        Array of external semaphore handles.
    paramsArray : CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS
        Array of external semaphore signal parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cydriver.CUexternalSemaphore) for x in range(self._extSemArray_length)]
        return [CUexternalSemaphore(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cydriver.CUexternalSemaphore*> calloc(len(val), sizeof(cydriver.CUexternalSemaphore))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUexternalSemaphore)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<CUexternalSemaphore>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS) for x in range(self._paramsArray_length)]
        return [CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS*> calloc(len(val), sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS>val[idx])._pvt_ptr, sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2_st:
    """
    Semaphore signal node parameters

    Attributes
    ----------
    extSemArray : CUexternalSemaphore
        Array of external semaphore handles.
    paramsArray : CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS
        Array of external semaphore signal parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cydriver.CUexternalSemaphore) for x in range(self._extSemArray_length)]
        return [CUexternalSemaphore(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cydriver.CUexternalSemaphore*> calloc(len(val), sizeof(cydriver.CUexternalSemaphore))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUexternalSemaphore)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<CUexternalSemaphore>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS) for x in range(self._paramsArray_length)]
        return [CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS*> calloc(len(val), sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS>val[idx])._pvt_ptr, sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class CUDA_EXT_SEM_WAIT_NODE_PARAMS_st:
    """
    Semaphore wait node parameters

    Attributes
    ----------
    extSemArray : CUexternalSemaphore
        Array of external semaphore handles.
    paramsArray : CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS
        Array of external semaphore wait parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXT_SEM_WAIT_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cydriver.CUexternalSemaphore) for x in range(self._extSemArray_length)]
        return [CUexternalSemaphore(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cydriver.CUexternalSemaphore*> calloc(len(val), sizeof(cydriver.CUexternalSemaphore))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUexternalSemaphore)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<CUexternalSemaphore>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS) for x in range(self._paramsArray_length)]
        return [CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS*> calloc(len(val), sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS>val[idx])._pvt_ptr, sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2_st:
    """
    Semaphore wait node parameters

    Attributes
    ----------
    extSemArray : CUexternalSemaphore
        Array of external semaphore handles.
    paramsArray : CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS
        Array of external semaphore wait parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cydriver.CUexternalSemaphore) for x in range(self._extSemArray_length)]
        return [CUexternalSemaphore(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cydriver.CUexternalSemaphore*> calloc(len(val), sizeof(cydriver.CUexternalSemaphore))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUexternalSemaphore)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<CUexternalSemaphore>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS) for x in range(self._paramsArray_length)]
        return [CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS*> calloc(len(val), sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS>val[idx])._pvt_ptr, sizeof(cydriver.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class anon_union9:
    """
    Attributes
    ----------
    mipmap : CUmipmappedArray

    array : CUarray


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUarrayMapInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._mipmap = CUmipmappedArray(_ptr=<void_ptr>&self._pvt_ptr[0].resource.mipmap)
        self._array = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].resource.array)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].resource
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['mipmap : ' + str(self.mipmap)]
            except ValueError:
                str_list += ['mipmap : <ValueError>']
            try:
                str_list += ['array : ' + str(self.array)]
            except ValueError:
                str_list += ['array : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def mipmap(self):
        return self._mipmap
    @mipmap.setter
    def mipmap(self, mipmap):
        cdef cydriver.CUmipmappedArray cymipmap
        if mipmap is None:
            cymipmap = <cydriver.CUmipmappedArray><void_ptr>0
        elif isinstance(mipmap, (CUmipmappedArray,)):
            pmipmap = int(mipmap)
            cymipmap = <cydriver.CUmipmappedArray><void_ptr>pmipmap
        else:
            pmipmap = int(CUmipmappedArray(mipmap))
            cymipmap = <cydriver.CUmipmappedArray><void_ptr>pmipmap
        self._mipmap._pvt_ptr[0] = cymipmap
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array):
        cdef cydriver.CUarray cyarray
        if array is None:
            cyarray = <cydriver.CUarray><void_ptr>0
        elif isinstance(array, (CUarray,)):
            parray = int(array)
            cyarray = <cydriver.CUarray><void_ptr>parray
        else:
            parray = int(CUarray(array))
            cyarray = <cydriver.CUarray><void_ptr>parray
        self._array._pvt_ptr[0] = cyarray

cdef class anon_struct20:
    """
    Attributes
    ----------
    level : unsigned int

    layer : unsigned int

    offsetX : unsigned int

    offsetY : unsigned int

    offsetZ : unsigned int

    extentWidth : unsigned int

    extentHeight : unsigned int

    extentDepth : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUarrayMapInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].subresource.sparseLevel
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['level : ' + str(self.level)]
            except ValueError:
                str_list += ['level : <ValueError>']
            try:
                str_list += ['layer : ' + str(self.layer)]
            except ValueError:
                str_list += ['layer : <ValueError>']
            try:
                str_list += ['offsetX : ' + str(self.offsetX)]
            except ValueError:
                str_list += ['offsetX : <ValueError>']
            try:
                str_list += ['offsetY : ' + str(self.offsetY)]
            except ValueError:
                str_list += ['offsetY : <ValueError>']
            try:
                str_list += ['offsetZ : ' + str(self.offsetZ)]
            except ValueError:
                str_list += ['offsetZ : <ValueError>']
            try:
                str_list += ['extentWidth : ' + str(self.extentWidth)]
            except ValueError:
                str_list += ['extentWidth : <ValueError>']
            try:
                str_list += ['extentHeight : ' + str(self.extentHeight)]
            except ValueError:
                str_list += ['extentHeight : <ValueError>']
            try:
                str_list += ['extentDepth : ' + str(self.extentDepth)]
            except ValueError:
                str_list += ['extentDepth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def level(self):
        return self._pvt_ptr[0].subresource.sparseLevel.level
    @level.setter
    def level(self, unsigned int level):
        self._pvt_ptr[0].subresource.sparseLevel.level = level
    @property
    def layer(self):
        return self._pvt_ptr[0].subresource.sparseLevel.layer
    @layer.setter
    def layer(self, unsigned int layer):
        self._pvt_ptr[0].subresource.sparseLevel.layer = layer
    @property
    def offsetX(self):
        return self._pvt_ptr[0].subresource.sparseLevel.offsetX
    @offsetX.setter
    def offsetX(self, unsigned int offsetX):
        self._pvt_ptr[0].subresource.sparseLevel.offsetX = offsetX
    @property
    def offsetY(self):
        return self._pvt_ptr[0].subresource.sparseLevel.offsetY
    @offsetY.setter
    def offsetY(self, unsigned int offsetY):
        self._pvt_ptr[0].subresource.sparseLevel.offsetY = offsetY
    @property
    def offsetZ(self):
        return self._pvt_ptr[0].subresource.sparseLevel.offsetZ
    @offsetZ.setter
    def offsetZ(self, unsigned int offsetZ):
        self._pvt_ptr[0].subresource.sparseLevel.offsetZ = offsetZ
    @property
    def extentWidth(self):
        return self._pvt_ptr[0].subresource.sparseLevel.extentWidth
    @extentWidth.setter
    def extentWidth(self, unsigned int extentWidth):
        self._pvt_ptr[0].subresource.sparseLevel.extentWidth = extentWidth
    @property
    def extentHeight(self):
        return self._pvt_ptr[0].subresource.sparseLevel.extentHeight
    @extentHeight.setter
    def extentHeight(self, unsigned int extentHeight):
        self._pvt_ptr[0].subresource.sparseLevel.extentHeight = extentHeight
    @property
    def extentDepth(self):
        return self._pvt_ptr[0].subresource.sparseLevel.extentDepth
    @extentDepth.setter
    def extentDepth(self, unsigned int extentDepth):
        self._pvt_ptr[0].subresource.sparseLevel.extentDepth = extentDepth

cdef class anon_struct21:
    """
    Attributes
    ----------
    layer : unsigned int

    offset : unsigned long long

    size : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUarrayMapInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].subresource.miptail
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['layer : ' + str(self.layer)]
            except ValueError:
                str_list += ['layer : <ValueError>']
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def layer(self):
        return self._pvt_ptr[0].subresource.miptail.layer
    @layer.setter
    def layer(self, unsigned int layer):
        self._pvt_ptr[0].subresource.miptail.layer = layer
    @property
    def offset(self):
        return self._pvt_ptr[0].subresource.miptail.offset
    @offset.setter
    def offset(self, unsigned long long offset):
        self._pvt_ptr[0].subresource.miptail.offset = offset
    @property
    def size(self):
        return self._pvt_ptr[0].subresource.miptail.size
    @size.setter
    def size(self, unsigned long long size):
        self._pvt_ptr[0].subresource.miptail.size = size

cdef class anon_union10:
    """
    Attributes
    ----------
    sparseLevel : anon_struct20

    miptail : anon_struct21


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUarrayMapInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._sparseLevel = anon_struct20(_ptr=<void_ptr>self._pvt_ptr)
        self._miptail = anon_struct21(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].subresource
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['sparseLevel :\n' + '\n'.join(['    ' + line for line in str(self.sparseLevel).splitlines()])]
            except ValueError:
                str_list += ['sparseLevel : <ValueError>']
            try:
                str_list += ['miptail :\n' + '\n'.join(['    ' + line for line in str(self.miptail).splitlines()])]
            except ValueError:
                str_list += ['miptail : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def sparseLevel(self):
        return self._sparseLevel
    @sparseLevel.setter
    def sparseLevel(self, sparseLevel not None : anon_struct20):
        string.memcpy(&self._pvt_ptr[0].subresource.sparseLevel, <cydriver.anon_struct20*><void_ptr>sparseLevel.getPtr(), sizeof(self._pvt_ptr[0].subresource.sparseLevel))
    @property
    def miptail(self):
        return self._miptail
    @miptail.setter
    def miptail(self, miptail not None : anon_struct21):
        string.memcpy(&self._pvt_ptr[0].subresource.miptail, <cydriver.anon_struct21*><void_ptr>miptail.getPtr(), sizeof(self._pvt_ptr[0].subresource.miptail))

cdef class anon_union11:
    """
    Attributes
    ----------
    memHandle : CUmemGenericAllocationHandle


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUarrayMapInfo_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._memHandle = CUmemGenericAllocationHandle(_ptr=<void_ptr>&self._pvt_ptr[0].memHandle.memHandle)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].memHandle
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['memHandle : ' + str(self.memHandle)]
            except ValueError:
                str_list += ['memHandle : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def memHandle(self):
        return self._memHandle
    @memHandle.setter
    def memHandle(self, memHandle):
        cdef cydriver.CUmemGenericAllocationHandle cymemHandle
        if memHandle is None:
            cymemHandle = <cydriver.CUmemGenericAllocationHandle><void_ptr>0
        elif isinstance(memHandle, (CUmemGenericAllocationHandle)):
            pmemHandle = int(memHandle)
            cymemHandle = <cydriver.CUmemGenericAllocationHandle><void_ptr>pmemHandle
        else:
            pmemHandle = int(CUmemGenericAllocationHandle(memHandle))
            cymemHandle = <cydriver.CUmemGenericAllocationHandle><void_ptr>pmemHandle
        self._memHandle._pvt_ptr[0] = cymemHandle


cdef class CUarrayMapInfo_st:
    """
    Specifies the CUDA array or CUDA mipmapped array memory mapping
    information

    Attributes
    ----------
    resourceType : CUresourcetype
        Resource type
    resource : anon_union9

    subresourceType : CUarraySparseSubresourceType
        Sparse subresource type
    subresource : anon_union10

    memOperationType : CUmemOperationType
        Memory operation type
    memHandleType : CUmemHandleType
        Memory handle type
    memHandle : anon_union11

    offset : unsigned long long
        Offset within mip tail  Offset within the memory
    deviceBitMask : unsigned int
        Device ordinal bit mask
    flags : unsigned int
        flags for future use, must be zero now.
    reserved : list[unsigned int]
        Reserved for future use, must be zero now.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUarrayMapInfo_st *>calloc(1, sizeof(cydriver.CUarrayMapInfo_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._resource = anon_union9(_ptr=<void_ptr>self._pvt_ptr)
        self._subresource = anon_union10(_ptr=<void_ptr>self._pvt_ptr)
        self._memHandle = anon_union11(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['resourceType : ' + str(self.resourceType)]
            except ValueError:
                str_list += ['resourceType : <ValueError>']
            try:
                str_list += ['resource :\n' + '\n'.join(['    ' + line for line in str(self.resource).splitlines()])]
            except ValueError:
                str_list += ['resource : <ValueError>']
            try:
                str_list += ['subresourceType : ' + str(self.subresourceType)]
            except ValueError:
                str_list += ['subresourceType : <ValueError>']
            try:
                str_list += ['subresource :\n' + '\n'.join(['    ' + line for line in str(self.subresource).splitlines()])]
            except ValueError:
                str_list += ['subresource : <ValueError>']
            try:
                str_list += ['memOperationType : ' + str(self.memOperationType)]
            except ValueError:
                str_list += ['memOperationType : <ValueError>']
            try:
                str_list += ['memHandleType : ' + str(self.memHandleType)]
            except ValueError:
                str_list += ['memHandleType : <ValueError>']
            try:
                str_list += ['memHandle :\n' + '\n'.join(['    ' + line for line in str(self.memHandle).splitlines()])]
            except ValueError:
                str_list += ['memHandle : <ValueError>']
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['deviceBitMask : ' + str(self.deviceBitMask)]
            except ValueError:
                str_list += ['deviceBitMask : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def resourceType(self):
        if self._pvt_ptr[0].resourceType not in _dict_CUresourcetype:
            return None
        return _dict_CUresourcetype[self._pvt_ptr[0].resourceType]
    @resourceType.setter
    def resourceType(self, resourceType not None : CUresourcetype):
        self._pvt_ptr[0].resourceType = resourceType.value
    @property
    def resource(self):
        return self._resource
    @resource.setter
    def resource(self, resource not None : anon_union9):
        string.memcpy(&self._pvt_ptr[0].resource, <cydriver.anon_union9*><void_ptr>resource.getPtr(), sizeof(self._pvt_ptr[0].resource))
    @property
    def subresourceType(self):
        if self._pvt_ptr[0].subresourceType not in _dict_CUarraySparseSubresourceType:
            return None
        return _dict_CUarraySparseSubresourceType[self._pvt_ptr[0].subresourceType]
    @subresourceType.setter
    def subresourceType(self, subresourceType not None : CUarraySparseSubresourceType):
        self._pvt_ptr[0].subresourceType = subresourceType.value
    @property
    def subresource(self):
        return self._subresource
    @subresource.setter
    def subresource(self, subresource not None : anon_union10):
        string.memcpy(&self._pvt_ptr[0].subresource, <cydriver.anon_union10*><void_ptr>subresource.getPtr(), sizeof(self._pvt_ptr[0].subresource))
    @property
    def memOperationType(self):
        if self._pvt_ptr[0].memOperationType not in _dict_CUmemOperationType:
            return None
        return _dict_CUmemOperationType[self._pvt_ptr[0].memOperationType]
    @memOperationType.setter
    def memOperationType(self, memOperationType not None : CUmemOperationType):
        self._pvt_ptr[0].memOperationType = memOperationType.value
    @property
    def memHandleType(self):
        if self._pvt_ptr[0].memHandleType not in _dict_CUmemHandleType:
            return None
        return _dict_CUmemHandleType[self._pvt_ptr[0].memHandleType]
    @memHandleType.setter
    def memHandleType(self, memHandleType not None : CUmemHandleType):
        self._pvt_ptr[0].memHandleType = memHandleType.value
    @property
    def memHandle(self):
        return self._memHandle
    @memHandle.setter
    def memHandle(self, memHandle not None : anon_union11):
        string.memcpy(&self._pvt_ptr[0].memHandle, <cydriver.anon_union11*><void_ptr>memHandle.getPtr(), sizeof(self._pvt_ptr[0].memHandle))
    @property
    def offset(self):
        return self._pvt_ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        self._pvt_ptr[0].offset = offset
    @property
    def deviceBitMask(self):
        return self._pvt_ptr[0].deviceBitMask
    @deviceBitMask.setter
    def deviceBitMask(self, unsigned int deviceBitMask):
        self._pvt_ptr[0].deviceBitMask = deviceBitMask
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class CUmemLocation_st:
    """
    Specifies a memory location.

    Attributes
    ----------
    type : CUmemLocationType
        Specifies the location type, which modifies the meaning of id.
    id : int
        identifier for a given this location's CUmemLocationType.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemLocation_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['id : ' + str(self.id)]
            except ValueError:
                str_list += ['id : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUmemLocationType:
            return None
        return _dict_CUmemLocationType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUmemLocationType):
        self._pvt_ptr[0].type = type.value
    @property
    def id(self):
        return self._pvt_ptr[0].id
    @id.setter
    def id(self, int id):
        self._pvt_ptr[0].id = id

cdef class anon_struct22:
    """
    Attributes
    ----------
    compressionType : bytes

    gpuDirectRDMACapable : bytes

    usage : unsigned short

    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUmemAllocationProp_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].allocFlags
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['compressionType : ' + str(self.compressionType)]
            except ValueError:
                str_list += ['compressionType : <ValueError>']
            try:
                str_list += ['gpuDirectRDMACapable : ' + str(self.gpuDirectRDMACapable)]
            except ValueError:
                str_list += ['gpuDirectRDMACapable : <ValueError>']
            try:
                str_list += ['usage : ' + str(self.usage)]
            except ValueError:
                str_list += ['usage : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def compressionType(self):
        return self._pvt_ptr[0].allocFlags.compressionType
    @compressionType.setter
    def compressionType(self, unsigned char compressionType):
        self._pvt_ptr[0].allocFlags.compressionType = compressionType
    @property
    def gpuDirectRDMACapable(self):
        return self._pvt_ptr[0].allocFlags.gpuDirectRDMACapable
    @gpuDirectRDMACapable.setter
    def gpuDirectRDMACapable(self, unsigned char gpuDirectRDMACapable):
        self._pvt_ptr[0].allocFlags.gpuDirectRDMACapable = gpuDirectRDMACapable
    @property
    def usage(self):
        return self._pvt_ptr[0].allocFlags.usage
    @usage.setter
    def usage(self, unsigned short usage):
        self._pvt_ptr[0].allocFlags.usage = usage
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].allocFlags.reserved, 4)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 4:
            raise ValueError("reserved length must be 4, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].allocFlags.reserved[i] = b

cdef class CUmemAllocationProp_st:
    """
    Specifies the allocation properties for a allocation.

    Attributes
    ----------
    type : CUmemAllocationType
        Allocation type
    requestedHandleTypes : CUmemAllocationHandleType
        requested CUmemAllocationHandleType
    location : CUmemLocation
        Location of allocation
    win32HandleMetaData : Any
        Windows-specific POBJECT_ATTRIBUTES required when
        CU_MEM_HANDLE_TYPE_WIN32 is specified. This object attributes
        structure includes security attributes that define the scope of
        which exported allocations may be transferred to other processes.
        In all other cases, this field is required to be zero.
    allocFlags : anon_struct22


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemAllocationProp_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._location = CUmemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].location)
        self._allocFlags = anon_struct22(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['requestedHandleTypes : ' + str(self.requestedHandleTypes)]
            except ValueError:
                str_list += ['requestedHandleTypes : <ValueError>']
            try:
                str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            except ValueError:
                str_list += ['location : <ValueError>']
            try:
                str_list += ['win32HandleMetaData : ' + hex(self.win32HandleMetaData)]
            except ValueError:
                str_list += ['win32HandleMetaData : <ValueError>']
            try:
                str_list += ['allocFlags :\n' + '\n'.join(['    ' + line for line in str(self.allocFlags).splitlines()])]
            except ValueError:
                str_list += ['allocFlags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUmemAllocationType:
            return None
        return _dict_CUmemAllocationType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUmemAllocationType):
        self._pvt_ptr[0].type = type.value
    @property
    def requestedHandleTypes(self):
        if self._pvt_ptr[0].requestedHandleTypes not in _dict_CUmemAllocationHandleType:
            return None
        return _dict_CUmemAllocationHandleType[self._pvt_ptr[0].requestedHandleTypes]
    @requestedHandleTypes.setter
    def requestedHandleTypes(self, requestedHandleTypes not None : CUmemAllocationHandleType):
        self._pvt_ptr[0].requestedHandleTypes = requestedHandleTypes.value
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : CUmemLocation):
        string.memcpy(&self._pvt_ptr[0].location, <cydriver.CUmemLocation*><void_ptr>location.getPtr(), sizeof(self._pvt_ptr[0].location))
    @property
    def win32HandleMetaData(self):
        return <void_ptr>self._pvt_ptr[0].win32HandleMetaData
    @win32HandleMetaData.setter
    def win32HandleMetaData(self, win32HandleMetaData):
        _cwin32HandleMetaData = _HelperInputVoidPtr(win32HandleMetaData)
        self._pvt_ptr[0].win32HandleMetaData = <void*><void_ptr>_cwin32HandleMetaData.cptr
    @property
    def allocFlags(self):
        return self._allocFlags
    @allocFlags.setter
    def allocFlags(self, allocFlags not None : anon_struct22):
        string.memcpy(&self._pvt_ptr[0].allocFlags, <cydriver.anon_struct22*><void_ptr>allocFlags.getPtr(), sizeof(self._pvt_ptr[0].allocFlags))

cdef class CUmulticastObjectProp_st:
    """
    Specifies the properties for a multicast object.

    Attributes
    ----------
    numDevices : unsigned int
        The number of devices in the multicast team that will bind memory
        to this object
    size : size_t
        The maximum amount of memory that can be bound to this multicast
        object per device
    handleTypes : unsigned long long
        Bitmask of exportable handle types (see CUmemAllocationHandleType)
        for this object
    flags : unsigned long long
        Flags for future use, must be zero now

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmulticastObjectProp_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['numDevices : ' + str(self.numDevices)]
            except ValueError:
                str_list += ['numDevices : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['handleTypes : ' + str(self.handleTypes)]
            except ValueError:
                str_list += ['handleTypes : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def numDevices(self):
        return self._pvt_ptr[0].numDevices
    @numDevices.setter
    def numDevices(self, unsigned int numDevices):
        self._pvt_ptr[0].numDevices = numDevices
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, size_t size):
        self._pvt_ptr[0].size = size
    @property
    def handleTypes(self):
        return self._pvt_ptr[0].handleTypes
    @handleTypes.setter
    def handleTypes(self, unsigned long long handleTypes):
        self._pvt_ptr[0].handleTypes = handleTypes
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned long long flags):
        self._pvt_ptr[0].flags = flags

cdef class CUmemAccessDesc_st:
    """
    Memory access descriptor

    Attributes
    ----------
    location : CUmemLocation
        Location on which the request is to change it's accessibility
    flags : CUmemAccess_flags
        ::CUmemProt accessibility flags to set on the request

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemAccessDesc_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._location = CUmemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].location)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            except ValueError:
                str_list += ['location : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : CUmemLocation):
        string.memcpy(&self._pvt_ptr[0].location, <cydriver.CUmemLocation*><void_ptr>location.getPtr(), sizeof(self._pvt_ptr[0].location))
    @property
    def flags(self):
        if self._pvt_ptr[0].flags not in _dict_CUmemAccess_flags:
            return None
        return _dict_CUmemAccess_flags[self._pvt_ptr[0].flags]
    @flags.setter
    def flags(self, flags not None : CUmemAccess_flags):
        self._pvt_ptr[0].flags = flags.value

cdef class CUgraphExecUpdateResultInfo_st:
    """
    Result information returned by cuGraphExecUpdate

    Attributes
    ----------
    result : CUgraphExecUpdateResult
        Gives more specific detail when a cuda graph update fails.
    errorNode : CUgraphNode
        The "to node" of the error edge when the topologies do not match.
        The error node when the error is associated with a specific node.
        NULL when the error is generic.
    errorFromNode : CUgraphNode
        The from node of error edge when the topologies do not match.
        Otherwise NULL.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUgraphExecUpdateResultInfo_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._errorNode = CUgraphNode(_ptr=<void_ptr>&self._pvt_ptr[0].errorNode)
        self._errorFromNode = CUgraphNode(_ptr=<void_ptr>&self._pvt_ptr[0].errorFromNode)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['result : ' + str(self.result)]
            except ValueError:
                str_list += ['result : <ValueError>']
            try:
                str_list += ['errorNode : ' + str(self.errorNode)]
            except ValueError:
                str_list += ['errorNode : <ValueError>']
            try:
                str_list += ['errorFromNode : ' + str(self.errorFromNode)]
            except ValueError:
                str_list += ['errorFromNode : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def result(self):
        if self._pvt_ptr[0].result not in _dict_CUgraphExecUpdateResult:
            return None
        return _dict_CUgraphExecUpdateResult[self._pvt_ptr[0].result]
    @result.setter
    def result(self, result not None : CUgraphExecUpdateResult):
        self._pvt_ptr[0].result = result.value
    @property
    def errorNode(self):
        return self._errorNode
    @errorNode.setter
    def errorNode(self, errorNode):
        cdef cydriver.CUgraphNode cyerrorNode
        if errorNode is None:
            cyerrorNode = <cydriver.CUgraphNode><void_ptr>0
        elif isinstance(errorNode, (CUgraphNode,)):
            perrorNode = int(errorNode)
            cyerrorNode = <cydriver.CUgraphNode><void_ptr>perrorNode
        else:
            perrorNode = int(CUgraphNode(errorNode))
            cyerrorNode = <cydriver.CUgraphNode><void_ptr>perrorNode
        self._errorNode._pvt_ptr[0] = cyerrorNode
    @property
    def errorFromNode(self):
        return self._errorFromNode
    @errorFromNode.setter
    def errorFromNode(self, errorFromNode):
        cdef cydriver.CUgraphNode cyerrorFromNode
        if errorFromNode is None:
            cyerrorFromNode = <cydriver.CUgraphNode><void_ptr>0
        elif isinstance(errorFromNode, (CUgraphNode,)):
            perrorFromNode = int(errorFromNode)
            cyerrorFromNode = <cydriver.CUgraphNode><void_ptr>perrorFromNode
        else:
            perrorFromNode = int(CUgraphNode(errorFromNode))
            cyerrorFromNode = <cydriver.CUgraphNode><void_ptr>perrorFromNode
        self._errorFromNode._pvt_ptr[0] = cyerrorFromNode

cdef class CUmemPoolProps_st:
    """
    Specifies the properties of allocations made from the pool.

    Attributes
    ----------
    allocType : CUmemAllocationType
        Allocation type. Currently must be specified as
        CU_MEM_ALLOCATION_TYPE_PINNED
    handleTypes : CUmemAllocationHandleType
        Handle types that will be supported by allocations from the pool.
    location : CUmemLocation
        Location where allocations should reside.
    win32SecurityAttributes : Any
        Windows-specific LPSECURITYATTRIBUTES required when
        CU_MEM_HANDLE_TYPE_WIN32 is specified. This security attribute
        defines the scope of which exported allocations may be transferred
        to other processes. In all other cases, this field is required to
        be zero.
    maxSize : size_t
        Maximum pool size. When set to 0, defaults to a system dependent
        value.
    usage : unsigned short
        Bitmask indicating intended usage for the pool.
    reserved : bytes
        reserved for future use, must be 0

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemPoolProps_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._location = CUmemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].location)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['allocType : ' + str(self.allocType)]
            except ValueError:
                str_list += ['allocType : <ValueError>']
            try:
                str_list += ['handleTypes : ' + str(self.handleTypes)]
            except ValueError:
                str_list += ['handleTypes : <ValueError>']
            try:
                str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            except ValueError:
                str_list += ['location : <ValueError>']
            try:
                str_list += ['win32SecurityAttributes : ' + hex(self.win32SecurityAttributes)]
            except ValueError:
                str_list += ['win32SecurityAttributes : <ValueError>']
            try:
                str_list += ['maxSize : ' + str(self.maxSize)]
            except ValueError:
                str_list += ['maxSize : <ValueError>']
            try:
                str_list += ['usage : ' + str(self.usage)]
            except ValueError:
                str_list += ['usage : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def allocType(self):
        if self._pvt_ptr[0].allocType not in _dict_CUmemAllocationType:
            return None
        return _dict_CUmemAllocationType[self._pvt_ptr[0].allocType]
    @allocType.setter
    def allocType(self, allocType not None : CUmemAllocationType):
        self._pvt_ptr[0].allocType = allocType.value
    @property
    def handleTypes(self):
        if self._pvt_ptr[0].handleTypes not in _dict_CUmemAllocationHandleType:
            return None
        return _dict_CUmemAllocationHandleType[self._pvt_ptr[0].handleTypes]
    @handleTypes.setter
    def handleTypes(self, handleTypes not None : CUmemAllocationHandleType):
        self._pvt_ptr[0].handleTypes = handleTypes.value
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : CUmemLocation):
        string.memcpy(&self._pvt_ptr[0].location, <cydriver.CUmemLocation*><void_ptr>location.getPtr(), sizeof(self._pvt_ptr[0].location))
    @property
    def win32SecurityAttributes(self):
        return <void_ptr>self._pvt_ptr[0].win32SecurityAttributes
    @win32SecurityAttributes.setter
    def win32SecurityAttributes(self, win32SecurityAttributes):
        _cwin32SecurityAttributes = _HelperInputVoidPtr(win32SecurityAttributes)
        self._pvt_ptr[0].win32SecurityAttributes = <void*><void_ptr>_cwin32SecurityAttributes.cptr
    @property
    def maxSize(self):
        return self._pvt_ptr[0].maxSize
    @maxSize.setter
    def maxSize(self, size_t maxSize):
        self._pvt_ptr[0].maxSize = maxSize
    @property
    def usage(self):
        return self._pvt_ptr[0].usage
    @usage.setter
    def usage(self, unsigned short usage):
        self._pvt_ptr[0].usage = usage
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 54)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 54:
            raise ValueError("reserved length must be 54, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class CUmemPoolPtrExportData_st:
    """
    Opaque data for exporting a pool allocation

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemPoolPtrExportData_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class CUmemcpyAttributes_st:
    """
    Attributes specific to copies within a batch. For more details on
    usage see cuMemcpyBatchAsync.

    Attributes
    ----------
    srcAccessOrder : CUmemcpySrcAccessOrder
        Source access ordering to be observed for copies with this
        attribute.
    srcLocHint : CUmemLocation
        Hint location for the source operand. Ignored when the pointers are
        not managed memory or memory allocated outside CUDA.
    dstLocHint : CUmemLocation
        Hint location for the destination operand. Ignored when the
        pointers are not managed memory or memory allocated outside CUDA.
    flags : unsigned int
        Additional flags for copies with this attribute. See CUmemcpyFlags

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemcpyAttributes_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcLocHint = CUmemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].srcLocHint)
        self._dstLocHint = CUmemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].dstLocHint)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcAccessOrder : ' + str(self.srcAccessOrder)]
            except ValueError:
                str_list += ['srcAccessOrder : <ValueError>']
            try:
                str_list += ['srcLocHint :\n' + '\n'.join(['    ' + line for line in str(self.srcLocHint).splitlines()])]
            except ValueError:
                str_list += ['srcLocHint : <ValueError>']
            try:
                str_list += ['dstLocHint :\n' + '\n'.join(['    ' + line for line in str(self.dstLocHint).splitlines()])]
            except ValueError:
                str_list += ['dstLocHint : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcAccessOrder(self):
        if self._pvt_ptr[0].srcAccessOrder not in _dict_CUmemcpySrcAccessOrder:
            return None
        return _dict_CUmemcpySrcAccessOrder[self._pvt_ptr[0].srcAccessOrder]
    @srcAccessOrder.setter
    def srcAccessOrder(self, srcAccessOrder not None : CUmemcpySrcAccessOrder):
        self._pvt_ptr[0].srcAccessOrder = srcAccessOrder.value
    @property
    def srcLocHint(self):
        return self._srcLocHint
    @srcLocHint.setter
    def srcLocHint(self, srcLocHint not None : CUmemLocation):
        string.memcpy(&self._pvt_ptr[0].srcLocHint, <cydriver.CUmemLocation*><void_ptr>srcLocHint.getPtr(), sizeof(self._pvt_ptr[0].srcLocHint))
    @property
    def dstLocHint(self):
        return self._dstLocHint
    @dstLocHint.setter
    def dstLocHint(self, dstLocHint not None : CUmemLocation):
        string.memcpy(&self._pvt_ptr[0].dstLocHint, <cydriver.CUmemLocation*><void_ptr>dstLocHint.getPtr(), sizeof(self._pvt_ptr[0].dstLocHint))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class CUoffset3D_st:
    """
    Struct representing offset into a CUarray in elements

    Attributes
    ----------
    x : size_t

    y : size_t

    z : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUoffset3D_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].x
    @x.setter
    def x(self, size_t x):
        self._pvt_ptr[0].x = x
    @property
    def y(self):
        return self._pvt_ptr[0].y
    @y.setter
    def y(self, size_t y):
        self._pvt_ptr[0].y = y
    @property
    def z(self):
        return self._pvt_ptr[0].z
    @z.setter
    def z(self, size_t z):
        self._pvt_ptr[0].z = z

cdef class CUextent3D_st:
    """
    Struct representing width/height/depth of a CUarray in elements

    Attributes
    ----------
    width : size_t

    height : size_t

    depth : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUextent3D_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].depth
    @depth.setter
    def depth(self, size_t depth):
        self._pvt_ptr[0].depth = depth

cdef class anon_struct23:
    """
    Attributes
    ----------
    ptr : CUdeviceptr

    rowLength : size_t

    layerHeight : size_t

    locHint : CUmemLocation


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUmemcpy3DOperand_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._ptr = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].op.ptr.ptr)
        self._locHint = CUmemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].op.ptr.locHint)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].op.ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ptr : ' + str(self.ptr)]
            except ValueError:
                str_list += ['ptr : <ValueError>']
            try:
                str_list += ['rowLength : ' + str(self.rowLength)]
            except ValueError:
                str_list += ['rowLength : <ValueError>']
            try:
                str_list += ['layerHeight : ' + str(self.layerHeight)]
            except ValueError:
                str_list += ['layerHeight : <ValueError>']
            try:
                str_list += ['locHint :\n' + '\n'.join(['    ' + line for line in str(self.locHint).splitlines()])]
            except ValueError:
                str_list += ['locHint : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ptr(self):
        return self._ptr
    @ptr.setter
    def ptr(self, ptr):
        cdef cydriver.CUdeviceptr cyptr
        if ptr is None:
            cyptr = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(ptr, (CUdeviceptr)):
            pptr = int(ptr)
            cyptr = <cydriver.CUdeviceptr><void_ptr>pptr
        else:
            pptr = int(CUdeviceptr(ptr))
            cyptr = <cydriver.CUdeviceptr><void_ptr>pptr
        self._ptr._pvt_ptr[0] = cyptr

    @property
    def rowLength(self):
        return self._pvt_ptr[0].op.ptr.rowLength
    @rowLength.setter
    def rowLength(self, size_t rowLength):
        self._pvt_ptr[0].op.ptr.rowLength = rowLength
    @property
    def layerHeight(self):
        return self._pvt_ptr[0].op.ptr.layerHeight
    @layerHeight.setter
    def layerHeight(self, size_t layerHeight):
        self._pvt_ptr[0].op.ptr.layerHeight = layerHeight
    @property
    def locHint(self):
        return self._locHint
    @locHint.setter
    def locHint(self, locHint not None : CUmemLocation):
        string.memcpy(&self._pvt_ptr[0].op.ptr.locHint, <cydriver.CUmemLocation*><void_ptr>locHint.getPtr(), sizeof(self._pvt_ptr[0].op.ptr.locHint))

cdef class anon_struct24:
    """
    Attributes
    ----------
    array : CUarray

    offset : CUoffset3D


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUmemcpy3DOperand_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._array = CUarray(_ptr=<void_ptr>&self._pvt_ptr[0].op.array.array)
        self._offset = CUoffset3D(_ptr=<void_ptr>&self._pvt_ptr[0].op.array.offset)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].op.array
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['array : ' + str(self.array)]
            except ValueError:
                str_list += ['array : <ValueError>']
            try:
                str_list += ['offset :\n' + '\n'.join(['    ' + line for line in str(self.offset).splitlines()])]
            except ValueError:
                str_list += ['offset : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array):
        cdef cydriver.CUarray cyarray
        if array is None:
            cyarray = <cydriver.CUarray><void_ptr>0
        elif isinstance(array, (CUarray,)):
            parray = int(array)
            cyarray = <cydriver.CUarray><void_ptr>parray
        else:
            parray = int(CUarray(array))
            cyarray = <cydriver.CUarray><void_ptr>parray
        self._array._pvt_ptr[0] = cyarray
    @property
    def offset(self):
        return self._offset
    @offset.setter
    def offset(self, offset not None : CUoffset3D):
        string.memcpy(&self._pvt_ptr[0].op.array.offset, <cydriver.CUoffset3D*><void_ptr>offset.getPtr(), sizeof(self._pvt_ptr[0].op.array.offset))

cdef class anon_union12:
    """
    Attributes
    ----------
    ptr : anon_struct23

    array : anon_struct24


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUmemcpy3DOperand_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._ptr = anon_struct23(_ptr=<void_ptr>self._pvt_ptr)
        self._array = anon_struct24(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].op
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ptr :\n' + '\n'.join(['    ' + line for line in str(self.ptr).splitlines()])]
            except ValueError:
                str_list += ['ptr : <ValueError>']
            try:
                str_list += ['array :\n' + '\n'.join(['    ' + line for line in str(self.array).splitlines()])]
            except ValueError:
                str_list += ['array : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ptr(self):
        return self._ptr
    @ptr.setter
    def ptr(self, ptr not None : anon_struct23):
        string.memcpy(&self._pvt_ptr[0].op.ptr, <cydriver.anon_struct23*><void_ptr>ptr.getPtr(), sizeof(self._pvt_ptr[0].op.ptr))
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array not None : anon_struct24):
        string.memcpy(&self._pvt_ptr[0].op.array, <cydriver.anon_struct24*><void_ptr>array.getPtr(), sizeof(self._pvt_ptr[0].op.array))

cdef class CUmemcpy3DOperand_st:
    """
    Struct representing an operand for copy with cuMemcpy3DBatchAsync

    Attributes
    ----------
    type : CUmemcpy3DOperandType

    op : anon_union12


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUmemcpy3DOperand_st *>calloc(1, sizeof(cydriver.CUmemcpy3DOperand_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUmemcpy3DOperand_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._op = anon_union12(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['op :\n' + '\n'.join(['    ' + line for line in str(self.op).splitlines()])]
            except ValueError:
                str_list += ['op : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUmemcpy3DOperandType:
            return None
        return _dict_CUmemcpy3DOperandType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUmemcpy3DOperandType):
        self._pvt_ptr[0].type = type.value
    @property
    def op(self):
        return self._op
    @op.setter
    def op(self, op not None : anon_union12):
        string.memcpy(&self._pvt_ptr[0].op, <cydriver.anon_union12*><void_ptr>op.getPtr(), sizeof(self._pvt_ptr[0].op))

cdef class CUDA_MEMCPY3D_BATCH_OP_st:
    """
    Attributes
    ----------
    src : CUmemcpy3DOperand
        Source memcpy operand.
    dst : CUmemcpy3DOperand
        Destination memcpy operand.
    extent : CUextent3D
        Extents of the memcpy between src and dst. The width, height and
        depth components must not be 0.
    srcAccessOrder : CUmemcpySrcAccessOrder
        Source access ordering to be observed for copy from src to dst.
    flags : unsigned int
        Additional flags for copies with this attribute. See CUmemcpyFlags

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEMCPY3D_BATCH_OP_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._src = CUmemcpy3DOperand(_ptr=<void_ptr>&self._pvt_ptr[0].src)
        self._dst = CUmemcpy3DOperand(_ptr=<void_ptr>&self._pvt_ptr[0].dst)
        self._extent = CUextent3D(_ptr=<void_ptr>&self._pvt_ptr[0].extent)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['src :\n' + '\n'.join(['    ' + line for line in str(self.src).splitlines()])]
            except ValueError:
                str_list += ['src : <ValueError>']
            try:
                str_list += ['dst :\n' + '\n'.join(['    ' + line for line in str(self.dst).splitlines()])]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['extent :\n' + '\n'.join(['    ' + line for line in str(self.extent).splitlines()])]
            except ValueError:
                str_list += ['extent : <ValueError>']
            try:
                str_list += ['srcAccessOrder : ' + str(self.srcAccessOrder)]
            except ValueError:
                str_list += ['srcAccessOrder : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def src(self):
        return self._src
    @src.setter
    def src(self, src not None : CUmemcpy3DOperand):
        string.memcpy(&self._pvt_ptr[0].src, <cydriver.CUmemcpy3DOperand*><void_ptr>src.getPtr(), sizeof(self._pvt_ptr[0].src))
    @property
    def dst(self):
        return self._dst
    @dst.setter
    def dst(self, dst not None : CUmemcpy3DOperand):
        string.memcpy(&self._pvt_ptr[0].dst, <cydriver.CUmemcpy3DOperand*><void_ptr>dst.getPtr(), sizeof(self._pvt_ptr[0].dst))
    @property
    def extent(self):
        return self._extent
    @extent.setter
    def extent(self, extent not None : CUextent3D):
        string.memcpy(&self._pvt_ptr[0].extent, <cydriver.CUextent3D*><void_ptr>extent.getPtr(), sizeof(self._pvt_ptr[0].extent))
    @property
    def srcAccessOrder(self):
        if self._pvt_ptr[0].srcAccessOrder not in _dict_CUmemcpySrcAccessOrder:
            return None
        return _dict_CUmemcpySrcAccessOrder[self._pvt_ptr[0].srcAccessOrder]
    @srcAccessOrder.setter
    def srcAccessOrder(self, srcAccessOrder not None : CUmemcpySrcAccessOrder):
        self._pvt_ptr[0].srcAccessOrder = srcAccessOrder.value
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class CUDA_MEM_ALLOC_NODE_PARAMS_v1_st:
    """
    Memory allocation node parameters

    Attributes
    ----------
    poolProps : CUmemPoolProps
        in: location where the allocation should reside (specified in
        ::location). ::handleTypes must be CU_MEM_HANDLE_TYPE_NONE. IPC is
        not supported.
    accessDescs : CUmemAccessDesc
        in: array of memory access descriptors. Used to describe peer GPU
        access
    accessDescCount : size_t
        in: number of memory access descriptors. Must not exceed the number
        of GPUs.
    bytesize : size_t
        in: size in bytes of the requested allocation
    dptr : CUdeviceptr
        out: address of the allocation returned by CUDA

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEM_ALLOC_NODE_PARAMS_v1_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._poolProps = CUmemPoolProps(_ptr=<void_ptr>&self._pvt_ptr[0].poolProps)
        self._dptr = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dptr)
    def __dealloc__(self):
        pass
        if self._accessDescs is not NULL:
            free(self._accessDescs)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['poolProps :\n' + '\n'.join(['    ' + line for line in str(self.poolProps).splitlines()])]
            except ValueError:
                str_list += ['poolProps : <ValueError>']
            try:
                str_list += ['accessDescs : ' + str(self.accessDescs)]
            except ValueError:
                str_list += ['accessDescs : <ValueError>']
            try:
                str_list += ['accessDescCount : ' + str(self.accessDescCount)]
            except ValueError:
                str_list += ['accessDescCount : <ValueError>']
            try:
                str_list += ['bytesize : ' + str(self.bytesize)]
            except ValueError:
                str_list += ['bytesize : <ValueError>']
            try:
                str_list += ['dptr : ' + str(self.dptr)]
            except ValueError:
                str_list += ['dptr : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def poolProps(self):
        return self._poolProps
    @poolProps.setter
    def poolProps(self, poolProps not None : CUmemPoolProps):
        string.memcpy(&self._pvt_ptr[0].poolProps, <cydriver.CUmemPoolProps*><void_ptr>poolProps.getPtr(), sizeof(self._pvt_ptr[0].poolProps))
    @property
    def accessDescs(self):
        arrs = [<void_ptr>self._pvt_ptr[0].accessDescs + x*sizeof(cydriver.CUmemAccessDesc) for x in range(self._accessDescs_length)]
        return [CUmemAccessDesc(_ptr=arr) for arr in arrs]
    @accessDescs.setter
    def accessDescs(self, val):
        if len(val) == 0:
            free(self._accessDescs)
            self._accessDescs_length = 0
            self._pvt_ptr[0].accessDescs = NULL
        else:
            if self._accessDescs_length != <size_t>len(val):
                free(self._accessDescs)
                self._accessDescs = <cydriver.CUmemAccessDesc*> calloc(len(val), sizeof(cydriver.CUmemAccessDesc))
                if self._accessDescs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUmemAccessDesc)))
                self._accessDescs_length = <size_t>len(val)
                self._pvt_ptr[0].accessDescs = self._accessDescs
            for idx in range(len(val)):
                string.memcpy(&self._accessDescs[idx], (<CUmemAccessDesc>val[idx])._pvt_ptr, sizeof(cydriver.CUmemAccessDesc))

    @property
    def accessDescCount(self):
        return self._pvt_ptr[0].accessDescCount
    @accessDescCount.setter
    def accessDescCount(self, size_t accessDescCount):
        self._pvt_ptr[0].accessDescCount = accessDescCount
    @property
    def bytesize(self):
        return self._pvt_ptr[0].bytesize
    @bytesize.setter
    def bytesize(self, size_t bytesize):
        self._pvt_ptr[0].bytesize = bytesize
    @property
    def dptr(self):
        return self._dptr
    @dptr.setter
    def dptr(self, dptr):
        cdef cydriver.CUdeviceptr cydptr
        if dptr is None:
            cydptr = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dptr, (CUdeviceptr)):
            pdptr = int(dptr)
            cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
        else:
            pdptr = int(CUdeviceptr(dptr))
            cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
        self._dptr._pvt_ptr[0] = cydptr


cdef class CUDA_MEM_ALLOC_NODE_PARAMS_v2_st:
    """
    Memory allocation node parameters

    Attributes
    ----------
    poolProps : CUmemPoolProps
        in: location where the allocation should reside (specified in
        ::location). ::handleTypes must be CU_MEM_HANDLE_TYPE_NONE. IPC is
        not supported.
    accessDescs : CUmemAccessDesc
        in: array of memory access descriptors. Used to describe peer GPU
        access
    accessDescCount : size_t
        in: number of memory access descriptors. Must not exceed the number
        of GPUs.
    bytesize : size_t
        in: size in bytes of the requested allocation
    dptr : CUdeviceptr
        out: address of the allocation returned by CUDA

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEM_ALLOC_NODE_PARAMS_v2_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._poolProps = CUmemPoolProps(_ptr=<void_ptr>&self._pvt_ptr[0].poolProps)
        self._dptr = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dptr)
    def __dealloc__(self):
        pass
        if self._accessDescs is not NULL:
            free(self._accessDescs)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['poolProps :\n' + '\n'.join(['    ' + line for line in str(self.poolProps).splitlines()])]
            except ValueError:
                str_list += ['poolProps : <ValueError>']
            try:
                str_list += ['accessDescs : ' + str(self.accessDescs)]
            except ValueError:
                str_list += ['accessDescs : <ValueError>']
            try:
                str_list += ['accessDescCount : ' + str(self.accessDescCount)]
            except ValueError:
                str_list += ['accessDescCount : <ValueError>']
            try:
                str_list += ['bytesize : ' + str(self.bytesize)]
            except ValueError:
                str_list += ['bytesize : <ValueError>']
            try:
                str_list += ['dptr : ' + str(self.dptr)]
            except ValueError:
                str_list += ['dptr : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def poolProps(self):
        return self._poolProps
    @poolProps.setter
    def poolProps(self, poolProps not None : CUmemPoolProps):
        string.memcpy(&self._pvt_ptr[0].poolProps, <cydriver.CUmemPoolProps*><void_ptr>poolProps.getPtr(), sizeof(self._pvt_ptr[0].poolProps))
    @property
    def accessDescs(self):
        arrs = [<void_ptr>self._pvt_ptr[0].accessDescs + x*sizeof(cydriver.CUmemAccessDesc) for x in range(self._accessDescs_length)]
        return [CUmemAccessDesc(_ptr=arr) for arr in arrs]
    @accessDescs.setter
    def accessDescs(self, val):
        if len(val) == 0:
            free(self._accessDescs)
            self._accessDescs_length = 0
            self._pvt_ptr[0].accessDescs = NULL
        else:
            if self._accessDescs_length != <size_t>len(val):
                free(self._accessDescs)
                self._accessDescs = <cydriver.CUmemAccessDesc*> calloc(len(val), sizeof(cydriver.CUmemAccessDesc))
                if self._accessDescs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUmemAccessDesc)))
                self._accessDescs_length = <size_t>len(val)
                self._pvt_ptr[0].accessDescs = self._accessDescs
            for idx in range(len(val)):
                string.memcpy(&self._accessDescs[idx], (<CUmemAccessDesc>val[idx])._pvt_ptr, sizeof(cydriver.CUmemAccessDesc))

    @property
    def accessDescCount(self):
        return self._pvt_ptr[0].accessDescCount
    @accessDescCount.setter
    def accessDescCount(self, size_t accessDescCount):
        self._pvt_ptr[0].accessDescCount = accessDescCount
    @property
    def bytesize(self):
        return self._pvt_ptr[0].bytesize
    @bytesize.setter
    def bytesize(self, size_t bytesize):
        self._pvt_ptr[0].bytesize = bytesize
    @property
    def dptr(self):
        return self._dptr
    @dptr.setter
    def dptr(self, dptr):
        cdef cydriver.CUdeviceptr cydptr
        if dptr is None:
            cydptr = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dptr, (CUdeviceptr)):
            pdptr = int(dptr)
            cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
        else:
            pdptr = int(CUdeviceptr(dptr))
            cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
        self._dptr._pvt_ptr[0] = cydptr


cdef class CUDA_MEM_FREE_NODE_PARAMS_st:
    """
    Memory free node parameters

    Attributes
    ----------
    dptr : CUdeviceptr
        in: the pointer to free

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_MEM_FREE_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._dptr = CUdeviceptr(_ptr=<void_ptr>&self._pvt_ptr[0].dptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['dptr : ' + str(self.dptr)]
            except ValueError:
                str_list += ['dptr : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def dptr(self):
        return self._dptr
    @dptr.setter
    def dptr(self, dptr):
        cdef cydriver.CUdeviceptr cydptr
        if dptr is None:
            cydptr = <cydriver.CUdeviceptr><void_ptr>0
        elif isinstance(dptr, (CUdeviceptr)):
            pdptr = int(dptr)
            cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
        else:
            pdptr = int(CUdeviceptr(dptr))
            cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
        self._dptr._pvt_ptr[0] = cydptr


cdef class CUDA_CHILD_GRAPH_NODE_PARAMS_st:
    """
    Child graph node parameters

    Attributes
    ----------
    graph : CUgraph
        The child graph to clone into the node for node creation, or a
        handle to the graph owned by the node for node query. The graph
        must not contain conditional nodes. Graphs containing memory
        allocation or memory free nodes must set the ownership to be moved
        to the parent.
    ownership : CUgraphChildGraphNodeOwnership
        The ownership relationship of the child graph node.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_CHILD_GRAPH_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._graph = CUgraph(_ptr=<void_ptr>&self._pvt_ptr[0].graph)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['graph : ' + str(self.graph)]
            except ValueError:
                str_list += ['graph : <ValueError>']
            try:
                str_list += ['ownership : ' + str(self.ownership)]
            except ValueError:
                str_list += ['ownership : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def graph(self):
        return self._graph
    @graph.setter
    def graph(self, graph):
        cdef cydriver.CUgraph cygraph
        if graph is None:
            cygraph = <cydriver.CUgraph><void_ptr>0
        elif isinstance(graph, (CUgraph,)):
            pgraph = int(graph)
            cygraph = <cydriver.CUgraph><void_ptr>pgraph
        else:
            pgraph = int(CUgraph(graph))
            cygraph = <cydriver.CUgraph><void_ptr>pgraph
        self._graph._pvt_ptr[0] = cygraph
    @property
    def ownership(self):
        if self._pvt_ptr[0].ownership not in _dict_CUgraphChildGraphNodeOwnership:
            return None
        return _dict_CUgraphChildGraphNodeOwnership[self._pvt_ptr[0].ownership]
    @ownership.setter
    def ownership(self, ownership not None : CUgraphChildGraphNodeOwnership):
        self._pvt_ptr[0].ownership = ownership.value

cdef class CUDA_EVENT_RECORD_NODE_PARAMS_st:
    """
    Event record node parameters

    Attributes
    ----------
    event : CUevent
        The event to record when the node executes

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EVENT_RECORD_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._event = CUevent(_ptr=<void_ptr>&self._pvt_ptr[0].event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cydriver.CUevent cyevent
        if event is None:
            cyevent = <cydriver.CUevent><void_ptr>0
        elif isinstance(event, (CUevent,)):
            pevent = int(event)
            cyevent = <cydriver.CUevent><void_ptr>pevent
        else:
            pevent = int(CUevent(event))
            cyevent = <cydriver.CUevent><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent

cdef class CUDA_EVENT_WAIT_NODE_PARAMS_st:
    """
    Event wait node parameters

    Attributes
    ----------
    event : CUevent
        The event to wait on from the node

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUDA_EVENT_WAIT_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._event = CUevent(_ptr=<void_ptr>&self._pvt_ptr[0].event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cydriver.CUevent cyevent
        if event is None:
            cyevent = <cydriver.CUevent><void_ptr>0
        elif isinstance(event, (CUevent,)):
            pevent = int(event)
            cyevent = <cydriver.CUevent><void_ptr>pevent
        else:
            pevent = int(CUevent(event))
            cyevent = <cydriver.CUevent><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent

cdef class CUgraphNodeParams_st:
    """
    Graph node parameters. See cuGraphAddNode.

    Attributes
    ----------
    type : CUgraphNodeType
        Type of the node
    reserved0 : list[int]
        Reserved. Must be zero.
    reserved1 : list[long long]
        Padding. Unused bytes must be zero.
    kernel : CUDA_KERNEL_NODE_PARAMS_v3
        Kernel node parameters.
    memcpy : CUDA_MEMCPY_NODE_PARAMS
        Memcpy node parameters.
    memset : CUDA_MEMSET_NODE_PARAMS_v2
        Memset node parameters.
    host : CUDA_HOST_NODE_PARAMS_v2
        Host node parameters.
    graph : CUDA_CHILD_GRAPH_NODE_PARAMS
        Child graph node parameters.
    eventWait : CUDA_EVENT_WAIT_NODE_PARAMS
        Event wait node parameters.
    eventRecord : CUDA_EVENT_RECORD_NODE_PARAMS
        Event record node parameters.
    extSemSignal : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2
        External semaphore signal node parameters.
    extSemWait : CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2
        External semaphore wait node parameters.
    alloc : CUDA_MEM_ALLOC_NODE_PARAMS_v2
        Memory allocation node parameters.
    free : CUDA_MEM_FREE_NODE_PARAMS
        Memory free node parameters.
    memOp : CUDA_BATCH_MEM_OP_NODE_PARAMS_v2
        MemOp node parameters.
    conditional : CUDA_CONDITIONAL_NODE_PARAMS
        Conditional node parameters.
    reserved2 : long long
        Reserved bytes. Must be zero.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUgraphNodeParams_st *>calloc(1, sizeof(cydriver.CUgraphNodeParams_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUgraphNodeParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._kernel = CUDA_KERNEL_NODE_PARAMS_v3(_ptr=<void_ptr>&self._pvt_ptr[0].kernel)
        self._memcpy = CUDA_MEMCPY_NODE_PARAMS(_ptr=<void_ptr>&self._pvt_ptr[0].memcpy)
        self._memset = CUDA_MEMSET_NODE_PARAMS_v2(_ptr=<void_ptr>&self._pvt_ptr[0].memset)
        self._host = CUDA_HOST_NODE_PARAMS_v2(_ptr=<void_ptr>&self._pvt_ptr[0].host)
        self._graph = CUDA_CHILD_GRAPH_NODE_PARAMS(_ptr=<void_ptr>&self._pvt_ptr[0].graph)
        self._eventWait = CUDA_EVENT_WAIT_NODE_PARAMS(_ptr=<void_ptr>&self._pvt_ptr[0].eventWait)
        self._eventRecord = CUDA_EVENT_RECORD_NODE_PARAMS(_ptr=<void_ptr>&self._pvt_ptr[0].eventRecord)
        self._extSemSignal = CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2(_ptr=<void_ptr>&self._pvt_ptr[0].extSemSignal)
        self._extSemWait = CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2(_ptr=<void_ptr>&self._pvt_ptr[0].extSemWait)
        self._alloc = CUDA_MEM_ALLOC_NODE_PARAMS_v2(_ptr=<void_ptr>&self._pvt_ptr[0].alloc)
        self._free = CUDA_MEM_FREE_NODE_PARAMS(_ptr=<void_ptr>&self._pvt_ptr[0].free)
        self._memOp = CUDA_BATCH_MEM_OP_NODE_PARAMS_v2(_ptr=<void_ptr>&self._pvt_ptr[0].memOp)
        self._conditional = CUDA_CONDITIONAL_NODE_PARAMS(_ptr=<void_ptr>&self._pvt_ptr[0].conditional)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['reserved0 : ' + str(self.reserved0)]
            except ValueError:
                str_list += ['reserved0 : <ValueError>']
            try:
                str_list += ['reserved1 : ' + str(self.reserved1)]
            except ValueError:
                str_list += ['reserved1 : <ValueError>']
            try:
                str_list += ['kernel :\n' + '\n'.join(['    ' + line for line in str(self.kernel).splitlines()])]
            except ValueError:
                str_list += ['kernel : <ValueError>']
            try:
                str_list += ['memcpy :\n' + '\n'.join(['    ' + line for line in str(self.memcpy).splitlines()])]
            except ValueError:
                str_list += ['memcpy : <ValueError>']
            try:
                str_list += ['memset :\n' + '\n'.join(['    ' + line for line in str(self.memset).splitlines()])]
            except ValueError:
                str_list += ['memset : <ValueError>']
            try:
                str_list += ['host :\n' + '\n'.join(['    ' + line for line in str(self.host).splitlines()])]
            except ValueError:
                str_list += ['host : <ValueError>']
            try:
                str_list += ['graph :\n' + '\n'.join(['    ' + line for line in str(self.graph).splitlines()])]
            except ValueError:
                str_list += ['graph : <ValueError>']
            try:
                str_list += ['eventWait :\n' + '\n'.join(['    ' + line for line in str(self.eventWait).splitlines()])]
            except ValueError:
                str_list += ['eventWait : <ValueError>']
            try:
                str_list += ['eventRecord :\n' + '\n'.join(['    ' + line for line in str(self.eventRecord).splitlines()])]
            except ValueError:
                str_list += ['eventRecord : <ValueError>']
            try:
                str_list += ['extSemSignal :\n' + '\n'.join(['    ' + line for line in str(self.extSemSignal).splitlines()])]
            except ValueError:
                str_list += ['extSemSignal : <ValueError>']
            try:
                str_list += ['extSemWait :\n' + '\n'.join(['    ' + line for line in str(self.extSemWait).splitlines()])]
            except ValueError:
                str_list += ['extSemWait : <ValueError>']
            try:
                str_list += ['alloc :\n' + '\n'.join(['    ' + line for line in str(self.alloc).splitlines()])]
            except ValueError:
                str_list += ['alloc : <ValueError>']
            try:
                str_list += ['free :\n' + '\n'.join(['    ' + line for line in str(self.free).splitlines()])]
            except ValueError:
                str_list += ['free : <ValueError>']
            try:
                str_list += ['memOp :\n' + '\n'.join(['    ' + line for line in str(self.memOp).splitlines()])]
            except ValueError:
                str_list += ['memOp : <ValueError>']
            try:
                str_list += ['conditional :\n' + '\n'.join(['    ' + line for line in str(self.conditional).splitlines()])]
            except ValueError:
                str_list += ['conditional : <ValueError>']
            try:
                str_list += ['reserved2 : ' + str(self.reserved2)]
            except ValueError:
                str_list += ['reserved2 : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUgraphNodeType:
            return None
        return _dict_CUgraphNodeType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUgraphNodeType):
        self._pvt_ptr[0].type = type.value
    @property
    def reserved0(self):
        return self._pvt_ptr[0].reserved0
    @reserved0.setter
    def reserved0(self, reserved0):
        self._pvt_ptr[0].reserved0 = reserved0
    @property
    def reserved1(self):
        return self._pvt_ptr[0].reserved1
    @reserved1.setter
    def reserved1(self, reserved1):
        self._pvt_ptr[0].reserved1 = reserved1
    @property
    def kernel(self):
        return self._kernel
    @kernel.setter
    def kernel(self, kernel not None : CUDA_KERNEL_NODE_PARAMS_v3):
        string.memcpy(&self._pvt_ptr[0].kernel, <cydriver.CUDA_KERNEL_NODE_PARAMS_v3*><void_ptr>kernel.getPtr(), sizeof(self._pvt_ptr[0].kernel))
    @property
    def memcpy(self):
        return self._memcpy
    @memcpy.setter
    def memcpy(self, memcpy not None : CUDA_MEMCPY_NODE_PARAMS):
        string.memcpy(&self._pvt_ptr[0].memcpy, <cydriver.CUDA_MEMCPY_NODE_PARAMS*><void_ptr>memcpy.getPtr(), sizeof(self._pvt_ptr[0].memcpy))
    @property
    def memset(self):
        return self._memset
    @memset.setter
    def memset(self, memset not None : CUDA_MEMSET_NODE_PARAMS_v2):
        string.memcpy(&self._pvt_ptr[0].memset, <cydriver.CUDA_MEMSET_NODE_PARAMS_v2*><void_ptr>memset.getPtr(), sizeof(self._pvt_ptr[0].memset))
    @property
    def host(self):
        return self._host
    @host.setter
    def host(self, host not None : CUDA_HOST_NODE_PARAMS_v2):
        string.memcpy(&self._pvt_ptr[0].host, <cydriver.CUDA_HOST_NODE_PARAMS_v2*><void_ptr>host.getPtr(), sizeof(self._pvt_ptr[0].host))
    @property
    def graph(self):
        return self._graph
    @graph.setter
    def graph(self, graph not None : CUDA_CHILD_GRAPH_NODE_PARAMS):
        string.memcpy(&self._pvt_ptr[0].graph, <cydriver.CUDA_CHILD_GRAPH_NODE_PARAMS*><void_ptr>graph.getPtr(), sizeof(self._pvt_ptr[0].graph))
    @property
    def eventWait(self):
        return self._eventWait
    @eventWait.setter
    def eventWait(self, eventWait not None : CUDA_EVENT_WAIT_NODE_PARAMS):
        string.memcpy(&self._pvt_ptr[0].eventWait, <cydriver.CUDA_EVENT_WAIT_NODE_PARAMS*><void_ptr>eventWait.getPtr(), sizeof(self._pvt_ptr[0].eventWait))
    @property
    def eventRecord(self):
        return self._eventRecord
    @eventRecord.setter
    def eventRecord(self, eventRecord not None : CUDA_EVENT_RECORD_NODE_PARAMS):
        string.memcpy(&self._pvt_ptr[0].eventRecord, <cydriver.CUDA_EVENT_RECORD_NODE_PARAMS*><void_ptr>eventRecord.getPtr(), sizeof(self._pvt_ptr[0].eventRecord))
    @property
    def extSemSignal(self):
        return self._extSemSignal
    @extSemSignal.setter
    def extSemSignal(self, extSemSignal not None : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2):
        string.memcpy(&self._pvt_ptr[0].extSemSignal, <cydriver.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2*><void_ptr>extSemSignal.getPtr(), sizeof(self._pvt_ptr[0].extSemSignal))
    @property
    def extSemWait(self):
        return self._extSemWait
    @extSemWait.setter
    def extSemWait(self, extSemWait not None : CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2):
        string.memcpy(&self._pvt_ptr[0].extSemWait, <cydriver.CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2*><void_ptr>extSemWait.getPtr(), sizeof(self._pvt_ptr[0].extSemWait))
    @property
    def alloc(self):
        return self._alloc
    @alloc.setter
    def alloc(self, alloc not None : CUDA_MEM_ALLOC_NODE_PARAMS_v2):
        string.memcpy(&self._pvt_ptr[0].alloc, <cydriver.CUDA_MEM_ALLOC_NODE_PARAMS_v2*><void_ptr>alloc.getPtr(), sizeof(self._pvt_ptr[0].alloc))
    @property
    def free(self):
        return self._free
    @free.setter
    def free(self, free not None : CUDA_MEM_FREE_NODE_PARAMS):
        string.memcpy(&self._pvt_ptr[0].free, <cydriver.CUDA_MEM_FREE_NODE_PARAMS*><void_ptr>free.getPtr(), sizeof(self._pvt_ptr[0].free))
    @property
    def memOp(self):
        return self._memOp
    @memOp.setter
    def memOp(self, memOp not None : CUDA_BATCH_MEM_OP_NODE_PARAMS_v2):
        string.memcpy(&self._pvt_ptr[0].memOp, <cydriver.CUDA_BATCH_MEM_OP_NODE_PARAMS_v2*><void_ptr>memOp.getPtr(), sizeof(self._pvt_ptr[0].memOp))
    @property
    def conditional(self):
        return self._conditional
    @conditional.setter
    def conditional(self, conditional not None : CUDA_CONDITIONAL_NODE_PARAMS):
        string.memcpy(&self._pvt_ptr[0].conditional, <cydriver.CUDA_CONDITIONAL_NODE_PARAMS*><void_ptr>conditional.getPtr(), sizeof(self._pvt_ptr[0].conditional))
    @property
    def reserved2(self):
        return self._pvt_ptr[0].reserved2
    @reserved2.setter
    def reserved2(self, long long reserved2):
        self._pvt_ptr[0].reserved2 = reserved2

cdef class CUcheckpointLockArgs_st:
    """
    CUDA checkpoint optional lock arguments

    Attributes
    ----------
    timeoutMs : unsigned int
        Timeout in milliseconds to attempt to lock the process, 0 indicates
        no timeout
    reserved0 : unsigned int
        Reserved for future use, must be zero
    reserved1 : list[cuuint64_t]
        Reserved for future use, must be zeroed

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUcheckpointLockArgs_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['timeoutMs : ' + str(self.timeoutMs)]
            except ValueError:
                str_list += ['timeoutMs : <ValueError>']
            try:
                str_list += ['reserved0 : ' + str(self.reserved0)]
            except ValueError:
                str_list += ['reserved0 : <ValueError>']
            try:
                str_list += ['reserved1 : ' + str(self.reserved1)]
            except ValueError:
                str_list += ['reserved1 : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def timeoutMs(self):
        return self._pvt_ptr[0].timeoutMs
    @timeoutMs.setter
    def timeoutMs(self, unsigned int timeoutMs):
        self._pvt_ptr[0].timeoutMs = timeoutMs
    @property
    def reserved0(self):
        return self._pvt_ptr[0].reserved0
    @reserved0.setter
    def reserved0(self, unsigned int reserved0):
        self._pvt_ptr[0].reserved0 = reserved0
    @property
    def reserved1(self):
        return [cuuint64_t(init_value=_reserved1) for _reserved1 in self._pvt_ptr[0].reserved1]
    @reserved1.setter
    def reserved1(self, reserved1):
        self._pvt_ptr[0].reserved1 = reserved1


cdef class CUcheckpointCheckpointArgs_st:
    """
    CUDA checkpoint optional checkpoint arguments

    Attributes
    ----------
    reserved : list[cuuint64_t]
        Reserved for future use, must be zeroed

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUcheckpointCheckpointArgs_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return [cuuint64_t(init_value=_reserved) for _reserved in self._pvt_ptr[0].reserved]
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved


cdef class CUcheckpointGpuPair_st:
    """
    CUDA checkpoint GPU UUID pairs for device remapping during restore

    Attributes
    ----------
    oldUuid : CUuuid
        UUID of the GPU that was checkpointed
    newUuid : CUuuid
        UUID of the GPU to restore onto

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUcheckpointGpuPair_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._oldUuid = CUuuid(_ptr=<void_ptr>&self._pvt_ptr[0].oldUuid)
        self._newUuid = CUuuid(_ptr=<void_ptr>&self._pvt_ptr[0].newUuid)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['oldUuid :\n' + '\n'.join(['    ' + line for line in str(self.oldUuid).splitlines()])]
            except ValueError:
                str_list += ['oldUuid : <ValueError>']
            try:
                str_list += ['newUuid :\n' + '\n'.join(['    ' + line for line in str(self.newUuid).splitlines()])]
            except ValueError:
                str_list += ['newUuid : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def oldUuid(self):
        return self._oldUuid
    @oldUuid.setter
    def oldUuid(self, oldUuid not None : CUuuid):
        string.memcpy(&self._pvt_ptr[0].oldUuid, <cydriver.CUuuid*><void_ptr>oldUuid.getPtr(), sizeof(self._pvt_ptr[0].oldUuid))
    @property
    def newUuid(self):
        return self._newUuid
    @newUuid.setter
    def newUuid(self, newUuid not None : CUuuid):
        string.memcpy(&self._pvt_ptr[0].newUuid, <cydriver.CUuuid*><void_ptr>newUuid.getPtr(), sizeof(self._pvt_ptr[0].newUuid))

cdef class CUcheckpointRestoreArgs_st:
    """
    CUDA checkpoint optional restore arguments

    Attributes
    ----------
    gpuPairs : CUcheckpointGpuPair
        Pointer to array of gpu pairs that indicate how to remap GPUs
        during restore
    gpuPairsCount : unsigned int
        Number of gpu pairs to remap
    reserved : bytes
        Reserved for future use, must be zeroed
    reserved1 : cuuint64_t
        Reserved for future use, must be zeroed

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUcheckpointRestoreArgs_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._reserved1 = cuuint64_t(_ptr=<void_ptr>&self._pvt_ptr[0].reserved1)
    def __dealloc__(self):
        pass
        if self._gpuPairs is not NULL:
            free(self._gpuPairs)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['gpuPairs : ' + str(self.gpuPairs)]
            except ValueError:
                str_list += ['gpuPairs : <ValueError>']
            try:
                str_list += ['gpuPairsCount : ' + str(self.gpuPairsCount)]
            except ValueError:
                str_list += ['gpuPairsCount : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            try:
                str_list += ['reserved1 : ' + str(self.reserved1)]
            except ValueError:
                str_list += ['reserved1 : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def gpuPairs(self):
        arrs = [<void_ptr>self._pvt_ptr[0].gpuPairs + x*sizeof(cydriver.CUcheckpointGpuPair) for x in range(self._gpuPairs_length)]
        return [CUcheckpointGpuPair(_ptr=arr) for arr in arrs]
    @gpuPairs.setter
    def gpuPairs(self, val):
        if len(val) == 0:
            free(self._gpuPairs)
            self._gpuPairs_length = 0
            self._pvt_ptr[0].gpuPairs = NULL
        else:
            if self._gpuPairs_length != <size_t>len(val):
                free(self._gpuPairs)
                self._gpuPairs = <cydriver.CUcheckpointGpuPair*> calloc(len(val), sizeof(cydriver.CUcheckpointGpuPair))
                if self._gpuPairs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cydriver.CUcheckpointGpuPair)))
                self._gpuPairs_length = <size_t>len(val)
                self._pvt_ptr[0].gpuPairs = self._gpuPairs
            for idx in range(len(val)):
                string.memcpy(&self._gpuPairs[idx], (<CUcheckpointGpuPair>val[idx])._pvt_ptr, sizeof(cydriver.CUcheckpointGpuPair))

    @property
    def gpuPairsCount(self):
        return self._pvt_ptr[0].gpuPairsCount
    @gpuPairsCount.setter
    def gpuPairsCount(self, unsigned int gpuPairsCount):
        self._pvt_ptr[0].gpuPairsCount = gpuPairsCount
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].reserved, 44)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 44:
            raise ValueError("reserved length must be 44, is " + str(len(reserved)))
        if CHAR_MIN == 0:
            for i, b in enumerate(reserved):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].reserved[i] = b
        else:
            for i, b in enumerate(reserved):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].reserved[i] = b
    @property
    def reserved1(self):
        return self._reserved1
    @reserved1.setter
    def reserved1(self, reserved1):
        cdef cydriver.cuuint64_t cyreserved1
        if reserved1 is None:
            cyreserved1 = <cydriver.cuuint64_t><void_ptr>0
        elif isinstance(reserved1, (cuuint64_t)):
            preserved1 = int(reserved1)
            cyreserved1 = <cydriver.cuuint64_t><void_ptr>preserved1
        else:
            preserved1 = int(cuuint64_t(reserved1))
            cyreserved1 = <cydriver.cuuint64_t><void_ptr>preserved1
        self._reserved1._pvt_ptr[0] = cyreserved1


cdef class CUcheckpointUnlockArgs_st:
    """
    CUDA checkpoint optional unlock arguments

    Attributes
    ----------
    reserved : list[cuuint64_t]
        Reserved for future use, must be zeroed

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUcheckpointUnlockArgs_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return [cuuint64_t(init_value=_reserved) for _reserved in self._pvt_ptr[0].reserved]
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved


cdef class CUmemDecompressParams_st:
    """
    Structure describing the parameters that compose a single
    decompression operation.

    Attributes
    ----------
    srcNumBytes : size_t
        The number of bytes to be read and decompressed from
        CUmemDecompressParams_st.src.
    dstNumBytes : size_t
        The number of bytes that the decompression operation will be
        expected to write to CUmemDecompressParams_st.dst. This value is
        optional; if present, it may be used by the CUDA driver as a
        heuristic for scheduling the individual decompression operations.
    dstActBytes : cuuint32_t
        After the decompression operation has completed, the actual number
        of bytes written to CUmemDecompressParams.dst will be recorded as a
        32-bit unsigned integer in the memory at this address.
    src : Any
        Pointer to a buffer of at least
        CUmemDecompressParams_st.srcNumBytes compressed bytes.
    dst : Any
        Pointer to a buffer where the decompressed data will be written.
        The number of bytes written to this location will be recorded in
        the memory pointed to by CUmemDecompressParams_st.dstActBytes
    algo : CUmemDecompressAlgorithm
        The decompression algorithm to use.
    padding : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemDecompressParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcNumBytes : ' + str(self.srcNumBytes)]
            except ValueError:
                str_list += ['srcNumBytes : <ValueError>']
            try:
                str_list += ['dstNumBytes : ' + str(self.dstNumBytes)]
            except ValueError:
                str_list += ['dstNumBytes : <ValueError>']
            try:
                str_list += ['dstActBytes : ' + str(self.dstActBytes)]
            except ValueError:
                str_list += ['dstActBytes : <ValueError>']
            try:
                str_list += ['src : ' + hex(self.src)]
            except ValueError:
                str_list += ['src : <ValueError>']
            try:
                str_list += ['dst : ' + hex(self.dst)]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['algo : ' + str(self.algo)]
            except ValueError:
                str_list += ['algo : <ValueError>']
            try:
                str_list += ['padding : ' + str(self.padding)]
            except ValueError:
                str_list += ['padding : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcNumBytes(self):
        return self._pvt_ptr[0].srcNumBytes
    @srcNumBytes.setter
    def srcNumBytes(self, size_t srcNumBytes):
        self._pvt_ptr[0].srcNumBytes = srcNumBytes
    @property
    def dstNumBytes(self):
        return self._pvt_ptr[0].dstNumBytes
    @dstNumBytes.setter
    def dstNumBytes(self, size_t dstNumBytes):
        self._pvt_ptr[0].dstNumBytes = dstNumBytes
    @property
    def dstActBytes(self):
        return cuuint32_t(_ptr=<void_ptr>self._pvt_ptr[0].dstActBytes)
    @property
    def src(self):
        return <void_ptr>self._pvt_ptr[0].src
    @src.setter
    def src(self, src):
        _csrc = _HelperInputVoidPtr(src)
        self._pvt_ptr[0].src = <void*><void_ptr>_csrc.cptr
    @property
    def dst(self):
        return <void_ptr>self._pvt_ptr[0].dst
    @dst.setter
    def dst(self, dst):
        _cdst = _HelperInputVoidPtr(dst)
        self._pvt_ptr[0].dst = <void*><void_ptr>_cdst.cptr
    @property
    def algo(self):
        if self._pvt_ptr[0].algo not in _dict_CUmemDecompressAlgorithm:
            return None
        return _dict_CUmemDecompressAlgorithm[self._pvt_ptr[0].algo]
    @algo.setter
    def algo(self, algo not None : CUmemDecompressAlgorithm):
        self._pvt_ptr[0].algo = algo.value
    @property
    def padding(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].padding, 20)
    @padding.setter
    def padding(self, padding):
        if len(padding) != 20:
            raise ValueError("padding length must be 20, is " + str(len(padding)))
        for i, b in enumerate(padding):
            self._pvt_ptr[0].padding[i] = b

cdef class CUdevSmResource_st:
    """
    Attributes
    ----------
    smCount : unsigned int
        The amount of streaming multiprocessors available in this resource.
        This is an output parameter only, do not write to this field.
    minSmPartitionSize : unsigned int
        The minimum number of streaming multiprocessors required to
        partition this resource. This is an output parameter only, do not
        write to this field.
    smCoscheduledAlignment : unsigned int
        The number of streaming multiprocessors in this resource that are
        guaranteed to be co-scheduled on the same GPU processing cluster.
        smCount is a multiple of this value. This is an output parameter
        only, do not write to this field.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUdevSmResource_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['smCount : ' + str(self.smCount)]
            except ValueError:
                str_list += ['smCount : <ValueError>']
            try:
                str_list += ['minSmPartitionSize : ' + str(self.minSmPartitionSize)]
            except ValueError:
                str_list += ['minSmPartitionSize : <ValueError>']
            try:
                str_list += ['smCoscheduledAlignment : ' + str(self.smCoscheduledAlignment)]
            except ValueError:
                str_list += ['smCoscheduledAlignment : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def smCount(self):
        return self._pvt_ptr[0].smCount
    @smCount.setter
    def smCount(self, unsigned int smCount):
        self._pvt_ptr[0].smCount = smCount
    @property
    def minSmPartitionSize(self):
        return self._pvt_ptr[0].minSmPartitionSize
    @minSmPartitionSize.setter
    def minSmPartitionSize(self, unsigned int minSmPartitionSize):
        self._pvt_ptr[0].minSmPartitionSize = minSmPartitionSize
    @property
    def smCoscheduledAlignment(self):
        return self._pvt_ptr[0].smCoscheduledAlignment
    @smCoscheduledAlignment.setter
    def smCoscheduledAlignment(self, unsigned int smCoscheduledAlignment):
        self._pvt_ptr[0].smCoscheduledAlignment = smCoscheduledAlignment

cdef class CUdevResource_st:
    """
    Attributes
    ----------
    type : CUdevResourceType
        Type of resource, dictates which union field was last set
    _internal_padding : bytes

    sm : CUdevSmResource
        Resource corresponding to CU_DEV_RESOURCE_TYPE_SM `typename`.
    _oversize : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUdevResource_st *>calloc(1, sizeof(cydriver.CUdevResource_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUdevResource_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._sm = CUdevSmResource(_ptr=<void_ptr>&self._pvt_ptr[0].sm)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['_internal_padding : ' + str(self._internal_padding)]
            except ValueError:
                str_list += ['_internal_padding : <ValueError>']
            try:
                str_list += ['sm :\n' + '\n'.join(['    ' + line for line in str(self.sm).splitlines()])]
            except ValueError:
                str_list += ['sm : <ValueError>']
            try:
                str_list += ['_oversize : ' + str(self._oversize)]
            except ValueError:
                str_list += ['_oversize : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_CUdevResourceType:
            return None
        return _dict_CUdevResourceType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : CUdevResourceType):
        self._pvt_ptr[0].type = type.value
    @property
    def _internal_padding(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0]._internal_padding, 92)
    @_internal_padding.setter
    def _internal_padding(self, _internal_padding):
        if len(_internal_padding) != 92:
            raise ValueError("_internal_padding length must be 92, is " + str(len(_internal_padding)))
        for i, b in enumerate(_internal_padding):
            self._pvt_ptr[0]._internal_padding[i] = b
    @property
    def sm(self):
        return self._sm
    @sm.setter
    def sm(self, sm not None : CUdevSmResource):
        string.memcpy(&self._pvt_ptr[0].sm, <cydriver.CUdevSmResource*><void_ptr>sm.getPtr(), sizeof(self._pvt_ptr[0].sm))
    @property
    def _oversize(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0]._oversize, 48)
    @_oversize.setter
    def _oversize(self, _oversize):
        if len(_oversize) != 48:
            raise ValueError("_oversize length must be 48, is " + str(len(_oversize)))
        for i, b in enumerate(_oversize):
            self._pvt_ptr[0]._oversize[i] = b

cdef class anon_union15:
    """
    Attributes
    ----------
    pArray : list[CUarray]

    pPitch : list[Any]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cydriver.CUeglFrame_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].frame
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['pArray : ' + str(self.pArray)]
            except ValueError:
                str_list += ['pArray : <ValueError>']
            try:
                str_list += ['pPitch : ' + hex(self.pPitch)]
            except ValueError:
                str_list += ['pPitch : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def pArray(self):
        return [CUarray(init_value=<void_ptr>_pArray) for _pArray in self._pvt_ptr[0].frame.pArray]
    @pArray.setter
    def pArray(self, pArray : list[CUarray]):
        if len(pArray) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(pArray))
        pArray = [int(_pArray) for _pArray in pArray]
        for _idx, _pArray in enumerate(pArray):
            self._pvt_ptr[0].frame.pArray[_idx] = <cydriver.CUarray><void_ptr>_pArray

    @property
    def pPitch(self):
        return [<void_ptr>_pPitch for _pPitch in self._pvt_ptr[0].frame.pPitch]
    @pPitch.setter
    def pPitch(self, pPitch : list[int]):
        if len(pPitch) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(pPitch))
        pPitch = [<void_ptr>_pPitch for _pPitch in pPitch]
        for _idx, _pPitch in enumerate(pPitch):
            self._pvt_ptr[0].frame.pPitch[_idx] = <void*><void_ptr>_pPitch

cdef class CUeglFrame_st:
    """
    CUDA EGLFrame structure Descriptor - structure defining one frame
    of EGL.  Each frame may contain one or more planes depending on
    whether the surface * is Multiplanar or not.

    Attributes
    ----------
    frame : anon_union15

    width : unsigned int
        Width of first plane
    height : unsigned int
        Height of first plane
    depth : unsigned int
        Depth of first plane
    pitch : unsigned int
        Pitch of first plane
    planeCount : unsigned int
        Number of planes
    numChannels : unsigned int
        Number of channels for the plane
    frameType : CUeglFrameType
        Array or Pitch
    eglColorFormat : CUeglColorFormat
        CUDA EGL Color Format
    cuFormat : CUarray_format
        CUDA Array Format

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cydriver.CUeglFrame_st *>calloc(1, sizeof(cydriver.CUeglFrame_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cydriver.CUeglFrame_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._frame = anon_union15(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['frame :\n' + '\n'.join(['    ' + line for line in str(self.frame).splitlines()])]
            except ValueError:
                str_list += ['frame : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['planeCount : ' + str(self.planeCount)]
            except ValueError:
                str_list += ['planeCount : <ValueError>']
            try:
                str_list += ['numChannels : ' + str(self.numChannels)]
            except ValueError:
                str_list += ['numChannels : <ValueError>']
            try:
                str_list += ['frameType : ' + str(self.frameType)]
            except ValueError:
                str_list += ['frameType : <ValueError>']
            try:
                str_list += ['eglColorFormat : ' + str(self.eglColorFormat)]
            except ValueError:
                str_list += ['eglColorFormat : <ValueError>']
            try:
                str_list += ['cuFormat : ' + str(self.cuFormat)]
            except ValueError:
                str_list += ['cuFormat : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def frame(self):
        return self._frame
    @frame.setter
    def frame(self, frame not None : anon_union15):
        string.memcpy(&self._pvt_ptr[0].frame, <cydriver.anon_union15*><void_ptr>frame.getPtr(), sizeof(self._pvt_ptr[0].frame))
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, unsigned int width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, unsigned int height):
        self._pvt_ptr[0].height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].depth
    @depth.setter
    def depth(self, unsigned int depth):
        self._pvt_ptr[0].depth = depth
    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, unsigned int pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def planeCount(self):
        return self._pvt_ptr[0].planeCount
    @planeCount.setter
    def planeCount(self, unsigned int planeCount):
        self._pvt_ptr[0].planeCount = planeCount
    @property
    def numChannels(self):
        return self._pvt_ptr[0].numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        self._pvt_ptr[0].numChannels = numChannels
    @property
    def frameType(self):
        if self._pvt_ptr[0].frameType not in _dict_CUeglFrameType:
            return None
        return _dict_CUeglFrameType[self._pvt_ptr[0].frameType]
    @frameType.setter
    def frameType(self, frameType not None : CUeglFrameType):
        self._pvt_ptr[0].frameType = frameType.value
    @property
    def eglColorFormat(self):
        if self._pvt_ptr[0].eglColorFormat not in _dict_CUeglColorFormat:
            return None
        return _dict_CUeglColorFormat[self._pvt_ptr[0].eglColorFormat]
    @eglColorFormat.setter
    def eglColorFormat(self, eglColorFormat not None : CUeglColorFormat):
        self._pvt_ptr[0].eglColorFormat = eglColorFormat.value
    @property
    def cuFormat(self):
        if self._pvt_ptr[0].cuFormat not in _dict_CUarray_format:
            return None
        return _dict_CUarray_format[self._pvt_ptr[0].cuFormat]
    @cuFormat.setter
    def cuFormat(self, cuFormat not None : CUarray_format):
        self._pvt_ptr[0].cuFormat = cuFormat.value

cdef class cuuint32_t:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.cuuint32_t *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<cuuint32_t ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cuuint64_t:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint64_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.cuuint64_t *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<cuuint64_t ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint64_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUdeviceptr_v2:
    """

    CUDA device pointer CUdeviceptr is defined as an unsigned integer type whose size matches the size of a pointer on the target platform.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUdeviceptr_v2 *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUdeviceptr_v2 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUdevice_v1:
    """

    CUDA device

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUdevice_v1 *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUdevice_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUtexObject_v1:
    """

    An opaque value that represents a CUDA texture object

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUtexObject_v1 *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUtexObject_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUsurfObject_v1:
    """

    An opaque value that represents a CUDA surface object

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUsurfObject_v1 *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUsurfObject_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUmemGenericAllocationHandle_v1:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUmemGenericAllocationHandle_v1 *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUmemGenericAllocationHandle_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class CUlogIterator:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.CUlogIterator *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<CUlogIterator ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class GLenum:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.GLenum *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<GLenum ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class GLuint:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.GLuint *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<GLuint ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLint:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.EGLint *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<EGLint ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpDevice:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.VdpDevice *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpDevice ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpGetProcAddress:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.VdpGetProcAddress *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpGetProcAddress ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpVideoSurface:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.VdpVideoSurface *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpVideoSurface ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpOutputSurface:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cydriver.VdpOutputSurface *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpOutputSurface ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

@cython.embedsignature(True)
def cuGetErrorString(error not None : CUresult):
    """ Gets the string description of an error code.

    Sets `*pStr` to the address of a NULL-terminated string description of
    the error code `error`. If the error code is not recognized,
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE` will be returned and `*pStr` will
    be set to the NULL address.

    Parameters
    ----------
    error : :py:obj:`~.CUresult`
        Error code to convert to string

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pStr : bytes
        Address of the string pointer.

    See Also
    --------
    :py:obj:`~.CUresult`, :py:obj:`~.cudaGetErrorString`
    """
    cdef cydriver.CUresult cyerror = error.value
    cdef const char* pStr = NULL
    with nogil:
        err = cydriver.cuGetErrorString(cyerror, &pStr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], <bytes>pStr if pStr != NULL else None)

@cython.embedsignature(True)
def cuGetErrorName(error not None : CUresult):
    """ Gets the string representation of an error code enum name.

    Sets `*pStr` to the address of a NULL-terminated string representation
    of the name of the enum error code `error`. If the error code is not
    recognized, :py:obj:`~.CUDA_ERROR_INVALID_VALUE` will be returned and
    `*pStr` will be set to the NULL address.

    Parameters
    ----------
    error : :py:obj:`~.CUresult`
        Error code to convert to string

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pStr : bytes
        Address of the string pointer.

    See Also
    --------
    :py:obj:`~.CUresult`, :py:obj:`~.cudaGetErrorName`
    """
    cdef cydriver.CUresult cyerror = error.value
    cdef const char* pStr = NULL
    with nogil:
        err = cydriver.cuGetErrorName(cyerror, &pStr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], <bytes>pStr if pStr != NULL else None)

@cython.embedsignature(True)
def cuInit(unsigned int Flags):
    """ Initialize the CUDA driver API Initializes the driver API and must be called before any other function from the driver API in the current process. Currently, the `Flags` parameter must be 0. If :py:obj:`~.cuInit()` has not been called, any function from the driver API will return :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`.

    Note: cuInit preloads various libraries needed for JIT compilation. To
    opt-out of this behavior, set the environment variable
    CUDA_FORCE_PRELOAD_LIBRARIES=0. CUDA will lazily load JIT libraries as
    needed. To disable JIT entirely, set the environment variable
    CUDA_DISABLE_JIT=1.

    Parameters
    ----------
    Flags : unsigned int
        Initialization flag for CUDA.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_SYSTEM_DRIVER_MISMATCH`, :py:obj:`~.CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE`
    """
    with nogil:
        err = cydriver.cuInit(Flags)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDriverGetVersion():
    """ Returns the latest CUDA version supported by driver.

    Returns in `*driverVersion` the version of CUDA supported by the
    driver. The version is returned as (1000 * major + 10 * minor). For
    example, CUDA 9.2 would be represented by 9020.

    This function automatically returns
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE` if `driverVersion` is NULL.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    driverVersion : int
        Returns the CUDA driver version

    See Also
    --------
    :py:obj:`~.cudaDriverGetVersion`, :py:obj:`~.cudaRuntimeGetVersion`
    """
    cdef int driverVersion = 0
    with nogil:
        err = cydriver.cuDriverGetVersion(&driverVersion)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], driverVersion)

@cython.embedsignature(True)
def cuDeviceGet(int ordinal):
    """ Returns a handle to a compute device.

    Returns in `*device` a device handle given an ordinal in the range [0,
    :py:obj:`~.cuDeviceGetCount()`-1].

    Parameters
    ----------
    ordinal : int
        Device number to get handle for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    device : :py:obj:`~.CUdevice`
        Returned device handle

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGetLuid`, :py:obj:`~.cuDeviceTotalMem`, :py:obj:`~.cuDeviceGetExecAffinitySupport`
    """
    cdef CUdevice device = CUdevice()
    with nogil:
        err = cydriver.cuDeviceGet(<cydriver.CUdevice*>device._pvt_ptr, ordinal)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], device)

@cython.embedsignature(True)
def cuDeviceGetCount():
    """ Returns the number of compute-capable devices.

    Returns in `*count` the number of devices with compute capability
    greater than or equal to 2.0 that are available for execution. If there
    is no such device, :py:obj:`~.cuDeviceGetCount()` returns 0.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    count : int
        Returned number of compute-capable devices

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGetLuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`, :py:obj:`~.cuDeviceGetExecAffinitySupport`, :py:obj:`~.cudaGetDeviceCount`
    """
    cdef int count = 0
    with nogil:
        err = cydriver.cuDeviceGetCount(&count)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], count)

@cython.embedsignature(True)
def cuDeviceGetName(int length, dev):
    """ Returns an identifier string for the device.

    Returns an ASCII string identifying the device `dev` in the NULL-
    terminated string pointed to by `name`. `length` specifies the maximum
    length of the string that may be returned. `name` is shortened to the
    specified `length`, if `length` is less than the device name

    Parameters
    ----------
    length : int
        Maximum length of string to store in `name`
    dev : :py:obj:`~.CUdevice`
        Device to get identifier string for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    name : bytes
        Returned identifier string for the device

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGetLuid`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`, :py:obj:`~.cuDeviceGetExecAffinitySupport`, :py:obj:`~.cudaGetDeviceProperties`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    pyname = b" " * length
    cdef char* name = pyname
    with nogil:
        err = cydriver.cuDeviceGetName(name, length, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pyname)

@cython.embedsignature(True)
def cuDeviceGetUuid(dev):
    """ Return an UUID for the device.

    Returns 16-octets identifying the device `dev` in the structure pointed
    by the `uuid`. If the device is in MIG mode, returns its MIG UUID which
    uniquely identifies the subscribed MIG compute instance.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device to get identifier string for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    uuid : :py:obj:`~.CUuuid`
        Returned UUID

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetLuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`, :py:obj:`~.cudaGetDeviceProperties`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef CUuuid uuid = CUuuid()
    with nogil:
        err = cydriver.cuDeviceGetUuid(<cydriver.CUuuid*>uuid._pvt_ptr, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], uuid)

@cython.embedsignature(True)
def cuDeviceGetLuid(dev):
    """ Return an LUID and device node mask for the device.

    Return identifying information (`luid` and `deviceNodeMask`) to allow
    matching device with graphics APIs.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device to get identifier string for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    luid : bytes
        Returned LUID
    deviceNodeMask : unsigned int
        Returned device node mask

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`, :py:obj:`~.cuDeviceGetExecAffinitySupport`, :py:obj:`~.cudaGetDeviceProperties`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef char luid[8]
    cdef unsigned int deviceNodeMask = 0
    with nogil:
        err = cydriver.cuDeviceGetLuid(luid, &deviceNodeMask, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], <bytes>luid, deviceNodeMask)

@cython.embedsignature(True)
def cuDeviceTotalMem(dev):
    """ Returns the total amount of memory on the device.

    Returns in `*bytes` the total amount of memory available on the device
    `dev` in bytes.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device handle

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    numbytes : int
        Returned memory available on device in bytes

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceGetExecAffinitySupport`, :py:obj:`~.cudaMemGetInfo`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef size_t numbytes = 0
    with nogil:
        err = cydriver.cuDeviceTotalMem(&numbytes, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], numbytes)

@cython.embedsignature(True)
def cuDeviceGetTexture1DLinearMaxWidth(pformat not None : CUarray_format, unsigned numChannels, dev):
    """ Returns the maximum number of elements allocatable in a 1D linear texture for a given texture element size.

    Returns in `maxWidthInElements` the maximum number of texture elements
    allocatable in a 1D linear texture for given `pformat` and
    `numChannels`.

    Parameters
    ----------
    pformat : :py:obj:`~.CUarray_format`
        Texture format.
    numChannels : unsigned
        Number of channels per texture element.
    dev : :py:obj:`~.CUdevice`
        Device handle.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    maxWidthInElements : int
        Returned maximum number of texture elements allocatable for given
        `pformat` and `numChannels`.

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cudaMemGetInfo`, :py:obj:`~.cuDeviceTotalMem`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef size_t maxWidthInElements = 0
    cdef cydriver.CUarray_format cypformat = pformat.value
    with nogil:
        err = cydriver.cuDeviceGetTexture1DLinearMaxWidth(&maxWidthInElements, cypformat, numChannels, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], maxWidthInElements)

@cython.embedsignature(True)
def cuDeviceGetAttribute(attrib not None : CUdevice_attribute, dev):
    """ Returns information about the device.

    Returns in `*pi` the integer value of the attribute `attrib` on device
    `dev`.

    Parameters
    ----------
    attrib : :py:obj:`~.CUdevice_attribute`
        Device attribute to query
    dev : :py:obj:`~.CUdevice`
        Device handle

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    pi : int
        Returned device attribute value

    See Also
    --------
    :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`, :py:obj:`~.cuDeviceGetExecAffinitySupport`, :py:obj:`~.cudaDeviceGetAttribute`, :py:obj:`~.cudaGetDeviceProperties`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef int pi = 0
    cdef cydriver.CUdevice_attribute cyattrib = attrib.value
    with nogil:
        err = cydriver.cuDeviceGetAttribute(&pi, cyattrib, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pi)

@cython.embedsignature(True)
def cuDeviceGetHostAtomicCapabilities(operations : Optional[tuple[CUatomicOperation] | list[CUatomicOperation]], unsigned int count, dev):
    """ Queries details about atomic operations supported between the device and host.

    Returns in `*capabilities` the details about requested atomic
    `*operations` over the the link between `dev` and the host. The
    allocated size of `*operations` and `*capabilities` must be `count`.

    For each :py:obj:`~.CUatomicOperation` in `*operations`, the
    corresponding result in `*capabilities` will be a bitmask indicating
    which of :py:obj:`~.CUatomicOperationCapability` the link supports
    natively.

    Returns :py:obj:`~.CUDA_ERROR_INVALID_DEVICE` if `dev` is not valid.

    Returns :py:obj:`~.CUDA_ERROR_INVALID_VALUE` if `*capabilities` or
    `*operations` is NULL, if `count` is 0, or if any of `*operations` is
    not valid.

    Parameters
    ----------
    operations : list[:py:obj:`~.CUatomicOperation`]
        Requested operations
    count : unsigned int
        Count of requested operations and size of capabilities
    dev : :py:obj:`~.CUdevice`
        Device handle

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    capabilities : list[unsigned int]
        Returned capability details of each requested operation

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetP2PAtomicCapabilities`, :py:obj:`~.cudaDeviceGeHostAtomicCapabilities`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    operations = [] if operations is None else operations
    if not all(isinstance(_x, (CUatomicOperation)) for _x in operations):
        raise TypeError("Argument 'operations' is not instance of type (expected tuple[cydriver.CUatomicOperation] or list[cydriver.CUatomicOperation]")
    cdef unsigned int* cycapabilities = NULL
    pycapabilities = []
    if count != 0:
        cycapabilities = <unsigned int*>calloc(count, sizeof(unsigned int))
        if cycapabilities is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(count) + 'x' + str(sizeof(unsigned int)))
    cdef vector[cydriver.CUatomicOperation] cyoperations = [pyoperations.value for pyoperations in (operations)]
    if count > len(operations): raise RuntimeError("List is too small: " + str(len(operations)) + " < " + str(count))
    with nogil:
        err = cydriver.cuDeviceGetHostAtomicCapabilities(cycapabilities, cyoperations.data(), count, cydev)
    if CUresult(err) == CUresult(0):
        pycapabilities = [<unsigned int>cycapabilities[idx] for idx in range(count)]
    if cycapabilities is not NULL:
        free(cycapabilities)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pycapabilities)

@cython.embedsignature(True)
def cuDeviceGetNvSciSyncAttributes(nvSciSyncAttrList, dev, int flags):
    """ Return NvSciSync attributes that this device can support.

    Returns in `nvSciSyncAttrList`, the properties of NvSciSync that this
    CUDA device, `dev` can support. The returned `nvSciSyncAttrList` can be
    used to create an NvSciSync object that matches this device's
    capabilities.

    If NvSciSyncAttrKey_RequiredPerm field in `nvSciSyncAttrList` is
    already set this API will return :py:obj:`~.CUDA_ERROR_INVALID_VALUE`.

    The applications should set `nvSciSyncAttrList` to a valid
    NvSciSyncAttrList failing which this API will return
    :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`.

    The `flags` controls how applications intends to use the NvSciSync
    created from the `nvSciSyncAttrList`. The valid flags are:

    - :py:obj:`~.CUDA_NVSCISYNC_ATTR_SIGNAL`, specifies that the
      applications intends to signal an NvSciSync on this CUDA device.

    - :py:obj:`~.CUDA_NVSCISYNC_ATTR_WAIT`, specifies that the applications
      intends to wait on an NvSciSync on this CUDA device.

    At least one of these flags must be set, failing which the API returns
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE`. Both the flags are orthogonal to
    one another: a developer may set both these flags that allows to set
    both wait and signal specific attributes in the same
    `nvSciSyncAttrList`.

    Note that this API updates the input `nvSciSyncAttrList` with values
    equivalent to the following public attribute key-values:
    NvSciSyncAttrKey_RequiredPerm is set to

    - NvSciSyncAccessPerm_SignalOnly if
      :py:obj:`~.CUDA_NVSCISYNC_ATTR_SIGNAL` is set in `flags`.

    - NvSciSyncAccessPerm_WaitOnly if :py:obj:`~.CUDA_NVSCISYNC_ATTR_WAIT`
      is set in `flags`.

    - NvSciSyncAccessPerm_WaitSignal if both
      :py:obj:`~.CUDA_NVSCISYNC_ATTR_WAIT` and
      :py:obj:`~.CUDA_NVSCISYNC_ATTR_SIGNAL` are set in `flags`.
      NvSciSyncAttrKey_PrimitiveInfo is set to

    - NvSciSyncAttrValPrimitiveType_SysmemSemaphore on any valid `device`.

    - NvSciSyncAttrValPrimitiveType_Syncpoint if `device` is a Tegra
      device.

    - NvSciSyncAttrValPrimitiveType_SysmemSemaphorePayload64b if `device`
      is GA10X+. NvSciSyncAttrKey_GpuId is set to the same UUID that is
      returned for this `device` from :py:obj:`~.cuDeviceGetUuid`.

    :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`,
    :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`,
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`,
    :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`,
    :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`,
    :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`

    Parameters
    ----------
    nvSciSyncAttrList : Any
        Return NvSciSync attributes supported.
    dev : :py:obj:`~.CUdevice`
        Valid Cuda Device to get NvSciSync attributes for.
    flags : int
        flags describing NvSciSync usage.

    Returns
    -------
    CUresult


    See Also
    --------
    :py:obj:`~.cuImportExternalSemaphore`, :py:obj:`~.cuDestroyExternalSemaphore`, :py:obj:`~.cuSignalExternalSemaphoresAsync`, :py:obj:`~.cuWaitExternalSemaphoresAsync`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cynvSciSyncAttrList = _HelperInputVoidPtr(nvSciSyncAttrList)
    cdef void* cynvSciSyncAttrList_ptr = <void*><void_ptr>cynvSciSyncAttrList.cptr
    with nogil:
        err = cydriver.cuDeviceGetNvSciSyncAttributes(cynvSciSyncAttrList_ptr, cydev, flags)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDeviceSetMemPool(dev, pool):
    """ Sets the current memory pool of a device.

    The memory pool must be local to the specified device.
    :py:obj:`~.cuMemAllocAsync` allocates from the current mempool of the
    provided stream's device. By default, a device's current memory pool is
    its default memory pool.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        None
    pool : :py:obj:`~.CUmemoryPool` or :py:obj:`~.cudaMemPool_t`
        None

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuDeviceGetDefaultMemPool`, :py:obj:`~.cuDeviceGetMemPool`, :py:obj:`~.cuMemPoolCreate`, :py:obj:`~.cuMemPoolDestroy`, :py:obj:`~.cuMemAllocFromPoolAsync`

    Notes
    -----
    Use :py:obj:`~.cuMemAllocFromPoolAsync` to specify asynchronous allocations from a device different than the one the stream runs on.
    """
    cdef cydriver.CUmemoryPool cypool
    if pool is None:
        ppool = 0
    elif isinstance(pool, (CUmemoryPool,)):
        ppool = int(pool)
    else:
        ppool = int(CUmemoryPool(pool))
    cypool = <cydriver.CUmemoryPool><void_ptr>ppool
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    with nogil:
        err = cydriver.cuDeviceSetMemPool(cydev, cypool)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDeviceGetMemPool(dev):
    """ Gets the current mempool for a device.

    Returns the last pool provided to :py:obj:`~.cuDeviceSetMemPool` for
    this device or the device's default memory pool if
    :py:obj:`~.cuDeviceSetMemPool` has never been called. By default the
    current mempool is the default mempool for a device. Otherwise the
    returned pool must have been set with :py:obj:`~.cuDeviceSetMemPool`.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        None

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pool : :py:obj:`~.CUmemoryPool`
        None

    See Also
    --------
    :py:obj:`~.cuDeviceGetDefaultMemPool`, :py:obj:`~.cuMemPoolCreate`, :py:obj:`~.cuDeviceSetMemPool`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef CUmemoryPool pool = CUmemoryPool()
    with nogil:
        err = cydriver.cuDeviceGetMemPool(<cydriver.CUmemoryPool*>pool._pvt_ptr, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pool)

@cython.embedsignature(True)
def cuDeviceGetDefaultMemPool(dev):
    """ Returns the default mempool of a device.

    The default mempool of a device contains device memory from that
    device.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        None

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED` :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`
    pool_out : :py:obj:`~.CUmemoryPool`
        None

    See Also
    --------
    :py:obj:`~.cuMemAllocAsync`, :py:obj:`~.cuMemPoolTrimTo`, :py:obj:`~.cuMemPoolGetAttribute`, :py:obj:`~.cuMemPoolSetAttribute`, :py:obj:`~.cuMemPoolSetAccess`, :py:obj:`~.cuDeviceGetMemPool`, :py:obj:`~.cuMemPoolCreate`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef CUmemoryPool pool_out = CUmemoryPool()
    with nogil:
        err = cydriver.cuDeviceGetDefaultMemPool(<cydriver.CUmemoryPool*>pool_out._pvt_ptr, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pool_out)

@cython.embedsignature(True)
def cuDeviceGetExecAffinitySupport(typename not None : CUexecAffinityType, dev):
    """ Returns information about the execution affinity support of the device.

    Returns in `*pi` whether execution affinity type `typename` is
    supported by device `dev`. The supported types are:

    - :py:obj:`~.CU_EXEC_AFFINITY_TYPE_SM_COUNT`: 1 if context with limited
      SMs is supported by the device, or 0 if not;

    Parameters
    ----------
    typename : :py:obj:`~.CUexecAffinityType`
        Execution affinity type to query
    dev : :py:obj:`~.CUdevice`
        Device handle

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    pi : int
        1 if the execution affinity type `typename` is supported by the
        device, or 0 if not

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef int pi = 0
    cdef cydriver.CUexecAffinityType cytypename = typename.value
    with nogil:
        err = cydriver.cuDeviceGetExecAffinitySupport(&pi, cytypename, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pi)

@cython.embedsignature(True)
def cuFlushGPUDirectRDMAWrites(target not None : CUflushGPUDirectRDMAWritesTarget, scope not None : CUflushGPUDirectRDMAWritesScope):
    """ Blocks until remote writes are visible to the specified scope.

    Blocks until GPUDirect RDMA writes to the target context via mappings
    created through APIs like nvidia_p2p_get_pages (see
    https://docs.nvidia.com/cuda/gpudirect-rdma for more information), are
    visible to the specified scope.

    If the scope equals or lies within the scope indicated by
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING`, the
    call will be a no-op and can be safely omitted for performance. This
    can be determined by comparing the numerical values between the two
    enums, with smaller scopes having smaller values.

    On platforms that support GPUDirect RDMA writes via more than one path
    in hardware (see
    :py:obj:`~.CU_MEM_RANGE_FLAG_DMA_BUF_MAPPING_TYPE_PCIE`), the user
    should consider those paths as belonging to separate ordering domains.
    Note that in such cases CUDA driver will report both RDMA writes
    ordering and RDMA write scope as ALL_DEVICES and a call to
    cuFlushGPUDirectRDMA will be a no-op, but when these multiple paths are
    used simultaneously, it is the user's responsibility to ensure ordering
    by using mechanisms outside the scope of CUDA.

    Users may query support for this API via
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_FLUSH_FLUSH_GPU_DIRECT_RDMA_OPTIONS`.

    Parameters
    ----------
    target : :py:obj:`~.CUflushGPUDirectRDMAWritesTarget`
        The target of the operation, see
        :py:obj:`~.CUflushGPUDirectRDMAWritesTarget`
    scope : :py:obj:`~.CUflushGPUDirectRDMAWritesScope`
        The scope of the operation, see
        :py:obj:`~.CUflushGPUDirectRDMAWritesScope`

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    """
    cdef cydriver.CUflushGPUDirectRDMAWritesTarget cytarget = target.value
    cdef cydriver.CUflushGPUDirectRDMAWritesScope cyscope = scope.value
    with nogil:
        err = cydriver.cuFlushGPUDirectRDMAWrites(cytarget, cyscope)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDeviceGetProperties(dev):
    """ Returns properties for a selected device.

    [Deprecated]

    This function was deprecated as of CUDA 5.0 and replaced by
    :py:obj:`~.cuDeviceGetAttribute()`.

    Returns in `*prop` the properties of device `dev`. The
    :py:obj:`~.CUdevprop` structure is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    where:

    - :py:obj:`~.maxThreadsPerBlock` is the maximum number of threads per
      block;

    - :py:obj:`~.maxThreadsDim`[3] is the maximum sizes of each dimension
      of a block;

    - :py:obj:`~.maxGridSize`[3] is the maximum sizes of each dimension of
      a grid;

    - :py:obj:`~.sharedMemPerBlock` is the total amount of shared memory
      available per block in bytes;

    - :py:obj:`~.totalConstantMemory` is the total amount of constant
      memory available on the device in bytes;

    - :py:obj:`~.SIMDWidth` is the warp size;

    - :py:obj:`~.memPitch` is the maximum pitch allowed by the memory copy
      functions that involve memory regions allocated through
      :py:obj:`~.cuMemAllocPitch()`;

    - :py:obj:`~.regsPerBlock` is the total number of registers available
      per block;

    - :py:obj:`~.clockRate` is the clock frequency in kilohertz;

    - :py:obj:`~.textureAlign` is the alignment requirement; texture base
      addresses that are aligned to :py:obj:`~.textureAlign` bytes do not
      need an offset applied to texture fetches.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device to get properties for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    prop : :py:obj:`~.CUdevprop`
        Returned properties of device

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef CUdevprop prop = CUdevprop()
    with nogil:
        err = cydriver.cuDeviceGetProperties(<cydriver.CUdevprop*>prop._pvt_ptr, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], prop)

@cython.embedsignature(True)
def cuDeviceComputeCapability(dev):
    """ Returns the compute capability of the device.

    [Deprecated]

    This function was deprecated as of CUDA 5.0 and its functionality
    superseded by :py:obj:`~.cuDeviceGetAttribute()`.

    Returns in `*major` and `*minor` the major and minor revision numbers
    that define the compute capability of the device `dev`.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device handle

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    major : int
        Major revision number
    minor : int
        Minor revision number

    See Also
    --------
    :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetCount`, :py:obj:`~.cuDeviceGetName`, :py:obj:`~.cuDeviceGetUuid`, :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceTotalMem`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef int major = 0
    cdef int minor = 0
    with nogil:
        err = cydriver.cuDeviceComputeCapability(&major, &minor, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], major, minor)

@cython.embedsignature(True)
def cuDevicePrimaryCtxRetain(dev):
    """ Retain the primary context on the GPU.

    Retains the primary context on the device. Once the user successfully
    retains the primary context, the primary context will be active and
    available to the user until the user releases it with
    :py:obj:`~.cuDevicePrimaryCtxRelease()` or resets it with
    :py:obj:`~.cuDevicePrimaryCtxReset()`. Unlike :py:obj:`~.cuCtxCreate()`
    the newly retained context is not pushed onto the stack.

    Retaining the primary context for the first time will fail with
    :py:obj:`~.CUDA_ERROR_UNKNOWN` if the compute mode of the device is
    :py:obj:`~.CU_COMPUTEMODE_PROHIBITED`. The function
    :py:obj:`~.cuDeviceGetAttribute()` can be used with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_COMPUTE_MODE` to determine the compute
    mode of the device. The `nvidia-smi` tool can be used to set the
    compute mode for devices. Documentation for `nvidia-smi` can be
    obtained by passing a -h option to it.

    Please note that the primary context always supports pinned
    allocations. Other flags can be specified by
    :py:obj:`~.cuDevicePrimaryCtxSetFlags()`.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device for which primary context is requested

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_UNKNOWN`
    pctx : :py:obj:`~.CUcontext`
        Returned context handle of the new context

    See Also
    --------
    :py:obj:`~.cuDevicePrimaryCtxRelease`, :py:obj:`~.cuDevicePrimaryCtxSetFlags`, :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef CUcontext pctx = CUcontext()
    with nogil:
        err = cydriver.cuDevicePrimaryCtxRetain(<cydriver.CUcontext*>pctx._pvt_ptr, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pctx)

@cython.embedsignature(True)
def cuDevicePrimaryCtxRelease(dev):
    """ Release the primary context on the GPU.

    Releases the primary context interop on the device. A retained context
    should always be released once the user is done using it. The context
    is automatically reset once the last reference to it is released. This
    behavior is different when the primary context was retained by the CUDA
    runtime from CUDA 4.0 and earlier. In this case, the primary context
    remains always active.

    Releasing a primary context that has not been previously retained will
    fail with :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`.

    Please note that unlike :py:obj:`~.cuCtxDestroy()` this method does not
    pop the context from stack in any circumstances.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device which primary context is released

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`

    See Also
    --------
    :py:obj:`~.cuDevicePrimaryCtxRetain`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    with nogil:
        err = cydriver.cuDevicePrimaryCtxRelease(cydev)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDevicePrimaryCtxSetFlags(dev, unsigned int flags):
    """ Set flags for the primary context.

    Sets the flags for the primary context on the device overwriting
    perviously set ones.

    The three LSBs of the `flags` parameter can be used to control how the
    OS thread, which owns the CUDA context at the time of an API call,
    interacts with the OS scheduler when waiting for results from the GPU.
    Only one of the scheduling flags can be set when creating a context.

    - :py:obj:`~.CU_CTX_SCHED_SPIN`: Instruct CUDA to actively spin when
      waiting for results from the GPU. This can decrease latency when
      waiting for the GPU, but may lower the performance of CPU threads if
      they are performing work in parallel with the CUDA thread.

    - :py:obj:`~.CU_CTX_SCHED_YIELD`: Instruct CUDA to yield its thread
      when waiting for results from the GPU. This can increase latency when
      waiting for the GPU, but can increase the performance of CPU threads
      performing work in parallel with the GPU.

    - :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC`: Instruct CUDA to block the
      CPU thread on a synchronization primitive when waiting for the GPU to
      finish work.

    - :py:obj:`~.CU_CTX_BLOCKING_SYNC`: Instruct CUDA to block the CPU
      thread on a synchronization primitive when waiting for the GPU to
      finish work.   Deprecated: This flag was deprecated as of CUDA 4.0
      and was replaced with :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC`.

    - :py:obj:`~.CU_CTX_SCHED_AUTO`: The default value if the `flags`
      parameter is zero, uses a heuristic based on the number of active
      CUDA contexts in the process `C` and the number of logical processors
      in the system `P`. If `C` > `P`, then CUDA will yield to other OS
      threads when waiting for the GPU (:py:obj:`~.CU_CTX_SCHED_YIELD`),
      otherwise CUDA will not yield while waiting for results and actively
      spin on the processor (:py:obj:`~.CU_CTX_SCHED_SPIN`). Additionally,
      on Tegra devices, :py:obj:`~.CU_CTX_SCHED_AUTO` uses a heuristic
      based on the power profile of the platform and may choose
      :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC` for low-powered devices.

    - :py:obj:`~.CU_CTX_LMEM_RESIZE_TO_MAX`: Instruct CUDA to not reduce
      local memory after resizing local memory for a kernel. This can
      prevent thrashing by local memory allocations when launching many
      kernels with high local memory usage at the cost of potentially
      increased memory usage.   Deprecated: This flag is deprecated and the
      behavior enabled by this flag is now the default and cannot be
      disabled.

    - :py:obj:`~.CU_CTX_COREDUMP_ENABLE`: If GPU coredumps have not been
      enabled globally with :py:obj:`~.cuCoredumpSetAttributeGlobal` or
      environment variables, this flag can be set during context creation
      to instruct CUDA to create a coredump if this context raises an
      exception during execution. These environment variables are described
      in the CUDA-GDB user guide under the "GPU core dump support" section.
      The initial settings will be taken from the global settings at the
      time of context creation. The other settings that control coredump
      output can be modified by calling :py:obj:`~.cuCoredumpSetAttribute`
      from the created context after it becomes current.

    - :py:obj:`~.CU_CTX_USER_COREDUMP_ENABLE`: If user-triggered GPU
      coredumps have not been enabled globally with
      :py:obj:`~.cuCoredumpSetAttributeGlobal` or environment variables,
      this flag can be set during context creation to instruct CUDA to
      create a coredump if data is written to a certain pipe that is
      present in the OS space. These environment variables are described in
      the CUDA-GDB user guide under the "GPU core dump support" section. It
      is important to note that the pipe name `must` be set with
      :py:obj:`~.cuCoredumpSetAttributeGlobal` before creating the context
      if this flag is used. Setting this flag implies that
      :py:obj:`~.CU_CTX_COREDUMP_ENABLE` is set. The initial settings will
      be taken from the global settings at the time of context creation.
      The other settings that control coredump output can be modified by
      calling :py:obj:`~.cuCoredumpSetAttribute` from the created context
      after it becomes current.

    - :py:obj:`~.CU_CTX_SYNC_MEMOPS`: Ensures that synchronous memory
      operations initiated on this context will always synchronize. See
      further documentation in the section titled "API Synchronization
      behavior" to learn more about cases when synchronous memory
      operations can exhibit asynchronous behavior.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device for which the primary context flags are set
    flags : unsigned int
        New flags for the device

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,

    See Also
    --------
    :py:obj:`~.cuDevicePrimaryCtxRetain`, :py:obj:`~.cuDevicePrimaryCtxGetState`, :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxSetFlags`, :py:obj:`~.cudaSetDeviceFlags`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    with nogil:
        err = cydriver.cuDevicePrimaryCtxSetFlags(cydev, flags)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDevicePrimaryCtxGetState(dev):
    """ Get the state of the primary context.

    Returns in `*flags` the flags for the primary context of `dev`, and in
    `*active` whether it is active. See
    :py:obj:`~.cuDevicePrimaryCtxSetFlags` for flag values.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device to get primary context flags for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    flags : unsigned int
        Pointer to store flags
    active : int
        Pointer to store context state; 0 = inactive, 1 = active

    See Also
    --------
    :py:obj:`~.cuDevicePrimaryCtxSetFlags`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxSetFlags`, :py:obj:`~.cudaGetDeviceFlags`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef unsigned int flags = 0
    cdef int active = 0
    with nogil:
        err = cydriver.cuDevicePrimaryCtxGetState(cydev, &flags, &active)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], flags, active)

@cython.embedsignature(True)
def cuDevicePrimaryCtxReset(dev):
    """ Destroy all allocations and reset all state on the primary context.

    Explicitly destroys and cleans up all resources associated with the
    current device in the current process.

    Note that it is responsibility of the calling function to ensure that
    no other module in the process is using the device any more. For that
    reason it is recommended to use :py:obj:`~.cuDevicePrimaryCtxRelease()`
    in most cases. However it is safe for other modules to call
    :py:obj:`~.cuDevicePrimaryCtxRelease()` even after resetting the
    device. Resetting the primary context does not release it, an
    application that has retained the primary context should explicitly
    release its usage.

    Parameters
    ----------
    dev : :py:obj:`~.CUdevice`
        Device for which primary context is destroyed

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE`

    See Also
    --------
    :py:obj:`~.cuDevicePrimaryCtxRetain`, :py:obj:`~.cuDevicePrimaryCtxRelease`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cudaDeviceReset`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    with nogil:
        err = cydriver.cuDevicePrimaryCtxReset(cydev)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxCreate(ctxCreateParams : Optional[CUctxCreateParams], unsigned int flags, dev):
    """ Create a CUDA context.

    Creates a new CUDA context and associates it with the calling thread.
    The `flags` parameter is described below. The context is created with a
    usage count of 1 and the caller of :py:obj:`~.cuCtxCreate()` must call
    :py:obj:`~.cuCtxDestroy()` when done using the context. If a context is
    already current to the thread, it is supplanted by the newly created
    context and may be restored by a subsequent call to
    :py:obj:`~.cuCtxPopCurrent()`.

    CUDA context can be created with execution affinity. The type and the
    amount of execution resource the context can use is limited by
    `paramsArray` and `numExecAffinityParams` in `execAffinity`. The
    `paramsArray` is an array of `CUexecAffinityParam` and the
    `numExecAffinityParams` describes the size of the paramsArray. If two
    `CUexecAffinityParam` in the array have the same type, the latter
    execution affinity parameter overrides the former execution affinity
    parameter. The supported execution affinity types are:

    - :py:obj:`~.CU_EXEC_AFFINITY_TYPE_SM_COUNT` limits the portion of SMs
      that the context can use. The portion of SMs is specified as the
      number of SMs via `CUexecAffinitySmCount`. This limit will be
      internally rounded up to the next hardware-supported amount. Hence,
      it is imperative to query the actual execution affinity of the
      context via `cuCtxGetExecAffinity` after context creation. Currently,
      this attribute is only supported under Volta+ MPS.

    CUDA context can be created in CIG(CUDA in Graphics) mode by setting
    `cigParams`. Data from graphics client is shared with CUDA via the
    `sharedData` in `cigParams`. Support for D3D12 graphics client can be
    determined using :py:obj:`~.cuDeviceGetAttribute()` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_D3D12_CIG_SUPPORTED`. `sharedData` is a
    ID3D12CommandQueue handle. Support for Vulkan graphics client can be
    determined using :py:obj:`~.cuDeviceGetAttribute()` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_VULKAN_CIG_SUPPORTED`. `sharedData` is a
    Nvidia specific data blob populated by calling
    vkGetExternalComputeQueueDataNV(). Either `execAffinityParams` or
    `cigParams` can be set to a non-null value. Setting both to a non-null
    value will result in an undefined behavior.

    The three LSBs of the `flags` parameter can be used to control how the
    OS thread, which owns the CUDA context at the time of an API call,
    interacts with the OS scheduler when waiting for results from the GPU.
    Only one of the scheduling flags can be set when creating a context.

    - :py:obj:`~.CU_CTX_SCHED_SPIN`: Instruct CUDA to actively spin when
      waiting for results from the GPU. This can decrease latency when
      waiting for the GPU, but may lower the performance of CPU threads if
      they are performing work in parallel with the CUDA thread.

    - :py:obj:`~.CU_CTX_SCHED_YIELD`: Instruct CUDA to yield its thread
      when waiting for results from the GPU. This can increase latency when
      waiting for the GPU, but can increase the performance of CPU threads
      performing work in parallel with the GPU.

    - :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC`: Instruct CUDA to block the
      CPU thread on a synchronization primitive when waiting for the GPU to
      finish work.

    - :py:obj:`~.CU_CTX_BLOCKING_SYNC`: Instruct CUDA to block the CPU
      thread on a synchronization primitive when waiting for the GPU to
      finish work.   Deprecated: This flag was deprecated as of CUDA 4.0
      and was replaced with :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC`.

    - :py:obj:`~.CU_CTX_SCHED_AUTO`: The default value if the `flags`
      parameter is zero, uses a heuristic based on the number of active
      CUDA contexts in the process `C` and the number of logical processors
      in the system `P`. If `C` > `P`, then CUDA will yield to other OS
      threads when waiting for the GPU (:py:obj:`~.CU_CTX_SCHED_YIELD`),
      otherwise CUDA will not yield while waiting for results and actively
      spin on the processor (:py:obj:`~.CU_CTX_SCHED_SPIN`). Additionally,
      on Tegra devices, :py:obj:`~.CU_CTX_SCHED_AUTO` uses a heuristic
      based on the power profile of the platform and may choose
      :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC` for low-powered devices.

    - :py:obj:`~.CU_CTX_MAP_HOST`: Instruct CUDA to support mapped pinned
      allocations. This flag must be set in order to allocate pinned host
      memory that is accessible to the GPU.

    - :py:obj:`~.CU_CTX_LMEM_RESIZE_TO_MAX`: Instruct CUDA to not reduce
      local memory after resizing local memory for a kernel. This can
      prevent thrashing by local memory allocations when launching many
      kernels with high local memory usage at the cost of potentially
      increased memory usage.   Deprecated: This flag is deprecated and the
      behavior enabled by this flag is now the default and cannot be
      disabled. Instead, the per-thread stack size can be controlled with
      :py:obj:`~.cuCtxSetLimit()`.

    - :py:obj:`~.CU_CTX_COREDUMP_ENABLE`: If GPU coredumps have not been
      enabled globally with :py:obj:`~.cuCoredumpSetAttributeGlobal` or
      environment variables, this flag can be set during context creation
      to instruct CUDA to create a coredump if this context raises an
      exception during execution. These environment variables are described
      in the CUDA-GDB user guide under the "GPU core dump support" section.
      The initial attributes will be taken from the global attributes at
      the time of context creation. The other attributes that control
      coredump output can be modified by calling
      :py:obj:`~.cuCoredumpSetAttribute` from the created context after it
      becomes current. This flag is not supported when CUDA context is
      created in CIG(CUDA in Graphics) mode.

    - :py:obj:`~.CU_CTX_USER_COREDUMP_ENABLE`: If user-triggered GPU
      coredumps have not been enabled globally with
      :py:obj:`~.cuCoredumpSetAttributeGlobal` or environment variables,
      this flag can be set during context creation to instruct CUDA to
      create a coredump if data is written to a certain pipe that is
      present in the OS space. These environment variables are described in
      the CUDA-GDB user guide under the "GPU core dump support" section. It
      is important to note that the pipe name `must` be set with
      :py:obj:`~.cuCoredumpSetAttributeGlobal` before creating the context
      if this flag is used. Setting this flag implies that
      :py:obj:`~.CU_CTX_COREDUMP_ENABLE` is set. The initial attributes
      will be taken from the global attributes at the time of context
      creation. The other attributes that control coredump output can be
      modified by calling :py:obj:`~.cuCoredumpSetAttribute` from the
      created context after it becomes current. Setting this flag on any
      context creation is equivalent to setting the
      :py:obj:`~.CU_COREDUMP_ENABLE_USER_TRIGGER` attribute to `true`
      globally. This flag is not supported when CUDA context is created in
      CIG(CUDA in Graphics) mode.

    - :py:obj:`~.CU_CTX_SYNC_MEMOPS`: Ensures that synchronous memory
      operations initiated on this context will always synchronize. See
      further documentation in the section titled "API Synchronization
      behavior" to learn more about cases when synchronous memory
      operations can exhibit asynchronous behavior.

    Context creation will fail with :py:obj:`~.CUDA_ERROR_UNKNOWN` if the
    compute mode of the device is :py:obj:`~.CU_COMPUTEMODE_PROHIBITED`.
    The function :py:obj:`~.cuDeviceGetAttribute()` can be used with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_COMPUTE_MODE` to determine the compute
    mode of the device. The `nvidia-smi` tool can be used to set the
    compute mode for * devices. Documentation for `nvidia-smi` can be
    obtained by passing a -h option to it.

    Context creation will fail with :: CUDA_ERROR_INVALID_VALUE if invalid
    parameter was passed by client to create the CUDA context.

    Context creation in CIG mode will fail with
    :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED` if CIG is not supported by the
    device or the driver.

    Parameters
    ----------
    ctxCreateParams : :py:obj:`~.CUctxCreateParams`
        Context creation parameters
    flags : unsigned int
        Context creation flags
    dev : :py:obj:`~.CUdevice`
        Device to create context on

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_UNKNOWN`
    pctx : :py:obj:`~.CUcontext`
        Returned context handle of the new context

    See Also
    --------
    :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCoredumpSetAttributeGlobal`, :py:obj:`~.cuCoredumpSetAttribute`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef CUcontext pctx = CUcontext()
    cdef cydriver.CUctxCreateParams* cyctxCreateParams_ptr = ctxCreateParams._pvt_ptr if ctxCreateParams is not None else NULL
    with nogil:
        err = cydriver.cuCtxCreate(<cydriver.CUcontext*>pctx._pvt_ptr, cyctxCreateParams_ptr, flags, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pctx)

@cython.embedsignature(True)
def cuCtxDestroy(ctx):
    """ Destroy a CUDA context.

    Destroys the CUDA context specified by `ctx`. The context `ctx` will be
    destroyed regardless of how many threads it is current to. It is the
    responsibility of the calling function to ensure that no API call
    issues using `ctx` while :py:obj:`~.cuCtxDestroy()` is executing.

    Destroys and cleans up all resources associated with the context. It is
    the caller's responsibility to ensure that the context or its resources
    are not accessed or passed in subsequent API calls and doing so will
    result in undefined behavior. These resources include CUDA types
    :py:obj:`~.CUmodule`, :py:obj:`~.CUfunction`, :py:obj:`~.CUstream`,
    :py:obj:`~.CUevent`, :py:obj:`~.CUarray`, :py:obj:`~.CUmipmappedArray`,
    :py:obj:`~.CUtexObject`, :py:obj:`~.CUsurfObject`,
    :py:obj:`~.CUtexref`, :py:obj:`~.CUsurfref`,
    :py:obj:`~.CUgraphicsResource`, :py:obj:`~.CUlinkState`,
    :py:obj:`~.CUexternalMemory` and :py:obj:`~.CUexternalSemaphore`. These
    resources also include memory allocations by :py:obj:`~.cuMemAlloc()`,
    :py:obj:`~.cuMemAllocHost()`, :py:obj:`~.cuMemAllocManaged()` and
    :py:obj:`~.cuMemAllocPitch()`.

    If `ctx` is current to the calling thread then `ctx` will also be
    popped from the current thread's context stack (as though
    :py:obj:`~.cuCtxPopCurrent()` were called). If `ctx` is current to
    other threads, then `ctx` will remain current to those threads, and
    attempting to access `ctx` from those threads will result in the error
    :py:obj:`~.CUDA_ERROR_CONTEXT_IS_DESTROYED`.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context to destroy

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`

    Notes
    -----
    :py:obj:`~.cuCtxDestroy()` will not destroy memory allocations by :py:obj:`~.cuMemCreate()`, :py:obj:`~.cuMemAllocAsync()` and :py:obj:`~.cuMemAllocFromPoolAsync()`. These memory allocations are not associated with any CUDA context and need to be destroyed explicitly.
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    with nogil:
        err = cydriver.cuCtxDestroy(cyctx)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxPushCurrent(ctx):
    """ Pushes a context on the current CPU thread.

    Pushes the given context `ctx` onto the CPU thread's stack of current
    contexts. The specified context becomes the CPU thread's current
    context, so all CUDA functions that operate on the current context are
    affected.

    The previous current context may be made current again by calling
    :py:obj:`~.cuCtxDestroy()` or :py:obj:`~.cuCtxPopCurrent()`.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context to push

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    with nogil:
        err = cydriver.cuCtxPushCurrent(cyctx)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxPopCurrent():
    """ Pops the current CUDA context from the current CPU thread.

    Pops the current CUDA context from the CPU thread and passes back the
    old context handle in `*pctx`. That context may then be made current to
    a different CPU thread by calling :py:obj:`~.cuCtxPushCurrent()`.

    If a context was current to the CPU thread before
    :py:obj:`~.cuCtxCreate()` or :py:obj:`~.cuCtxPushCurrent()` was called,
    this function makes that context current to the CPU thread again.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`
    pctx : :py:obj:`~.CUcontext`
        Returned popped context handle

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef CUcontext pctx = CUcontext()
    with nogil:
        err = cydriver.cuCtxPopCurrent(<cydriver.CUcontext*>pctx._pvt_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pctx)

@cython.embedsignature(True)
def cuCtxSetCurrent(ctx):
    """ Binds the specified CUDA context to the calling CPU thread.

    Binds the specified CUDA context to the calling CPU thread. If `ctx` is
    NULL then the CUDA context previously bound to the calling CPU thread
    is unbound and :py:obj:`~.CUDA_SUCCESS` is returned.

    If there exists a CUDA context stack on the calling CPU thread, this
    will replace the top of that stack with `ctx`. If `ctx` is NULL then
    this will be equivalent to popping the top of the calling CPU thread's
    CUDA context stack (or a no-op if the calling CPU thread's CUDA context
    stack is empty).

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context to bind to the calling CPU thread

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`

    See Also
    --------
    :py:obj:`~.cuCtxGetCurrent`, :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cudaSetDevice`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    with nogil:
        err = cydriver.cuCtxSetCurrent(cyctx)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxGetCurrent():
    """ Returns the CUDA context bound to the calling CPU thread.

    Returns in `*pctx` the CUDA context bound to the calling CPU thread. If
    no context is bound to the calling CPU thread then `*pctx` is set to
    NULL and :py:obj:`~.CUDA_SUCCESS` is returned.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`,
    pctx : :py:obj:`~.CUcontext`
        Returned context handle

    See Also
    --------
    :py:obj:`~.cuCtxSetCurrent`, :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cudaGetDevice`
    """
    cdef CUcontext pctx = CUcontext()
    with nogil:
        err = cydriver.cuCtxGetCurrent(<cydriver.CUcontext*>pctx._pvt_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pctx)

@cython.embedsignature(True)
def cuCtxGetDevice():
    """ Returns the device handle for the current context.

    Returns in `*device` the handle of the current context's device.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    device : :py:obj:`~.CUdevice`
        Returned device handle for the current context

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cudaGetDevice`
    """
    cdef CUdevice device = CUdevice()
    with nogil:
        err = cydriver.cuCtxGetDevice(<cydriver.CUdevice*>device._pvt_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], device)

@cython.embedsignature(True)
def cuCtxGetDevice_v2(ctx):
    """ Returns the device handle for the specified context.

    Returns in `*device` the handle of the specified context's device. If
    the specified context is NULL, the API will return the current
    context's device.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context for which to obtain the device

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    device : :py:obj:`~.CUdevice`
        Returned device handle for the specified context

    See Also
    --------
    :py:obj:`~.cuCtxGetCurrent`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    cdef CUdevice device = CUdevice()
    with nogil:
        err = cydriver.cuCtxGetDevice_v2(<cydriver.CUdevice*>device._pvt_ptr, cyctx)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], device)

@cython.embedsignature(True)
def cuCtxGetFlags():
    """ Returns the flags for the current context.

    Returns in `*flags` the flags of the current context. See
    :py:obj:`~.cuCtxCreate` for flag values.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    flags : unsigned int
        Pointer to store flags of current context

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetCurrent`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxGetSharedMemConfig`, :py:obj:`~.cuCtxGetStreamPriorityRange`, :py:obj:`~.cuCtxSetFlags`, :py:obj:`~.cudaGetDeviceFlags`
    """
    cdef unsigned int flags = 0
    with nogil:
        err = cydriver.cuCtxGetFlags(&flags)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], flags)

@cython.embedsignature(True)
def cuCtxSetFlags(unsigned int flags):
    """ Sets the flags for the current context.

    Sets the flags for the current context overwriting previously set ones.
    See :py:obj:`~.cuDevicePrimaryCtxSetFlags` for flag values.

    Parameters
    ----------
    flags : unsigned int
        Flags to set on the current context

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetCurrent`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxGetSharedMemConfig`, :py:obj:`~.cuCtxGetStreamPriorityRange`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cudaGetDeviceFlags`, :py:obj:`~.cuDevicePrimaryCtxSetFlags`,
    """
    with nogil:
        err = cydriver.cuCtxSetFlags(flags)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxGetId(ctx):
    """ Returns the unique Id associated with the context supplied.

    Returns in `ctxId` the unique Id which is associated with a given
    context. The Id is unique for the life of the program for this instance
    of CUDA. If context is supplied as NULL and there is one current, the
    Id of the current context is returned.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context for which to obtain the Id

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_CONTEXT_IS_DESTROYED`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    ctxId : unsigned long long
        Pointer to store the Id of the context

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPushCurrent`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    cdef unsigned long long ctxId = 0
    with nogil:
        err = cydriver.cuCtxGetId(cyctx, &ctxId)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], ctxId)

@cython.embedsignature(True)
def cuCtxSynchronize():
    """ Block for the current context's tasks to complete.

    Blocks until the current context has completed all preceding requested
    tasks. If the current context is the primary context, green contexts
    that have been created will also be synchronized.
    :py:obj:`~.cuCtxSynchronize()` returns an error if one of the preceding
    tasks failed. If the context was created with the
    :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC` flag, the CPU thread will block
    until the GPU context has finished its work.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cudaDeviceSynchronize`
    """
    with nogil:
        err = cydriver.cuCtxSynchronize()
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxSynchronize_v2(ctx):
    """ Block for the specified context's tasks to complete.

    Blocks until the specified context has completed all preceding
    requested tasks. If the specified context is the primary context, green
    contexts that have been created will also be synchronized. The API
    returns an error if one of the preceding tasks failed.

    If the context was created with the
    :py:obj:`~.CU_CTX_SCHED_BLOCKING_SYNC` flag, the CPU thread will block
    until the GPU context has finished its work.

    If the specified context is NULL, the API will operate on the current
    context.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context to synchronize

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuCtxGetCurrent`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuGreenCtxCreate`, :py:obj:`~.cuCtxFromGreenCtx`, :py:obj:`~.cudaDeviceSynchronize`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    with nogil:
        err = cydriver.cuCtxSynchronize_v2(cyctx)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxSetLimit(limit not None : CUlimit, size_t value):
    """ Set resource limits.

    Setting `limit` to `value` is a request by the application to update
    the current limit maintained by the context. The driver is free to
    modify the requested value to meet h/w requirements (this could be
    clamping to minimum or maximum values, rounding up to nearest element
    size, etc). The application can use :py:obj:`~.cuCtxGetLimit()` to find
    out exactly what the limit has been set to.

    Setting each :py:obj:`~.CUlimit` has its own specific restrictions, so
    each is discussed here.

    - :py:obj:`~.CU_LIMIT_STACK_SIZE` controls the stack size in bytes of
      each GPU thread. The driver automatically increases the per-thread
      stack size for each kernel launch as needed. This size isn't reset
      back to the original value after each launch. Setting this value will
      take effect immediately, and if necessary, the device will block
      until all preceding requested tasks are complete.

    - :py:obj:`~.CU_LIMIT_PRINTF_FIFO_SIZE` controls the size in bytes of
      the FIFO used by the :py:obj:`~.printf()` device system call. Setting
      :py:obj:`~.CU_LIMIT_PRINTF_FIFO_SIZE` must be performed before
      launching any kernel that uses the :py:obj:`~.printf()` device system
      call, otherwise :py:obj:`~.CUDA_ERROR_INVALID_VALUE` will be
      returned.

    - :py:obj:`~.CU_LIMIT_MALLOC_HEAP_SIZE` controls the size in bytes of
      the heap used by the :py:obj:`~.malloc()` and :py:obj:`~.free()`
      device system calls. Setting :py:obj:`~.CU_LIMIT_MALLOC_HEAP_SIZE`
      must be performed before launching any kernel that uses the
      :py:obj:`~.malloc()` or :py:obj:`~.free()` device system calls,
      otherwise :py:obj:`~.CUDA_ERROR_INVALID_VALUE` will be returned.

    - :py:obj:`~.CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH` controls the maximum
      nesting depth of a grid at which a thread can safely call
      :py:obj:`~.cudaDeviceSynchronize()`. Setting this limit must be
      performed before any launch of a kernel that uses the device runtime
      and calls :py:obj:`~.cudaDeviceSynchronize()` above the default sync
      depth, two levels of grids. Calls to
      :py:obj:`~.cudaDeviceSynchronize()` will fail with error code
      :py:obj:`~.cudaErrorSyncDepthExceeded` if the limitation is violated.
      This limit can be set smaller than the default or up the maximum
      launch depth of 24. When setting this limit, keep in mind that
      additional levels of sync depth require the driver to reserve large
      amounts of device memory which can no longer be used for user
      allocations. If these reservations of device memory fail,
      :py:obj:`~.cuCtxSetLimit()` will return
      :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, and the limit can be reset to a
      lower value. This limit is only applicable to devices of compute
      capability < 9.0. Attempting to set this limit on devices of other
      compute capability versions will result in the error
      :py:obj:`~.CUDA_ERROR_UNSUPPORTED_LIMIT` being returned.

    - :py:obj:`~.CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT` controls the
      maximum number of outstanding device runtime launches that can be
      made from the current context. A grid is outstanding from the point
      of launch up until the grid is known to have been completed. Device
      runtime launches which violate this limitation fail and return
      :py:obj:`~.cudaErrorLaunchPendingCountExceeded` when
      :py:obj:`~.cudaGetLastError()` is called after launch. If more
      pending launches than the default (2048 launches) are needed for a
      module using the device runtime, this limit can be increased. Keep in
      mind that being able to sustain additional pending launches will
      require the driver to reserve larger amounts of device memory upfront
      which can no longer be used for allocations. If these reservations
      fail, :py:obj:`~.cuCtxSetLimit()` will return
      :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, and the limit can be reset to a
      lower value. This limit is only applicable to devices of compute
      capability 3.5 and higher. Attempting to set this limit on devices of
      compute capability less than 3.5 will result in the error
      :py:obj:`~.CUDA_ERROR_UNSUPPORTED_LIMIT` being returned.

    - :py:obj:`~.CU_LIMIT_MAX_L2_FETCH_GRANULARITY` controls the L2 cache
      fetch granularity. Values can range from 0B to 128B. This is purely a
      performance hint and it can be ignored or clamped depending on the
      platform.

    - :py:obj:`~.CU_LIMIT_PERSISTING_L2_CACHE_SIZE` controls size in bytes
      available for persisting L2 cache. This is purely a performance hint
      and it can be ignored or clamped depending on the platform.

    Parameters
    ----------
    limit : :py:obj:`~.CUlimit`
        Limit to set
    value : size_t
        Size of limit

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_LIMIT`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cudaDeviceSetLimit`
    """
    cdef cydriver.CUlimit cylimit = limit.value
    with nogil:
        err = cydriver.cuCtxSetLimit(cylimit, value)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxGetLimit(limit not None : CUlimit):
    """ Returns resource limits.

    Returns in `*pvalue` the current size of `limit`. The supported
    :py:obj:`~.CUlimit` values are:

    - :py:obj:`~.CU_LIMIT_STACK_SIZE`: stack size in bytes of each GPU
      thread.

    - :py:obj:`~.CU_LIMIT_PRINTF_FIFO_SIZE`: size in bytes of the FIFO used
      by the :py:obj:`~.printf()` device system call.

    - :py:obj:`~.CU_LIMIT_MALLOC_HEAP_SIZE`: size in bytes of the heap used
      by the :py:obj:`~.malloc()` and :py:obj:`~.free()` device system
      calls.

    - :py:obj:`~.CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH`: maximum grid depth at
      which a thread can issue the device runtime call
      :py:obj:`~.cudaDeviceSynchronize()` to wait on child grid launches to
      complete.

    - :py:obj:`~.CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT`: maximum number
      of outstanding device runtime launches that can be made from this
      context.

    - :py:obj:`~.CU_LIMIT_MAX_L2_FETCH_GRANULARITY`: L2 cache fetch
      granularity.

    - :py:obj:`~.CU_LIMIT_PERSISTING_L2_CACHE_SIZE`: Persisting L2 cache
      size in bytes

    Parameters
    ----------
    limit : :py:obj:`~.CUlimit`
        Limit to query

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_LIMIT`
    pvalue : int
        Returned size of limit

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cudaDeviceGetLimit`
    """
    cdef size_t pvalue = 0
    cdef cydriver.CUlimit cylimit = limit.value
    with nogil:
        err = cydriver.cuCtxGetLimit(&pvalue, cylimit)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pvalue)

@cython.embedsignature(True)
def cuCtxGetCacheConfig():
    """ Returns the preferred cache configuration for the current context.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this function returns through `pconfig` the preferred cache
    configuration for the current context. This is only a preference. The
    driver will use the requested configuration if possible, but it is free
    to choose a different configuration if required to execute functions.

    This will return a `pconfig` of :py:obj:`~.CU_FUNC_CACHE_PREFER_NONE`
    on devices where the size of the L1 cache and shared memory are fixed.

    The supported cache configurations are:

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_NONE`: no preference for shared
      memory or L1 (default)

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_SHARED`: prefer larger shared memory
      and smaller L1 cache

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_L1`: prefer larger L1 cache and
      smaller shared memory

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_EQUAL`: prefer equal sized L1 cache
      and shared memory

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pconfig : :py:obj:`~.CUfunc_cache`
        Returned cache configuration

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cuFuncSetCacheConfig`, :py:obj:`~.cudaDeviceGetCacheConfig`
    """
    cdef cydriver.CUfunc_cache pconfig
    with nogil:
        err = cydriver.cuCtxGetCacheConfig(&pconfig)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], CUfunc_cache(pconfig))

@cython.embedsignature(True)
def cuCtxSetCacheConfig(config not None : CUfunc_cache):
    """ Sets the preferred cache configuration for the current context.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this sets through `config` the preferred cache configuration
    for the current context. This is only a preference. The driver will use
    the requested configuration if possible, but it is free to choose a
    different configuration if required to execute the function. Any
    function preference set via :py:obj:`~.cuFuncSetCacheConfig()` or
    :py:obj:`~.cuKernelSetCacheConfig()` will be preferred over this
    context-wide setting. Setting the context-wide cache configuration to
    :py:obj:`~.CU_FUNC_CACHE_PREFER_NONE` will cause subsequent kernel
    launches to prefer to not change the cache configuration unless
    required to launch the kernel.

    This setting does nothing on devices where the size of the L1 cache and
    shared memory are fixed.

    Launching a kernel with a different preference than the most recent
    preference setting may insert a device-side synchronization point.

    The supported cache configurations are:

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_NONE`: no preference for shared
      memory or L1 (default)

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_SHARED`: prefer larger shared memory
      and smaller L1 cache

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_L1`: prefer larger L1 cache and
      smaller shared memory

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_EQUAL`: prefer equal sized L1 cache
      and shared memory

    Parameters
    ----------
    config : :py:obj:`~.CUfunc_cache`
        Requested cache configuration

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cuFuncSetCacheConfig`, :py:obj:`~.cudaDeviceSetCacheConfig`, :py:obj:`~.cuKernelSetCacheConfig`
    """
    cdef cydriver.CUfunc_cache cyconfig = config.value
    with nogil:
        err = cydriver.cuCtxSetCacheConfig(cyconfig)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxGetApiVersion(ctx):
    """ Gets the context's API version.

    Returns a version number in `version` corresponding to the capabilities
    of the context (e.g. 3010 or 3020), which library developers can use to
    direct callers to a specific API version. If `ctx` is NULL, returns the
    API version used to create the currently bound context.

    Note that new API versions are only introduced when context
    capabilities are changed that break binary compatibility, so the API
    version and driver version may be different. For example, it is valid
    for the API version to be 3020 while the driver version is 4020.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context to check

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_UNKNOWN`
    version : unsigned int
        Pointer to version

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    cdef unsigned int version = 0
    with nogil:
        err = cydriver.cuCtxGetApiVersion(cyctx, &version)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], version)

@cython.embedsignature(True)
def cuCtxGetStreamPriorityRange():
    """ Returns numerical values that correspond to the least and greatest stream priorities.

    Returns in `*leastPriority` and `*greatestPriority` the numerical
    values that correspond to the least and greatest stream priorities
    respectively. Stream priorities follow a convention where lower numbers
    imply greater priorities. The range of meaningful stream priorities is
    given by [`*greatestPriority`, `*leastPriority`]. If the user attempts
    to create a stream with a priority value that is outside the meaningful
    range as specified by this API, the priority is automatically clamped
    down or up to either `*leastPriority` or `*greatestPriority`
    respectively. See :py:obj:`~.cuStreamCreateWithPriority` for details on
    creating a priority stream. A NULL may be passed in for
    `*leastPriority` or `*greatestPriority` if the value is not desired.

    This function will return '0' in both `*leastPriority` and
    `*greatestPriority` if the current context's device does not support
    stream priorities (see :py:obj:`~.cuDeviceGetAttribute`).

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    leastPriority : int
        Pointer to an int in which the numerical value for least stream
        priority is returned
    greatestPriority : int
        Pointer to an int in which the numerical value for greatest stream
        priority is returned

    See Also
    --------
    :py:obj:`~.cuStreamCreateWithPriority`, :py:obj:`~.cuStreamGetPriority`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cudaDeviceGetStreamPriorityRange`
    """
    cdef int leastPriority = 0
    cdef int greatestPriority = 0
    with nogil:
        err = cydriver.cuCtxGetStreamPriorityRange(&leastPriority, &greatestPriority)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], leastPriority, greatestPriority)

@cython.embedsignature(True)
def cuCtxResetPersistingL2Cache():
    """ Resets all persisting lines in cache to normal status.

    :py:obj:`~.cuCtxResetPersistingL2Cache` Resets all persisting lines in
    cache to normal status. Takes effect on function return.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`

    See Also
    --------
    :py:obj:`~.CUaccessPolicyWindow`
    """
    with nogil:
        err = cydriver.cuCtxResetPersistingL2Cache()
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxGetExecAffinity(typename not None : CUexecAffinityType):
    """ Returns the execution affinity setting for the current context.

    Returns in `*pExecAffinity` the current value of `typename`. The
    supported :py:obj:`~.CUexecAffinityType` values are:

    - :py:obj:`~.CU_EXEC_AFFINITY_TYPE_SM_COUNT`: number of SMs the context
      is limited to use.

    Parameters
    ----------
    typename : :py:obj:`~.CUexecAffinityType`
        Execution affinity type to query

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY`
    pExecAffinity : :py:obj:`~.CUexecAffinityParam`
        Returned execution affinity

    See Also
    --------
    :py:obj:`~.CUexecAffinityParam`
    """
    cdef CUexecAffinityParam pExecAffinity = CUexecAffinityParam()
    cdef cydriver.CUexecAffinityType cytypename = typename.value
    with nogil:
        err = cydriver.cuCtxGetExecAffinity(<cydriver.CUexecAffinityParam*>pExecAffinity._pvt_ptr, cytypename)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pExecAffinity)

@cython.embedsignature(True)
def cuCtxRecordEvent(hCtx, hEvent):
    """ Records an event.

    Captures in `hEvent` all the activities of the context `hCtx` at the
    time of this call. `hEvent` and `hCtx` must be from the same CUDA
    context, otherwise :py:obj:`~.CUDA_ERROR_INVALID_HANDLE` will be
    returned. Calls such as :py:obj:`~.cuEventQuery()` or
    :py:obj:`~.cuCtxWaitEvent()` will then examine or wait for completion
    of the work that was captured. Uses of `hCtx` after this call do not
    modify `hEvent`. If the context passed to `hCtx` is the primary
    context, `hEvent` will capture all the activities of the primary
    context and its green contexts. If the context passed to `hCtx` is a
    context converted from green context via
    :py:obj:`~.cuCtxFromGreenCtx()`, `hEvent` will capture only the
    activities of the green context.

    Parameters
    ----------
    hCtx : :py:obj:`~.CUcontext`
        Context to record event for
    hEvent : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to record

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED`

    See Also
    --------
    :py:obj:`~.cuCtxWaitEvent`, :py:obj:`~.cuGreenCtxRecordEvent`, :py:obj:`~.cuGreenCtxWaitEvent`, :py:obj:`~.cuEventRecord`

    Notes
    -----
    The API will return :py:obj:`~.CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED` if the specified context `hCtx` has a stream in the capture mode. In such a case, the call will invalidate all the conflicting captures.
    """
    cdef cydriver.CUevent cyhEvent
    if hEvent is None:
        phEvent = 0
    elif isinstance(hEvent, (CUevent,)):
        phEvent = int(hEvent)
    else:
        phEvent = int(CUevent(hEvent))
    cyhEvent = <cydriver.CUevent><void_ptr>phEvent
    cdef cydriver.CUcontext cyhCtx
    if hCtx is None:
        phCtx = 0
    elif isinstance(hCtx, (CUcontext,)):
        phCtx = int(hCtx)
    else:
        phCtx = int(CUcontext(hCtx))
    cyhCtx = <cydriver.CUcontext><void_ptr>phCtx
    with nogil:
        err = cydriver.cuCtxRecordEvent(cyhCtx, cyhEvent)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxWaitEvent(hCtx, hEvent):
    """ Make a context wait on an event.

    Makes all future work submitted to context `hCtx` wait for all work
    captured in `hEvent`. The synchronization will be performed on the
    device and will not block the calling CPU thread. See
    :py:obj:`~.cuCtxRecordEvent()` for details on what is captured by an
    event. If the context passed to `hCtx` is the primary context, the
    primary context and its green contexts will wait for `hEvent`. If the
    context passed to `hCtx` is a context converted from green context via
    :py:obj:`~.cuCtxFromGreenCtx()`, the green context will wait for
    `hEvent`.

    Parameters
    ----------
    hCtx : :py:obj:`~.CUcontext`
        Context to wait
    hEvent : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to wait on

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED`

    See Also
    --------
    :py:obj:`~.cuCtxRecordEvent`, :py:obj:`~.cuGreenCtxRecordEvent`, :py:obj:`~.cuGreenCtxWaitEvent`, :py:obj:`~.cuStreamWaitEvent`

    Notes
    -----
    `hEvent` may be from a different context or device than `hCtx`.

    The API will return :py:obj:`~.CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED` and invalidate the capture if the specified event `hEvent` is part of an ongoing capture sequence or if the specified context `hCtx` has a stream in the capture mode.
    """
    cdef cydriver.CUevent cyhEvent
    if hEvent is None:
        phEvent = 0
    elif isinstance(hEvent, (CUevent,)):
        phEvent = int(hEvent)
    else:
        phEvent = int(CUevent(hEvent))
    cyhEvent = <cydriver.CUevent><void_ptr>phEvent
    cdef cydriver.CUcontext cyhCtx
    if hCtx is None:
        phCtx = 0
    elif isinstance(hCtx, (CUcontext,)):
        phCtx = int(hCtx)
    else:
        phCtx = int(CUcontext(hCtx))
    cyhCtx = <cydriver.CUcontext><void_ptr>phCtx
    with nogil:
        err = cydriver.cuCtxWaitEvent(cyhCtx, cyhEvent)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxAttach(unsigned int flags):
    """ Increment a context's usage-count.

    [Deprecated]

    Note that this function is deprecated and should not be used.

    Increments the usage count of the context and passes back a context
    handle in `*pctx` that must be passed to :py:obj:`~.cuCtxDetach()` when
    the application is done with the context. :py:obj:`~.cuCtxAttach()`
    fails if there is no context current to the thread.

    Currently, the `flags` parameter must be 0.

    Parameters
    ----------
    flags : unsigned int
        Context attach flags (must be 0)

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pctx : :py:obj:`~.CUcontext`
        Returned context handle of the current context

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxDetach`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef CUcontext pctx = CUcontext()
    with nogil:
        err = cydriver.cuCtxAttach(<cydriver.CUcontext*>pctx._pvt_ptr, flags)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pctx)

@cython.embedsignature(True)
def cuCtxDetach(ctx):
    """ Decrement a context's usage-count.

    [Deprecated]

    Note that this function is deprecated and should not be used.

    Decrements the usage count of the context `ctx`, and destroys the
    context if the usage count goes to 0. The context must be a handle that
    was passed back by :py:obj:`~.cuCtxCreate()` or
    :py:obj:`~.cuCtxAttach()`, and must be current to the calling thread.

    Parameters
    ----------
    ctx : :py:obj:`~.CUcontext`
        Context to destroy

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`
    """
    cdef cydriver.CUcontext cyctx
    if ctx is None:
        pctx = 0
    elif isinstance(ctx, (CUcontext,)):
        pctx = int(ctx)
    else:
        pctx = int(CUcontext(ctx))
    cyctx = <cydriver.CUcontext><void_ptr>pctx
    with nogil:
        err = cydriver.cuCtxDetach(cyctx)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuCtxGetSharedMemConfig():
    """ Returns the current shared memory configuration for the current context.

    [Deprecated]

    This function will return in `pConfig` the current size of shared
    memory banks in the current context. On devices with configurable
    shared memory banks, :py:obj:`~.cuCtxSetSharedMemConfig` can be used to
    change this setting, so that all subsequent kernel launches will by
    default use the new bank size. When :py:obj:`~.cuCtxGetSharedMemConfig`
    is called on devices without configurable shared memory, it will return
    the fixed bank size of the hardware.

    The returned bank configurations can be either:

    - :py:obj:`~.CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE`: shared memory
      bank width is four bytes.

    - :py:obj:`~.CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE`: shared memory
      bank width will eight bytes.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pConfig : :py:obj:`~.CUsharedconfig`
        returned shared memory configuration

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cuCtxGetSharedMemConfig`, :py:obj:`~.cuFuncSetCacheConfig`, :py:obj:`~.cudaDeviceGetSharedMemConfig`
    """
    cdef cydriver.CUsharedconfig pConfig
    with nogil:
        err = cydriver.cuCtxGetSharedMemConfig(&pConfig)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], CUsharedconfig(pConfig))

@cython.embedsignature(True)
def cuCtxSetSharedMemConfig(config not None : CUsharedconfig):
    """ Sets the shared memory configuration for the current context.

    [Deprecated]

    On devices with configurable shared memory banks, this function will
    set the context's shared memory bank size which is used for subsequent
    kernel launches.

    Changed the shared memory configuration between launches may insert a
    device side synchronization point between those launches.

    Changing the shared memory bank size will not increase shared memory
    usage or affect occupancy of kernels, but may have major effects on
    performance. Larger bank sizes will allow for greater potential
    bandwidth to shared memory, but will change what kinds of accesses to
    shared memory will result in bank conflicts.

    This function will do nothing on devices with fixed shared memory bank
    size.

    The supported bank configurations are:

    - :py:obj:`~.CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE`: set bank width to
      the default initial setting (currently, four bytes).

    - :py:obj:`~.CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE`: set shared
      memory bank width to be natively four bytes.

    - :py:obj:`~.CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE`: set shared
      memory bank width to be natively eight bytes.

    Parameters
    ----------
    config : :py:obj:`~.CUsharedconfig`
        requested shared memory configuration

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuCtxCreate`, :py:obj:`~.cuCtxDestroy`, :py:obj:`~.cuCtxGetApiVersion`, :py:obj:`~.cuCtxGetCacheConfig`, :py:obj:`~.cuCtxGetDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuCtxGetLimit`, :py:obj:`~.cuCtxPopCurrent`, :py:obj:`~.cuCtxPushCurrent`, :py:obj:`~.cuCtxSetLimit`, :py:obj:`~.cuCtxSynchronize`, :py:obj:`~.cuCtxGetSharedMemConfig`, :py:obj:`~.cuFuncSetCacheConfig`, :py:obj:`~.cudaDeviceSetSharedMemConfig`
    """
    cdef cydriver.CUsharedconfig cyconfig = config.value
    with nogil:
        err = cydriver.cuCtxSetSharedMemConfig(cyconfig)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuModuleLoad(char* fname):
    """ Loads a compute module.

    Takes a filename `fname` and loads the corresponding module `module`
    into the current context. The CUDA driver API does not attempt to
    lazily allocate the resources needed by a module; if the memory for
    functions and data (constant and global) needed by the module cannot be
    allocated, :py:obj:`~.cuModuleLoad()` fails. The file should be a
    `cubin` file as output by nvcc, or a `PTX` file either as output by
    nvcc or handwritten, or a `fatbin` file as output by nvcc from
    toolchain 4.0 or later.

    Parameters
    ----------
    fname : bytes
        Filename of module to load

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_FILE_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`
    module : :py:obj:`~.CUmodule`
        Returned module

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`
    """
    cdef CUmodule module = CUmodule()
    with nogil:
        err = cydriver.cuModuleLoad(<cydriver.CUmodule*>module._pvt_ptr, fname)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], module)

@cython.embedsignature(True)
def cuModuleLoadData(image):
    """ Load a module's data.

    Takes a pointer `image` and loads the corresponding module `module`
    into the current context. The `image` may be a `cubin` or `fatbin` as
    output by nvcc, or a NULL-terminated `PTX`, either as output by nvcc or
    hand-written.

    Parameters
    ----------
    image : Any
        Module data to load

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`
    module : :py:obj:`~.CUmodule`
        Returned module

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`
    """
    cdef CUmodule module = CUmodule()
    cyimage = _HelperInputVoidPtr(image)
    cdef void* cyimage_ptr = <void*><void_ptr>cyimage.cptr
    with nogil:
        err = cydriver.cuModuleLoadData(<cydriver.CUmodule*>module._pvt_ptr, cyimage_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], module)

@cython.embedsignature(True)
def cuModuleLoadDataEx(image, unsigned int numOptions, options : Optional[tuple[CUjit_option] | list[CUjit_option]], optionValues : Optional[tuple[Any] | list[Any]]):
    """ Load a module's data with options.

    Takes a pointer `image` and loads the corresponding module `module`
    into the current context. The `image` may be a `cubin` or `fatbin` as
    output by nvcc, or a NULL-terminated `PTX`, either as output by nvcc or
    hand-written.

    Parameters
    ----------
    image : Any
        Module data to load
    numOptions : unsigned int
        Number of options
    options : list[:py:obj:`~.CUjit_option`]
        Options for JIT
    optionValues : list[Any]
        Option values for JIT

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`
    module : :py:obj:`~.CUmodule`
        Returned module

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`
    """
    optionValues = [] if optionValues is None else optionValues
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected tuple[cydriver.CUjit_option] or list[cydriver.CUjit_option]")
    cdef CUmodule module = CUmodule()
    cyimage = _HelperInputVoidPtr(image)
    cdef void* cyimage_ptr = <void*><void_ptr>cyimage.cptr
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[cydriver.CUjit_option] cyoptions = [pyoptions.value for pyoptions in (options)]
    pylist = [_HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperoptionValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cyoptionValues_ptr = <void**><void_ptr>voidStarHelperoptionValues.cptr
    with nogil:
        err = cydriver.cuModuleLoadDataEx(<cydriver.CUmodule*>module._pvt_ptr, cyimage_ptr, numOptions, cyoptions.data(), cyoptionValues_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], module)

@cython.embedsignature(True)
def cuModuleLoadFatBinary(fatCubin):
    """ Load a module's data.

    Takes a pointer `fatCubin` and loads the corresponding module `module`
    into the current context. The pointer represents a `fat binary` object,
    which is a collection of different `cubin` and/or `PTX` files, all
    representing the same device code, but compiled and optimized for
    different architectures.

    Prior to CUDA 4.0, there was no documented API for constructing and
    using fat binary objects by programmers. Starting with CUDA 4.0, fat
    binary objects can be constructed by providing the `-fatbin option` to
    nvcc. More information can be found in the nvcc document.

    Parameters
    ----------
    fatCubin : Any
        Fat binary to load

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`
    module : :py:obj:`~.CUmodule`
        Returned module

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleUnload`
    """
    cdef CUmodule module = CUmodule()
    cyfatCubin = _HelperInputVoidPtr(fatCubin)
    cdef void* cyfatCubin_ptr = <void*><void_ptr>cyfatCubin.cptr
    with nogil:
        err = cydriver.cuModuleLoadFatBinary(<cydriver.CUmodule*>module._pvt_ptr, cyfatCubin_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], module)

@cython.embedsignature(True)
def cuModuleUnload(hmod):
    """ Unloads a module.

    Unloads a module `hmod` from the current context. Attempting to unload
    a module which was obtained from the Library Management API such as
    :py:obj:`~.cuLibraryGetModule` will return
    :py:obj:`~.CUDA_ERROR_NOT_PERMITTED`.

    Parameters
    ----------
    hmod : :py:obj:`~.CUmodule`
        Module to unload

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_PERMITTED`

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`
    """
    cdef cydriver.CUmodule cyhmod
    if hmod is None:
        phmod = 0
    elif isinstance(hmod, (CUmodule,)):
        phmod = int(hmod)
    else:
        phmod = int(CUmodule(hmod))
    cyhmod = <cydriver.CUmodule><void_ptr>phmod
    with nogil:
        err = cydriver.cuModuleUnload(cyhmod)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuModuleGetLoadingMode():
    """ Query lazy loading mode.

    Returns lazy loading mode Module loading mode is controlled by
    CUDA_MODULE_LOADING env variable

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    mode : :py:obj:`~.CUmoduleLoadingMode`
        Returns the lazy loading mode

    See Also
    --------
    :py:obj:`~.cuModuleLoad`,
    """
    cdef cydriver.CUmoduleLoadingMode mode
    with nogil:
        err = cydriver.cuModuleGetLoadingMode(&mode)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], CUmoduleLoadingMode(mode))

@cython.embedsignature(True)
def cuModuleGetFunction(hmod, char* name):
    """ Returns a function handle.

    Returns in `*hfunc` the handle of the function of name `name` located
    in module `hmod`. If no function of that name exists,
    :py:obj:`~.cuModuleGetFunction()` returns
    :py:obj:`~.CUDA_ERROR_NOT_FOUND`.

    Parameters
    ----------
    hmod : :py:obj:`~.CUmodule`
        Module to retrieve function from
    name : bytes
        Name of function to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    hfunc : :py:obj:`~.CUfunction`
        Returned function handle

    See Also
    --------
    :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`
    """
    cdef cydriver.CUmodule cyhmod
    if hmod is None:
        phmod = 0
    elif isinstance(hmod, (CUmodule,)):
        phmod = int(hmod)
    else:
        phmod = int(CUmodule(hmod))
    cyhmod = <cydriver.CUmodule><void_ptr>phmod
    cdef CUfunction hfunc = CUfunction()
    with nogil:
        err = cydriver.cuModuleGetFunction(<cydriver.CUfunction*>hfunc._pvt_ptr, cyhmod, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], hfunc)

@cython.embedsignature(True)
def cuModuleGetFunctionCount(mod):
    """ Returns the number of functions within a module.

    Returns in `count` the number of functions in `mod`.

    Parameters
    ----------
    mod : :py:obj:`~.CUmodule`
        Module to query

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    count : unsigned int
        Number of functions found within the module
    """
    cdef cydriver.CUmodule cymod
    if mod is None:
        pmod = 0
    elif isinstance(mod, (CUmodule,)):
        pmod = int(mod)
    else:
        pmod = int(CUmodule(mod))
    cymod = <cydriver.CUmodule><void_ptr>pmod
    cdef unsigned int count = 0
    with nogil:
        err = cydriver.cuModuleGetFunctionCount(&count, cymod)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], count)

@cython.embedsignature(True)
def cuModuleEnumerateFunctions(unsigned int numFunctions, mod):
    """ Returns the function handles within a module.

    Returns in `functions` a maximum number of `numFunctions` function
    handles within `mod`. When function loading mode is set to LAZY the
    function retrieved may be partially loaded. The loading state of a
    function can be queried using :py:obj:`~.cuFunctionIsLoaded`. CUDA APIs
    may load the function automatically when called with partially loaded
    function handle which may incur additional latency. Alternatively,
    :py:obj:`~.cuFunctionLoad` can be used to explicitly load a function.
    The returned function handles become invalid when the module is
    unloaded.

    Parameters
    ----------
    numFunctions : unsigned int
        Maximum number of function handles may be returned to the buffer
    mod : :py:obj:`~.CUmodule`
        Module to query from

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    functions : list[:py:obj:`~.CUfunction`]
        Buffer where the function handles are returned to

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetFunctionCount`, :py:obj:`~.cuFuncIsLoaded`, :py:obj:`~.cuFuncLoad`
    """
    cdef cydriver.CUmodule cymod
    if mod is None:
        pmod = 0
    elif isinstance(mod, (CUmodule,)):
        pmod = int(mod)
    else:
        pmod = int(CUmodule(mod))
    cymod = <cydriver.CUmodule><void_ptr>pmod
    cdef cydriver.CUfunction* cyfunctions = NULL
    pyfunctions = []
    if numFunctions != 0:
        cyfunctions = <cydriver.CUfunction*>calloc(numFunctions, sizeof(cydriver.CUfunction))
        if cyfunctions is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(numFunctions) + 'x' + str(sizeof(cydriver.CUfunction)))
    with nogil:
        err = cydriver.cuModuleEnumerateFunctions(cyfunctions, numFunctions, cymod)
    if CUresult(err) == CUresult(0):
        pyfunctions = [CUfunction(init_value=<void_ptr>cyfunctions[idx]) for idx in range(numFunctions)]
    if cyfunctions is not NULL:
        free(cyfunctions)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pyfunctions)

@cython.embedsignature(True)
def cuModuleGetGlobal(hmod, char* name):
    """ Returns a global pointer from a module.

    Returns in `*dptr` and `*bytes` the base pointer and size of the global
    of name `name` located in module `hmod`. If no variable of that name
    exists, :py:obj:`~.cuModuleGetGlobal()` returns
    :py:obj:`~.CUDA_ERROR_NOT_FOUND`. One of the parameters `dptr` or
    `numbytes` (not both) can be NULL in which case it is ignored.

    Parameters
    ----------
    hmod : :py:obj:`~.CUmodule`
        Module to retrieve global from
    name : bytes
        Name of global to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    dptr : :py:obj:`~.CUdeviceptr`
        Returned global device pointer
    numbytes : int
        Returned global size in bytes

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`, :py:obj:`~.cudaGetSymbolAddress`, :py:obj:`~.cudaGetSymbolSize`
    """
    cdef cydriver.CUmodule cyhmod
    if hmod is None:
        phmod = 0
    elif isinstance(hmod, (CUmodule,)):
        phmod = int(hmod)
    else:
        phmod = int(CUmodule(hmod))
    cyhmod = <cydriver.CUmodule><void_ptr>phmod
    cdef CUdeviceptr dptr = CUdeviceptr()
    cdef size_t numbytes = 0
    with nogil:
        err = cydriver.cuModuleGetGlobal(<cydriver.CUdeviceptr*>dptr._pvt_ptr, &numbytes, cyhmod, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], dptr, numbytes)

@cython.embedsignature(True)
def cuLinkCreate(unsigned int numOptions, options : Optional[tuple[CUjit_option] | list[CUjit_option]], optionValues : Optional[tuple[Any] | list[Any]]):
    """ Creates a pending JIT linker invocation.

    If the call is successful, the caller owns the returned CUlinkState,
    which should eventually be destroyed with :py:obj:`~.cuLinkDestroy`.
    The device code machine size (32 or 64 bit) will match the calling
    application.

    Both linker and compiler options may be specified. Compiler options
    will be applied to inputs to this linker action which must be compiled
    from PTX. The options :py:obj:`~.CU_JIT_WALL_TIME`,
    :py:obj:`~.CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES`, and
    :py:obj:`~.CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES` will accumulate data
    until the CUlinkState is destroyed.

    The data passed in via :py:obj:`~.cuLinkAddData` and
    :py:obj:`~.cuLinkAddFile` will be treated as relocatable (-rdc=true to
    nvcc) when linking the final cubin during :py:obj:`~.cuLinkComplete`
    and will have similar consequences as offline relocatable device code
    linking.

    `optionValues` must remain valid for the life of the CUlinkState if
    output options are used. No other references to inputs are maintained
    after this call returns.

    Parameters
    ----------
    numOptions : unsigned int
        Size of options arrays
    options : list[:py:obj:`~.CUjit_option`]
        Array of linker and compiler options
    optionValues : list[Any]
        Array of option values, each cast to void *

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`
    stateOut : :py:obj:`~.CUlinkState`
        On success, this will contain a CUlinkState to specify and complete
        this action

    See Also
    --------
    :py:obj:`~.cuLinkAddData`, :py:obj:`~.cuLinkAddFile`, :py:obj:`~.cuLinkComplete`, :py:obj:`~.cuLinkDestroy`

    Notes
    -----
    For LTO-IR input, only LTO-IR compiled with toolkits prior to CUDA 12.0 will be accepted
    """
    optionValues = [] if optionValues is None else optionValues
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected tuple[cydriver.CUjit_option] or list[cydriver.CUjit_option]")
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[cydriver.CUjit_option] cyoptions = [pyoptions.value for pyoptions in (options)]
    pylist = [_HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperoptionValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cyoptionValues_ptr = <void**><void_ptr>voidStarHelperoptionValues.cptr
    cdef CUlinkState stateOut = CUlinkState()
    with nogil:
        err = cydriver.cuLinkCreate(numOptions, cyoptions.data(), cyoptionValues_ptr, stateOut._pvt_ptr)
    stateOut._keepalive.append(voidStarHelperoptionValues)
    for option in pylist:
        stateOut._keepalive.append(option)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], stateOut)

@cython.embedsignature(True)
def cuLinkAddData(state, typename not None : CUjitInputType, data, size_t size, char* name, unsigned int numOptions, options : Optional[tuple[CUjit_option] | list[CUjit_option]], optionValues : Optional[tuple[Any] | list[Any]]):
    """ Add an input to a pending linker invocation.

    Ownership of `data` is retained by the caller. No reference is retained
    to any inputs after this call returns.

    This method accepts only compiler options, which are used if the data
    must be compiled from PTX, and does not accept any of
    :py:obj:`~.CU_JIT_WALL_TIME`, :py:obj:`~.CU_JIT_INFO_LOG_BUFFER`,
    :py:obj:`~.CU_JIT_ERROR_LOG_BUFFER`,
    :py:obj:`~.CU_JIT_TARGET_FROM_CUCONTEXT`, or :py:obj:`~.CU_JIT_TARGET`.

    Parameters
    ----------
    state : :py:obj:`~.CUlinkState`
        A pending linker action.
    typename : :py:obj:`~.CUjitInputType`
        The type of the input data.
    data : Any
        The input data. PTX must be NULL-terminated.
    size : size_t
        The length of the input data.
    name : bytes
        An optional name for this input in log messages.
    numOptions : unsigned int
        Size of options.
    options : list[:py:obj:`~.CUjit_option`]
        Options to be applied only for this input (overrides options from
        :py:obj:`~.cuLinkCreate`).
    optionValues : list[Any]
        Array of option values, each cast to void *.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_IMAGE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`

    See Also
    --------
    :py:obj:`~.cuLinkCreate`, :py:obj:`~.cuLinkAddFile`, :py:obj:`~.cuLinkComplete`, :py:obj:`~.cuLinkDestroy`

    Notes
    -----
    For LTO-IR input, only LTO-IR compiled with toolkits prior to CUDA 12.0 will be accepted
    """
    optionValues = [] if optionValues is None else optionValues
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected tuple[cydriver.CUjit_option] or list[cydriver.CUjit_option]")
    cdef cydriver.CUlinkState cystate
    if state is None:
        pstate = 0
    elif isinstance(state, (CUlinkState,)):
        pstate = int(state)
    else:
        pstate = int(CUlinkState(state))
    cystate = <cydriver.CUlinkState><void_ptr>pstate
    cdef cydriver.CUjitInputType cytypename = typename.value
    cydata = _HelperInputVoidPtr(data)
    cdef void* cydata_ptr = <void*><void_ptr>cydata.cptr
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[cydriver.CUjit_option] cyoptions = [pyoptions.value for pyoptions in (options)]
    pylist = [_HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperoptionValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cyoptionValues_ptr = <void**><void_ptr>voidStarHelperoptionValues.cptr
    with nogil:
        err = cydriver.cuLinkAddData(cystate, cytypename, cydata_ptr, size, name, numOptions, cyoptions.data(), cyoptionValues_ptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuLinkAddFile(state, typename not None : CUjitInputType, char* path, unsigned int numOptions, options : Optional[tuple[CUjit_option] | list[CUjit_option]], optionValues : Optional[tuple[Any] | list[Any]]):
    """ Add a file input to a pending linker invocation.

    No reference is retained to any inputs after this call returns.

    This method accepts only compiler options, which are used if the input
    must be compiled from PTX, and does not accept any of
    :py:obj:`~.CU_JIT_WALL_TIME`, :py:obj:`~.CU_JIT_INFO_LOG_BUFFER`,
    :py:obj:`~.CU_JIT_ERROR_LOG_BUFFER`,
    :py:obj:`~.CU_JIT_TARGET_FROM_CUCONTEXT`, or :py:obj:`~.CU_JIT_TARGET`.

    This method is equivalent to invoking :py:obj:`~.cuLinkAddData` on the
    contents of the file.

    Parameters
    ----------
    state : :py:obj:`~.CUlinkState`
        A pending linker action
    typename : :py:obj:`~.CUjitInputType`
        The type of the input data
    path : bytes
        Path to the input file
    numOptions : unsigned int
        Size of options
    options : list[:py:obj:`~.CUjit_option`]
        Options to be applied only for this input (overrides options from
        :py:obj:`~.cuLinkCreate`)
    optionValues : list[Any]
        Array of option values, each cast to void *

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_FILE_NOT_FOUND` :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_IMAGE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`

    See Also
    --------
    :py:obj:`~.cuLinkCreate`, :py:obj:`~.cuLinkAddData`, :py:obj:`~.cuLinkComplete`, :py:obj:`~.cuLinkDestroy`

    Notes
    -----
    For LTO-IR input, only LTO-IR compiled with toolkits prior to CUDA 12.0 will be accepted
    """
    optionValues = [] if optionValues is None else optionValues
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected tuple[cydriver.CUjit_option] or list[cydriver.CUjit_option]")
    cdef cydriver.CUlinkState cystate
    if state is None:
        pstate = 0
    elif isinstance(state, (CUlinkState,)):
        pstate = int(state)
    else:
        pstate = int(CUlinkState(state))
    cystate = <cydriver.CUlinkState><void_ptr>pstate
    cdef cydriver.CUjitInputType cytypename = typename.value
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[cydriver.CUjit_option] cyoptions = [pyoptions.value for pyoptions in (options)]
    pylist = [_HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperoptionValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cyoptionValues_ptr = <void**><void_ptr>voidStarHelperoptionValues.cptr
    with nogil:
        err = cydriver.cuLinkAddFile(cystate, cytypename, path, numOptions, cyoptions.data(), cyoptionValues_ptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuLinkComplete(state):
    """ Complete a pending linker invocation.

    Completes the pending linker action and returns the cubin image for the
    linked device code, which can be used with
    :py:obj:`~.cuModuleLoadData`. The cubin is owned by `state`, so it
    should be loaded before `state` is destroyed via
    :py:obj:`~.cuLinkDestroy`. This call does not destroy `state`.

    Parameters
    ----------
    state : :py:obj:`~.CUlinkState`
        A pending linker invocation

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`
    cubinOut : Any
        On success, this will point to the output image
    sizeOut : int
        Optional parameter to receive the size of the generated image

    See Also
    --------
    :py:obj:`~.cuLinkCreate`, :py:obj:`~.cuLinkAddData`, :py:obj:`~.cuLinkAddFile`, :py:obj:`~.cuLinkDestroy`, :py:obj:`~.cuModuleLoadData`
    """
    cdef cydriver.CUlinkState cystate
    if state is None:
        pstate = 0
    elif isinstance(state, (CUlinkState,)):
        pstate = int(state)
    else:
        pstate = int(CUlinkState(state))
    cystate = <cydriver.CUlinkState><void_ptr>pstate
    cdef void_ptr cubinOut = 0
    cdef size_t sizeOut = 0
    with nogil:
        err = cydriver.cuLinkComplete(cystate, <void**>&cubinOut, &sizeOut)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], cubinOut, sizeOut)

@cython.embedsignature(True)
def cuLinkDestroy(state):
    """ Destroys state for a JIT linker invocation.

    Parameters
    ----------
    state : :py:obj:`~.CUlinkState`
        State object for the linker invocation

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`

    See Also
    --------
    :py:obj:`~.cuLinkCreate`
    """
    cdef cydriver.CUlinkState cystate
    if state is None:
        pstate = 0
    elif isinstance(state, (CUlinkState,)):
        pstate = int(state)
    else:
        pstate = int(CUlinkState(state))
    cystate = <cydriver.CUlinkState><void_ptr>pstate
    with nogil:
        err = cydriver.cuLinkDestroy(cystate)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuModuleGetTexRef(hmod, char* name):
    """ Returns a handle to a texture reference.

    [Deprecated]

    Returns in `*pTexRef` the handle of the texture reference of name
    `name` in the module `hmod`. If no texture reference of that name
    exists, :py:obj:`~.cuModuleGetTexRef()` returns
    :py:obj:`~.CUDA_ERROR_NOT_FOUND`. This texture reference handle should
    not be destroyed, since it will be destroyed when the module is
    unloaded.

    Parameters
    ----------
    hmod : :py:obj:`~.CUmodule`
        Module to retrieve texture reference from
    name : bytes
        Name of texture reference to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    pTexRef : :py:obj:`~.CUtexref`
        Returned texture reference

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetSurfRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`
    """
    cdef cydriver.CUmodule cyhmod
    if hmod is None:
        phmod = 0
    elif isinstance(hmod, (CUmodule,)):
        phmod = int(hmod)
    else:
        phmod = int(CUmodule(hmod))
    cyhmod = <cydriver.CUmodule><void_ptr>phmod
    cdef CUtexref pTexRef = CUtexref()
    with nogil:
        err = cydriver.cuModuleGetTexRef(<cydriver.CUtexref*>pTexRef._pvt_ptr, cyhmod, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pTexRef)

@cython.embedsignature(True)
def cuModuleGetSurfRef(hmod, char* name):
    """ Returns a handle to a surface reference.

    [Deprecated]

    Returns in `*pSurfRef` the handle of the surface reference of name
    `name` in the module `hmod`. If no surface reference of that name
    exists, :py:obj:`~.cuModuleGetSurfRef()` returns
    :py:obj:`~.CUDA_ERROR_NOT_FOUND`.

    Parameters
    ----------
    hmod : :py:obj:`~.CUmodule`
        Module to retrieve surface reference from
    name : bytes
        Name of surface reference to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    pSurfRef : :py:obj:`~.CUsurfref`
        Returned surface reference

    See Also
    --------
    :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuModuleGetGlobal`, :py:obj:`~.cuModuleGetTexRef`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`, :py:obj:`~.cuModuleLoadFatBinary`, :py:obj:`~.cuModuleUnload`
    """
    cdef cydriver.CUmodule cyhmod
    if hmod is None:
        phmod = 0
    elif isinstance(hmod, (CUmodule,)):
        phmod = int(hmod)
    else:
        phmod = int(CUmodule(hmod))
    cyhmod = <cydriver.CUmodule><void_ptr>phmod
    cdef CUsurfref pSurfRef = CUsurfref()
    with nogil:
        err = cydriver.cuModuleGetSurfRef(<cydriver.CUsurfref*>pSurfRef._pvt_ptr, cyhmod, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pSurfRef)

@cython.embedsignature(True)
def cuLibraryLoadData(code, jitOptions : Optional[tuple[CUjit_option] | list[CUjit_option]], jitOptionsValues : Optional[tuple[Any] | list[Any]], unsigned int numJitOptions, libraryOptions : Optional[tuple[CUlibraryOption] | list[CUlibraryOption]], libraryOptionValues : Optional[tuple[Any] | list[Any]], unsigned int numLibraryOptions):
    """ Load a library with specified code and options.

    Takes a pointer `code` and loads the corresponding library `library`
    based on the application defined library loading mode:

    - If module loading is set to EAGER, via the environment variables
      described in "Module loading", `library` is loaded eagerly into all
      contexts at the time of the call and future contexts at the time of
      creation until the library is unloaded with
      :py:obj:`~.cuLibraryUnload()`.

    - If the environment variables are set to LAZY, `library` is not
      immediately loaded onto all existent contexts and will only be loaded
      when a function is needed for that context, such as a kernel launch.

    These environment variables are described in the CUDA programming guide
    under the "CUDA environment variables" section.

    The `code` may be a `cubin` or `fatbin` as output by nvcc, or a NULL-
    terminated `PTX`, either as output by nvcc or hand-written. A fatbin
    should also contain relocatable code when doing separate compilation.

    Options are passed as an array via `jitOptions` and any corresponding
    parameters are passed in `jitOptionsValues`. The number of total JIT
    options is supplied via `numJitOptions`. Any outputs will be returned
    via `jitOptionsValues`.

    Library load options are passed as an array via `libraryOptions` and
    any corresponding parameters are passed in `libraryOptionValues`. The
    number of total library load options is supplied via
    `numLibraryOptions`.

    Parameters
    ----------
    code : Any
        Code to load
    jitOptions : list[:py:obj:`~.CUjit_option`]
        Options for JIT
    jitOptionsValues : list[Any]
        Option values for JIT
    numJitOptions : unsigned int
        Number of options
    libraryOptions : list[:py:obj:`~.CUlibraryOption`]
        Options for loading
    libraryOptionValues : list[Any]
        Option values for loading
    numLibraryOptions : unsigned int
        Number of options for loading

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`
    library : :py:obj:`~.CUlibrary`
        Returned library

    See Also
    --------
    :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`

    Notes
    -----
    If the library contains managed variables and no device in the system supports managed variables this call is expected to return :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`
    """
    libraryOptionValues = [] if libraryOptionValues is None else libraryOptionValues
    libraryOptions = [] if libraryOptions is None else libraryOptions
    if not all(isinstance(_x, (CUlibraryOption)) for _x in libraryOptions):
        raise TypeError("Argument 'libraryOptions' is not instance of type (expected tuple[cydriver.CUlibraryOption] or list[cydriver.CUlibraryOption]")
    jitOptionsValues = [] if jitOptionsValues is None else jitOptionsValues
    jitOptions = [] if jitOptions is None else jitOptions
    if not all(isinstance(_x, (CUjit_option)) for _x in jitOptions):
        raise TypeError("Argument 'jitOptions' is not instance of type (expected tuple[cydriver.CUjit_option] or list[cydriver.CUjit_option]")
    cdef CUlibrary library = CUlibrary()
    cycode = _HelperInputVoidPtr(code)
    cdef void* cycode_ptr = <void*><void_ptr>cycode.cptr
    cdef vector[cydriver.CUjit_option] cyjitOptions = [pyjitOptions.value for pyjitOptions in (jitOptions)]
    pylist = [_HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(jitOptions, jitOptionsValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperjitOptionsValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cyjitOptionsValues_ptr = <void**><void_ptr>voidStarHelperjitOptionsValues.cptr
    if numJitOptions > len(jitOptions): raise RuntimeError("List is too small: " + str(len(jitOptions)) + " < " + str(numJitOptions))
    if numJitOptions > len(jitOptionsValues): raise RuntimeError("List is too small: " + str(len(jitOptionsValues)) + " < " + str(numJitOptions))
    cdef vector[cydriver.CUlibraryOption] cylibraryOptions = [pylibraryOptions.value for pylibraryOptions in (libraryOptions)]
    pylist = [_HelperCUlibraryOption(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(libraryOptions, libraryOptionValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperlibraryOptionValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cylibraryOptionValues_ptr = <void**><void_ptr>voidStarHelperlibraryOptionValues.cptr
    if numLibraryOptions > len(libraryOptions): raise RuntimeError("List is too small: " + str(len(libraryOptions)) + " < " + str(numLibraryOptions))
    if numLibraryOptions > len(libraryOptionValues): raise RuntimeError("List is too small: " + str(len(libraryOptionValues)) + " < " + str(numLibraryOptions))
    with nogil:
        err = cydriver.cuLibraryLoadData(<cydriver.CUlibrary*>library._pvt_ptr, cycode_ptr, cyjitOptions.data(), cyjitOptionsValues_ptr, numJitOptions, cylibraryOptions.data(), cylibraryOptionValues_ptr, numLibraryOptions)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], library)

@cython.embedsignature(True)
def cuLibraryLoadFromFile(char* fileName, jitOptions : Optional[tuple[CUjit_option] | list[CUjit_option]], jitOptionsValues : Optional[tuple[Any] | list[Any]], unsigned int numJitOptions, libraryOptions : Optional[tuple[CUlibraryOption] | list[CUlibraryOption]], libraryOptionValues : Optional[tuple[Any] | list[Any]], unsigned int numLibraryOptions):
    """ Load a library with specified file and options.

    Takes a pointer `code` and loads the corresponding library `library`
    based on the application defined library loading mode:

    - If module loading is set to EAGER, via the environment variables
      described in "Module loading", `library` is loaded eagerly into all
      contexts at the time of the call and future contexts at the time of
      creation until the library is unloaded with
      :py:obj:`~.cuLibraryUnload()`.

    - If the environment variables are set to LAZY, `library` is not
      immediately loaded onto all existent contexts and will only be loaded
      when a function is needed for that context, such as a kernel launch.

    These environment variables are described in the CUDA programming guide
    under the "CUDA environment variables" section.

    The file should be a `cubin` file as output by nvcc, or a `PTX` file
    either as output by nvcc or handwritten, or a `fatbin` file as output
    by nvcc. A fatbin should also contain relocatable code when doing
    separate compilation.

    Options are passed as an array via `jitOptions` and any corresponding
    parameters are passed in `jitOptionsValues`. The number of total
    options is supplied via `numJitOptions`. Any outputs will be returned
    via `jitOptionsValues`.

    Library load options are passed as an array via `libraryOptions` and
    any corresponding parameters are passed in `libraryOptionValues`. The
    number of total library load options is supplied via
    `numLibraryOptions`.

    Parameters
    ----------
    fileName : bytes
        File to load from
    jitOptions : list[:py:obj:`~.CUjit_option`]
        Options for JIT
    jitOptionsValues : list[Any]
        Option values for JIT
    numJitOptions : unsigned int
        Number of options
    libraryOptions : list[:py:obj:`~.CUlibraryOption`]
        Options for loading
    libraryOptionValues : list[Any]
        Option values for loading
    numLibraryOptions : unsigned int
        Number of options for loading

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_PTX`, :py:obj:`~.CUDA_ERROR_UNSUPPORTED_PTX_VERSION`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_NO_BINARY_FOR_GPU`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED`, :py:obj:`~.CUDA_ERROR_JIT_COMPILER_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`
    library : :py:obj:`~.CUlibrary`
        Returned library

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuModuleLoad`, :py:obj:`~.cuModuleLoadData`, :py:obj:`~.cuModuleLoadDataEx`

    Notes
    -----
    If the library contains managed variables and no device in the system supports managed variables this call is expected to return :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`
    """
    libraryOptionValues = [] if libraryOptionValues is None else libraryOptionValues
    libraryOptions = [] if libraryOptions is None else libraryOptions
    if not all(isinstance(_x, (CUlibraryOption)) for _x in libraryOptions):
        raise TypeError("Argument 'libraryOptions' is not instance of type (expected tuple[cydriver.CUlibraryOption] or list[cydriver.CUlibraryOption]")
    jitOptionsValues = [] if jitOptionsValues is None else jitOptionsValues
    jitOptions = [] if jitOptions is None else jitOptions
    if not all(isinstance(_x, (CUjit_option)) for _x in jitOptions):
        raise TypeError("Argument 'jitOptions' is not instance of type (expected tuple[cydriver.CUjit_option] or list[cydriver.CUjit_option]")
    cdef CUlibrary library = CUlibrary()
    cdef vector[cydriver.CUjit_option] cyjitOptions = [pyjitOptions.value for pyjitOptions in (jitOptions)]
    pylist = [_HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(jitOptions, jitOptionsValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperjitOptionsValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cyjitOptionsValues_ptr = <void**><void_ptr>voidStarHelperjitOptionsValues.cptr
    if numJitOptions > len(jitOptions): raise RuntimeError("List is too small: " + str(len(jitOptions)) + " < " + str(numJitOptions))
    if numJitOptions > len(jitOptionsValues): raise RuntimeError("List is too small: " + str(len(jitOptionsValues)) + " < " + str(numJitOptions))
    cdef vector[cydriver.CUlibraryOption] cylibraryOptions = [pylibraryOptions.value for pylibraryOptions in (libraryOptions)]
    pylist = [_HelperCUlibraryOption(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(libraryOptions, libraryOptionValues)]
    cdef _InputVoidPtrPtrHelper voidStarHelperlibraryOptionValues = _InputVoidPtrPtrHelper(pylist)
    cdef void** cylibraryOptionValues_ptr = <void**><void_ptr>voidStarHelperlibraryOptionValues.cptr
    if numLibraryOptions > len(libraryOptions): raise RuntimeError("List is too small: " + str(len(libraryOptions)) + " < " + str(numLibraryOptions))
    if numLibraryOptions > len(libraryOptionValues): raise RuntimeError("List is too small: " + str(len(libraryOptionValues)) + " < " + str(numLibraryOptions))
    with nogil:
        err = cydriver.cuLibraryLoadFromFile(<cydriver.CUlibrary*>library._pvt_ptr, fileName, cyjitOptions.data(), cyjitOptionsValues_ptr, numJitOptions, cylibraryOptions.data(), cylibraryOptionValues_ptr, numLibraryOptions)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], library)

@cython.embedsignature(True)
def cuLibraryUnload(library):
    """ Unloads a library.

    Unloads the library specified with `library`

    Parameters
    ----------
    library : :py:obj:`~.CUlibrary`
        Library to unload

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuModuleUnload`
    """
    cdef cydriver.CUlibrary cylibrary
    if library is None:
        plibrary = 0
    elif isinstance(library, (CUlibrary,)):
        plibrary = int(library)
    else:
        plibrary = int(CUlibrary(library))
    cylibrary = <cydriver.CUlibrary><void_ptr>plibrary
    with nogil:
        err = cydriver.cuLibraryUnload(cylibrary)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuLibraryGetKernel(library, char* name):
    """ Returns a kernel handle.

    Returns in `pKernel` the handle of the kernel with name `name` located
    in library `library`. If kernel handle is not found, the call returns
    :py:obj:`~.CUDA_ERROR_NOT_FOUND`.

    Parameters
    ----------
    library : :py:obj:`~.CUlibrary`
        Library to retrieve kernel from
    name : bytes
        Name of kernel to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    pKernel : :py:obj:`~.CUkernel`
        Returned kernel handle

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuKernelGetFunction`, :py:obj:`~.cuLibraryGetModule`, :py:obj:`~.cuModuleGetFunction`
    """
    cdef cydriver.CUlibrary cylibrary
    if library is None:
        plibrary = 0
    elif isinstance(library, (CUlibrary,)):
        plibrary = int(library)
    else:
        plibrary = int(CUlibrary(library))
    cylibrary = <cydriver.CUlibrary><void_ptr>plibrary
    cdef CUkernel pKernel = CUkernel()
    with nogil:
        err = cydriver.cuLibraryGetKernel(<cydriver.CUkernel*>pKernel._pvt_ptr, cylibrary, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pKernel)

@cython.embedsignature(True)
def cuLibraryGetKernelCount(lib):
    """ Returns the number of kernels within a library.

    Returns in `count` the number of kernels in `lib`.

    Parameters
    ----------
    lib : :py:obj:`~.CUlibrary`
        Library to query

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    count : unsigned int
        Number of kernels found within the library
    """
    cdef cydriver.CUlibrary cylib
    if lib is None:
        plib = 0
    elif isinstance(lib, (CUlibrary,)):
        plib = int(lib)
    else:
        plib = int(CUlibrary(lib))
    cylib = <cydriver.CUlibrary><void_ptr>plib
    cdef unsigned int count = 0
    with nogil:
        err = cydriver.cuLibraryGetKernelCount(&count, cylib)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], count)

@cython.embedsignature(True)
def cuLibraryEnumerateKernels(unsigned int numKernels, lib):
    """ Retrieve the kernel handles within a library.

    Returns in `kernels` a maximum number of `numKernels` kernel handles
    within `lib`. The returned kernel handle becomes invalid when the
    library is unloaded.

    Parameters
    ----------
    numKernels : unsigned int
        Maximum number of kernel handles may be returned to the buffer
    lib : :py:obj:`~.CUlibrary`
        Library to query from

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    kernels : list[:py:obj:`~.CUkernel`]
        Buffer where the kernel handles are returned to

    See Also
    --------
    :py:obj:`~.cuLibraryGetKernelCount`
    """
    cdef cydriver.CUlibrary cylib
    if lib is None:
        plib = 0
    elif isinstance(lib, (CUlibrary,)):
        plib = int(lib)
    else:
        plib = int(CUlibrary(lib))
    cylib = <cydriver.CUlibrary><void_ptr>plib
    cdef cydriver.CUkernel* cykernels = NULL
    pykernels = []
    if numKernels != 0:
        cykernels = <cydriver.CUkernel*>calloc(numKernels, sizeof(cydriver.CUkernel))
        if cykernels is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(numKernels) + 'x' + str(sizeof(cydriver.CUkernel)))
    with nogil:
        err = cydriver.cuLibraryEnumerateKernels(cykernels, numKernels, cylib)
    if CUresult(err) == CUresult(0):
        pykernels = [CUkernel(init_value=<void_ptr>cykernels[idx]) for idx in range(numKernels)]
    if cykernels is not NULL:
        free(cykernels)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pykernels)

@cython.embedsignature(True)
def cuLibraryGetModule(library):
    """ Returns a module handle.

    Returns in `pMod` the module handle associated with the current context
    located in library `library`. If module handle is not found, the call
    returns :py:obj:`~.CUDA_ERROR_NOT_FOUND`.

    Parameters
    ----------
    library : :py:obj:`~.CUlibrary`
        Library to retrieve module from

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_CONTEXT_IS_DESTROYED`
    pMod : :py:obj:`~.CUmodule`
        Returned module handle

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuModuleGetFunction`
    """
    cdef cydriver.CUlibrary cylibrary
    if library is None:
        plibrary = 0
    elif isinstance(library, (CUlibrary,)):
        plibrary = int(library)
    else:
        plibrary = int(CUlibrary(library))
    cylibrary = <cydriver.CUlibrary><void_ptr>plibrary
    cdef CUmodule pMod = CUmodule()
    with nogil:
        err = cydriver.cuLibraryGetModule(<cydriver.CUmodule*>pMod._pvt_ptr, cylibrary)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pMod)

@cython.embedsignature(True)
def cuKernelGetFunction(kernel):
    """ Returns a function handle.

    Returns in `pFunc` the handle of the function for the requested kernel
    `kernel` and the current context. If function handle is not found, the
    call returns :py:obj:`~.CUDA_ERROR_NOT_FOUND`.

    Parameters
    ----------
    kernel : :py:obj:`~.CUkernel`
        Kernel to retrieve function for the requested context

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_CONTEXT_IS_DESTROYED`
    pFunc : :py:obj:`~.CUfunction`
        Returned function handle

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuLibraryGetKernel`, :py:obj:`~.cuLibraryGetModule`, :py:obj:`~.cuModuleGetFunction`
    """
    cdef cydriver.CUkernel cykernel
    if kernel is None:
        pkernel = 0
    elif isinstance(kernel, (CUkernel,)):
        pkernel = int(kernel)
    else:
        pkernel = int(CUkernel(kernel))
    cykernel = <cydriver.CUkernel><void_ptr>pkernel
    cdef CUfunction pFunc = CUfunction()
    with nogil:
        err = cydriver.cuKernelGetFunction(<cydriver.CUfunction*>pFunc._pvt_ptr, cykernel)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pFunc)

@cython.embedsignature(True)
def cuKernelGetLibrary(kernel):
    """ Returns a library handle.

    Returns in `pLib` the handle of the library for the requested kernel
    `kernel`

    Parameters
    ----------
    kernel : :py:obj:`~.CUkernel`
        Kernel to retrieve library handle

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    pLib : :py:obj:`~.CUlibrary`
        Returned library handle

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuLibraryGetKernel`
    """
    cdef cydriver.CUkernel cykernel
    if kernel is None:
        pkernel = 0
    elif isinstance(kernel, (CUkernel,)):
        pkernel = int(kernel)
    else:
        pkernel = int(CUkernel(kernel))
    cykernel = <cydriver.CUkernel><void_ptr>pkernel
    cdef CUlibrary pLib = CUlibrary()
    with nogil:
        err = cydriver.cuKernelGetLibrary(<cydriver.CUlibrary*>pLib._pvt_ptr, cykernel)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pLib)

@cython.embedsignature(True)
def cuLibraryGetGlobal(library, char* name):
    """ Returns a global device pointer.

    Returns in `*dptr` and `*bytes` the base pointer and size of the global
    with name `name` for the requested library `library` and the current
    context. If no global for the requested name `name` exists, the call
    returns :py:obj:`~.CUDA_ERROR_NOT_FOUND`. One of the parameters `dptr`
    or `numbytes` (not both) can be NULL in which case it is ignored.

    Parameters
    ----------
    library : :py:obj:`~.CUlibrary`
        Library to retrieve global from
    name : bytes
        Name of global to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_CONTEXT_IS_DESTROYED`
    dptr : :py:obj:`~.CUdeviceptr`
        Returned global device pointer for the requested context
    numbytes : int
        Returned global size in bytes

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuLibraryGetModule`, :py:obj:`~.cuModuleGetGlobal`
    """
    cdef cydriver.CUlibrary cylibrary
    if library is None:
        plibrary = 0
    elif isinstance(library, (CUlibrary,)):
        plibrary = int(library)
    else:
        plibrary = int(CUlibrary(library))
    cylibrary = <cydriver.CUlibrary><void_ptr>plibrary
    cdef CUdeviceptr dptr = CUdeviceptr()
    cdef size_t numbytes = 0
    with nogil:
        err = cydriver.cuLibraryGetGlobal(<cydriver.CUdeviceptr*>dptr._pvt_ptr, &numbytes, cylibrary, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], dptr, numbytes)

@cython.embedsignature(True)
def cuLibraryGetManaged(library, char* name):
    """ Returns a pointer to managed memory.

    Returns in `*dptr` and `*bytes` the base pointer and size of the
    managed memory with name `name` for the requested library `library`. If
    no managed memory with the requested name `name` exists, the call
    returns :py:obj:`~.CUDA_ERROR_NOT_FOUND`. One of the parameters `dptr`
    or `numbytes` (not both) can be NULL in which case it is ignored. Note
    that managed memory for library `library` is shared across devices and
    is registered when the library is loaded into atleast one context.

    Parameters
    ----------
    library : :py:obj:`~.CUlibrary`
        Library to retrieve managed memory from
    name : bytes
        Name of managed memory to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    dptr : :py:obj:`~.CUdeviceptr`
        Returned pointer to the managed memory
    numbytes : int
        Returned memory size in bytes

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`
    """
    cdef cydriver.CUlibrary cylibrary
    if library is None:
        plibrary = 0
    elif isinstance(library, (CUlibrary,)):
        plibrary = int(library)
    else:
        plibrary = int(CUlibrary(library))
    cylibrary = <cydriver.CUlibrary><void_ptr>plibrary
    cdef CUdeviceptr dptr = CUdeviceptr()
    cdef size_t numbytes = 0
    with nogil:
        err = cydriver.cuLibraryGetManaged(<cydriver.CUdeviceptr*>dptr._pvt_ptr, &numbytes, cylibrary, name)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], dptr, numbytes)

@cython.embedsignature(True)
def cuLibraryGetUnifiedFunction(library, char* symbol):
    """ Returns a pointer to a unified function.

    Returns in `*fptr` the function pointer to a unified function denoted
    by `symbol`. If no unified function with name `symbol` exists, the call
    returns :py:obj:`~.CUDA_ERROR_NOT_FOUND`. If there is no device with
    attribute :py:obj:`~.CU_DEVICE_ATTRIBUTE_UNIFIED_FUNCTION_POINTERS`
    present in the system, the call may return
    :py:obj:`~.CUDA_ERROR_NOT_FOUND`.

    Parameters
    ----------
    library : :py:obj:`~.CUlibrary`
        Library to retrieve function pointer memory from
    symbol : bytes
        Name of function pointer to retrieve

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`
    fptr : Any
        Returned pointer to a unified function

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`
    """
    cdef cydriver.CUlibrary cylibrary
    if library is None:
        plibrary = 0
    elif isinstance(library, (CUlibrary,)):
        plibrary = int(library)
    else:
        plibrary = int(CUlibrary(library))
    cylibrary = <cydriver.CUlibrary><void_ptr>plibrary
    cdef void_ptr fptr = 0
    with nogil:
        err = cydriver.cuLibraryGetUnifiedFunction(<void**>&fptr, cylibrary, symbol)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], fptr)

@cython.embedsignature(True)
def cuKernelGetAttribute(attrib not None : CUfunction_attribute, kernel, dev):
    """ Returns information about a kernel.

    Returns in `*pi` the integer value of the attribute `attrib` for the
    kernel `kernel` for the requested device `dev`. The supported
    attributes are:

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK`: The maximum
      number of threads per block, beyond which a launch of the kernel
      would fail. This number depends on both the kernel and the requested
      device.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES`: The size in bytes of
      statically-allocated shared memory per block required by this kernel.
      This does not include dynamically-allocated shared memory requested
      by the user at runtime.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES`: The size in bytes of
      user-allocated constant memory required by this kernel.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES`: The size in bytes of
      local memory used by each thread of this kernel.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_NUM_REGS`: The number of registers used
      by each thread of this kernel.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_PTX_VERSION`: The PTX virtual
      architecture version for which the kernel was compiled. This value is
      the major PTX version * 10

      - the minor PTX version, so a PTX version 1.3 function would return
        the value 13. Note that this may return the undefined value of 0
        for cubins compiled prior to CUDA 3.0.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_BINARY_VERSION`: The binary architecture
      version for which the kernel was compiled. This value is the major
      binary version * 10 + the minor binary version, so a binary version
      1.3 function would return the value 13. Note that this will return a
      value of 10 for legacy cubins that do not have a properly-encoded
      binary architecture version.

    - :py:obj:`~.CU_FUNC_CACHE_MODE_CA`: The attribute to indicate whether
      the kernel has been compiled with user specified option "-Xptxas
      --dlcm=ca" set.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES`: The
      maximum size in bytes of dynamically-allocated shared memory.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT`:
      Preferred shared memory-L1 cache split ratio in percent of total
      shared memory.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_CLUSTER_SIZE_MUST_BE_SET`: If this
      attribute is set, the kernel must launch with a valid cluster size
      specified.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_WIDTH`: The required
      cluster width in blocks.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_HEIGHT`: The required
      cluster height in blocks.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_DEPTH`: The required
      cluster depth in blocks.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_NON_PORTABLE_CLUSTER_SIZE_ALLOWED`:
      Indicates whether the function can be launched with non-portable
      cluster size. 1 is allowed, 0 is disallowed. A non-portable cluster
      size may only function on the specific SKUs the program is tested on.
      The launch might fail if the program is run on a different hardware
      platform. CUDA API provides cudaOccupancyMaxActiveClusters to assist
      with checking whether the desired size can be launched on the current
      device. A portable cluster size is guaranteed to be functional on all
      compute capabilities higher than the target compute capability. The
      portable cluster size for sm_90 is 8 blocks per cluster. This value
      may increase for future compute capabilities. The specific hardware
      unit may support higher cluster sizes that’s not guaranteed to be
      portable.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE`:
      The block scheduling policy of a function. The value type is
      CUclusterSchedulingPolicy.

    Parameters
    ----------
    attrib : :py:obj:`~.CUfunction_attribute`
        Attribute requested
    kernel : :py:obj:`~.CUkernel`
        Kernel to query attribute of
    dev : :py:obj:`~.CUdevice`
        Device to query attribute of

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    pi : int
        Returned attribute value

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuKernelSetAttribute`, :py:obj:`~.cuLibraryGetKernel`, :py:obj:`~.cuLaunchKernel`, :py:obj:`~.cuKernelGetFunction`, :py:obj:`~.cuLibraryGetModule`, :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuFuncGetAttribute`

    Notes
    -----
    If another thread is trying to set the same attribute on the same device using :py:obj:`~.cuKernelSetAttribute()` simultaneously, the attribute query will give the old or new value depending on the interleavings chosen by the OS scheduler and memory consistency.
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef cydriver.CUkernel cykernel
    if kernel is None:
        pkernel = 0
    elif isinstance(kernel, (CUkernel,)):
        pkernel = int(kernel)
    else:
        pkernel = int(CUkernel(kernel))
    cykernel = <cydriver.CUkernel><void_ptr>pkernel
    cdef int pi = 0
    cdef cydriver.CUfunction_attribute cyattrib = attrib.value
    with nogil:
        err = cydriver.cuKernelGetAttribute(&pi, cyattrib, cykernel, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pi)

@cython.embedsignature(True)
def cuKernelSetAttribute(attrib not None : CUfunction_attribute, int val, kernel, dev):
    """ Sets information about a kernel.

    This call sets the value of a specified attribute `attrib` on the
    kernel `kernel` for the requested device `dev` to an integer value
    specified by `val`. This function returns CUDA_SUCCESS if the new value
    of the attribute could be successfully set. If the set fails, this call
    will return an error. Not all attributes can have values set.
    Attempting to set a value on a read-only attribute will result in an
    error (CUDA_ERROR_INVALID_VALUE)

    Note that attributes set using :py:obj:`~.cuFuncSetAttribute()` will
    override the attribute set by this API irrespective of whether the call
    to :py:obj:`~.cuFuncSetAttribute()` is made before or after this API
    call. However, :py:obj:`~.cuKernelGetAttribute()` will always return
    the attribute value set by this API.

    Supported attributes are:

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES`: This is
      the maximum size in bytes of dynamically-allocated shared memory. The
      value should contain the requested maximum size of dynamically-
      allocated shared memory. The sum of this value and the function
      attribute :py:obj:`~.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES` cannot
      exceed the device attribute
      :py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN`.
      The maximal size of requestable dynamic shared memory may differ by
      GPU architecture.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT`: On
      devices where the L1 cache and shared memory use the same hardware
      resources, this sets the shared memory carveout preference, in
      percent of the total shared memory. See
      :py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR`
      This is only a hint, and the driver can choose a different ratio if
      required to execute the function.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_WIDTH`: The required
      cluster width in blocks. The width, height, and depth values must
      either all be 0 or all be positive. The validity of the cluster
      dimensions is checked at launch time. If the value is set during
      compile time, it cannot be set at runtime. Setting it at runtime will
      return CUDA_ERROR_NOT_PERMITTED.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_HEIGHT`: The required
      cluster height in blocks. The width, height, and depth values must
      either all be 0 or all be positive. The validity of the cluster
      dimensions is checked at launch time. If the value is set during
      compile time, it cannot be set at runtime. Setting it at runtime will
      return CUDA_ERROR_NOT_PERMITTED.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_REQUIRED_CLUSTER_DEPTH`: The required
      cluster depth in blocks. The width, height, and depth values must
      either all be 0 or all be positive. The validity of the cluster
      dimensions is checked at launch time. If the value is set during
      compile time, it cannot be set at runtime. Setting it at runtime will
      return CUDA_ERROR_NOT_PERMITTED.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_NON_PORTABLE_CLUSTER_SIZE_ALLOWED`:
      Indicates whether the function can be launched with non-portable
      cluster size. 1 is allowed, 0 is disallowed.

    - :py:obj:`~.CU_FUNC_ATTRIBUTE_CLUSTER_SCHEDULING_POLICY_PREFERENCE`:
      The block scheduling policy of a function. The value type is
      CUclusterSchedulingPolicy.

    Parameters
    ----------
    attrib : :py:obj:`~.CUfunction_attribute`
        Attribute requested
    val : int
        Value to set
    kernel : :py:obj:`~.CUkernel`
        Kernel to set attribute of
    dev : :py:obj:`~.CUdevice`
        Device to set attribute of

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuKernelGetAttribute`, :py:obj:`~.cuLibraryGetKernel`, :py:obj:`~.cuLaunchKernel`, :py:obj:`~.cuKernelGetFunction`, :py:obj:`~.cuLibraryGetModule`, :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuFuncSetAttribute`

    Notes
    -----
    The API has stricter locking requirements in comparison to its legacy counterpart :py:obj:`~.cuFuncSetAttribute()` due to device-wide semantics. If multiple threads are trying to set the same attribute on the same device simultaneously, the attribute setting will depend on the interleavings chosen by the OS scheduler and memory consistency.
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef cydriver.CUkernel cykernel
    if kernel is None:
        pkernel = 0
    elif isinstance(kernel, (CUkernel,)):
        pkernel = int(kernel)
    else:
        pkernel = int(CUkernel(kernel))
    cykernel = <cydriver.CUkernel><void_ptr>pkernel
    cdef cydriver.CUfunction_attribute cyattrib = attrib.value
    with nogil:
        err = cydriver.cuKernelSetAttribute(cyattrib, val, cykernel, cydev)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuKernelSetCacheConfig(kernel, config not None : CUfunc_cache, dev):
    """ Sets the preferred cache configuration for a device kernel.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this sets through `config` the preferred cache configuration
    for the device kernel `kernel` on the requested device `dev`. This is
    only a preference. The driver will use the requested configuration if
    possible, but it is free to choose a different configuration if
    required to execute `kernel`. Any context-wide preference set via
    :py:obj:`~.cuCtxSetCacheConfig()` will be overridden by this per-kernel
    setting.

    Note that attributes set using :py:obj:`~.cuFuncSetCacheConfig()` will
    override the attribute set by this API irrespective of whether the call
    to :py:obj:`~.cuFuncSetCacheConfig()` is made before or after this API
    call.

    This setting does nothing on devices where the size of the L1 cache and
    shared memory are fixed.

    Launching a kernel with a different preference than the most recent
    preference setting may insert a device-side synchronization point.

    The supported cache configurations are:

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_NONE`: no preference for shared
      memory or L1 (default)

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_SHARED`: prefer larger shared memory
      and smaller L1 cache

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_L1`: prefer larger L1 cache and
      smaller shared memory

    - :py:obj:`~.CU_FUNC_CACHE_PREFER_EQUAL`: prefer equal sized L1 cache
      and shared memory

    Parameters
    ----------
    kernel : :py:obj:`~.CUkernel`
        Kernel to configure cache for
    config : :py:obj:`~.CUfunc_cache`
        Requested cache configuration
    dev : :py:obj:`~.CUdevice`
        Device to set attribute of

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`

    See Also
    --------
    :py:obj:`~.cuLibraryLoadData`, :py:obj:`~.cuLibraryLoadFromFile`, :py:obj:`~.cuLibraryUnload`, :py:obj:`~.cuLibraryGetKernel`, :py:obj:`~.cuKernelGetFunction`, :py:obj:`~.cuLibraryGetModule`, :py:obj:`~.cuModuleGetFunction`, :py:obj:`~.cuFuncSetCacheConfig`, :py:obj:`~.cuCtxSetCacheConfig`, :py:obj:`~.cuLaunchKernel`

    Notes
    -----
    The API has stricter locking requirements in comparison to its legacy counterpart :py:obj:`~.cuFuncSetCacheConfig()` due to device-wide semantics. If multiple threads are trying to set a config on the same device simultaneously, the cache config setting will depend on the interleavings chosen by the OS scheduler and memory consistency.
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    cdef cydriver.CUkernel cykernel
    if kernel is None:
        pkernel = 0
    elif isinstance(kernel, (CUkernel,)):
        pkernel = int(kernel)
    else:
        pkernel = int(CUkernel(kernel))
    cykernel = <cydriver.CUkernel><void_ptr>pkernel
    cdef cydriver.CUfunc_cache cyconfig = config.value
    with nogil:
        err = cydriver.cuKernelSetCacheConfig(cykernel, cyconfig, cydev)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuKernelGetName(hfunc):
    """ Returns the function name for a :py:obj:`~.CUkernel` handle.

    Returns in `**name` the function name associated with the kernel handle
    `hfunc` . The function name is returned as a null-terminated string.
    The returned name is only valid when the kernel handle is valid. If the
    library is unloaded or reloaded, one must call the API again to get the
    updated name. This API may return a mangled name if the function is not
    declared as having C linkage. If either `**name` or `hfunc` is NULL,
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE` is returned.

    Parameters
    ----------
    hfunc : :py:obj:`~.CUkernel`
        The function handle to retrieve the name for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    name : bytes
        The returned name of the function
    """
    cdef cydriver.CUkernel cyhfunc
    if hfunc is None:
        phfunc = 0
    elif isinstance(hfunc, (CUkernel,)):
        phfunc = int(hfunc)
    else:
        phfunc = int(CUkernel(hfunc))
    cyhfunc = <cydriver.CUkernel><void_ptr>phfunc
    cdef const char* name = NULL
    with nogil:
        err = cydriver.cuKernelGetName(&name, cyhfunc)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], <bytes>name if name != NULL else None)

@cython.embedsignature(True)
def cuKernelGetParamInfo(kernel, size_t paramIndex):
    """ Returns the offset and size of a kernel parameter in the device-side parameter layout.

    Queries the kernel parameter at `paramIndex` into `kernel's` list of
    parameters, and returns in `paramOffset` and `paramSize` the offset and
    size, respectively, where the parameter will reside in the device-side
    parameter layout. This information can be used to update kernel node
    parameters from the device via
    :py:obj:`~.cudaGraphKernelNodeSetParam()` and
    :py:obj:`~.cudaGraphKernelNodeUpdatesApply()`. `paramIndex` must be
    less than the number of parameters that `kernel` takes. `paramSize` can
    be set to NULL if only the parameter offset is desired.

    Parameters
    ----------
    kernel : :py:obj:`~.CUkernel`
        The kernel to query
    paramIndex : size_t
        The parameter index to query

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`,
    paramOffset : int
        Returns the offset into the device-side parameter layout at which
        the parameter resides
    paramSize : int
        Optionally returns the size of the parameter in the device-side
        parameter layout

    See Also
    --------
    :py:obj:`~.cuFuncGetParamInfo`
    """
    cdef cydriver.CUkernel cykernel
    if kernel is None:
        pkernel = 0
    elif isinstance(kernel, (CUkernel,)):
        pkernel = int(kernel)
    else:
        pkernel = int(CUkernel(kernel))
    cykernel = <cydriver.CUkernel><void_ptr>pkernel
    cdef size_t paramOffset = 0
    cdef size_t paramSize = 0
    with nogil:
        err = cydriver.cuKernelGetParamInfo(cykernel, paramIndex, &paramOffset, &paramSize)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], paramOffset, paramSize)

@cython.embedsignature(True)
def cuMemGetInfo():
    """ Gets free and total memory.

    Returns in `*total` the total amount of memory available to the the
    current context. Returns in `*free` the amount of memory on the device
    that is free according to the OS. CUDA is not guaranteed to be able to
    allocate all of the memory that the OS reports as free. In a multi-
    tenet situation, free estimate returned is prone to race condition
    where a new allocation/free done by a different process or a different
    thread in the same process between the time when free memory was
    estimated and reported, will result in deviation in free value reported
    and actual free memory.

    The integrated GPU on Tegra shares memory with CPU and other component
    of the SoC. The free and total values returned by the API excludes the
    SWAP memory space maintained by the OS on some platforms. The OS may
    move some of the memory pages into swap area as the GPU or CPU allocate
    or access memory. See Tegra app note on how to calculate total and free
    memory on Tegra.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    free : int
        Returned free memory in bytes
    total : int
        Returned total memory in bytes

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemGetInfo`
    """
    cdef size_t free = 0
    cdef size_t total = 0
    with nogil:
        err = cydriver.cuMemGetInfo(&free, &total)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], free, total)

@cython.embedsignature(True)
def cuMemAlloc(size_t bytesize):
    """ Allocates device memory.

    Allocates `bytesize` bytes of linear memory on the device and returns
    in `*dptr` a pointer to the allocated memory. The allocated memory is
    suitably aligned for any kind of variable. The memory is not cleared.
    If `bytesize` is 0, :py:obj:`~.cuMemAlloc()` returns
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE`.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`
    dptr : :py:obj:`~.CUdeviceptr`
        Returned device pointer

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMalloc`
    """
    cdef CUdeviceptr dptr = CUdeviceptr()
    with nogil:
        err = cydriver.cuMemAlloc(<cydriver.CUdeviceptr*>dptr._pvt_ptr, bytesize)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], dptr)

@cython.embedsignature(True)
def cuMemAllocPitch(size_t WidthInBytes, size_t Height, unsigned int ElementSizeBytes):
    """ Allocates pitched device memory.

    Allocates at least `WidthInBytes` * `Height` bytes of linear memory on
    the device and returns in `*dptr` a pointer to the allocated memory.
    The function may pad the allocation to ensure that corresponding
    pointers in any given row will continue to meet the alignment
    requirements for coalescing as the address is updated from row to row.
    `ElementSizeBytes` specifies the size of the largest reads and writes
    that will be performed on the memory range. `ElementSizeBytes` may be
    4, 8 or 16 (since coalesced memory transactions are not possible on
    other data sizes). If `ElementSizeBytes` is smaller than the actual
    read/write size of a kernel, the kernel will run correctly, but
    possibly at reduced speed. The pitch returned in `*pPitch` by
    :py:obj:`~.cuMemAllocPitch()` is the width in bytes of the allocation.
    The intended usage of pitch is as a separate parameter of the
    allocation, used to compute addresses within the 2D array. Given the
    row and column of an array element of type T, the address is computed
    as:

    **View CUDA Toolkit Documentation for a C++ code example**

    The pitch returned by :py:obj:`~.cuMemAllocPitch()` is guaranteed to
    work with :py:obj:`~.cuMemcpy2D()` under all circumstances. For
    allocations of 2D arrays, it is recommended that programmers consider
    performing pitch allocations using :py:obj:`~.cuMemAllocPitch()`. Due
    to alignment restrictions in the hardware, this is especially true if
    the application will be performing 2D memory copies between different
    regions of device memory (whether linear memory or CUDA arrays).

    The byte alignment of the pitch returned by
    :py:obj:`~.cuMemAllocPitch()` is guaranteed to match or exceed the
    alignment requirement for texture binding with
    :py:obj:`~.cuTexRefSetAddress2D()`.

    Parameters
    ----------
    WidthInBytes : size_t
        Requested allocation width in bytes
    Height : size_t
        Requested allocation height in rows
    ElementSizeBytes : unsigned int
        Size of largest reads/writes for range

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`
    dptr : :py:obj:`~.CUdeviceptr`
        Returned device pointer
    pPitch : int
        Returned pitch of allocation in bytes

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMallocPitch`
    """
    cdef CUdeviceptr dptr = CUdeviceptr()
    cdef size_t pPitch = 0
    with nogil:
        err = cydriver.cuMemAllocPitch(<cydriver.CUdeviceptr*>dptr._pvt_ptr, &pPitch, WidthInBytes, Height, ElementSizeBytes)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], dptr, pPitch)

@cython.embedsignature(True)
def cuMemFree(dptr):
    """ Frees device memory.

    Frees the memory space pointed to by `dptr`, which must have been
    returned by a previous call to one of the following memory allocation
    APIs - :py:obj:`~.cuMemAlloc()`, :py:obj:`~.cuMemAllocPitch()`,
    :py:obj:`~.cuMemAllocManaged()`, :py:obj:`~.cuMemAllocAsync()`,
    :py:obj:`~.cuMemAllocFromPoolAsync()`

    Note - This API will not perform any implict synchronization when the
    pointer was allocated with :py:obj:`~.cuMemAllocAsync` or
    :py:obj:`~.cuMemAllocFromPoolAsync`. Callers must ensure that all
    accesses to these pointer have completed before invoking
    :py:obj:`~.cuMemFree`. For best performance and memory reuse, users
    should use :py:obj:`~.cuMemFreeAsync` to free memory allocated via the
    stream ordered memory allocator. For all other pointers, this API may
    perform implicit synchronization.

    Parameters
    ----------
    dptr : :py:obj:`~.CUdeviceptr`
        Pointer to memory to free

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemAllocManaged`, :py:obj:`~.cuMemAllocAsync`, :py:obj:`~.cuMemAllocFromPoolAsync`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemFreeAsync`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaFree`
    """
    cdef cydriver.CUdeviceptr cydptr
    if dptr is None:
        pdptr = 0
    elif isinstance(dptr, (CUdeviceptr,)):
        pdptr = int(dptr)
    else:
        pdptr = int(CUdeviceptr(dptr))
    cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
    with nogil:
        err = cydriver.cuMemFree(cydptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemGetAddressRange(dptr):
    """ Get information on memory allocations.

    Returns the base address in `*pbase` and size in `*psize` of the
    allocation by :py:obj:`~.cuMemAlloc()` or :py:obj:`~.cuMemAllocPitch()`
    that contains the input pointer `dptr`. Both parameters `pbase` and
    `psize` are optional. If one of them is NULL, it is ignored.

    Parameters
    ----------
    dptr : :py:obj:`~.CUdeviceptr`
        Device pointer to query

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_NOT_FOUND`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pbase : :py:obj:`~.CUdeviceptr`
        Returned base address
    psize : int
        Returned size of device memory allocation

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`
    """
    cdef cydriver.CUdeviceptr cydptr
    if dptr is None:
        pdptr = 0
    elif isinstance(dptr, (CUdeviceptr,)):
        pdptr = int(dptr)
    else:
        pdptr = int(CUdeviceptr(dptr))
    cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
    cdef CUdeviceptr pbase = CUdeviceptr()
    cdef size_t psize = 0
    with nogil:
        err = cydriver.cuMemGetAddressRange(<cydriver.CUdeviceptr*>pbase._pvt_ptr, &psize, cydptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None, None)
    return (_dict_CUresult[err], pbase, psize)

@cython.embedsignature(True)
def cuMemAllocHost(size_t bytesize):
    """ Allocates page-locked host memory.

    Allocates `bytesize` bytes of host memory that is page-locked and
    accessible to the device. The driver tracks the virtual memory ranges
    allocated with this function and automatically accelerates calls to
    functions such as :py:obj:`~.cuMemcpy()`. Since the memory can be
    accessed directly by the device, it can be read or written with much
    higher bandwidth than pageable memory obtained with functions such as
    :py:obj:`~.malloc()`.

    On systems where
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES`
    is true, :py:obj:`~.cuMemAllocHost` may not page-lock the allocated
    memory.

    Page-locking excessive amounts of memory with
    :py:obj:`~.cuMemAllocHost()` may degrade system performance, since it
    reduces the amount of memory available to the system for paging. As a
    result, this function is best used sparingly to allocate staging areas
    for data exchange between host and device.

    Note all host memory allocated using :py:obj:`~.cuMemAllocHost()` will
    automatically be immediately accessible to all contexts on all devices
    which support unified addressing (as may be queried using
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING`). The device pointer
    that may be used to access this host memory from those contexts is
    always equal to the returned host pointer `*pp`. See :py:obj:`~.Unified
    Addressing` for additional details.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`
    pp : Any
        Returned pointer to host memory

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMallocHost`
    """
    cdef void_ptr pp = 0
    with nogil:
        err = cydriver.cuMemAllocHost(<void**>&pp, bytesize)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pp)

@cython.embedsignature(True)
def cuMemFreeHost(p):
    """ Frees page-locked host memory.

    Frees the memory space pointed to by `p`, which must have been returned
    by a previous call to :py:obj:`~.cuMemAllocHost()`.

    Parameters
    ----------
    p : Any
        Pointer to memory to free

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaFreeHost`
    """
    cyp = _HelperInputVoidPtr(p)
    cdef void* cyp_ptr = <void*><void_ptr>cyp.cptr
    with nogil:
        err = cydriver.cuMemFreeHost(cyp_ptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemHostAlloc(size_t bytesize, unsigned int Flags):
    """ Allocates page-locked host memory.

    Allocates `bytesize` bytes of host memory that is page-locked and
    accessible to the device. The driver tracks the virtual memory ranges
    allocated with this function and automatically accelerates calls to
    functions such as :py:obj:`~.cuMemcpyHtoD()`. Since the memory can be
    accessed directly by the device, it can be read or written with much
    higher bandwidth than pageable memory obtained with functions such as
    :py:obj:`~.malloc()`.

    On systems where
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES`
    is true, :py:obj:`~.cuMemHostAlloc` may not page-lock the allocated
    memory.

    Page-locking excessive amounts of memory may degrade system
    performance, since it reduces the amount of memory available to the
    system for paging. As a result, this function is best used sparingly to
    allocate staging areas for data exchange between host and device.

    The `Flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.CU_MEMHOSTALLOC_PORTABLE`: The memory returned by this
      call will be considered as pinned memory by all CUDA contexts, not
      just the one that performed the allocation.

    - :py:obj:`~.CU_MEMHOSTALLOC_DEVICEMAP`: Maps the allocation into the
      CUDA address space. The device pointer to the memory may be obtained
      by calling :py:obj:`~.cuMemHostGetDevicePointer()`.

    - :py:obj:`~.CU_MEMHOSTALLOC_WRITECOMBINED`: Allocates the memory as
      write-combined (WC). WC memory can be transferred across the PCI
      Express bus more quickly on some system configurations, but cannot be
      read efficiently by most CPUs. WC memory is a good option for buffers
      that will be written by the CPU and read by the GPU via mapped pinned
      memory or host->device transfers.

    All of these flags are orthogonal to one another: a developer may
    allocate memory that is portable, mapped and/or write-combined with no
    restrictions.

    The :py:obj:`~.CU_MEMHOSTALLOC_DEVICEMAP` flag may be specified on CUDA
    contexts for devices that do not support mapped pinned memory. The
    failure is deferred to :py:obj:`~.cuMemHostGetDevicePointer()` because
    the memory may be mapped into other CUDA contexts via the
    :py:obj:`~.CU_MEMHOSTALLOC_PORTABLE` flag.

    The memory allocated by this function must be freed with
    :py:obj:`~.cuMemFreeHost()`.

    Note all host memory allocated using :py:obj:`~.cuMemHostAlloc()` will
    automatically be immediately accessible to all contexts on all devices
    which support unified addressing (as may be queried using
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING`). Unless the flag
    :py:obj:`~.CU_MEMHOSTALLOC_WRITECOMBINED` is specified, the device
    pointer that may be used to access this host memory from those contexts
    is always equal to the returned host pointer `*pp`. If the flag
    :py:obj:`~.CU_MEMHOSTALLOC_WRITECOMBINED` is specified, then the
    function :py:obj:`~.cuMemHostGetDevicePointer()` must be used to query
    the device pointer, even if the context supports unified addressing.
    See :py:obj:`~.Unified Addressing` for additional details.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes
    Flags : unsigned int
        Flags for allocation request

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`
    pp : Any
        Returned pointer to host memory

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaHostAlloc`
    """
    cdef void_ptr pp = 0
    with nogil:
        err = cydriver.cuMemHostAlloc(<void**>&pp, bytesize, Flags)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pp)

@cython.embedsignature(True)
def cuMemHostGetDevicePointer(p, unsigned int Flags):
    """ Passes back device pointer of mapped pinned memory.

    Passes back the device pointer `pdptr` corresponding to the mapped,
    pinned host buffer `p` allocated by :py:obj:`~.cuMemHostAlloc`.

    :py:obj:`~.cuMemHostGetDevicePointer()` will fail if the
    :py:obj:`~.CU_MEMHOSTALLOC_DEVICEMAP` flag was not specified at the
    time the memory was allocated, or if the function is called on a GPU
    that does not support mapped pinned memory.

    For devices that have a non-zero value for the device attribute
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM`,
    the memory can also be accessed from the device using the host pointer
    `p`. The device pointer returned by
    :py:obj:`~.cuMemHostGetDevicePointer()` may or may not match the
    original host pointer `p` and depends on the devices visible to the
    application. If all devices visible to the application have a non-zero
    value for the device attribute, the device pointer returned by
    :py:obj:`~.cuMemHostGetDevicePointer()` will match the original pointer
    `p`. If any device visible to the application has a zero value for the
    device attribute, the device pointer returned by
    :py:obj:`~.cuMemHostGetDevicePointer()` will not match the original
    host pointer `p`, but it will be suitable for use on all devices
    provided Unified Virtual Addressing is enabled. In such systems, it is
    valid to access the memory using either pointer on devices that have a
    non-zero value for the device attribute. Note however that such devices
    should access the memory using only one of the two pointers and not
    both.

    `Flags` provides for future releases. For now, it must be set to 0.

    Parameters
    ----------
    p : Any
        Host pointer
    Flags : unsigned int
        Options (must be 0)

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pdptr : :py:obj:`~.CUdeviceptr`
        Returned device pointer

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaHostGetDevicePointer`
    """
    cdef CUdeviceptr pdptr = CUdeviceptr()
    cyp = _HelperInputVoidPtr(p)
    cdef void* cyp_ptr = <void*><void_ptr>cyp.cptr
    with nogil:
        err = cydriver.cuMemHostGetDevicePointer(<cydriver.CUdeviceptr*>pdptr._pvt_ptr, cyp_ptr, Flags)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pdptr)

@cython.embedsignature(True)
def cuMemHostGetFlags(p):
    """ Passes back flags that were used for a pinned allocation.

    Passes back the flags `pFlags` that were specified when allocating the
    pinned host buffer `p` allocated by :py:obj:`~.cuMemHostAlloc`.

    :py:obj:`~.cuMemHostGetFlags()` will fail if the pointer does not
    reside in an allocation performed by :py:obj:`~.cuMemAllocHost()` or
    :py:obj:`~.cuMemHostAlloc()`.

    Parameters
    ----------
    p : Any
        Host pointer

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pFlags : unsigned int
        Returned flags word

    See Also
    --------
    :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cudaHostGetFlags`
    """
    cdef unsigned int pFlags = 0
    cyp = _HelperInputVoidPtr(p)
    cdef void* cyp_ptr = <void*><void_ptr>cyp.cptr
    with nogil:
        err = cydriver.cuMemHostGetFlags(&pFlags, cyp_ptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pFlags)

@cython.embedsignature(True)
def cuMemAllocManaged(size_t bytesize, unsigned int flags):
    """ Allocates memory that will be automatically managed by the Unified Memory system.

    Allocates `bytesize` bytes of managed memory on the device and returns
    in `*dptr` a pointer to the allocated memory. If the device doesn't
    support allocating managed memory, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`
    is returned. Support for managed memory can be queried using the device
    attribute :py:obj:`~.CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY`. The allocated
    memory is suitably aligned for any kind of variable. The memory is not
    cleared. If `bytesize` is 0, :py:obj:`~.cuMemAllocManaged` returns
    :py:obj:`~.CUDA_ERROR_INVALID_VALUE`. The pointer is valid on the CPU
    and on all GPUs in the system that support managed memory. All accesses
    to this pointer must obey the Unified Memory programming model.

    `flags` specifies the default stream association for this allocation.
    `flags` must be one of :py:obj:`~.CU_MEM_ATTACH_GLOBAL` or
    :py:obj:`~.CU_MEM_ATTACH_HOST`. If :py:obj:`~.CU_MEM_ATTACH_GLOBAL` is
    specified, then this memory is accessible from any stream on any
    device. If :py:obj:`~.CU_MEM_ATTACH_HOST` is specified, then the
    allocation should not be accessed from devices that have a zero value
    for the device attribute
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS`; an explicit
    call to :py:obj:`~.cuStreamAttachMemAsync` will be required to enable
    access on such devices.

    If the association is later changed via
    :py:obj:`~.cuStreamAttachMemAsync` to a single stream, the default
    association as specified during :py:obj:`~.cuMemAllocManaged` is
    restored when that stream is destroyed. For managed variables, the
    default association is always :py:obj:`~.CU_MEM_ATTACH_GLOBAL`. Note
    that destroying a stream is an asynchronous operation, and as a result,
    the change to default association won't happen until all work in the
    stream has completed.

    Memory allocated with :py:obj:`~.cuMemAllocManaged` should be released
    with :py:obj:`~.cuMemFree`.

    Device memory oversubscription is possible for GPUs that have a non-
    zero value for the device attribute
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS`. Managed
    memory on such GPUs may be evicted from device memory to host memory at
    any time by the Unified Memory driver in order to make room for other
    allocations.

    In a system where all GPUs have a non-zero value for the device
    attribute :py:obj:`~.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS`,
    managed memory may not be populated when this API returns and instead
    may be populated on access. In such systems, managed memory can migrate
    to any processor's memory at any time. The Unified Memory driver will
    employ heuristics to maintain data locality and prevent excessive page
    faults to the extent possible. The application can also guide the
    driver about memory usage patterns via :py:obj:`~.cuMemAdvise`. The
    application can also explicitly migrate memory to a desired processor's
    memory via :py:obj:`~.cuMemPrefetchAsync`.

    In a multi-GPU system where all of the GPUs have a zero value for the
    device attribute
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS` and all the
    GPUs have peer-to-peer support with each other, the physical storage
    for managed memory is created on the GPU which is active at the time
    :py:obj:`~.cuMemAllocManaged` is called. All other GPUs will reference
    the data at reduced bandwidth via peer mappings over the PCIe bus. The
    Unified Memory driver does not migrate memory among such GPUs.

    In a multi-GPU system where not all GPUs have peer-to-peer support with
    each other and where the value of the device attribute
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS` is zero for
    at least one of those GPUs, the location chosen for physical storage of
    managed memory is system-dependent.

    - On Linux, the location chosen will be device memory as long as the
      current set of active contexts are on devices that either have peer-
      to-peer support with each other or have a non-zero value for the
      device attribute
      :py:obj:`~.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS`. If there
      is an active context on a GPU that does not have a non-zero value for
      that device attribute and it does not have peer-to-peer support with
      the other devices that have active contexts on them, then the
      location for physical storage will be 'zero-copy' or host memory.
      Note that this means that managed memory that is located in device
      memory is migrated to host memory if a new context is created on a
      GPU that doesn't have a non-zero value for the device attribute and
      does not support peer-to-peer with at least one of the other devices
      that has an active context. This in turn implies that context
      creation may fail if there is insufficient host memory to migrate all
      managed allocations.

    - On Windows, the physical storage is always created in 'zero-copy' or
      host memory. All GPUs will reference the data at reduced bandwidth
      over the PCIe bus. In these circumstances, use of the environment
      variable CUDA_VISIBLE_DEVICES is recommended to restrict CUDA to only
      use those GPUs that have peer-to-peer support. Alternatively, users
      can also set CUDA_MANAGED_FORCE_DEVICE_ALLOC to a non-zero value to
      force the driver to always use device memory for physical storage.
      When this environment variable is set to a non-zero value, all
      contexts created in that process on devices that support managed
      memory have to be peer-to-peer compatible with each other. Context
      creation will fail if a context is created on a device that supports
      managed memory and is not peer-to-peer compatible with any of the
      other managed memory supporting devices on which contexts were
      previously created, even if those contexts have been destroyed. These
      environment variables are described in the CUDA programming guide
      under the "CUDA environment variables" section.

    - On ARM, managed memory is not available on discrete gpu with Drive
      PX-2.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes
    flags : unsigned int
        Must be one of :py:obj:`~.CU_MEM_ATTACH_GLOBAL` or
        :py:obj:`~.CU_MEM_ATTACH_HOST`

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`
    dptr : :py:obj:`~.CUdeviceptr`
        Returned device pointer

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuStreamAttachMemAsync`, :py:obj:`~.cudaMallocManaged`
    """
    cdef CUdeviceptr dptr = CUdeviceptr()
    with nogil:
        err = cydriver.cuMemAllocManaged(<cydriver.CUdeviceptr*>dptr._pvt_ptr, bytesize, flags)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], dptr)

ctypedef struct cuAsyncCallbackData_st:
    cydriver.CUasyncCallback callback
    void *userData

ctypedef cuAsyncCallbackData_st cuAsyncCallbackData

@cython.show_performance_hints(False)
cdef void cuAsyncNotificationCallbackWrapper(cydriver.CUasyncNotificationInfo *info, void *data, cydriver.CUasyncCallbackHandle handle) nogil:
    cdef cuAsyncCallbackData *cbData = <cuAsyncCallbackData *>data
    with gil:
        cbData.callback(info, cbData.userData, handle)

@cython.embedsignature(True)
def cuDeviceRegisterAsyncNotification(device, callbackFunc, userData):
    """ Registers a callback function to receive async notifications.

    Registers `callbackFunc` to receive async notifications.

    The `userData` parameter is passed to the callback function at async
    notification time.   Likewise, `callback` is also passed to the
    callback function to distinguish between multiple registered callbacks.

    The callback function being registered should be designed to return
    quickly (~10ms).   Any long running tasks should be queued for
    execution on an application thread.

    Callbacks may not call cuDeviceRegisterAsyncNotification or
    cuDeviceUnregisterAsyncNotification. Doing so will result in
    :py:obj:`~.CUDA_ERROR_NOT_PERMITTED`. Async notification callbacks
    execute in an undefined order and may be serialized.

    Returns in `*callback` a handle representing the registered callback
    instance.

    Parameters
    ----------
    device : :py:obj:`~.CUdevice`
        The device on which to register the callback
    callbackFunc : :py:obj:`~.CUasyncCallback`
        The function to register as a callback
    userData : Any
        A generic pointer to user data. This is passed into the callback
        function.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_PERMITTED`, :py:obj:`~.CUDA_ERROR_UNKNOWN`
    callback : :py:obj:`~.CUasyncCallbackHandle`
        A handle representing the registered callback instance

    See Also
    --------
    :py:obj:`~.cuDeviceUnregisterAsyncNotification`
    """
    cdef cydriver.CUasyncCallback cycallbackFunc
    if callbackFunc is None:
        pcallbackFunc = 0
    elif isinstance(callbackFunc, (CUasyncCallback,)):
        pcallbackFunc = int(callbackFunc)
    else:
        pcallbackFunc = int(CUasyncCallback(callbackFunc))
    cycallbackFunc = <cydriver.CUasyncCallback><void_ptr>pcallbackFunc
    cdef cydriver.CUdevice cydevice
    if device is None:
        pdevice = 0
    elif isinstance(device, (CUdevice,)):
        pdevice = int(device)
    else:
        pdevice = int(CUdevice(device))
    cydevice = <cydriver.CUdevice>pdevice
    cyuserData = _HelperInputVoidPtr(userData)
    cdef void* cyuserData_ptr = <void*><void_ptr>cyuserData.cptr

    cdef cuAsyncCallbackData *cbData = NULL
    cbData = <cuAsyncCallbackData *>malloc(sizeof(cbData[0]))
    if cbData == NULL:
        return (CUresult.CUDA_ERROR_OUT_OF_MEMORY, None)
    cbData.callback = cycallbackFunc
    cbData.userData = cyuserData_ptr

    cdef CUasyncCallbackHandle callback = CUasyncCallbackHandle()
    with nogil:
        err = cydriver.cuDeviceRegisterAsyncNotification(cydevice, <cydriver.CUasyncCallback>cuAsyncNotificationCallbackWrapper, <void *>cbData, <cydriver.CUasyncCallbackHandle*>callback._pvt_ptr)
    if err != cydriver.CUDA_SUCCESS:
        free(cbData)
    else:
        m_global._allocated[int(callback)] = cbData
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], callback)

@cython.embedsignature(True)
def cuDeviceUnregisterAsyncNotification(device, callback):
    """ Unregisters an async notification callback.

    Unregisters `callback` so that the corresponding callback function will
    stop receiving async notifications.

    Parameters
    ----------
    device : :py:obj:`~.CUdevice`
        The device from which to remove `callback`.
    callback : :py:obj:`~.CUasyncCallbackHandle`
        The callback instance to unregister from receiving async
        notifications.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_NOT_PERMITTED`, :py:obj:`~.CUDA_ERROR_UNKNOWN`

    See Also
    --------
    :py:obj:`~.cuDeviceRegisterAsyncNotification`
    """
    cdef cydriver.CUasyncCallbackHandle cycallback
    if callback is None:
        pcallback = 0
    elif isinstance(callback, (CUasyncCallbackHandle,)):
        pcallback = int(callback)
    else:
        pcallback = int(CUasyncCallbackHandle(callback))
    cycallback = <cydriver.CUasyncCallbackHandle><void_ptr>pcallback
    cdef cydriver.CUdevice cydevice
    if device is None:
        pdevice = 0
    elif isinstance(device, (CUdevice,)):
        pdevice = int(device)
    else:
        pdevice = int(CUdevice(device))
    cydevice = <cydriver.CUdevice>pdevice
    with nogil:
        err = cydriver.cuDeviceUnregisterAsyncNotification(cydevice, cycallback)
    if err == cydriver.CUDA_SUCCESS:
        free(m_global._allocated[pcallback])
        m_global._allocated.erase(<void_ptr>pcallback)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuDeviceGetByPCIBusId(char* pciBusId):
    """ Returns a handle to a compute device.

    Returns in `*device` a device handle given a PCI bus ID string.

    where `domain`, `bus`, `device`, and `function` are all hexadecimal
    values

    Parameters
    ----------
    pciBusId : bytes
        String in one of the following forms:

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    dev : :py:obj:`~.CUdevice`
        Returned device handle

    See Also
    --------
    :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetPCIBusId`, :py:obj:`~.cudaDeviceGetByPCIBusId`
    """
    cdef CUdevice dev = CUdevice()
    with nogil:
        err = cydriver.cuDeviceGetByPCIBusId(<cydriver.CUdevice*>dev._pvt_ptr, pciBusId)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], dev)

@cython.embedsignature(True)
def cuDeviceGetPCIBusId(int length, dev):
    """ Returns a PCI Bus Id string for the device.

    Returns an ASCII string identifying the device `dev` in the NULL-
    terminated string pointed to by `pciBusId`. `length` specifies the
    maximum length of the string that may be returned.

    where `domain`, `bus`, `device`, and `function` are all hexadecimal
    values. pciBusId should be large enough to store 13 characters
    including the NULL-terminator.

    Parameters
    ----------
    length : int
        Maximum length of string to store in `name`
    dev : :py:obj:`~.CUdevice`
        Device to get identifier string for

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_INVALID_DEVICE`
    pciBusId : bytes
        Returned identifier string for the device in the following format

    See Also
    --------
    :py:obj:`~.cuDeviceGet`, :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetByPCIBusId`, :py:obj:`~.cudaDeviceGetPCIBusId`
    """
    cdef cydriver.CUdevice cydev
    if dev is None:
        pdev = 0
    elif isinstance(dev, (CUdevice,)):
        pdev = int(dev)
    else:
        pdev = int(CUdevice(dev))
    cydev = <cydriver.CUdevice>pdev
    pypciBusId = b" " * length
    cdef char* pciBusId = pypciBusId
    with nogil:
        err = cydriver.cuDeviceGetPCIBusId(pciBusId, length, cydev)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pypciBusId)

@cython.embedsignature(True)
def cuIpcGetEventHandle(event):
    """ Gets an interprocess handle for a previously allocated event.

    Takes as input a previously allocated event. This event must have been
    created with the :py:obj:`~.CU_EVENT_INTERPROCESS` and
    :py:obj:`~.CU_EVENT_DISABLE_TIMING` flags set. This opaque handle may
    be copied into other processes and opened with
    :py:obj:`~.cuIpcOpenEventHandle` to allow efficient hardware
    synchronization between GPU work in different processes.

    After the event has been opened in the importing process,
    :py:obj:`~.cuEventRecord`, :py:obj:`~.cuEventSynchronize`,
    :py:obj:`~.cuStreamWaitEvent` and :py:obj:`~.cuEventQuery` may be used
    in either process. Performing operations on the imported event after
    the exported event has been freed with :py:obj:`~.cuEventDestroy` will
    result in undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cuDeviceGetAttribute` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED`

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event allocated with :py:obj:`~.CU_EVENT_INTERPROCESS` and
        :py:obj:`~.CU_EVENT_DISABLE_TIMING` flags.

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_MAP_FAILED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pHandle : :py:obj:`~.CUipcEventHandle`
        Pointer to a user allocated CUipcEventHandle in which to return the
        opaque event handle

    See Also
    --------
    :py:obj:`~.cuEventCreate`, :py:obj:`~.cuEventDestroy`, :py:obj:`~.cuEventSynchronize`, :py:obj:`~.cuEventQuery`, :py:obj:`~.cuStreamWaitEvent`, :py:obj:`~.cuIpcOpenEventHandle`, :py:obj:`~.cuIpcGetMemHandle`, :py:obj:`~.cuIpcOpenMemHandle`, :py:obj:`~.cuIpcCloseMemHandle`, :py:obj:`~.cudaIpcGetEventHandle`
    """
    cdef cydriver.CUevent cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (CUevent,)):
        pevent = int(event)
    else:
        pevent = int(CUevent(event))
    cyevent = <cydriver.CUevent><void_ptr>pevent
    cdef CUipcEventHandle pHandle = CUipcEventHandle()
    with nogil:
        err = cydriver.cuIpcGetEventHandle(<cydriver.CUipcEventHandle*>pHandle._pvt_ptr, cyevent)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pHandle)

@cython.embedsignature(True)
def cuIpcOpenEventHandle(handle not None : CUipcEventHandle):
    """ Opens an interprocess event handle for use in the current process.

    Opens an interprocess event handle exported from another process with
    :py:obj:`~.cuIpcGetEventHandle`. This function returns a
    :py:obj:`~.CUevent` that behaves like a locally created event with the
    :py:obj:`~.CU_EVENT_DISABLE_TIMING` flag specified. This event must be
    freed with :py:obj:`~.cuEventDestroy`.

    Performing operations on the imported event after the exported event
    has been freed with :py:obj:`~.cuEventDestroy` will result in undefined
    behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cuapiDeviceGetAttribute` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED`

    Parameters
    ----------
    handle : :py:obj:`~.CUipcEventHandle`
        Interprocess handle to open

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_MAP_FAILED`, :py:obj:`~.CUDA_ERROR_PEER_ACCESS_UNSUPPORTED`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    phEvent : :py:obj:`~.CUevent`
        Returns the imported event

    See Also
    --------
    :py:obj:`~.cuEventCreate`, :py:obj:`~.cuEventDestroy`, :py:obj:`~.cuEventSynchronize`, :py:obj:`~.cuEventQuery`, :py:obj:`~.cuStreamWaitEvent`, :py:obj:`~.cuIpcGetEventHandle`, :py:obj:`~.cuIpcGetMemHandle`, :py:obj:`~.cuIpcOpenMemHandle`, :py:obj:`~.cuIpcCloseMemHandle`, :py:obj:`~.cudaIpcOpenEventHandle`
    """
    cdef CUevent phEvent = CUevent()
    with nogil:
        err = cydriver.cuIpcOpenEventHandle(<cydriver.CUevent*>phEvent._pvt_ptr, handle._pvt_ptr[0])
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], phEvent)

@cython.embedsignature(True)
def cuIpcGetMemHandle(dptr):
    """ Gets an interprocess memory handle for an existing device memory allocation.

    Takes a pointer to the base of an existing device memory allocation
    created with :py:obj:`~.cuMemAlloc` and exports it for use in another
    process. This is a lightweight operation and may be called multiple
    times on an allocation without adverse effects.

    If a region of memory is freed with :py:obj:`~.cuMemFree` and a
    subsequent call to :py:obj:`~.cuMemAlloc` returns memory with the same
    device address, :py:obj:`~.cuIpcGetMemHandle` will return a unique
    handle for the new memory.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cuapiDeviceGetAttribute` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED`

    Parameters
    ----------
    dptr : :py:obj:`~.CUdeviceptr`
        Base pointer to previously allocated device memory

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_MAP_FAILED`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pHandle : :py:obj:`~.CUipcMemHandle`
        Pointer to user allocated :py:obj:`~.CUipcMemHandle` to return the
        handle in.

    See Also
    --------
    :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuIpcGetEventHandle`, :py:obj:`~.cuIpcOpenEventHandle`, :py:obj:`~.cuIpcOpenMemHandle`, :py:obj:`~.cuIpcCloseMemHandle`, :py:obj:`~.cudaIpcGetMemHandle`
    """
    cdef cydriver.CUdeviceptr cydptr
    if dptr is None:
        pdptr = 0
    elif isinstance(dptr, (CUdeviceptr,)):
        pdptr = int(dptr)
    else:
        pdptr = int(CUdeviceptr(dptr))
    cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
    cdef CUipcMemHandle pHandle = CUipcMemHandle()
    with nogil:
        err = cydriver.cuIpcGetMemHandle(<cydriver.CUipcMemHandle*>pHandle._pvt_ptr, cydptr)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pHandle)

@cython.embedsignature(True)
def cuIpcOpenMemHandle(handle not None : CUipcMemHandle, unsigned int Flags):
    """ Opens an interprocess memory handle exported from another process and returns a device pointer usable in the local process.

    Maps memory exported from another process with
    :py:obj:`~.cuIpcGetMemHandle` into the current device address space.
    For contexts on different devices :py:obj:`~.cuIpcOpenMemHandle` can
    attempt to enable peer access between the devices as if the user called
    :py:obj:`~.cuCtxEnablePeerAccess`. This behavior is controlled by the
    :py:obj:`~.CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS` flag.
    :py:obj:`~.cuDeviceCanAccessPeer` can determine if a mapping is
    possible.

    Contexts that may open :py:obj:`~.CUipcMemHandles` are restricted in
    the following way. :py:obj:`~.CUipcMemHandles` from each
    :py:obj:`~.CUdevice` in a given process may only be opened by one
    :py:obj:`~.CUcontext` per :py:obj:`~.CUdevice` per other process.

    If the memory handle has already been opened by the current context,
    the reference count on the handle is incremented by 1 and the existing
    device pointer is returned.

    Memory returned from :py:obj:`~.cuIpcOpenMemHandle` must be freed with
    :py:obj:`~.cuIpcCloseMemHandle`.

    Calling :py:obj:`~.cuMemFree` on an exported memory region before
    calling :py:obj:`~.cuIpcCloseMemHandle` in the importing context will
    result in undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cuapiDeviceGetAttribute` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED`

    Parameters
    ----------
    handle : :py:obj:`~.CUipcMemHandle`
        :py:obj:`~.CUipcMemHandle` to open
    Flags : unsigned int
        Flags for this operation. Must be specified as
        :py:obj:`~.CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS`

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_MAP_FAILED`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_TOO_MANY_PEERS`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`
    pdptr : :py:obj:`~.CUdeviceptr`
        Returned device pointer

    See Also
    --------
    :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuIpcGetEventHandle`, :py:obj:`~.cuIpcOpenEventHandle`, :py:obj:`~.cuIpcGetMemHandle`, :py:obj:`~.cuIpcCloseMemHandle`, :py:obj:`~.cuCtxEnablePeerAccess`, :py:obj:`~.cuDeviceCanAccessPeer`, :py:obj:`~.cudaIpcOpenMemHandle`

    Notes
    -----
    No guarantees are made about the address returned in `*pdptr`. In particular, multiple processes may not receive the same address for the same `handle`.
    """
    cdef CUdeviceptr pdptr = CUdeviceptr()
    with nogil:
        err = cydriver.cuIpcOpenMemHandle(<cydriver.CUdeviceptr*>pdptr._pvt_ptr, handle._pvt_ptr[0], Flags)
    if err != cydriver.CUDA_SUCCESS:
        return (_dict_CUresult[err], None)
    return (_dict_CUresult[err], pdptr)

@cython.embedsignature(True)
def cuIpcCloseMemHandle(dptr):
    """ Attempts to close memory mapped with :py:obj:`~.cuIpcOpenMemHandle`.

    Decrements the reference count of the memory returned by
    :py:obj:`~.cuIpcOpenMemHandle` by 1. When the reference count reaches
    0, this API unmaps the memory. The original allocation in the exporting
    process as well as imported mappings in other processes will be
    unaffected.

    Any resources used to enable peer access will be freed if this is the
    last mapping using them.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cuapiDeviceGetAttribute` with
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_IPC_EVENT_SUPPORTED`

    Parameters
    ----------
    dptr : :py:obj:`~.CUdeviceptr`
        Device pointer returned by :py:obj:`~.cuIpcOpenMemHandle`

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_MAP_FAILED`, :py:obj:`~.CUDA_ERROR_INVALID_HANDLE`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuIpcGetEventHandle`, :py:obj:`~.cuIpcOpenEventHandle`, :py:obj:`~.cuIpcGetMemHandle`, :py:obj:`~.cuIpcOpenMemHandle`, :py:obj:`~.cudaIpcCloseMemHandle`
    """
    cdef cydriver.CUdeviceptr cydptr
    if dptr is None:
        pdptr = 0
    elif isinstance(dptr, (CUdeviceptr,)):
        pdptr = int(dptr)
    else:
        pdptr = int(CUdeviceptr(dptr))
    cydptr = <cydriver.CUdeviceptr><void_ptr>pdptr
    with nogil:
        err = cydriver.cuIpcCloseMemHandle(cydptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemHostRegister(p, size_t bytesize, unsigned int Flags):
    """ Registers an existing host memory range for use by CUDA.

    Page-locks the memory range specified by `p` and `bytesize` and maps it
    for the device(s) as specified by `Flags`. This memory range also is
    added to the same tracking mechanism as :py:obj:`~.cuMemHostAlloc` to
    automatically accelerate calls to functions such as
    :py:obj:`~.cuMemcpyHtoD()`. Since the memory can be accessed directly
    by the device, it can be read or written with much higher bandwidth
    than pageable memory that has not been registered. Page-locking
    excessive amounts of memory may degrade system performance, since it
    reduces the amount of memory available to the system for paging. As a
    result, this function is best used sparingly to register staging areas
    for data exchange between host and device.

    On systems where
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES`
    is true, :py:obj:`~.cuMemHostRegister` will not page-lock the memory
    range specified by `ptr` but only populate unpopulated pages.

    The `Flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.CU_MEMHOSTREGISTER_PORTABLE`: The memory returned by this
      call will be considered as pinned memory by all CUDA contexts, not
      just the one that performed the allocation.

    - :py:obj:`~.CU_MEMHOSTREGISTER_DEVICEMAP`: Maps the allocation into
      the CUDA address space. The device pointer to the memory may be
      obtained by calling :py:obj:`~.cuMemHostGetDevicePointer()`.

    - :py:obj:`~.CU_MEMHOSTREGISTER_IOMEMORY`: The pointer is treated as
      pointing to some I/O memory space, e.g. the PCI Express resource of a
      3rd party device.

    - :py:obj:`~.CU_MEMHOSTREGISTER_READ_ONLY`: The pointer is treated as
      pointing to memory that is considered read-only by the device. On
      platforms without
      :py:obj:`~.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES`,
      this flag is required in order to register memory mapped to the CPU
      as read-only. Support for the use of this flag can be queried from
      the device attribute
      :py:obj:`~.CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED`.
      Using this flag with a current context associated with a device that
      does not have this attribute set will cause
      :py:obj:`~.cuMemHostRegister` to error with CUDA_ERROR_NOT_SUPPORTED.

    All of these flags are orthogonal to one another: a developer may page-
    lock memory that is portable or mapped with no restrictions.

    The :py:obj:`~.CU_MEMHOSTREGISTER_DEVICEMAP` flag may be specified on
    CUDA contexts for devices that do not support mapped pinned memory. The
    failure is deferred to :py:obj:`~.cuMemHostGetDevicePointer()` because
    the memory may be mapped into other CUDA contexts via the
    :py:obj:`~.CU_MEMHOSTREGISTER_PORTABLE` flag.

    For devices that have a non-zero value for the device attribute
    :py:obj:`~.CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM`,
    the memory can also be accessed from the device using the host pointer
    `p`. The device pointer returned by
    :py:obj:`~.cuMemHostGetDevicePointer()` may or may not match the
    original host pointer `ptr` and depends on the devices visible to the
    application. If all devices visible to the application have a non-zero
    value for the device attribute, the device pointer returned by
    :py:obj:`~.cuMemHostGetDevicePointer()` will match the original pointer
    `ptr`. If any device visible to the application has a zero value for
    the device attribute, the device pointer returned by
    :py:obj:`~.cuMemHostGetDevicePointer()` will not match the original
    host pointer `ptr`, but it will be suitable for use on all devices
    provided Unified Virtual Addressing is enabled. In such systems, it is
    valid to access the memory using either pointer on devices that have a
    non-zero value for the device attribute. Note however that such devices
    should access the memory using only of the two pointers and not both.

    The memory page-locked by this function must be unregistered with
    :py:obj:`~.cuMemHostUnregister()`.

    Parameters
    ----------
    p : Any
        Host pointer to memory to page-lock
    bytesize : size_t
        Size in bytes of the address range to page-lock
    Flags : unsigned int
        Flags for allocation request

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED`, :py:obj:`~.CUDA_ERROR_NOT_PERMITTED`, :py:obj:`~.CUDA_ERROR_NOT_SUPPORTED`

    See Also
    --------
    :py:obj:`~.cuMemHostUnregister`, :py:obj:`~.cuMemHostGetFlags`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cudaHostRegister`
    """
    cyp = _HelperInputVoidPtr(p)
    cdef void* cyp_ptr = <void*><void_ptr>cyp.cptr
    with nogil:
        err = cydriver.cuMemHostRegister(cyp_ptr, bytesize, Flags)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemHostUnregister(p):
    """ Unregisters a memory range that was registered with cuMemHostRegister.

    Unmaps the memory range whose base address is specified by `p`, and
    makes it pageable again.

    The base address must be the same one specified to
    :py:obj:`~.cuMemHostRegister()`.

    Parameters
    ----------
    p : Any
        Host pointer to memory to unregister

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`, :py:obj:`~.CUDA_ERROR_OUT_OF_MEMORY`, :py:obj:`~.CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED`,

    See Also
    --------
    :py:obj:`~.cuMemHostRegister`, :py:obj:`~.cudaHostUnregister`
    """
    cyp = _HelperInputVoidPtr(p)
    cdef void* cyp_ptr = <void*><void_ptr>cyp.cptr
    with nogil:
        err = cydriver.cuMemHostUnregister(cyp_ptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpy(dst, src, size_t ByteCount):
    """ Copies memory.

    Copies data between two pointers. `dst` and `src` are base pointers of
    the destination and source, respectively. `ByteCount` specifies the
    number of bytes to copy. Note that this function infers the type of the
    transfer (host to host, host to device, device to device, or device to
    host) from the pointer values. This function is only allowed in
    contexts which support unified addressing.

    Parameters
    ----------
    dst : :py:obj:`~.CUdeviceptr`
        Destination unified virtual address space pointer
    src : :py:obj:`~.CUdeviceptr`
        Source unified virtual address space pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`
    """
    cdef cydriver.CUdeviceptr cysrc
    if src is None:
        psrc = 0
    elif isinstance(src, (CUdeviceptr,)):
        psrc = int(src)
    else:
        psrc = int(CUdeviceptr(src))
    cysrc = <cydriver.CUdeviceptr><void_ptr>psrc
    cdef cydriver.CUdeviceptr cydst
    if dst is None:
        pdst = 0
    elif isinstance(dst, (CUdeviceptr,)):
        pdst = int(dst)
    else:
        pdst = int(CUdeviceptr(dst))
    cydst = <cydriver.CUdeviceptr><void_ptr>pdst
    with nogil:
        err = cydriver.cuMemcpy(cydst, cysrc, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyPeer(dstDevice, dstContext, srcDevice, srcContext, size_t ByteCount):
    """ Copies device memory between two contexts.

    Copies from device memory in one context to device memory in another
    context. `dstDevice` is the base device pointer of the destination
    memory and `dstContext` is the destination context. `srcDevice` is the
    base device pointer of the source memory and `srcContext` is the source
    pointer. `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : :py:obj:`~.CUdeviceptr`
        Destination device pointer
    dstContext : :py:obj:`~.CUcontext`
        Destination context
    srcDevice : :py:obj:`~.CUdeviceptr`
        Source device pointer
    srcContext : :py:obj:`~.CUcontext`
        Source context
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpy3DPeer`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyPeerAsync`, :py:obj:`~.cuMemcpy3DPeerAsync`, :py:obj:`~.cudaMemcpyPeer`
    """
    cdef cydriver.CUcontext cysrcContext
    if srcContext is None:
        psrcContext = 0
    elif isinstance(srcContext, (CUcontext,)):
        psrcContext = int(srcContext)
    else:
        psrcContext = int(CUcontext(srcContext))
    cysrcContext = <cydriver.CUcontext><void_ptr>psrcContext
    cdef cydriver.CUdeviceptr cysrcDevice
    if srcDevice is None:
        psrcDevice = 0
    elif isinstance(srcDevice, (CUdeviceptr,)):
        psrcDevice = int(srcDevice)
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
    cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
    cdef cydriver.CUcontext cydstContext
    if dstContext is None:
        pdstContext = 0
    elif isinstance(dstContext, (CUcontext,)):
        pdstContext = int(dstContext)
    else:
        pdstContext = int(CUcontext(dstContext))
    cydstContext = <cydriver.CUcontext><void_ptr>pdstContext
    cdef cydriver.CUdeviceptr cydstDevice
    if dstDevice is None:
        pdstDevice = 0
    elif isinstance(dstDevice, (CUdeviceptr,)):
        pdstDevice = int(dstDevice)
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
    cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
    with nogil:
        err = cydriver.cuMemcpyPeer(cydstDevice, cydstContext, cysrcDevice, cysrcContext, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyHtoD(dstDevice, srcHost, size_t ByteCount):
    """ Copies memory from Host to Device.

    Copies from host memory to device memory. `dstDevice` and `srcHost` are
    the base addresses of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : :py:obj:`~.CUdeviceptr`
        Destination device pointer
    srcHost : Any
        Source host pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyToSymbol`
    """
    cdef cydriver.CUdeviceptr cydstDevice
    if dstDevice is None:
        pdstDevice = 0
    elif isinstance(dstDevice, (CUdeviceptr,)):
        pdstDevice = int(dstDevice)
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
    cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
    cysrcHost = _HelperInputVoidPtr(srcHost)
    cdef void* cysrcHost_ptr = <void*><void_ptr>cysrcHost.cptr
    with nogil:
        err = cydriver.cuMemcpyHtoD(cydstDevice, cysrcHost_ptr, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyDtoH(dstHost, srcDevice, size_t ByteCount):
    """ Copies memory from Device to Host.

    Copies from device to host memory. `dstHost` and `srcDevice` specify
    the base pointers of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstHost : Any
        Destination host pointer
    srcDevice : :py:obj:`~.CUdeviceptr`
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyFromSymbol`
    """
    cdef cydriver.CUdeviceptr cysrcDevice
    if srcDevice is None:
        psrcDevice = 0
    elif isinstance(srcDevice, (CUdeviceptr,)):
        psrcDevice = int(srcDevice)
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
    cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
    cydstHost = _HelperInputVoidPtr(dstHost)
    cdef void* cydstHost_ptr = <void*><void_ptr>cydstHost.cptr
    with nogil:
        err = cydriver.cuMemcpyDtoH(cydstHost_ptr, cysrcDevice, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyDtoD(dstDevice, srcDevice, size_t ByteCount):
    """ Copies memory from Device to Device.

    Copies from device memory to device memory. `dstDevice` and `srcDevice`
    are the base pointers of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : :py:obj:`~.CUdeviceptr`
        Destination device pointer
    srcDevice : :py:obj:`~.CUdeviceptr`
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`
    """
    cdef cydriver.CUdeviceptr cysrcDevice
    if srcDevice is None:
        psrcDevice = 0
    elif isinstance(srcDevice, (CUdeviceptr,)):
        psrcDevice = int(srcDevice)
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
    cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
    cdef cydriver.CUdeviceptr cydstDevice
    if dstDevice is None:
        pdstDevice = 0
    elif isinstance(dstDevice, (CUdeviceptr,)):
        pdstDevice = int(dstDevice)
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
    cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
    with nogil:
        err = cydriver.cuMemcpyDtoD(cydstDevice, cysrcDevice, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyDtoA(dstArray, size_t dstOffset, srcDevice, size_t ByteCount):
    """ Copies memory from Device to Array.

    Copies from device memory to a 1D CUDA array. `dstArray` and
    `dstOffset` specify the CUDA array handle and starting index of the
    destination data. `srcDevice` specifies the base pointer of the source.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstArray : :py:obj:`~.CUarray`
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcDevice : :py:obj:`~.CUdeviceptr`
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpyToArray`
    """
    cdef cydriver.CUdeviceptr cysrcDevice
    if srcDevice is None:
        psrcDevice = 0
    elif isinstance(srcDevice, (CUdeviceptr,)):
        psrcDevice = int(srcDevice)
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
    cysrcDevice = <cydriver.CUdeviceptr><void_ptr>psrcDevice
    cdef cydriver.CUarray cydstArray
    if dstArray is None:
        pdstArray = 0
    elif isinstance(dstArray, (CUarray,)):
        pdstArray = int(dstArray)
    else:
        pdstArray = int(CUarray(dstArray))
    cydstArray = <cydriver.CUarray><void_ptr>pdstArray
    with nogil:
        err = cydriver.cuMemcpyDtoA(cydstArray, dstOffset, cysrcDevice, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyAtoD(dstDevice, srcArray, size_t srcOffset, size_t ByteCount):
    """ Copies memory from Array to Device.

    Copies from one 1D CUDA array to device memory. `dstDevice` specifies
    the base pointer of the destination and must be naturally aligned with
    the CUDA array elements. `srcArray` and `srcOffset` specify the CUDA
    array handle and the offset in bytes into the array where the copy is
    to begin. `ByteCount` specifies the number of bytes to copy and must be
    evenly divisible by the array element size.

    Parameters
    ----------
    dstDevice : :py:obj:`~.CUdeviceptr`
        Destination device pointer
    srcArray : :py:obj:`~.CUarray`
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpyFromArray`
    """
    cdef cydriver.CUarray cysrcArray
    if srcArray is None:
        psrcArray = 0
    elif isinstance(srcArray, (CUarray,)):
        psrcArray = int(srcArray)
    else:
        psrcArray = int(CUarray(srcArray))
    cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
    cdef cydriver.CUdeviceptr cydstDevice
    if dstDevice is None:
        pdstDevice = 0
    elif isinstance(dstDevice, (CUdeviceptr,)):
        pdstDevice = int(dstDevice)
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
    cydstDevice = <cydriver.CUdeviceptr><void_ptr>pdstDevice
    with nogil:
        err = cydriver.cuMemcpyAtoD(cydstDevice, cysrcArray, srcOffset, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyHtoA(dstArray, size_t dstOffset, srcHost, size_t ByteCount):
    """ Copies memory from Host to Array.

    Copies from host memory to a 1D CUDA array. `dstArray` and `dstOffset`
    specify the CUDA array handle and starting offset in bytes of the
    destination data. `pSrc` specifies the base address of the source.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstArray : :py:obj:`~.CUarray`
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcHost : Any
        Source host pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpyToArray`
    """
    cdef cydriver.CUarray cydstArray
    if dstArray is None:
        pdstArray = 0
    elif isinstance(dstArray, (CUarray,)):
        pdstArray = int(dstArray)
    else:
        pdstArray = int(CUarray(dstArray))
    cydstArray = <cydriver.CUarray><void_ptr>pdstArray
    cysrcHost = _HelperInputVoidPtr(srcHost)
    cdef void* cysrcHost_ptr = <void*><void_ptr>cysrcHost.cptr
    with nogil:
        err = cydriver.cuMemcpyHtoA(cydstArray, dstOffset, cysrcHost_ptr, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyAtoH(dstHost, srcArray, size_t srcOffset, size_t ByteCount):
    """ Copies memory from Array to Host.

    Copies from one 1D CUDA array to host memory. `dstHost` specifies the
    base pointer of the destination. `srcArray` and `srcOffset` specify the
    CUDA array handle and starting offset in bytes of the source data.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstHost : Any
        Destination device pointer
    srcArray : :py:obj:`~.CUarray`
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpyFromArray`
    """
    cdef cydriver.CUarray cysrcArray
    if srcArray is None:
        psrcArray = 0
    elif isinstance(srcArray, (CUarray,)):
        psrcArray = int(srcArray)
    else:
        psrcArray = int(CUarray(srcArray))
    cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
    cydstHost = _HelperInputVoidPtr(dstHost)
    cdef void* cydstHost_ptr = <void*><void_ptr>cydstHost.cptr
    with nogil:
        err = cydriver.cuMemcpyAtoH(cydstHost_ptr, cysrcArray, srcOffset, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpyAtoA(dstArray, size_t dstOffset, srcArray, size_t srcOffset, size_t ByteCount):
    """ Copies memory from Array to Array.

    Copies from one 1D CUDA array to another. `dstArray` and `srcArray`
    specify the handles of the destination and source CUDA arrays for the
    copy, respectively. `dstOffset` and `srcOffset` specify the destination
    and source offsets in bytes into the CUDA arrays. `ByteCount` is the
    number of bytes to be copied. The size of the elements in the CUDA
    arrays need not be the same format, but the elements must be the same
    size; and count must be evenly divisible by that size.

    Parameters
    ----------
    dstArray : :py:obj:`~.CUarray`
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcArray : :py:obj:`~.CUarray`
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpyArrayToArray`
    """
    cdef cydriver.CUarray cysrcArray
    if srcArray is None:
        psrcArray = 0
    elif isinstance(srcArray, (CUarray,)):
        psrcArray = int(srcArray)
    else:
        psrcArray = int(CUarray(srcArray))
    cysrcArray = <cydriver.CUarray><void_ptr>psrcArray
    cdef cydriver.CUarray cydstArray
    if dstArray is None:
        pdstArray = 0
    elif isinstance(dstArray, (CUarray,)):
        pdstArray = int(dstArray)
    else:
        pdstArray = int(CUarray(dstArray))
    cydstArray = <cydriver.CUarray><void_ptr>pdstArray
    with nogil:
        err = cydriver.cuMemcpyAtoA(cydstArray, dstOffset, cysrcArray, srcOffset, ByteCount)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpy2D(pCopy : Optional[CUDA_MEMCPY2D]):
    """ Copies memory for 2D arrays.

    Perform a 2D memory copy according to the parameters specified in
    `pCopy`. The :py:obj:`~.CUDA_MEMCPY2D` structure is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    where:

    - :py:obj:`~.srcMemoryType` and :py:obj:`~.dstMemoryType` specify the
      type of memory of the source and destination, respectively;
      :py:obj:`~.CUmemorytype_enum` is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    If :py:obj:`~.srcMemoryType` is :py:obj:`~.CU_MEMORYTYPE_UNIFIED`,
    :py:obj:`~.srcDevice` and :py:obj:`~.srcPitch` specify the (unified
    virtual address space) base address of the source data and the bytes
    per row to apply. :py:obj:`~.srcArray` is ignored. This value may be
    used only if unified addressing is supported in the calling context.

    If :py:obj:`~.srcMemoryType` is :py:obj:`~.CU_MEMORYTYPE_HOST`,
    :py:obj:`~.srcHost` and :py:obj:`~.srcPitch` specify the (host) base
    address of the source data and the bytes per row to apply.
    :py:obj:`~.srcArray` is ignored.

    If :py:obj:`~.srcMemoryType` is :py:obj:`~.CU_MEMORYTYPE_DEVICE`,
    :py:obj:`~.srcDevice` and :py:obj:`~.srcPitch` specify the (device)
    base address of the source data and the bytes per row to apply.
    :py:obj:`~.srcArray` is ignored.

    If :py:obj:`~.srcMemoryType` is :py:obj:`~.CU_MEMORYTYPE_ARRAY`,
    :py:obj:`~.srcArray` specifies the handle of the source data.
    :py:obj:`~.srcHost`, :py:obj:`~.srcDevice` and :py:obj:`~.srcPitch` are
    ignored.

    If :py:obj:`~.dstMemoryType` is :py:obj:`~.CU_MEMORYTYPE_HOST`,
    :py:obj:`~.dstHost` and :py:obj:`~.dstPitch` specify the (host) base
    address of the destination data and the bytes per row to apply.
    :py:obj:`~.dstArray` is ignored.

    If :py:obj:`~.dstMemoryType` is :py:obj:`~.CU_MEMORYTYPE_UNIFIED`,
    :py:obj:`~.dstDevice` and :py:obj:`~.dstPitch` specify the (unified
    virtual address space) base address of the source data and the bytes
    per row to apply. :py:obj:`~.dstArray` is ignored. This value may be
    used only if unified addressing is supported in the calling context.

    If :py:obj:`~.dstMemoryType` is :py:obj:`~.CU_MEMORYTYPE_DEVICE`,
    :py:obj:`~.dstDevice` and :py:obj:`~.dstPitch` specify the (device)
    base address of the destination data and the bytes per row to apply.
    :py:obj:`~.dstArray` is ignored.

    If :py:obj:`~.dstMemoryType` is :py:obj:`~.CU_MEMORYTYPE_ARRAY`,
    :py:obj:`~.dstArray` specifies the handle of the destination data.
    :py:obj:`~.dstHost`, :py:obj:`~.dstDevice` and :py:obj:`~.dstPitch` are
    ignored.

    - :py:obj:`~.srcXInBytes` and :py:obj:`~.srcY` specify the base address
      of the source data for the copy.

    For host pointers, the starting address is

    **View CUDA Toolkit Documentation for a C++ code example**

    For device pointers, the starting address is

    **View CUDA Toolkit Documentation for a C++ code example**

    For CUDA arrays, :py:obj:`~.srcXInBytes` must be evenly divisible by
    the array element size.

    - :py:obj:`~.dstXInBytes` and :py:obj:`~.dstY` specify the base address
      of the destination data for the copy.

    For host pointers, the base address is

    **View CUDA Toolkit Documentation for a C++ code example**

    For device pointers, the starting address is

    **View CUDA Toolkit Documentation for a C++ code example**

    For CUDA arrays, :py:obj:`~.dstXInBytes` must be evenly divisible by
    the array element size.

    - :py:obj:`~.WidthInBytes` and :py:obj:`~.Height` specify the width (in
      bytes) and height of the 2D copy being performed.

    - If specified, :py:obj:`~.srcPitch` must be greater than or equal to
      :py:obj:`~.WidthInBytes` + :py:obj:`~.srcXInBytes`, and
      :py:obj:`~.dstPitch` must be greater than or equal to
      :py:obj:`~.WidthInBytes` + dstXInBytes.

    :py:obj:`~.cuMemcpy2D()` returns an error if any pitch is greater than
    the maximum allowed (:py:obj:`~.CU_DEVICE_ATTRIBUTE_MAX_PITCH`).
    :py:obj:`~.cuMemAllocPitch()` passes back pitches that always work with
    :py:obj:`~.cuMemcpy2D()`. On intra-device memory copies (device to
    device, CUDA array to device, CUDA array to CUDA array),
    :py:obj:`~.cuMemcpy2D()` may fail for pitches not computed by
    :py:obj:`~.cuMemAllocPitch()`. :py:obj:`~.cuMemcpy2DUnaligned()` does
    not have this restriction, but may run significantly slower in the
    cases where :py:obj:`~.cuMemcpy2D()` would have returned an error code.

    Parameters
    ----------
    pCopy : :py:obj:`~.CUDA_MEMCPY2D`
        Parameters for the memory copy

    Returns
    -------
    CUresult
        :py:obj:`~.CUDA_SUCCESS`, :py:obj:`~.CUDA_ERROR_DEINITIALIZED`, :py:obj:`~.CUDA_ERROR_NOT_INITIALIZED`, :py:obj:`~.CUDA_ERROR_INVALID_CONTEXT`, :py:obj:`~.CUDA_ERROR_INVALID_VALUE`

    See Also
    --------
    :py:obj:`~.cuArray3DCreate`, :py:obj:`~.cuArray3DGetDescriptor`, :py:obj:`~.cuArrayCreate`, :py:obj:`~.cuArrayDestroy`, :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuMemAlloc`, :py:obj:`~.cuMemAllocHost`, :py:obj:`~.cuMemAllocPitch`, :py:obj:`~.cuMemcpy2DAsync`, :py:obj:`~.cuMemcpy2DUnaligned`, :py:obj:`~.cuMemcpy3D`, :py:obj:`~.cuMemcpy3DAsync`, :py:obj:`~.cuMemcpyAtoA`, :py:obj:`~.cuMemcpyAtoD`, :py:obj:`~.cuMemcpyAtoH`, :py:obj:`~.cuMemcpyAtoHAsync`, :py:obj:`~.cuMemcpyDtoA`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpyDtoDAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoA`, :py:obj:`~.cuMemcpyHtoAAsync`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemFree`, :py:obj:`~.cuMemFreeHost`, :py:obj:`~.cuMemGetAddressRange`, :py:obj:`~.cuMemGetInfo`, :py:obj:`~.cuMemHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`, :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`
    """
    cdef cydriver.CUDA_MEMCPY2D* cypCopy_ptr = pCopy._pvt_ptr if pCopy is not None else NULL
    with nogil:
        err = cydriver.cuMemcpy2D(cypCopy_ptr)
    return (_dict_CUresult[err],)

@cython.embedsignature(True)
def cuMemcpy2DUnaligned(pCopy : Optional[CUDA_MEMCPY2D]):
  