// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityTool The vulnerability tool.
type VulnerabilityTool string

// List of VulnerabilityTool.
const (
	VULNERABILITYTOOL_IAST  VulnerabilityTool = "IAST"
	VULNERABILITYTOOL_SCA   VulnerabilityTool = "SCA"
	VULNERABILITYTOOL_INFRA VulnerabilityTool = "Infra"
)

var allowedVulnerabilityToolEnumValues = []VulnerabilityTool{
	VULNERABILITYTOOL_IAST,
	VULNERABILITYTOOL_SCA,
	VULNERABILITYTOOL_INFRA,
}

// GetAllowedValues reeturns the list of possible values.
func (v *VulnerabilityTool) GetAllowedValues() []VulnerabilityTool {
	return allowedVulnerabilityToolEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *VulnerabilityTool) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = VulnerabilityTool(value)
	return nil
}

// NewVulnerabilityToolFromValue returns a pointer to a valid VulnerabilityTool
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewVulnerabilityToolFromValue(v string) (*VulnerabilityTool, error) {
	ev := VulnerabilityTool(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for VulnerabilityTool: valid values are %v", v, allowedVulnerabilityToolEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v VulnerabilityTool) IsValid() bool {
	for _, existing := range allowedVulnerabilityToolEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to VulnerabilityTool value.
func (v VulnerabilityTool) Ptr() *VulnerabilityTool {
	return &v
}
