// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a data migration using the provided settings.
func (c *Client) CreateDataMigration(ctx context.Context, params *CreateDataMigrationInput, optFns ...func(*Options)) (*CreateDataMigrationOutput, error) {
	if params == nil {
		params = &CreateDataMigrationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataMigration", params, optFns, c.addOperationCreateDataMigrationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataMigrationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataMigrationInput struct {

	// Specifies if the data migration is full-load only, change data capture (CDC)
	// only, or full-load and CDC.
	//
	// This member is required.
	DataMigrationType types.MigrationTypeValue

	// An identifier for the migration project.
	//
	// This member is required.
	MigrationProjectIdentifier *string

	// The Amazon Resource Name (ARN) for the service access role that you want to use
	// to create the data migration.
	//
	// This member is required.
	ServiceAccessRoleArn *string

	// A user-friendly name for the data migration. Data migration names have the
	// following constraints:
	//
	//   - Must begin with a letter, and can only contain ASCII letters, digits, and
	//   hyphens.
	//
	//   - Can't end with a hyphen or contain two consecutive hyphens.
	//
	//   - Length must be from 1 to 255 characters.
	DataMigrationName *string

	// Specifies whether to enable CloudWatch logs for the data migration.
	EnableCloudwatchLogs *bool

	// The number of parallel jobs that trigger parallel threads to unload the tables
	// from the source, and then load them to the target.
	NumberOfJobs *int32

	// An optional JSON string specifying what tables, views, and schemas to include
	// or exclude from the migration.
	SelectionRules *string

	// Specifies information about the source data provider.
	SourceDataSettings []types.SourceDataSetting

	// One or more tags to be assigned to the data migration.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateDataMigrationOutput struct {

	// Information about the created data migration.
	DataMigration *types.DataMigration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataMigrationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDataMigration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDataMigration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataMigration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataMigrationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataMigration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataMigration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataMigration",
	}
}
