// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package watcher

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfDebugWatchInfoT struct {
	_       structs.HostLayout
	Flags   uint64
	Payload uint64
}

// LoadBpfDebug returns the embedded CollectionSpec for BpfDebug.
func LoadBpfDebug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfDebugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load BpfDebug: %w", err)
	}

	return spec, err
}

// LoadBpfDebugObjects loads BpfDebug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfDebugObjects
//	*BpfDebugPrograms
//	*BpfDebugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfDebugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpfDebug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfDebugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugSpecs struct {
	BpfDebugProgramSpecs
	BpfDebugMapSpecs
	BpfDebugVariableSpecs
}

// BpfDebugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugProgramSpecs struct {
	ObiKprobeSysBind *ebpf.ProgramSpec `ebpf:"obi_kprobe_sys_bind"`
}

// BpfDebugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugMapSpecs struct {
	DebugEvents *ebpf.MapSpec `ebpf:"debug_events"`
	WatchEvents *ebpf.MapSpec `ebpf:"watch_events"`
}

// BpfDebugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugVariableSpecs struct {
	Ip4ip6Prefix *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.VariableSpec `ebpf:"unused"`
	Unused2      *ebpf.VariableSpec `ebpf:"unused_2"`
	UnusedHttp2  *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// BpfDebugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugObjects struct {
	BpfDebugPrograms
	BpfDebugMaps
	BpfDebugVariables
}

func (o *BpfDebugObjects) Close() error {
	return _BpfDebugClose(
		&o.BpfDebugPrograms,
		&o.BpfDebugMaps,
	)
}

// BpfDebugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugMaps struct {
	DebugEvents *ebpf.Map `ebpf:"debug_events"`
	WatchEvents *ebpf.Map `ebpf:"watch_events"`
}

func (m *BpfDebugMaps) Close() error {
	return _BpfDebugClose(
		m.DebugEvents,
		m.WatchEvents,
	)
}

// BpfDebugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugVariables struct {
	Ip4ip6Prefix *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.Variable `ebpf:"unused"`
	Unused2      *ebpf.Variable `ebpf:"unused_2"`
	UnusedHttp2  *ebpf.Variable `ebpf:"unused_http2"`
}

// BpfDebugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugPrograms struct {
	ObiKprobeSysBind *ebpf.Program `ebpf:"obi_kprobe_sys_bind"`
}

func (p *BpfDebugPrograms) Close() error {
	return _BpfDebugClose(
		p.ObiKprobeSysBind,
	)
}

func _BpfDebugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpfdebug_x86_bpfel.o
var _BpfDebugBytes []byte
