// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"errors"
	"sync"

	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("github.com/open-telemetry/opentelemetry-collector-contrib/processor/groupbyattrsprocessor")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("github.com/open-telemetry/opentelemetry-collector-contrib/processor/groupbyattrsprocessor")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                                     metric.Meter
	mu                                        sync.Mutex
	registrations                             []metric.Registration
	ProcessorGroupbyattrsLogGroups            metric.Int64Histogram
	ProcessorGroupbyattrsMetricGroups         metric.Int64Histogram
	ProcessorGroupbyattrsNumGroupedLogs       metric.Int64Counter
	ProcessorGroupbyattrsNumGroupedMetrics    metric.Int64Counter
	ProcessorGroupbyattrsNumGroupedSpans      metric.Int64Counter
	ProcessorGroupbyattrsNumNonGroupedLogs    metric.Int64Counter
	ProcessorGroupbyattrsNumNonGroupedMetrics metric.Int64Counter
	ProcessorGroupbyattrsNumNonGroupedSpans   metric.Int64Counter
	ProcessorGroupbyattrsSpanGroups           metric.Int64Histogram
}

// TelemetryBuilderOption applies changes to default builder.
type TelemetryBuilderOption interface {
	apply(*TelemetryBuilder)
}

type telemetryBuilderOptionFunc func(mb *TelemetryBuilder)

func (tbof telemetryBuilderOptionFunc) apply(mb *TelemetryBuilder) {
	tbof(mb)
}

// Shutdown unregister all registered callbacks for async instruments.
func (builder *TelemetryBuilder) Shutdown() {
	builder.mu.Lock()
	defer builder.mu.Unlock()
	for _, reg := range builder.registrations {
		reg.Unregister()
	}
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...TelemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{}
	for _, op := range options {
		op.apply(&builder)
	}
	builder.meter = Meter(settings)
	var err, errs error
	builder.ProcessorGroupbyattrsLogGroups, err = builder.meter.Int64Histogram(
		"otelcol_processor_groupbyattrs_log_groups",
		metric.WithDescription("Distribution of groups extracted for logs [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsMetricGroups, err = builder.meter.Int64Histogram(
		"otelcol_processor_groupbyattrs_metric_groups",
		metric.WithDescription("Distribution of groups extracted for metrics [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsNumGroupedLogs, err = builder.meter.Int64Counter(
		"otelcol_processor_groupbyattrs_num_grouped_logs",
		metric.WithDescription("Number of logs that had attributes grouped [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsNumGroupedMetrics, err = builder.meter.Int64Counter(
		"otelcol_processor_groupbyattrs_num_grouped_metrics",
		metric.WithDescription("Number of metrics that had attributes grouped [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsNumGroupedSpans, err = builder.meter.Int64Counter(
		"otelcol_processor_groupbyattrs_num_grouped_spans",
		metric.WithDescription("Number of spans that had attributes grouped [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsNumNonGroupedLogs, err = builder.meter.Int64Counter(
		"otelcol_processor_groupbyattrs_num_non_grouped_logs",
		metric.WithDescription("Number of logs that did not have attributes grouped [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsNumNonGroupedMetrics, err = builder.meter.Int64Counter(
		"otelcol_processor_groupbyattrs_num_non_grouped_metrics",
		metric.WithDescription("Number of metrics that did not have attributes grouped [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsNumNonGroupedSpans, err = builder.meter.Int64Counter(
		"otelcol_processor_groupbyattrs_num_non_grouped_spans",
		metric.WithDescription("Number of spans that did not have attributes grouped [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorGroupbyattrsSpanGroups, err = builder.meter.Int64Histogram(
		"otelcol_processor_groupbyattrs_span_groups",
		metric.WithDescription("Distribution of groups extracted for spans [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	return &builder, errs
}
