// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// StorageSpecApplyConfiguration represents a declarative configuration of the StorageSpec type for use
// with apply.
type StorageSpecApplyConfiguration struct {
	DisableMountSubPath *bool                                            `json:"disableMountSubPath,omitempty"`
	EmptyDir            *corev1.EmptyDirVolumeSource                     `json:"emptyDir,omitempty"`
	Ephemeral           *corev1.EphemeralVolumeSource                    `json:"ephemeral,omitempty"`
	VolumeClaimTemplate *EmbeddedPersistentVolumeClaimApplyConfiguration `json:"volumeClaimTemplate,omitempty"`
}

// StorageSpecApplyConfiguration constructs a declarative configuration of the StorageSpec type for use with
// apply.
func StorageSpec() *StorageSpecApplyConfiguration {
	return &StorageSpecApplyConfiguration{}
}

// WithDisableMountSubPath sets the DisableMountSubPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DisableMountSubPath field is set to the value of the last call.
func (b *StorageSpecApplyConfiguration) WithDisableMountSubPath(value bool) *StorageSpecApplyConfiguration {
	b.DisableMountSubPath = &value
	return b
}

// WithEmptyDir sets the EmptyDir field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EmptyDir field is set to the value of the last call.
func (b *StorageSpecApplyConfiguration) WithEmptyDir(value corev1.EmptyDirVolumeSource) *StorageSpecApplyConfiguration {
	b.EmptyDir = &value
	return b
}

// WithEphemeral sets the Ephemeral field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Ephemeral field is set to the value of the last call.
func (b *StorageSpecApplyConfiguration) WithEphemeral(value corev1.EphemeralVolumeSource) *StorageSpecApplyConfiguration {
	b.Ephemeral = &value
	return b
}

// WithVolumeClaimTemplate sets the VolumeClaimTemplate field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the VolumeClaimTemplate field is set to the value of the last call.
func (b *StorageSpecApplyConfiguration) WithVolumeClaimTemplate(value *EmbeddedPersistentVolumeClaimApplyConfiguration) *StorageSpecApplyConfiguration {
	b.VolumeClaimTemplate = value
	return b
}
