// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
)

// Profiles is the top-level struct that is propagated through the profiles pipeline.
// Use NewProfiles to create new instance, zero-initialized instance is not valid for use.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewProfiles function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Profiles internal.ProfilesWrapper

func newProfiles(orig *internal.ExportProfilesServiceRequest, state *internal.State) Profiles {
	return Profiles(internal.NewProfilesWrapper(orig, state))
}

// NewProfiles creates a new empty Profiles.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewProfiles() Profiles {
	return newProfiles(internal.NewExportProfilesServiceRequest(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Profiles) MoveTo(dest Profiles) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.getOrig() == dest.getOrig() {
		return
	}
	internal.DeleteExportProfilesServiceRequest(dest.getOrig(), false)
	*dest.getOrig(), *ms.getOrig() = *ms.getOrig(), *dest.getOrig()
}

// ResourceProfiles returns the ResourceProfiles associated with this Profiles.
func (ms Profiles) ResourceProfiles() ResourceProfilesSlice {
	return newResourceProfilesSlice(&ms.getOrig().ResourceProfiles, ms.getState())
}

// Dictionary returns the dictionary associated with this Profiles.
func (ms Profiles) Dictionary() ProfilesDictionary {
	return newProfilesDictionary(&ms.getOrig().Dictionary, ms.getState())
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Profiles) CopyTo(dest Profiles) {
	dest.getState().AssertMutable()
	internal.CopyExportProfilesServiceRequest(dest.getOrig(), ms.getOrig())
}

func (ms Profiles) getOrig() *internal.ExportProfilesServiceRequest {
	return internal.GetProfilesOrig(internal.ProfilesWrapper(ms))
}

func (ms Profiles) getState() *internal.State {
	return internal.GetProfilesState(internal.ProfilesWrapper(ms))
}
