// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *Metric) GetData() any {
	if m != nil {
		return m.Data
	}
	return nil
}

type Metric_Gauge struct {
	Gauge *Gauge
}

func (m *Metric) GetGauge() *Gauge {
	if v, ok := m.GetData().(*Metric_Gauge); ok {
		return v.Gauge
	}
	return nil
}

type Metric_Sum struct {
	Sum *Sum
}

func (m *Metric) GetSum() *Sum {
	if v, ok := m.GetData().(*Metric_Sum); ok {
		return v.Sum
	}
	return nil
}

type Metric_Histogram struct {
	Histogram *Histogram
}

func (m *Metric) GetHistogram() *Histogram {
	if v, ok := m.GetData().(*Metric_Histogram); ok {
		return v.Histogram
	}
	return nil
}

type Metric_ExponentialHistogram struct {
	ExponentialHistogram *ExponentialHistogram
}

func (m *Metric) GetExponentialHistogram() *ExponentialHistogram {
	if v, ok := m.GetData().(*Metric_ExponentialHistogram); ok {
		return v.ExponentialHistogram
	}
	return nil
}

type Metric_Summary struct {
	Summary *Summary
}

func (m *Metric) GetSummary() *Summary {
	if v, ok := m.GetData().(*Metric_Summary); ok {
		return v.Summary
	}
	return nil
}

// Metric represents one metric as a collection of datapoints.
// See Metric definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/main/opentelemetry/proto/metrics/v1/metrics.proto
type Metric struct {
	Name        string
	Description string
	Unit        string
	Data        any
	Metadata    []KeyValue
}

var (
	protoPoolMetric = sync.Pool{
		New: func() any {
			return &Metric{}
		},
	}

	ProtoPoolMetric_Gauge = sync.Pool{
		New: func() any {
			return &Metric_Gauge{}
		},
	}

	ProtoPoolMetric_Sum = sync.Pool{
		New: func() any {
			return &Metric_Sum{}
		},
	}

	ProtoPoolMetric_Histogram = sync.Pool{
		New: func() any {
			return &Metric_Histogram{}
		},
	}

	ProtoPoolMetric_ExponentialHistogram = sync.Pool{
		New: func() any {
			return &Metric_ExponentialHistogram{}
		},
	}

	ProtoPoolMetric_Summary = sync.Pool{
		New: func() any {
			return &Metric_Summary{}
		},
	}
)

func NewMetric() *Metric {
	if !UseProtoPooling.IsEnabled() {
		return &Metric{}
	}
	return protoPoolMetric.Get().(*Metric)
}

func DeleteMetric(orig *Metric, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	switch ov := orig.Data.(type) {
	case *Metric_Gauge:
		DeleteGauge(ov.Gauge, true)
		ov.Gauge = nil
		ProtoPoolMetric_Gauge.Put(ov)
	case *Metric_Sum:
		DeleteSum(ov.Sum, true)
		ov.Sum = nil
		ProtoPoolMetric_Sum.Put(ov)
	case *Metric_Histogram:
		DeleteHistogram(ov.Histogram, true)
		ov.Histogram = nil
		ProtoPoolMetric_Histogram.Put(ov)
	case *Metric_ExponentialHistogram:
		DeleteExponentialHistogram(ov.ExponentialHistogram, true)
		ov.ExponentialHistogram = nil
		ProtoPoolMetric_ExponentialHistogram.Put(ov)
	case *Metric_Summary:
		DeleteSummary(ov.Summary, true)
		ov.Summary = nil
		ProtoPoolMetric_Summary.Put(ov)

	}
	for i := range orig.Metadata {
		DeleteKeyValue(&orig.Metadata[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolMetric.Put(orig)
	}
}

func CopyMetric(dest, src *Metric) *Metric {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewMetric()
	}
	dest.Name = src.Name

	dest.Description = src.Description

	dest.Unit = src.Unit

	switch t := src.Data.(type) {
	case *Metric_Gauge:
		var ov *Metric_Gauge
		if !UseProtoPooling.IsEnabled() {
			ov = &Metric_Gauge{}
		} else {
			ov = ProtoPoolMetric_Gauge.Get().(*Metric_Gauge)
		}
		ov.Gauge = NewGauge()
		CopyGauge(ov.Gauge, t.Gauge)
		dest.Data = ov

	case *Metric_Sum:
		var ov *Metric_Sum
		if !UseProtoPooling.IsEnabled() {
			ov = &Metric_Sum{}
		} else {
			ov = ProtoPoolMetric_Sum.Get().(*Metric_Sum)
		}
		ov.Sum = NewSum()
		CopySum(ov.Sum, t.Sum)
		dest.Data = ov

	case *Metric_Histogram:
		var ov *Metric_Histogram
		if !UseProtoPooling.IsEnabled() {
			ov = &Metric_Histogram{}
		} else {
			ov = ProtoPoolMetric_Histogram.Get().(*Metric_Histogram)
		}
		ov.Histogram = NewHistogram()
		CopyHistogram(ov.Histogram, t.Histogram)
		dest.Data = ov

	case *Metric_ExponentialHistogram:
		var ov *Metric_ExponentialHistogram
		if !UseProtoPooling.IsEnabled() {
			ov = &Metric_ExponentialHistogram{}
		} else {
			ov = ProtoPoolMetric_ExponentialHistogram.Get().(*Metric_ExponentialHistogram)
		}
		ov.ExponentialHistogram = NewExponentialHistogram()
		CopyExponentialHistogram(ov.ExponentialHistogram, t.ExponentialHistogram)
		dest.Data = ov

	case *Metric_Summary:
		var ov *Metric_Summary
		if !UseProtoPooling.IsEnabled() {
			ov = &Metric_Summary{}
		} else {
			ov = ProtoPoolMetric_Summary.Get().(*Metric_Summary)
		}
		ov.Summary = NewSummary()
		CopySummary(ov.Summary, t.Summary)
		dest.Data = ov

	default:
		dest.Data = nil
	}
	dest.Metadata = CopyKeyValueSlice(dest.Metadata, src.Metadata)

	return dest
}

func CopyMetricSlice(dest, src []Metric) []Metric {
	var newDest []Metric
	if cap(dest) < len(src) {
		newDest = make([]Metric, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMetric(&dest[i], false)
		}
	}
	for i := range src {
		CopyMetric(&newDest[i], &src[i])
	}
	return newDest
}

func CopyMetricPtrSlice(dest, src []*Metric) []*Metric {
	var newDest []*Metric
	if cap(dest) < len(src) {
		newDest = make([]*Metric, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMetric()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMetric(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMetric()
		}
	}
	for i := range src {
		CopyMetric(newDest[i], src[i])
	}
	return newDest
}

func (orig *Metric) Reset() {
	*orig = Metric{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Metric) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}
	if orig.Description != "" {
		dest.WriteObjectField("description")
		dest.WriteString(orig.Description)
	}
	if orig.Unit != "" {
		dest.WriteObjectField("unit")
		dest.WriteString(orig.Unit)
	}
	switch orig := orig.Data.(type) {
	case *Metric_Gauge:
		if orig.Gauge != nil {
			dest.WriteObjectField("gauge")
			orig.Gauge.MarshalJSON(dest)
		}
	case *Metric_Sum:
		if orig.Sum != nil {
			dest.WriteObjectField("sum")
			orig.Sum.MarshalJSON(dest)
		}
	case *Metric_Histogram:
		if orig.Histogram != nil {
			dest.WriteObjectField("histogram")
			orig.Histogram.MarshalJSON(dest)
		}
	case *Metric_ExponentialHistogram:
		if orig.ExponentialHistogram != nil {
			dest.WriteObjectField("exponentialHistogram")
			orig.ExponentialHistogram.MarshalJSON(dest)
		}
	case *Metric_Summary:
		if orig.Summary != nil {
			dest.WriteObjectField("summary")
			orig.Summary.MarshalJSON(dest)
		}
	}
	if len(orig.Metadata) > 0 {
		dest.WriteObjectField("metadata")
		dest.WriteArrayStart()
		orig.Metadata[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Metadata); i++ {
			dest.WriteMore()
			orig.Metadata[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Metric) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "name":
			orig.Name = iter.ReadString()
		case "description":
			orig.Description = iter.ReadString()
		case "unit":
			orig.Unit = iter.ReadString()

		case "gauge":
			{
				var ov *Metric_Gauge
				if !UseProtoPooling.IsEnabled() {
					ov = &Metric_Gauge{}
				} else {
					ov = ProtoPoolMetric_Gauge.Get().(*Metric_Gauge)
				}
				ov.Gauge = NewGauge()
				ov.Gauge.UnmarshalJSON(iter)
				orig.Data = ov
			}

		case "sum":
			{
				var ov *Metric_Sum
				if !UseProtoPooling.IsEnabled() {
					ov = &Metric_Sum{}
				} else {
					ov = ProtoPoolMetric_Sum.Get().(*Metric_Sum)
				}
				ov.Sum = NewSum()
				ov.Sum.UnmarshalJSON(iter)
				orig.Data = ov
			}

		case "histogram":
			{
				var ov *Metric_Histogram
				if !UseProtoPooling.IsEnabled() {
					ov = &Metric_Histogram{}
				} else {
					ov = ProtoPoolMetric_Histogram.Get().(*Metric_Histogram)
				}
				ov.Histogram = NewHistogram()
				ov.Histogram.UnmarshalJSON(iter)
				orig.Data = ov
			}

		case "exponentialHistogram", "exponential_histogram":
			{
				var ov *Metric_ExponentialHistogram
				if !UseProtoPooling.IsEnabled() {
					ov = &Metric_ExponentialHistogram{}
				} else {
					ov = ProtoPoolMetric_ExponentialHistogram.Get().(*Metric_ExponentialHistogram)
				}
				ov.ExponentialHistogram = NewExponentialHistogram()
				ov.ExponentialHistogram.UnmarshalJSON(iter)
				orig.Data = ov
			}

		case "summary":
			{
				var ov *Metric_Summary
				if !UseProtoPooling.IsEnabled() {
					ov = &Metric_Summary{}
				} else {
					ov = ProtoPoolMetric_Summary.Get().(*Metric_Summary)
				}
				ov.Summary = NewSummary()
				ov.Summary.UnmarshalJSON(iter)
				orig.Data = ov
			}

		case "metadata":
			for iter.ReadArray() {
				orig.Metadata = append(orig.Metadata, KeyValue{})
				orig.Metadata[len(orig.Metadata)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Metric) SizeProto() int {
	var n int
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Description)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Unit)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	switch orig := orig.Data.(type) {
	case nil:
		_ = orig
		break
	case *Metric_Gauge:
		if orig.Gauge != nil {
			l = orig.Gauge.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *Metric_Sum:
		if orig.Sum != nil {
			l = orig.Sum.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *Metric_Histogram:
		if orig.Histogram != nil {
			l = orig.Histogram.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *Metric_ExponentialHistogram:
		if orig.ExponentialHistogram != nil {
			l = orig.ExponentialHistogram.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *Metric_Summary:
		if orig.Summary != nil {
			l = orig.Summary.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	}
	for i := range orig.Metadata {
		l = orig.Metadata[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Metric) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = len(orig.Description)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Description)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.Unit)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Unit)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	switch orig := orig.Data.(type) {
	case *Metric_Gauge:
		if orig.Gauge != nil {
			l = orig.Gauge.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x2a
		}
	case *Metric_Sum:
		if orig.Sum != nil {
			l = orig.Sum.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x3a
		}
	case *Metric_Histogram:
		if orig.Histogram != nil {
			l = orig.Histogram.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x4a
		}
	case *Metric_ExponentialHistogram:
		if orig.ExponentialHistogram != nil {
			l = orig.ExponentialHistogram.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x52
		}
	case *Metric_Summary:
		if orig.Summary != nil {
			l = orig.Summary.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x5a
		}
	}
	for i := len(orig.Metadata) - 1; i >= 0; i-- {
		l = orig.Metadata[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x62
	}
	return len(buf) - pos
}

func (orig *Metric) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Name = string(buf[startPos:pos])

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Description = string(buf[startPos:pos])

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Unit = string(buf[startPos:pos])

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Gauge", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *Metric_Gauge
			if !UseProtoPooling.IsEnabled() {
				ov = &Metric_Gauge{}
			} else {
				ov = ProtoPoolMetric_Gauge.Get().(*Metric_Gauge)
			}
			ov.Gauge = NewGauge()
			err = ov.Gauge.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Data = ov

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *Metric_Sum
			if !UseProtoPooling.IsEnabled() {
				ov = &Metric_Sum{}
			} else {
				ov = ProtoPoolMetric_Sum.Get().(*Metric_Sum)
			}
			ov.Sum = NewSum()
			err = ov.Sum.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Data = ov

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Histogram", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *Metric_Histogram
			if !UseProtoPooling.IsEnabled() {
				ov = &Metric_Histogram{}
			} else {
				ov = ProtoPoolMetric_Histogram.Get().(*Metric_Histogram)
			}
			ov.Histogram = NewHistogram()
			err = ov.Histogram.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Data = ov

		case 10:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialHistogram", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *Metric_ExponentialHistogram
			if !UseProtoPooling.IsEnabled() {
				ov = &Metric_ExponentialHistogram{}
			} else {
				ov = ProtoPoolMetric_ExponentialHistogram.Get().(*Metric_ExponentialHistogram)
			}
			ov.ExponentialHistogram = NewExponentialHistogram()
			err = ov.ExponentialHistogram.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Data = ov

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *Metric_Summary
			if !UseProtoPooling.IsEnabled() {
				ov = &Metric_Summary{}
			} else {
				ov = ProtoPoolMetric_Summary.Get().(*Metric_Summary)
			}
			ov.Summary = NewSummary()
			err = ov.Summary.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Data = ov

		case 12:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Metadata = append(orig.Metadata, KeyValue{})
			err = orig.Metadata[len(orig.Metadata)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestMetric() *Metric {
	orig := NewMetric()
	orig.Name = "test_name"
	orig.Description = "test_description"
	orig.Unit = "test_unit"
	orig.Data = &Metric_Gauge{Gauge: GenTestGauge()}
	orig.Metadata = []KeyValue{{}, *GenTestKeyValue()}
	return orig
}

func GenTestMetricPtrSlice() []*Metric {
	orig := make([]*Metric, 5)
	orig[0] = NewMetric()
	orig[1] = GenTestMetric()
	orig[2] = NewMetric()
	orig[3] = GenTestMetric()
	orig[4] = NewMetric()
	return orig
}

func GenTestMetricSlice() []Metric {
	orig := make([]Metric, 5)
	orig[1] = *GenTestMetric()
	orig[3] = *GenTestMetric()
	return orig
}
