// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *RequestContext) GetClientAddress() any {
	if m != nil {
		return m.ClientAddress
	}
	return nil
}

type RequestContext_IP struct {
	IP *IPAddr
}

func (m *RequestContext) GetIP() *IPAddr {
	if v, ok := m.GetClientAddress().(*RequestContext_IP); ok {
		return v.IP
	}
	return nil
}

type RequestContext_TCP struct {
	TCP *TCPAddr
}

func (m *RequestContext) GetTCP() *TCPAddr {
	if v, ok := m.GetClientAddress().(*RequestContext_TCP); ok {
		return v.TCP
	}
	return nil
}

type RequestContext_UDP struct {
	UDP *UDPAddr
}

func (m *RequestContext) GetUDP() *UDPAddr {
	if v, ok := m.GetClientAddress().(*RequestContext_UDP); ok {
		return v.UDP
	}
	return nil
}

type RequestContext_Unix struct {
	Unix *UnixAddr
}

func (m *RequestContext) GetUnix() *UnixAddr {
	if v, ok := m.GetClientAddress().(*RequestContext_Unix); ok {
		return v.Unix
	}
	return nil
}

type RequestContext struct {
	SpanContext    *SpanContext
	ClientMetadata []KeyValue
	ClientAddress  any
}

var (
	protoPoolRequestContext = sync.Pool{
		New: func() any {
			return &RequestContext{}
		},
	}

	ProtoPoolRequestContext_IP = sync.Pool{
		New: func() any {
			return &RequestContext_IP{}
		},
	}

	ProtoPoolRequestContext_TCP = sync.Pool{
		New: func() any {
			return &RequestContext_TCP{}
		},
	}

	ProtoPoolRequestContext_UDP = sync.Pool{
		New: func() any {
			return &RequestContext_UDP{}
		},
	}

	ProtoPoolRequestContext_Unix = sync.Pool{
		New: func() any {
			return &RequestContext_Unix{}
		},
	}
)

func NewRequestContext() *RequestContext {
	if !UseProtoPooling.IsEnabled() {
		return &RequestContext{}
	}
	return protoPoolRequestContext.Get().(*RequestContext)
}

func DeleteRequestContext(orig *RequestContext, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteSpanContext(orig.SpanContext, true)
	for i := range orig.ClientMetadata {
		DeleteKeyValue(&orig.ClientMetadata[i], false)
	}
	switch ov := orig.ClientAddress.(type) {
	case *RequestContext_IP:
		DeleteIPAddr(ov.IP, true)
		ov.IP = nil
		ProtoPoolRequestContext_IP.Put(ov)
	case *RequestContext_TCP:
		DeleteTCPAddr(ov.TCP, true)
		ov.TCP = nil
		ProtoPoolRequestContext_TCP.Put(ov)
	case *RequestContext_UDP:
		DeleteUDPAddr(ov.UDP, true)
		ov.UDP = nil
		ProtoPoolRequestContext_UDP.Put(ov)
	case *RequestContext_Unix:
		DeleteUnixAddr(ov.Unix, true)
		ov.Unix = nil
		ProtoPoolRequestContext_Unix.Put(ov)

	}

	orig.Reset()
	if nullable {
		protoPoolRequestContext.Put(orig)
	}
}

func CopyRequestContext(dest, src *RequestContext) *RequestContext {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewRequestContext()
	}
	dest.SpanContext = CopySpanContext(dest.SpanContext, src.SpanContext)

	dest.ClientMetadata = CopyKeyValueSlice(dest.ClientMetadata, src.ClientMetadata)

	switch t := src.ClientAddress.(type) {
	case *RequestContext_IP:
		var ov *RequestContext_IP
		if !UseProtoPooling.IsEnabled() {
			ov = &RequestContext_IP{}
		} else {
			ov = ProtoPoolRequestContext_IP.Get().(*RequestContext_IP)
		}
		ov.IP = NewIPAddr()
		CopyIPAddr(ov.IP, t.IP)
		dest.ClientAddress = ov

	case *RequestContext_TCP:
		var ov *RequestContext_TCP
		if !UseProtoPooling.IsEnabled() {
			ov = &RequestContext_TCP{}
		} else {
			ov = ProtoPoolRequestContext_TCP.Get().(*RequestContext_TCP)
		}
		ov.TCP = NewTCPAddr()
		CopyTCPAddr(ov.TCP, t.TCP)
		dest.ClientAddress = ov

	case *RequestContext_UDP:
		var ov *RequestContext_UDP
		if !UseProtoPooling.IsEnabled() {
			ov = &RequestContext_UDP{}
		} else {
			ov = ProtoPoolRequestContext_UDP.Get().(*RequestContext_UDP)
		}
		ov.UDP = NewUDPAddr()
		CopyUDPAddr(ov.UDP, t.UDP)
		dest.ClientAddress = ov

	case *RequestContext_Unix:
		var ov *RequestContext_Unix
		if !UseProtoPooling.IsEnabled() {
			ov = &RequestContext_Unix{}
		} else {
			ov = ProtoPoolRequestContext_Unix.Get().(*RequestContext_Unix)
		}
		ov.Unix = NewUnixAddr()
		CopyUnixAddr(ov.Unix, t.Unix)
		dest.ClientAddress = ov

	default:
		dest.ClientAddress = nil
	}

	return dest
}

func CopyRequestContextSlice(dest, src []RequestContext) []RequestContext {
	var newDest []RequestContext
	if cap(dest) < len(src) {
		newDest = make([]RequestContext, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteRequestContext(&dest[i], false)
		}
	}
	for i := range src {
		CopyRequestContext(&newDest[i], &src[i])
	}
	return newDest
}

func CopyRequestContextPtrSlice(dest, src []*RequestContext) []*RequestContext {
	var newDest []*RequestContext
	if cap(dest) < len(src) {
		newDest = make([]*RequestContext, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewRequestContext()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteRequestContext(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewRequestContext()
		}
	}
	for i := range src {
		CopyRequestContext(newDest[i], src[i])
	}
	return newDest
}

func (orig *RequestContext) Reset() {
	*orig = RequestContext{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *RequestContext) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.SpanContext != nil {
		dest.WriteObjectField("spanContext")
		orig.SpanContext.MarshalJSON(dest)
	}
	if len(orig.ClientMetadata) > 0 {
		dest.WriteObjectField("clientMetadata")
		dest.WriteArrayStart()
		orig.ClientMetadata[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ClientMetadata); i++ {
			dest.WriteMore()
			orig.ClientMetadata[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	switch orig := orig.ClientAddress.(type) {
	case *RequestContext_IP:
		if orig.IP != nil {
			dest.WriteObjectField("iP")
			orig.IP.MarshalJSON(dest)
		}
	case *RequestContext_TCP:
		if orig.TCP != nil {
			dest.WriteObjectField("tCP")
			orig.TCP.MarshalJSON(dest)
		}
	case *RequestContext_UDP:
		if orig.UDP != nil {
			dest.WriteObjectField("uDP")
			orig.UDP.MarshalJSON(dest)
		}
	case *RequestContext_Unix:
		if orig.Unix != nil {
			dest.WriteObjectField("unix")
			orig.Unix.MarshalJSON(dest)
		}
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *RequestContext) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "spanContext", "span_context":
			orig.SpanContext = NewSpanContext()
			orig.SpanContext.UnmarshalJSON(iter)
		case "clientMetadata", "client_metadata":
			for iter.ReadArray() {
				orig.ClientMetadata = append(orig.ClientMetadata, KeyValue{})
				orig.ClientMetadata[len(orig.ClientMetadata)-1].UnmarshalJSON(iter)
			}

		case "iP":
			{
				var ov *RequestContext_IP
				if !UseProtoPooling.IsEnabled() {
					ov = &RequestContext_IP{}
				} else {
					ov = ProtoPoolRequestContext_IP.Get().(*RequestContext_IP)
				}
				ov.IP = NewIPAddr()
				ov.IP.UnmarshalJSON(iter)
				orig.ClientAddress = ov
			}

		case "tCP":
			{
				var ov *RequestContext_TCP
				if !UseProtoPooling.IsEnabled() {
					ov = &RequestContext_TCP{}
				} else {
					ov = ProtoPoolRequestContext_TCP.Get().(*RequestContext_TCP)
				}
				ov.TCP = NewTCPAddr()
				ov.TCP.UnmarshalJSON(iter)
				orig.ClientAddress = ov
			}

		case "uDP":
			{
				var ov *RequestContext_UDP
				if !UseProtoPooling.IsEnabled() {
					ov = &RequestContext_UDP{}
				} else {
					ov = ProtoPoolRequestContext_UDP.Get().(*RequestContext_UDP)
				}
				ov.UDP = NewUDPAddr()
				ov.UDP.UnmarshalJSON(iter)
				orig.ClientAddress = ov
			}

		case "unix":
			{
				var ov *RequestContext_Unix
				if !UseProtoPooling.IsEnabled() {
					ov = &RequestContext_Unix{}
				} else {
					ov = ProtoPoolRequestContext_Unix.Get().(*RequestContext_Unix)
				}
				ov.Unix = NewUnixAddr()
				ov.Unix.UnmarshalJSON(iter)
				orig.ClientAddress = ov
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *RequestContext) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.SpanContext != nil {
		l = orig.SpanContext.SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.ClientMetadata {
		l = orig.ClientMetadata[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	switch orig := orig.ClientAddress.(type) {
	case nil:
		_ = orig
		break
	case *RequestContext_IP:
		if orig.IP != nil {
			l = orig.IP.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *RequestContext_TCP:
		if orig.TCP != nil {
			l = orig.TCP.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *RequestContext_UDP:
		if orig.UDP != nil {
			l = orig.UDP.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *RequestContext_Unix:
		if orig.Unix != nil {
			l = orig.Unix.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	}
	return n
}

func (orig *RequestContext) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.SpanContext != nil {
		l = orig.SpanContext.MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	for i := len(orig.ClientMetadata) - 1; i >= 0; i-- {
		l = orig.ClientMetadata[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	switch orig := orig.ClientAddress.(type) {
	case *RequestContext_IP:
		if orig.IP != nil {
			l = orig.IP.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x1a
		}
	case *RequestContext_TCP:
		if orig.TCP != nil {
			l = orig.TCP.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x22
		}
	case *RequestContext_UDP:
		if orig.UDP != nil {
			l = orig.UDP.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x2a
		}
	case *RequestContext_Unix:
		if orig.Unix != nil {
			l = orig.Unix.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x32
		}
	}
	return len(buf) - pos
}

func (orig *RequestContext) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanContext", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			orig.SpanContext = NewSpanContext()
			err = orig.SpanContext.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientMetadata", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ClientMetadata = append(orig.ClientMetadata, KeyValue{})
			err = orig.ClientMetadata[len(orig.ClientMetadata)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field IP", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *RequestContext_IP
			if !UseProtoPooling.IsEnabled() {
				ov = &RequestContext_IP{}
			} else {
				ov = ProtoPoolRequestContext_IP.Get().(*RequestContext_IP)
			}
			ov.IP = NewIPAddr()
			err = ov.IP.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.ClientAddress = ov

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TCP", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *RequestContext_TCP
			if !UseProtoPooling.IsEnabled() {
				ov = &RequestContext_TCP{}
			} else {
				ov = ProtoPoolRequestContext_TCP.Get().(*RequestContext_TCP)
			}
			ov.TCP = NewTCPAddr()
			err = ov.TCP.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.ClientAddress = ov

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field UDP", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *RequestContext_UDP
			if !UseProtoPooling.IsEnabled() {
				ov = &RequestContext_UDP{}
			} else {
				ov = ProtoPoolRequestContext_UDP.Get().(*RequestContext_UDP)
			}
			ov.UDP = NewUDPAddr()
			err = ov.UDP.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.ClientAddress = ov

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Unix", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *RequestContext_Unix
			if !UseProtoPooling.IsEnabled() {
				ov = &RequestContext_Unix{}
			} else {
				ov = ProtoPoolRequestContext_Unix.Get().(*RequestContext_Unix)
			}
			ov.Unix = NewUnixAddr()
			err = ov.Unix.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.ClientAddress = ov
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestRequestContext() *RequestContext {
	orig := NewRequestContext()
	orig.SpanContext = GenTestSpanContext()
	orig.ClientMetadata = []KeyValue{{}, *GenTestKeyValue()}
	orig.ClientAddress = &RequestContext_IP{IP: GenTestIPAddr()}
	return orig
}

func GenTestRequestContextPtrSlice() []*RequestContext {
	orig := make([]*RequestContext, 5)
	orig[0] = NewRequestContext()
	orig[1] = GenTestRequestContext()
	orig[2] = NewRequestContext()
	orig[3] = GenTestRequestContext()
	orig[4] = NewRequestContext()
	return orig
}

func GenTestRequestContextSlice() []RequestContext {
	orig := make([]RequestContext, 5)
	orig[1] = *GenTestRequestContext()
	orig[3] = *GenTestRequestContext()
	return orig
}
