// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ResourceMetrics is a collection of metrics from a Resource.
type ResourceMetrics struct {
	Resource               Resource
	ScopeMetrics           []*ScopeMetrics
	SchemaUrl              string
	DeprecatedScopeMetrics []*ScopeMetrics
}

var (
	protoPoolResourceMetrics = sync.Pool{
		New: func() any {
			return &ResourceMetrics{}
		},
	}
)

func NewResourceMetrics() *ResourceMetrics {
	if !UseProtoPooling.IsEnabled() {
		return &ResourceMetrics{}
	}
	return protoPoolResourceMetrics.Get().(*ResourceMetrics)
}

func DeleteResourceMetrics(orig *ResourceMetrics, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteResource(&orig.Resource, false)
	for i := range orig.ScopeMetrics {
		DeleteScopeMetrics(orig.ScopeMetrics[i], true)
	}
	for i := range orig.DeprecatedScopeMetrics {
		DeleteScopeMetrics(orig.DeprecatedScopeMetrics[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolResourceMetrics.Put(orig)
	}
}

func CopyResourceMetrics(dest, src *ResourceMetrics) *ResourceMetrics {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewResourceMetrics()
	}
	CopyResource(&dest.Resource, &src.Resource)

	dest.ScopeMetrics = CopyScopeMetricsPtrSlice(dest.ScopeMetrics, src.ScopeMetrics)

	dest.SchemaUrl = src.SchemaUrl

	dest.DeprecatedScopeMetrics = CopyScopeMetricsPtrSlice(dest.DeprecatedScopeMetrics, src.DeprecatedScopeMetrics)

	return dest
}

func CopyResourceMetricsSlice(dest, src []ResourceMetrics) []ResourceMetrics {
	var newDest []ResourceMetrics
	if cap(dest) < len(src) {
		newDest = make([]ResourceMetrics, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceMetrics(&dest[i], false)
		}
	}
	for i := range src {
		CopyResourceMetrics(&newDest[i], &src[i])
	}
	return newDest
}

func CopyResourceMetricsPtrSlice(dest, src []*ResourceMetrics) []*ResourceMetrics {
	var newDest []*ResourceMetrics
	if cap(dest) < len(src) {
		newDest = make([]*ResourceMetrics, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceMetrics()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceMetrics(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceMetrics()
		}
	}
	for i := range src {
		CopyResourceMetrics(newDest[i], src[i])
	}
	return newDest
}

func (orig *ResourceMetrics) Reset() {
	*orig = ResourceMetrics{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ResourceMetrics) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	orig.Resource.MarshalJSON(dest)
	if len(orig.ScopeMetrics) > 0 {
		dest.WriteObjectField("scopeMetrics")
		dest.WriteArrayStart()
		orig.ScopeMetrics[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ScopeMetrics); i++ {
			dest.WriteMore()
			orig.ScopeMetrics[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	if len(orig.DeprecatedScopeMetrics) > 0 {
		dest.WriteObjectField("deprecatedScopeMetrics")
		dest.WriteArrayStart()
		orig.DeprecatedScopeMetrics[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DeprecatedScopeMetrics); i++ {
			dest.WriteMore()
			orig.DeprecatedScopeMetrics[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ResourceMetrics) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resource":

			orig.Resource.UnmarshalJSON(iter)
		case "scopeMetrics", "scope_metrics":
			for iter.ReadArray() {
				orig.ScopeMetrics = append(orig.ScopeMetrics, NewScopeMetrics())
				orig.ScopeMetrics[len(orig.ScopeMetrics)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		case "deprecatedScopeMetrics", "deprecated_scope_metrics":
			for iter.ReadArray() {
				orig.DeprecatedScopeMetrics = append(orig.DeprecatedScopeMetrics, NewScopeMetrics())
				orig.DeprecatedScopeMetrics[len(orig.DeprecatedScopeMetrics)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ResourceMetrics) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Resource.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeMetrics {
		l = orig.ScopeMetrics[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.DeprecatedScopeMetrics {
		l = orig.DeprecatedScopeMetrics[i].SizeProto()
		n += 2 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ResourceMetrics) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Resource.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.ScopeMetrics) - 1; i >= 0; i-- {
		l = orig.ScopeMetrics[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.DeprecatedScopeMetrics) - 1; i >= 0; i-- {
		l = orig.DeprecatedScopeMetrics[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3e
		pos--
		buf[pos] = 0xc2
	}
	return len(buf) - pos
}

func (orig *ResourceMetrics) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Resource.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeMetrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ScopeMetrics = append(orig.ScopeMetrics, NewScopeMetrics())
			err = orig.ScopeMetrics[len(orig.ScopeMetrics)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])

		case 1000:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedScopeMetrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DeprecatedScopeMetrics = append(orig.DeprecatedScopeMetrics, NewScopeMetrics())
			err = orig.DeprecatedScopeMetrics[len(orig.DeprecatedScopeMetrics)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestResourceMetrics() *ResourceMetrics {
	orig := NewResourceMetrics()
	orig.Resource = *GenTestResource()
	orig.ScopeMetrics = []*ScopeMetrics{{}, GenTestScopeMetrics()}
	orig.SchemaUrl = "test_schemaurl"
	orig.DeprecatedScopeMetrics = []*ScopeMetrics{{}, GenTestScopeMetrics()}
	return orig
}

func GenTestResourceMetricsPtrSlice() []*ResourceMetrics {
	orig := make([]*ResourceMetrics, 5)
	orig[0] = NewResourceMetrics()
	orig[1] = GenTestResourceMetrics()
	orig[2] = NewResourceMetrics()
	orig[3] = GenTestResourceMetrics()
	orig[4] = NewResourceMetrics()
	return orig
}

func GenTestResourceMetricsSlice() []ResourceMetrics {
	orig := make([]ResourceMetrics, 5)
	orig[1] = *GenTestResourceMetrics()
	orig[3] = *GenTestResourceMetrics()
	return orig
}
