// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type UnixAddr struct {
	Name string
	Net  string
}

var (
	protoPoolUnixAddr = sync.Pool{
		New: func() any {
			return &UnixAddr{}
		},
	}
)

func NewUnixAddr() *UnixAddr {
	if !UseProtoPooling.IsEnabled() {
		return &UnixAddr{}
	}
	return protoPoolUnixAddr.Get().(*UnixAddr)
}

func DeleteUnixAddr(orig *UnixAddr, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolUnixAddr.Put(orig)
	}
}

func CopyUnixAddr(dest, src *UnixAddr) *UnixAddr {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewUnixAddr()
	}
	dest.Name = src.Name

	dest.Net = src.Net

	return dest
}

func CopyUnixAddrSlice(dest, src []UnixAddr) []UnixAddr {
	var newDest []UnixAddr
	if cap(dest) < len(src) {
		newDest = make([]UnixAddr, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteUnixAddr(&dest[i], false)
		}
	}
	for i := range src {
		CopyUnixAddr(&newDest[i], &src[i])
	}
	return newDest
}

func CopyUnixAddrPtrSlice(dest, src []*UnixAddr) []*UnixAddr {
	var newDest []*UnixAddr
	if cap(dest) < len(src) {
		newDest = make([]*UnixAddr, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewUnixAddr()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteUnixAddr(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewUnixAddr()
		}
	}
	for i := range src {
		CopyUnixAddr(newDest[i], src[i])
	}
	return newDest
}

func (orig *UnixAddr) Reset() {
	*orig = UnixAddr{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *UnixAddr) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}
	if orig.Net != "" {
		dest.WriteObjectField("net")
		dest.WriteString(orig.Net)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *UnixAddr) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "name":
			orig.Name = iter.ReadString()
		case "net":
			orig.Net = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *UnixAddr) SizeProto() int {
	var n int
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Net)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *UnixAddr) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = len(orig.Net)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Net)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *UnixAddr) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Name = string(buf[startPos:pos])

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Net", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Net = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestUnixAddr() *UnixAddr {
	orig := NewUnixAddr()
	orig.Name = "test_name"
	orig.Net = "test_net"
	return orig
}

func GenTestUnixAddrPtrSlice() []*UnixAddr {
	orig := make([]*UnixAddr, 5)
	orig[0] = NewUnixAddr()
	orig[1] = GenTestUnixAddr()
	orig[2] = NewUnixAddr()
	orig[3] = GenTestUnixAddr()
	orig[4] = NewUnixAddr()
	return orig
}

func GenTestUnixAddrSlice() []UnixAddr {
	orig := make([]UnixAddr, 5)
	orig[1] = *GenTestUnixAddr()
	orig[3] = *GenTestUnixAddr()
	return orig
}
