/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.ktor;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.application.Plugin;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.EmbeddedServer;
import io.ktor.server.engine.EmbeddedServerKt;
import io.ktor.server.netty.Netty;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.plugins.CannotTransformContentToTypeException;
import io.ktor.server.plugins.contentnegotiation.ContentNegotiationKt;
import io.ktor.server.plugins.statuspages.StatusPagesKt;
import io.ktor.server.response.ApplicationResponseFunctionsKt;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.Routing;
import io.ktor.server.routing.RoutingBuilderKt;
import io.ktor.server.routing.RoutingContext;
import io.ktor.server.routing.RoutingRootKt;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.reflect.TypeInfo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.Result;
import org.jitsi.jicofo.ConferenceRequest;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.PinnedConference;
import org.jitsi.jicofo.bridgeload.LoadRedistributor;
import org.jitsi.jicofo.bridgeload.MoveResult;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.ktor.Application;
import org.jitsi.jicofo.ktor.ApplicationKt;
import org.jitsi.jicofo.ktor.RestConfig;
import org.jitsi.jicofo.ktor.exception.BadRequest;
import org.jitsi.jicofo.ktor.exception.Forbidden;
import org.jitsi.jicofo.ktor.exception.MissingParameter;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.version.CurrentVersionImpl;
import org.jitsi.jicofo.xmpp.ConferenceIqHandler;
import org.jitsi.jicofo.xmpp.XmppCapsStats;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001Bo\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00128\u0010\r\u001a4\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010!\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010\"\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010#\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010$\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010%\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010&\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010'\u001a\u00020\u001e*\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\r\u001a4\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jitsi/jicofo/ktor/Application;", "", "healthChecker", "Lorg/jitsi/health/HealthCheckService;", "conferenceIqHandler", "Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "loadRedistributor", "Lorg/jitsi/jicofo/bridgeload/LoadRedistributor;", "getStatsJson", "Lkotlin/Function0;", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "full", "Lorg/jxmpp/jid/EntityBareJid;", "confId", "(Lorg/jitsi/health/HealthCheckService;Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;Lorg/jitsi/jicofo/ConferenceStore;Lorg/jitsi/jicofo/bridgeload/LoadRedistributor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "server", "Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "start", "stop", "", "about", "Lio/ktor/server/routing/Route;", "conferenceRequest", "debug", "metrics", "moveEndpoints", "pin", "rtcstats", "stats", "jicofo"})
public final class Application {
    @Nullable
    private final HealthCheckService healthChecker;
    @NotNull
    private final ConferenceIqHandler conferenceIqHandler;
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final LoadRedistributor loadRedistributor;
    @NotNull
    private final Function0<OrderedJsonObject> getStatsJson;
    @NotNull
    private final Function2<Boolean, EntityBareJid, OrderedJsonObject> getDebugState;
    @NotNull
    private final Logger logger;
    @NotNull
    private final EmbeddedServer<NettyApplicationEngine, NettyApplicationEngine.Configuration> server;

    public Application(@Nullable HealthCheckService healthChecker2, @NotNull ConferenceIqHandler conferenceIqHandler, @NotNull ConferenceStore conferenceStore, @NotNull LoadRedistributor loadRedistributor, @NotNull Function0<OrderedJsonObject> getStatsJson, @NotNull Function2<? super Boolean, ? super EntityBareJid, OrderedJsonObject> getDebugState) {
        Intrinsics.checkNotNullParameter((Object)((Object)conferenceIqHandler), (String)"conferenceIqHandler");
        Intrinsics.checkNotNullParameter((Object)conferenceStore, (String)"conferenceStore");
        Intrinsics.checkNotNullParameter((Object)loadRedistributor, (String)"loadRedistributor");
        Intrinsics.checkNotNullParameter(getStatsJson, (String)"getStatsJson");
        Intrinsics.checkNotNullParameter(getDebugState, (String)"getDebugState");
        this.healthChecker = healthChecker2;
        this.conferenceIqHandler = conferenceIqHandler;
        this.conferenceStore = conferenceStore;
        this.loadRedistributor = loadRedistributor;
        this.getStatsJson = getStatsJson;
        this.getDebugState = getDebugState;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        this.server = this.start();
    }

    private final EmbeddedServer<NettyApplicationEngine, NettyApplicationEngine.Configuration> start() {
        this.logger.info((Object)("Starting ktor on port " + RestConfig.config.getPort() + ", host " + RestConfig.config.getHost()));
        return EmbeddedServerKt.embeddedServer$default((ApplicationEngineFactory)((ApplicationEngineFactory)Netty.INSTANCE), (int)RestConfig.config.getPort(), (String)RestConfig.config.getHost(), null, (Function1)((Function1)new Function1<io.ktor.server.application.Application, Unit>(this){
            final /* synthetic */ Application this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull io.ktor.server.application.Application $this$embeddedServer) {
                Intrinsics.checkNotNullParameter((Object)$this$embeddedServer, (String)"$this$embeddedServer");
                ApplicationPluginKt.install((Pipeline)((Pipeline)$this$embeddedServer), (Plugin)((Plugin)ContentNegotiationKt.getContentNegotiation()), (Function1)start.1.INSTANCE);
                ApplicationPluginKt.install((Pipeline)((Pipeline)$this$embeddedServer), (Plugin)((Plugin)StatusPagesKt.getStatusPages()), (Function1)start.2.INSTANCE);
                RoutingRootKt.routing((io.ktor.server.application.Application)$this$embeddedServer, (Function1)((Function1)new Function1<Routing, Unit>(this.this$0){
                    final /* synthetic */ Application this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Routing $this$routing) {
                        Intrinsics.checkNotNullParameter((Object)$this$routing, (String)"$this$routing");
                        Application.access$about(this.this$0, (Route)$this$routing);
                        Application.access$conferenceRequest(this.this$0, (Route)$this$routing);
                        Application.access$debug(this.this$0, (Route)$this$routing);
                        Application.access$metrics(this.this$0, (Route)$this$routing);
                        Application.access$moveEndpoints(this.this$0, (Route)$this$routing);
                        Application.access$pin(this.this$0, (Route)$this$routing);
                        Application.access$rtcstats(this.this$0, (Route)$this$routing);
                        Application.access$stats(this.this$0, (Route)$this$routing);
                    }
                }));
            }
        }), (int)8, null).start(false);
    }

    public final void stop() {
        EmbeddedServer.stop$default(this.server, (long)0L, (long)0L, (int)3, null);
    }

    private final void metrics(Route $this$metrics) {
        if (RestConfig.config.getEnablePrometheus()) {
            RoutingBuilderKt.get((Route)$this$metrics, (String)"/metrics", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$mapTo$iv$iv;
                            ResultKt.throwOnFailure((Object)object);
                            RoutingContext $this$get = (RoutingContext)this.L$0;
                            Iterable $this$sortedByDescending$iv = HttpHeaderValueParserKt.parseHeaderValue((String)$this$get.getCall().getRequest().getHeaders().get("Accept"));
                            boolean $i$f$sortedByDescending = false;
                            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    HeaderValue it = (HeaderValue)b;
                                    boolean bl = false;
                                    Comparable comparable = Double.valueOf(it.getQuality());
                                    it = (HeaderValue)a;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getQuality()));
                                }
                            });
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                HeaderValue headerValue = (HeaderValue)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getValue());
                            }
                            List accepts = (List)destination$iv$iv;
                            Pair pair = JicofoMetricsContainer.Companion.getInstance().getMetrics(accepts);
                            String metrics2 = (String)pair.component1();
                            String contentType = (String)pair.component2();
                            this.label = 1;
                            Object object3 = ApplicationResponseFunctionsKt.respondText$default((ApplicationCall)((ApplicationCall)$this$get.getCall()), (String)metrics2, (ContentType)ContentType.Companion.parse(contentType), null, null, (Continuation)((Continuation)this), (int)12, null);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final void about(Route $this$about) {
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J2\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"org/jitsi/jicofo/ktor/Application$about$VersionInfo", "", "name", "", "version", "os", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getOs", "getVersion", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/jitsi/jicofo/ktor/Application$about$VersionInfo;", "equals", "", "other", "hashCode", "", "toString", "jicofo"})
        public final class VersionInfo {
            @Nullable
            private final String name;
            @Nullable
            private final String version;
            @Nullable
            private final String os;

            public VersionInfo(@Nullable String name, @Nullable String version, @Nullable String os) {
                this.name = name;
                this.version = version;
                this.os = os;
            }

            public /* synthetic */ VersionInfo(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                this(string, string2, string3);
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            @Nullable
            public final String getOs() {
                return this.os;
            }

            @Nullable
            public final String component1() {
                return this.name;
            }

            @Nullable
            public final String component2() {
                return this.version;
            }

            @Nullable
            public final String component3() {
                return this.os;
            }

            @NotNull
            public final VersionInfo copy(@Nullable String name, @Nullable String version, @Nullable String os) {
                return new VersionInfo(name, version, os);
            }

            public static /* synthetic */ VersionInfo copy$default(VersionInfo versionInfo, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = versionInfo.name;
                }
                if ((n & 2) != 0) {
                    string2 = versionInfo.version;
                }
                if ((n & 4) != 0) {
                    string3 = versionInfo.os;
                }
                return versionInfo.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "VersionInfo(name=" + this.name + ", version=" + this.version + ", os=" + this.os + ")";
            }

            public int hashCode() {
                int result = this.name == null ? 0 : this.name.hashCode();
                result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
                result = result * 31 + (this.os == null ? 0 : this.os.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VersionInfo)) {
                    return false;
                }
                VersionInfo versionInfo = (VersionInfo)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)versionInfo.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.version, (Object)versionInfo.version)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.os, (Object)versionInfo.os);
            }
        }
        VersionInfo versionInfo = new VersionInfo(CurrentVersionImpl.VERSION.getApplicationName(), CurrentVersionImpl.VERSION.toString(), System.getProperty("os.name"));
        RoutingBuilderKt.route((Route)$this$about, (String)"/about", (Function1)((Function1)new Function1<Route, Unit>(this, versionInfo){
            final /* synthetic */ Application this$0;
            final /* synthetic */ VersionInfo $versionInfo;
            {
                this.this$0 = $receiver;
                this.$versionInfo = $versionInfo;
                super(1);
            }

            public final void invoke(@NotNull Route $this$route) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
                    RoutingBuilderKt.get((Route)$this$route, (String)"version", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.$versionInfo, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ VersionInfo $versionInfo;
                        {
                            this.$versionInfo = $versionInfo;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    KType kType;
                                    void $this$respond$iv;
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    ApplicationCall applicationCall = (ApplicationCall)$this$get.getCall();
                                    VersionInfo message$iv = this.$versionInfo;
                                    boolean $i$f$respond = false;
                                    VersionInfo versionInfo = message$iv;
                                    void var7_9 = $this$respond$iv;
                                    boolean $i$f$typeInfo = false;
                                    KClass kClass = Reflection.getOrCreateKotlinClass(VersionInfo.class);
                                    boolean $i$f$typeOfOrNull = false;
                                    try {
                                        kType = Reflection.typeOf(VersionInfo.class);
                                    }
                                    catch (Throwable throwable) {
                                        kType = null;
                                    }
                                    KType kType2 = kType;
                                    KClass kClass2 = kClass;
                                    TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                                    this.label = 1;
                                    Object object3 = var7_9.respond((Object)versionInfo, typeInfo, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    boolean $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    HealthCheckService healthCheckService = Application.access$getHealthChecker$p(this.this$0);
                    if (healthCheckService == null) break block0;
                    HealthCheckService healthCheckService2 = healthCheckService;
                    Application application = this.this$0;
                    HealthCheckService it = healthCheckService2;
                    boolean bl = false;
                    RoutingBuilderKt.get((Route)$this$route, (String)"health", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(application, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            void $result;
                            Result it;
                            RoutingContext $this$get;
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    KType kType;
                                    void $this$respond$iv;
                                    void message$iv;
                                    ResultKt.throwOnFailure((Object)object);
                                    $this$get = (RoutingContext)this.L$0;
                                    it = Application.access$getHealthChecker$p(this.this$0).getResult();
                                    boolean bl = false;
                                    if (!it.getSuccess()) break;
                                    ApplicationCall applicationCall = (ApplicationCall)$this$get.getCall();
                                    String string = "OK";
                                    about.2.1 $completion$iv = this;
                                    boolean $i$f$respond = false;
                                    void var9_14 = message$iv;
                                    void var10_15 = $this$respond$iv;
                                    boolean $i$f$typeInfo = false;
                                    KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                                    boolean $i$f$typeOfOrNull = false;
                                    try {
                                        kType = Reflection.typeOf(String.class);
                                    }
                                    catch (Throwable throwable) {
                                        kType = null;
                                    }
                                    KType kType2 = kType;
                                    KClass kClass2 = kClass;
                                    TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                                    this.label = 1;
                                    Object object3 = var10_15.respond((Object)var9_14, typeInfo, (Continuation)$completion$iv);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    boolean bl = false;
                                    boolean $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            Integer n = it.getResponseCode();
                            int status = n != null ? n : (it.getHardFailure() ? 500 : 503);
                            this.label = 2;
                            Object object4 = ApplicationResponseFunctionsKt.respondText((ApplicationCall)((ApplicationCall)$this$get.getCall()), (ContentType)ContentType.Text.INSTANCE.getPlain(), (HttpStatusCode)HttpStatusCode.Companion.fromValue(status), (Function1)((Function1)new Function1<Continuation<? super String>, Object>(it, null){
                                int label;
                                final /* synthetic */ Result $it;
                                {
                                    this.$it = $it;
                                    super(1, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            String string = this.$it.getMessage();
                                            if (string == null) {
                                                string = "Unknown error.";
                                            }
                                            return string;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@Nullable Continuation<? super String> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                            {
                                case 2: {
                                    boolean bl = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    object4 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }
        }));
    }

    private final void conferenceRequest(Route $this$conferenceRequest) {
        if (RestConfig.config.getEnableConferenceRequest()) {
            RoutingBuilderKt.options((Route)$this$conferenceRequest, (String)"/conference-request/v1", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            KType kType;
                            void $this$respond$iv;
                            ResultKt.throwOnFailure((Object)object);
                            RoutingContext $this$options = (RoutingContext)this.L$0;
                            ApplicationCall applicationCall = (ApplicationCall)$this$options.getCall();
                            HttpStatusCode message$iv = HttpStatusCode.Companion.getOK();
                            boolean $i$f$respond = false;
                            HttpStatusCode httpStatusCode = message$iv;
                            void var7_9 = $this$respond$iv;
                            boolean $i$f$typeInfo = false;
                            KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                            boolean $i$f$typeOfOrNull = false;
                            try {
                                kType = Reflection.typeOf(HttpStatusCode.class);
                            }
                            catch (Throwable throwable) {
                                kType = null;
                            }
                            KType kType2 = kType;
                            KClass kClass2 = kClass;
                            TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                            this.label = 1;
                            Object object3 = var7_9.respond((Object)httpStatusCode, typeInfo, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$respond = false;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            RoutingBuilderKt.post((Route)$this$conferenceRequest, (String)"/conference-request/v1", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Application this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$post = (RoutingContext)this.L$0;
                            $this$receive$iv = (ApplicationCall)$this$post.getCall();
                            $i$f$receive = false;
                            var6_8 = $this$receive$iv;
                            $i$f$typeInfo = false;
                            var8_13 = Reflection.getOrCreateKotlinClass(ConferenceRequest.class);
                            $i$f$typeOfOrNull = false;
                            try {
                                var10_18 = Reflection.typeOf(ConferenceRequest.class);
                            }
                            catch (Throwable var11_19) {
                                var10_18 = null;
                            }
                            var12_22 = var10_18;
                            var13_23 = var8_13;
                            this.L$0 = $this$post;
                            this.label = 1;
                            v0 = var6_8.receiveNullable(new TypeInfo(var13_23, var12_22), (Continuation)this);
                            ** if (v0 != var19_2) goto lbl28
lbl27:
                            // 1 sources

                            return var19_2;
lbl28:
                            // 1 sources

                            ** GOTO lbl36
                        }
                        case 1: {
                            $i$f$receive = false;
                            $this$post = (RoutingContext)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl36:
                                // 2 sources

                                if (v0 == null) {
                                    $i$f$typeInfo = false;
                                    var8_13 = Reflection.getOrCreateKotlinClass(ConferenceRequest.class);
                                    $i$f$typeOfOrNull = false;
                                    try {
                                        var10_18 = Reflection.typeOf(ConferenceRequest.class);
                                    }
                                    catch (Throwable var11_20) {
                                        var10_18 = null;
                                    }
                                    var12_22 = var10_18;
                                    var13_23 = var8_13;
                                    v1 = new TypeInfo(var13_23, var12_22).getKotlinType();
                                    Intrinsics.checkNotNull((Object)v1);
                                    var17_25 = v1;
                                    throw new CannotTransformContentToTypeException(var17_25);
                                }
                                $this$receive$iv = (ConferenceRequest)v0;
                            }
                            catch (Exception e) {
                                throw new BadRequest(e.getMessage());
                            }
                            request = $this$receive$iv;
                            token = ApplicationKt.access$getToken($this$post.getCall().getRequest());
                            try {
                                var6_8 = Application.access$getConferenceIqHandler$p(this.this$0).handleConferenceIq(request.toConferenceIq(token));
                            }
                            catch (XmppStringprepException e) {
                                throw new BadRequest("Invalid room name: " + e.getMessage());
                            }
                            catch (Exception e) {
                                Application.access$getLogger$p(this.this$0).error((Object)e.getMessage(), (Throwable)e);
                                throw new BadRequest(e.getMessage());
                            }
                            response = var6_8;
                            v2 = response.getError();
                            if (v2 != null) {
                                it = v2;
                                $i$a$-let-Application$conferenceRequest$2$1 = false;
                                v3 = it.getCondition();
                                switch (v3 == null ? -1 : conferenceRequest.WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                                    case 1: {
                                        v4 = new Forbidden(null, 1, null);
                                        break;
                                    }
                                    case 2: {
                                        v4 = new BadRequest("invalid-session");
                                        break;
                                    }
                                    default: {
                                        v4 = new BadRequest(it.toString());
                                    }
                                }
                                throw v4;
                            }
                            if (!(response instanceof ConferenceIq)) {
                                throw new InternalError();
                            }
                            var6_8 = (ApplicationCall)$this$post.getCall();
                            message$iv = ConferenceRequest.Companion.fromConferenceIq((ConferenceIq)response);
                            $i$f$respond = false;
                            var9_17 = message$iv;
                            var10_18 = $this$respond$iv;
                            $i$f$typeInfo = false;
                            var12_22 = Reflection.getOrCreateKotlinClass(ConferenceRequest.class);
                            $i$f$typeOfOrNull = false;
                            try {
                                var14_28 = Reflection.typeOf(ConferenceRequest.class);
                            }
                            catch (Throwable var15_29) {
                                var14_28 = null;
                            }
                            var16_30 = var14_28;
                            var17_26 = var12_22;
                            var18_31 = new TypeInfo((KClass)var17_26, var16_30);
                            this.L$0 = null;
                            this.label = 2;
                            v5 = var10_18.respond((Object)var9_17, var18_31, (Continuation)this);
                            if (v5 == var19_2) {
                                return var19_2;
                            }
                            ** GOTO lbl114
                        }
                        case 2: {
                            $i$f$respond = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl114:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final void rtcstats(Route $this$rtcstats) {
        RoutingBuilderKt.get((Route)$this$rtcstats, (String)"/rtcstats", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Application this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        RoutingContext $this$get = (RoutingContext)this.L$0;
                        JSONObject rtcstats2 = new JSONObject();
                        Iterable $this$forEach$iv = Application.access$getConferenceStore$p(this.this$0).getAllConferences();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String meetingId;
                            JitsiMeetConference conference = (JitsiMeetConference)element$iv;
                            boolean bl = false;
                            if (!conference.includeInStatistics() || !conference.isRtcStatsEnabled()) continue;
                            if (conference.getMeetingId() == null) continue;
                            boolean bl2 = false;
                            rtcstats2.put((Object)meetingId, (Object)conference.getRtcstatsState());
                        }
                        this.label = 1;
                        Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), rtcstats2, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void moveEndpoints(Route $this$moveEndpoints) {
        if (RestConfig.config.getEnableMoveEndpoints()) {
            RoutingBuilderKt.route((Route)$this$moveEndpoints, (String)"/move-endpoints", (Function1)((Function1)new Function1<Route, Unit>(this){
                final /* synthetic */ Application this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Route $this$route) {
                    Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
                    RoutingBuilderKt.get((Route)$this$route, (String)"move-endpoint", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    KType kType;
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    ApplicationCall $this$respond$iv = (ApplicationCall)$this$get.getCall();
                                    MoveResult message$iv = ApplicationKt.access$translateException((Function0)new Function0<MoveResult>(this.this$0, $this$get){
                                        final /* synthetic */ Application this$0;
                                        final /* synthetic */ RoutingContext $$this$get;
                                        {
                                            this.this$0 = $receiver;
                                            this.$$this$get = $$this$get;
                                            super(0);
                                        }

                                        @NotNull
                                        public final MoveResult invoke() {
                                            return Application.access$getLoadRedistributor$p(this.this$0).moveEndpoint(this.$$this$get.getCall().getRequest().getQueryParameters().get("conference"), this.$$this$get.getCall().getRequest().getQueryParameters().get("endpoint"), this.$$this$get.getCall().getRequest().getQueryParameters().get("bridge"));
                                        }
                                    });
                                    boolean $i$f$respond = false;
                                    MoveResult moveResult = message$iv;
                                    ApplicationCall applicationCall = $this$respond$iv;
                                    boolean $i$f$typeInfo = false;
                                    KClass kClass = Reflection.getOrCreateKotlinClass(MoveResult.class);
                                    boolean $i$f$typeOfOrNull = false;
                                    try {
                                        kType = Reflection.typeOf(MoveResult.class);
                                    }
                                    catch (Throwable throwable) {
                                        kType = null;
                                    }
                                    KType kType2 = kType;
                                    KClass kClass2 = kClass;
                                    TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                                    this.label = 1;
                                    Object object3 = applicationCall.respond((Object)moveResult, typeInfo, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    boolean $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.get((Route)$this$route, (String)"move-endpoints", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    KType kType;
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    ApplicationCall $this$respond$iv = (ApplicationCall)$this$get.getCall();
                                    MoveResult message$iv = ApplicationKt.access$translateException((Function0)new Function0<MoveResult>(this.this$0, $this$get){
                                        final /* synthetic */ Application this$0;
                                        final /* synthetic */ RoutingContext $$this$get;
                                        {
                                            this.this$0 = $receiver;
                                            this.$$this$get = $$this$get;
                                            super(0);
                                        }

                                        @NotNull
                                        public final MoveResult invoke() {
                                            String string = this.$$this$get.getCall().getRequest().getQueryParameters().get("numEndpoints");
                                            return Application.access$getLoadRedistributor$p(this.this$0).moveEndpoints(this.$$this$get.getCall().getRequest().getQueryParameters().get("bridge"), this.$$this$get.getCall().getRequest().getQueryParameters().get("conference"), string != null ? Integer.parseInt(string) : 1);
                                        }
                                    });
                                    boolean $i$f$respond = false;
                                    MoveResult moveResult = message$iv;
                                    ApplicationCall applicationCall = $this$respond$iv;
                                    boolean $i$f$typeInfo = false;
                                    KClass kClass = Reflection.getOrCreateKotlinClass(MoveResult.class);
                                    boolean $i$f$typeOfOrNull = false;
                                    try {
                                        kType = Reflection.typeOf(MoveResult.class);
                                    }
                                    catch (Throwable throwable) {
                                        kType = null;
                                    }
                                    KType kType2 = kType;
                                    KClass kClass2 = kClass;
                                    TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                                    this.label = 1;
                                    Object object3 = applicationCall.respond((Object)moveResult, typeInfo, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    boolean $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.get((Route)$this$route, (String)"move-fraction", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    KType kType;
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    ApplicationCall $this$respond$iv = (ApplicationCall)$this$get.getCall();
                                    MoveResult message$iv = ApplicationKt.access$translateException((Function0)new Function0<MoveResult>(this.this$0, $this$get){
                                        final /* synthetic */ Application this$0;
                                        final /* synthetic */ RoutingContext $$this$get;
                                        {
                                            this.this$0 = $receiver;
                                            this.$$this$get = $$this$get;
                                            super(0);
                                        }

                                        @NotNull
                                        public final MoveResult invoke() {
                                            String string = this.$$this$get.getCall().getRequest().getQueryParameters().get("fraction");
                                            return Application.access$getLoadRedistributor$p(this.this$0).moveFraction(this.$$this$get.getCall().getRequest().getQueryParameters().get("bridge"), string != null ? Double.parseDouble(string) : 0.1);
                                        }
                                    });
                                    boolean $i$f$respond = false;
                                    MoveResult moveResult = message$iv;
                                    ApplicationCall applicationCall = $this$respond$iv;
                                    boolean $i$f$typeInfo = false;
                                    KClass kClass = Reflection.getOrCreateKotlinClass(MoveResult.class);
                                    boolean $i$f$typeOfOrNull = false;
                                    try {
                                        kType = Reflection.typeOf(MoveResult.class);
                                    }
                                    catch (Throwable throwable) {
                                        kType = null;
                                    }
                                    KType kType2 = kType;
                                    KClass kClass2 = kClass;
                                    TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                                    this.label = 1;
                                    Object object3 = applicationCall.respond((Object)moveResult, typeInfo, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    boolean $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }));
        }
    }

    private final void debug(Route $this$debug) {
        if (RestConfig.config.getEnableDebug()) {
            RoutingBuilderKt.route((Route)$this$debug, (String)"/debug", (Function1)((Function1)new Function1<Route, Unit>(this){
                final /* synthetic */ Application this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Route $this$route) {
                    Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
                    RoutingBuilderKt.get((Route)$this$route, (String)"", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    this.label = 1;
                                    Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), (OrderedJsonObject)Application.access$getGetDebugState$p(this.this$0).invoke((Object)Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)$this$get.getCall().getRequest().getQueryParameters().get("full"), (Object)"true")), null), (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.get((Route)$this$route, (String)"conferences", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    JSONArray jSONArray = new JSONArray();
                                    Application application = this.this$0;
                                    JSONArray $this$invokeSuspend_u24lambda_u241 = jSONArray;
                                    boolean bl = false;
                                    Iterable $this$forEach$iv = Application.access$getConferenceStore$p(application).getAllConferences();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        JitsiMeetConference it = (JitsiMeetConference)element$iv;
                                        boolean bl2 = false;
                                        $this$invokeSuspend_u24lambda_u241.add((Object)it.getRoomName().toString());
                                    }
                                    JSONArray conferencesJson = jSONArray;
                                    this.label = 1;
                                    Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), conferencesJson, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.get((Route)$this$route, (String)"conferences-full", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    JSONObject jSONObject = new JSONObject();
                                    Application application = this.this$0;
                                    JSONObject $this$invokeSuspend_u24lambda_u241 = jSONObject;
                                    boolean bl = false;
                                    Iterable $this$forEach$iv = Application.access$getConferenceStore$p(application).getAllConferences();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        JitsiMeetConference it = (JitsiMeetConference)element$iv;
                                        boolean bl2 = false;
                                        $this$invokeSuspend_u24lambda_u241.put((Object)it.getRoomName().toString(), (Object)it.getDebugState());
                                    }
                                    JSONObject conferencesJson = jSONObject;
                                    this.label = 1;
                                    Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), conferencesJson, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.get((Route)$this$route, (String)"/conference/{conference}", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    EntityBareJid entityBareJid;
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    String string = $this$get.getCall().getParameters().get("conference");
                                    if (string == null) {
                                        throw new MissingParameter("conference");
                                    }
                                    String conference = string;
                                    try {
                                        entityBareJid = JidCreate.entityBareFrom((String)conference);
                                    }
                                    catch (Exception exception) {
                                        throw new BadRequest("Invalid conference ID");
                                    }
                                    EntityBareJid conferenceJid = entityBareJid;
                                    this.label = 1;
                                    Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), (OrderedJsonObject)Application.access$getGetDebugState$p(this.this$0).invoke((Object)Boxing.boxBoolean((boolean)true), (Object)conferenceJid), (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.get((Route)$this$route, (String)"xmpp-caps", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(null){
                        int label;
                        private /* synthetic */ Object L$0;

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    this.label = 1;
                                    Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), XmppCapsStats.Companion.getStats(), (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }));
        }
    }

    private final void pin(Route $this$pin) {
        if (RestConfig.config.getPinEnabled()) {
            RoutingBuilderKt.route((Route)$this$pin, (String)"/pin", (Function1)((Function1)new Function1<Route, Unit>(this){
                final /* synthetic */ Application this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Route $this$route) {
                    Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
                    RoutingBuilderKt.get((Route)$this$route, (String)"", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    KType kType;
                                    void $this$respond$iv;
                                    ResultKt.throwOnFailure((Object)object);
                                    RoutingContext $this$get = (RoutingContext)this.L$0;
                                    ApplicationCall applicationCall = (ApplicationCall)$this$get.getCall();
                                    List<PinnedConference> message$iv = Application.access$getConferenceStore$p(this.this$0).getPinnedConferences();
                                    boolean $i$f$respond = false;
                                    List<PinnedConference> list = message$iv;
                                    void var7_9 = $this$respond$iv;
                                    boolean $i$f$typeInfo = false;
                                    KClass kClass = Reflection.getOrCreateKotlinClass(List.class);
                                    boolean $i$f$typeOfOrNull = false;
                                    try {
                                        kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(PinnedConference.class)));
                                    }
                                    catch (Throwable throwable) {
                                        kType = null;
                                    }
                                    KType kType2 = kType;
                                    KClass kClass2 = kClass;
                                    TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                                    this.label = 1;
                                    Object object3 = var7_9.respond(list, typeInfo, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    boolean $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.post((Route)$this$route, (String)"", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$post = (RoutingContext)this.L$0;
                                    $this$receive$iv = (ApplicationCall)$this$post.getCall();
                                    $i$f$receive = false;
                                    var6_8 = $this$receive$iv;
                                    $i$f$typeInfo = false;
                                    var8_12 = Reflection.getOrCreateKotlinClass(pin.PinJson.class);
                                    $i$f$typeOfOrNull = false;
                                    try {
                                        var10_15 = Reflection.typeOf(pin.PinJson.class);
                                    }
                                    catch (Throwable var11_17) {
                                        var10_15 = null;
                                    }
                                    var12_20 = var10_15;
                                    var13_22 = var8_12;
                                    this.L$0 = $this$post;
                                    this.label = 1;
                                    v0 = var6_8.receiveNullable(new TypeInfo(var13_22, var12_20), (Continuation)this);
                                    ** if (v0 != var18_2) goto lbl28
lbl27:
                                    // 1 sources

                                    return var18_2;
lbl28:
                                    // 1 sources

                                    ** GOTO lbl36
                                }
                                case 1: {
                                    $i$f$receive = false;
                                    $this$post = (RoutingContext)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl36:
                                        // 2 sources

                                        if (v0 == null) {
                                            $i$f$typeInfo = false;
                                            var8_12 = Reflection.getOrCreateKotlinClass(pin.PinJson.class);
                                            $i$f$typeOfOrNull = false;
                                            try {
                                                var10_15 = Reflection.typeOf(pin.PinJson.class);
                                            }
                                            catch (Throwable var11_18) {
                                                var10_15 = null;
                                            }
                                            var12_20 = var10_15;
                                            var13_22 = var8_12;
                                            v1 = new TypeInfo(var13_22, var12_20).getKotlinType();
                                            Intrinsics.checkNotNull((Object)v1);
                                            var17_23 = v1;
                                            throw new CannotTransformContentToTypeException(var17_23);
                                        }
                                        $this$receive$iv = (pin.PinJson)v0;
                                    }
                                    catch (Exception e) {
                                        throw new BadRequest(e.getMessage());
                                    }
                                    pin = $this$receive$iv;
                                    try {
                                        e /* !! */  = JidCreate.entityBareFrom((String)pin.getConferenceId());
                                    }
                                    catch (Exception var6_9) {
                                        throw new BadRequest("Invalid conference ID");
                                    }
                                    conferenceJid = e /* !! */ ;
                                    v2 = Application.access$getConferenceStore$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)conferenceJid);
                                    v3 = pin.getJvbVersion();
                                    e /* !! */  = Duration.ofMinutes(pin.getDurationMinutes());
                                    Intrinsics.checkNotNullExpressionValue((Object)e /* !! */ , (String)"ofMinutes(...)");
                                    v2.pinConference(conferenceJid, v3, (Duration)e /* !! */ );
                                    e /* !! */  = (ApplicationCall)$this$post.getCall();
                                    message$iv = HttpStatusCode.Companion.getOK();
                                    $i$f$respond = false;
                                    var8_12 = message$iv;
                                    var9_14 = $this$respond$iv;
                                    $i$f$typeInfo = false;
                                    var11_19 = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                                    $i$f$typeOfOrNull = false;
                                    try {
                                        var13_22 = Reflection.typeOf(HttpStatusCode.class);
                                    }
                                    catch (Throwable var14_26) {
                                        var13_22 = null;
                                    }
                                    var15_27 = var13_22;
                                    var16_28 = var11_19;
                                    var17_24 = new TypeInfo(var16_28, (KType)var15_27);
                                    this.L$0 = null;
                                    this.label = 2;
                                    v4 = var9_14.respond((Object)var8_12, var17_24, (Continuation)this);
                                    if (v4 == var18_2) {
                                        return var18_2;
                                    }
                                    ** GOTO lbl99
                                }
                                case 2: {
                                    $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v4 = $result;
lbl99:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    RoutingBuilderKt.post((Route)$this$route, (String)"/remove", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Application this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$post = (RoutingContext)this.L$0;
                                    $this$receive$iv = (ApplicationCall)$this$post.getCall();
                                    $i$f$receive = false;
                                    var6_7 = $this$receive$iv;
                                    $i$f$typeInfo = false;
                                    var8_11 = Reflection.getOrCreateKotlinClass(pin.UnpinJson.class);
                                    $i$f$typeOfOrNull = false;
                                    try {
                                        var10_14 = Reflection.typeOf(pin.UnpinJson.class);
                                    }
                                    catch (Throwable var11_16) {
                                        var10_14 = null;
                                    }
                                    var12_19 = var10_14;
                                    var13_21 = var8_11;
                                    this.L$0 = $this$post;
                                    this.label = 1;
                                    v0 = var6_7.receiveNullable(new TypeInfo(var13_21, var12_19), (Continuation)this);
                                    if (v0 == var18_2) {
                                        return var18_2;
                                    }
                                    ** GOTO lbl32
                                }
                                case 1: {
                                    $i$f$receive = false;
                                    $this$post = (RoutingContext)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl32:
                                    // 2 sources

                                    if (v0 == null) {
                                        $i$f$typeInfo = false;
                                        var8_11 = Reflection.getOrCreateKotlinClass(pin.UnpinJson.class);
                                        $i$f$typeOfOrNull = false;
                                        try {
                                            var10_14 = Reflection.typeOf(pin.UnpinJson.class);
                                        }
                                        catch (Throwable var11_17) {
                                            var10_14 = null;
                                        }
                                        var12_19 = var10_14;
                                        var13_21 = var8_11;
                                        v1 = new TypeInfo(var13_21, var12_19).getKotlinType();
                                        Intrinsics.checkNotNull((Object)v1);
                                        var17_22 = v1;
                                        throw new CannotTransformContentToTypeException(var17_22);
                                    }
                                    unpin = (pin.UnpinJson)v0;
                                    try {
                                        $i$f$receive = JidCreate.entityBareFrom((String)unpin.getConferenceId());
                                    }
                                    catch (Exception var6_8) {
                                        throw new BadRequest("Invalid conference ID");
                                    }
                                    conferenceJid = $i$f$receive;
                                    v2 = Application.access$getConferenceStore$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)conferenceJid);
                                    v2.unpinConference(conferenceJid);
                                    $i$f$receive = (ApplicationCall)$this$post.getCall();
                                    message$iv = HttpStatusCode.Companion.getOK();
                                    $i$f$respond = false;
                                    var8_11 = message$iv;
                                    var9_13 = $this$respond$iv;
                                    $i$f$typeInfo = false;
                                    var11_18 = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                                    $i$f$typeOfOrNull = false;
                                    try {
                                        var13_21 = Reflection.typeOf(HttpStatusCode.class);
                                    }
                                    catch (Throwable var14_25) {
                                        var13_21 = null;
                                    }
                                    var15_26 = var13_21;
                                    var16_27 = var11_18;
                                    var17_23 = new TypeInfo(var16_27, (KType)var15_26);
                                    this.L$0 = null;
                                    this.label = 2;
                                    v3 = var9_13.respond((Object)var8_11, var17_23, (Continuation)this);
                                    if (v3 == var18_2) {
                                        return var18_2;
                                    }
                                    ** GOTO lbl88
                                }
                                case 2: {
                                    $i$f$respond = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl88:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }));
        }
    }

    private final void stats(Route $this$stats) {
        RoutingBuilderKt.get((Route)$this$stats, (String)"/stats", (Function2)((Function2)new Function2<RoutingContext, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Application this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        RoutingContext $this$get = (RoutingContext)this.L$0;
                        this.label = 1;
                        Object object3 = ApplicationKt.access$respondJson($this$get.getCall(), (OrderedJsonObject)Application.access$getGetStatsJson$p(this.this$0).invoke(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull RoutingContext p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ void access$about(Application $this, Route $receiver) {
        $this.about($receiver);
    }

    public static final /* synthetic */ void access$conferenceRequest(Application $this, Route $receiver) {
        $this.conferenceRequest($receiver);
    }

    public static final /* synthetic */ void access$debug(Application $this, Route $receiver) {
        $this.debug($receiver);
    }

    public static final /* synthetic */ void access$metrics(Application $this, Route $receiver) {
        $this.metrics($receiver);
    }

    public static final /* synthetic */ void access$moveEndpoints(Application $this, Route $receiver) {
        $this.moveEndpoints($receiver);
    }

    public static final /* synthetic */ void access$pin(Application $this, Route $receiver) {
        $this.pin($receiver);
    }

    public static final /* synthetic */ void access$rtcstats(Application $this, Route $receiver) {
        $this.rtcstats($receiver);
    }

    public static final /* synthetic */ void access$stats(Application $this, Route $receiver) {
        $this.stats($receiver);
    }

    public static final /* synthetic */ HealthCheckService access$getHealthChecker$p(Application $this) {
        return $this.healthChecker;
    }

    public static final /* synthetic */ ConferenceIqHandler access$getConferenceIqHandler$p(Application $this) {
        return $this.conferenceIqHandler;
    }

    public static final /* synthetic */ Logger access$getLogger$p(Application $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ConferenceStore access$getConferenceStore$p(Application $this) {
        return $this.conferenceStore;
    }

    public static final /* synthetic */ LoadRedistributor access$getLoadRedistributor$p(Application $this) {
        return $this.loadRedistributor;
    }

    public static final /* synthetic */ Function2 access$getGetDebugState$p(Application $this) {
        return $this.getDebugState;
    }

    public static final /* synthetic */ Function0 access$getGetStatsJson$p(Application $this) {
        return $this.getStatsJson;
    }
}

