/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.CheckIn;
import io.sentry.CheckInStatus;
import io.sentry.DateUtils;
import io.sentry.IHub;
import io.sentry.MonitorConfig;
import io.sentry.Sentry;
import io.sentry.protocol.SentryId;
import io.sentry.util.TracingUtils;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class CheckInUtils {
    public static <U> U withCheckIn(@NotNull String monitorSlug, @Nullable MonitorConfig monitorConfig, @NotNull Callable<U> callable) throws Exception {
        CheckInStatus status;
        U u;
        @NotNull IHub hub = Sentry.getCurrentHub();
        long startTime = System.currentTimeMillis();
        boolean didError = false;
        hub.pushScope();
        TracingUtils.startNewTrace(hub);
        CheckIn inProgressCheckIn = new CheckIn(monitorSlug, CheckInStatus.IN_PROGRESS);
        if (monitorConfig != null) {
            inProgressCheckIn.setMonitorConfig(monitorConfig);
        }
        @Nullable SentryId checkInId = hub.captureCheckIn(inProgressCheckIn);
        try {
            u = callable.call();
            status = didError ? CheckInStatus.ERROR : CheckInStatus.OK;
        }
        catch (Throwable t) {
            try {
                didError = true;
                throw t;
            }
            catch (Throwable throwable) {
                @NotNull CheckInStatus status2 = didError ? CheckInStatus.ERROR : CheckInStatus.OK;
                CheckIn checkIn = new CheckIn(checkInId, monitorSlug, status2);
                checkIn.setDuration(DateUtils.millisToSeconds(System.currentTimeMillis() - startTime));
                hub.captureCheckIn(checkIn);
                hub.popScope();
                throw throwable;
            }
        }
        CheckIn checkIn = new CheckIn(checkInId, monitorSlug, status);
        checkIn.setDuration(DateUtils.millisToSeconds(System.currentTimeMillis() - startTime));
        hub.captureCheckIn(checkIn);
        hub.popScope();
        return u;
    }

    public static <U> U withCheckIn(@NotNull String monitorSlug, @NotNull Callable<U> callable) throws Exception {
        return CheckInUtils.withCheckIn(monitorSlug, null, callable);
    }

    @ApiStatus.Internal
    public static boolean isIgnored(@Nullable List<String> ignoredSlugs, @NotNull String slug) {
        if (ignoredSlugs == null || ignoredSlugs.isEmpty()) {
            return false;
        }
        for (String ignoredSlug : ignoredSlugs) {
            if (ignoredSlug.equalsIgnoreCase(slug)) {
                return true;
            }
            try {
                if (!slug.matches(ignoredSlug)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }
}

