/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtp.BlockHeader;
import org.jitsi.rtp.rtp.PrimaryBlockHeader;
import org.jitsi.rtp.rtp.RedundancyBlockHeader;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.RtpSequenceNumberKt;
import org.jitsi.rtp.util.BufferPool;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B'\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/rtp/rtp/RedPacketParser;", "PacketType", "Lorg/jitsi/rtp/rtp/RtpPacket;", "", "createPacket", "Lkotlin/Function3;", "", "", "<init>", "(Lkotlin/jvm/functions/Function3;)V", "getCreatePacket", "()Lkotlin/jvm/functions/Function3;", "decapsulate", "", "rtpPacket", "parseRedundancy", "", "rtp"})
public final class RedPacketParser<PacketType extends RtpPacket> {
    @NotNull
    private final Function3<byte[], Integer, Integer, PacketType> createPacket;

    public RedPacketParser(@NotNull Function3<? super byte[], ? super Integer, ? super Integer, ? extends PacketType> createPacket) {
        Intrinsics.checkNotNullParameter(createPacket, (String)"createPacket");
        this.createPacket = createPacket;
    }

    @NotNull
    public final Function3<byte[], Integer, Integer, PacketType> getCreatePacket() {
        return this.createPacket;
    }

    @NotNull
    public final List<PacketType> decapsulate(@NotNull RtpPacket rtpPacket, boolean parseRedundancy) {
        Object object;
        BlockHeader blockHeader;
        Intrinsics.checkNotNullParameter((Object)rtpPacket, (String)"rtpPacket");
        RtpPacket $this$decapsulate_u24lambda_u240 = rtpPacket;
        boolean bl = false;
        int currentOffset = $this$decapsulate_u24lambda_u240.getPayloadOffset();
        List redundancyBlockHeaders = new ArrayList();
        PrimaryBlockHeader primaryBlockHeader = null;
        do {
            if (currentOffset >= $this$decapsulate_u24lambda_u240.offset + $this$decapsulate_u24lambda_u240.length) {
                throw new IllegalArgumentException("Invalid RED packet: no last header block found within the allowed length.");
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$decapsulate_u24lambda_u240.buffer, (String)"buffer");
            blockHeader = BlockHeader.Companion.parse($this$decapsulate_u24lambda_u240.buffer, currentOffset);
            object = blockHeader;
            if (object instanceof PrimaryBlockHeader) {
                primaryBlockHeader = (PrimaryBlockHeader)blockHeader;
            } else if (object instanceof RedundancyBlockHeader) {
                redundancyBlockHeaders.add(blockHeader);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            currentOffset += blockHeader.getHeaderLength();
        } while (blockHeader instanceof RedundancyBlockHeader);
        List packets = parseRedundancy ? (List)new ArrayList() : null;
        object = ((Iterable)redundancyBlockHeaders).iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            RedundancyBlockHeader it = (RedundancyBlockHeader)object.next();
            int blockLength = it.getLength();
            if (currentOffset + blockLength > $this$decapsulate_u24lambda_u240.offset + $this$decapsulate_u24lambda_u240.length) {
                throw new IllegalArgumentException("Invalid RED packet: blocks extend past the packet length.");
            }
            if (parseRedundancy) {
                byte[] byteArray = (byte[])BufferPool.Companion.getGetArray().invoke((Object)(22 + blockLength + 20));
                System.arraycopy($this$decapsulate_u24lambda_u240.buffer, $this$decapsulate_u24lambda_u240.offset, byteArray, 10, 12);
                RtpHeader.Companion.setCsrcCount(byteArray, 10, 0);
                RtpHeader.Companion.setHasExtensions(byteArray, 10, false);
                System.arraycopy($this$decapsulate_u24lambda_u240.buffer, currentOffset, byteArray, 22, blockLength);
                Object object2 = this.createPacket.invoke((Object)byteArray, (Object)10, (Object)(12 + blockLength));
                RtpPacket $this$decapsulate_u24lambda_u240_u240 = (RtpPacket)object2;
                boolean bl2 = false;
                $this$decapsulate_u24lambda_u240_u240.setPayloadType(it.getPt());
                $this$decapsulate_u24lambda_u240_u240.setTimestamp($this$decapsulate_u24lambda_u240_u240.getTimestamp() - (long)it.getTimestampOffset());
                $this$decapsulate_u24lambda_u240_u240.setSequenceNumber(RtpSequenceNumberKt.toRtpSequenceNumber($this$decapsulate_u24lambda_u240_u240.getSequenceNumber() - (redundancyBlockHeaders.size() - index)));
                RtpPacket redundancyPacket = (RtpPacket)object2;
                List list = packets;
                if (list != null) {
                    list.add(redundancyPacket);
                }
            }
            currentOffset += blockLength;
        }
        int headerLength = $this$decapsulate_u24lambda_u240.getHeaderLength();
        int newOffset = currentOffset - headerLength;
        int newLength = $this$decapsulate_u24lambda_u240.length - currentOffset + $this$decapsulate_u24lambda_u240.offset + headerLength;
        System.arraycopy($this$decapsulate_u24lambda_u240.buffer, $this$decapsulate_u24lambda_u240.offset, $this$decapsulate_u24lambda_u240.buffer, newOffset, headerLength);
        $this$decapsulate_u24lambda_u240.offset = newOffset;
        $this$decapsulate_u24lambda_u240.length = newLength;
        PrimaryBlockHeader primaryBlockHeader2 = primaryBlockHeader;
        if (primaryBlockHeader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"primaryBlockHeader");
            primaryBlockHeader2 = null;
        }
        $this$decapsulate_u24lambda_u240.setPayloadType(primaryBlockHeader2.getPt());
        List list = packets;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

